 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_FILE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_FILE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Async

template <typename TSpec > struct Async;       	// "projects/library/seqan/file/file_base.h"(58)

//____________________________________________________________________________
// Chained

template <__int64 _FileSize , typename TFile > struct Chained;       	// "projects/library/seqan/file/file_base.h"(90)

//____________________________________________________________________________
// ChunkLength

template <typename T> struct ChunkLength;       	// "projects/library/seqan/file/chunk_collector.h"(41)

//____________________________________________________________________________
// DefaultOpenMode

template <typename T> struct DefaultOpenMode;       	// "projects/library/seqan/file/file_base.h"(122)

//____________________________________________________________________________
// DefaultOpenTempMode

template <typename T> struct DefaultOpenTempMode;       	// "projects/library/seqan/file/file_base.h"(127)

//____________________________________________________________________________
// Dynamic

template <typename TSpec > struct Dynamic;       	// "projects/library/seqan/file/file_page.h"(224)

//____________________________________________________________________________
// ExtStringConstIterator

template <typename TExtString > struct ExtStringConstIterator;       	// "projects/library/seqan/file/string_external.h"(267)

//____________________________________________________________________________
// ExtStringFwdConstIterator

template <typename TExtString > struct ExtStringFwdConstIterator;       	// "projects/library/seqan/file/string_external.h"(601)

//____________________________________________________________________________
// ExtStringFwdIterator

template <typename TExtString > struct ExtStringFwdIterator;       	// "projects/library/seqan/file/string_external.h"(370)

//____________________________________________________________________________
// ExtStringIterator

template <typename TExtString > struct ExtStringIterator;       	// "projects/library/seqan/file/string_external.h"(165)

//____________________________________________________________________________
// External

template <typename TConfig > struct External;       	// "projects/library/seqan/file/string_external.h"(158)

//____________________________________________________________________________
// ExternalConfig

template <typename _TFile , unsigned _PAGE_SIZE , unsigned _FRAMES > struct ExternalConfig;       	// "projects/library/seqan/file/string_external.h"(83)

//____________________________________________________________________________
// ExternalConfigLarge

template <typename _TFile , unsigned _PAGE_SIZE , unsigned _FRAMES > struct ExternalConfigLarge;       	// "projects/library/seqan/file/string_external.h"(118)

//____________________________________________________________________________
// ExternalConfigSize

template <typename _TSize, typename _TFile , unsigned _PAGE_SIZE , unsigned _FRAMES > struct ExternalConfigSize;       	// "projects/library/seqan/file/string_external.h"(150)

//____________________________________________________________________________
// File

template <typename TSpec > class File;       	// "projects/library/seqan/file/file_base.h"(71)

//____________________________________________________________________________
// FileFormat

template <typename TFile, typename TData, typename TMeta, typename TFormat > struct FileFormat;       	// "projects/library/seqan/file/file_format.h"(60)

//____________________________________________________________________________
// FileReader

template <typename TFormat, typename TFile, typename TSpec> struct FileReader;       	// "projects/library/seqan/file/file_filereader.h"(28)

//____________________________________________________________________________
// FileReaderIterator

struct FileReaderIterator;       	// "projects/library/seqan/file/file_filereader.h"(411)

//____________________________________________________________________________
// Fixed

template <unsigned _PageSize > struct Fixed;       	// "projects/library/seqan/file/file_page.h"(254)

//____________________________________________________________________________
// MMap

template <typename TConfig > struct MMap;       	// "projects/library/seqan/file/string_mmap.h"(31)

//____________________________________________________________________________
// PageBucket

template <typename TValue > struct PageBucket;       	// "projects/library/seqan/file/file_page.h"(156)

//____________________________________________________________________________
// PageBucketExtended

template <typename TValue > struct PageBucketExtended;       	// "projects/library/seqan/file/file_page.h"(164)

//____________________________________________________________________________
// PageChain

template <typename TPageFrame > struct PageChain;       	// "projects/library/seqan/file/file_page.h"(570)

//____________________________________________________________________________
// PageContainer

template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > struct PageContainer;       	// "projects/library/seqan/file/file_page.h"(709)

//____________________________________________________________________________
// PageFrame

template <typename TValue, typename TFile, typename TSpec > struct PageFrame;       	// "projects/library/seqan/file/file_page.h"(195)

//____________________________________________________________________________
// Row

template <typename T> struct Row;       	// "projects/library/seqan/file/file_format_fasta_align.h"(33)

//____________________________________________________________________________
// Rows

template <typename T> struct Rows;       	// "projects/library/seqan/file/file_format_fasta_align.h"(36)

//____________________________________________________________________________
// SAMFileMeta

class SAMFileMeta;       	// "projects/library/seqan/file/file_format_sam.h"(63)

//____________________________________________________________________________
// SAMMeta

class SAMMeta;       	// "projects/library/seqan/file/file_format_sam.h"(72)

//____________________________________________________________________________
// SimpleBuffer

template <typename TValue > struct SimpleBuffer;       	// "projects/library/seqan/file/file_page.h"(36)

//____________________________________________________________________________
// Striped

template <unsigned _FileCount , typename TFile > struct Striped;       	// "projects/library/seqan/file/file_base.h"(107)

//____________________________________________________________________________
// Sync

template <typename TSpec > struct Sync;       	// "projects/library/seqan/file/file_base.h"(47)

//____________________________________________________________________________
// TagCGViz_

struct TagCGViz_;       	// "projects/library/seqan/file/file_format_cgviz.h"(36)

//____________________________________________________________________________
// TagEmbl_

struct TagEmbl_;       	// "projects/library/seqan/file/file_format_embl.h"(34)

//____________________________________________________________________________
// TagFastaAlign_

struct TagFastaAlign_;       	// "projects/library/seqan/file/file_format_fasta_align.h"(44)

//____________________________________________________________________________
// TagFasta_

struct TagFasta_;       	// "projects/library/seqan/file/file_format_fasta.h"(35)

//____________________________________________________________________________
// TagGenbank_

struct TagGenbank_;       	// "projects/library/seqan/file/file_format_genbank.h"(35)

//____________________________________________________________________________
// TagRaw_

struct TagRaw_;       	// "projects/library/seqan/file/file_format_raw.h"(37)

//____________________________________________________________________________
// TagSBAM_

template <typename TSpec> struct TagSBAM_;       	// "projects/library/seqan/file/file_format_sam.h"(39)

//____________________________________________________________________________
// _Append_ChunkCollector_2_String

template <typename TExpand> struct _Append_ChunkCollector_2_String;       	// "projects/library/seqan/file/chunk_collector.h"(342)

//____________________________________________________________________________
// _Assign_ChunkCollector_2_String

template <typename TExpand> struct _Assign_ChunkCollector_2_String;       	// "projects/library/seqan/file/chunk_collector.h"(272)

//____________________________________________________________________________
// _Assign_Stream_2_ChunkCollector

struct _Assign_Stream_2_ChunkCollector;       	// "projects/library/seqan/file/chunk_collector.h"(194)

//____________________________________________________________________________
// _BAM

struct _BAM;       	// "projects/library/seqan/file/file_format_sam.h"(54)

//____________________________________________________________________________
// _ChunkCollector

template <typename THost> class _ChunkCollector;       	// "projects/library/seqan/file/chunk_collector.h"(51)

//____________________________________________________________________________
// _FileReader_Types

template <typename T> struct _FileReader_Types;       	// "projects/library/seqan/file/file_filereader.h"(419)

//____________________________________________________________________________
// _IsTellSeekStream

template <typename T> struct _IsTellSeekStream;       	// "projects/library/seqan/file/stream.h"(179)
template <typename T> struct _IsTellSeekStream;       	// "projects/library/seqan/file/cstream.h"(63)

//____________________________________________________________________________
// _Read_Raw

template <typename TFile, typename TData, typename TTag> struct _Read_Raw;       	// "projects/library/seqan/file/file_format_raw.h"(47)

//____________________________________________________________________________
// _Replace_ChunkCollector_2_String

template <typename TExpand> struct _Replace_ChunkCollector_2_String;       	// "projects/library/seqan/file/chunk_collector.h"(415)

//____________________________________________________________________________
// _SAM

struct _SAM;       	// "projects/library/seqan/file/file_format_sam.h"(46)

//____________________________________________________________________________
// aDummyRequest

struct aDummyRequest;       	// "projects/library/seqan/file/file_base.h"(143)

//____________________________________________________________________________
// aRequest

template <typename T > struct aRequest;       	// "projects/library/seqan/file/file_base.h"(156)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BAM

typedef Tag<TagSBAM_<_BAM> > const BAM;       	// "projects/library/seqan/file/file_format_sam.h"(55)

//____________________________________________________________________________
// CGViz

typedef Tag<TagCGViz_> const CGViz;       	// "projects/library/seqan/file/file_format_cgviz.h"(37)

//____________________________________________________________________________
// Embl

typedef Tag<TagEmbl_> const Embl;       	// "projects/library/seqan/file/file_format_embl.h"(35)

//____________________________________________________________________________
// Fasta

typedef Tag<TagFasta_> const Fasta;       	// "projects/library/seqan/file/file_format_fasta.h"(36)

//____________________________________________________________________________
// FastaAlign

typedef Tag<TagFastaAlign_> const FastaAlign;       	// "projects/library/seqan/file/file_format_fasta_align.h"(45)

//____________________________________________________________________________
// Genbank

typedef Tag<TagGenbank_> const Genbank;       	// "projects/library/seqan/file/file_format_genbank.h"(36)

//____________________________________________________________________________
// Raw

typedef Tag<TagRaw_> const Raw;       	// "projects/library/seqan/file/file_format_raw.h"(38)

//____________________________________________________________________________
// SAM

typedef Tag<TagSBAM_<_SAM> > const SAM;       	// "projects/library/seqan/file/file_format_sam.h"(47)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _FileReaderString_construct

template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline void _FileReaderString_construct(String<TValue, FileReader<TFormat, TFile, TSpec> > & me);       	// "projects/library/seqan/file/file_filereader.h"(263)

//____________________________________________________________________________
// _FileReaderString_findblock

template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPosition> inline unsigned int _FileReaderString_findblock(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TPosition pos);       	// "projects/library/seqan/file/file_filereader.h"(242)

//____________________________________________________________________________
// _FileReaderString_isValidBlock

template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TUint> inline bool _FileReaderString_isValidBlock(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TUint block_number);       	// "projects/library/seqan/file/file_filereader.h"(280)

//____________________________________________________________________________
// _FileReaderString_loadComplete

template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline void _FileReaderString_loadComplete(String<TValue, FileReader<TFormat, TFile, TSpec> > & me);       	// "projects/library/seqan/file/file_filereader.h"(297)

//____________________________________________________________________________
// _FileReaderString_loadblock

template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPosition> inline void _FileReaderString_loadblock(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TPosition blocknum);       	// "projects/library/seqan/file/file_filereader.h"(176)

//____________________________________________________________________________
// _allocateStorage

template <typename TValue, typename TConfig, typename TSize > inline typename Value<String<TValue, MMap<TConfig> > >::Type * _allocateStorage(String<TValue, MMap<TConfig> > &me, TSize new_capacity);       	// "projects/library/seqan/file/string_mmap.h"(578)

//____________________________________________________________________________
// _cancelFArray

template <typename TFileArray, typename TRequest > inline bool _cancelFArray(TFileArray &me, TRequest &request);       	// "projects/library/seqan/file/file_array.h"(272)

//____________________________________________________________________________
// _closeFArray

template <typename TFileArray > inline bool _closeFArray(TFileArray &me);       	// "projects/library/seqan/file/file_array.h"(242)

//____________________________________________________________________________
// _dataFile

template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline TFile & _dataFile(String<TValue, FileReader<TFormat, TFile, TSpec> > & me);       	// "projects/library/seqan/file/file_filereader.h"(165)

//____________________________________________________________________________
// _deallocateStorage

template <typename TValue, typename TConfig, typename TSize > inline void _deallocateStorage(String<TValue, MMap<TConfig> > & , TValue * , TSize );       	// "projects/library/seqan/file/string_mmap.h"(599)

//____________________________________________________________________________
// _ensureFileIsOpen

template <typename TValue, typename TConfig > inline void _ensureFileIsOpen(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(659)

//____________________________________________________________________________
// _fasta_align_scan_line

template <typename TFile, typename TSize> void _fasta_align_scan_line(TFile & file, TSize & count);       	// "projects/library/seqan/file/file_format_fasta_align.h"(51)

//____________________________________________________________________________
// _fasta_scan_line

template <typename TFile, typename TSize> inline typename Value<TFile>::Type _fasta_scan_line(TFile & file, TSize & count_valid, TSize & count_all);       	// "projects/library/seqan/file/file_format_fasta.h"(145)

//____________________________________________________________________________
// _flushFArray

template <typename TFileArray > inline bool _flushFArray(TFileArray &me);       	// "projects/library/seqan/file/file_array.h"(264)

//____________________________________________________________________________
// _getCStyleOpenMode

inline const char * _getCStyleOpenMode(int openMode);       	// "projects/library/seqan/file/file_cstyle.h"(68)

//____________________________________________________________________________
// _holderAllocatePointer

template <typename THolder> inline FILE * _holderAllocatePointer(THolder &, FILE * data);       	// "projects/library/seqan/file/cstream.h"(236)

//____________________________________________________________________________
// _holderDeallocate

template <typename THolder> inline void _holderDeallocate(THolder &, FILE *);       	// "projects/library/seqan/file/cstream.h"(231)

//____________________________________________________________________________
// _map

template <typename TValue, typename TConfig > inline bool _map(String<TValue, MMap<TConfig> > &me, size_t new_capacity);       	// "projects/library/seqan/file/string_mmap.h"(303)
template <typename TValue, typename TConfig > inline bool _map(String<TValue, MMap<TConfig> > &me, size_t new_capacity);       	// "projects/library/seqan/file/string_mmap.h"(468)

//____________________________________________________________________________
// _openTempFArray

template <typename TFileArray > inline bool _openTempFArray(TFileArray &me, int openMode);       	// "projects/library/seqan/file/file_array.h"(221)
template <typename TFileArray > inline bool _openTempFArray(TFileArray &me);       	// "projects/library/seqan/file/file_array.h"(229)

//____________________________________________________________________________
// _read_n_chars_from_file

template <typename TFile, typename TSize> inline void _read_n_chars_from_file(TFile & file, TSize count);       	// "projects/library/seqan/file/file_format_fasta.h"(187)

//____________________________________________________________________________
// _reallocateStorage

template <typename TValue, typename TConfig > inline typename Value<String<TValue, MMap<TConfig> > >::Type * _reallocateStorage( String<TValue, MMap<TConfig> > &me, typename Size< String<TValue, MMap<TConfig> > >::Type new_capacity);       	// "projects/library/seqan/file/string_mmap.h"(589)

//____________________________________________________________________________
// _remap

template <typename TValue, typename TConfig, typename TCapSize > inline bool _remap(String<TValue, MMap<TConfig> > &me, TCapSize new_capacity);       	// "projects/library/seqan/file/string_mmap.h"(380)
template <typename TValue, typename TConfig, typename TCapSize > inline bool _remap(String<TValue, MMap<TConfig> > &me, TCapSize new_capacity);       	// "projects/library/seqan/file/string_mmap.h"(518)

//____________________________________________________________________________
// _reopenFArray

template <typename TFileArray > inline bool _reopenFArray(TFileArray &me, int openMode);       	// "projects/library/seqan/file/file_array.h"(234)

//____________________________________________________________________________
// _sectorSizeFArray

template <typename TFileArray > inline unsigned _sectorSizeFArray(TFileArray &me, int openMode);       	// "projects/library/seqan/file/file_array.h"(250)

//____________________________________________________________________________
// _setCapacity

template <typename TValue, typename TConfig > inline void _setCapacity( String<TValue, MMap<TConfig> > & me, size_t new_capacity);       	// "projects/library/seqan/file/string_mmap.h"(210)

//____________________________________________________________________________
// _setLength

template <typename TValue, typename TConfig > inline void _setLength( String<TValue, MMap<TConfig> > & me, size_t new_length);       	// "projects/library/seqan/file/string_mmap.h"(198)
template <typename THost> inline void _setLength(_ChunkCollector<THost> & me, typename Size<THost>::Type new_length);       	// "projects/library/seqan/file/chunk_collector.h"(106)

//____________________________________________________________________________
// _sizeFArray

template <typename TFileArray > inline typename Size<TFileArray>::Type _sizeFArray(TFileArray &me);       	// "projects/library/seqan/file/file_array.h"(256)

//____________________________________________________________________________
// _streamClose

inline void _streamClose(::std::FILE * & me);       	// "projects/library/seqan/file/cstream.h"(93)

//____________________________________________________________________________
// _streamEOF

template <typename TValue, typename TTraits> inline bool _streamEOF(::std::basic_ios<TValue, TTraits> const & me);       	// "projects/library/seqan/file/stream.h"(209)
inline bool _streamEOF(::std::FILE * me);       	// "projects/library/seqan/file/cstream.h"(108)

//____________________________________________________________________________
// _streamGet

template <typename TValue, typename TTraits> inline TValue _streamGet(::std::basic_istream<TValue, TTraits> & source);       	// "projects/library/seqan/file/stream.h"(253)
inline char _streamGet(::std::FILE * source);       	// "projects/library/seqan/file/cstream.h"(133)

//____________________________________________________________________________
// _streamOpen

inline bool _streamOpen(::std::FILE * & me, String<char> path, bool for_read );       	// "projects/library/seqan/file/cstream.h"(75)

//____________________________________________________________________________
// _streamPeek

template <typename TValue, typename TTraits> inline TValue _streamPeek(::std::basic_istream<TValue, TTraits> & source);       	// "projects/library/seqan/file/stream.h"(273)

//____________________________________________________________________________
// _streamPut

template <typename TValue, typename TTraits, typename TChar> inline void _streamPut(::std::basic_ostream<TValue, TTraits> & target, TChar character);       	// "projects/library/seqan/file/stream.h"(313)
inline void _streamPut(::std::FILE * target, char character);       	// "projects/library/seqan/file/cstream.h"(145)

//____________________________________________________________________________
// _streamPutFloat

template <typename TStream> inline void _streamPutFloat(TStream & target, float number, char const * format_string);       	// "projects/library/seqan/file/stream_algorithms.h"(73)
template <typename TStream> inline void _streamPutFloat(TStream & target, float number);       	// "projects/library/seqan/file/stream_algorithms.h"(83)

//____________________________________________________________________________
// _streamPutInt

template <typename TStream> inline void _streamPutInt(TStream & target, int number, char const * format_string);       	// "projects/library/seqan/file/stream_algorithms.h"(44)
template <typename TStream> inline void _streamPutInt(TStream & target, int number);       	// "projects/library/seqan/file/stream_algorithms.h"(54)

//____________________________________________________________________________
// _streamRead

template <typename TValue, typename TTraits> inline ::std::streamsize _streamRead(TValue * target, ::std::basic_istream<TValue, TTraits> & source, ::std::streamsize limit);       	// "projects/library/seqan/file/stream.h"(232)
template <typename TValue> inline size_t _streamRead(TValue * target, ::std::FILE * source, size_t limit);       	// "projects/library/seqan/file/cstream.h"(122)

//____________________________________________________________________________
// _streamSeek2G

template <typename TValue, typename TTraits> inline void _streamSeek2G(::std::basic_istream<TValue, TTraits> & me, int off);       	// "projects/library/seqan/file/stream.h"(420)
inline void _streamSeek2G(FILE * me, int off);       	// "projects/library/seqan/file/cstream.h"(208)

//____________________________________________________________________________
// _streamSeekG

template <typename TValue, typename TTraits> inline void _streamSeekG(::std::basic_istream<TValue, TTraits> & me, typename Position< ::std::basic_istream<TValue, TTraits> >::Type pos);       	// "projects/library/seqan/file/stream.h"(373)
inline void _streamSeekG(FILE * me, Position<FILE *>::Type pos);       	// "projects/library/seqan/file/cstream.h"(184)

//____________________________________________________________________________
// _streamSeekP

template <typename TValue, typename TTraits> inline void _streamSeekP(::std::basic_ostream<TValue, TTraits> & me, typename Position< ::std::basic_ostream<TValue, TTraits> >::Type pos);       	// "projects/library/seqan/file/stream.h"(397)
inline void _streamSeekP(FILE * me, Position<FILE *>::Type pos);       	// "projects/library/seqan/file/cstream.h"(196)

//____________________________________________________________________________
// _streamTellG

template <typename TValue, typename TTraits> inline typename Position< ::std::basic_istream<TValue, TTraits> >::Type _streamTellG(::std::basic_istream<TValue, TTraits> & me);       	// "projects/library/seqan/file/stream.h"(332)
inline Position<FILE *>::Type _streamTellG(FILE * me);       	// "projects/library/seqan/file/cstream.h"(161)

//____________________________________________________________________________
// _streamTellP

template <typename TValue, typename TTraits> inline typename Position< ::std::basic_ostream<TValue, TTraits> >::Type _streamTellP(::std::basic_ostream<TValue, TTraits> & me);       	// "projects/library/seqan/file/stream.h"(351)
inline Position<FILE *>::Type _streamTellP(FILE * me);       	// "projects/library/seqan/file/cstream.h"(172)

//____________________________________________________________________________
// _streamUnget

template <typename TValue, typename TTraits> inline void _streamUnget(::std::basic_istream<TValue, TTraits> & source);       	// "projects/library/seqan/file/stream.h"(292)
inline void _streamUnget(::std::FILE * stream);       	// "projects/library/seqan/file/cstream.h"(219)

//____________________________________________________________________________
// _streamWrite

template <typename TTarget, typename T1, typename T2, typename TCompression> inline void _streamWrite(TTarget & target, Pair<T1, T2, TCompression> const & source);       	// "projects/library/seqan/file/stream_algorithms.h"(94)
template <typename TTarget, typename T1, typename T2, typename T3, typename TCompression> inline void _streamWrite(TTarget & target, Triple<T1, T2, T3, TCompression> const & source);       	// "projects/library/seqan/file/stream_algorithms.h"(104)
template <typename TTarget, typename TSource> inline void _streamWrite(TTarget & target, TSource const & source);       	// "projects/library/seqan/file/stream_algorithms.h"(128)

//____________________________________________________________________________
// _streamWriteRange

template <typename TTarget, typename TIterator> inline void _streamWriteRange(TTarget & target, TIterator begin_, TIterator end_);       	// "projects/library/seqan/file/stream_algorithms.h"(193)

//____________________________________________________________________________
// _streamWriteSeq

template <typename TTarget, typename TSource> inline void _streamWriteSeq(TTarget & target, TSource const & source, False const);       	// "projects/library/seqan/file/stream_algorithms.h"(140)
template <typename TTarget, typename TSource> inline void _streamWriteSeq(TTarget & target, TSource const & source, True const);       	// "projects/library/seqan/file/stream_algorithms.h"(151)
template <typename TTarget, typename TSourceValue> inline void _streamWriteSeq(TTarget & target, TSourceValue const * source, True const);       	// "projects/library/seqan/file/stream_algorithms.h"(168)

//____________________________________________________________________________
// _stream_appendLine

template <typename TFile, typename TString, typename TChar> inline void _stream_appendLine(TFile & file, TString & str, TChar & c);       	// "projects/library/seqan/file/file_format.h"(432)

//____________________________________________________________________________
// _stream_countLine

template <typename TFile, typename TChar> inline void _stream_countLine(TFile & file, TChar & c);       	// "projects/library/seqan/file/file_format.h"(464)

//____________________________________________________________________________
// _stream_isLetter

template <typename TChar> inline bool _stream_isLetter(TChar const c);       	// "projects/library/seqan/file/file_format.h"(564)

//____________________________________________________________________________
// _stream_readWord

template <typename TFile, typename TChar> inline String<char> _stream_readWord(TFile & file, TChar& c);       	// "projects/library/seqan/file/file_format.h"(548)

//____________________________________________________________________________
// _stream_skipLine

template <typename TFile, typename TChar> inline typename Size<TFile>::Type _stream_skipLine(TFile & file, TChar & c);       	// "projects/library/seqan/file/file_format.h"(495)

//____________________________________________________________________________
// _stream_skipWhitespace

template <typename TFile, typename TChar> inline void _stream_skipWhitespace(TFile& file, TChar& c);       	// "projects/library/seqan/file/file_format.h"(534)

//____________________________________________________________________________
// _string_appendLine

template <typename TString1, typename TString2, typename TIter> inline void _string_appendLine(TString1 & str, TString2 & a_str, TIter & it);       	// "projects/library/seqan/file/file_format.h"(624)

//____________________________________________________________________________
// _string_readNumber

template <typename TString, typename TIter> inline int _string_readNumber(TString & str, TIter& it);       	// "projects/library/seqan/file/file_format.h"(668)

//____________________________________________________________________________
// _string_skipLine

template <typename TString, typename TIter> inline typename Size<TString>::Type _string_skipLine(TString & str, TIter & it);       	// "projects/library/seqan/file/file_format.h"(588)

//____________________________________________________________________________
// _string_skipWhitespace

template <typename TString, typename TIter> inline void _string_skipWhitespace(TString& str, TIter& it);       	// "projects/library/seqan/file/file_format.h"(655)

//____________________________________________________________________________
// _unmap

template <typename TValue, typename TConfig > inline bool _unmap(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(349)
template <typename TValue, typename TConfig > inline bool _unmap(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(495)

//____________________________________________________________________________
// _writeAlignment

template <typename TFile, typename TGapsSpec, typename TIDString, typename TSAMSpec> inline void _writeAlignment( TFile & target, Align<DnaString, TGapsSpec> const & source, int ref, int read, const CharString & refName, const CharString & readName, BAM);       	// "projects/library/seqan/file/file_format_sam.h"(378)

//____________________________________________________________________________
// _write_additional_meta

template <typename TFile> inline void _write_additional_meta(TFile & target, String<Triple<CharString, char, CharString> > const & meta, Tag<TagSBAM_<_SAM> > );       	// "projects/library/seqan/file/file_format_sam.h"(195)

//____________________________________________________________________________
// _write_alignment

template <typename TFile, typename TGapsSpec, typename TMeta> inline void _write_alignment(TFile & target, Align<DnaString,TGapsSpec> const & source, const int ref_row_pos_int, const int read_row_pos_int, const TMeta & meta, Tag<TagSBAM_<_SAM> > );       	// "projects/library/seqan/file/file_format_sam.h"(222)

//____________________________________________________________________________
// _write_impl

template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void _write_impl(TFile& target, Align<TSource, TSpec>& align, TStringContainer& ids, CGViz);       	// "projects/library/seqan/file/file_format_cgviz.h"(62)
template <typename TFile, typename TString, typename TData> void _write_impl(TFile & file, TData & data, TString & id, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(487)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void _write_impl(TFile& file, Align<TSource, TSpec>& align, TStringContainer& ids, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(246)

//____________________________________________________________________________
// alignSize

template <typename T1, typename T2> inline T1 alignSize(T1 _size, T2 _aligning);       	// "projects/library/seqan/file/file_base.h"(713)

//____________________________________________________________________________
// allocPage

template <typename TValue, typename TSize, typename T > inline void allocPage(SimpleBuffer<TValue> &pf, TSize size, T const & me);       	// "projects/library/seqan/file/file_page.h"(114)
template <typename TValue, typename TFile, typename TSpec, typename T > inline void allocPage(PageFrame<TValue, TFile, TSpec> &pf, T const & me);       	// "projects/library/seqan/file/file_page.h"(378)

//____________________________________________________________________________
// allocate

template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize > inline void allocate(File< Chained<FILE_SIZE, TFile> > const &me, TValue* &data, TSize count);       	// "projects/library/seqan/file/file_array.h"(340)
template <unsigned _FileCount, typename TFile, typename TValue, typename TSize > inline void allocate(File< Striped<_FileCount, TFile> > const &me, TValue* &data, TSize count);       	// "projects/library/seqan/file/file_array.h"(350)

//____________________________________________________________________________
// append

template <typename TValue, typename TConfig, typename TSource, typename TExpand > inline void append(String<TValue, External<TConfig> > &target, TSource const &source, Tag<TExpand> const expand);       	// "projects/library/seqan/file/string_external.h"(1932)
template <typename TValue, typename TConfig, typename TSourceValue, typename TExpand > inline void append(String<TValue, External<TConfig> > &target, TSourceValue * source, Tag<TExpand> const expand);       	// "projects/library/seqan/file/string_external.h"(1953)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, _ChunkCollector<TSourceHost> const & source, Tag<TExpand> const );       	// "projects/library/seqan/file/chunk_collector.h"(398)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, _ChunkCollector<TSourceHost> const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const );       	// "projects/library/seqan/file/chunk_collector.h"(407)

//____________________________________________________________________________
// appendValue

template <typename TValue, typename TConfig, typename TExpand > inline void appendValue(String<TValue, External<TConfig> > &me, TValue const &_Val, Tag<TExpand> const expand);       	// "projects/library/seqan/file/string_external.h"(1870)

//____________________________________________________________________________
// areadAt

template <typename File, typename TValue, typename TSize, typename TPos, typename aRequest > inline bool areadAt(File & me, TValue *memPtr, TSize const count, TPos const fileOfs, aRequest &);       	// "projects/library/seqan/file/file_base.h"(606)
template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize, typename TOffset, typename TRequest > inline bool areadAt(File< Chained<FILE_SIZE, TFile> > &me, TValue *memPtr, TSize count, TOffset offset, TRequest &req);       	// "projects/library/seqan/file/file_array.h"(392)

//____________________________________________________________________________
// assign

template <typename TValue, typename TConfig, typename TSource, typename TExpand > inline void assign( String<TValue, External<TConfig> > &target, TSource const &source, Tag<TExpand> const);       	// "projects/library/seqan/file/string_external.h"(2004)
template <typename TValue, typename TConfig, typename TSourceValue, typename TExpand > inline void assign( String<TValue, External<TConfig> > &target, TSourceValue * source, Tag<TExpand> const);       	// "projects/library/seqan/file/string_external.h"(2027)
template <typename THost, typename TSource> inline void assign(_ChunkCollector<THost> & target, TSource & source);       	// "projects/library/seqan/file/chunk_collector.h"(239)
template <typename THost, typename TSource> inline void assign(_ChunkCollector<THost> & target, TSource const & source);       	// "projects/library/seqan/file/chunk_collector.h"(246)
template <typename THost, typename TSource, typename TSize> inline void assign(_ChunkCollector<THost> & target, TSource & source, TSize limit);       	// "projects/library/seqan/file/chunk_collector.h"(255)
template <typename THost, typename TSource, typename TSize> inline void assign(_ChunkCollector<THost> & target, TSource const & source, TSize limit);       	// "projects/library/seqan/file/chunk_collector.h"(263)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, _ChunkCollector<TSourceHost> const & source, Tag<TExpand> const tag);       	// "projects/library/seqan/file/chunk_collector.h"(324)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, _ChunkCollector<TSourceHost> const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const tag);       	// "projects/library/seqan/file/chunk_collector.h"(333)

//____________________________________________________________________________
// atBegin

template <typename TExtString> inline bool atBegin(ExtStringIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(928)
template <typename TExtString> inline bool atBegin(ExtStringIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(930)
template <typename TExtString> inline bool atBegin(ExtStringConstIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(933)
template <typename TExtString> inline bool atBegin(ExtStringConstIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(935)
template <typename TExtString> inline bool atBegin(ExtStringFwdIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(938)
template <typename TExtString> inline bool atBegin(ExtStringFwdIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(942)
template <typename TExtString> inline bool atBegin(ExtStringFwdConstIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(947)
template <typename TExtString> inline bool atBegin(ExtStringFwdConstIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(951)
template <typename TContainer> inline bool atBegin(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(769)
template <typename TContainer> inline bool atBegin(Iter<TContainer, FileReaderIterator> const & it);       	// "projects/library/seqan/file/file_filereader.h"(775)

//____________________________________________________________________________
// atEnd

template <typename TExtString> inline bool atEnd(ExtStringIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(957)
template <typename TExtString> inline bool atEnd(ExtStringIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(959)
template <typename TExtString> inline bool atEnd(ExtStringConstIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(962)
template <typename TExtString> inline bool atEnd(ExtStringConstIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(964)
template <typename TExtString> inline bool atEnd(ExtStringFwdIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(967)
template <typename TExtString> inline bool atEnd(ExtStringFwdIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(971)
template <typename TExtString> inline bool atEnd(ExtStringFwdConstIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(976)
template <typename TExtString> inline bool atEnd(ExtStringFwdConstIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(980)
template <typename TContainer> inline bool atEnd(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(754)
template <typename TContainer> inline bool atEnd(Iter<TContainer, FileReaderIterator> const & it);       	// "projects/library/seqan/file/file_filereader.h"(760)

//____________________________________________________________________________
// awriteAt

template <typename File, typename TValue, typename TSize, typename TPos, typename aRequest > inline bool awriteAt(File & me, TValue const *memPtr, TSize const count, TPos const fileOfs, aRequest &);       	// "projects/library/seqan/file/file_base.h"(630)
template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize, typename TOffset, typename TRequest > inline bool awriteAt(File< Chained<FILE_SIZE, TFile> > &me, TValue const *memPtr, TSize count, TOffset offset, TRequest &req);       	// "projects/library/seqan/file/file_array.h"(409)

//____________________________________________________________________________
// back

template <typename TValue, typename TConfig > inline TValue & back(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1915)
template <typename TValue, typename TConfig > inline TValue const & back(String<TValue, External<TConfig> > const &me);       	// "projects/library/seqan/file/string_external.h"(1922)

//____________________________________________________________________________
// begin

template <typename TValue, typename TConfig > inline typename Iterator<String<TValue, MMap<TConfig> > , Standard>::Type begin(String<TValue, MMap<TConfig> > & me, Standard);       	// "projects/library/seqan/file/string_mmap.h"(141)
template <typename TValue, typename TConfig > inline typename Iterator<String<TValue, MMap<TConfig> > const, Standard>::Type begin(String<TValue, MMap<TConfig> > const & me, Standard);       	// "projects/library/seqan/file/string_mmap.h"(149)
template <typename TValue, typename TConfig, typename TSpec > inline typename Iterator<String<TValue, External<TConfig> >, Tag<TSpec> const>::Type begin(String<TValue, External<TConfig> > &me, Tag<TSpec> const);       	// "projects/library/seqan/file/string_external.h"(1820)
template <typename TValue, typename TConfig, typename TSpec > inline typename Iterator<String<TValue, External<TConfig> > const, Tag<TSpec> const>::Type begin(String<TValue, External<TConfig> > const &me, Tag<TSpec> const);       	// "projects/library/seqan/file/string_external.h"(1828)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> >, TIteratorSpec >::Type begin(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, Tag<TIteratorSpec> const);       	// "projects/library/seqan/file/file_filereader.h"(349)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> > const, TIteratorSpec >::Type begin(String<TValue, FileReader<TFormat, TFile, TSpec> > const & me, Tag<TIteratorSpec> const);       	// "projects/library/seqan/file/file_filereader.h"(357)
template <typename TValue > inline TValue* begin(SimpleBuffer<TValue> &pf, Standard);       	// "projects/library/seqan/file/file_page.h"(129)
template <typename TValue > inline TValue const * begin(SimpleBuffer<TValue> const &pf, Standard);       	// "projects/library/seqan/file/file_page.h"(134)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Iterator< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS>, Standard >::Type begin( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> &pageCont, Standard const);       	// "projects/library/seqan/file/file_page.h"(920)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Iterator< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const, Standard >::Type begin( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const &pageCont, Standard const);       	// "projects/library/seqan/file/file_page.h"(929)

//____________________________________________________________________________
// cancel

template <typename TValue, typename TConfig > inline void cancel(String<TValue, MMap<TConfig> > &);       	// "projects/library/seqan/file/string_mmap.h"(289)
template <typename TValue, typename TConfig > inline void cancel(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(452)
template <typename TValue, typename TConfig > inline void cancel(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1554)
template <typename aRequest > inline bool cancel(FILE*, aRequest &);       	// "projects/library/seqan/file/file_cstyle.h"(227)
template <typename TSpec, typename aRequest > inline bool cancel(File<TSpec> &, aRequest &);       	// "projects/library/seqan/file/file_base.h"(698)
template <typename TValue, typename TFile, typename TSpec > inline bool cancel(PageFrame<TValue, TFile, TSpec> &pf, TFile &file);       	// "projects/library/seqan/file/file_page.h"(480)

//____________________________________________________________________________
// cancelAndFree

template <typename TValue, typename TConfig > inline void cancelAndFree(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1572)

//____________________________________________________________________________
// capacity

template <typename TValue, typename TConfig > inline typename Size<String<TValue, MMap<TConfig> > >::Type capacity(String<TValue, MMap<TConfig> > & me);       	// "projects/library/seqan/file/string_mmap.h"(178)
template <typename TValue, typename TConfig > inline typename Size<String<TValue, MMap<TConfig> > >::Type capacity(String<TValue, MMap<TConfig> > const & me);       	// "projects/library/seqan/file/string_mmap.h"(186)
template <typename TValue, typename TConfig > inline typename Size< String<TValue, External<TConfig> > >::Type capacity(String<TValue, External<TConfig> > const &me);       	// "projects/library/seqan/file/string_external.h"(1772)

//____________________________________________________________________________
// chunkCount

template <typename THost> inline int chunkCount(_ChunkCollector<THost> const & me);       	// "projects/library/seqan/file/chunk_collector.h"(113)

//____________________________________________________________________________
// clear

template <typename TValue, typename TConfig > inline void clear(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(568)
template <typename TValue, typename TConfig > inline void clear(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1504)
template <typename THost> inline void clear(_ChunkCollector<THost> & me);       	// "projects/library/seqan/file/chunk_collector.h"(80)

//____________________________________________________________________________
// close

template <typename TValue, typename TConfig > inline bool close(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(697)
template <typename TValue, typename TConfig > inline bool close(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1743)
inline bool close(FILE* me);       	// "projects/library/seqan/file/file_cstyle.h"(113)
template <typename TSpec > inline bool close(File<TSpec> & me);       	// "projects/library/seqan/file/file_base.h"(267)
template <__int64 FILE_SIZE, typename TFile > inline bool close(File< Chained<FILE_SIZE, TFile> > &me);       	// "projects/library/seqan/file/file_array.h"(315)
template <unsigned _FileCount, typename TFile > inline bool close(File< Striped<_FileCount, TFile> > &me);       	// "projects/library/seqan/file/file_array.h"(322)

//____________________________________________________________________________
// container

template <typename TExtString> inline TExtString & container(ExtStringIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(907)
template <typename TExtString> inline TExtString & container(ExtStringIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(909)
template <typename TExtString> inline TExtString & container(ExtStringConstIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(912)
template <typename TExtString> inline TExtString & container(ExtStringConstIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(914)
template <typename TExtString> inline TExtString & container(ExtStringFwdIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(917)
template <typename TExtString> inline TExtString & container(ExtStringFwdIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(919)
template <typename TExtString> inline TExtString & container(ExtStringFwdConstIterator<TExtString> &it);       	// "projects/library/seqan/file/string_external.h"(922)
template <typename TExtString> inline TExtString & container(ExtStringFwdConstIterator<TExtString> const &it);       	// "projects/library/seqan/file/string_external.h"(924)
template <typename TContainer> inline TContainer & container(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(582)
template <typename TContainer> inline TContainer & container(Iter<TContainer, FileReaderIterator> const & it);       	// "projects/library/seqan/file/file_filereader.h"(588)

//____________________________________________________________________________
// createChunk

template <typename THost> inline typename Value<THost>::Type * createChunk(_ChunkCollector<THost> & me);       	// "projects/library/seqan/file/chunk_collector.h"(127)

//____________________________________________________________________________
// deallocate

template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize > inline void deallocate(File< Chained<FILE_SIZE, TFile> > const &me, TValue* &data, TSize count);       	// "projects/library/seqan/file/file_array.h"(345)
template <unsigned _FileCount, typename TFile, typename TValue, typename TSize > inline void deallocate(File< Striped<_FileCount, TFile> > const &me, TValue* &data, TSize count);       	// "projects/library/seqan/file/file_array.h"(355)

//____________________________________________________________________________
// enclosingBlocks

template <typename T1, typename T2> inline T1 enclosingBlocks(T1 _size, T2 _blockSize);       	// "projects/library/seqan/file/file_base.h"(707)

//____________________________________________________________________________
// end

template <typename TValue, typename TConfig > inline typename Iterator<String<TValue, MMap<TConfig> > , Standard>::Type end(String<TValue, MMap<TConfig> > & me, Standard);       	// "projects/library/seqan/file/string_mmap.h"(160)
template <typename TValue, typename TConfig > inline typename Iterator<String<TValue, MMap<TConfig> > const, Standard>::Type end(String<TValue, MMap<TConfig> > const & me, Standard);       	// "projects/library/seqan/file/string_mmap.h"(168)
template <typename TValue, typename TConfig, typename TSpec > inline typename Iterator<String<TValue, External<TConfig> >, Tag<TSpec> const>::Type end(String<TValue, External<TConfig> > &me, Tag<TSpec> const);       	// "projects/library/seqan/file/string_external.h"(1836)
template <typename TValue, typename TConfig, typename TSpec > inline typename Iterator<String<TValue, External<TConfig> > const, Tag<TSpec> const>::Type end(String<TValue, External<TConfig> > const &me, Tag<TSpec> const);       	// "projects/library/seqan/file/string_external.h"(1844)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> >, TIteratorSpec >::Type end(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, Tag<TIteratorSpec> const);       	// "projects/library/seqan/file/file_filereader.h"(369)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> > const, TIteratorSpec >::Type end(String<TValue, FileReader<TFormat, TFile, TSpec> > const & me, Tag<TIteratorSpec> const);       	// "projects/library/seqan/file/file_filereader.h"(377)
template <typename TValue > inline TValue * end(SimpleBuffer<TValue> &pf, Standard);       	// "projects/library/seqan/file/file_page.h"(139)
template <typename TValue > inline TValue const * end(SimpleBuffer<TValue> const &pf, Standard);       	// "projects/library/seqan/file/file_page.h"(144)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Iterator< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS>, Standard >::Type end( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> &pageCont, Standard const);       	// "projects/library/seqan/file/file_page.h"(938)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Iterator< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const, Standard >::Type end( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const &pageCont, Standard const);       	// "projects/library/seqan/file/file_page.h"(947)

//____________________________________________________________________________
// equiDistantAlignedDistribution

template <typename TValue, typename TSize, typename T, class Function > inline unsigned equiDistantAlignedDistribution( SimpleBuffer<TValue> &_clusterBuffer, unsigned aligning, unsigned _bufferSize, T const &me, TSize _size, unsigned _pageSize, Function const &_Func);       	// "projects/library/seqan/file/file_page.h"(1023)

//____________________________________________________________________________
// equiDistantDistribution

template <typename TValue, typename TSize, typename T, class Function > inline bool equiDistantDistribution( SimpleBuffer<TValue> &_clusterBuffer, unsigned _bufferSize, T const &me, TSize _size, unsigned _pageSize, Function const &_Func);       	// "projects/library/seqan/file/file_page.h"(961)

//____________________________________________________________________________
// flush

template <typename TValue, typename TConfig > inline void flush(String<TValue, MMap<TConfig> > &);       	// "projects/library/seqan/file/string_mmap.h"(282)
template <typename TValue, typename TConfig > inline void flush(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(444)
template <typename TValue, typename TConfig > inline void flush(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1534)
inline bool flush(FILE*);       	// "projects/library/seqan/file/file_cstyle.h"(214)
template <typename TSpec > inline void flush(File<TSpec> &);       	// "projects/library/seqan/file/file_base.h"(650)

//____________________________________________________________________________
// flushAndFree

template <typename TValue, typename TConfig > inline void flushAndFree(String<TValue, MMap<TConfig> > &);       	// "projects/library/seqan/file/string_mmap.h"(296)
template <typename TValue, typename TConfig > inline void flushAndFree(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(460)
template <typename TValue, typename TConfig > inline void flushAndFree(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1601)

//____________________________________________________________________________
// formatID

template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void * formatID(FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "projects/library/seqan/file/file_format.h"(171)

//____________________________________________________________________________
// freePage

template <typename TValue, typename T > inline void freePage(SimpleBuffer<TValue> &pf, T const & me);       	// "projects/library/seqan/file/file_page.h"(121)
template <typename TValue, typename TFile, typename TSpec, typename T > inline void freePage(PageFrame<TValue, TFile, TSpec> &pf, T const & me);       	// "projects/library/seqan/file/file_page.h"(389)

//____________________________________________________________________________
// front

template <typename TValue, typename TConfig > inline TValue & front(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1901)
template <typename TValue, typename TConfig > inline TValue const & front(String<TValue, External<TConfig> > const &me);       	// "projects/library/seqan/file/string_external.h"(1908)

//____________________________________________________________________________
// getChunk

template <typename THost> inline typename Value<THost>::Type * getChunk(_ChunkCollector<THost> const & me, int chunk_number);       	// "projects/library/seqan/file/chunk_collector.h"(120)

//____________________________________________________________________________
// getValue

template <typename TContainer> inline typename GetValue<Iter<TContainer, FileReaderIterator> >::Type getValue(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(542)
template <typename TContainer> inline typename GetValue<Iter<TContainer, FileReaderIterator> >::Type getValue(Iter<TContainer, FileReaderIterator> const & it);       	// "projects/library/seqan/file/file_filereader.h"(553)

//____________________________________________________________________________
// goBegin

template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Embl, TFile2, TSpec> > & it, bool skip_meta );       	// "projects/library/seqan/file/file_format_embl.h"(47)
template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Fasta, TFile2, TSpec> > & it, bool skip_meta);       	// "projects/library/seqan/file/file_format_fasta.h"(45)
template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Fasta, TFile2, TSpec> > & it);       	// "projects/library/seqan/file/file_format_fasta.h"(82)
template <typename TContainer> inline void goBegin(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(720)
template <typename TFile, typename TFile2, typename TSpec> inline void goBegin(Iter<TFile, FileReader<Genbank, TFile2, TSpec> > & it, bool skip_meta );       	// "projects/library/seqan/file/file_format_genbank.h"(46)

//____________________________________________________________________________
// goEnd

template <typename TContainer> inline void goEnd(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(742)

//____________________________________________________________________________
// goNext

template <typename TFile> void goNext(TFile & file, CGViz);       	// "projects/library/seqan/file/file_format_cgviz.h"(48)
template <typename TFile, typename TFile2, typename TSpec> inline void goNext(Iter<TFile, FileReader<Embl, TFile2, TSpec> > & it);       	// "projects/library/seqan/file/file_format_embl.h"(108)
template <typename TFile> inline void goNext(TFile & file, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(427)
template <typename TFile, typename TFile2, typename TSpec> inline void goNext(Iter<TFile, FileReader<Fasta, TFile2, TSpec> > & it);       	// "projects/library/seqan/file/file_format_fasta.h"(90)
template <typename TFile> void goNext(TFile & file, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(443)
template <typename TFile> void goNext(TFile & file, Raw);       	// "projects/library/seqan/file/file_format_raw.h"(247)
template <typename TContainer> inline void goNext(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(654)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void goNext(TFile & file, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "projects/library/seqan/file/file_format.h"(251)
template <typename TFile, typename TFile2, typename TSpec> inline void goNext(Iter<TFile, FileReader<Genbank, TFile2, TSpec> > & it);       	// "projects/library/seqan/file/file_format_genbank.h"(124)
template <typename TFile> inline void goNext(TFile & file, Genbank);       	// "projects/library/seqan/file/file_format_genbank.h"(254)
template <typename TFile> void goNext(TFile & file, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(233)

//____________________________________________________________________________
// goPrevious

template <typename TContainer> inline void goPrevious(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(686)

//____________________________________________________________________________
// guessFileFormat

template <typename TFile, typename TData, typename TMeta> inline FileFormat<TFile, TData, TMeta, void> guessFileFormat(TFile & file, TData & data);       	// "projects/library/seqan/file/file_format_guess.h"(52)

//____________________________________________________________________________
// id

template <typename TValue, typename TConfig > inline void const * id(String<TValue, External<TConfig> > const &me);       	// "projects/library/seqan/file/string_external.h"(2047)
template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline void const * id(String<TValue, FileReader<TFormat, TFile, TSpec> > const & me);       	// "projects/library/seqan/file/file_filereader.h"(310)

//____________________________________________________________________________
// iter

template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPosition, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> >, TIteratorSpec >::Type iter(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TPosition pos, Tag<TIteratorSpec> const);       	// "projects/library/seqan/file/file_filereader.h"(390)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPosition, typename TIteratorSpec> inline typename Iterator< String<TValue, FileReader<TFormat, TFile, TSpec> > const, TIteratorSpec >::Type iter(String<TValue, FileReader<TFormat, TFile, TSpec> > const & me, TPosition pos, Tag<TIteratorSpec> const);       	// "projects/library/seqan/file/file_filereader.h"(399)

//____________________________________________________________________________
// length

template <typename TValue, typename TConfig > inline typename Size< String<TValue, External<TConfig> > >::Type length(String<TValue, External<TConfig> > const &me);       	// "projects/library/seqan/file/string_external.h"(1765)
template <typename TValue, typename TFormat, typename TFile, typename TSpec> inline typename Size< String<TValue, FileReader<TFormat, TFile, TSpec> > >::Type length(String<TValue, FileReader<TFormat, TFile, TSpec> > & me);       	// "projects/library/seqan/file/file_filereader.h"(337)
template <__int64 FILE_SIZE, typename TFile > inline unsigned length(File< Chained<FILE_SIZE, TFile> > const &me);       	// "projects/library/seqan/file/file_array.h"(284)
template <unsigned _FileCount, typename TFile > inline unsigned length(File< Striped<_FileCount, TFile> > const &me);       	// "projects/library/seqan/file/file_array.h"(289)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void length(TFile & file, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "projects/library/seqan/file/file_format.h"(267)
template <typename THost> inline typename Size<THost>::Type length(_ChunkCollector<THost> const & me);       	// "projects/library/seqan/file/chunk_collector.h"(99)
template <typename TValue > inline typename Size<SimpleBuffer<TValue> >::Type length(SimpleBuffer<TValue> const &me);       	// "projects/library/seqan/file/file_page.h"(104)
template <typename TValue, typename TFile, unsigned _PageSize > inline typename Size<PageFrame<TValue, TFile, Fixed<_PageSize> > >::Type length(PageFrame<TValue, TFile, Fixed<_PageSize> > const & );       	// "projects/library/seqan/file/file_page.h"(328)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline typename Size< PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> >::Type length(PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> const &pageCont);       	// "projects/library/seqan/file/file_page.h"(911)

//____________________________________________________________________________
// open

template <typename TValue, typename TConfig > inline bool open(String<TValue, MMap<TConfig> > &me, const char *fileName, int openMode);       	// "projects/library/seqan/file/string_mmap.h"(606)
template <typename TValue, typename TConfig > inline bool open(String<TValue, MMap<TConfig> > &me, const char *fileName);       	// "projects/library/seqan/file/string_mmap.h"(622)
template <typename TValue, typename TConfig > inline bool open(String<TValue, MMap<TConfig> > &me, typename TConfig::TFile file);       	// "projects/library/seqan/file/string_mmap.h"(630)
template <typename TValue, typename TConfig > inline bool open(String<TValue, External<TConfig> > &me, const char *fileName, int openMode);       	// "projects/library/seqan/file/string_external.h"(1637)
template <typename TValue, typename TConfig > inline bool open(String<TValue, External<TConfig> > &me, const char *fileName);       	// "projects/library/seqan/file/string_external.h"(1660)
template <typename TValue, typename TConfig > inline bool open(String<TValue, External<TConfig> > &me, typename TConfig::TFile file);       	// "projects/library/seqan/file/string_external.h"(1670)
inline bool open(FILE* &me, const char *fileName, int openMode);       	// "projects/library/seqan/file/file_cstyle.h"(93)
inline bool open(FILE* &me, const char *fileName);       	// "projects/library/seqan/file/file_cstyle.h"(100)
template <typename TSpec > inline bool open(File<TSpec> &me, const char *fileName, int openMode);       	// "projects/library/seqan/file/file_base.h"(216)
template <typename TSpec > inline bool open(File<TSpec> &me, const char *fileName);       	// "projects/library/seqan/file/file_base.h"(222)
template <__int64 FILE_SIZE, typename TFile > inline bool open(File< Chained<FILE_SIZE, TFile> > &me, const char *fileName, int openMode);       	// "projects/library/seqan/file/file_array.h"(294)

//____________________________________________________________________________
// openTemp

template <typename TValue, typename TConfig > inline bool openTemp(String<TValue, MMap<TConfig> > &me);       	// "projects/library/seqan/file/string_mmap.h"(648)
template <typename TValue, typename TConfig > inline bool openTemp(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1701)
inline bool openTemp(FILE* &me);       	// "projects/library/seqan/file/file_cstyle.h"(106)
template <typename TSpec > inline bool openTemp(File<TSpec> &me);       	// "projects/library/seqan/file/file_base.h"(240)
template <typename TSpec > inline bool openTemp(File<TSpec> &me, int openMode);       	// "projects/library/seqan/file/file_base.h"(246)
template <__int64 FILE_SIZE, typename TFile > inline bool openTemp(File< Chained<FILE_SIZE, TFile> > &me, int openMode);       	// "projects/library/seqan/file/file_array.h"(303)
template <unsigned _FileCount, typename TFile > inline bool openTemp(File< Striped<_FileCount, TFile> > &me, int openMode);       	// "projects/library/seqan/file/file_array.h"(310)

//____________________________________________________________________________
// operator!=

template <typename TContainer> inline bool operator!= (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "projects/library/seqan/file/file_filereader.h"(800)
template <typename TFileLeft, typename TDataLeft, typename TMetaLeft, typename TFormatLeft, typename TFileRight, typename TDataRight, typename TMetaRight, typename TFormatRight> inline bool operator!= (FileFormat<TFileLeft, TDataLeft, TMetaLeft, TFormatLeft> const & left, FileFormat<TFileRight, TDataRight, TMetaRight, TFormatRight> const & right);       	// "projects/library/seqan/file/file_format.h"(348)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TFormat2> inline bool operator!= (FileFormat<TFile, TData, TMeta, TFormat> const & left, Tag<TFormat2> const);       	// "projects/library/seqan/file/file_format.h"(357)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TFormat2> inline bool operator!= (Tag<TFormat2> const, FileFormat<TFile, TData, TMeta, TFormat> const & right);       	// "projects/library/seqan/file/file_format.h"(366)

//____________________________________________________________________________
// operator+

template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> operator+ (Iter<TContainer, FileReaderIterator> const & left, TIntegral right);       	// "projects/library/seqan/file/file_filereader.h"(857)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> operator+ (TIntegral left, Iter<TContainer, FileReaderIterator> const & right);       	// "projects/library/seqan/file/file_filereader.h"(865)

//____________________________________________________________________________
// operator+=

template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> & operator+= (Iter<TContainer, FileReaderIterator> & left, TIntegral right);       	// "projects/library/seqan/file/file_filereader.h"(878)

//____________________________________________________________________________
// operator-

template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> operator- (Iter<TContainer, FileReaderIterator> const & left, TIntegral right);       	// "projects/library/seqan/file/file_filereader.h"(896)
template <typename TContainer> inline typename Difference<Iter<TContainer, FileReaderIterator> >::Type operator- (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "projects/library/seqan/file/file_filereader.h"(907)

//____________________________________________________________________________
// operator-=

template <typename TContainer, typename TIntegral> inline Iter<TContainer, FileReaderIterator> & operator-= (Iter<TContainer, FileReaderIterator> & left, TIntegral right);       	// "projects/library/seqan/file/file_filereader.h"(920)

//____________________________________________________________________________
// operator<

template <typename TContainer> inline bool operator< (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "projects/library/seqan/file/file_filereader.h"(813)

//____________________________________________________________________________
// operator<<

template <typename TValue > ::std::ostream& operator<<(::std::ostream &out, const PageBucketExtended<TValue> &pb);       	// "projects/library/seqan/file/file_page.h"(169)
template <typename TValue, typename TFile, typename TSpec > ::std::ostream& operator<<(::std::ostream &out, const PageFrame<TValue, TFile, TSpec > &pf);       	// "projects/library/seqan/file/file_page.h"(347)

//____________________________________________________________________________
// operator<=

template <typename TContainer> inline bool operator<= (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "projects/library/seqan/file/file_filereader.h"(835)

//____________________________________________________________________________
// operator==

template <typename TContainer> inline bool operator== (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "projects/library/seqan/file/file_filereader.h"(787)
template <typename TFileLeft, typename TDataLeft, typename TMetaLeft, typename TFormatLeft, typename TFileRight, typename TDataRight, typename TMetaRight, typename TFormatRight> inline bool operator== (FileFormat<TFileLeft, TDataLeft, TMetaLeft, TFormatLeft> const & left, FileFormat<TFileRight, TDataRight, TMetaRight, TFormatRight> const & right);       	// "projects/library/seqan/file/file_format.h"(319)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TFormat2> inline bool operator== (FileFormat<TFile, TData, TMeta, TFormat> const & left, Tag<TFormat2> const);       	// "projects/library/seqan/file/file_format.h"(328)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TFormat2> inline bool operator== (Tag<TFormat2> const, FileFormat<TFile, TData, TMeta, TFormat> const & right);       	// "projects/library/seqan/file/file_format.h"(337)

//____________________________________________________________________________
// operator>

template <typename TContainer> inline bool operator> (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "projects/library/seqan/file/file_filereader.h"(822)

//____________________________________________________________________________
// operator>=

template <typename TContainer> inline bool operator>= (Iter<TContainer, FileReaderIterator> const & left, Iter<TContainer, FileReaderIterator> const & right);       	// "projects/library/seqan/file/file_filereader.h"(844)

//____________________________________________________________________________
// pageSize

template <typename TValue > inline typename Size<SimpleBuffer<TValue> >::Type pageSize(SimpleBuffer<TValue> &me);       	// "projects/library/seqan/file/file_page.h"(87)
template <typename TValue, typename TFile, unsigned _PageSize > inline typename Size<PageFrame<TValue, TFile, Fixed<_PageSize> > >::Type pageSize(PageFrame<TValue, TFile, Fixed<_PageSize> > & );       	// "projects/library/seqan/file/file_page.h"(334)

//____________________________________________________________________________
// pop_back

template <typename TValue, typename TConfig > inline void pop_back(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1894)

//____________________________________________________________________________
// position

template <typename TContainer> inline typename Position<Iter<TContainer, FileReaderIterator> >::Type position(Iter<TContainer, FileReaderIterator> const & it);       	// "projects/library/seqan/file/file_filereader.h"(597)

//____________________________________________________________________________
// push

template <typename TValue, typename TConfig > inline void push(String<TValue, External<TConfig> > &me, TValue const &_Val);       	// "projects/library/seqan/file/string_external.h"(1881)

//____________________________________________________________________________
// push_back

template <typename TValue, typename TConfig > inline void push_back(String<TValue, External<TConfig> > &me, TValue const &_Val);       	// "projects/library/seqan/file/string_external.h"(1888)

//____________________________________________________________________________
// read

template <typename TFile, typename TData> inline void read(TFile & file, TData & data, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(153)
template <typename TFile, typename TData, typename TSize> inline void read(TFile & file, TData & data, TSize limit, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(171)
template <typename TFile, typename TData, typename TSize> void read(TFile & file, TData & data, TSize limit, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(206)
template <typename TFile, typename TData> void read(TFile & file, TData & data, Fasta tag);       	// "projects/library/seqan/file/file_format_fasta.h"(306)
template <typename TFile, typename TData> void read(TFile & file, TData & data, Raw);       	// "projects/library/seqan/file/file_format_raw.h"(191)
template <typename TFile, typename TData, typename TSize> void read(TFile & file, TData & data, TSize limit, Raw);       	// "projects/library/seqan/file/file_format_raw.h"(204)
template <typename TFile, typename TData> void read(TFile & file, TData & data);       	// "projects/library/seqan/file/file_format_raw.h"(307)
template <typename TFile, typename TData, typename TSize> void read(TFile & file, TData & data, TSize limit);       	// "projects/library/seqan/file/file_format_raw.h"(316)
template <typename TValue, typename TSize > inline bool read(FILE* me, TValue *memPtr, TSize const count);       	// "projects/library/seqan/file/file_cstyle.h"(147)
template <typename TFile, typename TGapsSpec> void read(TFile & file, Align<DnaString, TGapsSpec> & data, SAMMeta & meta, SAM);       	// "projects/library/seqan/file/file_format_sam.h"(409)
template <typename TFile> void read(TFile & file, String<Pair<CharString, String<Pair<CharString, CharString> > > > & data, SAM);       	// "projects/library/seqan/file/file_format_sam.h"(423)
template <typename TSpec, typename TValue, typename TSize > inline bool read(File<TSpec> & me, TValue *memPtr, TSize const count);       	// "projects/library/seqan/file/file_base.h"(296)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void read(TFile & file, TData & data, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "projects/library/seqan/file/file_format.h"(200)
template <typename TFile, typename TData, typename TMeta, typename TFormat, typename TSize> inline void read(TFile & file, TData & data, TSize limit, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "projects/library/seqan/file/file_format.h"(211)
template <typename TFile, typename TData> inline void read(TFile & file, TData & data, Genbank);       	// "projects/library/seqan/file/file_format_genbank.h"(170)
template <typename TFile, typename TData, typename TSize> inline void read(TFile & file, TData & data, TSize limit, Genbank);       	// "projects/library/seqan/file/file_format_genbank.h"(188)
template <typename TFile, typename TSource, typename TSpec> void read(TFile & file, Align<TSource, TSpec> & align, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(72)

//____________________________________________________________________________
// readAt

template <typename TValue, typename TSize, typename TPos > inline bool readAt(FILE* me, TValue *memPtr, TSize const count, TPos const fileOfs);       	// "projects/library/seqan/file/file_cstyle.h"(169)
template <typename TFile, typename TValue, typename TSize, typename TPos > inline bool readAt(TFile & me, TValue *memPtr, TSize const count, TPos const fileOfs);       	// "projects/library/seqan/file/file_base.h"(334)
template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize, typename TOffset > inline bool readAt(File< Chained<FILE_SIZE, TFile> > &me, TValue *memPtr, TSize count, TOffset offset);       	// "projects/library/seqan/file/file_array.h"(364)

//____________________________________________________________________________
// readBucket

template <typename TValue, unsigned FILE_COUNT, typename TFile > inline unsigned readBucket( PageBucket<TValue> &b, int pageNo, unsigned pageSize, unsigned dataSize, File< Striped<FILE_COUNT, TFile> > &file);       	// "projects/library/seqan/file/file_page_raid0.h"(134)
template <typename TValue, typename TFile > inline unsigned readBucket(PageBucket<TValue> &b, int pageNo, unsigned pageSize, unsigned dataSize, TFile &file);       	// "projects/library/seqan/file/file_page.h"(513)

//____________________________________________________________________________
// readFeature

template <typename TData, typename TKey, typename TString> inline typename Position<TString>::Type readFeature(TString & str, typename Position<TString>::Type start_pos, TData & data, TKey key, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(372)

//____________________________________________________________________________
// readID

template <typename TFile, typename TString> void readID(TFile & file, TString & id, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(324)
template <typename TFile, typename TString> void readID(TFile & , TString & id, Raw);       	// "projects/library/seqan/file/file_format_raw.h"(219)

//____________________________________________________________________________
// readIDs

template <typename TFile, typename TStringContainer> void readIDs(TFile& file, TStringContainer& ids, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(178)

//____________________________________________________________________________
// readLastPage

template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec, typename TSize > inline bool readLastPage( int pageNo, PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, TSpec> &pf, File< Striped<FILE_COUNT, TFile> > &file, TSize size);       	// "projects/library/seqan/file/file_page_raid0.h"(84)
template <typename TValue, typename TFile, typename TSpec, typename TSize> inline bool readLastPage(int pageNo, PageFrame<TValue, TFile, TSpec> &pf, TFile &file, TSize size);       	// "projects/library/seqan/file/file_page.h"(429)

//____________________________________________________________________________
// readLineType

template <typename TFile, typename TData, typename TKey> inline void readLineType(TFile & file, TData & data, TKey key, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(248)
template <typename TData, typename TValue, typename TSpec, typename TKey> inline void readLineType(String<TValue,TSpec> & meta, TData & data, TKey key, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(305)

//____________________________________________________________________________
// readMeta

template <typename TFile, typename TMeta> inline void readMeta(TFile & file, TMeta & meta, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(194)
template <typename TFile, typename TMeta> void readMeta(TFile & file, TMeta & meta, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(429)
template <typename TFile, typename TMeta> void readMeta(TFile & file, TMeta & meta, Raw);       	// "projects/library/seqan/file/file_format_raw.h"(233)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void readMeta(TFile & file, TMeta & meta, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "projects/library/seqan/file/file_format.h"(235)
template <typename TFile, typename TMeta> inline void readMeta(TFile & file, TMeta & meta, Genbank);       	// "projects/library/seqan/file/file_format_genbank.h"(212)
template <typename TFile, typename TMeta> void readMeta(TFile & file, TMeta & meta, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(223)

//____________________________________________________________________________
// readPage

template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec > inline bool readPage( int pageNo, PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, TSpec> &pf, File< Striped<FILE_COUNT, TFile> > &file);       	// "projects/library/seqan/file/file_page_raid0.h"(40)
template <typename TValue, typename TFile, typename TSpec > inline bool readPage(int pageNo, PageFrame<TValue, TFile, TSpec> &pf, TFile &file);       	// "projects/library/seqan/file/file_page.h"(402)
template <typename TValue, typename TFile, typename TSpec > inline bool readPage(PageFrame<TValue, TFile, Dynamic<TSpec> > &pf, TFile &file);       	// "projects/library/seqan/file/file_page.h"(495)

//____________________________________________________________________________
// readShortID

template <typename TFile, typename TString> void readShortID(TFile & file, TString & id, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(371)

//____________________________________________________________________________
// release

template <typename aRequest > inline void release(FILE*, aRequest &);       	// "projects/library/seqan/file/file_cstyle.h"(221)
template <typename TSpec, typename aRequest > inline void release(File<TSpec> &, aRequest &);       	// "projects/library/seqan/file/file_base.h"(681)

//____________________________________________________________________________
// reopen

template <typename File > inline void reopen(File &, int);       	// "projects/library/seqan/file/file_base.h"(252)

//____________________________________________________________________________
// replace

template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, _ChunkCollector<TSourceHost> const & source, Tag<TExpand> const tag);       	// "projects/library/seqan/file/chunk_collector.h"(473)
template <typename TTargetValue, typename TTargetSpec, typename TSourceHost, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_begin, typename Size< String<TTargetValue, TTargetSpec> >::Type pos_end, _ChunkCollector<TSourceHost> const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const tag);       	// "projects/library/seqan/file/chunk_collector.h"(485)
template <typename TTargetValue, typename TSourceHost, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, _ChunkCollector<TSourceHost> const & source, Tag<TExpand> const tag);       	// "projects/library/seqan/file/chunk_collector.h"(498)
template <typename TTargetValue, typename TSourceHost, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, _ChunkCollector<TSourceHost> const & source, size_t limit, Tag<TExpand> const tag);       	// "projects/library/seqan/file/chunk_collector.h"(510)

//____________________________________________________________________________
// reserve

template <typename TValue, typename TConfig, typename TSize, typename TExpand > inline typename Size< String<TValue, External<TConfig> > >::Type reserve( String<TValue, External<TConfig> > &me, TSize new_capacity, Tag<TExpand> const expand);       	// "projects/library/seqan/file/string_external.h"(1811)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS, typename TExpand > inline void reserve( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> &pageCont, unsigned _Count, Tag<TExpand> const expand);       	// "projects/library/seqan/file/file_page.h"(888)

//____________________________________________________________________________
// resize

template <typename TValue, typename TConfig, typename TNewSize, typename TExpand > inline typename Size< String<TValue, External<TConfig> > >::Type resize( String<TValue, External<TConfig> > &me, TNewSize new_length, Tag<TExpand> const expand);       	// "projects/library/seqan/file/string_external.h"(1784)
template <typename TSize > inline void resize(FILE* me, TSize new_length);       	// "projects/library/seqan/file/file_cstyle.h"(206)
template <typename TSpec, typename TSize > inline void resize(File<TSpec> &me, TSize new_length);       	// "projects/library/seqan/file/file_base.h"(460)
template <__int64 FILE_SIZE, typename TFile, typename TSize > inline void resize(File< Chained<FILE_SIZE, TFile> > &me, TSize new_length);       	// "projects/library/seqan/file/file_array.h"(335)
template <typename TValue, typename TSize > inline void resize(SimpleBuffer<TValue> &me, TSize size);       	// "projects/library/seqan/file/file_page.h"(109)
template <typename TValue, typename TFile, typename TSpec, typename TSize > inline void resize(PageFrame<TValue, TFile, Dynamic<TSpec> > &me, TSize size);       	// "projects/library/seqan/file/file_page.h"(316)
template <typename TValue, typename TFile, unsigned _PageSize, typename TSize > inline void resize(PageFrame<TValue, TFile, Fixed<_PageSize> > & , TSize );       	// "projects/library/seqan/file/file_page.h"(339)
template <typename TPageFrame, unsigned FRAMES, unsigned PRIORITY_LEVELS > inline void resize( PageContainer<TPageFrame, FRAMES, PRIORITY_LEVELS> &pageCont, unsigned _Count);       	// "projects/library/seqan/file/file_page.h"(896)

//____________________________________________________________________________
// rewind

template <typename File > inline void rewind(File &me);       	// "projects/library/seqan/file/file_base.h"(426)

//____________________________________________________________________________
// save

template <typename TValue, typename TConfig > inline bool save(String<TValue, MMap<TConfig> > const &me, const char *fileName, int openMode);       	// "projects/library/seqan/file/string_mmap.h"(671)
template <typename TValue, typename TConfig > inline bool save(String<TValue, MMap<TConfig> > const &me, const char *fileName);       	// "projects/library/seqan/file/string_mmap.h"(679)
template <typename TValue, typename TConfig > inline bool save(String<TValue, MMap<TConfig> > const &me, typename TConfig::TFile file);       	// "projects/library/seqan/file/string_mmap.h"(687)
template <typename TValue, typename TConfig > inline bool save(String<TValue, External<TConfig> > const &me, const char *fileName, int openMode);       	// "projects/library/seqan/file/string_external.h"(1712)
template <typename TValue, typename TConfig > inline bool save(String<TValue, External<TConfig> > const &me, const char *fileName);       	// "projects/library/seqan/file/string_external.h"(1720)
template <typename TValue, typename TConfig > inline bool save(String<TValue, External<TConfig> > const &me, typename TConfig::TFile file);       	// "projects/library/seqan/file/string_external.h"(1728)

//____________________________________________________________________________
// sectorSize

inline unsigned sectorSize(FILE* const &);       	// "projects/library/seqan/file/file_cstyle.h"(120)
template <typename TSpec > inline unsigned sectorSize(File<TSpec> const & );       	// "projects/library/seqan/file/file_base.h"(273)

//____________________________________________________________________________
// seek

template <typename TPos > inline Size<FILE*>::Type seek(FILE* me, TPos const fileOfs, int origin);       	// "projects/library/seqan/file/file_cstyle.h"(127)
template <typename TPos > inline Size<FILE*>::Type seek(FILE* me, TPos const fileOfs);       	// "projects/library/seqan/file/file_cstyle.h"(134)
template <typename TSpec, typename TPos > inline typename Position< File<TSpec> >::Type seek(File<TSpec> &me, TPos const fileOfs, int origin);       	// "projects/library/seqan/file/file_base.h"(382)
template <typename TSpec, typename TPos > inline typename Position< File<TSpec> >::Type seek(File<TSpec> &me, TPos const fileOfs);       	// "projects/library/seqan/file/file_base.h"(395)

//____________________________________________________________________________
// setEOF

template <typename TSpec > inline bool setEOF(File<TSpec> & );       	// "projects/library/seqan/file/file_base.h"(478)

//____________________________________________________________________________
// setPageSize

template <typename TValue, typename TSize > inline void setPageSize(SimpleBuffer<TValue> &me, TSize size);       	// "projects/library/seqan/file/file_page.h"(92)

//____________________________________________________________________________
// setPosition

template <typename TContainer, typename TPos> inline void setPosition(Iter<TContainer, FileReaderIterator> & it, TPos pos);       	// "projects/library/seqan/file/file_filereader.h"(622)

//____________________________________________________________________________
// size

inline Size<FILE*>::Type size(FILE* me);       	// "projects/library/seqan/file/file_cstyle.h"(194)
template <typename TSpec > inline typename Size<File<TSpec> >::Type size(File<TSpec> &me);       	// "projects/library/seqan/file/file_base.h"(442)
template <__int64 FILE_SIZE, typename TFile > __int64 size(File< Chained<FILE_SIZE, TFile> > &me);       	// "projects/library/seqan/file/file_array.h"(325)
template <unsigned _FileCount, typename TFile > __int64 size(File< Striped<_FileCount, TFile> > &me);       	// "projects/library/seqan/file/file_array.h"(330)
template <typename TValue > inline typename Size<SimpleBuffer<TValue> >::Type size(SimpleBuffer<TValue> const &me);       	// "projects/library/seqan/file/file_page.h"(98)
template <typename TValue, typename TFile, unsigned _PageSize > inline typename Size<PageFrame<TValue, TFile, Fixed<_PageSize> > >::Type size(PageFrame<TValue, TFile, Fixed<_PageSize> > & );       	// "projects/library/seqan/file/file_page.h"(322)

//____________________________________________________________________________
// tell

inline Size<FILE*>::Type tell(FILE* me);       	// "projects/library/seqan/file/file_cstyle.h"(140)
template <typename TSpec > inline typename Position< File<TSpec> >::Type tell(File<TSpec> &me);       	// "projects/library/seqan/file/file_base.h"(410)

//____________________________________________________________________________
// value

template <typename TValue, typename TConfig, typename TPos > inline typename Reference<String<TValue, External<TConfig> > >::Type value(String<TValue, External<TConfig> > &me, TPos pos);       	// "projects/library/seqan/file/string_external.h"(1853)
template <typename TValue, typename TConfig, typename TPos > inline typename Reference<String<TValue, External<TConfig> > const>::Type value(String<TValue, External<TConfig> > const &me, TPos pos);       	// "projects/library/seqan/file/string_external.h"(1860)
template <typename TValue, typename TFormat, typename TFile, typename TSpec, typename TPos> inline TValue value(String<TValue, FileReader<TFormat, TFile, TSpec> > & me, TPos pos);       	// "projects/library/seqan/file/file_filereader.h"(321)
template <typename TContainer> inline typename Reference<Iter<TContainer, FileReaderIterator> >::Type value(Iter<TContainer, FileReaderIterator> & it);       	// "projects/library/seqan/file/file_filereader.h"(567)
template <typename TContainer> inline typename Reference<Iter<TContainer, FileReaderIterator> >::Type value(Iter<TContainer, FileReaderIterator> const & it);       	// "projects/library/seqan/file/file_filereader.h"(573)

//____________________________________________________________________________
// waitFor

inline bool waitFor(aDummyRequest &);       	// "projects/library/seqan/file/file_base.h"(668)
template <typename TTime > inline bool waitFor(aDummyRequest &, TTime);       	// "projects/library/seqan/file/file_base.h"(674)
template <typename TValue, typename TFile, typename TSpec > inline bool waitFor(PageFrame<TValue, TFile, TSpec> &pf);       	// "projects/library/seqan/file/file_page.h"(457)
template <typename TValue, typename TFile, typename TSpec, typename TTime > inline bool waitFor(PageFrame<TValue, TFile, TSpec> &pf, TTime timeOut);       	// "projects/library/seqan/file/file_page.h"(469)

//____________________________________________________________________________
// waitForAll

template <typename TValue, typename TConfig > inline void waitForAll(String<TValue, MMap<TConfig> > &);       	// "projects/library/seqan/file/string_mmap.h"(268)
template <typename TValue, typename TConfig > inline void waitForAll(String<TValue, External<TConfig> > &me);       	// "projects/library/seqan/file/string_external.h"(1514)

//____________________________________________________________________________
// write

template <typename TFile, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec>& align, CGViz);       	// "projects/library/seqan/file/file_format_cgviz.h"(190)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec> & align, TStringContainer& ids, CGViz);       	// "projects/library/seqan/file/file_format_cgviz.h"(198)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec>* align, TStringContainer & ids, CGViz);       	// "projects/library/seqan/file/file_format_cgviz.h"(206)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec, typename TMeta> void write(TFile & file, Align<TSource, TSpec> & align, TStringContainer& ids, TMeta &, CGViz);       	// "projects/library/seqan/file/file_format_cgviz.h"(214)
template <typename TFile, typename TData> inline void write(TFile & file, TData & data, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(465)
template <typename TFile, typename TData, typename TMeta> inline void write(TFile & file, TData & data, TMeta & meta, Embl);       	// "projects/library/seqan/file/file_format_embl.h"(531)
template <typename TFile, typename TString, typename TData, typename TMeta> void write(TFile & file, TData & data, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(521)
template <typename TFile, typename TString, typename TData> void write(TFile & file, TData & data, TString & id, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(534)
template <typename TFile, typename TString, typename TDataValue> void write(TFile & file, TDataValue * data, TString & id, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(547)
template <typename TFile, typename TString, typename TData, typename TMeta> void write(TFile & file, TData & data, TString & id, TMeta &, Fasta);       	// "projects/library/seqan/file/file_format_fasta.h"(562)
template <typename TFile, typename TData> void write(TFile & file, TData const & data, Raw);       	// "projects/library/seqan/file/file_format_raw.h"(266)
template <typename TFile, typename TData, typename TString> void write(TFile & file, TData const & data, TString const &, Raw);       	// "projects/library/seqan/file/file_format_raw.h"(279)
template <typename TFile, typename TString, typename TData, typename TMeta> void write(TFile & file, TData const & data, TString const &, TMeta const &, Raw);       	// "projects/library/seqan/file/file_format_raw.h"(293)
template <typename TFile, typename TData> void write(TFile & file, TData & data);       	// "projects/library/seqan/file/file_format_raw.h"(327)
template <typename TFile, typename TData> void write(TFile & file, TData const & data);       	// "projects/library/seqan/file/file_format_raw.h"(335)
template <typename TValue, typename TSize > inline bool write(FILE* me, TValue const *memPtr, TSize const count);       	// "projects/library/seqan/file/file_cstyle.h"(158)
template <typename TFile, typename TGapsSpec, typename TIDString, typename TSAMSpec> inline void write(TFile & target, Align<DnaString, TGapsSpec> const & source, TIDString const & myId, Tag<TagSBAM_<TSAMSpec> > );       	// "projects/library/seqan/file/file_format_sam.h"(120)
template <typename TFile, typename TGapsSpec, typename TIDString, typename TSAMSpec> inline void write(TFile & target, Align<DnaString, TGapsSpec> const & source, const int refPosition, TIDString const & myId, Tag<TagSBAM_<TSAMSpec> > );       	// "projects/library/seqan/file/file_format_sam.h"(132)
template <typename TFile, typename TGapsSpec, typename TIDString, typename TMeta, typename TSAMSpec> inline void write(TFile & target, Align<DnaString, TGapsSpec> const & source, const int refPosition, const String<TMeta> & metas, const String<unsigned int> & IDs, TIDString const &, Tag<TagSBAM_<TSAMSpec> > );       	// "projects/library/seqan/file/file_format_sam.h"(170)
template <typename TFile> inline void write(TFile & target, const String<Pair<CharString, String<Pair<CharString, CharString> > > > & meta, const Tag<TagSBAM_<_SAM> > & sam);       	// "projects/library/seqan/file/file_format_sam.h"(557)
template <typename TSpec, typename TValue, typename TSize > inline bool write(File<TSpec> & me, TValue const *memPtr, TSize const count);       	// "projects/library/seqan/file/file_base.h"(315)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void write(TFile & file, TData & data, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "projects/library/seqan/file/file_format.h"(293)
template <typename TFile, typename TData, typename TMeta, typename TFormat> inline void write(TFile & file, TData & data, TMeta & meta, FileFormat<TFile, TData, TMeta, TFormat> const & file_format);       	// "projects/library/seqan/file/file_format.h"(303)
template <typename TFile, typename TData> inline void write(TFile & file, TData & data, Genbank);       	// "projects/library/seqan/file/file_format_genbank.h"(292)
template <typename TFile, typename TData, typename TMeta> inline void write(TFile & file, TData & data, TMeta & meta, Genbank);       	// "projects/library/seqan/file/file_format_genbank.h"(348)
template <typename TFile, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec>& align, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(284)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec> & align, TStringContainer& ids, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(292)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec> void write(TFile & file, Align<TSource, TSpec>* align, TStringContainer & ids, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(300)
template <typename TFile, typename TStringContainer, typename TSource, typename TSpec, typename TMeta> void write(TFile & file, Align<TSource, TSpec> & align, TStringContainer& ids, TMeta &, FastaAlign);       	// "projects/library/seqan/file/file_format_fasta_align.h"(308)

//____________________________________________________________________________
// writeAt

template <typename TValue, typename TSize, typename TPos > inline bool writeAt(FILE* me, TValue const *memPtr, TSize const count, TPos const fileOfs);       	// "projects/library/seqan/file/file_cstyle.h"(182)
template <typename TFile, typename TValue, typename TSize, typename TPos > inline bool writeAt(TFile & me, TValue const *memPtr, TSize const count, TPos const fileOfs);       	// "projects/library/seqan/file/file_base.h"(355)
template <__int64 FILE_SIZE, typename TFile, typename TValue, typename TSize, typename TOffset > inline bool writeAt(File< Chained<FILE_SIZE, TFile> > &me, TValue const *memPtr, TSize count, TOffset offset);       	// "projects/library/seqan/file/file_array.h"(378)

//____________________________________________________________________________
// writeBucket

template <typename TValue, unsigned FILE_COUNT, typename TFile > inline bool writeBucket( PageBucket<TValue> &b, int pageNo, unsigned pageSize, File< Striped<FILE_COUNT, TFile> > &file);       	// "projects/library/seqan/file/file_page_raid0.h"(158)
template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec > inline bool writeBucket( PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, Dynamic<TSpec> > &pf, unsigned &pageOfs, File< Striped<FILE_COUNT, TFile> > &file);       	// "projects/library/seqan/file/file_page_raid0.h"(179)
template <typename TValue, typename TFile > inline bool writeBucket(PageBucket<TValue> &b, int pageNo, unsigned pageSize, TFile &file);       	// "projects/library/seqan/file/file_page.h"(532)
template <typename TValue, typename TFile, typename TSpec > inline bool writeBucket(PageFrame<TValue, TFile, Dynamic<TSpec> > &pf, unsigned &pageOfs, TFile &file);       	// "projects/library/seqan/file/file_page.h"(549)

//____________________________________________________________________________
// writeLastPage

template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec, typename TSize > inline bool writeLastPage( PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, TSpec> &pf, int pageNo, File< Striped<FILE_COUNT, TFile> > &file, TSize size);       	// "projects/library/seqan/file/file_page_raid0.h"(106)
template <typename TValue, typename TFile, typename TSpec, typename TSize > inline bool writeLastPage(PageFrame<TValue, TFile, TSpec> &pf, int pageNo, TFile &file, TSize size);       	// "projects/library/seqan/file/file_page.h"(443)

//____________________________________________________________________________
// writePage

template <typename TValue, unsigned FILE_COUNT, typename TFile, typename TSpec > inline bool writePage( PageFrame<TValue, File< Striped<FILE_COUNT, TFile> >, TSpec> &pf, int pageNo, File< Striped<FILE_COUNT, TFile> > &file);       	// "projects/library/seqan/file/file_page_raid0.h"(62)
template <typename TValue, typename TFile, typename TSpec > inline bool writePage(PageFrame<TValue, TFile, TSpec> &pf, int pageNo, TFile &file);       	// "projects/library/seqan/file/file_page.h"(416)
template <typename TValue, typename TFile, typename TSpec > inline bool writePage(PageFrame<TValue, TFile, Dynamic<TSpec> > &pf, TFile &file);       	// "projects/library/seqan/file/file_page.h"(504)

//____________________________________________________________________________
// write_header_line

template <typename TFile> inline void write_header_line(TFile & target, const CharString & cat, const String<Pair<CharString, CharString> > & meta, Tag<TagSBAM_<_SAM> > );       	// "projects/library/seqan/file/file_format_sam.h"(533)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

