 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_CONSENSUS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_CONSENSUS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Bayesian_

struct Bayesian_;       	// "projects/library/seqan/consensus/consensus_base.h"(65)

//____________________________________________________________________________
// ConsensusOptions

struct ConsensusOptions;       	// "projects/library/seqan/consensus/consensus_base.h"(77)

//____________________________________________________________________________
// ConsensusScore_

struct ConsensusScore_;       	// "projects/library/seqan/consensus/consensus_score.h"(38)

//____________________________________________________________________________
// FastaReadFormat_

struct FastaReadFormat_;       	// "projects/library/seqan/consensus/consensus_base.h"(1072)

//____________________________________________________________________________
// FractionalScore_

struct FractionalScore_;       	// "projects/library/seqan/consensus/consensus_score.h"(43)

//____________________________________________________________________________
// Majority_Vote_

struct Majority_Vote_;       	// "projects/library/seqan/consensus/consensus_base.h"(57)

//____________________________________________________________________________
// Overlap_Library_

struct Overlap_Library_;       	// "projects/library/seqan/consensus/consensus_base.h"(37)

//____________________________________________________________________________
// WeightedConsensusScore

template <typename TScore1, typename TScore2> struct WeightedConsensusScore;       	// "projects/library/seqan/consensus/consensus_score.h"(49)

//____________________________________________________________________________
// _LessPair

template <typename TSize> struct _LessPair;       	// "projects/library/seqan/consensus/consensus_library.h"(78)

//____________________________________________________________________________
// _LessTripel

template <typename TSize> struct _LessTripel;       	// "projects/library/seqan/consensus/consensus_library.h"(89)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Bayesian

typedef Tag<Bayesian_> const Bayesian;       	// "projects/library/seqan/consensus/consensus_base.h"(66)

//____________________________________________________________________________
// ConsensusScore

typedef Tag<ConsensusScore_> const ConsensusScore;       	// "projects/library/seqan/consensus/consensus_score.h"(39)

//____________________________________________________________________________
// FastaReadFormat

typedef Tag<FastaReadFormat_> const FastaReadFormat;       	// "projects/library/seqan/consensus/consensus_base.h"(1073)

//____________________________________________________________________________
// FractionalScore

typedef Tag<FractionalScore_> const FractionalScore;       	// "projects/library/seqan/consensus/consensus_score.h"(44)

//____________________________________________________________________________
// Majority_Vote

typedef Tag<Majority_Vote_> const Majority_Vote;       	// "projects/library/seqan/consensus/consensus_base.h"(58)

//____________________________________________________________________________
// Overlap_Library

typedef Tag<Overlap_Library_> const Overlap_Library;       	// "projects/library/seqan/consensus/consensus_base.h"(38)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __countLetters

template <typename TValue, typename TSpec, typename TCounters, typename TSize, typename TAlphabet> inline void __countLetters(String<TValue, TSpec> const& mat, TCounters& counterValues, TSize alignDepth, TAlphabet);       	// "projects/library/seqan/consensus/consensus_base.h"(713)

//____________________________________________________________________________
// __getAlignmentStatistics

template <typename TSize, typename TCargo1, typename TCargo2> inline void __getAlignmentStatistics(Nothing&, TSize, TSize, TSize, TCargo1, TCargo2);       	// "projects/library/seqan/consensus/consensus_library.h"(37)
template <typename TValue, typename TSpec, typename TSize, typename TCargo1, typename TCargo2> inline void __getAlignmentStatistics(String<TValue, TSpec>& dist, TSize i, TSize j, TSize nseq, TCargo1, TCargo2 quality);       	// "projects/library/seqan/consensus/consensus_library.h"(51)
template <typename TCargo, typename TSpec, typename TSize, typename TCargo1, typename TCargo2> inline void __getAlignmentStatistics(Graph<Undirected<TCargo, TSpec> >& dist, TSize i, TSize j, TSize, TCargo1, TCargo2 quality);       	// "projects/library/seqan/consensus/consensus_library.h"(66)

//____________________________________________________________________________
// _convertSimpleReadFile

template <typename TFile, typename TSpec, typename TConfig, typename TFilePath> inline bool _convertSimpleReadFile(TFile& file, FragmentStore<TSpec, TConfig>& fragStore, TFilePath& filePath, bool moveToFront);       	// "projects/library/seqan/consensus/consensus_base.h"(1259)

//____________________________________________________________________________
// _loadContigReads

template <typename TValue, typename TStrSpec, typename TPosPair, typename TStringSpec, typename TSpec, typename TConfig, typename TId> inline void _loadContigReads(StringSet<TValue, Owner<TStrSpec> >& strSet, String<TPosPair, TStringSpec>& startEndPos, FragmentStore<TSpec, TConfig> const& fragStore, TId const contigId);       	// "projects/library/seqan/consensus/consensus_base.h"(143)

//____________________________________________________________________________
// _writeCeleraCgb

template <typename TFile, typename TSpec, typename TConfig> inline void _writeCeleraCgb(TFile& target, FragmentStore<TSpec, TConfig>& fragStore);       	// "projects/library/seqan/consensus/consensus_base.h"(1718)

//____________________________________________________________________________
// _writeCeleraFrg

template <typename TFile, typename TSpec, typename TConfig> inline void _writeCeleraFrg(TFile& target, FragmentStore<TSpec, TConfig>& fragStore);       	// "projects/library/seqan/consensus/consensus_base.h"(1636)

//____________________________________________________________________________
// appendSegmentMatches

template <typename TString, typename TSpec, typename TId, typename TDiagList, typename TBegEndPos, typename TScore, typename TSize, typename TSegmentMatches, typename TScoreValues, typename TDistance> inline void appendSegmentMatches(StringSet<TString, TSpec> const& str, String<Pair<TId, TId> > const& pList, TDiagList const& dList, TBegEndPos const& begEndPos, TScore const& score_type, TSize thresholdMatchlength, TSize thresholdQuality, TSize maxOvl, TSegmentMatches& matches, TScoreValues& scores, TDistance& dist, Overlap_Library);       	// "projects/library/seqan/consensus/consensus_library.h"(371)

//____________________________________________________________________________
// assignGappedConsensus

template <typename TSpec, typename TConfig, typename TGappedConsensus, typename TSize> inline void assignGappedConsensus(FragmentStore<TSpec, TConfig>& fragStore, TGappedConsensus& gappedCons, TSize contigId);       	// "projects/library/seqan/consensus/consensus_base.h"(364)

//____________________________________________________________________________
// assignProfile

template <typename TValue, typename TString> inline void assignProfile(Score<TValue, ConsensusScore>& me, TString const& profile);       	// "projects/library/seqan/consensus/consensus_score.h"(85)
template <typename TValue, typename TString> inline void assignProfile(Score<TValue, FractionalScore>& me, TString const& profile);       	// "projects/library/seqan/consensus/consensus_score.h"(197)
template <typename TValue, typename TScore1, typename TScore2, typename TString> inline void assignProfile(Score<TValue, WeightedConsensusScore<TScore1, TScore2> >& me, TString const& profile);       	// "projects/library/seqan/consensus/consensus_score.h"(303)

//____________________________________________________________________________
// consensusAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TSize, typename TConfigOptions> inline void consensusAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& gOut, String<Pair<TSize, TSize> >& begEndPos, TConfigOptions const& consOpt);       	// "projects/library/seqan/consensus/consensus_base.h"(411)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSize> inline void consensusAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& gOut, String<Pair<TSize, TSize> >& begEndPos);       	// "projects/library/seqan/consensus/consensus_base.h"(466)

//____________________________________________________________________________
// consensusCalling

template <typename TValue, typename TSpec, typename TGappedCons, typename TAlignDepth, typename TAlphabet> inline void consensusCalling(String<TValue, TSpec> const& mat, TGappedCons& gappedConsensus, TAlignDepth maxCoverage, TAlphabet, Bayesian);       	// "projects/library/seqan/consensus/consensus_base.h"(758)
template <typename TFragSpec, typename TConfig, typename TContigId> inline void consensusCalling(FragmentStore<TFragSpec, TConfig>& fragStore, TContigId contigId, Bayesian);       	// "projects/library/seqan/consensus/consensus_base.h"(960)
template <typename TValue, typename TSpec, typename TGappedCons, typename TAlignDepth, typename TAlphabet> inline void consensusCalling(String<TValue, TSpec> const& mat, TGappedCons& gappedConsensus, TAlignDepth maxCoverage, TAlphabet, Majority_Vote);       	// "projects/library/seqan/consensus/consensus_base.h"(992)
template <typename TFragSpec, typename TConfig, typename TContigId> inline void consensusCalling(FragmentStore<TFragSpec, TConfig>& fragStore, TContigId contigId, Majority_Vote);       	// "projects/library/seqan/consensus/consensus_base.h"(1036)

//____________________________________________________________________________
// convertAlignment

template <typename TSpec, typename TConfig, typename TMatrix, typename TSize2, typename TSize, typename TReadSlot> inline bool convertAlignment(FragmentStore<TSpec, TConfig>& fragStore, TMatrix& mat, TSize2 contigId, TSize& coverage, TReadSlot& slot);       	// "projects/library/seqan/consensus/consensus_base.h"(192)
template <typename TSpec, typename TConfig, typename TMatrix, typename TSize2, typename TSize> inline bool convertAlignment(FragmentStore<TSpec, TConfig>& fragStore, TMatrix& mat, TSize2 contigId, TSize& coverage);       	// "projects/library/seqan/consensus/consensus_base.h"(305)
template <typename TSpec, typename TConfig, typename TMatrix> inline bool convertAlignment(FragmentStore<TSpec, TConfig>& fragStore, TMatrix& mat);       	// "projects/library/seqan/consensus/consensus_base.h"(317)

//____________________________________________________________________________
// getGappedConsensus

template <typename TSpec, typename TConfig, typename TGappedConsensus, typename TSize> inline void getGappedConsensus(FragmentStore<TSpec, TConfig>& fragStore, TGappedConsensus& gappedConsensus, TSize contigId);       	// "projects/library/seqan/consensus/consensus_base.h"(331)

//____________________________________________________________________________
// insertGap

template <typename TPos, typename TGapAnchor, typename TSpec, typename TGapPos> inline int insertGap(AlignedReadStoreElement<TPos, TGapAnchor, TSpec>& alignedRead, TGapPos const gapPos);       	// "projects/library/seqan/consensus/consensus_realign.h"(70)
template <typename TAlignedReads, typename TSpec, typename TGapPos> inline int insertGap(String<TAlignedReads, TSpec>& alignedReadStore, TGapPos const gapPos);       	// "projects/library/seqan/consensus/consensus_realign.h"(130)

//____________________________________________________________________________
// reAlign

template <typename TFragSpec, typename TConfig, typename TAlignedRead, typename TSpec, typename TConsensus, typename TScore, typename TMethod, typename TBandwidth> inline void reAlign(FragmentStore<TFragSpec, TConfig>& fragStore, String<TAlignedRead, TSpec>& contigReads, TConsensus& consensus, TScore& consScore, TMethod const rmethod, TBandwidth const bandwidth, bool includeReference);       	// "projects/library/seqan/consensus/consensus_realign.h"(182)
template <typename TSpec, typename TConfig, typename TScore, typename TId, typename TMethod, typename TBandwidth> inline void reAlign(FragmentStore<TSpec, TConfig>& fragStore, TScore& consScore, TId const contigId, TMethod const rmethod, TBandwidth const bandwidth, bool includeReference);       	// "projects/library/seqan/consensus/consensus_realign.h"(455)
template <typename TSpec, typename TConfig, typename TScore, typename TId, typename TBandwidth> inline void reAlign(FragmentStore<TSpec, TConfig>& fragStore, TScore& consScore, TId const contigId, TBandwidth const bandwidth, bool includeReference);       	// "projects/library/seqan/consensus/consensus_realign.h"(640)

//____________________________________________________________________________
// removeGap

template <typename TPos, typename TGapAnchor, typename TSpec, typename TGapPos> inline void removeGap(AlignedReadStoreElement<TPos, TGapAnchor, TSpec>& alignedRead, TGapPos const gapPos);       	// "projects/library/seqan/consensus/consensus_realign.h"(33)
template <typename TAlignedReads, typename TSpec, typename TGapPos> inline void removeGap(String<TAlignedReads, TSpec>& alignedReadStore, TGapPos const gapPos);       	// "projects/library/seqan/consensus/consensus_realign.h"(54)

//____________________________________________________________________________
// score

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, ConsensusScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &, TSeq2 const &seq2);       	// "projects/library/seqan/consensus/consensus_score.h"(163)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, FractionalScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "projects/library/seqan/consensus/consensus_score.h"(268)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "projects/library/seqan/consensus/consensus_score.h"(367)

//____________________________________________________________________________
// scoreConsensus

template <typename TConsensus> inline int scoreConsensus(TConsensus& consensus);       	// "projects/library/seqan/consensus/consensus_realign.h"(147)

//____________________________________________________________________________
// scoreGapExtendHorizontal

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, ConsensusScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/consensus/consensus_score.h"(114)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, FractionalScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &);       	// "projects/library/seqan/consensus/consensus_score.h"(221)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "projects/library/seqan/consensus/consensus_score.h"(318)

//____________________________________________________________________________
// scoreGapExtendVertical

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, ConsensusScore> const &, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/consensus/consensus_score.h"(139)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, FractionalScore> const &, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/consensus/consensus_score.h"(245)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const & seq1, TSeq2 const & seq2);       	// "projects/library/seqan/consensus/consensus_score.h"(343)

//____________________________________________________________________________
// scoreGapOpenHorizontal

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, ConsensusScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/consensus/consensus_score.h"(126)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, FractionalScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &);       	// "projects/library/seqan/consensus/consensus_score.h"(233)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "projects/library/seqan/consensus/consensus_score.h"(330)

//____________________________________________________________________________
// scoreGapOpenVertical

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, ConsensusScore> const &, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/consensus/consensus_score.h"(151)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, FractionalScore> const &, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/consensus/consensus_score.h"(257)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const & seq1, TSeq2 const & seq2);       	// "projects/library/seqan/consensus/consensus_score.h"(355)

//____________________________________________________________________________
// selectPairs

template <typename TString, typename TSpec, typename TBegEndPos, typename TSize, typename TPairList, typename TPos, typename TSpec2> inline void selectPairs(StringSet<TString, TSpec> const& str, TBegEndPos const& begEndPos, TSize bandwidth, TPairList& pList, String<Pair<TPos, TPos>, TSpec2>& dList);       	// "projects/library/seqan/consensus/consensus_library.h"(106)

//____________________________________________________________________________
// selectPairsIndel

template <typename TString, typename TSpec, typename TBegEndPos, typename TSize, typename TPairList, typename TPos, typename TSpec2> inline void selectPairsIndel(StringSet<TString, TSpec> const& str, TBegEndPos const& begEndPos, TSize lookAround, TPairList& pList, String<Pair<TPos, TPos>, TSpec2>& dList);       	// "projects/library/seqan/consensus/consensus_library.h"(326)

//____________________________________________________________________________
// updateContig

template <typename TFragSpec, typename TConfig, typename TStringSet, typename TCargo, typename TSpec, typename TContigId> inline void updateContig(FragmentStore<TFragSpec, TConfig>& fragStore, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TContigId contigId);       	// "projects/library/seqan/consensus/consensus_base.h"(479)

//____________________________________________________________________________
// write

template <typename TFile, typename TSpec, typename TConfig> inline void write(TFile & file, FragmentStore<TSpec, TConfig>& fragStore, FastaReadFormat);       	// "projects/library/seqan/consensus/consensus_base.h"(1082)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

