/***************************************************************************
                          page.cpp  -  description
                             -------------------
    begin                : Sat Apr 7 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "page.h"
#include "page.moc"
#include "pageitem.h"
#include "serializer.h"
#include "scribusXml.h"
#include <qapplication.h>
#include <qcolor.h>
#include <qrect.h>
#include <qpointarray.h>
#include <qregion.h>
#include <qcursor.h>
#include <qimage.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qcstring.h>
#include <qdragobject.h>
#include <qurl.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <qbitmap.h>
#include <qwmatrix.h>
#include <qpopupmenu.h>
#ifdef HAVE_TIFF
	#include <tiffio.h>
#endif
#ifdef HAVE_CMS
	#include <lcms.h>
#endif
extern ProfilesL InputProfiles;
extern QPixmap loadIcon(QString nam);
extern float Cwidth(ScribusDoc *doc, QPainter *p, QString name, QString ch, int Siz);
#ifdef HAVE_CMS
QImage ProofPict(QImage *Im, QString Prof, int Rend, cmsHPROFILE emPr=0);
#else
QImage ProofPict(QImage *Im, QString Prof, int Rend);
#endif
// #include <iostream.h>

Page::Page(QWidget *pa, int x, int y, int b, int h, ScribusDoc *doc, QScrollView *view)
				 : QWidget(pa)
{
	resize(b, h);
	move(x, y);
	setBackgroundColor(doc->papColor);
	doku = doc;
	Anz = view;
	Items.clear();
	Items.setAutoDelete(true);
	Margins.Top = 9;
	Margins.Left = 9;
	Margins.Right = 9;
	Margins.Bottom = 40;
	SelItem.clear();
	ClRe = -1;
	ClRe2 = -1;
	setAcceptDrops(true);
	emit DocChanged();
	doku->DragP = false;
	Imoved = false;
	Mpressed = false;
	HaveSelRect = false;
	PageNam = "";
	LeftPg = false;
	Magnify = false;
}

Page::~Page(){
}

void Page::dragEnterEvent(QDragEnterEvent *e)
{
	QString text;
	e->accept(QTextDrag::canDecode(e));
	if (QTextDrag::decode(e, text))
		{
		setActiveWindow();
		raise();
		SeleItemPos(e->pos());
		}
}

void Page::dragMoveEvent(QDragMoveEvent *e)
{
	QString text;
	PageItem *b;
	bool img;
	e->accept(QTextDrag::canDecode(e));
	if (QTextDrag::decode(e, text))
		{
		QUrl ur(text);
		QFileInfo fi = QFileInfo(ur.path());
		QString ext = fi.extension(false).lower();
		img = ((ext=="eps")||(ext=="ps")||(ext=="png")||(ext=="gif")||(ext=="jpg")||(ext=="xpm"));
		if (!SeleItemPos(e->pos()))
			{
			if (SelItem.count() != 0)
				Deselect();
			}
		else
			{
			b = Items.at(*SelItem.at(0));
			if (img)
				{
				if (b->PType != 2)
					Deselect();
				}
			else
				{
				if (b->PType != 4)
					Deselect();
				}
			}
		}
}

void Page::dropEvent(QDropEvent *e)
{
	QString text;
	PageItem *b;
	bool img;
	struct Pti *hg;
	uint a;
	int re;
	if (QTextDrag::decode(e, text))
		{
		QUrl ur(text);
		QFileInfo fi = QFileInfo(ur.path());
		QString ext = fi.extension(false).lower();
		img = ((ext=="eps")||(ext=="ps")||(ext=="png")||(ext=="gif")||(ext=="jpg")||(ext=="xpm"));
		if (SeleItemPos(e->pos()))
			{
			b = Items.at(*SelItem.at(0));
			if (b->PType == 2)
				{
				if ((fi.exists()) && (img))
					{
    			LoadPict(ur.path(), b->ItemNr);
    			update();
					}
				}
			if (b->PType == 4)
				{
				if ((b->BackBox != 0) && (b->Ptext.count() == 0))
					return;
				if ((fi.exists()) && (!img) && (fi.size() < 500000))
					{
  				Serializer *ss = new Serializer(ur.path());
  				if (ss->Read())
  					{
  					ss->GetText(b, b->Ausrich);
						emit DocChanged();
  					}
  				delete ss;
    			update();
    			}
				else
					{
					slotDoCurs(false);
					slotSetCurs(e->pos().x(), e->pos().y());
					if (text.startsWith("<SCRIBUSELEM>"))
						return;
					for (a=0; a<text.length(); a++)
						{
						hg = new Pti;
						hg->ch = text.at(a);
						if (hg->ch == QChar(10)) { hg->ch = QChar(13); }
						if (hg->ch == QChar(9)) { hg->ch = " "; }
						hg->cfont = b->IFont;
						hg->csize = b->ISize;
						hg->ccolor = b->Pcolor2;
						hg->cextra = 0;
						hg->cshade = b->Shade2;
						hg->cselect = false;
						hg->cstyle = 0;
						hg->cab = 0;
						hg->xp = 0;
						hg->yp = 0;
						b->Ptext.insert(b->CPos, hg);
 						b->CPos += 1;
						}
					b->Dirty = true;
					emit DocChanged();
					update();
					}
				}
			}
		else
			{
			if ((fi.exists()) && (!img))
				{
				emit LoadElem(QString(ur.path()), qRound(e->pos().x()/doku->Scale), qRound(e->pos().y()/doku->Scale), true, false);
				}
			else
				{
				if (doku->DraggedElem != 0)
					{			
					QPopupMenu *pmen = new QPopupMenu();
					qApp->setOverrideCursor(QCursor(ArrowCursor), true);
					pmen->insertItem(tr("Copy Here"));
					pmen->insertItem(tr("Move Here"));
					pmen->insertItem(tr("Cancel"));
					re = pmen->indexOf(pmen->exec(QCursor::pos()));
					delete pmen;
					if (re == 1)
						{
						doku->DraggedElem->OwnPage->SelItem.clear();
						for (uint dre=0; dre<doku->DragElements.count(); dre++)
							{
							doku->DraggedElem->OwnPage->SelItem.append(&doku->DragElements[dre]);
							}
						doku->DraggedElem->OwnPage->DeleteItem();
						}
					}
				else
					re = 1;
				if ((!img) && ((re == 0) || (re == 1)))
					emit LoadElem(QString(text), qRound(e->pos().x()/doku->Scale), qRound(e->pos().y()/doku->Scale), false, false);
				doku->DraggedElem = 0;
				doku->DragElements.clear();
				}
			}
		}
}

void Page::DrawPageMarks(QPaintEvent *e)
{
	QPainter p;
	float b;
	p.begin(this);
	if (doku->Marks)
		{
		p.setPen(doku->margColor);
		if (doku->RandFarbig)
			{
			p.setBrush(doku->margColor);
			p.drawRect(0, 0, width(), Margins.Top*doku->Scale);
			p.drawRect(0, Margins.Top*doku->Scale, Margins.Left*doku->Scale, height()-Margins.Top*doku->Scale);
			p.drawRect(Margins.Left*doku->Scale, height()-Margins.Bottom*doku->Scale,
							 	width()-Margins.Right*doku->Scale-Margins.Left*doku->Scale,
							 	Margins.Bottom*doku->Scale);
			p.drawRect(width()-Margins.Right*doku->Scale, Margins.Top*doku->Scale,
								Margins.Right*doku->Scale, height());
			}
		p.setPen(doku->margColor);
		p.drawLine(0, int(Margins.Top*doku->Scale), width(), int(Margins.Top*doku->Scale));
		p.drawLine(0, height()-int(Margins.Bottom*doku->Scale), width(), height()-int(Margins.Bottom*doku->Scale));
		p.drawLine(int(Margins.Left*doku->Scale), 0, int(Margins.Left*doku->Scale), height());
		p.drawLine(width()-int(Margins.Right*doku->Scale), 0, width()-int(Margins.Right*doku->Scale), height());
		}
	if (doku->Raster)
		{
		p.setClipRect(e->rect());
		int stx = e->rect().x();
		int endx = e->rect().x()+e->rect().width();
		int sty = e->rect().y();
		int endy = e->rect().y()+e->rect().height();
		if (doku->Scale > 0.49)
			{
			float i,start;
			i=doku->majorGrid*doku->Scale;
			p.setPen(QPen(doku->majorColor, 1, SolidLine, FlatCap, MiterJoin));
			start=floor(sty/i);
			start*=i;
			for (b = start; b < endy; b+=i)
 					p.drawLine(0, b, width(), b);
			start=floor(stx/i);
			start*=i;
			for (b = start; b <= endx; b+=i)
					p.drawLine(b, 0, b, height());
			i=doku->minorGrid*doku->Scale;
			p.setPen(QPen(doku->minorColor, 1, DotLine, FlatCap, MiterJoin));
			start=floor(sty/i);
			start*=i;
			for (b = start; b < endy; b+=i)
					p.drawLine(0, b, width(), b);
			start=floor(stx/i);
			start*=i;
			for (b = start; b <= endx; b+=i)
 					p.drawLine(b, 0, b, height());
 			}
 		}
	p.setPen(QColor(0, 0, 0));
	p.setBrush(NoBrush);
	p.drawRect(0, 0, width(), height());
 	p.end();
}

void Page::DrawPageItems(QPaintEvent *e)
{
	QPainter p;
	uint a;
	PageItem* b;
	ScribusView* vi = (ScribusView*)Anz;
	if (MPageNam != "")
		{
		Page* Mp = vi->MasterPages.at(vi->MasterNames[MPageNam]);
		QWidget* Opa;
		Page* Opa2;
		if (Mp->Items.count() != 0)
			{
			for (a = 0; a < Mp->Items.count(); a++)
				{
				b = Mp->Items.at(a);
				Opa = b->Parent;
				Opa2 = b->OwnPage;
				b->Parent = this;
				b->OwnPage = this;
				b->paintObj(e->rect());
				b->Parent = Opa;
				b->OwnPage = Opa2;
				}
			}
		}
	if (Items.count() != 0)
		{
		for (a = 0; a < Items.count(); a++)
			{
			Items.at(a)->Redrawn = false;
			}
		for (a = 0; a < Items.count(); a++)
			{
			QPainter p;
			p.begin(this);
			Transform(Items.at(a), &p);
			QRegion apr = QRegion(p.xForm(Items.at(a)->Clip));
			p.end();
			if (e->rect().intersects(apr.boundingRect()))
				{
				if (!Items.at(a)->Redrawn)
					{
					if (Items.at(a)->PType == 4)
						Items.at(a)->paintObj(e->rect());
					else
						Items.at(a)->paintObj(e->rect());
					Items.at(a)->Redrawn = true;
					}
				if ((doku->EditClip) && (Items.at(a)->Select))
					MarkClip(Items.at(a));
				if ((doku->AppMode == 7) && (Items.at(a)->Select))
					slotDoCurs(true);
				}
			}
		for (a = 0; a < Items.count(); a++)
			{
			Items.at(a)->Redrawn = false;
			}
		}
}

/** No descriptions */
void Page::paintEvent(QPaintEvent *e)
{
	if (doku->Before)
		DrawPageMarks(e);
	DrawPageItems(e);
	if (!doku->Before)
		DrawPageMarks(e);
}

QRegion Page::ViewReg()
{
	int cx = Anz->contentsX() - Anz->childX(doku->ActPage->parentWidget());
	int cy = Anz->contentsY() - Anz->childY(doku->ActPage->parentWidget());
	int cw = Anz->visibleWidth();
	int ch = Anz->visibleHeight();
	return QRegion(QRect(cx, cy, cw, ch));
}

void Page::Transform(PageItem *b, QPainter *p)
{
	p->translate(int(b->Xpos*doku->Scale), int(b->Ypos*doku->Scale));
	p->scale(doku->Scale, doku->Scale);
	p->rotate(b->Rot);
}

void Page::TransformM(PageItem *b, QPainter *p)
{
	if (b->flippedH % 2 != 0)
		{
		p->translate(b->Width, 0);
		p->scale(-1, 1);
		}
	if (b->flippedV % 2 != 0)
		{
		p->translate(0, b->Height);
		p->scale(1, -1);
		}
}

void Page::RefreshItem(PageItem *b)
{
	QPainter p;
	p.begin(this);
	Transform(b, &p);
	if (b->PType == 4)
		RepaintTextRegion(b, QRegion(p.xForm(QRect(-10, -10, b->Width+20, b->Height+20))));
	else
		update(QRegion(p.xForm(QRect(-10, -10, b->Width+20, b->Height+20))).intersect(ViewReg()).boundingRect());
	p.end();
}

void Page::RepaintTextRegion(PageItem *b, QRegion alt)
{
	QPainter p;
	QRegion neu;
	p.begin(this);
	Transform(b, &p);
	neu = QRegion(p.xForm(QRect(0, 0, b->Width+1, b->Height+1))).unite(alt);
	p.end();
	QRect g = neu.boundingRect();
	g.setX(g.x()-20);
	g.setY(g.y()-20);
	g.setWidth(g.width()+20);
	g.setHeight(g.height()+20);
	PageItem *nb;
	neu = QRegion(g);
	if (b->NextBox != 0)
		{
		nb = b->NextBox;
		while (nb->OwnPage == this)
			{
			p.begin(this);
			Transform(nb, &p);
			neu = QRegion(p.xForm(QRect(0, 0, nb->Width, nb->Height))).unite(neu);
			p.end();
			if (nb->NextBox == 0)
				break;
			nb = nb->NextBox;
			}
		}
	update(neu.intersect(ViewReg()).boundingRect());
}

bool Page::MoveSizeItem(QPoint newX, QPoint newY, int ite)
{
	QRegion alt, neu;
	QPainter p;
	PageItem *b = Items.at(ite);
	p.begin(this);
	Transform(b, &p);
	alt = QRegion(p.xForm(QRect(0, 0, b->Width, b->Height)));
	p.end();
	float scx = (b->Width - newY.x()) / b->Width;
	float scy = (b->Height - newY.y()) / b->Height;
	b->Width -= newY.x();
	b->Height -= newY.y();
	b->Xpos += newX.x();
	b->Ypos += newX.y();
	switch (b->PType)
		{
		case 1:
			b->Clip.makeEllipse(0, 0, int(b->Width), int(b->Height));
			break;
		case 5:
			b->Clip.setPoints(4, -1,-1, int(b->Width+1),-1, int(b->Width+1),int(b->Height+1), -1,int(b->Height+1));
			break;
		default:
			QWMatrix ma;
			ma.scale(scx, scy);
			b->Clip = ma.map(b->Clip);
			break;
		}
	RepaintTextRegion(b, alt);
	emit ItemPos(b->Xpos, b->Ypos);
	emit ItemGeom(b->Width, b->Height);
	emit ItemRadius(b->RadRect);
	return TRUE;	
}

void Page::UpdateClip(PageItem* b)
{
	float oldx, oldy;
	switch (b->PType)
		{
		case 1:
			b->Clip.makeEllipse(0, 0, int(b->Width), int(b->Height));
			break;
		case 5:
			if (b->Width == -2)
				oldx = -3;
			else
				oldx = b->Width;
			if (b->Height == -2)
				oldy = -3;
			else
				oldy = b->Height;
			b->Clip.setPoints(4, -1,-1, int(oldx+1),-1, int(oldx+1),int(oldy+1), -1,int(oldy+1));
			break;
		default:
			if (!b->ClipEdited)
				{
				if (b->FrameType == 0)
					b->Clip.setPoints(4, 0,0, int(b->Width),0, int(b->Width),int(b->Height), 0,int(b->Height));
				if (b->FrameType == 1)
					b->Clip.makeEllipse(0, 0, int(b->Width), int(b->Height));
				if (b->FrameType == 2)
					SetFrameRounded();
				}
			else
				{
				if ((b->OldB2 == 0) || (b->OldH2 == 0))
					return;
				float scx = b->Width / b->OldB2;
				float scy = b->Height / b->OldH2;
				QWMatrix ma;
				ma.scale(scx, scy);
				b->Clip = ma.map(b->Clip);
				}
			break;
		}
}

bool Page::SizeItem(float newX, float newY, int ite)
{
	QRegion alt, neu;
	QPainter p;
	PageItem *b = Items.at(ite);
	if (b->PType != 5)
		{
		if ((newX < 1) || (newY < 1)) { return FALSE; }
		}
	p.begin(this);
	Transform(b, &p);
	alt = QRegion(p.xForm(QRect(0, 0, b->Width, b->Height)));
	p.end();
	b->Width = newX;
	b->Height = newY;
  b->RadRect = QMIN(b->RadRect, QMIN(b->Width,b->Height)/2);
	if (b->Sizing)
		{
		b->FrameOnly = true;
		b->Tinput = true;
		b->paintObj();
		emit ItemGeom(b->Width, b->Height);
		emit ItemRadius(b->RadRect);
		return true;
		}
	UpdateClip(b);
	RepaintTextRegion(b, alt);
	emit ItemGeom(b->Width, b->Height);
	emit ItemRadius(b->RadRect);
	return TRUE;	
}

void Page::MoveItemI(float newX, float newY, int ite)
{
	QPainter p;
	PageItem *b = Items.at(ite);
	p.begin(this);
	Transform(b, &p);
	TransformM(b, &p);
	QRegion alt = QRegion(p.xForm(QRect(0, 0, b->Width, b->Height)));
	p.end();
	if (b->flippedH % 2 != 0)
		{
		b->LocalX -= newX;
		}
	else
		{
		b->LocalX += newX;
		}
	if (b->flippedV % 2 != 0)
		{
		b->LocalY -= newY;
		}
	else
		{
		b->LocalY += newY;
		}
	repaint(alt);
	emit SetLocalValues(b->LocalScX, b->LocalScY, b->LocalX, b->LocalY);	
}

bool Page::MoveItem(float newX, float newY, int ite)
{
	QRegion alt, neu;
	QPainter p;
	PageItem *b;
	float oldx, oldy;
	bool retw = false;
	b = Items.at(ite);
	p.begin(this);
	Transform(b, &p);
	alt = QRegion(p.xForm(QRect(0, 0, b->Width, b->Height)));
	p.end();
	oldx = b->Xpos;
	oldy = b->Ypos;
	b->Xpos += newX;
	b->Ypos += newY;
	if (doku->useRaster)
		{
		b->Xpos = qRound(b->Xpos / doku->minorGrid) * doku->minorGrid;
		b->Ypos = qRound(b->Ypos / doku->minorGrid) * doku->minorGrid;
		}
	if ((oldx != b->Xpos) || (oldy != b->Ypos))
		{
		retw = true;
		}
	if (!Imoved)
		RepaintTextRegion(b, alt);
	emit ItemPos(b->Xpos, b->Ypos);
	return retw;	
}

float Page::xy2Deg(float x, float y)
{
	return (atan2(y,x)*(180.0/3.1415927));
}

void Page::RotateItem(float win, int ite)
{
	QRegion alt, neu;
	QPainter p;
	PageItem *b;
	b = Items.at(ite);
	p.begin(this);
	Transform(b, &p);
	alt = QRegion(p.xForm(QRect(0, 0, b->Width, b->Height)));
	p.end();
	b->Rot = win;
	RepaintTextRegion(b, alt);
	emit SetAngle(b->Rot);
}

void Page::mouseReleaseEvent(QMouseEvent *m)
{
	Mpressed = false;
	mCG = false;
	if ((doku->AppMode != 6) && (doku->AppMode != 7) && (!doku->EditClip))
		{
		if ((SelItem.count() != 0) && (m->button() == RightButton) && (!doku->DragP))
			{
			QPopupMenu *pmen = new QPopupMenu();
			qApp->setOverrideCursor(QCursor(ArrowCursor), true);
			PageItem *b = Items.at(*SelItem.at(0));
			if (b->PType == 2)
				{
				pmen->insertItem(tr("Get Picture..."), this, SIGNAL(LoadPic()));
				int px = pmen->insertItem(tr("Image visible"), this, SLOT(TogglePic()));
				pmen->setItemChecked(px, b->PicArt);
				}
			if (b->PType == 4)
				{
				pmen->insertItem(tr("Get Text..."), this, SIGNAL(LoadPic()));
				int pxb = pmen->insertItem(tr("Is PDF-Bookmark"), this, SLOT(ToggleBookmark()));
				pmen->setItemChecked(pxb, b->isBookmark);
				pxb = pmen->insertItem(tr("Is PDF-Annotation"), this, SLOT(ToggleAnnotation()));
				pmen->setItemChecked(pxb, b->isAnnotation);
				if (b->isAnnotation)
					pmen->insertItem(tr("Annotation Properties"), this, SIGNAL(AnnotProps()));
				}
			pmen->insertItem(tr("Modify..."), this, SIGNAL(ModifyIt()));
			pmen->insertItem(tr("Send to Back"), this, SLOT(ToBack()));
			pmen->insertItem(tr("Bring to Front"), this, SLOT(ToFront()));
			pmen->insertItem(tr("Lower"), this, SLOT(LowerItem()));
			pmen->insertItem(tr("Raise"), this, SLOT(RaiseItem()));
			pmen->insertSeparator();
			pmen->insertItem(tr("Cut"), this, SIGNAL(CutItem()));
			pmen->insertItem(tr("Copy"), this, SIGNAL(CopyItem()));
			pmen->insertItem(tr("Delete"), this, SLOT(DeleteItem()));
			pmen->exec(QCursor::pos());
			delete pmen;
			}
		if (doku->AppMode == 10)
			update();
		if (SelItem.count() != 0)
			{
			PageItem *b = Items.at(*SelItem.at(0));
			if (b->Sizing)
				{
				b->Sizing = false;
				UpdateClip(b);
				update();
				}
			}
		if ((SelItem.count() != 0) && (Imoved))
			{
			PageItem *b = Items.at(*SelItem.at(0));
			if (b->PType != 5)
				{
				if (fabs(b->Width) < 5)
					b->Width = 5;
				if (fabs(b->Height) < 5)
					b->Height = 5;
				}
			update();
			}
		if ((SelItem.count() == 0) && (HaveSelRect))
			{
			float sc = doku->Scale;
			QPainter p;
			p.begin(this);
			p.setRasterOp(XorROP);
			p.setPen(QPen(white, 1, DotLine, FlatCap, MiterJoin));
			p.drawRect(Mxp*sc, Myp*sc, SeRx-(Mxp*sc), SeRy-(Myp*sc));
			p.end();
  		if((Mxp*sc) > SeRx)
  			{
    		float tmp=SeRx;
    		SeRx=int(Mxp*sc);
    		Mxp=int(tmp/sc);
  			}
  		if((Myp*sc) > SeRy)
  			{
    		float tmp=SeRy;
    		SeRy=int(Myp*sc);
    		Myp=int(tmp/sc);
  			}
			QRect Sele = QRect(Mxp*sc, Myp*sc, SeRx-(Mxp*sc), SeRy-(Myp*sc));
			if (Items.count() != 0)
				{
				for (uint a = 0; a < Items.count(); a++)
					{	
					p.begin(this);
					Transform(Items.at(a), &p);
					QRegion apr = QRegion(p.xForm(Items.at(a)->Clip));
					p.end();
					if (Sele.contains(apr.boundingRect()))
						{
						SelectItemNr(a);
						}
					}
				}
			HaveSelRect = false;
			}
		doku->AppMode = 1;
		qApp->setOverrideCursor(QCursor(ArrowCursor), true);
		emit PaintingDone();
		}
	if (doku->AppMode == 6)
		{
		if (HaveSelRect)
			{
			float sc = doku->Scale;
  		if((Mxp*sc) > SeRx)
  			{
    		float tmp=SeRx;
    		SeRx=int(Mxp*sc);
    		Mxp=int(tmp/sc);
  			}
  		if((Myp*sc) > SeRy)
  			{
    		float tmp=SeRy;
    		SeRy=int(Myp*sc);
    		Myp=int(tmp/sc);
  			}
			float yf = height() / (SeRy/sc-Myp);
			float xf = width() / (SeRx/sc-Mxp);
			doku->Scale = QMIN(yf, xf);
			emit ZoomAbs();
			emit AbsPosi(Mxp, Myp);
			HaveSelRect = false;
			doku->AppMode = 1;
			qApp->setOverrideCursor(QCursor(ArrowCursor), true);
			emit PaintingDone();
			}
		else
			{
			if (Magnify)
				emit ZoomIn();
			else
				emit ZoomOut();
			HaveSelRect = false;
			}
		}
	if (doku->AppMode == 7)
		{
		PageItem *b = Items.at(*SelItem.at(0));
		uint a;
		if (b->PType == 4)
			{
			if (oldCp == b->CPos)
				{
				for (a = 0; a < b->Ptext.count(); a++)
					{
					b->Ptext.at(a)->cselect = false;
					}
				b->HasSel = false;
				emit HasNoTextSel();
				b->Dirty = true;
				b->paintObj();
				}
			}
		}
	doku->DragP = false;
	Imoved = false;
}

void Page::mouseMoveEvent(QMouseEvent *m)
{
	int newX, newY, c;
	float nx, ny, dx, dy;
	uint a;
	PageItem *b;
	QPoint np, np2;
	QPainter p;
	QRect tx;
	bool erf = false;
	float sc = doku->Scale;
	emit Hrule(m->x()+Anz->childX(parentWidget()));
	emit Vrule(m->y()+Anz->childY(parentWidget()));
	if ((!doku->DragP) && (Mpressed) && (SelItem.count() != 0))
		{
		int cx = Anz->contentsX() - Anz->childX(doku->ActPage->parentWidget());
		int cy = Anz->contentsY() - Anz->childY(doku->ActPage->parentWidget());
		int cw = Anz->visibleWidth();
		int ch = Anz->visibleHeight();
		if (m->y() < cy)
			Anz->scrollBy(0, m->y() - cy);
		if ((ch - (m->y() - cy)) < 0)
			Anz->scrollBy(0, m->y() - cy - ch);
		if (m->x() < cx)
			Anz->scrollBy(m->x() - cx, 0);
		if ((cw - (m->x() - cx)) < 0)
			Anz->scrollBy(m->x() - cx - cw, 0);
		}
	if (SelItem.count() != 0)
		{
		newX = int(m->x()/sc);
		newY = int(m->y()/sc);
		if ((Mpressed) && (m->state() == RightButton) && (!doku->DragP) && (doku->AppMode == 1))
			{
			if ((abs(Dxp - newX) > 3) || (abs(Dyp - newY) > 3))
				{
				doku->DragP = true;
				doku->DraggedElem = Items.at(*SelItem.at(0));
				doku->DragElements.clear();
				for (uint dre=0; dre<SelItem.count(); dre++)
					{
					doku->DragElements.append(*SelItem.at(dre));
					}
  			ScriXmlDoc *ss = new ScriXmlDoc();
				QDragObject *dr = new QTextDrag(ss->WriteElem(&SelItem, doku), this);
				dr->setPixmap(loadIcon("DragPix.xpm"));
				dr->drag();
				delete ss;
				doku->DragP = false;
				Mpressed = false;
				doku->DraggedElem = 0;
				doku->DragElements.clear();
				}
			return;
			}
		if (doku->DragP)
			return;
		if (Mpressed && (doku->AppMode == 9))
			{
			float newW =  xy2Deg(newX - Items.at(*SelItem.at(0))->Xpos, newY - Items.at(*SelItem.at(0))->Xpos);
			RotateItem(qRound((Items.at(*SelItem.at(0))->Rot - (oldW - newW))*100.0)/100.0, *SelItem.at(0));
			oldW = newW;
			emit DocChanged();
			}
		if (Mpressed && (doku->AppMode == 7))
			{
			b = Items.at(*doku->ActPage->SelItem.at(0));
			if (b->PType == 2)
				{
				MoveItemI(newX-Mxp, newY-Myp, *SelItem.at(0));
				emit DocChanged();
				Mxp = newX;
				Myp = newY;
				}
			if (b->PType == 4)
				{
				for (a = 0; a < b->Ptext.count(); a++)
					{
					b->Ptext.at(a)->cselect = false;
					}
				b->HasSel = false;
				slotSetCurs(m->x(), m->y());
				if (b->CPos < oldCp)
					{
					for (c = b->CPos; c < oldCp; c++)
						{
						b->Ptext.at(c)->cselect = true;
						b->HasSel = true;
						}
					}
				if (b->CPos > oldCp)
					{
					for (c = oldCp; c < b->CPos; c++)
						{
						b->Ptext.at(c)->cselect = true;
						b->HasSel = true;
						}
					}
//				b->Dirty = true;
				b->paintObj();
				if (b->HasSel)
					{
					emit HasTextSel();
					}
				else
					{
					emit HasNoTextSel();
					}
				}
			}
		if (Mpressed && (doku->AppMode == 1))
			{
			if (doku->EditClip)
				{
				Imoved = false;
				b = Items.at(*SelItem.at(0));
				p.begin(this);
				Transform(b, &p);
				TransformM(b, &p);
				np = p.xFormDev(m->pos());
				if (np.x() < -1) { np.setX(-1); }
				if (np.y() < -1) { np.setY(-1); }
				if (np.x() > b->Width+1) { np.setX(b->Width+1); }
				if (np.y() > b->Height+1) { np.setY(b->Height+1); }
				if (ClRe != -1)
					{
					b->Clip.setPoint(ClRe, np);
					QRegion elem = QRegion(p.xForm(QRect(-5, -5, b->Width+10, b->Height+10)));
					repaint(elem.intersect(ViewReg()));
					}
				p.end();
				b->ClipEdited = true;
				emit DocChanged();
				return;
				}
			if (mCG)
				{
				Imoved = false;
				for (a = 0; a < SelItem.count(); a++)
					{
					switch (HowTo)
						{
						case 1:
							b = Items.at(*SelItem.at(0));
							p.begin(this);
							Transform(b, &p);
							np = p.xFormDev(QPoint(m->x(), m->y()));
							nx = np.x();
							ny = np.y();
							p.end();
							if (doku->useRaster)
								{
								dx = b->Xpos - int (b->Xpos / doku->minorGrid) * doku->minorGrid;
								dy = b->Ypos - int (b->Ypos / doku->minorGrid) * doku->minorGrid;
								nx = (qRound(np.x() / doku->minorGrid) * doku->minorGrid - dx);
								ny = (qRound(np.y() / doku->minorGrid) * doku->minorGrid - dy);
								}
							erf = SizeItem(nx, ny, *SelItem.at(0));
							break;
						case 2:
							b = Items.at(*SelItem.at(0));
							p.begin(this);
							p.rotate(b->Rot);
							np = p.xFormDev(QPoint(newX-Mxp, newY-Myp));
							p.end();
							np2 = QPoint(newX-Mxp, newY-Myp);
							erf = MoveSizeItem(np2, np, *SelItem.at(0));
							break;
						}
					}
				if (erf)
					{
					Mxp = newX;
					Myp = newY;
					emit DocChanged();
					}
				}
			else
				{
				Imoved = true;
				for (a = 0; a < SelItem.count(); a++)
					{
					b = Items.at(*SelItem.at(a));
					p.begin(this);
					Transform(b, &p);
					p.setRasterOp(XorROP);
					p.setBrush(NoBrush);
					p.setPen(QPen(white, 1, DotLine, FlatCap, MiterJoin));
					p.drawRect(0, 0, b->Width+1, b->Height+1);
					p.end();
					erf = MoveItem(newX-Mxp, newY-Myp, *SelItem.at(a));
					p.begin(this);
					Transform(b, &p);
					p.setRasterOp(XorROP);
					p.setBrush(NoBrush);
					p.setPen(QPen(white, 1, DotLine, FlatCap, MiterJoin));
					p.drawRect(0, 0, b->Width+1, b->Height+1);
					p.end();
					}
				if (erf)
					{
					emit DocChanged();
					Mxp = newX;
					Myp = newY;
					}
				}
			}
		if (!Mpressed)
			{
			for (a = 0; a < doku->ActPage->SelItem.count(); a++)
				{
  			b = doku->ActPage->Items.at(*doku->ActPage->SelItem.at(a));
  			p.begin(this);
				Transform(b, &p);
				QRegion ganz = ViewReg();
				if (ganz.intersect(QRegion(p.xForm(QPointArray(QRect(-3, -3, int(b->Width+6), int(b->Height+6)))))).contains(m->pos()))
  				{
					if ((doku->EditClip) && (doku->EditClipMode == 1))
						{
						b = Items.at(*SelItem.at(0));
						TransformM(b, &p);
						QRect mpo = QRect(m->x()-doku->GrabRad, m->y()-doku->GrabRad, doku->GrabRad*2, doku->GrabRad*2);
						QPointArray lp = QPointArray();
						for (uint clp = 0; clp < b->Clip.count()-1; clp++)
							{
							lp.setPoints(3, b->Clip.point(clp).x(), b->Clip.point(clp).y()-1,
															b->Clip.point(clp).x(), b->Clip.point(clp).y()+1,
															b->Clip.point(clp+1).x(), b->Clip.point(clp+1).y());
							QRegion elem = QRegion(p.xForm(lp));
							if (elem.contains(mpo))
								{
  							qApp->setOverrideCursor(QCursor(pointingHandCursor), true);
  							ClRe2 = clp+1;
								p.end();
								return;
								}
							}
						uint cle = b->Clip.count()-1;
						lp.setPoints(3, b->Clip.point(cle).x(), b->Clip.point(cle).y()-1,
														b->Clip.point(cle).x(), b->Clip.point(cle).y()+1,
														b->Clip.point(0).x(), b->Clip.point(0).y());
						QRegion elem = QRegion(p.xForm(lp));
						if (elem.contains(mpo))
							{
  						qApp->setOverrideCursor(QCursor(pointingHandCursor), true);
  						ClRe2 = cle+1;
							p.end();
							return;
							}
						}
  				tx = p.xForm(QRect(b->Width-6, b->Height-6, 6, 6));
  				if (tx.contains(m->pos()))
  					{
  					if (doku->AppMode == 9)
  						{
  						qApp->setOverrideCursor(QCursor(loadIcon("Rotieren2.xpm")), true);
  						}
  					else
  						{
  						if (doku->EditClip)
  							{
  							qApp->setOverrideCursor(QCursor(crossCursor), true);
  							}
  						else
  							{
  							if (doku->AppMode != 7)
  								qApp->setOverrideCursor(QCursor(SizeFDiagCursor), true);
  							}
  						}
  					}
  				else
  					{
  					tx = p.xForm(QRect(0, 0, 6, 6));
  					if (tx.contains(m->pos()))
  						{
  						if (doku->EditClip)
  							{
  							qApp->setOverrideCursor(QCursor(crossCursor), true);
  							}
  						else
  							{
  							if (doku->AppMode != 7)
  								qApp->setOverrideCursor(QCursor(SizeFDiagCursor), true);
  							}
  						}
  					else
  						{
  						if (doku->EditClip)
  							{
  							qApp->setOverrideCursor(QCursor(crossCursor), true);
  							}
  						else
  							{
  							qApp->setOverrideCursor(QCursor(SizeAllCursor), true);
  							if (doku->AppMode == 7)
  								{
  								if (b->PType == 4)
  									qApp->setOverrideCursor(QCursor(ibeamCursor), true);
  								if (b->PType == 2)
  									qApp->setOverrideCursor(QCursor(loadIcon("HandC.xpm")), true);
  								}
  							}
  						}
  					}
  				break;
  				}
  			else
  				{
  				qApp->setOverrideCursor(QCursor(ArrowCursor), true);
  				}
  			p.end();
				}			
			}
		}
	else
		{
		if (Mpressed)
			{
			newX = m->x();
			newY = m->y();
			p.begin(this);
			p.setRasterOp(XorROP);
			p.setPen(QPen(white, 1, DotLine, FlatCap, MiterJoin));
			p.drawRect(Mxp*sc, Myp*sc, SeRx-(Mxp*sc), SeRy-(Myp*sc));
			p.drawRect(Mxp*sc, Myp*sc, newX-(Mxp*sc), newY-(Myp*sc));
			p.end();
			SeRx = newX;
			SeRy = newY;
			HaveSelRect = true;
			}
		}
}

void Page::mousePressEvent(QMouseEvent *m)
{
	float sc;
	bool inText;
	uint a;
	int z;
	float Rxp = 0;
	float Ryp = 0;
	float Rxpd = 0;
	float Rypd = 0;
	PageItem *b;
	PageItem *bb;
	QPainter p;
	QRect tx, mpo;
	sc = doku->Scale;
	Mpressed = true;
	Imoved = false;
	SeRx = m->x();
	SeRy = m->y();
	HaveSelRect = false;
	doku->DragP = false;
	Mxp = qRound(m->x()/sc);
	Myp = qRound(m->y()/sc);
	mpo = QRect(m->x()-doku->GrabRad, m->y()-doku->GrabRad, doku->GrabRad*2, doku->GrabRad*2);
	if ((doku->useRaster) && (doku->AppMode != 7))
		{
		Rxp = int(Mxp / doku->minorGrid) * doku->minorGrid;
		Rxpd = Mxp - Rxp;
		Mxp = qRound(Rxp);
		Ryp = int(Myp / doku->minorGrid) * doku->minorGrid;
		Rypd = Myp - Ryp;
		Myp = qRound(Ryp);
		}
	else
		{
		Ryp = Myp;
		Rxp = Mxp;
		}
	switch (doku->AppMode)
		{
		case 1:
			if ((doku->EditClip) && (SelItem.count() != 0))
				{
				int x, y;
				QPoint np;
				b = Items.at(*SelItem.at(0));
				ClRe = -1;
				p.begin(this);
				Transform(b, &p);
				TransformM(b, &p);
				for (a=0; a<b->Clip.size(); a++)
					{
					b->Clip.point(a, &x, &y);
					np = p.xForm(QPoint(x, y));
  				tx = p.xForm(QRect(x-3, y-3, 6, 6));
					if (doku->EditClipMode == 1)
						{
						np = p.xFormDev(m->pos());
						QPointArray cli = QPointArray();
						uint cc, cc2;
						cc2 = 0;
						if (ClRe2 == int(b->Clip.size()))
							{
							b->Clip.resize(b->Clip.size()+1);
							b->Clip.putPoints(ClRe2, 1, np.x(), np.y());
							ClRe2 = -1;
							}
						else
							{
							for (cc=0; cc<b->Clip.size(); cc++)
								{
								b->Clip.point(cc, &x, &y);
								if (int(cc) == ClRe2)
									{
									cli.putPoints(cc2, 1, np.x(), np.y());
									cc2++;
									ClRe2 = -1;
									}
								cli.putPoints(cc2, 1, x, y);
								cc2++;
								}
							b->Clip = cli.copy();
							b->ClipEdited = true;
							}
						repaint(QRegion(p.xForm(QRect(-5, -5, b->Width+10, b->Height+10))));
						}
					if (tx.contains(m->pos()))
						{
						if ((doku->EditClipMode == 2) && (b->Clip.size() > 3))
							{
							np = p.xFormDev(m->pos());
							QPointArray cli = QPointArray();
							uint cc, cc2;
							cc2 = 0;
							for (cc=0; cc<b->Clip.size(); cc++)
								{
								b->Clip.point(cc, &x, &y);
								cli.putPoints(cc2, 1, x, y);
								cc2++;
								if (cc == a)
									{
									cc2--;
									}
								}
							b->Clip = cli.copy();
							b->ClipEdited = true;
							repaint(QRegion(p.xForm(QRect(-5, -5, b->Width+10, b->Height+10))));
							ClRe = -1;
							break;
							}
						ClRe = a;
						break;
						}
					}
				p.end();
				return;
				}
			if (SelItem.count() != 0)
				{
				b = Items.at(*SelItem.at(0));
				p.begin(this);
				Transform(b, &p);
				if (!QRegion(p.xForm(QPointArray(QRect(0, 0, int(b->Width), int(b->Height))))).contains(mpo))
					{
					SeleItem(m);
					}
				else
					{
					if (p.xForm(QRect(b->Width-6, b->Height-6, 6, 6)).intersects(mpo))
						{
						mCG = TRUE;
						HowTo = 1;
						if (b->PType != 5)
							{
							b->Sizing = true;
							b->OldB = b->Width;
							b->OldH = b->Height;
							b->OldB2 = b->Width;
							b->OldH2 = b->Height;
							}
						qApp->setOverrideCursor(QCursor(SizeFDiagCursor), true);
						}
					else
						{
						if (p.xForm(QRect(0, 0, 6, 6)).intersects(mpo))
							{
							mCG = TRUE;
							HowTo = 2;
							qApp->setOverrideCursor(QCursor(SizeFDiagCursor), true);
							}
						else
							{
							mCG = FALSE;
							qApp->setOverrideCursor(QCursor(SizeAllCursor), true);
							SeleItem(m);
							}
						}
					}
				p.end();
				}
			else
				{
				SeleItem(m);
				}
			if (m->button() == MidButton)
				{
				if (SelItem.count() != 0)
					Deselect();
				repaint();
				}
			if ((SelItem.count() != 0) && (m->button() == RightButton))
				{
				Mpressed = true;
				Dxp = Mxp;
				Dyp = Mxp;
				}	
			break;
		case 2:
			SeleItem(m);
			Deselect();
			z = PaintRect(Rxp, Ryp, 1+Rxpd, 1+Rypd, doku->Dwidth, doku->Dbrush, doku->Dpen);
			SetupDraw(z);
			emit HaveSel(3);
			break;
		case 3:
			SeleItem(m);
			Deselect();
			z = PaintEllipse(Rxp, Ryp, 1+Rxpd, 1+Rypd, doku->Dwidth, doku->Dbrush, doku->Dpen);
			SetupDraw(z);
			emit HaveSel(1);
			break;
		case 4:
			SeleItem(m);
			Deselect();
			z = PaintPict(Rxp, Ryp, 1+Rxpd, 1+Rypd);
			SetupDraw(z);
			emit HaveSel(2);
			break;
		case 5:
			SeleItem(m);
			Deselect();
			z = PaintText(Rxp, Ryp, 1+Rxpd, 1+Rypd, doku->Dwidth, doku->DpenText);
			SetupDraw(z);
			emit HaveSel(4);
			break;
		case 6:
			Mpressed = true;
			if (m->state() == ShiftButton)
				{
				Magnify = false;
				}
			else
				{
				Magnify = true;
				}
			break;
		case 7:
			slotDoCurs(false);
			inText = slotSetCurs(m->x(), m->y());
			if (SelItem.count() == 0)
				{
				Deselect();
				if (!SeleItem(m))
					{
					slotDoCurs(true);
					emit Amode(1);
					return;
					}
				}
			b = doku->ActPage->Items.at(*doku->ActPage->SelItem.at(0));
			oldCp = b->CPos;
			slotDoCurs(true);
			if ((!inText) && (b->PType == 4))
				{
				Deselect();
				if (SeleItem(m))
					{
					b = doku->ActPage->Items.at(*doku->ActPage->SelItem.at(0));
					if (b->PType != 4)
						{
						emit PaintingDone();
						qApp->setOverrideCursor(QCursor(ArrowCursor), true);
						}
					else
						emit Amode(7);
					}
				else
					{
					emit PaintingDone();
					qApp->setOverrideCursor(QCursor(ArrowCursor), true);
					}
				}
			break;
		case 8:
			SeleItem(m);
			Deselect();
			z = PaintLine(Rxp, Ryp, 1+Rxpd, 1+Rypd, doku->DwidthLine, doku->DpenLine);
			SetupDraw(z);
			emit HaveSel(5);
			break;
		case 9:
			if (SelItem.count() != 0)
				{
				oldW = xy2Deg(Mxp - Items.at(*SelItem.at(0))->Xpos, Myp - Items.at(*SelItem.at(0))->Xpos);
				}
			break;
		case 10:
			b = doku->ElemToLink;
			SeleItem(m);
			if (SelItem.count() != 0)
				{
				bb = Items.at(*SelItem.at(0));
				if ((bb->Ptext.count() == 0) && (bb->BackBox == 0) && (b != bb))
					{
					b->NextBox = bb;
					bb->BackBox = b;
					}
				emit DocChanged();
				}
			doku->ElemToLink = 0;
			break;
		case 11:
			SeleItem(m);
			if (SelItem.count() != 0)
				{
				if (Items.at(*SelItem.at(0))->BackBox != 0)
					{
					Items.at(*SelItem.at(0))->BackBox->NextBox = 0;
					Items.at(*SelItem.at(0))->BackBox = 0;
					}
				emit DocChanged();
				}
			break;
		}
}

bool Page::SeleItemPos(QPoint m)
{
	uint a;
	float sc = doku->Scale;
	QPainter p;
	PageItem* b = Items.last();
	Mxp = int(m.x()/sc);
	Myp = int(m.y()/sc);
	ClRe = -1;
	if (doku->ActPage != this)
		{
		Deselect();
		doku->ActPage = this;
		emit PgCh(PageNr);
		}
	if (doku->DragP)
		return false;
	for (a = 0; a < Items.count(); a++)
		{
		p.begin(this);
		Transform(b, &p);
		if (QRegion(p.xForm(QPointArray(QRect(0, 0, int(b->Width), int(b->Height))))).contains(m))
			{
			if ((b->PType == 4) || (b->PType == 2))
				{
				if (!b->Select)
					{
					b->Select = true;
					b->FrameOnly = true;
					b->paintObj();
					SelItem.append(&b->ItemNr);
					emit HaveSel(b->PType);
					EmitValues(b);
					}
				p.end();
				return TRUE;
				}
			}
		p.end();
		b = Items.prev();
		}
	return FALSE;
}

bool Page::SeleItem(QMouseEvent *m)
{
	uint a;
	float sc = doku->Scale;
	QPainter p;
	QRect tx, mpo;
	PageItem* b = Items.last();
	Mpressed = true;
	Mxp = int(m->x()/sc);
	Myp = int(m->y()/sc);
	mpo = QRect(m->x()-doku->GrabRad, m->y()-doku->GrabRad, doku->GrabRad*2, doku->GrabRad*2);
	ClRe = -1;
	if (doku->ActPage != this)
		{
		Deselect();
		doku->ActPage = this;
		emit PgCh(PageNr);
		}
	if (Items.count() == 0)
		return false;
	for (a = 0; a < Items.count(); a++)
		{
		p.begin(this);
		Transform(b, &p);
		if ((QRegion(p.xForm(QPointArray(QRect(0, 0, int(b->Width), int(b->Height))))).contains(mpo)) ||
			  (QRegion(p.xForm(b->Clip)).contains(mpo)))
			{
			if (!b->Select)
				{
				if ((m->state() != ShiftButton) || (doku->AppMode == 10) || (doku->AppMode == 11))
					Deselect();
				if (b->Groups.count() != 0)
					{
					if (SelItem.count() != 0)
						{
						if (SelItem.find(&b->ItemNr) == -1)
							SelItem.append(&b->ItemNr);
						}
					else
						SelItem.append(&b->ItemNr);
					for (uint ga=0; ga<Items.count(); ga++)
						{
						if (Items.at(ga)->Groups.count() != 0)
							{
							if (Items.at(ga)->Groups.top() == b->Groups.top())
								{
								if (Items.at(ga)->ItemNr != b->ItemNr)
									{
									if (SelItem.find(&Items.at(ga)->ItemNr) == -1)
										SelItem.append(&Items.at(ga)->ItemNr);
									}
								Items.at(ga)->Select = true;
								Items.at(ga)->FrameOnly = true;
								Items.at(ga)->paintObj();
								}
							}
						}
					}
				else
					{
					SelItem.append(&b->ItemNr);
					b->Select = true;
					b->FrameOnly = true;
					b->paintObj();
					}
				}
			else
				{
  			if (SelItem.count() > 1)
  				{
  				PageItem *bb = Items.at(*SelItem.at(0));
  				SelItem.remove(&b->ItemNr);
  				SelItem.prepend(&b->ItemNr);
					b->FrameOnly = true;
					b->paintObj();
					bb->FrameOnly = true;
					bb->paintObj();
					}
				}
			EmitValues(b);
			emit HaveSel(b->PType);
			if (b->PType == 5)
				emit ItemGeom(b->Width, b->Height);
  		tx = p.xForm(QRect(b->Width-6, b->Height-6, 6, 6));
			if (tx.contains(mpo))
				{
				mCG = TRUE;
				HowTo = 1;
				qApp->setOverrideCursor(QCursor(SizeFDiagCursor), true);
				}
			else
				{
				tx = p.xForm(QRect(0, 0, 6, 6));
				if (tx.contains(mpo))
					{
					mCG = TRUE;
					HowTo = 2;
					qApp->setOverrideCursor(QCursor(SizeFDiagCursor), true);
					}
				else
					{
					mCG = FALSE;
					qApp->setOverrideCursor(QCursor(SizeAllCursor), true);
					}
				}
			p.end();
			return TRUE;
			}
		p.end();
		b = Items.prev();
		}
	Deselect();
	emit HaveSel(-1);
	SelItem.clear();
	return FALSE;
}

void Page::SelectItemNr(int nr)
{
	PageItem *b = doku->ActPage->Items.at(nr);
	if (!b->Select)
		{
		if (b->Groups.count() != 0)
			{
			if (doku->ActPage->SelItem.count() != 0)
				{
				if (doku->ActPage->SelItem.find(&b->ItemNr) == -1)
					doku->ActPage->SelItem.append(&b->ItemNr);
				}
			else
				doku->ActPage->SelItem.append(&b->ItemNr);
			for (uint ga=0; ga<doku->ActPage->Items.count(); ga++)
				{
				if (doku->ActPage->Items.at(ga)->Groups.count() != 0)
					{
					if (doku->ActPage->Items.at(ga)->Groups.top() == b->Groups.top())
						{
						if (doku->ActPage->Items.at(ga)->ItemNr != b->ItemNr)
							{
							if (doku->ActPage->SelItem.find(&doku->ActPage->Items.at(ga)->ItemNr) == -1)
								doku->ActPage->SelItem.append(&Items.at(ga)->ItemNr);
							}
						doku->ActPage->Items.at(ga)->Select = true;
						doku->ActPage->Items.at(ga)->FrameOnly = true;
						doku->ActPage->Items.at(ga)->paintObj();
						}
					}
				}
			}
		else
			{
			doku->ActPage->SelItem.append(&b->ItemNr);
			b->Select = true;
			b->FrameOnly = true;
			b->paintObj();
			}
		}
	else
		{
  	if (doku->ActPage->SelItem.count() > 1)
  		{
  		PageItem *bb = doku->ActPage->Items.at(*doku->ActPage->SelItem.at(0));
  		doku->ActPage->SelItem.remove(&b->ItemNr);
  		doku->ActPage->SelItem.prepend(&b->ItemNr);
			b->FrameOnly = true;
			b->paintObj();
			bb->FrameOnly = true;
			bb->paintObj();
			}
		}
	emit HaveSel(b->PType);
	EmitValues(b);
}

bool Page::slotSetCurs(int x, int y)
{
	if (doku->ActPage != this) {return false;}
  if (SelItem.count() != 0)
  	{
  	QRect mpo;
  	PageItem *b = Items.at(*SelItem.at(0));
  	if (b->PType != 4)
  		return false;
  	QPainter p;
  	QFont ffo;
  	QString chx;
  	p.begin(this);
  	Transform(b, &p);
		mpo = QRect(x-doku->GrabRad, y-doku->GrabRad, doku->GrabRad*2, doku->GrabRad*2);
		if ((QRegion(p.xForm(QPointArray(QRect(0, 0, int(b->Width), int(b->Height))))).contains(mpo)) ||
			  (QRegion(p.xForm(b->Clip)).contains(mpo)))
			{
			TransformM(b, &p);
  		uint a;
  		int xp, yp, w, h;
  		for (a=0; a<b->Ptext.count(); a++)
  			{
	  		xp = int(b->Ptext.at(a)->xp);
  			yp = int(b->Ptext.at(a)->yp);
  			chx = b->Ptext.at(a)->ch;
				if (chx == QChar(30))
					{
					if (doku->MasterP)
						chx = "#";
					else
						{
						uint zae = 0;
						while (b->Ptext.at(a+zae)->ch == QChar(30))
							{
							zae++;
							if (a+zae == b->Ptext.count())
								break;
							}
						QString out="%1";
						chx = out.arg(PageNr+1, zae).right(zae).left(1);
						}
					}
  			ffo = doku->UsedFonts[b->Ptext.at(a)->cfont];
  			if ((b->Ptext.at(a)->cstyle & 127) == 0)
  				ffo.setPointSize(b->Ptext.at(a)->csize);
  			if (b->Ptext.at(a)->cstyle & 4)
					ffo.setPointSize(b->Ptext.at(a)->csize);
  			if (b->Ptext.at(a)->cstyle & 8)
					ffo.setPointSize(b->Ptext.at(a)->csize);
  			if (b->Ptext.at(a)->cstyle & 16)
					ffo.setPointSize(b->Ptext.at(a)->csize);
  			if (b->Ptext.at(a)->cstyle & 32)
					ffo.setPointSize(b->Ptext.at(a)->csize);
  			if (b->Ptext.at(a)->cstyle & 64)
  				{
  				if (chx.upper() != chx)
  					{
						ffo.setPointSize(b->Ptext.at(a)->csize * doku->VKapit / 100);
						chx = chx.upper();
						}
					else
						{
						ffo.setPointSize(b->Ptext.at(a)->csize);
						}
					}
  			if (b->Ptext.at(a)->cstyle & 1)
					ffo.setPointSize(b->Ptext.at(a)->csize * doku->VHochSc / 100);
  			if (b->Ptext.at(a)->cstyle & 2)
					ffo.setPointSize(b->Ptext.at(a)->csize * doku->VTiefSc / 100);
  			p.setFont(ffo);
  			w = qRound(Cwidth(doku, &p, b->Ptext.at(a)->cfont, chx, ffo.pointSize()));
  			h = int(doku->Vorlagen[b->Ptext.at(a)->cab].LineSpa);
  			if (QRegion(p.xForm(QRect(xp-1, yp-h, w+1, h))).contains(QPoint(x, y)))
  				{
  				b->CPos = a;
  				p.end();
					b->IFont = b->Ptext.at(a)->cfont;
					b->ISize = b->Ptext.at(a)->csize;
					b->Pcolor2 = b->Ptext.at(a)->ccolor;
					b->Shade2 = b->Ptext.at(a)->cshade;
					emit ItemTextFont(b->Ptext.at(a)->cfont);
					emit ItemTextSize(b->Ptext.at(a)->csize);
					emit ItemTextUSval(b->Ptext.at(a)->cextra);
					emit ItemTextStil(b->Ptext.at(a)->cstyle);
					emit ItemTextAbs(b->Ptext.at(a)->cab);
					emit ItemFarben(b->Ptext.at(a)->ccolor, b->Pcolor, b->Ptext.at(a)->cshade, b->Shade);
  				return true;
  				}
  			}
  		QPoint np;
  		for (a=0; a<b->Ptext.count(); a++)
  			{
	  		xp = int(b->Ptext.at(a)->xp);
	  		yp = int(b->Ptext.at(a)->yp);
	  		np = p.xForm(QPoint(xp, yp - doku->Vorlagen[b->Ptext.at(a)->cab].LineSpa));
 	 			if (y < np.y())
  				{
  				b->CPos = a;
  				p.end();
					b->IFont = b->Ptext.at(a)->cfont;
					b->ISize = b->Ptext.at(a)->csize;
					b->Pcolor2 = b->Ptext.at(a)->ccolor;
					b->Shade2 = b->Ptext.at(a)->cshade;
					emit ItemFarben(b->Ptext.at(a)->ccolor, b->Pcolor, b->Ptext.at(a)->cshade, b->Shade);
					emit ItemTextFont(b->Ptext.at(a)->cfont);
					emit ItemTextSize(b->Ptext.at(a)->csize);
					emit ItemTextUSval(b->Ptext.at(a)->cextra);
					emit ItemTextStil(b->Ptext.at(a)->cstyle);
					emit ItemTextAbs(b->Ptext.at(a)->cab);
  				return true;
  				}
  			}
	  	b->CPos = b->Ptext.count();
  		if (b->Ptext.count() != 0)
  			{
				b->IFont = b->Ptext.at(b->CPos-1)->cfont;
				b->ISize = b->Ptext.at(b->CPos-1)->csize;
				b->Pcolor2 = b->Ptext.at(b->CPos-1)->ccolor;
				b->Shade2 = b->Ptext.at(b->CPos-1)->cshade;
				emit ItemFarben(b->Ptext.at(b->CPos-1)->ccolor, b->Pcolor, b->Ptext.at(b->CPos-1)->cshade, b->Shade);
				emit ItemTextFont(b->Ptext.at(b->CPos-1)->cfont);
				emit ItemTextSize(b->Ptext.at(b->CPos-1)->csize);
				emit ItemTextUSval(b->Ptext.at(b->CPos-1)->cextra);
				emit ItemTextStil(b->Ptext.at(b->CPos-1)->cstyle);
				emit ItemTextAbs(b->Ptext.at(b->CPos-1)->cab);
  			p.end();
  			return true;
  			}
  		p.end();
  		}
  	}
  return false;
}

void Page::slotDoCurs(bool draw)
{
	QColor tmp;
	int h, s, v, sneu;
  if (SelItem.count() != 0)
  	{
  	PageItem *b = Items.at(*SelItem.at(0));
  	if ((b->PType != 4) || (b->Ptext.count() == 0)) { return; }
  	QPainter p;
  	QFont ffo;
  	QString chx;
  	int xp, yp, yp1;
  	p.begin(this);
		p.setClipRegion(ViewReg());
		Transform(b, &p);
		TransformM(b, &p);
		if (b->CPos > 0)
			{
			if (b->Ptext.at(b->CPos-1)->yp == 0)
				return;
			chx = b->Ptext.at(b->CPos-1)->ch;
			if (chx == QChar(30))
				{
				if (doku->MasterP)
					chx = "#";
				else
					{
					uint zae = 0;
					while (b->Ptext.at(b->CPos-1+zae)->ch == QChar(30))
						{
						zae++;
						if (b->CPos-1+zae == b->Ptext.count())
							break;
						}
					QString out="%1";
					chx = out.arg(PageNr+1, zae).right(zae).left(1);
					}
				}
			ffo = doku->UsedFonts[b->Ptext.at(b->CPos-1)->cfont];
  		if ((b->Ptext.at(b->CPos-1)->cstyle & 127) == 0)
  			ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize);
  		if (b->Ptext.at(b->CPos-1)->cstyle & 4)
				ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize);
  		if (b->Ptext.at(b->CPos-1)->cstyle & 8)
				ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize);
  		if (b->Ptext.at(b->CPos-1)->cstyle & 16)
				ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize);
  		if (b->Ptext.at(b->CPos-1)->cstyle & 32)
				ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize);
  		if (b->Ptext.at(b->CPos-1)->cstyle & 64)
  			{
  			if (chx.upper() != chx)
  				{
					ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize * doku->VKapit / 100);
					chx = chx.upper();
					}
				else
					{
					ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize);
					}
				}
  		if (b->Ptext.at(b->CPos-1)->cstyle & 1)
				ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize * doku->VHochSc / 100);
  		if (b->Ptext.at(b->CPos-1)->cstyle & 2)
				ffo.setPointSize(b->Ptext.at(b->CPos-1)->csize * doku->VTiefSc / 100);
			p.setFont(ffo);
  		xp = int(b->Ptext.at(b->CPos-1)->xp);
  		if (b->Ptext.at(b->CPos-1)->ch != QChar(13))
  			xp += qRound(Cwidth(doku, &p, b->Ptext.at(b->CPos-1)->cfont, chx, ffo.pointSize()));
  		yp = int(b->Ptext.at(b->CPos-1)->yp);
  		yp1 = yp - b->Ptext.at(b->CPos-1)->csize;
  		}
  	else
			{
  		xp = int(b->Ptext.at(b->CPos)->xp);
  		yp = int(b->Ptext.at(b->CPos)->yp);
  		yp1 = yp - b->Ptext.at(b->CPos)->csize;
  		}
  	if (draw)
  		{
  		p.setPen(QPen(black, 1, SolidLine, FlatCap, MiterJoin));
  		CursVis = false;
  		}
  	else
  		{
  		if (b->Pcolor != "None")
  			{
				doku->PageColors[b->Pcolor].getRGBColor().hsv(&h, &s, &v);
				sneu = s * b->Shade / 100;
				tmp.setHsv(h, sneu, v);
				p.setPen(tmp);
  			}
  		else
  			{
  			p.setPen(QPen(white, 1, SolidLine, FlatCap, MiterJoin));
  			}
  		CursVis = true;
  		}
  	if (yp1 < int(b->Height))
  		{
  		p.drawLine(xp, yp1, xp, yp);
  		if ((!draw) && (b->CPos > 1) && (b->CPos != int(b->Ptext.count())))
  			{
  			DrawCursChar(b, &p, 1);
  			DrawCursChar(b, &p, 0);
  			}
  		}
  	p.end();
  	}
}

void Page::DrawCursChar(PageItem *b, QPainter *p, int po)
{
	QColor tmp;
	int h, s, v, sneu;
  QFont ffo;
  QString chx;
	struct Pti *hl;
	hl = b->Ptext.at(b->CPos-po);
	chx = hl->ch;
	if (chx == QChar(13))
		return;
	if (chx == QChar(30))
		{
		if (doku->MasterP)
			chx = "#";
		else
			{
			uint zae = 0;
			while (b->Ptext.at(b->CPos-po+zae)->ch == QChar(30))
				{
				zae++;
				if (b->CPos-po+zae == b->Ptext.count())
						break;
				}
			QString out="%1";
			chx = out.arg(PageNr+1, zae).right(zae).left(1);
			}
		}
	ffo = doku->UsedFonts[hl->cfont];
	if ((hl->cstyle & 127) == 0)
		ffo.setPointSize(hl->csize);
	if (hl->cstyle & 4)
		ffo.setPointSize(hl->csize);
	if (hl->cstyle & 8)
		ffo.setPointSize(hl->csize);
	if (hl->cstyle & 16)
		ffo.setPointSize(hl->csize);
	if (hl->cstyle & 32)
		ffo.setPointSize(hl->csize);
	if (hl->cstyle & 64)
		{
		if (chx.upper() != chx)
			{
			ffo.setPointSize(hl->csize * doku->VKapit / 100);
			chx = chx.upper();
			}
		else
			{
			ffo.setPointSize(hl->csize);
			}
		}
	if (hl->cstyle & 1)
		ffo.setPointSize(hl->csize * doku->VHochSc / 100);
	if (hl->cstyle & 2)
		ffo.setPointSize(hl->csize * doku->VTiefSc / 100);
	p->setFont(ffo);
	if (hl->ccolor != "None")
		{
		doku->PageColors[hl->ccolor].getRGBColor().rgb(&h, &s, &v);
		if ((h == s) && (s == v))
			{
			doku->PageColors[hl->ccolor].getRGBColor().hsv(&h, &s, &v);
			sneu = 255 - ((255 - v) * hl->cshade / 100);
			tmp.setHsv(h, s, sneu);			
			}
		else
			{
			doku->PageColors[hl->ccolor].getRGBColor().hsv(&h, &s, &v);
			sneu = s * hl->cshade / 100;
			tmp.setHsv(h, sneu, v);
			}
		}
	p->setPen(tmp);
	p->drawText(hl->xp, hl->yp, chx);
}

void Page::BlinkCurs()
{
	slotDoCurs(CursVis);
}

void Page::MarkClip(PageItem *b)
{
	uint a;
	int x, y, d;
	QPainter p;
	p.begin(this);
	p.setClipRegion(ViewReg());
	p.setClipping(true);
	Transform(b, &p);
	TransformM(b, &p);
	p.setPen(QPen(blue, 1, SolidLine, FlatCap, MiterJoin));
	p.setBrush(NoBrush);
	p.drawPolygon(b->Clip);
	for (a=0; a<b->Clip.size(); a++)
		{
		b->Clip.point(a, &x, &y);
		d = a;
		if (d == ClRe)
			{
			p.setPen(QPen(red, 8, SolidLine, RoundCap, MiterJoin));
			}
		else
			{
			p.setPen(QPen(blue, 8, SolidLine, RoundCap, MiterJoin));
			}
		p.drawLine(x, y, x, y);
		}
	p.end();
}

void Page::SetFrameRect()
{
	ClRe = -1;
  if (SelItem.count() != 0)
  	{
  	PageItem *b = Items.at(*SelItem.at(0));
  	b->Clip.setPoints(4, 0,0, int(b->Width),0, int(b->Width),int(b->Height), 0,int(b->Height));
  	update();
		b->ClipEdited = false;
		b->FrameType = 0;
  	}
}

void Page::SetFrameRounded()
{
	ClRe = -1;
  if (SelItem.count() != 0)
  	{
  	PageItem *b = Items.at(*SelItem.at(0));
  	if (b->RadRect == 0)
  		{
  		SetFrameRect();
  		return;
  		}
  	b->RadRect = QMIN(b->RadRect, QMIN(b->Width,b->Height)/2);
		float RR = b->RadRect * 2;
		QPointArray e1 = QPointArray();
		QPointArray e2 = QPointArray();
		QPointArray e3 = QPointArray();
		QPointArray e4 = QPointArray();
		e1.makeArc(0, 0, int(RR), int(RR), 1440, 1440);
		e2.makeArc(0, int(b->Height-RR), int(RR), int(RR), 2880, 1440);
		e3.makeArc(int(b->Width-RR), int(b->Height-RR), int(RR), int(RR), 4320, 1440);
		e4.makeArc(int(b->Width-RR), 0, int(RR), int(RR), 0, 1440);
		QPointArray e5 = QPointArray(e1.size()+e2.size()+e3.size()+e4.size()+1);
		for (uint ae = 0; ae < e1.size(); ae++)
			{
			e5.setPoint(ae, e1.point(ae));
			}
		for (uint ae = 0; ae < e2.size(); ae++)
			{
			e5.setPoint(ae+e1.size(), e2.point(ae));
			}
		for (uint ae = 0; ae < e3.size(); ae++)
			{
			e5.setPoint(ae+e1.size()+e2.size(), e3.point(ae));
			}
		for (uint ae = 0; ae < e4.size(); ae++)
			{
			e5.setPoint(ae+e1.size()+e2.size()+e3.size(), e4.point(ae));
			}
		e5.setPoint(e5.size()-1, e1.point(0));
		b->Clip = e5.copy();
		b->ClipEdited = false;
		b->FrameType = 2;
		emit ItemRadius(b->RadRect);
  	update();
  	}
}

void Page::SetFrameOval()
{
	uint nx = 0;
	ClRe = -1;
  if (SelItem.count() != 0)
  	{
  	QPointArray cl;
  	PageItem *b = Items.at(*SelItem.at(0));
  	cl.makeEllipse(0, 0, b->Width, b->Height);
  	b->Clip.resize(cl.size() / 2);
  	for (uint n = 0; n<cl.size(); n++)
  		{
  		if ((n % 2) == 0)
  			{
  			b->Clip.setPoint(nx, cl.point(n));
  			nx++;
  			}
  		}
		b->ClipEdited = false;
		b->FrameType = 1;
  	update();
  	}
}

void Page::ChLineWidth(int w)
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->Pwidth = w;
			RefreshItem(Items.at(*SelItem.at(a)));
			}
		}
}

void Page::ChLineArt(PenStyle w)
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->PLineArt = w;
			RefreshItem(Items.at(*SelItem.at(a)));
			}
		}
}

void Page::ChLineJoin(PenJoinStyle w)
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->PLineJoin = w;
			RefreshItem(Items.at(*SelItem.at(a)));
			}
		}
}

void Page::ChLineEnd(PenCapStyle w)
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->PLineEnd = w;
			RefreshItem(Items.at(*SelItem.at(a)));
			}
		}
}

void Page::ChLineSpa(float w)
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->LineSp = w;
			RefreshItem(Items.at(*SelItem.at(a)));
			}
		doku->Vorlagen[0].LineSpa = w;
		}
}


void Page::ChLocalXY(float x, float y)
{
	uint a;
	PageItem *b;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
  		b = Items.at(*SelItem.at(a));
			b->LocalX = x;
			b->LocalY = y;
			RefreshItem(b);
			}
		}
}

void Page::ChLocalSc(float x, float y)
{
	uint a;
	PageItem *b;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
  		b = Items.at(*SelItem.at(a));
			b->LocalScX = x;
			b->LocalScY = y;
			RefreshItem(b);
			}
		}
}

void Page::ItemFont(QString fon)
{
	uint a;
	PageItem *b = Items.at(*SelItem.at(0));
	b->IFont = fon;
	if (doku->AppMode == 1)
		{
		if (b->Ptext.count() != 0)
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				b->Ptext.at(a)->cfont = fon;
				}
			b->Dirty = true;
			RefreshItem(b);
			}
		}
	if ((b->HasSel) && (doku->AppMode == 7))
		{
		if (b->Ptext.count() != 0)
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (b->Ptext.at(a)->cselect)
					b->Ptext.at(a)->cfont = fon;
				}
			b->Dirty = true;
			b->paintObj();
			}
		}
}

void Page::ItemPen(QString farbe)
{
	uint a, b;
	PageItem *i;
	if (farbe == tr("None"))
		farbe = "None";
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
  		i = Items.at(*SelItem.at(a));
  		if (i->PType == 4)
  			{
				for (b=0; b<i->Ptext.count(); b++)
					{
					if (doku->AppMode == 7)
						{
						if (i->Ptext.at(b)->cselect)
							i->Ptext.at(b)->ccolor = farbe;
						}
					else
						i->Ptext.at(b)->ccolor = farbe;
					}
				}
			if ((i->PType == 5) && (farbe == "None"))
				break;
			i->Pcolor2 = farbe;
			RefreshItem(i);
			}
		}
}

void Page::ItemBrush(QString farbe)
{
	uint a;
	PageItem *b;
	if (farbe == tr("None"))
		farbe = "None";
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
  		b = Items.at(*SelItem.at(a));
  		if (b->PType == 4)
  			ItemPen(farbe);
  		else
  			{
				b->Pcolor = farbe;
				RefreshItem(b);
				}
			emit ItemFarben(b->Pcolor2, b->Pcolor, b->Shade2, b->Shade);
			}
		}
}

void Page::ItemBrushShade(int sha)
{
	uint a;
	PageItem *b;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
  		b = Items.at(*SelItem.at(a));
  		if (b->PType == 4)
  			ItemPenShade(sha);
  		else
				b->Shade = sha;
			emit ItemFarben(b->Pcolor2, b->Pcolor, b->Shade2, b->Shade);
			RefreshItem(b);
			}
		}
}

void Page::ItemPenShade(int sha)
{
	uint a, b;
	PageItem *i;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
  		i = Items.at(*SelItem.at(a));
  		if (i->PType == 4)
  			{
				for (b=0; b<i->Ptext.count(); b++)
					{
					if (doku->AppMode == 7)
						{
						if (i->Ptext.at(b)->cselect)
							i->Ptext.at(b)->cshade = sha;
						}
					else
						i->Ptext.at(b)->cshade = sha;
					}
				}
			i->Shade2 = sha;
			RefreshItem(i);
			}
		}
}

void Page::chTyStyle(int s)
{
	uint a;
	int old;
	PageItem *b = Items.at(*SelItem.at(0));
	if (b->Ptext.count() != 0)
		{
		if (doku->AppMode == 7)
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (b->Ptext.at(a)->cselect)
					{
					if (s == 0)
						b->Ptext.at(a)->cstyle &= ~127;
					else
						{
						old = b->Ptext.at(a)->cstyle;
						old = old ^ s;
						if ((s == 1) && (old & 2))
							old = old & ~2;
						if ((s == 2) && (old & 1))
							old = old & ~1;
						b->Ptext.at(a)->cstyle = old;
						}
					}
				}
			}
		else
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (s == 0)
					b->Ptext.at(a)->cstyle &= ~127;
				else
					{
					old = b->Ptext.at(a)->cstyle;
					old = old ^ s;
					if ((s == 1) && (old & 2))
						old = old & ~2;
					if ((s == 2) && (old & 1))
						old = old & ~1;
					b->Ptext.at(a)->cstyle = old;
					}
				}
			}
		b->Dirty = true;
		RefreshItem(b);
		}
}

void Page::SetAbStyle(int s)
{
	if (SelItem.count() == 0)
		return;
	PageItem *b = Items.at(*SelItem.at(0));
	chAbStyle(b, s);
}

void Page::chAbStyle(PageItem *b, int s)
{
	int a, ax;
	PageItem *nb;
	bool cr = true;
	if (doku->AppMode == 7)
		{
		nb = b;
		a = b->CPos;
		if (a == int(nb->Ptext.count()))
			a -= 1;
		while ((cr) && (nb != 0))
			{
			if (nb->Ptext.count() == 0)
				{
				nb = nb->BackBox;
				if (nb == 0)
					{
					cr = false;
					break;
					}
				a = int(nb->Ptext.count()-1);
				}
			ax = a;
			for (int xx=0; xx<ax+1; xx++)
				{
				if (nb->Ptext.at(a)->ch == QChar(13))
					{
					cr = false;
					break;
					}
				nb->Ptext.at(a)->cab = s;
				a--;
				}
			if (cr)
				{
				nb = nb->BackBox;
				if (nb != 0)
					a = int(nb->Ptext.count()-1);
				}
			}
		a = b->CPos;
		cr = true;
		nb = b;
		if (a == int(nb->Ptext.count()))
			cr = false;
		while ((cr) && (nb != 0))
			{
			while (a < int(nb->Ptext.count()))
				{
				nb->Ptext.at(a)->cab = s;
				if (nb->Ptext.at(a)->ch == QChar(13))
					{
					cr = false;
					break;
					}
				a++;
				}
			if (cr)
				{
				nb = nb->NextBox;
				a = 0;
				}
			}
		}
	else
		{
		b->Ausrich = s;
		if (b->Ptext.count() != 0)
			{
			for (a = 0; a < int(b->Ptext.count()); a++)
				{
				b->Ptext.at(a)->cab = s;
				}
			}
		}
	if (!b->Tinput)
		{
		b->Dirty = true;
		RefreshItem(b);
		}
}

void Page::chKerning(float us)
{
	uint a;
	PageItem *b = Items.at(*SelItem.at(0));
	if ((b->HasSel) && (doku->AppMode == 7))
		{
		if (b->Ptext.count() != 0)
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (b->Ptext.at(a)->cselect)
					{
					b->Ptext.at(a)->cextra = us;
					}
				}
			b->Dirty = true;
			RefreshItem(b);
			}
		}
	else
		{
		if (b->Ptext.count() != 0)
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				b->Ptext.at(a)->cextra = us;
				}
			b->Dirty = true;
			RefreshItem(b);
			b->ExtraV = us;
			}
		}
}

void Page::chFSize(int size)
{
	uint a;
	PageItem *b = Items.at(*SelItem.at(0));
	b->ISize = size;
	if (doku->AppMode != 7)
		{
		b->LineSp = (size * float(doku->AutoLine) / 100) + size;
		doku->Vorlagen[0].LineSpa = b->LineSp;
		emit ItemTextAttr(b->LineSp);
		}
	if (b->Ptext.count() != 0)
		{
		if (doku->AppMode == 7)
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				if (b->Ptext.at(a)->cselect)
					b->Ptext.at(a)->csize = size;
				}
			}
		else
			{
			for (a = 0; a < b->Ptext.count(); a++)
				{
				b->Ptext.at(a)->csize = size;
				}
			}
		b->Dirty = true;
		RefreshItem(b);
		}
	emit ItemTextSize(b->ISize);
}

void Page::QueryFarben()
{
	PageItem *b;
  if (SelItem.count() != 0)
  	{
  	b = Items.at(*SelItem.at(0));
  	emit ItemFarben(b->Pcolor2, b->Pcolor, b->Shade2, b->Shade);
  	}
}

void Page::ToggleBookmark()
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->isBookmark = !Items.at(*SelItem.at(a))->isBookmark;
			if (Items.at(*SelItem.at(a))->isBookmark)
				Items.at(*SelItem.at(a))->isAnnotation = false;
			}
		emit DocChanged();
		}
}

void Page::ToggleAnnotation()
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->isAnnotation = !Items.at(*SelItem.at(a))->isAnnotation;
			if (Items.at(*SelItem.at(a))->isAnnotation)
				Items.at(*SelItem.at(a))->isBookmark = false;
			}
		emit DocChanged();
		}
}

void Page::TogglePic()
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->PicArt = !Items.at(*SelItem.at(a))->PicArt;
			RefreshItem(Items.at(*SelItem.at(a)));
			}
		emit DocChanged();
		}
}

void Page::FlipImageH()
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->flippedH += 1;
			RefreshItem(Items.at(*SelItem.at(a)));
			}
		emit DocChanged();
		}
}

void Page::FlipImageV()
{
	uint a;
  if (SelItem.count() != 0)
  	{
  	for (a = 0; a < SelItem.count(); a++)
  		{
			Items.at(*SelItem.at(a))->flippedV += 1;
			RefreshItem(Items.at(*SelItem.at(a)));
			}
		emit DocChanged();
		}
}

void Page::ToBack()
{
	uint a;
  if ((Items.count() > 1) && (SelItem.count() != 0))
  	{
		PageItem *b = Items.take(*SelItem.at(0));
		Items.prepend(b);
		for (a = 0; a < Items.count(); a++)
			{
			Items.at(a)->ItemNr = a;
			}
		SelItem.clear();
		SelItem.append(&b->ItemNr);
		emit DocChanged();
		update();
		}
}

void Page::ToFront()
{
	uint a;
  if ((Items.count() > 1) && (SelItem.count() != 0))
  	{
		PageItem *b = Items.take(*SelItem.at(0));
		Items.append(b);
		for (a = 0; a < Items.count(); a++)
			{
			Items.at(a)->ItemNr = a;
			}
		SelItem.clear();
		SelItem.append(&b->ItemNr);
		emit DocChanged();
		update();
		}
}

void Page::LowerItem()
{
	uint a;
  if ((Items.count() > 1) && (SelItem.count() != 0) && (*SelItem.at(0)>0))
  	{
		PageItem *b = Items.take(*SelItem.at(0));
		Items.insert(*SelItem.at(0)-1, b);
		for (a = 0; a < Items.count(); a++)
			{
			Items.at(a)->ItemNr = a;
			}
		SelItem.clear();
		SelItem.append(&b->ItemNr);
		emit DocChanged();
		update();
		}
}

void Page::RaiseItem()
{
	uint a;
  if ((Items.count() > 1) && (SelItem.count() != 0) && (*SelItem.at(0)<Items.count()-2))
  	{
		PageItem *b = Items.take(*SelItem.at(0));
		Items.insert(*SelItem.at(0)+1, b);
		for (a = 0; a < Items.count(); a++)
			{
			Items.at(a)->ItemNr = a;
			}
		SelItem.clear();
		SelItem.append(&b->ItemNr);
		emit DocChanged();
		update();
		}
}

void Page::DeleteItem()
{
	uint a, c, itnr, anz;
	PageItem *b;
  if (SelItem.count() != 0)
  	{
  	anz = SelItem.count();
  	for (uint de=0; de<anz; de++)
  		{
	  	b = Items.at(*SelItem.at(0));
	  	if (b->PType == 4)
	  		{
	  		if ((b->NextBox != 0) || (b->BackBox != 0))
	  			{
	  			if (b->BackBox == 0)
	  				{
	  				b->NextBox->BackBox = b->BackBox;
	  				c = b->Ptext.count();
	  				for (a = 0; a < c; a++)
	  					{
	  					b->NextBox->Ptext.prepend(b->Ptext.take(b->Ptext.count()-1));
	  					}
	  				}
	  			else
	  				{
	  				b->BackBox->NextBox = b->NextBox;
	  				if (b->NextBox != 0)
	  					{
	  					b->NextBox->BackBox = b->BackBox;
	  					if (b->isAutoText)
	  						doku->LastAuto = b->BackBox;
	  					}
	  				c = b->Ptext.count();
	  				for (a = 0; a < c; a++)
 	 					{
	  					b->BackBox->Ptext.append(b->Ptext.take(0));
	  					}
	  				}
	  			}
	  		}
			Items.remove(*SelItem.at(0));
			SelItem.removeFirst();
			for (a = 0; a < Items.count(); a++)
				{
				itnr = Items.at(a)->ItemNr;
				Items.at(a)->ItemNr = a;
				for (uint dxx=0; dxx<SelItem.count(); dxx++)
					{
					if (*SelItem.at(dxx) == itnr)
						*SelItem.at(dxx) = a;
					}
				}
			}	
		SelItem.clear();
  	qApp->setOverrideCursor(QCursor(ArrowCursor), true);
		update();
		emit HaveSel(-1);
		emit DocChanged();
		}
}

void Page::Deselect()
{
	if (doku->ActPage->SelItem.count() != 0)
		{
		for (uint a = 0; a < doku->ActPage->Items.count(); a++)
			{
			if (doku->ActPage->Items.at(a)->Select)
				{
				doku->ActPage->Items.at(a)->Select = FALSE;
				RefreshItem(doku->ActPage->Items.at(a));
				}
			}
		doku->ActPage->SelItem.clear();
		}
	emit HaveSel(-1);
}

void Page::PasteItem(struct CLBuf *Buffer, bool loading)
{
	Deselect();
	float x = Buffer->Xpos;
	float y = Buffer->Ypos;
	float w = Buffer->Width;
	float h = Buffer->Height;
	int pw = Buffer->Pwidth;
	int z = 0;
	struct Pti *hg;
	switch (Buffer->PType)
		{
		case 1:
			z = PaintEllipse(x, y, w, h, pw, Buffer->Pcolor, Buffer->Pcolor2);
			break;
		case 2:
			z = PaintPict(x, y, w, h);
			Items.at(z)->LocalScX = Buffer->LocalScX;
			Items.at(z)->LocalScY = Buffer->LocalScY;
			Items.at(z)->LocalX = Buffer->LocalX;
			Items.at(z)->LocalY = Buffer->LocalY;
			Items.at(z)->Pfile = Buffer->Pfile;
			Items.at(z)->IProfile = Buffer->IProfile;
			Items.at(z)->EmProfile = Buffer->EmProfile;
			Items.at(z)->IRender = Buffer->IRender;
			Items.at(z)->UseEmbedded = Buffer->UseEmbedded;
   		LoadPict(Items.at(z)->Pfile, z);
			Items.at(z)->LocalScX = Buffer->LocalScX;
			Items.at(z)->LocalScY = Buffer->LocalScY;
			Items.at(z)->PicArt = Buffer->PicArt;
			Items.at(z)->flippedH = Buffer->flippedH;
			Items.at(z)->flippedV = Buffer->flippedV;
			Items.at(z)->BBoxX = Buffer->BBoxX;
			Items.at(z)->BBoxH = Buffer->BBoxH;
			break;
		case 3:
			z = PaintRect(x, y, w, h, pw, Buffer->Pcolor, Buffer->Pcolor2);
			break;
		case 4:
			z = PaintText(x, y, w, h, 1, Buffer->Pcolor);
			if (Buffer->Ptext != "")
				{
				QTextStream t(&Buffer->Ptext, IO_ReadOnly);
				QString cc;
				while (!t.atEnd())
					{
					cc = t.readLine();
					QStringList wt;
					QStringList::Iterator it;
					wt = QStringList::split("\t", cc);
					it = wt.begin();
					hg = new Pti;
					hg->ch = (*it);
					it++;
					hg->cfont = *it;
					it++;
					hg->csize = (*it).toInt();
					it++;
					hg->ccolor = *it;
					it++;
					hg->cextra = (*it).toFloat();
					it++;
					hg->cshade = (*it).toInt();
					hg->cselect = false;
					it++;
					if (it == NULL)
						hg->cstyle = 0;
					else
						hg->cstyle = (*it).toInt();
					it++;
					if (it == NULL)
						hg->cab = 0;
					else
						hg->cab = (*it).toInt();
					hg->xp = 0;
					hg->yp = 0;
					Items.at(z)->Ptext.append(hg);
					}
				}
			Items.at(z)->LineSp = Buffer->LineSp;
			Items.at(z)->flippedH = Buffer->flippedH;
			Items.at(z)->flippedV = Buffer->flippedV;
			break;
		case 5:
			z = PaintLine(x, y, w, h, pw, Buffer->Pcolor2);
			break;
		}
	PageItem* b = Items.at(z);
	b->RadRect = Buffer->RadRect;
	b->FrameType = Buffer->FrameType;
	b->ClipEdited = Buffer->ClipEdited;
	b->Pcolor = Buffer->Pcolor;
	b->Pcolor2 = Buffer->Pcolor2;
	b->Shade = Buffer->Shade;
	b->Shade2 = Buffer->Shade2;
	b->Rot = Buffer->Rot;
	b->Extra = Buffer->Extra;
	b->PLineArt = PenStyle(Buffer->PLineArt);
	b->PLineEnd = PenCapStyle(Buffer->PLineEnd);
	b->PLineJoin = PenJoinStyle(Buffer->PLineJoin);
	b->isPrintable = Buffer->isPrintable;
	b->isBookmark = Buffer->isBookmark;
	b->isAnnotation = Buffer->isAnnotation;
	b->AnType = Buffer->AnType;
	b->AnAction = Buffer->AnAction;
	b->AnZiel = Buffer->AnZiel;
	b->Clip = Buffer->Clip.copy();
	b->Textflow = Buffer->Textflow;
	b->Ausrich = Buffer->Ausrich;
	b->IFont = Buffer->IFont;
	b->ISize = Buffer->ISize;
	b->ExtraV = Buffer->ExtraV;
	b->Groups = Buffer->Groups;
	if (!loading)
		{	
		b->Select = true;
		SelItem.append(&b->ItemNr);
		b->paintObj();
		emit HaveSel(b->PType);
		EmitValues(b);
		emit DocChanged();
		update();
		}
	if ((b->PType == 4) && (loading))
		{
		b->Dirty = true;
		b->paintObj();
		}
}

void Page::SetupDraw(int nr)
{
	PageItem* b = Items.at(nr);
	b->Select = true;
	mCG = TRUE;
	HowTo = 1;
	qApp->setOverrideCursor(QCursor(SizeFDiagCursor), true);
	SelItem.clear();
	SelItem.append(&b->ItemNr);
	b->paintObj();
	Imoved = true;
	doku->AppMode = 1;
	emit DocChanged();
	if (b->PType == 5)
		b->Sizing = false;
	else
		b->Sizing = true;
	EmitValues(b);
}

void Page::EmitValues(PageItem *b)
{
	emit ItemPos(b->Xpos, b->Ypos);
	emit ItemGeom(b->Width, b->Height);
	emit SetAngle(b->Rot);
	emit SetSizeValue(b->Pwidth);
	emit SetLineArt(b->PLineArt, b->PLineEnd, b->PLineJoin);
	emit SetLocalValues(b->LocalScX, b->LocalScY, b->LocalX, b->LocalY );
	emit ItemFarben(b->Pcolor2, b->Pcolor, b->Shade2, b->Shade);
	emit ItemTextAttr(b->LineSp);
	emit ItemTextFont(b->IFont);
	emit ItemTextSize(b->ISize);
	emit ItemTextUSval(b->ExtraV);
	emit ItemTextAbs(b->Ausrich);
}

void Page::AlignObj(bool xa, bool ya, bool Vth, bool Vtv, float xdisp, float ydisp, int xart, int yart)
{
	uint a;
	float xp = 999999;
	float yp = 999999;
	float xm = 0;
	float xd, xo;
	QList<float> ml;
	QPainter p;
	PageItem *b;
	ml.setAutoDelete(true);
	ml.clear();
	if (xa)
		{
		if (Vth)
			{
			for (a=0; a<SelItem.count(); a++)
				{
				p.begin(this);
				b = Items.at(*SelItem.at(a));
				Transform(b, &p);
				switch (xart)
					{
					case 0:
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().x()));
						break;
					case 1:
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().x()+QRegion(p.xForm(b->Clip)).boundingRect().width() / 2));
						break;
					case 2:
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().right()));
						break;
					}
				p.end();
				}
			xp = 99999;
			xm = 0;
			for (a=0; a<SelItem.count(); a++)
				{
				xp = QMIN(*ml.at(a), xp);
				xm = QMAX(*ml.at(a), xm);
				}
			xd = (xm - xp) / (SelItem.count()-1);
			for	(a=0; a<SelItem.count(); a++)
				{
				xo = *ml.at(a);
				MoveItem((xp + xd * a) - xo, 0, *SelItem.at(a));
				}
			ml.clear();
			}
		else
			{
			switch (xart)
				{
				case 0:
					for (a=0; a<SelItem.count(); a++)
						{
						b = Items.at(*SelItem.at(a));
						p.begin(this);
						Transform(b, &p);
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().x()));
						p.end();
						}
					xp = 99999;
					for (a=0; a<SelItem.count(); a++)
						{
						xp = QMIN(*ml.at(a), xp);
						}
					for	(a=0; a<SelItem.count(); a++)
						{
						MoveItem(xp - *ml.at(a) + a*xdisp, 0, *SelItem.at(a));
						}
					ml.clear();
					break;
				case 1:
					for (a=0; a<SelItem.count(); a++)
						{
						b = Items.at(*SelItem.at(a));
						p.begin(this);
						Transform(b, &p);
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().x()+QRegion(p.xForm(b->Clip)).boundingRect().width() / 2));
						p.end();
						}
					xp = *ml.at(0);
					for	(a=0; a<SelItem.count(); a++)
						{
						MoveItem(xp - *ml.at(a) + a*xdisp, 0, *SelItem.at(a));
						}
					ml.clear();
					break;
				case 2:
					xp = 0;
					for (a=0; a<SelItem.count(); a++)
						{
						b = Items.at(*SelItem.at(a));
						p.begin(this);
						Transform(b, &p);
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().right()));
						p.end();
						}
					for (a=0; a<SelItem.count(); a++)
						{
						xp = QMAX(*ml.at(a), xp);
						}
					for	(a=0; a<SelItem.count(); a++)
						{
						MoveItem(xp - *ml.at(a) + a*xdisp, 0, *SelItem.at(a));
						}
					ml.clear();
					break;
				}
			}
		}
	if (ya)
		{
		if (Vtv)
			{
			for (a=0; a<SelItem.count(); a++)
				{
				p.begin(this);
				b = Items.at(*SelItem.at(a));
				Transform(b, &p);
				switch (yart)
					{
					case 0:
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().y()));
						break;
					case 1:
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().y()+QRegion(p.xForm(b->Clip)).boundingRect().height() / 2));
						break;
					case 2:
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().bottom()));
						break;
					}
				p.end();
				}
			xp = 99999;
			xm = 0;
			for (a=0; a<SelItem.count(); a++)
				{
				xp = QMIN(*ml.at(a), xp);
				xm = QMAX(*ml.at(a), xm);
				}
			xd = (xm - xp) / (SelItem.count()-1);
			for	(a=0; a<SelItem.count(); a++)
				{
				xo = *ml.at(a);
				MoveItem(0, (xp + xd * a) - xo, *SelItem.at(a));
				}
			ml.clear();
			}
		else
			{
			switch (yart)
				{
				case 0:
					for (a=0; a<SelItem.count(); a++)
						{
						b = Items.at(*SelItem.at(a));
						p.begin(this);
						Transform(b, &p);
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().y()));
						p.end();
						}
					yp = 99999;
					for (a=0; a<SelItem.count(); a++)
						{
						yp = QMIN(*ml.at(a), yp);
						}
					for	(a=0; a<SelItem.count(); a++)
						{
						MoveItem(0, yp - *ml.at(a) + a*ydisp, *SelItem.at(a));
						}
					ml.clear();
					break;
				case 1:
					for (a=0; a<SelItem.count(); a++)
						{
						b = Items.at(*SelItem.at(a));
						p.begin(this);
						Transform(b, &p);
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().y()+QRegion(p.xForm(b->Clip)).boundingRect().height() / 2));
						p.end();
						}
					xp = *ml.at(0);
					for	(a=0; a<SelItem.count(); a++)
						{
						MoveItem(0, xp - *ml.at(a) + a*ydisp, *SelItem.at(a));
						}
					ml.clear();
					break;
				case 2:
					yp = 0;
					for (a=0; a<SelItem.count(); a++)
						{
						b = Items.at(*SelItem.at(a));
						p.begin(this);
						Transform(b, &p);
						ml.append(new float(QRegion(p.xForm(b->Clip)).boundingRect().bottom()));
						p.end();
						}
					for (a=0; a<SelItem.count(); a++)
						{
						yp = QMAX(*ml.at(a), yp);
						}
					for	(a=0; a<SelItem.count(); a++)
						{
						MoveItem(0, yp - *ml.at(a) + a*ydisp, *SelItem.at(a));
						}
					ml.clear();
					break;
				}
			}
		}
}

/** Zeichnet eine Ellipse */
int Page::PaintEllipse(float x, float y, float b, float h, int w, QString fill, QString outline)
{
	PageItem* ite = new PageItem(this, 1, x, y, b, h, w, fill, outline, doku);
	Items.append(ite);
	ite->PLineArt = doku->DLineArt;
	ite->Shade = doku->Dshade;
	ite->Shade2 = doku->Dshade2;
	ite->ItemNr = Items.count()-1;
	if (!doku->loading)
		{
		ite->paintObj();
		}
	return ite->ItemNr;
}

/** Zeichnet einen Bildrahmen */
int Page::PaintPict(float x, float y, float b, float h)
{
	PageItem* ite = new PageItem(this, 2, x, y, b, h, 1, doku->DbrushPict, "None", doku);
	Items.append(ite);
	ite->Shade = doku->ShadePict;
	ite->LocalScX = doku->ScaleX;
	ite->LocalScY = doku->ScaleY;
	ite->IProfile = doku->CMSSettings.DefaultInputProfile;
	ite->IRender = doku->CMSSettings.DefaultIntentMonitor2;
	ite->ItemNr = Items.count()-1;
	if (!doku->loading)
		{
		ite->paintObj();
		}
	return ite->ItemNr;
}

/** Zeichnet ein Rechteck */
int Page::PaintRect(float x, float y, float b, float h, int w, QString fill, QString outline)
{
	PageItem* ite = new PageItem(this, 3, x, y, b, h, w, fill, outline, doku);
	Items.append(ite);
	ite->PLineArt = doku->DLineArt;
	ite->Shade = doku->Dshade;
	ite->Shade2 = doku->Dshade2;
	ite->ItemNr = Items.count()-1;
	if (!doku->loading)
		{
		ite->paintObj();
		}
	return ite->ItemNr;
}

/** Zeichnet einen Textrahmen */
int Page::PaintText(float x, float y, float b, float h, int w, QString outline)
{
	if (w == 0) { w = 1; }
	PageItem* ite = new PageItem(this, 4, x, y, b, h, w, "None", outline, doku);
	Items.append(ite);
	ite->ItemNr = Items.count()-1;
	if (!doku->loading)
		{
		ite->paintObj();
		}
	return ite->ItemNr;
}

/** Zeichnet eine Linie */
int Page::PaintLine(float x, float y, float b, float h, int w, QString outline)
{
	if (w == 0) { w = 1; }
	PageItem* ite = new PageItem(this, 5, x, y, b, h, w, "Black", outline, doku);
	Items.append(ite);
	ite->PLineArt = doku->DLstyleLine;
	ite->Shade2 = doku->DshadeLine;
	ite->ItemNr = Items.count()-1;
	if (!doku->loading)
		{
		ite->paintObj();
		}
	return ite->ItemNr;
}

void Page::insertColor(QString nam, float c, float m, float y, float k)
{
	if (!doku->PageColors.contains(nam))
		{
		CMYKColor tmp = CMYKColor(int(255 * c), int(255 * m), int(255 * y), int(255 * k));
		doku->PageColors.insert(nam, tmp);
		}
}

void Page::LoadPict(QString fn, int ItNr)
{
	QString tmp, dummy, cmd1, cmd2, BBox, FarNam;
	QChar tc;
	QString oldPr = doku->CMSSettings.DefaultInputProfile;
	float x, y, b, h, c, m, k;
	bool found = false;
	int ret = -1;
	QFileInfo fi = QFileInfo(fn);
	QString ext = fi.extension(false).lower();
	if ((ext == "eps") || (ext == "ps"))
		{
		QFile f(fn);
		if (f.open(IO_ReadOnly))
			{
			QTextStream ts(&f);
			while (!ts.atEnd())
				{
				tc = ' ';
				tmp = "";
				while ((tc != '\n') && (tc != '\r'))
					{
					ts >> tc;
					if ((tc != '\n') && (tc != '\r'))
						tmp += tc;
					}
				if (tmp.startsWith("%%BoundingBox"))
					{
					found = true;
					BBox = tmp;
					}
				if (tmp.startsWith("%%CMYKCustomColor"))
					{
					QTextStream ts2(&tmp, IO_ReadOnly);
					ts2 >> dummy >> c >> m >> y >> k;
					FarNam = ts2.read();
					FarNam = FarNam.stripWhiteSpace();
					FarNam = FarNam.remove(0,1);
					FarNam = FarNam.remove(FarNam.length()-1,1);
					insertColor(FarNam, c, m, y, k);
					while (!ts.atEnd())
						{
						tc = ' ';
						tmp = "";
						while ((tc != '\n') && (tc != '\r'))
							{
							ts >> tc;
							if ((tc != '\n') && (tc != '\r'))
								tmp += tc;
							}
						if (!tmp.startsWith("%%+"))
							break;
						QTextStream ts2(&tmp, IO_ReadOnly);
						ts2 >> dummy >> c >> m >> y >> k;
						FarNam = ts2.read();
						FarNam = FarNam.stripWhiteSpace();
						FarNam = FarNam.remove(0,1);
						FarNam = FarNam.remove(FarNam.length()-1,1);
						insertColor(FarNam, c, m, y, k);						
						}
					}
				if (tmp.startsWith("%%EndComments"))
					break;
				}	
			f.close();
			if (found)
				{
				QTextStream ts2(&BBox, IO_ReadOnly);
				ts2 >> dummy >> x >> y >> b >> h;
				cmd1 = "gs -q -dNOPAUSE -sDEVICE=png16m -r72 -sOutputFile=/tmp/sc.png -g";
				cmd2 = " -c showpage -c quit";
				ret = system(cmd1 + tmp.setNum(qRound(b)) + "x" + tmp.setNum(qRound(h)) + " " + fn + cmd2);
				if (ret == 0)
					{
					QImage im4;
					QImage image;
					image.load("/tmp/sc.png");
  				image = image.convertDepth(32);
					int wi = image.width();
					int hi = image.height();
					QBitmap bm("/tmp/sc.png");
					bm.fill(Qt::color1);
    			int i = 0;
    			QPainter pp;
    			pp.begin(&bm);
    			pp.setPen(Qt::color0);
    			QString tmp2;
    			if ( image.depth() == 8 ) {
        			for( int yi=0; yi < hi; yi++ ) {
            			uchar * s = image.scanLine( yi );
            			for( int xi=0; xi < wi; xi++ ) {
                			if(image.color(s[xi]) == 0xffffffff)
                				pp.drawPoint(xi, yi);
                			i++;
            			}
        			}
    			} else {
        			for( int yi=0; yi < hi; yi++ ) {
            			QRgb * s = (QRgb*)(image.scanLine( yi ));
            			for( int xi=0; xi < wi; xi++ )
                			for( xi=0; xi < wi; xi++ ) {
                					if((*s++) == 0xffffffff)
                							pp.drawPoint(xi, yi);
                    			i++;
                			}
        			}
    			}
    			pp.end();
					QPixmap pm;
					pm.convertFromImage(image);
					pm.setMask(bm);
					im4.setAlphaBuffer(true);
					im4 = pm.convertToImage();
					image = im4.copy(x, 0, b-x, h-y);
					im4 = ProofPict(&image, Items.at(ItNr)->IProfile, Items.at(ItNr)->IRender);
					Items.at(ItNr)->pixm.convertFromImage(im4);
					Items.at(ItNr)->Pfile = fn;
					Items.at(ItNr)->PicAvail = true;
					Items.at(ItNr)->PicArt = true;
					Items.at(ItNr)->isRaster = false;
					Items.at(ItNr)->BBoxX = x;
					Items.at(ItNr)->BBoxH = h;
					system("rm -f /tmp/sc.png");
					}
				else
					{
					Items.at(ItNr)->Pfile = fn;
					Items.at(ItNr)->PicAvail = false;
					Items.at(ItNr)->PicArt = false;
					}
				}
			}
		else
			{
			Items.at(ItNr)->Pfile = fn;
			Items.at(ItNr)->PicAvail = false;
			Items.at(ItNr)->PicArt = false;
			}
		return;
		}
#ifdef HAVE_TIFF
	if (ext == "tif")
		{
		QImage img;
		QImage inI2;
#ifdef HAVE_CMS
    DWORD EmbedLen = 0;
    LPBYTE EmbedBuffer;
		const char *Descriptor;
		cmsHPROFILE hIn;
#endif
		TIFF* tif = TIFFOpen(fn, "r");
		if(tif)
			{
			unsigned width, height,size;
			float xres, yres;
			TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &width);
			TIFFGetField(tif, TIFFTAG_IMAGELENGTH, &height);
			TIFFGetField(tif, TIFFTAG_XRESOLUTION, &xres);
			TIFFGetField(tif, TIFFTAG_YRESOLUTION, &yres);
			size=width*height;
			uint32 *bits=(uint32*) _TIFFmalloc(size * sizeof (uint32));
			if(bits)
				{
				if (TIFFReadRGBAImage(tif, width, height, bits, 0))
					{
        	img.create(width,height,32);
					if(TIFFGetR(0x1234567)==qRed  (0x1234567) &&
						 TIFFGetG(0x1234567)==qGreen(0x1234567) &&
						 TIFFGetB(0x1234567)==qBlue (0x1234567))
						{
						for(unsigned y=0; y<height; y++)
							memcpy(img.scanLine(height-1-y),bits+y*width,width*4);
						}
					else
						{
						uint32 *inp=bits;
						for(unsigned y=0; y<height; y++)
							{
							QRgb *row=(QRgb*) (img.scanLine(height-1-y));
							for(unsigned x=0; x<width; x++)
								{
								const uint32 col=*(inp++);
								row[x]=qRgb(TIFFGetR(col), TIFFGetG(col), TIFFGetB(col) ) | (TIFFGetA(col)<<24);
								}
							}
						}
#ifdef HAVE_CMS
					if((TIFFGetField(tif, TIFFTAG_ICCPROFILE, &EmbedLen, &EmbedBuffer)) && (Items.at(ItNr)->UseEmbedded))
						{
						hIn = cmsOpenProfileFromMem(EmbedBuffer, EmbedLen);
  					Descriptor = cmsTakeProductDesc(hIn);
						if ((int) cmsGetColorSpace(hIn) == icSigRgbData)
							{
							Items.at(ItNr)->IProfile = "Embedded " + QString(Descriptor);
							Items.at(ItNr)->EmProfile = "Embedded " + QString(Descriptor);
							inI2 = ProofPict(&img, Items.at(ItNr)->IProfile, Items.at(ItNr)->IRender, hIn);
							}
						else
							{
							if (!InputProfiles.contains(Items.at(ItNr)->IProfile))
								Items.at(ItNr)->IProfile = oldPr;
							Items.at(ItNr)->EmProfile = "";
							Items.at(ItNr)->UseEmbedded = false;
							inI2 = ProofPict(&img, Items.at(ItNr)->IProfile, Items.at(ItNr)->IRender);
							}
						cmsCloseProfile(hIn);
						}
					else
						{
						if (!InputProfiles.contains(Items.at(ItNr)->IProfile))
							Items.at(ItNr)->IProfile = oldPr;
						inI2 = ProofPict(&img, Items.at(ItNr)->IProfile, Items.at(ItNr)->IRender);
						}
#else
					inI2 = ProofPict(&img, Items.at(ItNr)->IProfile, Items.at(ItNr)->IRender);
#endif
					Items.at(ItNr)->pixm.convertFromImage(inI2);
					Items.at(ItNr)->PicAvail = true;
					Items.at(ItNr)->PicArt = true;
					Items.at(ItNr)->BBoxX = 0;
					if (Items.at(ItNr)->Pfile != fn)
						{
						Items.at(ItNr)->LocalScX = 72.0 / xres;
						Items.at(ItNr)->LocalScY = 72.0 / yres;
						}
					Items.at(ItNr)->Pfile = fn;
					Items.at(ItNr)->BBoxH = Items.at(ItNr)->pixm.height();
					Items.at(ItNr)->isRaster = true;
					}
				_TIFFfree(bits);
				}
			TIFFClose(tif);
			}
		else
			{
			Items.at(ItNr)->Pfile = fn;
			Items.at(ItNr)->PicAvail = false;
			Items.at(ItNr)->PicArt = false;
			}
		}
#endif
	else
		{
		QImage inI;
		QImage inI2;
		if (inI.load(fn))
			{
			inI = inI.convertDepth(32);
			inI2 = ProofPict(&inI, Items.at(ItNr)->IProfile, Items.at(ItNr)->IRender);
			Items.at(ItNr)->pixm.convertFromImage(inI2);
			Items.at(ItNr)->Pfile = fn;
			Items.at(ItNr)->PicAvail = true;
			Items.at(ItNr)->PicArt = true;
			Items.at(ItNr)->BBoxX = 0;
			Items.at(ItNr)->BBoxH = Items.at(ItNr)->pixm.height();
			Items.at(ItNr)->isRaster = true;
			}
		else
			{
			Items.at(ItNr)->Pfile = fn;
			Items.at(ItNr)->PicAvail = false;
			Items.at(ItNr)->PicArt = false;
			}
		}
	Items.at(ItNr)->flippedH = 0;
	Items.at(ItNr)->flippedV = 0;
	emit DocChanged();
}


