#include "prefs.h"
#include "prefs.moc"
#include "keymanager.h"
#include <qfont.h>
#include <qcolordialog.h>
#include <qcolor.h>
#include <qstringlist.h>
extern QPixmap loadIcon(QString nam);

extern "C" void* Run(QWidget *d, preV *Vor);

void* Run(QWidget *d, preV *Vor)
{
	Preferences *dia = new Preferences(d, Vor);
	return dia;
}

Preferences::Preferences( QWidget* parent, preV *Vor)
    : QDialog( parent, "pref", true, 0 )
{
    fon = &Vor->AvailFonts;
    Umrech = 1.0;
    KKC = Vor->KeyActions;
    setCaption( tr( "Preferences" ) );
  	setIcon(loadIcon("AppIcon.xpm"));
    PrefsLayout = new QVBoxLayout( this );
    PrefsLayout->setSpacing( 6 );
    PrefsLayout->setMargin( 11 );
    TabWidget3 = new QTabWidget( this, "TabWidget3" );
    TabWidget3->setMinimumSize( QSize( 450, 230 ) );
    tab = new QWidget( TabWidget3, "tab" );
    tabLayout = new QGridLayout( tab );
    tabLayout->setSpacing( 6 );
    tabLayout->setMargin( 20 );
    ButtonGroup1 = new QButtonGroup( tab, "ButtonGroup1" );
    ButtonGroup1->setTitle( tr( "GUI" ) );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 0 );
    ButtonGroup1->layout()->setMargin( 0 );
    ButtonGroup1Layout = new QGridLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );
    ButtonGroup1Layout->setSpacing( 6 );
    ButtonGroup1Layout->setMargin( 10 );
    TextGstil = new QLabel(ButtonGroup1, "dd");
    TextGstil->setText(tr("Stil"));
    ButtonGroup1Layout->addWidget( TextGstil, 0, 0 );
    GUICombo = new QComboBox( true, ButtonGroup1, "GUICombo" );
    GUICombo->insertItem( "Default-"+tr("Style" ) );
    GUICombo->insertItem( tr( "Platinum-Style" ) );
    GUICombo->insertItem( tr( "Windows-Style" ) );
    GUICombo->insertItem( tr( "Motif-Style" ) );
    GUICombo->insertItem( tr( "CDE-Style" ) );
    GUICombo->insertItem( tr( "Motif-Plus-Style" ) );
    GUICombo->setEditable(false);
    GUICombo->setCurrentItem(Vor->GUI);
    ButtonGroup1Layout->addWidget( GUICombo, 0, 1, Qt::AlignRight );
    TextGstil2 = new QLabel(ButtonGroup1, "dd");
    TextGstil2->setText(tr("Fontsize"));
    ButtonGroup1Layout->addWidget( TextGstil2, 1, 0 );
    GFsize = new QSpinBox(ButtonGroup1, "gfs" );
    GFsize->setSuffix( tr( " pts" ) );
    GFsize->setMaxValue( 22 );
    GFsize->setMinValue( 8 );
    GFsize->setValue( Vor->AppFontSize );
    ButtonGroup1Layout->addWidget( GFsize, 1, 1, Qt::AlignRight );
    tabLayout->addWidget( ButtonGroup1, 0, 0 );
    GroupBox20 = new QGroupBox( tab, "GroupBox20" );
    GroupBox20->setTitle( tr( "Units" ) );
    GroupBox20->setColumnLayout(0, Qt::Vertical );
    GroupBox20->layout()->setSpacing( 0 );
    GroupBox20->layout()->setMargin( 0 );
    GroupBox20Layout = new QHBoxLayout( GroupBox20->layout() );
    GroupBox20Layout->setAlignment( Qt::AlignTop );
    GroupBox20Layout->setSpacing( 0 );
    GroupBox20Layout->setMargin( 25 );
    UnitCombo = new QComboBox( true, GroupBox20, "UnitCombo" );
    UnitCombo->insertItem( tr( "Points (pt)" ) );
    UnitCombo->insertItem( tr( "Millimeters (mm)" ) );
    UnitCombo->setEditable(false);
    UnitCombo->setCurrentItem(Vor->Einheit);
    GroupBox20Layout->addWidget( UnitCombo );
    tabLayout->addWidget( GroupBox20, 1, 0 );
    Mouse = new QGroupBox( tab, "Mouse" );
    Mouse->setTitle( tr( "Mouse-Settings" ) );
    Mouse->setColumnLayout(0, Qt::Vertical );
    Mouse->layout()->setSpacing( 0 );
    Mouse->layout()->setMargin( 0 );
    MouseLayout = new QHBoxLayout( Mouse->layout() );
    MouseLayout->setAlignment( Qt::AlignTop );
    MouseLayout->setSpacing( 6 );
    MouseLayout->setMargin( 10 );
    Layout5 = new QGridLayout;
    Layout5->setSpacing( 6 );
    Layout5->setMargin( 0 );
    TextLabel1_2 = new QLabel( Mouse, "TextLabel1_2" );
    TextLabel1_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel1_2->sizePolicy().hasHeightForWidth() ) );
		TextLabel1_2->setText( tr( "Wheel-Jump" ) );
    Layout5->addWidget( TextLabel1_2, 0, 0 );
    SpinBox3 = new QSpinBox( Mouse, "SpinBox3" );
    SpinBox3->setMaxValue( 1000 );
    SpinBox3->setMinValue( 0 );
    SpinBox3->setLineStep( 10 );
    SpinBox3->setValue( Vor->Wheelval );
    Layout5->addWidget( SpinBox3, 0, 1 );
    TextLabel1_2_2 = new QLabel( Mouse, "TextLabel1_2_2" );
    TextLabel1_2_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel1_2_2->sizePolicy().hasHeightForWidth() ) );
    TextLabel1_2_2->setText( tr( "Grab-Radius" ) );
    Layout5->addWidget( TextLabel1_2_2, 1, 0 );
    SpinBox3_2 = new QSpinBox( Mouse, "SpinBox3_2" );
    SpinBox3_2->setMaxValue( 1000 );
    SpinBox3_2->setMinValue( 1 );
    SpinBox3_2->setLineStep( 1 );
    SpinBox3_2->setValue( Vor->GrabRad );
    Layout5->addWidget( SpinBox3_2, 1, 1 );
    MouseLayout->addLayout( Layout5 );
    tabLayout->addWidget( Mouse, 0, 1 );

    GroupBox20b = new QGroupBox( tab, "GroupBox20b" );
    GroupBox20b->setTitle( tr( "Menues" ) );
    GroupBox20b->setColumnLayout(0, Qt::Vertical );
    GroupBox20b->layout()->setSpacing( 0 );
    GroupBox20b->layout()->setMargin( 0 );
    GroupBox20bLayout = new QGridLayout( GroupBox20b->layout() );
    GroupBox20bLayout->setAlignment( Qt::AlignTop );
    GroupBox20bLayout->setSpacing( 5 );
    GroupBox20bLayout->setMargin( 10 );
    TextLabel4c = new QLabel( GroupBox20b, "TextLabel4c" );
    TextLabel4c->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel4c->sizePolicy().hasHeightForWidth() ) );
    TextLabel4c->setText( tr( "Recent Documents:" ) );
    GroupBox20bLayout->addWidget( TextLabel4c, 0, 0);
    Recen = new QSpinBox( GroupBox20b, "Recen" );
    Recen->setMaxValue( 30 );
    Recen->setMinValue( 1 );
    Recen->setValue( Vor->RecentDCount );
    GroupBox20bLayout->addWidget( Recen, 0, 1 );
    Shorty = new QPushButton(GroupBox20b, "SH");
    Shorty->setText(tr("Keyboard Shortcuts..."));
    GroupBox20bLayout->addMultiCellWidget( Shorty, 1, 1, 0, 1 );
    tabLayout->addWidget( GroupBox20b, 1, 1 );

    TabWidget3->insertTab( tab, tr( "General" ) );

    tab_2 = new QWidget( TabWidget3, "tab_2" );
    tabLayout_2 = new QGridLayout( tab_2 );
    tabLayout_2->setSpacing( 6 );
    tabLayout_2->setMargin( 11 );
    GroupBox1 = new QGroupBox( tab_2, "GroupBox1" );
    GroupBox1->setTitle( tr( "Grid Layout:" ) );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 0 );
    GroupBox1->layout()->setMargin( 0 );
    GroupBox1Layout = new QHBoxLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );
    GroupBox1Layout->setSpacing( 0 );
    GroupBox1Layout->setMargin( 10 );
    Layout10 = new QGridLayout;
    Layout10->setSpacing( 6 );
    Layout10->setMargin( 0 );
    TextLabel1 = new QLabel( GroupBox1, "TextLabel1" );
    TextLabel1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel1->sizePolicy().hasHeightForWidth() ) );
    TextLabel1->setText( tr( "Minor Grid Spacing:" ) );
    Layout10->addWidget( TextLabel1, 0, 0 );
    TextLabel2 = new QLabel( GroupBox1, "TextLabel2" );
    TextLabel2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel2->sizePolicy().hasHeightForWidth() ) );
    TextLabel2->setText( tr( "Major Grid Spacing:" ) );
    Layout10->addWidget( TextLabel2, 1, 0 );
    SpinBox1 = new QSpinBox( GroupBox1, "SpinBox1" );
    SpinBox1->setMaxValue( 1000 );
    SpinBox1->setMinValue( 1 );
    SpinBox1->setLineStep( 1 );
    Layout10->addWidget( SpinBox1, 0, 1 );
    SpinBox2 = new QSpinBox( GroupBox1, "SpinBox2" );
    SpinBox2->setMaxValue( 1000 );
    SpinBox2->setMinValue( 10 );
    SpinBox2->setLineStep( 10 );
    Layout10->addWidget( SpinBox2, 1, 1 );
    UnitChange();
    SpinBox2->setValue( qRound(Vor->DmajGrid * Umrech));
    SpinBox1->setValue( qRound(Vor->DminGrid * Umrech));
    GroupBox1Layout->addLayout( Layout10 );
    tabLayout_2->addWidget( GroupBox1, 0, 0 );
    GroupBox2 = new QGroupBox( tab_2, "GroupBox2" );
    GroupBox2->setTitle( tr( "Grid Colors:" ) );
    GroupBox2->setColumnLayout(0, Qt::Vertical );
    GroupBox2->layout()->setSpacing( 0 );
    GroupBox2->layout()->setMargin( 0 );
    GroupBox2Layout = new QHBoxLayout( GroupBox2->layout() );
    GroupBox2Layout->setAlignment( Qt::AlignTop );
    GroupBox2Layout->setSpacing( 6 );
    GroupBox2Layout->setMargin( 11 );
    Layout11 = new QGridLayout;
    Layout11->setSpacing( 6 );
    Layout11->setMargin( 0 );
    TextLabel3 = new QLabel( GroupBox2, "TextLabel3" );
    TextLabel3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel3->sizePolicy().hasHeightForWidth() ) );
    TextLabel3->setText( tr( "Minor Grid Color:" ) );
    Layout11->addWidget( TextLabel3, 0, 0 );
    TextLabel4 = new QLabel( GroupBox2, "TextLabel4" );
    TextLabel4->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel4->sizePolicy().hasHeightForWidth() ) );
    TextLabel4->setText( tr( "Major Grid Color:" ) );
    Layout11->addWidget( TextLabel4, 1, 0 );
    minColor = new QPushButton( GroupBox2, "minColor" );
    minColor->setText( tr( "" ) );
    minColor->setAutoDefault( FALSE );
    QPixmap pm = QPixmap(40, 20);
    pm.fill(Vor->DminColor);
    minColor->setPixmap(pm);
    minColor->setBackgroundColor(Vor->DminColor);
    Layout11->addWidget( minColor, 0, 1 );
    MaxColor = new QPushButton( GroupBox2, "MaxColor" );
    MaxColor->setText( tr( "" ) );
    MaxColor->setAutoDefault( FALSE );
    QPixmap pm1 = QPixmap(40, 20);
    pm1.fill(Vor->DmajColor);
    MaxColor->setPixmap(pm1);
    MaxColor->setBackgroundColor(Vor->DmajColor);
    Layout11->addWidget( MaxColor, 1, 1 );
    GroupBox2Layout->addLayout( Layout11 );
    tabLayout_2->addWidget( GroupBox2, 1, 0 );
    ButtonGroup5 = new QButtonGroup( tab_2, "ButtonGroup5" );
    ButtonGroup5->setTitle( tr( "Placing:" ) );
    ButtonGroup5->setExclusive( TRUE );
    ButtonGroup5->setColumnLayout(0, Qt::Vertical );
    ButtonGroup5->layout()->setSpacing( 0 );
    ButtonGroup5->layout()->setMargin( 0 );
    ButtonGroup5Layout = new QHBoxLayout( ButtonGroup5->layout() );
    ButtonGroup5Layout->setAlignment( Qt::AlignTop );
    ButtonGroup5Layout->setSpacing( 6 );
    ButtonGroup5Layout->setMargin( 11 );
    Layout7 = new QVBoxLayout;
    Layout7->setSpacing( 6 );
    Layout7->setMargin( 0 );
    RadioButton6 = new QRadioButton( ButtonGroup5, "RadioButton6" );
    RadioButton6->setText( tr( "In the Background" ) );
    RadioButton6->setChecked( Vor->Before );
    Layout7->addWidget( RadioButton6 );
    RadioButton7 = new QRadioButton( ButtonGroup5, "RadioButton6_2" );
    RadioButton7->setText( tr( "In the Foreground" ) );
    RadioButton7->setChecked( !Vor->Before );
    Layout7->addWidget( RadioButton7 );
    ButtonGroup5Layout->addLayout( Layout7 );
    tabLayout_2->addWidget( ButtonGroup5, 0, 1 );
    TabWidget3->insertTab( tab_2, tr( "Guides" ) );

    tab_4 = new QWidget( TabWidget3, "tab_4" );
    tabLayout_3 = new QGridLayout( tab_4 );
    tabLayout_3->setSpacing( 6 );
    tabLayout_3->setMargin( 11 );
    GroupBox4_2 = new QGroupBox( tab_4, "GroupBox4_2" );
    GroupBox4_2->setTitle( tr( "Subscript" ) );
    GroupBox4_2->setColumnLayout(0, Qt::Vertical );
    GroupBox4_2->layout()->setSpacing( 0 );
    GroupBox4_2->layout()->setMargin( 0 );
    GroupBox4_2Layout = new QHBoxLayout( GroupBox4_2->layout() );
    GroupBox4_2Layout->setAlignment( Qt::AlignTop );
    GroupBox4_2Layout->setSpacing( 6 );
    GroupBox4_2Layout->setMargin( 11 );

    Layout12 = new QGridLayout;
    Layout12->setSpacing( 6 );
    Layout12->setMargin( 0 );
    TextLabel2_3_2 = new QLabel( GroupBox4_2, "TextLabel2_3_2" );
    TextLabel2_3_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel2_3_2->sizePolicy().hasHeightForWidth() ) );
    TextLabel2_3_2->setText( tr( "Scaling:" ) );
    Layout12->addWidget( TextLabel2_3_2, 1, 0 );
    TextLabel1_5_2 = new QLabel( GroupBox4_2, "TextLabel1_5_2" );
    TextLabel1_5_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel1_5_2->sizePolicy().hasHeightForWidth() ) );
    TextLabel1_5_2->setText( tr( "Disp.:" ) );
    Layout12->addWidget( TextLabel1_5_2, 0, 0 );
    VTiefW = new QSpinBox( GroupBox4_2, "VTiefW" );
    VTiefW->setSuffix( tr( " %" ) );
    VTiefW->setMaxValue( 100 );
    VTiefW->setMinValue( 1 );
    VTiefW->setValue( Vor->DVTief );
    Layout12->addWidget( VTiefW, 0, 1 );
    VTiefWSc = new QSpinBox( GroupBox4_2, "VTiefWSc" );
    VTiefWSc->setSuffix( tr( " %" ) );
    VTiefWSc->setMaxValue( 100 );
    VTiefWSc->setMinValue( 1 );
    VTiefWSc->setValue( Vor->DVTiefSc );
    Layout12->addWidget( VTiefWSc, 1, 1 );
    GroupBox4_2Layout->addLayout( Layout12 );
    tabLayout_3->addWidget( GroupBox4_2, 1, 0 );
    GroupBox4 = new QGroupBox( tab_4, "GroupBox4" );
    GroupBox4->setTitle( tr( "Superscript" ) );
    GroupBox4->setColumnLayout(0, Qt::Vertical );
    GroupBox4->layout()->setSpacing( 0 );
    GroupBox4->layout()->setMargin( 0 );
    GroupBox4Layout = new QHBoxLayout( GroupBox4->layout() );
    GroupBox4Layout->setAlignment( Qt::AlignTop );
    GroupBox4Layout->setSpacing( 6 );
    GroupBox4Layout->setMargin( 11 );
    Layout13 = new QGridLayout;
    Layout13->setSpacing( 6 );
    Layout13->setMargin( 0 );
    TextLabel2_3 = new QLabel( GroupBox4, "TextLabel2_3" );
    TextLabel2_3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel2_3->sizePolicy().hasHeightForWidth() ) );
    TextLabel2_3->setText( tr( "Scaling:" ) );
    Layout13->addWidget( TextLabel2_3, 1, 0 );
    TextLabel1_5 = new QLabel( GroupBox4, "TextLabel1_5" );
    TextLabel1_5->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel1_5->sizePolicy().hasHeightForWidth() ) );
    TextLabel1_5->setText( tr( "Disp.:" ) );
    Layout13->addWidget( TextLabel1_5, 0, 0 );
    VHochW = new QSpinBox( GroupBox4, "VHochW" );
    VHochW->setSuffix( tr( " %" ) );
    VHochW->setMaxValue( 100 );
    VHochW->setMinValue( 1 );
    VHochW->setValue( Vor->DVHoch );
    Layout13->addWidget( VHochW, 0, 1 );
    VHochWSc = new QSpinBox( GroupBox4, "VHochWSc" );
    VHochWSc->setSuffix( tr( " %" ) );
    VHochWSc->setMaxValue( 100 );
    VHochWSc->setMinValue( 1 );
    VHochWSc->setValue( Vor->DVHochSc );
    Layout13->addWidget( VHochWSc, 1, 1 );
    GroupBox4Layout->addLayout( Layout13 );
    tabLayout_3->addWidget( GroupBox4, 0, 0 );
    GroupBox4_3 = new QGroupBox( tab_4, "GroupBox4_3" );
    GroupBox4_3->setTitle( tr( "Small Caps" ) );
    GroupBox4_3->setColumnLayout(0, Qt::Vertical );
    GroupBox4_3->layout()->setSpacing( 0 );
    GroupBox4_3->layout()->setMargin( 0 );
    GroupBox4_3Layout = new QHBoxLayout( GroupBox4_3->layout() );
    GroupBox4_3Layout->setAlignment( Qt::AlignTop );
    GroupBox4_3Layout->setSpacing( 6 );
    GroupBox4_3Layout->setMargin( 11 );
    Layout14 = new QHBoxLayout;
    Layout14->setSpacing( 6 );
    Layout14->setMargin( 0 );
    TextLabel2_3_3 = new QLabel( GroupBox4_3, "TextLabel2_3_3" );
    TextLabel2_3_3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel2_3_3->sizePolicy().hasHeightForWidth() ) );
    TextLabel2_3_3->setText( tr( "Scaling:" ) );
    Layout14->addWidget( TextLabel2_3_3 );
    SmallCaps = new QSpinBox( GroupBox4_3, "SmallCaps" );
    SmallCaps->setSuffix( tr( " %" ) );
    SmallCaps->setMaxValue( 100 );
    SmallCaps->setMinValue( 1 );
    SmallCaps->setValue( Vor->DVKapit );
    Layout14->addWidget( SmallCaps );
    GroupBox4_3Layout->addLayout( Layout14 );
    tabLayout_3->addWidget( GroupBox4_3, 0, 1 );

    GroupBox4_3a = new QGroupBox( tab_4, "GroupBox4_3a" );
    GroupBox4_3a->setTitle( tr( "Other" ) );
    GroupBox4_3a->setColumnLayout(0, Qt::Vertical );
    GroupBox4_3a->layout()->setSpacing( 0 );
    GroupBox4_3a->layout()->setMargin( 0 );
    GroupBox4_3aLayout = new QHBoxLayout( GroupBox4_3a->layout() );
    GroupBox4_3aLayout->setAlignment( Qt::AlignTop );
    GroupBox4_3aLayout->setSpacing( 6 );
    GroupBox4_3aLayout->setMargin( 11 );
    Layout14a = new QHBoxLayout;
    Layout14a->setSpacing( 6 );
    Layout14a->setMargin( 0 );
    TextLabel2_3_3a = new QLabel( GroupBox4_3a, "TextLabel2_3_3" );
    TextLabel2_3_3a->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel2_3_3a->sizePolicy().hasHeightForWidth() ) );
    TextLabel2_3_3a->setText( tr( "Automatic Linespaceing:" ) );
    Layout14a->addWidget( TextLabel2_3_3a );
    AutoLineV = new QSpinBox( GroupBox4_3a, "LineS" );
    AutoLineV->setSuffix( tr( " %" ) );
    AutoLineV->setMaxValue( 100 );
    AutoLineV->setMinValue( 1 );
    AutoLineV->setValue( Vor->AutoLine );
    Layout14a->addWidget( AutoLineV );
    GroupBox4_3aLayout->addLayout( Layout14a );
    tabLayout_3->addWidget( GroupBox4_3a, 1, 1 );

    TabWidget3->insertTab( tab_4, tr( "Typographics" ) );

    tab_3 = new QWidget( TabWidget3, "tab_3" );
    tabLayout_4 = new QHBoxLayout( tab_3 );
    tabLayout_4->setSpacing( 0 );
    tabLayout_4->setMargin( 10 );
    ButtonGroup2 = new QButtonGroup( tab_3, "ButtonGroup2" );
    ButtonGroup2->setFrameShape( QButtonGroup::NoFrame );
    ButtonGroup2->setTitle( tr( "" ) );
    ButtonGroup2->setExclusive( TRUE );
    ButtonGroup2->setColumnLayout(0, Qt::Vertical );
    ButtonGroup2->layout()->setSpacing( 0 );
    ButtonGroup2->layout()->setMargin( 0 );
    ButtonGroup2Layout = new QHBoxLayout( ButtonGroup2->layout() );
    ButtonGroup2Layout->setAlignment( Qt::AlignTop );
    ButtonGroup2Layout->setSpacing( 6 );
    ButtonGroup2Layout->setMargin( 5 );
    Layout16 = new QGridLayout;
    Layout16->setSpacing( 6 );
    Layout16->setMargin( 0 );
    TextButton = new QToolButton( ButtonGroup2, "TextButton" );
    TextButton->setText( tr( "" ) );
    TextButton->setPixmap(loadIcon("Text.xpm"));
    TextButton->setToggleButton( TRUE );
    TextButton->setOn( TRUE );
    ButtonGroup2->insert( TextButton, -1 );
    Layout16->addWidget( TextButton, 0, 0 );
    BildButton = new QToolButton( ButtonGroup2, "BildButton" );
    BildButton->setText( tr( "" ) );
    BildButton->setPixmap(loadIcon("Bild.xpm"));
    BildButton->setToggleButton( TRUE );
    ButtonGroup2->insert( BildButton, -1 );
    Layout16->addWidget( BildButton, 0, 1 );
    RectButton = new QToolButton( ButtonGroup2, "RectButton" );
    RectButton->setText( tr( "" ) );
    RectButton->setPixmap(loadIcon("Rechtecke.xpm") );
    RectButton->setToggleButton( TRUE );
    ButtonGroup2->insert( RectButton, -1 );
    Layout16->addWidget( RectButton, 1, 0 );
    OvalButton = new QToolButton( ButtonGroup2, "OvalButton" );
    OvalButton->setText( tr( "" ) );
    OvalButton->setPixmap(loadIcon("Kreise.xpm"));
    OvalButton->setToggleButton( TRUE );
    ButtonGroup2->insert( OvalButton, -1 );
    Layout16->addWidget( OvalButton, 1, 1 );
    ZoomButton = new QToolButton( ButtonGroup2, "ZoomButton" );
    ZoomButton->setText( tr( "" ) );
    ZoomButton->setPixmap(loadIcon("Lupe.xpm"));
    ZoomButton->setToggleButton( TRUE );
    ButtonGroup2->insert( ZoomButton, -1 );
    Layout16->addWidget( ZoomButton, 2, 0 );
    LineButton = new QToolButton( ButtonGroup2, "LineButton" );
    LineButton->setText( tr( "" ) );
    LineButton->setPixmap(loadIcon("Stift.xpm"));
    LineButton->setToggleButton( TRUE );
    ButtonGroup2->insert( LineButton, -1 );
    Layout16->addWidget( LineButton, 2, 1 );
    ButtonGroup2Layout->addLayout( Layout16 );
    tabLayout_4->addWidget( ButtonGroup2 );

    ToolFrame = new QFrame( tab_3, "ToolFrame" );
    ToolFrame->setFrameShape( QFrame::NoFrame );
    ToolFrame->setFrameShadow( QFrame::Plain );
    ToolFrameLayout = new QHBoxLayout( ToolFrame );
    ToolFrameLayout->setSpacing( 0 );
    ToolFrameLayout->setMargin( 10 );
    Layout15a = new QGridLayout;
    Layout15a->setSpacing( 6 );
    Layout15a->setMargin( 0 );
    TextLabel2_2 = new QLabel( ToolFrame, "TextLabel2_2" );
    TextLabel2_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel2_2->sizePolicy().hasHeightForWidth() ) );
    TextLabel2_2->setText( tr( "Default Size:" ) );
    Layout15a->addWidget( TextLabel2_2, 1, 0 );
    TextLabel1_3 = new QLabel( ToolFrame, "TextLabel1_3" );
    TextLabel1_3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel1_3->sizePolicy().hasHeightForWidth() ) );
    TextLabel1_3->setText( tr( "Default Font:" ) );
    Layout15a->addWidget( TextLabel1_3, 0, 0 );
    FontCombo = new QComboBox( true, ToolFrame, "FontCombo" );
    FontCombo->setEditable(false);
		QStringList rlist;
		rlist.clear();
    SCFontsIterator it(*fon);
    for ( ; it.current(); ++it)
    	{
    	rlist.append(it.currentKey());
    	}
    rlist.sort();
    FontCombo->insertStringList(rlist);
    for (int fc=0; fc<FontCombo->count(); fc++)
    	{
    	if (FontCombo->text(fc) == Vor->DefFont)
    		{
    		FontCombo->setCurrentItem(fc);
    		break;
    		}
    	}
    Layout15a->addWidget( FontCombo, 0, 1 );
    SizeCombo = new QComboBox( true, ToolFrame, "SizeCombo" );
    SizeCombo->setEditable(false);
		SizeCombo->insertItem(" 7 pt");
		SizeCombo->insertItem(" 9 pt");
		SizeCombo->insertItem("10 pt");
		SizeCombo->insertItem("12 pt");
		SizeCombo->insertItem("14 pt");
		SizeCombo->insertItem("18 pt");
		SizeCombo->insertItem("24 pt");
		SizeCombo->insertItem("36 pt");
		SizeCombo->insertItem("48 pt");
		SizeCombo->insertItem("60 pt");
		SizeCombo->insertItem("72 pt");
		int a;
		for (a = 0; a < SizeCombo->count(); a++)
			{
			if (SizeCombo->text(a).left(2).toInt() == Vor->DefSize)
				{
				SizeCombo->setCurrentItem(a);
				}
			}
    Layout15a->addWidget( SizeCombo, 1, 1 );
    TextLabelT1 = new QLabel( ToolFrame, "TextLabel1_3_2" );
    TextLabelT1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT1->sizePolicy().hasHeightForWidth() ) );
    TextLabelT1->setText( tr( "Text Color:" ) );
    Layout15a->addWidget( TextLabelT1, 2, 0 );
    ForegroundT = new QComboBox( true, ToolFrame, "Foreground" );
    ForegroundT->setEditable(false);
    QPixmap pm2;
    pm2 = QPixmap(15, 15);
    CListe::Iterator itc;
		for (itc = Vor->DColors.begin(); itc != Vor->DColors.end(); ++itc)
			{
			pm2.fill(Vor->DColors[itc.key()].getRGBColor());
			ForegroundT->insertItem(pm2, itc.key());
    	if (itc.key() == Vor->DpenText)
    		{
    		ForegroundT->setCurrentItem(ForegroundT->count()-1);
    		}
			}
    Layout15a->addWidget( ForegroundT, 2, 1 );
    TextLabel1_4 = new QLabel( ToolFrame, "TextLabel1_4" );
    TextLabel1_4->setMinimumSize(QSize(260, 70));
    TextLabel1_4->setText( tr( "Sample Text" ) );
    TextLabel1_4->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
    SetSample();
    Layout15a->addMultiCellWidget( TextLabel1_4, 3, 3, 0, 1 );
    ToolFrameLayout->addLayout( Layout15a );
    tabLayout_4->addWidget( ToolFrame );
		ToolFrame->hide();

    ToolFrame2 = new QFrame( tab_3, "ToolFrame" );
    ToolFrame2->setFrameShape( QFrame::NoFrame );
    ToolFrame2->setFrameShadow( QFrame::Plain );
    ToolFrame2Layout = new QHBoxLayout( ToolFrame2 );
    ToolFrame2Layout->setSpacing( 0 );
    ToolFrame2Layout->setMargin( 10 );
    Layout15b = new QGridLayout;
    Layout15b->setSpacing( 6 );
    Layout15b->setMargin( 0 );
    TextLabelT21 = new QLabel( ToolFrame2, "TextLabel1_3_2" );
    TextLabelT21->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT21->sizePolicy().hasHeightForWidth() ) );
    TextLabelT21->setText( tr( "Line Color:" ) );
    Layout15b->addWidget(TextLabelT21, 0, 0);
    TextLabelT22 = new QLabel( ToolFrame2, "TextLabel2_2" );
    TextLabelT22->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT22->sizePolicy().hasHeightForWidth() ) );
    TextLabelT22->setText( tr( "Shading:" ) );
    Layout15b->addWidget(TextLabelT22, 1, 0);
    TextLabelT23 = new QLabel( ToolFrame2, "TextLabel1_3" );
    TextLabelT23->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT23->sizePolicy().hasHeightForWidth() ) );
    TextLabelT23->setText( tr( "Fill Color:" ) );
    Layout15b->addWidget(TextLabelT23, 2, 0);
    TextLabelT24 = new QLabel( ToolFrame2, "TextLabel2_2_2" );
    TextLabelT24->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT24->sizePolicy().hasHeightForWidth() ) );
    TextLabelT24->setText( tr( "Shading:" ) );
    Layout15b->addWidget(TextLabelT24, 3, 0);
    TextLabelT25 = new QLabel( ToolFrame2, "TextLabel1_3_3" );
    TextLabelT25->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT25->sizePolicy().hasHeightForWidth() ) );
    TextLabelT25->setText( tr( "Linestyle:" ) );
    Layout15b->addWidget(TextLabelT25, 4, 0);
    TextLabelT26 = new QLabel( ToolFrame2, "TextLabel2_3_4" );
    TextLabelT26->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT26->sizePolicy().hasHeightForWidth() ) );
    TextLabelT26->setText( tr( "Linewidth:" ) );
    Layout15b->addWidget(TextLabelT26, 5, 0);
    Foreground = new QComboBox( true, ToolFrame2, "Foreground" );
    Foreground->setEditable(false);
 		Foreground->insertItem(tr("None"));
 		if (Vor->Dpen == "None")
 			Foreground->setCurrentItem(Foreground->count()-1);
    pm2 = QPixmap(15, 15);
		for (itc = Vor->DColors.begin(); itc != Vor->DColors.end(); ++itc)
			{
			pm2.fill(Vor->DColors[itc.key()].getRGBColor());
			Foreground->insertItem(pm2, itc.key());
    	if (itc.key() == Vor->Dpen)
    		{
    		Foreground->setCurrentItem(Foreground->count()-1);
    		}
			}
    Layout15b->addWidget(Foreground, 0, 1);
    Shade2 = new QSpinBox( ToolFrame2, "Shade2" );
    Shade2->setSuffix( tr( " %" ) );
    Shade2->setMaxValue( 100 );
    Shade2->setMinValue( 0 );
    Shade2->setValue( Vor->Dshade2 );
    Layout15b->addWidget(Shade2, 1, 1);
    Background = new QComboBox( true, ToolFrame2, "Background" );
    Background->setEditable(false);
 		Background->insertItem(tr("None"));
 		if (Vor->Dbrush == "None")
 			Background->setCurrentItem(Background->count()-1);
		for (itc = Vor->DColors.begin(); itc != Vor->DColors.end(); ++itc)
			{
			pm2.fill(Vor->DColors[itc.key()].getRGBColor());
			Background->insertItem(pm2, itc.key());
    	if (itc.key() == Vor->Dbrush)
    		{
    		Background->setCurrentItem(Background->count()-1);
    		}
			}
    Layout15b->addWidget(Background, 2, 1);
    Shade = new QSpinBox( ToolFrame2, "Shade" );
    Shade->setSuffix( tr( " %" ) );
    Shade->setMaxValue( 100 );
    Shade->setMinValue( 0 );
    Shade->setValue( Vor->Dshade );
    Layout15b->addWidget(Shade, 3, 1);
    Linestyle = new LineCombo(ToolFrame2);
    Linestyle->setEditable(false);
		switch (Vor->DLineArt)
			{
			case SolidLine:
				Linestyle->setCurrentItem(0);
				break;
			case DashLine:
				Linestyle->setCurrentItem(1);
				break;
			case DotLine:
				Linestyle->setCurrentItem(2);
				break;
			case DashDotLine:
				Linestyle->setCurrentItem(3);
				break;
			case DashDotDotLine:
				Linestyle->setCurrentItem(4);
				break;
			default:
				Linestyle->setCurrentItem(0);
				break;
			}
    Layout15b->addWidget(Linestyle, 4, 1);
    LineW = new QSpinBox( ToolFrame2, "LineW" );
    LineW->setSuffix( tr( " pts" ) );
    LineW->setMaxValue( 20 );
    LineW->setMinValue( 0 );
    LineW->setValue( Vor->Dwidth );
    Layout15b->addWidget(LineW, 5, 1);
    ToolFrame2Layout->addLayout( Layout15b );
    tabLayout_4->addWidget( ToolFrame2 );
		ToolFrame2->hide();
		
    ToolFrame3 = new QFrame( tab_3, "ToolFrame" );
    ToolFrame3->setFrameShape( QFrame::NoFrame );
    ToolFrame3->setFrameShadow( QFrame::Plain );
    ToolFrame3Layout = new QHBoxLayout( ToolFrame3 );
    ToolFrame3Layout->setSpacing( 0 );
    ToolFrame3Layout->setMargin( 10 );
    Layout15c = new QGridLayout;
    Layout15c->setSpacing( 6 );
    Layout15c->setMargin( 0 );
    TextLabelT31 = new QLabel( ToolFrame3, "TextLabel1_3_2" );
    TextLabelT31->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT31->sizePolicy().hasHeightForWidth() ) );
    TextLabelT31->setText( tr( "Line Color:" ) );
    Layout15c->addWidget(TextLabelT31, 0, 0);
    TextLabelT32 = new QLabel( ToolFrame3, "TextLabel2_2" );
    TextLabelT32->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT32->sizePolicy().hasHeightForWidth() ) );
    TextLabelT32->setText( tr( "Shading:" ) );
    Layout15c->addWidget(TextLabelT32, 1, 0);
    TextLabelT35 = new QLabel( ToolFrame3, "TextLabel1_3_3" );
    TextLabelT35->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT35->sizePolicy().hasHeightForWidth() ) );
    TextLabelT35->setText( tr( "Linestyle:" ) );
    Layout15c->addWidget(TextLabelT35, 2, 0);
    TextLabelT36 = new QLabel( ToolFrame3, "TextLabel2_3_4" );
    TextLabelT36->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT36->sizePolicy().hasHeightForWidth() ) );
    TextLabelT36->setText( tr( "Linewidth:" ) );
    Layout15c->addWidget(TextLabelT36, 3, 0);
    Foreground2 = new QComboBox( true, ToolFrame3, "Foreground" );
    Foreground2->setEditable(false);
    QPixmap pm3;
    pm3 = QPixmap(15, 15);
    CListe::Iterator itc2;
		for (itc2 = Vor->DColors.begin(); itc2 != Vor->DColors.end(); ++itc2)
			{
			pm3.fill(Vor->DColors[itc2.key()].getRGBColor());
			Foreground2->insertItem(pm3, itc2.key());
    	if (itc2.key() == Vor->DpenLine)
    		{
    		Foreground2->setCurrentItem(Foreground2->count()-1);
    		}
			}
    Layout15c->addWidget(Foreground2, 0, 1);
    Shade22 = new QSpinBox( ToolFrame3, "Shade2" );
    Shade22->setSuffix( tr( " %" ) );
    Shade22->setMaxValue( 100 );
    Shade22->setMinValue( 0 );
    Shade22->setValue( Vor->DshadeLine );
    Layout15c->addWidget(Shade22, 1, 1);
    Linestyle2 = new LineCombo(ToolFrame3);
    Linestyle2->setEditable(false);
		switch (Vor->DLstyleLine)
			{
			case SolidLine:
				Linestyle2->setCurrentItem(0);
				break;
			case DashLine:
				Linestyle2->setCurrentItem(1);
				break;
			case DotLine:
				Linestyle2->setCurrentItem(2);
				break;
			case DashDotLine:
				Linestyle2->setCurrentItem(3);
				break;
			case DashDotDotLine:
				Linestyle2->setCurrentItem(4);
				break;
			default:
				Linestyle2->setCurrentItem(0);
				break;
			}
    Layout15c->addWidget(Linestyle2, 2, 1);
    LineW2 = new QSpinBox( ToolFrame3, "LineW" );
    LineW2->setSuffix( tr( " pts" ) );
    LineW2->setMaxValue( 20 );
    LineW2->setMinValue( 1 );
    LineW2->setValue( Vor->DwidthLine );
    Layout15c->addWidget(LineW2, 3, 1);
    ToolFrame3Layout->addLayout( Layout15c );
    tabLayout_4->addWidget( ToolFrame3 );
		ToolFrame3->hide();
		
    ToolFrame4 = new QFrame( tab_3, "ToolFrame" );
    ToolFrame4->setFrameShape( QFrame::NoFrame );
    ToolFrame4->setFrameShadow( QFrame::Plain );
    ToolFrame4Layout = new QHBoxLayout( ToolFrame4 );
    ToolFrame4Layout->setSpacing( 0 );
    ToolFrame4Layout->setMargin( 10 );
    Layout15d = new QGridLayout;
    Layout15d->setSpacing( 6 );
    Layout15d->setMargin( 0 );
    TextLabelT42 = new QLabel( ToolFrame4, "TextLabel2_2" );
    TextLabelT42->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT42->sizePolicy().hasHeightForWidth() ) );
    TextLabelT42->setText( tr( "Minimum:" ) );
    Layout15d->addWidget(TextLabelT42, 0, 0);
    TextLabelT43 = new QLabel( ToolFrame4, "TextLabel2_2_3" );
    TextLabelT43->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT43->sizePolicy().hasHeightForWidth() ) );
    TextLabelT43->setText( tr( "Maximum:" ) );
    Layout15d->addWidget(TextLabelT43, 1, 0);
    TextLabelT44 = new QLabel( ToolFrame4, "TextLabel2_3_4" );
    TextLabelT44->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT44->sizePolicy().hasHeightForWidth() ) );
    TextLabelT44->setText( tr( "Stepping:" ) );
    Layout15d->addWidget(TextLabelT44, 2, 0);
    MinMag = new QSpinBox( ToolFrame4, "Shade2" );
    MinMag->setSuffix( tr( " %" ) );
    MinMag->setMaxValue( 800 );
    MinMag->setMinValue( 10 );
    MinMag->setLineStep( 10 );
    MinMag->setValue( Vor->MagMin );
    Layout15d->addWidget(MinMag, 0, 1);
    MaxMag = new QSpinBox( ToolFrame4, "Shade" );
    MaxMag->setSuffix( tr( " %" ) );
    MaxMag->setMaxValue( 800 );
    MaxMag->setMinValue( 10 );
    MaxMag->setLineStep( 10 );
    MaxMag->setValue( Vor->MagMax );
    Layout15d->addWidget(MaxMag, 1, 1);
    StepMag = new QSpinBox( ToolFrame4, "LineW" );
    StepMag->setSuffix( tr( " %" ) );
    StepMag->setMaxValue( 200 );
    StepMag->setMinValue( 1 );
    StepMag->setLineStep( 25 );
    StepMag->setValue( Vor->MagStep );
    Layout15d->addWidget(StepMag, 2, 1);
    ToolFrame4Layout->addLayout( Layout15d );
    tabLayout_4->addWidget( ToolFrame4 );	
		ToolFrame4->hide();

    ToolFrame5 = new QFrame( tab_3, "ToolFrame5" );
    ToolFrame5->setFrameShape( QFrame::NoFrame );
    ToolFrame5->setFrameShadow( QFrame::Plain );
    ToolFrame5Layout = new QHBoxLayout( ToolFrame5 );
    ToolFrame5Layout->setSpacing( 0 );
    ToolFrame5Layout->setMargin( 20 );
    Layout15 = new QGridLayout;
    Layout15->setSpacing( 6 );
    Layout15->setMargin( 0 );
    TextLabelT51 = new QLabel( ToolFrame5, "TextLabelT51" );
    TextLabelT51->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT51->sizePolicy().hasHeightForWidth() ) );
    TextLabelT51->setText( tr( "Horizontal Scaling" ) );
    Layout15->addWidget( TextLabelT51, 0, 0 );
    TextLabelT52 = new QLabel( ToolFrame5, "TextLabelT52" );
    TextLabelT52->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT52->sizePolicy().hasHeightForWidth() ) );
    TextLabelT52->setText( tr( "Vertical Scaling" ) );
    Layout15->addWidget( TextLabelT52, 1, 0 );
    TextLabelT53 = new QLabel( ToolFrame5, "TextLabelT53" );
    TextLabelT53->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT53->sizePolicy().hasHeightForWidth() ) );
    TextLabelT53->setText( tr( "Fill Color:" ) );
    Layout15->addWidget( TextLabelT53, 2, 0 );
    TextLabelT54 = new QLabel( ToolFrame5, "TextLabelT54" );
    TextLabelT54->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabelT54->sizePolicy().hasHeightForWidth() ) );
    TextLabelT54->setText( tr( "Shading:" ) );
    Layout15->addWidget( TextLabelT54, 3, 0 );
    XScale = new QSpinBox( ToolFrame5, "XScale" );
    XScale->setSuffix( tr( " %" ) );
    XScale->setMaxValue( 1000 );
    XScale->setMinValue( 1 );
    XScale->setValue( qRound(Vor->ScaleX * 100) );
    Layout15->addWidget( XScale, 0, 1 );
    YScale = new QSpinBox( ToolFrame5, "YScale" );
    YScale->setSuffix( tr( " %" ) );
    YScale->setMaxValue( 1000 );
    YScale->setMinValue( 1 );
    YScale->setValue( qRound(Vor->ScaleX * 100) );
    Layout15->addWidget( YScale, 1, 1 );
    Kette = new LinkButton( ToolFrame5 );
    Kette->setToggleButton( TRUE );
    Kette->setAutoRaise(true);
    Layout15->addMultiCellWidget( Kette, 0, 1, 2, 2 );
    ShadeP = new QSpinBox( ToolFrame5, "ShadeP" );
    ShadeP->setSuffix( tr( " %" ) );
    ShadeP->setMaxValue( 100 );
    ShadeP->setMinValue( 0 );
    ShadeP->setValue( Vor->ShadePict );
    Layout15->addWidget( ShadeP, 3, 1 );
    BackgroundP = new QComboBox( true, ToolFrame5, "BackgroundP" );
    BackgroundP->setEditable(false);
    BackgroundP->insertItem(tr("None"));
   	if (Vor->DbrushPict == "None")
   		BackgroundP->setCurrentItem(BackgroundP->count()-1);
		for (itc = Vor->DColors.begin(); itc != Vor->DColors.end(); ++itc)
			{
			pm2.fill(Vor->DColors[itc.key()].getRGBColor());
			BackgroundP->insertItem(pm2, itc.key());
    	if (itc.key() == Vor->DbrushPict)
    		{
    		BackgroundP->setCurrentItem(BackgroundP->count()-1);
    		}
			}
    Layout15->addMultiCellWidget( BackgroundP, 2, 2, 1, 2 );
    ToolFrame5Layout->addLayout( Layout15 );
    tabLayout_4->addWidget( ToolFrame5 );
		ToolFrame5->hide();
    TabWidget3->insertTab( tab_3, tr( "Tools" ) );

    tab_5 = new QWidget( TabWidget3, "tab_5" );
    tabLayout_5 = new QGridLayout( tab_5 );
    tabLayout_5->setSpacing( 6 );
    tabLayout_5->setMargin( 11 );

    Saving = new QGroupBox( tab_5, "Saving" );
    Saving->setTitle( tr( "Other Options" ) );
    Saving->setColumnLayout(0, Qt::Vertical );
    Saving->layout()->setSpacing( 0 );
    Saving->layout()->setMargin( 0 );
    SavingLayout = new QHBoxLayout( Saving->layout() );
    SavingLayout->setAlignment( Qt::AlignTop );
    SavingLayout->setSpacing( 6 );
    SavingLayout->setMargin( 25 );

    SaveAtQuit = new QCheckBox( Saving, "SaveAtQuit" );
    SaveAtQuit->setText( tr( "Save Contents on Exit" ) );
    SaveAtQuit->setChecked(Vor->SaveAtQ);
    SavingLayout->addWidget( SaveAtQuit );

    tabLayout_5->addWidget( Saving, 1, 0 );

    Preview = new QGroupBox( tab_5, "Preview" );
    Preview->setTitle( tr( "Preview" ) );
    Preview->setColumnLayout(0, Qt::Vertical );
    Preview->layout()->setSpacing( 0 );
    Preview->layout()->setMargin( 0 );
    PreviewLayout = new QHBoxLayout( Preview->layout() );
    PreviewLayout->setAlignment( Qt::AlignTop );
    PreviewLayout->setSpacing( 10 );
    PreviewLayout->setMargin( 24 );

    TextLabelP = new QLabel( Preview, "TextLabel1_3" );
    TextLabelP->setText( tr( "Size:" ) );
    PreviewLayout->addWidget( TextLabelP );

    PreviewSize = new QComboBox( true, Preview, "PreviewSize" );
    PreviewSize->insertItem( tr( "Small" ) );
    PreviewSize->insertItem( tr( "Medium" ) );
    PreviewSize->insertItem( tr( "Big" ) );
    PreviewSize->setEditable(false);
    switch (Vor->PSize)
    	{
    	case 40:
    		PreviewSize->setCurrentItem(0);
    		break;
    	case 60:
    		PreviewSize->setCurrentItem(1);
    		break;
    	case 80:
    		PreviewSize->setCurrentItem(2);
    		break;
    	}
    PreviewLayout->addWidget( PreviewSize );

    tabLayout_5->addWidget( Preview, 0, 0 );

    Frame6 = new QFrame( tab_5, "Frame6" );
    Frame6->setFrameShape( QFrame::NoFrame );
    Frame6->setFrameShadow( QFrame::Plain );
    Frame6->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum));

    tabLayout_5->addMultiCellWidget( Frame6, 0, 1, 1, 1 );
    TabWidget3->insertTab( tab_5, tr( "Scrapbook" ) );

    tab_6 = new QWidget( TabWidget3, "tab_6" );
    tabLayout_6 = new QHBoxLayout( tab_6 );
    tabLayout_6->setSpacing( 6 );
    tabLayout_6->setMargin( 11 );
    GroupBox10 = new QGroupBox( tab_6, "GroupBox10" );
    GroupBox10->setTitle( tr( "" ) );
    GroupBox10->setColumnLayout(0, Qt::Vertical );
    GroupBox10->layout()->setSpacing( 0 );
    GroupBox10->layout()->setMargin( 0 );
    GroupBox10Layout = new QVBoxLayout( GroupBox10->layout() );
    GroupBox10Layout->setAlignment( Qt::AlignTop );
    GroupBox10Layout->setSpacing( 6 );
    GroupBox10Layout->setMargin( 11 );
    FramesVisible = new QCheckBox( GroupBox10, "FramesVisible" );
    FramesVisible->setText( tr( "Display Frames" ) );
    FramesVisible->setChecked(Vor->ShFrames);
    GroupBox10Layout->addWidget( FramesVisible );
    SidebySide = new QCheckBox( GroupBox10, "SidebySide" );
    SidebySide->setText( tr( "Display Pages Side by Side" ) );
    SidebySide->setChecked(Vor->PagesSbS);
    GroupBox10Layout->addWidget( SidebySide );

    Layout_6b = new QHBoxLayout();
    Layout_6b->setSpacing( 0 );
    Layout_6b->setMargin( 0 );
    GroupBox20a = new QGroupBox( GroupBox10, "GroupBox20" );
    GroupBox20a->setTitle( tr( "Page-Colors" ) );
    GroupBox20a->setColumnLayout(0, Qt::Vertical );
    GroupBox20a->layout()->setSpacing( 0 );
    GroupBox20a->layout()->setMargin( 0 );
    GroupBox20aLayout = new QHBoxLayout( GroupBox20a->layout() );
    GroupBox20aLayout->setAlignment( Qt::AlignTop );
    GroupBox20aLayout->setSpacing( 10 );
    GroupBox20aLayout->setMargin( 25 );
    TextLabel4a = new QLabel( GroupBox20a, "TextLabel4" );
    TextLabel4a->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel4a->sizePolicy().hasHeightForWidth() ) );
    TextLabel4a->setText( tr( "Background:" ) );
    GroupBox20aLayout->addWidget( TextLabel4a);
    PapColor = new QPushButton( GroupBox20a, "PapColor" );
    PapColor->setText( tr( "" ) );
    PapColor->setAutoDefault( FALSE );
    QPixmap pm1a = QPixmap(40, 20);
    pm1a.fill(Vor->DpapColor);
    PapColor->setPixmap(pm1a);
    PapColor->setBackgroundColor(Vor->DpapColor);
    GroupBox20aLayout->addWidget( PapColor );
    TextLabel4b = new QLabel( GroupBox20a, "TextLabel4" );
    TextLabel4b->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, TextLabel4b->sizePolicy().hasHeightForWidth() ) );
    TextLabel4b->setText( tr( "Margins:" ) );
    GroupBox20aLayout->addWidget( TextLabel4b);
    RandColor = new QPushButton( GroupBox20a, "RColor" );
    RandColor->setText( tr( "" ) );
    RandColor->setAutoDefault( FALSE );
    pm1a.fill( Vor->DmargColor );
    RandColor->setPixmap(pm1a);
    RandColor->setBackgroundColor( Vor->DmargColor );
    GroupBox20aLayout->addWidget( RandColor );
    Layout_6b->addWidget(GroupBox20a);
    QSpacerItem* spacer2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout_6b->addItem( spacer2 );
    GroupBox10Layout->addLayout(Layout_6b);
    RandFarb = new QCheckBox( GroupBox10, "Ran" );
    RandFarb->setText( tr( "Display unprintable Area in Margin Color" ) );
    RandFarb->setChecked(Vor->RandFarbig);
    GroupBox10Layout->addWidget( RandFarb );
    tabLayout_6->addWidget( GroupBox10 );
    TabWidget3->insertTab( tab_6, tr( "Display" ) );

    PrefsLayout->addWidget( TabWidget3 );
    ToolFrame->show();
    Layout3 = new QHBoxLayout;
    Layout3->setSpacing( 6 );
    Layout3->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer );
    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setMinimumSize( QSize( 80, 30 ) );
    buttonCancel->setText( tr( "Cancel" ) );
    buttonCancel->setDefault( FALSE );
    Layout3->addWidget( buttonCancel );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer_2 );
    buttonOK = new QPushButton( this, "buttonOK" );
    buttonOK->setMinimumSize( QSize( 80, 30 ) );
    buttonOK->setText( tr( "OK" ) );
    buttonOK->setDefault( TRUE );
    Layout3->addWidget( buttonOK );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer_3 );
    PrefsLayout->addLayout( Layout3 );

    // signals and slots connections
    connect( minColor, SIGNAL( clicked() ), this, SLOT( changeMicolor() ) );
    connect( MaxColor, SIGNAL( clicked() ), this, SLOT( changeMaColor() ) );
    connect( PapColor, SIGNAL( clicked() ), this, SLOT( changePapColor() ) );
    connect( RandColor, SIGNAL( clicked() ), this, SLOT( changeRandColor() ) );
    connect( buttonOK, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect(FontCombo, SIGNAL(activated(int)), this, SLOT(SetSample()));
    connect(SizeCombo, SIGNAL(activated(int)), this, SLOT(SetSample()));
    connect(TextButton, SIGNAL(clicked()), this, SLOT(SetTool()));
    connect(RectButton, SIGNAL(clicked()), this, SLOT(SetTool()));
    connect(OvalButton, SIGNAL(clicked()), this, SLOT(SetTool()));
    connect(LineButton, SIGNAL(clicked()), this, SLOT(SetTool()));
    connect(ZoomButton, SIGNAL(clicked()), this, SLOT(SetTool()));
    connect(BildButton, SIGNAL(clicked()), this, SLOT(SetTool()));
    connect(Kette, SIGNAL(clicked()), this, SLOT(ToggleKette()));
    connect(XScale, SIGNAL(valueChanged(int)), this, SLOT(HChange()));
    connect(YScale, SIGNAL(valueChanged(int)), this, SLOT(VChange()));
    connect(UnitCombo, SIGNAL(activated(int)), this, SLOT(UnitChange()));
    connect(Shorty, SIGNAL(clicked()), this, SLOT(DefKB()));
//    setMaximumSize( sizeHint() );
}

/*
 *  Destroys the object and frees any allocated resources
 */
Preferences::~Preferences()
{
    // no need to delete child widgets, Qt does it all for us
}

void Preferences::DefKB()
{
	KeyManager *dia = new KeyManager(this, KKC);
	if (dia->exec())
		KKC = dia->KK;
	delete dia;
}

void Preferences::SetSample()
{
	QFont fo;
	fo = (*fon)[FontCombo->currentText()]->Font;
	fo.setPointSize(SizeCombo->currentText().left(2).toInt());
	TextLabel1_4->setFont(fo);
}

void Preferences::changeMaColor()
{
	QColor neu = QColor();
	neu = QColorDialog::getColor(MaxColor->backgroundColor(), this);
	if (neu.isValid())
		{
    QPixmap pm = QPixmap(40, 20);
    pm.fill(neu);
    MaxColor->setPixmap(pm);
   	MaxColor->setBackgroundColor(neu);
		}
}

void Preferences::changeMicolor()
{
	QColor neu = QColor();
	neu = QColorDialog::getColor(minColor->backgroundColor(), this);
	if (neu.isValid())
		{
    QPixmap pm = QPixmap(40, 20);
    pm.fill(neu);
    minColor->setPixmap(pm);
   	minColor->setBackgroundColor(neu);	
		}
}

void Preferences::changePapColor()
{
	QColor neu = QColor();
	neu = QColorDialog::getColor(PapColor->backgroundColor(), this);
	if (neu.isValid())
		{
    QPixmap pm = QPixmap(40, 20);
    pm.fill(neu);
    PapColor->setPixmap(pm);
   	PapColor->setBackgroundColor(neu);	
		}
}

void Preferences::changeRandColor()
{
	QColor neu = QColor();
	neu = QColorDialog::getColor(RandColor->backgroundColor(), this);
	if (neu.isValid())
		{
    QPixmap pm = QPixmap(40, 20);
    pm.fill(neu);
    RandColor->setPixmap(pm);
   	RandColor->setBackgroundColor(neu);	
		}
}

void Preferences::SetTool()
{
	ToolFrame->hide();
	ToolFrame2->hide();
	ToolFrame3->hide();
	ToolFrame4->hide();
	ToolFrame5->hide();
	if (TextButton == sender())
		ToolFrame->show();
	if (RectButton == sender())
		ToolFrame2->show();
	if (OvalButton == sender())
		ToolFrame2->show();
	if (LineButton == sender())
		ToolFrame3->show();
	if (ZoomButton == sender())
		ToolFrame4->show();
	if (BildButton == sender())
		ToolFrame5->show();
}

void Preferences::ToggleKette()
{
	if (Kette->isOn())
		{
		YScale->setValue(XScale->value());
		}		
}

void Preferences::HChange()
{
	if (Kette->isOn())
		{
		YScale->setValue(XScale->value());
		}
}

void Preferences::VChange()
{
	if (Kette->isOn())
		{
		XScale->setValue(YScale->value());
		}
}

void Preferences::UnitChange()
{
	if (UnitCombo->currentItem() == 0)
		{
		Umrech = 1.0;
    SpinBox1->setSuffix( tr( " pt" ) );
    SpinBox2->setSuffix( tr( " pt" ) );
		}
	else
		{
		Umrech = 0.3527777;
    SpinBox1->setSuffix( tr( " mm" ) );
    SpinBox2->setSuffix( tr( " mm" ) );
		}
}

