/***************************************************************************
                          cmykcolor.cpp  -  description
                             -------------------
    begin                : Sun Sep 9 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cmykcolor.h"
#include "config.h"
#ifdef HAVE_CMS
	#include <lcms.h>
extern cmsHPROFILE CMSinputProf;
extern cmsHPROFILE CMSoutputProf;
extern cmsHPROFILE CMSprinterProf;
extern bool SoftProofing;
extern bool CMSuse;
extern int IntentMonitor;
extern int IntentPrinter;
#endif

CMYKColor::CMYKColor(int c, int m, int y, int k)
{
	setColor(c, m, y, k);
	Spot = false;
}

CMYKColor::~CMYKColor()
{
}

void CMYKColor::setColor(int c, int m, int y, int k)
{
	C = c;
	M = m;
	Y = y;
	K = k;
	RecalcRGB();
}

void CMYKColor::setColorRGB(int r, int g, int b)
{
	int c = 255 - r;
	int m = 255 - g;
	int y = 255 - b;
	int k = QMIN(QMIN(c, m), y);
	C = c - k;
	M = m - k;
	Y = y - k;
	K = k;
	RGB = QColor(r, g, b);
}

void CMYKColor::fromQColor(QColor f)
{
	int r, g, b;
	f.rgb(&r, &g, &b);
	setColorRGB(r, g, b);
}

QColor CMYKColor::getRGBColor()
{
	return RGB;
}

void CMYKColor::getCMYK(int *c, int *m, int *y, int *k)
{
	*c = C;
	*m = M;
	*y = Y;
	*k = K;
}

void CMYKColor::applyGCR()
{
	int k = QMIN(QMIN(C, M), Y);
	C = C - k;
	M = M - k;
	Y = Y - k;
	K = QMIN((K + k), 255);
}

QString CMYKColor::name()
{
	QString tmp, tmp2;
	tmp2 = "#";
	tmp.setNum(C, 16);
	if (tmp.length() < 2)
		tmp.insert(0, "0");
	tmp2 += tmp;
	tmp.setNum(M, 16);
	if (tmp.length() < 2)
		tmp.insert(0, "0");
	tmp2 += tmp;
	tmp.setNum(Y, 16);
	if (tmp.length() < 2)
		tmp.insert(0, "0");
	tmp2 += tmp;
	tmp.setNum(K, 16);
	if (tmp.length() < 2)
		tmp.insert(0, "0");
	tmp2 += tmp;
	return tmp2;
}

void CMYKColor::setNamedColor(QString nam)
{
	bool ok;
	int c = nam.mid(1,2).toInt(&ok, 16);
	int m = nam.mid(3,2).toInt(&ok, 16);
	int y = nam.mid(5,2).toInt(&ok, 16);
	int k = nam.mid(7,2).toInt(&ok, 16);
	setColor(c, m, y, k);
}

void CMYKColor::RecalcRGB()
{
	RGB = QColor(255-QMIN(255, C+K), 255-QMIN(255,M+K), 255-QMIN(255,Y+K));
	if ((C == M) && (M == Y))
		return;
#ifdef HAVE_CMS
	if ((CMSuse) && (SoftProofing))
		{
  	WORD inC[3];
  	WORD outC[3];
  	int r, g, b;
  	RGB.rgb(&r, &g, &b);
  	inC[0] = r*257;
  	inC[1] = g*257;
  	inC[2] = b*257;
  	inC[3] = 0;
		cmsHTRANSFORM xform, xfor2;
  	DWORD dwOut;
  	icColorSpaceSignature OutputColorSpace;
  	OutputColorSpace = cmsGetColorSpace(CMSprinterProf);
  	dwOut = BYTES_SH(2) | CHANNELS_SH(_cmsChannelsOf(OutputColorSpace));
		xform = cmsCreateTransform(CMSinputProf, TYPE_RGB_8,
															 CMSprinterProf, dwOut,
															 IntentPrinter,
															 cmsFLAGS_NOTPRECALC);
		xfor2 = cmsCreateTransform(CMSprinterProf, dwOut,
															 CMSoutputProf, TYPE_RGB_8,
															 IntentMonitor,
															 cmsFLAGS_NOTPRECALC);
		cmsDoTransform(xform, inC, outC, 1);
		cmsDoTransform(xfor2, outC, inC, 1);
		cmsDeleteTransform(xform);
		cmsDeleteTransform(xfor2);
		RGB = QColor(inC[0]/257, inC[1]/257, inC[2]/257);
		}
	else
		{
		if (CMSuse)
			{
  		WORD inC[3];
  		WORD outC[3];
  		int r, g, b;
  		RGB.rgb(&r, &g, &b);
  		inC[0] = r*257;
  		inC[1] = g*257;
  		inC[2] = b*257;
  		inC[3] = 0;
			cmsHTRANSFORM xform;
			xform = cmsCreateTransform(CMSinputProf, TYPE_RGB_8,
															 	 CMSoutputProf, TYPE_RGB_8,
															 	 IntentMonitor,
															 	 cmsFLAGS_NOTPRECALC);
			cmsDoTransform(xform, inC, outC, 1);
			cmsDeleteTransform(xform);
			RGB = QColor(inC[0]/257, inC[1]/257, inC[2]/257);
			}
		}
#endif
}
