;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribetext/text.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:03:53 2001                          */
;*    Last change :  Wed Jan  9 16:05:58 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The translator scribe->text                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribetext_text
   
   (library scribeapi)

   (import  __scribetext_justify
	    __scribetext_table
	    __scribetext_info)
   
   (export  (generic ascii ::obj)))

;*---------------------------------------------------------------------*/
;*    title-number ::%block ...                                        */
;*---------------------------------------------------------------------*/
(define-generic (title-number obj::%container)
   "")

;*---------------------------------------------------------------------*/
;*    title-number ::%chapter ...                                      */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%chapter)
   (with-access::%chapter obj (number)
      (if (number? (not number))
	  ""
	  (->string (*scribe-chapter-numbering* number)))))

;*---------------------------------------------------------------------*/
;*    do-number ...                                                    */
;*---------------------------------------------------------------------*/
(define (do-number sup cur)
   (if (and (string? sup) (not (=fx (string-length sup) 0)))
       (string-append sup "." cur)
       cur))

;*---------------------------------------------------------------------*/
;*    title-number ::%section ...                                      */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%section)
   (with-access::%section obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-section-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-section-numbering* number)))))))

;*---------------------------------------------------------------------*/
;*    title-number ::%subsection ...                                   */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%subsection)
   (with-access::%subsection obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-subsection-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-subsection-numbering* number)))))))

;*---------------------------------------------------------------------*/
;*    title-number ::%subsubsection ...                                */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%subsubsection)
   (with-access::%subsubsection obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-subsubsection-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-subsubsection-numbering* number)))))))

;*---------------------------------------------------------------------*/
;*    *text-string-processor* ...                                      */
;*---------------------------------------------------------------------*/
(define *text-string-processor*
   (lambda (x) x))

;*---------------------------------------------------------------------*/
;*    ascii ::obj ...                                                  */
;*---------------------------------------------------------------------*/
(define-generic (ascii obj::obj)
   (cond
      ((procedure? obj)
       (ascii (obj)))
      ((string? obj)
       (output (*text-string-processor* obj)))
      ((number? obj)
       (output (*text-string-processor* (number->string obj))))
      ((char? obj)
       (output (*text-string-processor* (string obj))))
      ((eq? obj #unspecified)
       obj)
      ((list? obj)
       (for-each ascii obj))
      ((or (symbol? obj) (boolean? obj))
       "")
      (else
       (with-access::%node obj (loc)
	  (error/location "ascii"
			  "Can't find method for node"
			  (find-runtime-type obj)
			  (car loc)
			  (cdr loc))))))

;*---------------------------------------------------------------------*/
;*    ascii ::%document ...                                            */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%document)
   (with-document
    obj
    (lambda ()
       (with-access::%document obj (title authors body footnotes)
	  (scribe-document->ascii title authors body)
	  (if (pair? footnotes)
	      (begin
		 (with-justification
		  (make-justifier *text-column-width* 'left)
		  (lambda ()
		     (newline)
		     (newline)
		     (print "-------------")
		     (for-each (lambda (fn)
				  (with-access::%footnote fn (number note id)
				     (output (string-append
					      "*"
					      (number->string number)
					      ": "))
				     (ascii note)
				     (output-newline)))
			       footnotes)))))))))

;*---------------------------------------------------------------------*/
;*     scribe-document->ascii ...                                      */
;*---------------------------------------------------------------------*/
(define (scribe-document->ascii title authors body)
   (define (ascii-authors1 author)
      (ascii author)
      (output-newline)
      (output-newline))
   (define (ascii-authorsN authors cols first)
      (define (make-row authors . opt)
	 (apply tr (map (lambda (v)
			   (apply td :align 'center :valign 'top v opt))
			authors)))
      (define (make-rows authors)
	 (let loop ((authors authors)
		    (rows '())
		    (row '())
		    (cnum 0))
	    (cond
	       ((null? authors)
		(reverse! (cons (make-row (reverse! row)) rows)))
	       ((= cnum cols)
		(loop authors
		      (cons (make-row (reverse! row)) rows)
		      '()
		      0))
	       (else
		(loop (cdr authors)
		      rows
		      (cons (car authors) row)
		      (+fx cnum 1))))))
      (ascii (apply table
		    (if first
			(cons (make-row (list (car authors)) :colspan cols)
			      (make-rows (cdr authors)))
			(make-rows authors)))))
   (define (ascii-authors authors)
      (if (pair? authors)
	  (begin
	     (output-newline)
	     (output "--o-0-o--")
	     (output-newline)
	     (output-newline)
	     (let ((len (length authors)))
		(case len
		   ((1)
		    (ascii-authors1 (car authors)))
		   ((2 3)
		    (ascii-authorsN authors len #f))
		   ((4)
		    (ascii-authorsN authors 2 #f))
		   (else
		    (ascii-authorsN authors 3 #t)))))))
   ;; display the title and the authors
   (define (ascii-title title authors)
      (with-justification
       (make-justifier (justification-width) 'center)
       (lambda () 
	  (output (make-string *text-column-width* #\=))
	  (output-newline)
	  (if (string? title)
	      (output (list->string
		       (apply append
			      (map (lambda (c) (list c #a008))
				   (string->list title)))))
	      (ascii title))
	  (output-newline)
	  (ascii-authors authors)
	  (output (make-string *text-column-width* #\=))
	  (output-newline)
	  (output-newline)
	  (output-flush *margin*))))
   ;; display the footer
   (define (ascii-footer)
      (if *scribe-footer*
	  (with-justification
	   (make-justifier *text-column-width* 'left)
	   (lambda ()
	      (ascii *scribe-footer*)))))
   ;; the title
   (ascii-title title authors)
   (output-flush 0)
   ;; the body
   (ascii body)
   (output-flush 0)
   ;; the footer of the document
   (ascii-footer)
   (output-flush 0)
   ;; we are done
   (newline)
   (newline))

;*---------------------------------------------------------------------*/
;*    ascii ::%author ...                                              */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%author)
   (with-access::%author obj (name affiliation email url address phone)
      (if (or (pair? name) (string? name))
	  (ascii name))
      (if affiliation (begin (output-newline) (output affiliation)))
      (if (pair? address)
	  (for-each (lambda (x) (output-newline) (output x)) address))
      (if email (begin (output-newline) (output email)))
      (if url (begin (output-newline) (output url)))
      (if phone (begin (output-newline) (output phone)))
      (output-newline)))
   
;*---------------------------------------------------------------------*/
;*    scribe->html ::%toc ...                                          */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%toc)
   (with-access::%toc obj (chapter section)
      ;; display the toc for a subsectino
      (define (subsection-toc s margin)
	 (with-access::%subsection s (toc number title)
	    (if margin (output (make-string margin #\space)))
	    (ascii-subsection-ref s)
	    (output-newline)))
      ;; display the toc for a section
      (define (section-toc s margin subsection)
	 (with-access::%section s (toc number title children)
	    (if (and toc
		     (or (eq? section #t)
			 (and (pair? section) (member title section))))
		(begin
		   (if margin (output (make-string margin #\space)))
		   (ascii-section-ref s)
		   (output-newline)))
	    (if subsection
		(for-each (lambda (x)
			     (if (%subsection? x)
				 (subsection-toc x (+ margin 4))))
			  (section-subsections s)))))
      ;; display the toc for a chapter
      (define (chapter-toc c)
	 (with-access::%chapter c (toc number subtitle)
	    (if (and toc
		     (or (eq? chapter #t)
			 (and (pair? chapter) (member subtitle chapter))))
		(begin
		   (ascii-chapter-ref c)
		   (output-newline)))
	    (for-each (lambda (x)
			 (section-toc x 4 #f))
		      (chapter-sections c))))
      
      (define (partial-toc)
	 (let ((sections (if (current-chapter)
			     (chapter-sections (current-chapter))
			     (document-sections (current-document)))))
	    (for-each (lambda (x) (section-toc x 0 #t)) sections)))
      (define (full-toc)
	 ;; the top-level sections
	 (for-each (lambda (x)
		      (section-toc x 0 #f))
		   (document-sections (current-document)))
	 ;; the chapters
	 (for-each chapter-toc (document-chapters (current-document))))
      ;; the diplay of the toc
      (if (eq? (%toc-chapter obj) #t)
	  ;; %toc-chapter may be a list of chapters
	  (full-toc)
	  (partial-toc))))

;*---------------------------------------------------------------------*/
;*    ascii ::%text ...                                                */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%text)
   (ascii (%text-body obj)))

;*---------------------------------------------------------------------*/
;*    ascii ::%linebreak ...                                           */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%linebreak)
   (let loop ((num (%linebreak-repetition obj)))
      (output-newline)
      (if (>fx num 1)
	  (begin
	     (output-newline)
	     (loop (-fx num 1))))))

;*---------------------------------------------------------------------*/
;*    ascii ::%center ...                                              */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%center)
   (with-justification (make-justifier (justification-width) 'center)
		       (lambda ()
			  (ascii (%center-body obj)))))

;*---------------------------------------------------------------------*/
;*    ascii ::%flush ...                                               */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%flush)
   (with-access::%flush obj (side)
      (with-justification (make-justifier (justification-width) side)
			  (lambda ()
			     (ascii (%flush-body obj))))))

;*---------------------------------------------------------------------*/
;*    ascii ::%atom ...                                                */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%atom)
   (print (%atom-value obj)))

;*---------------------------------------------------------------------*/
;*    ascii ::%emph ...                                                */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%emph)
   (output "_")
   (ascii (%emph-body obj))
   (output "_"))

;*---------------------------------------------------------------------*/
;*    ascii ::%underline ...                                           */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%underline)
   (output "_")
   (ascii (%underline-body obj))
   (output "_"))

;*---------------------------------------------------------------------*/
;*    ascii ::%sup ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%sup)
   (with-access::%sup obj (body)
      (output "^")
      (ascii body)))

;*---------------------------------------------------------------------*/
;*    ascii ::%sub ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%sub)
   (with-access::%sub obj (body)
      (output "_")
      (ascii body)))

;*---------------------------------------------------------------------*/
;*    ascii ::%pre ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%pre)
   (with-justification (make-justifier *text-column-width* 'verbatim)
		       (lambda ()
			  (ascii (%pre-body obj))
			  (output-newline))))

;*---------------------------------------------------------------------*/
;*    ascii ::%code ...                                                */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%code)
   (with-access::%code obj (body)
      (output "`")
      (ascii body)
      (output "'")))

;*---------------------------------------------------------------------*/
;*    ascii ::%samp ...                                                */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%samp)
   (with-access::%samp obj (body)
      (output "`")
      (ascii body)
      (output "'")))

;*---------------------------------------------------------------------*/
;*    ascii ::%var ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%var)
   (with-access::%var obj (body)
      (let ((old *text-string-processor*))
	 (set! *text-string-processor* string-upcase)
	 (let ((res (ascii body)))
	    (set! *text-string-processor* old)
	    res))))

;*---------------------------------------------------------------------*/
;*    mark ...                                                         */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%mark)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    reference ...                                                    */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%reference)
   (with-access::%reference obj (body anchor)
      (multiple-value-bind (file mark)
	 (find-reference obj (current-document))
	 (if (not mark)
	     (begin
		(warning "ref" "Can't find reference -- " anchor)
		(output "reference:???"))
	     (ascii body)))))

;*---------------------------------------------------------------------*/
;*    ascii ::%url-ref ...                                             */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%url-ref)
   (with-access::%url-ref obj (url anchor body)
      (ascii body)
      (output " (")
      (ascii url)
      (if anchor
	  (begin
	     (display "#")
	     (ascii anchor)))
      (output ")")))
   
;*---------------------------------------------------------------------*/
;*    ascii ::%chapter-ref ...                                         */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%chapter-ref)
   (multiple-value-bind (_ chapter)
      (find-reference obj (current-document))
      (if (not chapter)
	  (with-access::%chapter-ref obj (anchor)
	     (warning "ref" "Can't find chapter -- " anchor)
	     (output "chapter:???"))
	  (ascii-chapter-ref chapter))))

;*---------------------------------------------------------------------*/
;*    ascii-chapter-ref ...                                            */
;*---------------------------------------------------------------------*/
(define (ascii-chapter-ref obj::%chapter)
   (output (make-chapter-title obj #f)))

;*---------------------------------------------------------------------*/
;*    ascii ::%section-ref ...                                         */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%section-ref)
   (multiple-value-bind (_ section)
      (find-reference obj (current-document))
      (if (not (%section? section))
	  (with-access::%section-ref obj (anchor)
	     (warning "ref" "Can't find section -- " anchor)
	     (output "section:???"))
	  (ascii-section-ref section))))

;*---------------------------------------------------------------------*/
;*    ascii-section-ref ...                                            */
;*---------------------------------------------------------------------*/
(define (ascii-section-ref obj::%section)
   (output (make-section-title obj)))
   
;*---------------------------------------------------------------------*/
;*    ascii ::%subsection-ref ...                                      */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%subsection-ref)
   (multiple-value-bind (_ subsection)
      (find-reference obj (current-document))
      (if (not (%subsection? subsection))
	  (with-access::%subsection-ref obj (anchor)
	     (warning "ref" "Can't find subsection -- " anchor)
	     (output "subsection:???"))
	  (ascii-subsection-ref subsection))))

;*---------------------------------------------------------------------*/
;*    ascii-subsection-ref ...                                         */
;*---------------------------------------------------------------------*/
(define (ascii-subsection-ref obj::%subsection)
   (output (make-subsection-title obj)))
   
;*---------------------------------------------------------------------*/
;*    ascii ::%subsubsection-ref ...                                   */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%subsubsection-ref)
   (multiple-value-bind (_ subsubsection)
      (find-reference obj (current-document))
      (if (not (%subsubsection? subsubsection))
	  (with-access::%subsubsection-ref obj (anchor)
	     (warning "ref" "Can't find subsubsection -- " anchor)
	     (output "subsubsection:???"))
	  (ascii-subsubsection-ref subsubsection))))

;*---------------------------------------------------------------------*/
;*    ascii-subsubsection-ref ...                                      */
;*---------------------------------------------------------------------*/
(define (ascii-subsubsection-ref obj::%subsubsection)
   (output (make-subsubsection-title obj)))

;*---------------------------------------------------------------------*/
;*    mailto ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%mailto)
   (with-access::%mailto obj (email body)
      (if (pair? body)
	  (ascii body)
	  (output email))))

;*---------------------------------------------------------------------*/
;*    ascii ::%item ...                                                */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%item)
   (with-access::%item obj (value body)
      (if (not (null? value))
	  (begin
	     (ascii value)
	     (display ": ")))
      (ascii body)))

;*---------------------------------------------------------------------*/
;*    ascii ::%itemize ...                                             */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%itemize)
   (with-access::%itemize obj (items)
      (for-each (lambda (item)
		   (with-justification (make-justifier
					(-fx (justification-width) 3)
					'left)
				       (lambda ()
					  (output "- ")
					  (ascii item))
				       3))
		items)))
      
;*---------------------------------------------------------------------*/
;*    ascii ::%enumerate ...                                           */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%enumerate)
   (with-access::%enumerate obj (items)
      (let loop ((num 1)
		 (items items))
	 (if (pair? items)
	     (let ((item (car items)))
		(with-justification (make-justifier
				     (-fx (justification-width) 3)
				     'left)
				    (lambda ()
				       (output (integer->string num))
				       (output " - ")
				       (ascii item))
				    3)
		(loop (+fx num 1) (cdr items)))))))
      
;*---------------------------------------------------------------------*/
;*    ascii ::%description ...                                         */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%description)
   (with-access::%description obj (items)
      (for-each (lambda (item)
		   (with-justification (make-justifier
					(-fx (justification-width) 3)
					'left)
				       (lambda ()
					  (with-access::%item item (value body)
					     (output "*")
					     (if (pair? value)
						 (let loop ((vs value))
						    (ascii (car vs))
						    (if (pair? (cdr vs))
							(begin
							   (output " ")
							   (loop (cdr vs)))))
						 (ascii value))
					     (output "* ")
					     (ascii body)))
				       3))
		items)))
      
;*---------------------------------------------------------------------*/
;*    make-section-title ...                                           */
;*---------------------------------------------------------------------*/
(define (make-section-title obj)
   (with-access::%section obj (title number)
      (if (not number)
	  title
	  (string-append (title-number obj) " -- "
			 (if (string? title)
			     title
			     (with-output-to-string 
				(lambda () (ascii title))))))))

;*---------------------------------------------------------------------*/
;*    ascii ::%section ...                                             */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%section)
   (with-access::%section obj (body title)
      (output-newline)
      (output-flush *margin*)
      (let ((t (make-section-title obj)))
	 (print t)
	 (print (make-string (string-length t) #\*)))
      (with-justification (make-justifier *text-column-width*
					  *text-justification*)
			  (lambda () (ascii body)))))

;*---------------------------------------------------------------------*/
;*    make-subsection-title ...                                        */
;*---------------------------------------------------------------------*/
(define (make-subsection-title obj)
   (with-access::%subsection obj (title number)
      (if (not number)
	  title
	  (string-append (title-number obj) " -- "
			 (if (string? title)
			     title
			     (with-output-to-string 
				(lambda () (ascii title))))))))

;*---------------------------------------------------------------------*/
;*    ascii ::%subsection ...                                          */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%subsection)
   (with-access::%subsection obj (body title)
      (output-flush *margin*)
      (let ((t (make-subsection-title obj)))
	 (print t)
	 (print (make-string (string-length t) #\-)))
      (ascii body)))

;*---------------------------------------------------------------------*/
;*    make-subsubsection-title ...                                     */
;*---------------------------------------------------------------------*/
(define (make-subsubsection-title obj)
   (with-access::%subsubsection obj (title number)
      (if (not number)
	  title
	  (string-append (title-number obj) " -- " title))))

;*---------------------------------------------------------------------*/
;*    ascii ::%subsubsection ...                                       */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%subsubsection)
   (with-access::%subsubsection obj (body title)
      (output-flush *margin*)
      (let ((t (make-subsubsection-title obj)))
	 (print t)
	 (print (make-string (string-length t) #\~)))
      (ascii body)))

;*---------------------------------------------------------------------*/
;*    ascii ::%paragraph ...                                           */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%paragraph)
   (with-access::%paragraph obj (body)
      (output-newline)
      (output-flush *margin*)
      (ascii body)))

;*---------------------------------------------------------------------*/
;*    make-chapter-title ...                                           */
;*---------------------------------------------------------------------*/
(define (make-chapter-title obj full)
   (with-access::%chapter obj (title subtitle number parent)
      (let* ((doc parent)
	     (title (cond
		       (title
			title)
		       ((and full
			     (%document? doc)
			     (or (string? (%document-title doc))
				 (and (pair? (%document-title doc))
				      (string? (car (%document-title doc))))))
			(string-append (if (string? (%document-title doc))
					   (%document-title doc)
					   (car (%document-title doc)))
				       " -- "
				       subtitle))
		       (else
			subtitle))))
	 (if (not number)
	     title
	     (string-append (title-number obj) " -- "
			    (if (string? title)
				title
				(with-output-to-string 
				   (lambda () (ascii title)))))))))

;*---------------------------------------------------------------------*/
;*    ascii ::%chapter ...                                             */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%chapter)
   (with-access::%chapter obj (body file title subtitle)
      (output-newline)
      (output-flush *margin*)
      (print (make-string *text-column-width* #\=))
      (newline)
      (output-center (make-chapter-title obj #t))
      (newline)
      (print (make-string *text-column-width* #\=))
      (ascii body)))

;*---------------------------------------------------------------------*/
;*    ascii ::%hrule ...                                               */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%hrule)
   (with-access::%hrule obj (width)
      (let ((w (if (= width 1.)
		   (justification-width)
		   (inexact->exact (* (exact->inexact (justification-width))
				      (/ (exact->inexact width) 100.))))))
	 (output (make-string w #\-)))))

;*---------------------------------------------------------------------*/
;*    ascii ::%font ...                                                */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%font)
   (with-access::%font obj (body)
      (ascii body)))

;*---------------------------------------------------------------------*/
;*    ascii ::%image ...                                               */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%image)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    ascii ::%table ...                                               */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%table)
   (with-access::%table obj (border loc)
      (output-flush *margin*)
      (if border
	  (border-table->ascii obj)
	  (table->ascii obj ascii))
      (output-flush *margin*)))

;*---------------------------------------------------------------------*/
;*    border-table->ascii ...                                          */
;*---------------------------------------------------------------------*/
(define (border-table->ascii table)
   (table->ascii table ascii))

;*---------------------------------------------------------------------*/
;*    ascii ::%character ...                                           */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%character)
   (case (%character-value obj)
      ((copyright)
       (display "(c)"))
      ((#\space)
       (display #\space))
      ((#\tab)
       (display #\tab))))

;*---------------------------------------------------------------------*/
;*    ascii ::%hook ...                                                */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%hook)
   (with-access::%hook obj (body before after process)
      (if (procedure? before)
	  (let ((bef (before)))
	     (if process (ascii bef))))
      (call-next-method)
      (if (procedure? after)
	  (let ((af (after)))
	     (if process (ascii af))))))

;*---------------------------------------------------------------------*/
;*    ascii ::%figure ...                                              */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%figure)
   (with-access::%figure obj (body legend number)
      (output-newline)
      (ascii body)
      (output-newline)
      (output-newline)
      (output "Fig. ")
      (output (number->string number))
      (output ": ")
      (ascii legend)
      (output-newline)))

;*---------------------------------------------------------------------*/
;*    ascii ::%footnote ...                                            */
;*---------------------------------------------------------------------*/
(define-method (ascii obj::%footnote)
   (with-access::%footnote obj (note body number)
      (ascii body)
      (output (string-append "(*" (number->string number) ")"))))

;*---------------------------------------------------------------------*/
;*    Top level form to register the newly loaded back-end             */
;*---------------------------------------------------------------------*/
(register-backend! 'text ascii)
(register-backend! 'info info)
