;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/pc.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep 26 22:15:36 2001                          */
;*    Last change :  Fri Nov 30 11:33:30 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The C fontifier.                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_pc
   
   (import  __scribeapi_param
	    __scribeapi_ast)
   
   (eval    (export c))
   
   (export  (c ::bstring)))

;*---------------------------------------------------------------------*/
;*    C stamps                                                         */
;*---------------------------------------------------------------------*/
(define *keyword* (gensym))
(define *cpp* (gensym))

;*---------------------------------------------------------------------*/
;*    C keywords                                                       */
;*---------------------------------------------------------------------*/
(for-each (lambda (symbol)
	     (putprop! symbol *keyword* #t))
	  '(for class while return try catch break continue
		do if else typedef struct union goto switch case
		static extern default finally throw))
(let ((sharp (string->symbol "#")))
   (for-each (lambda (symbol)
		(putprop! (symbol-append sharp symbol) *cpp* #t))
	     '(include define if ifdef ifdef else endif)))

;*---------------------------------------------------------------------*/
;*    *color* ...                                                      */
;*---------------------------------------------------------------------*/
(define *color* '())

;*---------------------------------------------------------------------*/
;*    c ...                                                            */
;*---------------------------------------------------------------------*/
(define (c obj)
   (parse-c (open-input-string obj)))

;*---------------------------------------------------------------------*/
;*    parse-c port ...                                                 */
;*---------------------------------------------------------------------*/
(define (parse-c port::input-port)
   (let ((g (regular-grammar ()
	       ((bol (: "%%" (* all)))
		;; a text inclusion
		(with-input-from-string (the-substring 2 (the-length))
		   (lambda ()
		      (let* ((file (read))
			     (def (read))
			     (start (read))
			     (stop (read)))
			 (append (c-from-file file def start stop)
				 (ignore))))))
	       ((bol (: "/*" (* (or (out #\*) (: (+ #\*) (out #\/ #\*))))
			     (+ #\*) "/"))
		;; italic comments
		(let ((str (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#ffa600" (it ,str))
			     `(it ,str))
			 (ignore))))
	       ((or (: "/*" (* (or (out #\*) (: (+ #\*) (out #\/ #\*))))
			    (+ #\*) "/")
		    (: "//" (* all)))
		;; italic comments
		(let ((str (the-substring 1 (the-length))))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#ffa600" (it ,str))
			     `(it ,str))
			 (ignore))))
	       ((+ #\Space)
		;; separators
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((in "[]")
		;; brackets
		(if *scribe-prgm-color*
		    (let* ((str (the-string))
			   (cstr `(color :fg "red" (bold ,str))))
		       (cons cstr (ignore)))))
	       ((+ #\()
		;; open parenthesis
		(let ((str (the-string)))
		   (if (pair? *color*)
		       (let ((par (if *scribe-prgm-color*
				      `(color :fg ,(car *color*) (bold ,str))
				      str)))
			  (cons par (ignore)))
		       (cons str (ignore)))))
	       (#\)
		;; close parenthesis
		(let ((str (the-string)))
		   (if (pair? *color*)
		       (let ((color (car *color*)))
			  (set! *color* (cdr *color*))
			  (cons (if *scribe-prgm-color*
				    `(color :fg ,color (bold ,str))
				    str)
				(ignore)))
		       (cons str (ignore)))))
	       (#\Tab
		(cons (make-string 8 #\space) (ignore)))
	       ((+ (out #\; #\Space #\Tab #\( #\) #\[ #\] #\: #\"))
		;; keywords
		(let* ((string (the-string))
		       (symbol (the-symbol)))
		   (cond
		      ((getprop symbol *keyword*)
		       (let ((id (if *scribe-prgm-color*
				     `(color :fg "blue" (bold ,string))
				     string)))
			  (cons id (ignore))))
		      ((getprop symbol *cpp*)
		       (let ((id (if *scribe-prgm-color*
				     `(color :fg "#00cf00" (bold ,string))
				     string)))
			  (cons id (ignore))))
		      (else
		       (cons string (ignore))))))
	       ((or (: "\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\"")
		    (: "#\"" (* (or (out #a000 #\\ #\") (: #\\ all))) "\""))
		;; strings
		(let ((str (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "red" ,str)
			     str)
			 (ignore))))
	       ((: (or "::" ":")
		   (+ (out #\; #\Newline #\Space #\Tab #\( #\) #\:)))
		;; type and keywords annotations
		(let ((string (the-string)))
		   (cons (if *scribe-prgm-color*
			     `(color :fg "#00cf00" (bold ,string))
			     `(it ,string))
			 (ignore))))
	       ((+ (or #\: #\; #\"))
		(let ((str (the-string)))
		   (cons str (ignore))))
	       ((: #\# #\\ (+ (out " \n\t")))
		;; characters
		(let ((str (the-string)))
		   (cons str (ignore))))
	       (else
		(let ((c (the-failure)))
		   (if (eof-object? c)
		       '()
		       (error "prgm(c)" "Unexpected character" c)))))))
      (read/rp g port)))

;*---------------------------------------------------------------------*/
;*    c-from-file ...                                             */
;*---------------------------------------------------------------------*/
(define (c-from-file file def start stop)
   (cond
      ((and (not def) (not start) (not stop))
       ;; the whole file
       (if (file-exists? file)
	   (let ((p (open-input-file file)))
	      (if (input-port? p)
		  (parse-c p)
		  (error "prgm(c)" "Can't open file" file)))
	   (error "prgm(c)" "Can't find file" file)))
      (def
       (multiple-value-bind (start stop)
	  (c-definition-search file (cond
					    ((symbol? def)
					     def)
					    ((string? def)
					     (string->symbol def))
					    (else
					     (error "prgm(c)"
						    "Illegal definition"
						    def))))
	  (c-from-file-lines file start stop)))
      ((or start stop)
       (c-from-file-lines file start stop))
      (else
       '())))

;*---------------------------------------------------------------------*/
;*    c-from-file-lines ...                                       */
;*---------------------------------------------------------------------*/
(define (c-from-file-lines file start stop)
   (let* ((start (if (fixnum? start)
		     start
		     1))
	  (stop (if (fixnum? stop)
		    stop
		    -1))
	  (port (open-input-file/line file start)))
      (unwind-protect
	 (let loop ((line (read-line port))
		    (lines '())
		    (lnum start))
	    (cond
	       ((and (> stop 0) (> lnum stop))
		(cdr (reverse! lines)))
	       ((eof-object? line)
		(if (=fx stop -1)
		    (cdr (reverse! lines))
		    (error "prgm(c)" "File too short" file)))
	       (else
		(loop (read-line port)
		      (cons* (untabify line) #"\n" lines)
		      (+fx lnum 1)))))
	 (close-input-port port))))

;*---------------------------------------------------------------------*/
;*    untabify ...                                                     */
;*---------------------------------------------------------------------*/
(define (untabify obj)
   ;; count the number of #\tab
   (let ((len (string-length obj))
	 (tabl 8))
      (let loop ((i 0)
		 (nl 0))
	 (cond
	    ((=fx i len)
	     (if (=fx nl len)
		 obj
		 ;; allocates a new string and fill it
		 (let ((new (make-string nl)))
		    (let loop ((r 0)
			       (w 0))
		       (cond
			  ((=fx r len)
			   new)
			  ((char=? (string-ref obj r) #\tab)
			   (let ((q (/fx r tabl)))
			      (let liip ((num (-fx (*fx tabl (+fx 1 q)) r))
					 (w w))
				 (if (=fx num 0)
				     (loop (+fx r 1) w)
				     (begin
					(string-set! new w #\space)
					(liip (-fx num 1) (+fx w 1)))))))
			  (else
			   (string-set! new w (string-ref obj r))
			   (loop (+fx r 1) (+fx w 1))))))))
	    ((char=? (string-ref obj i) #\tab)
	     (let* ((q (/fx i tabl))
		    (n (-fx (*fx tabl (+fx 1 q)) i)))
		(loop (+fx i 1) (+fx nl n))))
	    (else
	     (loop (+fx i 1) (+fx nl 1)))))))

;*---------------------------------------------------------------------*/
;*    open-input-file/line ...                                         */
;*---------------------------------------------------------------------*/
(define (open-input-file/line::input-port file line-num)
   (let ((iport (open-input-file file)))
      (if (not (input-port? iport))
	  (error "prgm(c)" "Can't open file for input" file)
	  (if (=fx line-num 1)
	      iport
	      (let loop ((line (read-line iport))
			 (lnum 2))
		 (cond
		    ((eof-object? line)
		     (error "prgm(c)"
			    "File too short"
			    (list file line-num lnum)))
		    ((>fx lnum line-num)
		     (error "prgm(c)"
			    "Illegal file num"
			    (list file line-num lnum)))
		    ((=fx lnum line-num)
		     iport)
		    (else
		     (loop (read-line iport) (+fx lnum 1)))))))))

;*---------------------------------------------------------------------*/
;*    c-definition-search ...                                     */
;*    -------------------------------------------------------------    */
;*    This function seek a C definition. If it finds it it        */
;*    returns two value the starting line number of the definition     */
;*    and the stop line.                                               */
;*---------------------------------------------------------------------*/
(define (c-definition-search file-name def)
   (reader-reset!)
   (let ((iport (open-input-file file-name)))
      (if (not (input-port? iport))
	  (error "prgm(c)" "Can't open file for input" file-name)
	  (unwind-protect
	     (let loop ((exp (read iport #t)))
		(if (not (eof-object? exp))
		    (match-case exp
		       ((begin . ?rest)
			(loop (read iport #t)))
		       (((or define define-inline define-generic
			     define-method define-macro define-expander)
			 (?fun . ?-) . ?-)
			(if (eq? def fun)
			    (values (line-number exp)
				    (reader-current-line-number))
			    (loop (read iport #f))))
		       (((or define define-struct) (and (? symbol?) ?var) . ?-)
			(if (eq? var def)
			    (values (line-number exp)
				    (reader-current-line-number))
			    (loop (read iport #t))))
		       (else
			(loop (read iport #t))))
		    (values #f #f)))
	     (close-input-port iport)))))

;*---------------------------------------------------------------------*/
;*    reader-current-line-number ...                                   */
;*    -------------------------------------------------------------    */
;*    This is a gross hack but to get the current reader line number   */
;*    we build a dummy expression that we read.                        */
;*---------------------------------------------------------------------*/
(define (reader-current-line-number)
   (let* ((port (open-input-string "(9)"))
	  (exp  (read port #t)))
      (close-input-port port)
      (line-number exp)))

;*---------------------------------------------------------------------*/
;*    line-number ...                                                  */
;*---------------------------------------------------------------------*/
(define (line-number expr)
   (and (epair? expr)
	(match-case (cer expr)
	   ((at ?- ?pos ?line)
	    line))))

