 /* sane - Scanner Access Now Easy.
   Copyright (C) 2003 Johannes Hub (JohannesHub@t-online.de)

   This file was initially copied from the hp3300 backend.
   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an exutable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/

/*
    Concept for a backend for scanners based on the RTS88xx chipset,
    such as HP4400C, HP4470C.
    Parts of this source were inspired by other backends.

		History:

		Version 0.18  21.11.04 13.alpha,
				- source sorted,
				- now only SANEI_USB_SUPPORT for a better overview(xfermodules removed)
				- read and verify the MainBoardID 
		Version 0.17p 02.11.04 12.alpha, source sorted, little fixes, SANEI_USB_SUPPORT implemented
		Version 0.17p 02.11.04 12.alpha, source sourted, little fixes, SANEI_USB_SUPPORT implemented
		Version 0.17b 30.03.04 10.alpha, little fixes and libusb implemented
		Version 0.17  09.03.04 9. alpha, HP3500 included
		Version 0.16  06.02.04 8. alpha, wait counting on LCD
		Version 0.15a 29.01.04 7. alpha, CCD switch moved to config file
		Version 0.15  11.01.04 6. alpha, a second CCD implemented
		Version 0.13a 21.11.04 4. alpha, an little fix included
		Version 0.12  22.10.03 third alpha, Backend name changed to HP_RTS88xx
		Version 0.11  30.08.03 second alpha
		Version 0.10  19.07.03 first alpha
*/

/*
    Provides a simple interface to read and write data from the scanner,
    without any knowledge whether it's a parallel or USB scanner
*/

#ifndef _HP_RTS_XFER_H_
#define _HP_RTS_XFER_H_

#include <stdio.h> /* for FILE * */

#ifdef STANDALONE

	#include <ctype.h>
	#include "../include/sane/config.h"
	#include "../include/sane/sane.h"

	#include "hp_rts88xx.h"
	#undef DBG
	#undef DBG_MSG
	#undef DBG_USB
	#undef DBG_OPT
	#undef DBG_SCAN
	#undef DBG_ASSERT
	#undef DBG_ERR

	#define DBG          fprintf
	#define DBG_MSG      stdout
	#define DBG_USB      stdout
	#define DBG_OPT      stdout
	#define DBG_SCAN     stdout
	#define DBG_ASSERT   stdout
	#define DBG_ERR      stdout

#endif


#define MAINBOARD_ID          0xb1
#define	REG_MOVE_CONTROL_TEST	0xb3

#define MAX_READ_WRITE	0x3fff    /* 4096 */
#define TIMEOUT         10000
#define XFER_BUF_SIZE  0xFF00

#ifndef MIN
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#endif


typedef enum {
	eUnknownModel = 0,
	eHp3500c,
	eHp3530c,
	eHp3570c,
	eHp4400c,
	eHp4470c,
	eVi8920,
	eVi8900,
	eVi8700,
	eVi5800,
	eVi5300,
	eVi4800,
	eVa3000,
	eMi3000,
	ePlS6,
	ePrlS6
} EScannerModel;


typedef struct {
	SANE_Char     *pszVendor;
	SANE_Char     *pszName;
	SANE_Int      iVendor;
	SANE_Int      iProduct;
	EScannerModel eModel;
} TScannerModel;


/* linked list of SANE_Device structures */
typedef struct TDevListEntry
{
  struct TDevListEntry *pNext;
  SANE_Device dev;
}
TDevListEntry;


typedef SANE_Int (TFnReportDevice)(TScannerModel *pModel, SANE_Char *pszDeviceName);

/* USB device file name */
extern SANE_Char * usb_devfile;

/* list of supported models, the actual list is in hp_rts_xfer.c */
extern TScannerModel ScannerModels[];

/*  The number returned by Hp_rts_XferInit is a handle. This handle needs to
    be passed to all other transfer functions.
    Internally it is a pointer to structure containg function pointers
*/
void			Hp_rts_DumpHex(SANE_Byte *pabData, SANE_Int iLen, SANE_Int iWidth, SANE_Int withLf);
void			Hp_rts_DumpBits(SANE_Byte reg, SANE_Byte pabData);

SANE_Int Hp_rts_XferInit(/*EScannerModel *peModel*/void);
/*SANE_Int  Hp_rts_XferInit        (EScannerModel *peModel);*/
SANE_Int  Hp_rts_XferExit        (SANE_Int iXferHandle);
SANE_Int  Hp_rts_RegWrite        (SANE_Int iXferHandle, SANE_Byte reg, SANE_Byte bData);
SANE_Int  Hp_rts_RegRead         (SANE_Int iXferHandle, SANE_Byte reg, SANE_Byte *pbData);
SANE_Int  Hp_rts_BulkWrite       (SANE_Int iXferHandle, SANE_Byte reg, SANE_Byte *pabBuf, SANE_Int iSize, SANE_Int wHeader);
SANE_Int  Hp_rts_BulkRead        (SANE_Int iXferHandle, SANE_Byte reg, SANE_Byte *pabBuf, SANE_Int iSize, SANE_Int wWrite);
SANE_Int  Hp_rts_BulkReadall     (SANE_Int iHandle,     SANE_Byte *pabData);
SANE_Bool Hp_rts_MatchUsbDevice  (SANE_Int iVendor,     SANE_Int iProduct, TScannerModel **ppeModel);
SANE_Bool Hp_rts_ProbeRegisters  (THWParams *pHWParams);
SANE_Int  Hp_rts_Set_double_reg  (SANE_Int iHandle, SANE_Byte reg, SANE_Byte c1, SANE_Byte c2 );
SANE_Int  Hp_rts_Read_double_reg (SANE_Int iHandle, SANE_Byte reg, SANE_Byte *pbData );
SANE_Int  Hp_rts_data_ready      (SANE_Int iHandle, SANE_Int *size);
SANE_Int  Hp_rts_read_data       (SANE_Int iHandle, SANE_Int size,SANE_Byte *data);
SANE_Int Hp_rts_set_value_lsbfirst(	SANE_Byte	*regs,SANE_Int	firstreg,SANE_Int totalregs, SANE_Word	value);

SANE_Bool  Hp_rts_is_moving       (SANE_Int iHandle);
SANE_Int  Hp_rts_start_moving    (SANE_Int iHandle);
SANE_Int  Hp_rts_stop_moving     (SANE_Int iHandle);
void      Hp_rts_WriteGammaCalibTable   (SANE_Int iHandle,
																	const SANE_Int *pabGammaR, const SANE_Int *pabGammaG,const SANE_Int *pabGammaB);
/*void      Hp_rts_SetDefaultGamma (SANE_Int iHandle);*/
SANE_Bool  Hp_rts_Check_Moving  (SANE_Int iHandle);
SANE_Int  Hp_rts_Read_Sram       (SANE_Int iHandle, SANE_Byte *pabData,
                                  SANE_Int iSize);
SANE_Int  Hp_rts_set_noscan_distance(SANE_Byte	*regs,SANE_Word	value);
SANE_Int  Hp_rts_set_total_distance(SANE_Byte	*regs,SANE_Word	value);
SANE_Int  Hp_rts_set_scanline_end(SANE_Byte	*regs,SANE_Word	value);
SANE_Int  Hp_rts_set_scanline_start(SANE_Byte	*regs,SANE_Word	value);

SANE_Status Hp_rts_CircBufferInit (SANE_Handle h, TDataPipe *p, SANE_Int iBytesPerLine,
                            SANE_Int iMisAlignment, SANE_Bool mode);

SANE_Bool Hp_rts_CircBufferGetLine     (SANE_Handle h, TDataPipe *p, SANE_Byte *pabLine,
                            SANE_Bool mode);

void Hp_rts_CircBufferExit        (SANE_Handle h);

SANE_Bool Hp_rts_XferBufferGetLine(SANE_Handle h, TDataPipe *p, SANE_Byte *pabLine);

void Hp_rts_XferBufferExit        (SANE_Handle h);
SANE_Status Hp_rts_XferBufferInit (SANE_Handle h, TDataPipe *p);

#endif /* _HP_RTS_XFER_H_ */
