# Rust by Example

[Rust][rust] is a modern systems programming language focusing on safety, speed,
and concurrency. It accomplishes these goals by being memory safe without using 
garbage collection.

Rust by Example (RBE) is a collection of runnable examples that illustrate various Rust
concepts and standard libraries. To get even more out of these examples, don't forget
to [install Rust locally][install] and check out the [official docs][std]. 
Additionally for the curious, you can also [check out the source code for this site][home].

Now let's begin!

- [Hello World](hello.html) - Start with a traditional Hello World program.

- [Primitives](primitives.html) - Learn about signed integers, unsigned integers and other primitives.

- [Custom Types](custom_types.html) - `struct` and `enum`.

- [Variable Bindings](variable_bindings.html) - mutable bindings, scope, shadowing.

- [Types](types.html) - Learn about changing and defining types.

- [Conversion](conversion.html)

- [Expressions](expression.html)

- [Flow Control](flow_control.html) - `if`/`else`, `for`, and others.

- [Functions](fn.html) - Learn about Methods, Closures and High Order Functions.

- [Modules](mod.html) - Organize code using modules

- [Crates](crates.html) - A crate is a compilation unit in Rust. Learn to create a library.

- [Attributes](attribute.html) - An attribute is metadata applied to some module, crate or item.

- [Generics](generics.html) - Learn about writing a function or data type which can work for multiple types of arguments.

- [Scoping rules](scope.html) - Scopes play an important part in ownership, borrowing, and lifetimes.

- [Traits](trait.html) - A trait is a collection of methods defined for an unknown type: `Self`

- [Macros](macros.html)

- [Error handling](error.html) - Learn Rust way of handling failures.

- [Std library types](std.html) - Learn about some custom types provided by `std` library.

- [Std misc](std_misc.html) - More custom types for file handling, threads.

- [Testing](testing.html) - All sorts of testing in Rust.

- [Unsafe Operations](unsafe.html)

- [Compatibility](compatibility.html)

- [Meta](meta.html) - Documentation, Benchmarking.


[rust]: https://www.rust-lang.org/
[install]: https://www.rust-lang.org/install.html
[std]: https://doc.rust-lang.org/std/
[home]: https://github.com/rust-lang/rust-by-example
