require 'runit/testcase'
require 'runit/ext/testdecorator'
require 'runit/cui/testrunner'
require 'dummytestcase'

class DummyDecorator
  include RUNIT::EXT::TestDecorator
  def value
    "DummyDecorator Value"
  end
end

class DummyTestDecoratedForTestDecorator < RUNIT::TestCase
  def decorated(decorator)
    @decorator = decorator
  end
  def test_foo
    assert_equal("DummyDecorator Value", @decorator.value)
  end
end

class TestEXT__TestDecorator < RUNIT::TestCase
  def test_decorated
    r = RUNIT::TestResult.new
    assert_no_exception {
      t = DummyDecorator.new(DummyTestDecoratedForTestDecorator.suite)
      t.run(r)
    }
    assert_equal(1, r.run_asserts)
    assert_equal(0, r.failure_size)
  end
end

if $0 == __FILE__
  if ARGV.size == 0
    suite = TestEXT__TestDecorator.suite
  else
    suite = RUNIT::TestSuite.new
    ARGV.each do |testmethod|
      suite.add(TestEXT__TestDecorator.new(testmethod))
    end
  end
  RUNIT::CUI::TestRunner.run(suite)
end
