#!/usr/bin/env ruby

# quick & dirty script for running all available tests for each module
# Author: Joachim Glauche

require "rbconfig"
require "pathname"

ruby = File.join(RbConfig::CONFIG['bindir'],
                 RbConfig::CONFIG['RUBY_INSTALL_NAME'] + RbConfig::CONFIG['EXEEXT'])

# for creating a separating line
def separator
  "-" * 80
end

targets = []
includes = []

base_dir = Pathname(File.dirname(__FILE__))
Pathname.glob((base_dir + "*").to_s) do |dir|
  next unless dir.directory?
  dir = dir.expand_path
  ext_dir = dir + "ext" + dir.basename
  includes.concat(["-I", (dir + "lib").to_s, "-I", ext_dir.to_s])
  next unless (dir + "test").directory?
  targets << dir
end

targets.each do |target|
  Dir.chdir(target.to_s) do
    puts "#{Time.now} running test for #{target}"
    puts separator

    args = includes + ["test/run-test.rb"]
    command = [ruby, *args]
    system(command.collect {|arg| "'#{arg.gsub(/'/, '\\\'')}'"}.join(' '))

    puts separator
  end
end

