
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_sr_cyrl/gherkin_lexer_sr_cyrl.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 21, 22, 23, 24, 25, 
	26, 28, 30, 41, 42, 43, 45, 47, 
	52, 57, 62, 67, 71, 75, 77, 78, 
	79, 80, 81, 82, 83, 84, 85, 86, 
	87, 88, 89, 90, 91, 92, 97, 104, 
	109, 113, 119, 122, 124, 130, 141, 142, 
	143, 144, 145, 146, 147, 148, 149, 150, 
	153, 154, 156, 157, 158, 160, 161, 162, 
	163, 164, 166, 167, 168, 169, 170, 171, 
	172, 173, 174, 175, 176, 177, 186, 196, 
	198, 200, 202, 204, 206, 217, 219, 221, 
	223, 225, 227, 229, 231, 233, 235, 239, 
	241, 244, 246, 248, 251, 253, 255, 257, 
	259, 261, 263, 265, 267, 269, 271, 273, 
	275, 277, 279, 281, 283, 285, 287, 289, 
	291, 293, 295, 297, 299, 301, 303, 306, 
	308, 310, 312, 314, 316, 318, 320, 322, 
	324, 326, 328, 330, 332, 334, 336, 338, 
	340, 342, 344, 346, 348, 350, 352, 354, 
	356, 359, 361, 363, 365, 367, 369, 372, 
	374, 376, 378, 380, 382, 384, 386, 388, 
	390, 392, 394, 396, 398, 400, 402, 404, 
	406, 408, 410, 412, 414, 416, 418, 420, 
	422, 424, 426, 428, 430, 432, 434, 436, 
	438, 440, 442, 444, 446, 448, 450, 452, 
	454, 456, 458, 460, 462, 464, 466, 468, 
	470, 472, 474, 476, 478, 480, 482, 484, 
	486, 488, 490, 492, 494, 496, 498, 500, 
	502, 504, 506, 508, 510, 512, 514, 516, 
	518, 520, 522, 523, 524, 525, 526, 527, 
	528, 529, 530, 531, 540, 550, 552, 554, 
	556, 558, 560, 562, 564, 566, 568, 570, 
	572, 574, 576, 578, 582, 584, 586, 588, 
	590, 593, 595, 597, 599, 601, 603, 605, 
	607, 609, 611, 613, 615, 617, 619, 621, 
	623, 625, 627, 629, 632, 634, 636, 638, 
	640, 642, 644, 646, 648, 650, 652, 654, 
	656, 658, 660, 662, 664, 666, 668, 670, 
	672, 674, 676, 678, 680, 682, 684, 686, 
	688, 690, 692, 694, 696, 698, 700, 702, 
	704, 706, 708, 710, 712, 714, 716, 718, 
	720, 722, 724, 726, 728, 730, 732, 734, 
	736, 738, 740, 742, 744, 746, 748, 750, 
	752, 754, 756, 758, 760, 762, 764, 766, 
	768, 770, 772, 774, 775, 776, 777, 778, 
	779, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 801, 
	808, 810, 812, 814, 816, 818, 821, 823, 
	825, 827, 829, 831, 833, 835, 837, 839, 
	841, 843, 845, 847, 849, 851, 853, 855, 
	857, 859, 861, 863, 865, 867, 869, 871, 
	873, 875, 877, 880, 882, 884, 886, 888, 
	890, 892, 894, 896, 898, 900, 902, 904, 
	907, 909, 911, 913, 915, 917, 919, 921, 
	923, 925, 927, 929, 931, 933, 935, 937, 
	939, 942, 944, 947, 949, 951, 953, 955, 
	957, 960, 962, 964, 966, 968, 970, 972, 
	974, 976, 978, 980, 982, 984, 986, 988, 
	990, 992, 994, 996, 998, 1000, 1002, 1004, 
	1006, 1008, 1010, 1012, 1014, 1016, 1018, 1020, 
	1022, 1024, 1026, 1028, 1030, 1032, 1034, 1036, 
	1038, 1040, 1042, 1045, 1047, 1049, 1051, 1053, 
	1055, 1057, 1059, 1061, 1063, 1065, 1067, 1069, 
	1071, 1073, 1075, 1077, 1079, 1081, 1083, 1085, 
	1087, 1089, 1091, 1093, 1095, 1097, 1099, 1101, 
	1103, 1105, 1107, 1109, 1111, 1113, 1115, 1117, 
	1118, 1119, 1120, 1121, 1122, 1123, 1125, 1126, 
	1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 
	1135, 1136, 1137, 1138, 1139, 1141, 1142, 1143, 
	1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151, 
	1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 
	1160, 1161, 1163, 1164, 1165, 1166, 1167, 1174, 
	1178, 1180, 1182, 1184, 1186, 1188, 1190, 1192, 
	1194, 1196, 1198, 1200, 1202, 1204, 1206, 1208, 
	1210, 1212, 1214, 1216, 1218, 1220, 1222, 1224, 
	1226, 1228, 1230, 1232, 1234, 1236, 1238, 1240, 
	1242, 1244, 1246, 1248, 1250, 1252, 1254, 1256, 
	1258, 1260, 1262, 1264, 1266, 1268, 1270, 1272, 
	1273, 1274, 1283, 1293, 1295, 1297, 1299, 1301, 
	1303, 1305, 1307, 1309, 1311, 1313, 1315, 1317, 
	1319, 1321, 1325, 1327, 1330, 1332, 1334, 1337, 
	1339, 1341, 1343, 1345, 1348, 1350, 1352, 1354, 
	1356, 1358, 1360, 1362, 1364, 1366, 1368, 1370, 
	1372, 1374, 1376, 1378, 1380, 1382, 1384, 1386, 
	1388, 1390, 1392, 1394, 1396, 1398, 1401, 1403, 
	1405, 1407, 1409, 1411, 1413, 1416, 1418, 1420, 
	1422, 1424, 1426, 1428, 1430, 1432, 1434, 1436, 
	1438, 1440, 1443, 1445, 1447, 1449, 1451, 1453, 
	1455, 1457, 1459, 1461, 1463, 1465, 1467, 1469, 
	1471, 1473, 1475, 1478, 1480, 1482, 1484, 1486, 
	1488, 1491, 1493, 1495, 1497, 1499, 1501, 1503, 
	1505, 1507, 1509, 1511, 1513, 1515, 1517, 1519, 
	1521, 1523, 1525, 1527, 1529, 1531, 1533, 1535, 
	1537, 1539, 1541, 1543, 1545, 1547, 1549, 1551, 
	1553, 1555, 1557, 1559, 1561, 1563, 1565, 1567, 
	1569, 1571, 1573, 1575, 1577, 1579, 1581, 1583, 
	1585, 1587, 1589, 1591, 1593, 1595, 1597, 1599, 
	1601, 1603, 1605, 1607, 1609, 1611, 1613, 1615, 
	1617, 1619, 1621, 1623, 1625, 1627, 1629, 1631, 
	1633, 1635, 1637, 1639, 1641, 1643, 1644, 1645, 
	1646, 1647, 1648, 1649, 1650, 1652, 1653, 1654, 
	1655, 1656, 1657, 1658, 1659, 1660, 1661, 1662, 
	1663, 1664, 1665, 1666, 1667, 1668, 1669, 1670, 
	1671, 1672, 1673, 1674, 1675, 1676, 1677, 1678, 
	1679, 1680, 1681, 1682, 1683, 1684, 1685, 1686, 
	1687, 1688, 1689, 1690, 1691, 1692, 1693, 1695, 
	1696, 1697, 1698, 1699, 1700, 1701, 1702, 1703, 
	1704, 1705, 1706, 1707, 1708, 1709, 1710, 1711, 
	1712, 1713, 1714, 1715, 1716, 1717, 1718, 1719
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -112, -105, -104, -102, 
	-100, -98, -97, -95, -92, -48, -69, -48, 
	-72, 32, 10, 13, 10, 13, -48, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, 34, 34, 10, 13, 10, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 9, 13, 10, 
	32, 9, 13, 10, 13, 10, 95, 70, 
	69, 65, 84, 85, 82, 69, 95, 69, 
	78, 68, 95, 37, 13, 32, 64, 9, 
	10, 9, 10, 13, 32, 64, 11, 12, 
	10, 32, 64, 9, 13, 32, 124, 9, 
	13, 10, 32, 92, 124, 9, 13, 10, 
	92, 124, 10, 92, 10, 32, 92, 124, 
	9, 13, -48, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, -48, -80, -48, 
	-76, -48, -80, -47, -126, -48, -75, -72, 
	-66, -48, -80, -66, -48, -76, -48, 32, 
	-80, -48, -67, -47, -126, -122, -48, -75, 
	-48, -70, -47, -127, -47, -126, 58, 10, 
	10, -48, 10, 32, 35, 37, 42, 64, 
	9, 13, -112, -105, -104, -102, -100, -98, 
	-97, -95, -92, 10, -48, 10, -69, 10, 
	-48, 10, -72, 10, 10, 32, -48, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, -48, 10, -80, 10, -48, 10, -76, 
	10, -48, 10, -80, 10, -47, 10, -126, 
	10, -48, 10, -75, -72, -66, 10, -48, 
	10, -80, -66, 10, -48, 10, -76, 10, 
	-48, 10, 32, -80, 10, -48, 10, -67, 
	10, -47, 10, -122, 10, -48, 10, -75, 
	10, -48, 10, -65, 10, -47, 10, -126, 
	10, 10, 58, -48, 10, -66, 10, -48, 
	10, -77, 10, -47, 10, -125, 10, -47, 
	10, -101, 10, -48, 10, -67, 10, -48, 
	10, -66, 10, -47, 10, -127, 10, -48, 
	-47, 10, -67, 10, -48, 10, -76, 10, 
	-48, 10, -127, 10, -48, 10, -66, 10, 
	-48, 10, -79, 10, -48, 10, -72, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -68, 10, -48, 10, -75, 10, 
	-47, 10, -128, 10, -48, -47, 10, -70, 
	10, -48, 10, -72, 10, -47, 10, -122, 
	10, -126, -122, 10, -47, 10, -128, 10, 
	-47, 10, -125, 10, -48, 10, -70, 10, 
	-47, 10, -126, 10, -47, 10, -125, 10, 
	-47, 10, -128, 10, -48, 10, -80, 10, 
	10, 32, -47, 10, -127, 10, -47, 10, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -47, 10, 
	-104, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-66, 10, -47, 10, -125, 10, -48, 10, 
	-67, 10, -48, 10, -70, 10, -47, 10, 
	-122, 10, -48, 10, -72, 10, -48, 10, 
	-66, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -48, 10, -69, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, -48, -75, -48, -65, -47, -126, 
	58, 10, 10, -48, 10, 32, 35, 37, 
	42, 64, 9, 13, -112, -105, -104, -102, 
	-100, -98, -97, -95, -92, 10, -48, 10, 
	-69, 10, -48, 10, -72, 10, 10, 32, 
	-48, 10, -80, 10, -48, 10, -76, 10, 
	-48, 10, -80, 10, -47, 10, -126, 10, 
	-48, 10, -75, -72, -66, 10, -48, 10, 
	-80, 10, -48, 10, -76, 10, -48, 10, 
	32, -80, 10, -48, 10, -66, 10, -48, 
	10, -77, 10, -47, 10, -125, 10, -47, 
	10, -101, 10, -48, 10, -67, 10, -48, 
	10, -66, 10, -47, 10, -127, 10, -47, 
	10, -126, 10, 10, 58, -48, -47, 10, 
	-67, 10, -48, 10, -76, 10, -48, 10, 
	-127, 10, -48, 10, -66, 10, -48, 10, 
	-79, 10, -48, 10, -72, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-68, 10, -48, 10, -75, 10, -47, 10, 
	-128, 10, -47, 10, -122, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -48, 10, -66, 10, -47, 10, 
	-125, 10, -48, 10, -67, 10, -48, 10, 
	-70, 10, -47, 10, -122, 10, -48, 10, 
	-72, 10, -48, 10, -66, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -48, 10, 
	-69, 10, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, -48, -66, 
	-48, -77, -47, -125, -47, -101, -48, -67, 
	-48, -66, -47, -127, -47, -126, 58, 10, 
	10, -48, 10, 32, 35, 37, 64, 9, 
	13, -102, -100, -98, -97, -95, -92, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-47, 10, -126, -122, 10, -48, 10, -75, 
	10, -48, 10, -70, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, 10, 58, -48, 
	10, -75, 10, -48, 10, -65, 10, -48, 
	10, -66, 10, -48, 10, -77, 10, -47, 
	10, -125, 10, -47, 10, -101, 10, -48, 
	10, -67, 10, -48, 10, -66, 10, -47, 
	10, -127, 10, -48, 10, -67, -66, 10, 
	-48, 10, -66, 10, -48, 10, -78, 10, 
	-48, 10, -80, 10, -48, 10, -79, 10, 
	-48, 10, -72, 10, -48, 10, -67, 10, 
	-48, -47, 10, -66, 10, -48, 10, -73, 
	10, -48, 10, -80, 10, -48, 10, -76, 
	10, -128, 10, -48, 10, -72, 10, -48, 
	10, -68, 10, -48, 10, -75, 10, -47, 
	10, -128, 10, -48, 10, 58, -72, 10, 
	-48, -47, 10, -70, 10, -48, 10, -72, 
	10, -47, 10, -122, 10, -126, -122, 10, 
	-47, 10, -128, 10, -47, 10, -125, 10, 
	-48, 10, -70, 10, -47, 10, -126, 10, 
	-47, 10, -125, 10, -47, 10, -128, 10, 
	-48, 10, -80, 10, 10, 32, -47, 10, 
	-127, 10, -47, 10, -122, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -47, 10, -104, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -48, -47, 10, -66, 10, -104, 
	10, -48, 10, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -48, -47, -67, -48, -76, 
	-48, -127, -48, -67, -66, -48, -66, -48, 
	-78, -48, -80, -48, -79, -48, -72, -48, 
	-67, -48, -80, -48, -47, -66, -48, -73, 
	-48, -80, -48, -76, -48, -72, -48, -67, 
	-128, -48, -72, -48, -68, -48, -75, -47, 
	-128, -48, 58, -72, 58, 10, 10, -48, 
	10, 32, 35, 124, 9, 13, -100, -98, 
	-92, 10, -48, 10, -66, 10, -48, 10, 
	-77, 10, -47, 10, -125, 10, -47, 10, 
	-101, 10, -48, 10, -67, 10, -48, 10, 
	-66, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, 10, 58, -47, 10, -127, 10, 
	-48, 10, -66, 10, -48, 10, -79, 10, 
	-48, 10, -72, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -112, -105, -104, -102, -100, 
	-98, -97, -95, -92, 10, -48, 10, -69, 
	10, -48, 10, -72, 10, 10, 32, -48, 
	10, -80, 10, -48, 10, -76, 10, -48, 
	10, -80, 10, -47, 10, -126, 10, -48, 
	10, -75, -72, -66, 10, -48, 10, -80, 
	-66, 10, -48, 10, -76, 10, -48, 10, 
	32, -80, 10, -48, 10, -67, 10, -47, 
	10, -126, -122, 10, -48, 10, -75, 10, 
	-48, 10, -70, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, 10, 58, -48, 10, 
	-75, 10, -48, 10, -65, 10, -48, 10, 
	-66, 10, -48, 10, -77, 10, -47, 10, 
	-125, 10, -47, 10, -101, 10, -48, 10, 
	-67, 10, -48, 10, -66, 10, -48, -47, 
	10, -67, 10, -48, 10, -76, 10, -48, 
	10, -127, 10, -48, 10, -67, -66, 10, 
	-48, 10, -66, 10, -48, 10, -78, 10, 
	-48, 10, -80, 10, -48, 10, -79, 10, 
	-48, 10, -72, 10, -48, 10, -67, 10, 
	-48, -47, 10, -66, 10, -48, 10, -73, 
	10, -48, 10, -80, 10, -48, 10, -76, 
	10, -128, 10, -48, 10, -72, 10, -48, 
	10, -68, 10, -48, 10, -75, 10, -47, 
	10, -128, 10, -48, -47, 10, -70, 10, 
	-48, 10, -72, 10, -47, 10, -122, 10, 
	-126, -122, 10, -47, 10, -128, 10, -47, 
	10, -125, 10, -48, 10, -70, 10, -47, 
	10, -126, 10, -47, 10, -125, 10, -47, 
	10, -128, 10, -48, 10, -80, 10, 10, 
	32, -47, 10, -127, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -47, 10, -104, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -48, 10, -66, 
	10, -47, 10, -125, 10, -48, 10, -67, 
	10, -48, 10, -70, 10, -47, 10, -122, 
	10, -48, 10, -72, 10, -48, 10, -66, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -48, 10, -69, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, -48, -47, -70, -48, -72, -47, -122, 
	-48, -80, -126, -122, -47, -128, -47, -125, 
	-48, -70, -47, -126, -47, -125, -47, -128, 
	-48, -80, 32, -47, -127, -47, -122, -48, 
	-75, -48, -67, -48, -80, -47, -128, -48, 
	-72, -47, -104, -48, -75, -48, -67, -48, 
	-80, -47, -128, -48, -72, -48, -47, -66, 
	58, -104, -48, -47, -125, -48, -67, -48, 
	-70, -47, -122, -48, -72, -48, -66, -48, 
	-67, -48, -80, -48, -69, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 9, 1, 1, 1, 1, 1, 
	2, 2, 9, 1, 1, 2, 2, 3, 
	3, 3, 3, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 3, 5, 3, 
	2, 4, 3, 2, 4, 9, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	1, 2, 1, 1, 2, 1, 1, 1, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 7, 10, 2, 
	2, 2, 2, 2, 9, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 4, 2, 
	3, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 7, 10, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 4, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 6, 7, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 3, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 1, 1, 1, 1, 5, 4, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 7, 10, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 4, 2, 3, 2, 2, 3, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 1, 
	1, 1, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 0, 0, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 22, 24, 26, 28, 30, 
	32, 35, 38, 49, 51, 53, 56, 59, 
	64, 69, 74, 79, 83, 87, 90, 92, 
	94, 96, 98, 100, 102, 104, 106, 108, 
	110, 112, 114, 116, 118, 120, 125, 132, 
	137, 141, 147, 151, 154, 160, 171, 173, 
	175, 177, 179, 181, 183, 185, 187, 189, 
	193, 195, 198, 200, 202, 205, 207, 209, 
	211, 213, 216, 218, 220, 222, 224, 226, 
	228, 230, 232, 234, 236, 238, 247, 258, 
	261, 264, 267, 270, 273, 284, 287, 290, 
	293, 296, 299, 302, 305, 308, 311, 316, 
	319, 323, 326, 329, 333, 336, 339, 342, 
	345, 348, 351, 354, 357, 360, 363, 366, 
	369, 372, 375, 378, 381, 384, 387, 390, 
	393, 396, 399, 402, 405, 408, 411, 415, 
	418, 421, 424, 427, 430, 433, 436, 439, 
	442, 445, 448, 451, 454, 457, 460, 463, 
	466, 469, 472, 475, 478, 481, 484, 487, 
	490, 494, 497, 500, 503, 506, 509, 513, 
	516, 519, 522, 525, 528, 531, 534, 537, 
	540, 543, 546, 549, 552, 555, 558, 561, 
	564, 567, 570, 573, 576, 579, 582, 585, 
	588, 591, 594, 597, 600, 603, 606, 609, 
	612, 615, 618, 621, 624, 627, 630, 633, 
	636, 639, 642, 645, 648, 651, 654, 657, 
	660, 663, 666, 669, 672, 675, 678, 681, 
	684, 687, 690, 693, 696, 699, 702, 705, 
	708, 711, 714, 717, 720, 723, 726, 729, 
	732, 735, 738, 740, 742, 744, 746, 748, 
	750, 752, 754, 756, 765, 776, 779, 782, 
	785, 788, 791, 794, 797, 800, 803, 806, 
	809, 812, 815, 818, 823, 826, 829, 832, 
	835, 839, 842, 845, 848, 851, 854, 857, 
	860, 863, 866, 869, 872, 875, 878, 881, 
	884, 887, 890, 893, 897, 900, 903, 906, 
	909, 912, 915, 918, 921, 924, 927, 930, 
	933, 936, 939, 942, 945, 948, 951, 954, 
	957, 960, 963, 966, 969, 972, 975, 978, 
	981, 984, 987, 990, 993, 996, 999, 1002, 
	1005, 1008, 1011, 1014, 1017, 1020, 1023, 1026, 
	1029, 1032, 1035, 1038, 1041, 1044, 1047, 1050, 
	1053, 1056, 1059, 1062, 1065, 1068, 1071, 1074, 
	1077, 1080, 1083, 1086, 1089, 1092, 1095, 1098, 
	1101, 1104, 1107, 1110, 1112, 1114, 1116, 1118, 
	1120, 1122, 1124, 1126, 1128, 1130, 1132, 1134, 
	1136, 1138, 1140, 1142, 1144, 1146, 1148, 1156, 
	1164, 1167, 1170, 1173, 1176, 1179, 1183, 1186, 
	1189, 1192, 1195, 1198, 1201, 1204, 1207, 1210, 
	1213, 1216, 1219, 1222, 1225, 1228, 1231, 1234, 
	1237, 1240, 1243, 1246, 1249, 1252, 1255, 1258, 
	1261, 1264, 1267, 1271, 1274, 1277, 1280, 1283, 
	1286, 1289, 1292, 1295, 1298, 1301, 1304, 1307, 
	1311, 1314, 1317, 1320, 1323, 1326, 1329, 1332, 
	1335, 1338, 1341, 1344, 1347, 1350, 1353, 1356, 
	1359, 1363, 1366, 1370, 1373, 1376, 1379, 1382, 
	1385, 1389, 1392, 1395, 1398, 1401, 1404, 1407, 
	1410, 1413, 1416, 1419, 1422, 1425, 1428, 1431, 
	1434, 1437, 1440, 1443, 1446, 1449, 1452, 1455, 
	1458, 1461, 1464, 1467, 1470, 1473, 1476, 1479, 
	1482, 1485, 1488, 1491, 1494, 1497, 1500, 1503, 
	1506, 1509, 1512, 1516, 1519, 1522, 1525, 1528, 
	1531, 1534, 1537, 1540, 1543, 1546, 1549, 1552, 
	1555, 1558, 1561, 1564, 1567, 1570, 1573, 1576, 
	1579, 1582, 1585, 1588, 1591, 1594, 1597, 1600, 
	1603, 1606, 1609, 1612, 1615, 1618, 1621, 1624, 
	1626, 1628, 1630, 1632, 1634, 1636, 1639, 1641, 
	1643, 1645, 1647, 1649, 1651, 1653, 1655, 1657, 
	1659, 1661, 1663, 1665, 1667, 1670, 1672, 1674, 
	1676, 1678, 1680, 1682, 1684, 1686, 1688, 1690, 
	1692, 1694, 1696, 1698, 1700, 1702, 1704, 1706, 
	1708, 1710, 1713, 1715, 1717, 1719, 1721, 1728, 
	1733, 1736, 1739, 1742, 1745, 1748, 1751, 1754, 
	1757, 1760, 1763, 1766, 1769, 1772, 1775, 1778, 
	1781, 1784, 1787, 1790, 1793, 1796, 1799, 1802, 
	1805, 1808, 1811, 1814, 1817, 1820, 1823, 1826, 
	1829, 1832, 1835, 1838, 1841, 1844, 1847, 1850, 
	1853, 1856, 1859, 1862, 1865, 1868, 1871, 1874, 
	1876, 1878, 1887, 1898, 1901, 1904, 1907, 1910, 
	1913, 1916, 1919, 1922, 1925, 1928, 1931, 1934, 
	1937, 1940, 1945, 1948, 1952, 1955, 1958, 1962, 
	1965, 1968, 1971, 1974, 1978, 1981, 1984, 1987, 
	1990, 1993, 1996, 1999, 2002, 2005, 2008, 2011, 
	2014, 2017, 2020, 2023, 2026, 2029, 2032, 2035, 
	2038, 2041, 2044, 2047, 2050, 2053, 2057, 2060, 
	2063, 2066, 2069, 2072, 2075, 2079, 2082, 2085, 
	2088, 2091, 2094, 2097, 2100, 2103, 2106, 2109, 
	2112, 2115, 2119, 2122, 2125, 2128, 2131, 2134, 
	2137, 2140, 2143, 2146, 2149, 2152, 2155, 2158, 
	2161, 2164, 2167, 2171, 2174, 2177, 2180, 2183, 
	2186, 2190, 2193, 2196, 2199, 2202, 2205, 2208, 
	2211, 2214, 2217, 2220, 2223, 2226, 2229, 2232, 
	2235, 2238, 2241, 2244, 2247, 2250, 2253, 2256, 
	2259, 2262, 2265, 2268, 2271, 2274, 2277, 2280, 
	2283, 2286, 2289, 2292, 2295, 2298, 2301, 2304, 
	2307, 2310, 2313, 2316, 2319, 2322, 2325, 2328, 
	2331, 2334, 2337, 2340, 2343, 2346, 2349, 2352, 
	2355, 2358, 2361, 2364, 2367, 2370, 2373, 2376, 
	2379, 2382, 2385, 2388, 2391, 2394, 2397, 2400, 
	2403, 2406, 2409, 2412, 2415, 2418, 2420, 2422, 
	2424, 2426, 2428, 2430, 2432, 2435, 2437, 2439, 
	2441, 2443, 2445, 2447, 2449, 2451, 2453, 2455, 
	2457, 2459, 2461, 2463, 2465, 2467, 2469, 2471, 
	2473, 2475, 2477, 2479, 2481, 2483, 2485, 2487, 
	2489, 2491, 2493, 2495, 2497, 2499, 2501, 2503, 
	2505, 2507, 2509, 2511, 2513, 2515, 2517, 2520, 
	2522, 2524, 2526, 2528, 2530, 2532, 2534, 2536, 
	2538, 2540, 2542, 2544, 2546, 2548, 2550, 2552, 
	2554, 2556, 2558, 2560, 2562, 2564, 2566, 2568
};

static const short _lexer_trans_targs[] = {
	2, 869, 10, 10, 11, 21, 23, 7, 
	37, 40, 10, 0, 3, 46, 7, 56, 
	355, 526, 548, 796, 851, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	10, 22, 9, 10, 22, 9, 2, 10, 
	10, 11, 21, 23, 7, 37, 40, 10, 
	0, 12, 0, 13, 0, 15, 14, 14, 
	15, 14, 14, 16, 16, 17, 16, 16, 
	16, 16, 17, 16, 16, 16, 16, 18, 
	16, 16, 16, 16, 19, 16, 16, 10, 
	20, 20, 0, 10, 20, 20, 0, 10, 
	22, 21, 10, 0, 24, 0, 25, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 31, 0, 32, 0, 33, 0, 
	34, 0, 35, 0, 36, 0, 871, 0, 
	0, 0, 0, 0, 38, 39, 10, 39, 
	39, 37, 38, 38, 10, 39, 37, 39, 
	0, 40, 41, 40, 0, 45, 44, 43, 
	41, 44, 42, 0, 43, 41, 42, 0, 
	43, 42, 45, 44, 43, 41, 44, 42, 
	2, 45, 45, 11, 21, 23, 7, 37, 
	40, 45, 0, 47, 0, 48, 0, 49, 
	0, 50, 0, 51, 0, 52, 0, 53, 
	0, 54, 0, 55, 0, 7, 7, 7, 
	0, 57, 0, 58, 62, 0, 59, 0, 
	60, 0, 61, 8, 0, 7, 0, 63, 
	0, 64, 0, 65, 0, 66, 234, 0, 
	67, 0, 68, 0, 69, 0, 70, 0, 
	71, 0, 72, 0, 73, 0, 74, 0, 
	75, 0, 77, 76, 77, 76, 78, 77, 
	77, 10, 220, 83, 10, 77, 76, 79, 
	85, 83, 95, 112, 126, 142, 152, 202, 
	77, 76, 80, 77, 76, 81, 77, 76, 
	82, 77, 76, 83, 77, 76, 77, 84, 
	76, 2, 10, 10, 11, 21, 23, 7, 
	37, 40, 10, 0, 86, 77, 76, 87, 
	77, 76, 88, 77, 76, 89, 77, 76, 
	90, 77, 76, 91, 77, 76, 92, 77, 
	76, 93, 77, 76, 94, 77, 76, 83, 
	83, 83, 77, 76, 96, 77, 76, 97, 
	101, 77, 76, 98, 77, 76, 99, 77, 
	76, 100, 77, 84, 76, 83, 77, 76, 
	102, 77, 76, 103, 77, 76, 104, 77, 
	76, 105, 77, 76, 106, 77, 76, 107, 
	77, 76, 108, 77, 76, 109, 77, 76, 
	110, 77, 76, 111, 77, 76, 77, 84, 
	76, 113, 77, 76, 114, 77, 76, 115, 
	77, 76, 116, 77, 76, 117, 77, 76, 
	118, 77, 76, 119, 77, 76, 120, 77, 
	76, 121, 77, 76, 122, 77, 76, 123, 
	77, 76, 124, 77, 76, 125, 77, 76, 
	109, 77, 76, 127, 131, 77, 76, 128, 
	77, 76, 129, 77, 76, 130, 77, 76, 
	100, 77, 76, 132, 77, 76, 133, 77, 
	76, 134, 77, 76, 135, 77, 76, 136, 
	77, 76, 137, 77, 76, 138, 77, 76, 
	139, 77, 76, 140, 77, 76, 141, 77, 
	76, 111, 77, 76, 143, 77, 76, 144, 
	77, 76, 145, 77, 76, 146, 77, 76, 
	147, 77, 76, 148, 77, 76, 149, 77, 
	76, 150, 77, 76, 151, 77, 76, 111, 
	77, 76, 153, 158, 77, 76, 154, 77, 
	76, 155, 77, 76, 156, 77, 76, 157, 
	77, 76, 140, 77, 76, 159, 190, 77, 
	76, 160, 77, 76, 161, 77, 76, 162, 
	77, 76, 163, 77, 76, 164, 77, 76, 
	165, 77, 76, 166, 77, 76, 167, 77, 
	76, 168, 77, 76, 169, 77, 76, 170, 
	77, 76, 171, 77, 76, 172, 77, 76, 
	173, 77, 76, 77, 174, 76, 175, 77, 
	76, 176, 77, 76, 177, 77, 76, 178, 
	77, 76, 179, 77, 76, 180, 77, 76, 
	181, 77, 76, 182, 77, 76, 183, 77, 
	76, 184, 77, 76, 185, 77, 76, 186, 
	77, 76, 187, 77, 76, 188, 77, 76, 
	189, 77, 76, 140, 77, 76, 191, 77, 
	76, 192, 77, 76, 193, 77, 76, 194, 
	77, 76, 195, 77, 76, 196, 77, 76, 
	197, 77, 76, 198, 77, 76, 199, 77, 
	76, 200, 77, 76, 201, 77, 76, 111, 
	77, 76, 203, 77, 76, 204, 77, 76, 
	205, 77, 76, 206, 77, 76, 207, 77, 
	76, 208, 77, 76, 209, 77, 76, 210, 
	77, 76, 211, 77, 76, 212, 77, 76, 
	213, 77, 76, 214, 77, 76, 215, 77, 
	76, 216, 77, 76, 217, 77, 76, 218, 
	77, 76, 219, 77, 76, 120, 77, 76, 
	77, 221, 76, 77, 222, 76, 77, 223, 
	76, 77, 224, 76, 77, 225, 76, 77, 
	226, 76, 77, 227, 76, 77, 228, 76, 
	77, 229, 76, 77, 230, 76, 77, 231, 
	76, 77, 232, 76, 77, 233, 76, 77, 
	10, 76, 235, 0, 236, 0, 237, 0, 
	238, 0, 239, 0, 240, 0, 241, 0, 
	243, 242, 243, 242, 244, 243, 243, 10, 
	341, 249, 10, 243, 242, 245, 250, 249, 
	260, 266, 283, 299, 309, 323, 243, 242, 
	246, 243, 242, 247, 243, 242, 248, 243, 
	242, 249, 243, 242, 243, 84, 242, 251, 
	243, 242, 252, 243, 242, 253, 243, 242, 
	254, 243, 242, 255, 243, 242, 256, 243, 
	242, 257, 243, 242, 258, 243, 242, 259, 
	243, 242, 249, 249, 249, 243, 242, 261, 
	243, 242, 262, 243, 242, 263, 243, 242, 
	264, 243, 242, 265, 243, 84, 242, 249, 
	243, 242, 267, 243, 242, 268, 243, 242, 
	269, 243, 242, 270, 243, 242, 271, 243, 
	242, 272, 243, 242, 273, 243, 242, 274, 
	243, 242, 275, 243, 242, 276, 243, 242, 
	277, 243, 242, 278, 243, 242, 279, 243, 
	242, 280, 243, 242, 281, 243, 242, 282, 
	243, 242, 243, 84, 242, 284, 288, 243, 
	242, 285, 243, 242, 286, 243, 242, 287, 
	243, 242, 265, 243, 242, 289, 243, 242, 
	290, 243, 242, 291, 243, 242, 292, 243, 
	242, 293, 243, 242, 294, 243, 242, 295, 
	243, 242, 296, 243, 242, 297, 243, 242, 
	298, 243, 242, 282, 243, 242, 300, 243, 
	242, 301, 243, 242, 302, 243, 242, 303, 
	243, 242, 304, 243, 242, 305, 243, 242, 
	306, 243, 242, 307, 243, 242, 308, 243, 
	242, 282, 243, 242, 310, 243, 242, 311, 
	243, 242, 312, 243, 242, 313, 243, 242, 
	314, 243, 242, 315, 243, 242, 316, 243, 
	242, 317, 243, 242, 318, 243, 242, 319, 
	243, 242, 320, 243, 242, 321, 243, 242, 
	322, 243, 242, 282, 243, 242, 324, 243, 
	242, 325, 243, 242, 326, 243, 242, 327, 
	243, 242, 328, 243, 242, 329, 243, 242, 
	330, 243, 242, 331, 243, 242, 332, 243, 
	242, 333, 243, 242, 334, 243, 242, 335, 
	243, 242, 336, 243, 242, 337, 243, 242, 
	338, 243, 242, 339, 243, 242, 340, 243, 
	242, 274, 243, 242, 243, 342, 242, 243, 
	343, 242, 243, 344, 242, 243, 345, 242, 
	243, 346, 242, 243, 347, 242, 243, 348, 
	242, 243, 349, 242, 243, 350, 242, 243, 
	351, 242, 243, 352, 242, 243, 353, 242, 
	243, 354, 242, 243, 10, 242, 356, 0, 
	357, 0, 358, 0, 359, 0, 360, 0, 
	361, 0, 362, 0, 363, 0, 364, 0, 
	365, 0, 366, 0, 367, 0, 368, 0, 
	369, 0, 370, 0, 371, 0, 372, 0, 
	374, 373, 374, 373, 375, 374, 374, 10, 
	512, 10, 374, 373, 376, 395, 407, 423, 
	442, 494, 374, 373, 377, 374, 373, 378, 
	374, 373, 379, 374, 373, 380, 374, 373, 
	381, 374, 373, 382, 391, 374, 373, 383, 
	374, 373, 384, 374, 373, 385, 374, 373, 
	386, 374, 373, 387, 374, 373, 388, 374, 
	373, 389, 374, 373, 390, 374, 373, 374, 
	84, 373, 392, 374, 373, 393, 374, 373, 
	394, 374, 373, 388, 374, 373, 396, 374, 
	373, 397, 374, 373, 398, 374, 373, 399, 
	374, 373, 400, 374, 373, 401, 374, 373, 
	402, 374, 373, 403, 374, 373, 404, 374, 
	373, 405, 374, 373, 406, 374, 373, 386, 
	374, 373, 408, 374, 373, 409, 374, 373, 
	410, 374, 373, 411, 417, 374, 373, 412, 
	374, 373, 413, 374, 373, 414, 374, 373, 
	415, 374, 373, 416, 374, 373, 390, 374, 
	373, 418, 374, 373, 419, 374, 373, 420, 
	374, 373, 421, 374, 373, 422, 374, 373, 
	415, 374, 373, 424, 431, 374, 373, 425, 
	374, 373, 426, 374, 373, 427, 374, 373, 
	428, 374, 373, 429, 374, 373, 430, 374, 
	373, 419, 374, 373, 432, 374, 373, 433, 
	374, 373, 434, 374, 373, 435, 374, 373, 
	436, 374, 373, 437, 374, 373, 438, 374, 
	373, 439, 374, 373, 440, 374, 373, 441, 
	374, 84, 373, 390, 374, 373, 443, 448, 
	374, 373, 444, 374, 373, 445, 374, 373, 
	446, 374, 373, 447, 374, 373, 415, 374, 
	373, 449, 480, 374, 373, 450, 374, 373, 
	451, 374, 373, 452, 374, 373, 453, 374, 
	373, 454, 374, 373, 455, 374, 373, 456, 
	374, 373, 457, 374, 373, 458, 374, 373, 
	459, 374, 373, 460, 374, 373, 461, 374, 
	373, 462, 374, 373, 463, 374, 373, 374, 
	464, 373, 465, 374, 373, 466, 374, 373, 
	467, 374, 373, 468, 374, 373, 469, 374, 
	373, 470, 374, 373, 471, 374, 373, 472, 
	374, 373, 473, 374, 373, 474, 374, 373, 
	475, 374, 373, 476, 374, 373, 477, 374, 
	373, 478, 374, 373, 479, 374, 373, 415, 
	374, 373, 481, 374, 373, 482, 374, 373, 
	483, 374, 373, 484, 374, 373, 485, 374, 
	373, 486, 374, 373, 487, 374, 373, 488, 
	374, 373, 489, 374, 373, 490, 374, 373, 
	491, 492, 374, 373, 390, 374, 373, 493, 
	374, 373, 441, 374, 373, 495, 374, 373, 
	496, 374, 373, 497, 374, 373, 498, 374, 
	373, 499, 374, 373, 500, 374, 373, 501, 
	374, 373, 502, 374, 373, 503, 374, 373, 
	504, 374, 373, 505, 374, 373, 506, 374, 
	373, 507, 374, 373, 508, 374, 373, 509, 
	374, 373, 510, 374, 373, 511, 374, 373, 
	403, 374, 373, 374, 513, 373, 374, 514, 
	373, 374, 515, 373, 374, 516, 373, 374, 
	517, 373, 374, 518, 373, 374, 519, 373, 
	374, 520, 373, 374, 521, 373, 374, 522, 
	373, 374, 523, 373, 374, 524, 373, 374, 
	525, 373, 374, 10, 373, 527, 531, 0, 
	528, 0, 529, 0, 530, 0, 61, 0, 
	532, 0, 533, 0, 534, 540, 0, 535, 
	0, 536, 0, 537, 0, 538, 0, 539, 
	0, 74, 0, 541, 0, 542, 0, 543, 
	0, 544, 0, 545, 0, 546, 0, 547, 
	0, 371, 0, 549, 560, 0, 550, 0, 
	551, 0, 552, 0, 553, 0, 554, 0, 
	555, 0, 556, 0, 557, 0, 558, 0, 
	559, 0, 538, 0, 561, 0, 562, 0, 
	563, 0, 564, 0, 565, 0, 566, 0, 
	567, 0, 568, 0, 569, 0, 570, 623, 
	0, 571, 0, 572, 0, 574, 573, 574, 
	573, 575, 574, 574, 10, 10, 574, 573, 
	576, 593, 605, 574, 573, 577, 574, 573, 
	578, 574, 573, 579, 574, 573, 580, 574, 
	573, 581, 574, 573, 582, 574, 573, 583, 
	574, 573, 584, 574, 573, 585, 574, 573, 
	586, 574, 573, 587, 574, 573, 588, 574, 
	573, 589, 574, 573, 590, 574, 573, 591, 
	574, 573, 592, 574, 573, 574, 84, 573, 
	594, 574, 573, 595, 574, 573, 596, 574, 
	573, 597, 574, 573, 598, 574, 573, 599, 
	574, 573, 600, 574, 573, 601, 574, 573, 
	602, 574, 573, 603, 574, 573, 604, 574, 
	573, 592, 574, 573, 606, 574, 573, 607, 
	574, 573, 608, 574, 573, 609, 574, 573, 
	610, 574, 573, 611, 574, 573, 612, 574, 
	573, 613, 574, 573, 614, 574, 573, 615, 
	574, 573, 616, 574, 573, 617, 574, 573, 
	618, 574, 573, 619, 574, 573, 620, 574, 
	573, 621, 574, 573, 622, 574, 573, 584, 
	574, 573, 625, 624, 625, 624, 626, 625, 
	625, 10, 782, 631, 10, 625, 624, 627, 
	632, 631, 642, 665, 677, 697, 714, 764, 
	625, 624, 628, 625, 624, 629, 625, 624, 
	630, 625, 624, 631, 625, 624, 625, 84, 
	624, 633, 625, 624, 634, 625, 624, 635, 
	625, 624, 636, 625, 624, 637, 625, 624, 
	638, 625, 624, 639, 625, 624, 640, 625, 
	624, 641, 625, 624, 631, 631, 631, 625, 
	624, 643, 625, 624, 644, 648, 625, 624, 
	645, 625, 624, 646, 625, 624, 647, 625, 
	84, 624, 631, 625, 624, 649, 625, 624, 
	650, 625, 624, 651, 625, 624, 652, 661, 
	625, 624, 653, 625, 624, 654, 625, 624, 
	655, 625, 624, 656, 625, 624, 657, 625, 
	624, 658, 625, 624, 659, 625, 624, 660, 
	625, 624, 625, 84, 624, 662, 625, 624, 
	663, 625, 624, 664, 625, 624, 658, 625, 
	624, 666, 625, 624, 667, 625, 624, 668, 
	625, 624, 669, 625, 624, 670, 625, 624, 
	671, 625, 624, 672, 625, 624, 673, 625, 
	624, 674, 625, 624, 675, 625, 624, 676, 
	625, 624, 656, 625, 624, 678, 682, 625, 
	624, 679, 625, 624, 680, 625, 624, 681, 
	625, 624, 647, 625, 624, 683, 625, 624, 
	684, 625, 624, 685, 691, 625, 624, 686, 
	625, 624, 687, 625, 624, 688, 625, 624, 
	689, 625, 624, 690, 625, 624, 660, 625, 
	624, 692, 625, 624, 693, 625, 624, 694, 
	625, 624, 695, 625, 624, 696, 625, 624, 
	689, 625, 624, 698, 705, 625, 624, 699, 
	625, 624, 700, 625, 624, 701, 625, 624, 
	702, 625, 624, 703, 625, 624, 704, 625, 
	624, 693, 625, 624, 706, 625, 624, 707, 
	625, 624, 708, 625, 624, 709, 625, 624, 
	710, 625, 624, 711, 625, 624, 712, 625, 
	624, 713, 625, 624, 660, 625, 624, 715, 
	720, 625, 624, 716, 625, 624, 717, 625, 
	624, 718, 625, 624, 719, 625, 624, 689, 
	625, 624, 721, 752, 625, 624, 722, 625, 
	624, 723, 625, 624, 724, 625, 624, 725, 
	625, 624, 726, 625, 624, 727, 625, 624, 
	728, 625, 624, 729, 625, 624, 730, 625, 
	624, 731, 625, 624, 732, 625, 624, 733, 
	625, 624, 734, 625, 624, 735, 625, 624, 
	625, 736, 624, 737, 625, 624, 738, 625, 
	624, 739, 625, 624, 740, 625, 624, 741, 
	625, 624, 742, 625, 624, 743, 625, 624, 
	744, 625, 624, 745, 625, 624, 746, 625, 
	624, 747, 625, 624, 748, 625, 624, 749, 
	625, 624, 750, 625, 624, 751, 625, 624, 
	689, 625, 624, 753, 625, 624, 754, 625, 
	624, 755, 625, 624, 756, 625, 624, 757, 
	625, 624, 758, 625, 624, 759, 625, 624, 
	760, 625, 624, 761, 625, 624, 762, 625, 
	624, 763, 625, 624, 660, 625, 624, 765, 
	625, 624, 766, 625, 624, 767, 625, 624, 
	768, 625, 624, 769, 625, 624, 770, 625, 
	624, 771, 625, 624, 772, 625, 624, 773, 
	625, 624, 774, 625, 624, 775, 625, 624, 
	776, 625, 624, 777, 625, 624, 778, 625, 
	624, 779, 625, 624, 780, 625, 624, 781, 
	625, 624, 673, 625, 624, 625, 783, 624, 
	625, 784, 624, 625, 785, 624, 625, 786, 
	624, 625, 787, 624, 625, 788, 624, 625, 
	789, 624, 625, 790, 624, 625, 791, 624, 
	625, 792, 624, 625, 793, 624, 625, 794, 
	624, 625, 795, 624, 625, 10, 624, 797, 
	804, 0, 798, 0, 799, 0, 800, 0, 
	801, 0, 802, 0, 803, 0, 240, 0, 
	805, 836, 0, 806, 0, 807, 0, 808, 
	0, 809, 0, 810, 0, 811, 0, 812, 
	0, 813, 0, 814, 0, 815, 0, 816, 
	0, 817, 0, 818, 0, 819, 0, 820, 
	0, 821, 0, 822, 0, 823, 0, 824, 
	0, 825, 0, 826, 0, 827, 0, 828, 
	0, 829, 0, 830, 0, 831, 0, 832, 
	0, 833, 0, 834, 0, 835, 0, 802, 
	0, 837, 0, 838, 0, 839, 0, 840, 
	0, 841, 0, 842, 0, 843, 0, 844, 
	0, 845, 0, 846, 0, 847, 849, 0, 
	848, 0, 623, 0, 850, 0, 570, 0, 
	852, 0, 853, 0, 854, 0, 855, 0, 
	856, 0, 857, 0, 858, 0, 859, 0, 
	860, 0, 861, 0, 862, 0, 863, 0, 
	864, 0, 865, 0, 866, 0, 867, 0, 
	868, 0, 363, 0, 870, 0, 10, 0, 
	0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	149, 126, 57, 110, 23, 0, 29, 54, 
	0, 5, 1, 0, 29, 1, 35, 0, 
	43, 0, 43, 0, 43, 139, 48, 9, 
	106, 11, 0, 134, 45, 45, 45, 3, 
	122, 33, 33, 33, 0, 122, 33, 33, 
	33, 0, 122, 33, 0, 33, 0, 102, 
	7, 7, 43, 54, 0, 0, 43, 114, 
	25, 0, 54, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	43, 43, 43, 43, 0, 27, 118, 27, 
	27, 51, 27, 0, 54, 0, 1, 0, 
	43, 0, 0, 0, 43, 54, 37, 37, 
	87, 37, 37, 43, 0, 39, 0, 43, 
	0, 0, 54, 0, 0, 39, 0, 0, 
	96, 54, 0, 93, 90, 41, 96, 90, 
	99, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 72, 33, 84, 72, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 15, 
	0, 63, 130, 31, 60, 57, 31, 63, 
	57, 66, 31, 43, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 15, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	15, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 78, 
	33, 84, 78, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 19, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 19, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 19, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 19, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 69, 
	33, 69, 0, 0, 0, 0, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	13, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 13, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 13, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 81, 81, 0, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 21, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 144, 57, 54, 0, 84, 54, 
	0, 75, 33, 84, 75, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 17, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	17, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 17, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 17, 0, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 871;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1716 "ext/gherkin_lexer_sr_cyrl/gherkin_lexer_sr_cyrl.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
    
#line 1723 "ext/gherkin_lexer_sr_cyrl/gherkin_lexer_sr_cyrl.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 2013 "ext/gherkin_lexer_sr_cyrl/gherkin_lexer_sr_cyrl.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 2076 "ext/gherkin_lexer_sr_cyrl/gherkin_lexer_sr_cyrl.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/sr_cyrl.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_sr_cyrl()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Sr_cyrl", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

