#!/usr/bin/ruby
#
# Reads the logging format generated by the debug log method and generates/runs a problem
#
#
require 'rubygems'
require 'dep_selector/gecode_wrapper'

def read_process_file(name)
  file = File.open(name)
  problem = nil
  file.each do |line|
    next if line =~ /^\s*$/ 
    if line =~ /Creating VersionProblem inst\# (\d+) with (\d+) packages, (\d+) stats, (\d+) debug/ then
      instance, pkg_count, stats, debug = $1,$2.to_i,$3.to_i,($4 == '0' ? false : true)
#      puts "Cr #{instance} #{pkg_count} #{stats} #{debug}"
      problem = DepSelector::GecodeWrapper.new(pkg_count, debug)
      next
    end
    if line =~ /DepSelector inst\# (\d+) - Adding package id (\d+)\/(\d+): min = (-?\d+), max = (-?\d+), current version (-?\d+)/ then
      instance, pkg_id, pkg_count, min, max, cur = [$1,$2,$3,$4,$5,$6].map { |x| x.to_i }
#      puts "Add #{instance} #{pkg_id} #{pkg_count} #{min} #{max} #{cur}"
      problem.add_package(min, max, cur)
      next
    end
    if line =~ /DepSelector inst\# (\d+) - Adding VC for (\d+) @ (\d+) depPkg\s+(\d+)\s+\[\s*(\d+),\s*(\d+)\s+\]/ then
      instance, pkg_id, pkg_ver, depPkg_id, constraint_min, constraint_max = [$1, $2, $3, $4, $5, $6].map { |x| x.to_i }
#      puts "VC  #{instance} #{pkg_id} #{depPkg_id} #{pkg_ver}, #{constraint_min}, #{constraint_max}"
      problem.add_version_constraint(pkg_id, pkg_ver, depPkg_id, constraint_min, constraint_max)
      next
    end
    if line =~ /DepSelector inst\# (\d+) - Marking Package Required (\d+)/ then
      instance, pkg_id = $1.to_i, $2.to_i
      puts "Req #{instance} #{pkg_id}"
      problem.mark_required(pkg_id)
      next
    end
    if line =~ /DepSelector inst\# (\d+) - Marking Package Preferred Latest (\d+) weight (\d+)/ then
      instance, pkg_id, weight = [$1, $2, $3].map { |x| x.to_i }
#      puts "Prf #{instance} #{pkg_id} #{weight}"
      problem.mark_preferred_to_be_at_latest(pkg_id, weight);
      next
    end
    puts "Unmatched #{line}"
  end
  problem.solve
end


if __FILE__ == $0
  read_process_file(ARGV[0])
else
#  setup_interactive
end



    
