#ifndef _shipobj_h_
#define _shipobj_h_

#include "allegro.h"
#include "spaceobj.h"
#include "defs.h"
#include <vector>

using namespace std;

class Booster;
class Move;
class WeaponObject;
class HullObject;
class WeaponNode;
class ExplosionClass;
class Section;
class Group;

class ShipObject:public SpaceObject{
public:

	ShipObject( int qx, int qy, int spc, HullObject * hnew, Group * _group, Move * movey, int al );

	virtual bool MoveMe(vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight, Section * onscreen,DATAFILE * snd );

	virtual void Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * sd );
	
	virtual void Explode( ExplosionClass ** explr, int ME );

	virtual double DX();
	virtual double DY();
	
	virtual double AccelX();
	virtual double AccelY();
	
	virtual double Hurt();
	
	virtual bool powerUp();
	
	//destructor
	virtual ~ShipObject();

Move * style;
int special;

};

class MeteorObject:public ShipObject{
public:
	MeteorObject( int qx, int qy, int spc, HullObject * hnew, Move * hmove );
	virtual void Explode( ExplosionClass ** explr, int ME );
};

//there must be a better way to implement this
class EnemyGeneric:public ShipObject{
public:
	EnemyGeneric( int qx, int qy, HullObject * hnew, WeaponObject * myW, Move * movey, Group * _group );
	virtual void Radar( BITMAP * rad );
};

class PowerUp:public ShipObject{
public:
	PowerUp( int qx, int qy, HullObject * hnew, Move * movey );
	virtual bool Damage( double much );
	virtual void Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * sd);
	virtual bool powerUp();
	virtual bool needSpecial();
	virtual void Radar( BITMAP * rad );
};

class Money:public PowerUp{
public:
	Money( int qx, int qy, int m, HullObject * hnew, Move * movey );
	virtual bool Damage( double much );
	virtual void Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * sd );
};

class Health:public PowerUp{
public:
	Health( int qx, int qy, HullObject * hnew, Move * movey );
	virtual void Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * sd);
};

class Cloak:public PowerUp{
public:

	Cloak( int qx, int qy, HullObject * hnew, Move * movey );
	virtual void Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * sd);
};

#endif
