#include "section.h"
#include "spaceobj.h"
#include <stdlib.h>
#include <vector>

using namespace std;

Section::Section():
internal_list( 0 ) {

	for ( int q = 0; q < MAX_SECTION_LIST; q++ )
		container_list[q] = new vector< SpaceObject * >();

}


void Section::add( SpaceObject * who, int x, int y ) {

	y += MIN_SECTION_Y;
	y /= MAX_SECTION_OBJ;
	if ( y >= 0 && y < MAX_SECTION_LIST ) {

		//for ( int q = 0; q < container_list[y]->size(); q++ )
		//	if ( (*container_list[y])[q] == who ) return;

		container_list[y]->push_back( who );
	}

}


void Section::dispose( SpaceObject * who ) {

	for ( int q = 0; q < MAX_SECTION_LIST; q++ ) {

		for ( vector< SpaceObject * >::iterator it = container_list[q]->begin();
		it != container_list[q]->end(); ) {
			if ( *it == who )
				it = container_list[q]->erase( it );
			else ++it;
		}

	}

}


void Section::print() {

	/*
	printf("Info for %p\n", this );
	for ( int q = 0; q < MAX_SECTION_LIST; q++ ){

		printf("Container %d\n", q );
		Iterator * i = container_list[q]->iterator();

		while ( !i->isEmpty() ){
			printf("[%p]", i->getObj() );
			i->Next();
		}

	delete i;
	printf("\n");

	}
	printf("End info for %p\n", this );
	*/

}


void Section::reset() {
	internal_list = 0;
}


int Section::spacer() {
	return MAX_SECTION_OBJ;
}


void Section::clear() {

	for ( int q = 0; q < MAX_SECTION_LIST; q++ )
		container_list[q]->clear();
	internal_list = 0;

}


vector< SpaceObject * > * Section::getNext() {
	if ( internal_list < MAX_SECTION_LIST ) {
		internal_list++;
		return container_list[ internal_list-1 ];
	}
	return NULL;
}


Section::~Section() {
	clear();
	for ( int q = 0; q < MAX_SECTION_LIST; q++ )
		delete container_list[q];
}
