#include "allegro.h"
#include "spaceobj.h"
#include "defs.h"
#include "hull_weapon.h"
#include "hull_weapon_pulse_large.h"

LargePulse_WHull::LargePulse_WHull():
HullWeapon( 0, 1, 3 ){}

void LargePulse_WHull::Draw( BITMAP * who, int x, int y ) {
	for ( int tri = 0; tri < 2; tri++ ) {

		int x1 = x + rnd(7) - 3;
		int x2 = x + rnd(7) - 3;
		int y1 = y + 10 + rnd(8);
		triangle( who, x1,  y, x2, y, (x1+x2)/2, y1-2, makecol(255,20,0));
		triangle( who, x1,  y, x2, y, (x1+x2)/2, y1, makecol(240,20,0) );

	}

	ellipsefill( who, x, y-1, 3, 6, makecol(255,0,0) );
	ellipsefill( who, x, y, 3, 6, makecol(240,100,0) );

}


bool LargePulse_WHull::Collide( int mx, int my, SpaceObject * check ) {
	if ( check->HitMe( mx, my ) )
		return true;

	for ( int ang = 0; ang < 360; ang += 65 ) {

		int tx = (int)(mx + tcos[ang]*6 );
		int ty = (int)(my + tsine[ang]*6 );
		if ( check->HitMe( tx, ty ) )
			return true;

	}

	return false;

}
