/*  QuickList dialog_initial.c
 *  www.quicklist.org for more information.
 *
 *  Current owner:  Bob 
 *
 *  Copyright (C) 1999
 *  Robert Lissner
 *  Jay MacDonald
 *  Sam Phillips
 *  Keith Wesolowski 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "includes.h"
#include "globals.h"
#include "quicklist.xpm"


static void open_clicked (GtkObject *object, gpointer user_data) {
  open_file (NULL, NULL);
}

static void import_clicked (GtkObject *object, gpointer user_data) {
  file_import (NULL, NULL);
}

static void exit_clicked (GtkObject *object, gpointer user_data) {
  gtk_main_quit ();
}

/* ________________________________
  |                                |
  |    maybe_create_initial_db     |
  |________________________________|
 */
/* This function creates the dialog box that comes up first in quicklist.  The
   dialog asks:  New file, existing file, Exit Quickfile
   The box will also come up if there are no files on the desk as a result of
   closing files that were open */

void 
maybe_create_initial_db (void) 
{
  
  GtkWidget *new_button, 
            *open_button, 
	    *import_button,
            *exit_button,
	    *logo_pixmap,
	    *hbox, 
 	    *button_vbox,
	    *label,
            *vbar;

  char *message; 

 
  GdkBitmap *mask;
  GdkPixmap *pix_map;

  
  if (file_ct)
    return; /* only want this dialog box if no files open */
  
  make_basic_dialog1 (); /* destroys any other */
  dialog1_file = NULL;
  gtk_window_set_title (GTK_WINDOW (dialog1_win), 
			_("Welcome to QuickList v" VERSION));

  gtk_box_set_spacing (GTK_BOX (GTK_DIALOG(dialog1_win)->vbox), 5);


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog1_win)->vbox),
                      hbox, TRUE, TRUE, 0);

  gtk_widget_realize (dialog1_win);
  pix_map = 
	gdk_pixmap_colormap_create_from_xpm_d (dialog1_win->window, NULL, 
		&mask, NULL, quicklist_xpm);
  logo_pixmap = gtk_pixmap_new (pix_map, mask);
  gtk_container_add (GTK_CONTAINER (hbox), logo_pixmap);

  vbar = gtk_vseparator_new ();
  gtk_container_add (GTK_CONTAINER (hbox), vbar);

  button_vbox = gtk_vbox_new (TRUE, 5);
  gtk_container_add (GTK_CONTAINER(hbox), button_vbox);
 

  new_button = gtk_button_new_with_label (_("New list"));
  gtk_box_pack_start (GTK_BOX (button_vbox),
		      new_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(new_button), "clicked", 
		      GTK_SIGNAL_FUNC (new_file), NULL);

  open_button = gtk_button_new_with_label (_("Open existing list"));
  gtk_box_pack_start (GTK_BOX (button_vbox),
		      open_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(open_button),"clicked", 
		      GTK_SIGNAL_FUNC(open_clicked), NULL);

  import_button = gtk_button_new_with_label (_("Import list"));
  gtk_box_pack_start (GTK_BOX (button_vbox),
		      import_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(import_button),"clicked", 
		      GTK_SIGNAL_FUNC(import_clicked), NULL);


  exit_button = gtk_button_new_with_label (_("Exit QuickList"));
  gtk_box_pack_start (GTK_BOX (button_vbox),
		      exit_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT(exit_button),"clicked", 
		      GTK_SIGNAL_FUNC(exit_clicked), NULL );

  gtk_signal_connect (GTK_OBJECT  (dialog1_win),
		      "delete_event",
		      (GtkSignalFunc) exit_clicked, NULL);
 
  message = g_strconcat ("QuickList Version", VERSION, "\n",
	   "Copyright (c) 1999 the QuickList Team\n"
	   "(See Help screen for details)\n\n"
	   "Please visit the QuickList web site at\n"
	   "http://www.QuickList.org and register as a user.\n"
	   "You will make our day :-)  All information\n" 
	   "submitted is confidential.\n\n"
	   "QuickList is released under the GNU General Public\n"
	   "License. Go ahead and spread it around!", NULL);
  

  label = gtk_label_new (message); 
 
  g_free (message);

  gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog1_win)->action_area), 
		     label);

  gtk_widget_show_all (dialog1_win);
} /* End of maybe_create_initial_box */ 










