
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: MultiPath.i,v 1.11 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_multipath_i
#define quantlib_multipath_i

%include Path.i

%{
using QuantLib::MonteCarlo::Path;
using QuantLib::MonteCarlo::MultiPath;
using QuantLib::MonteCarlo::GaussianMultiPathGenerator;
typedef QuantLib::MonteCarlo::Sample<QuantLib::MonteCarlo::MultiPath>
    SampleMultiPath;
%}

class MultiPath {
  private:
    // access control - no constructor exported
    MultiPath();
  public:
    ~MultiPath();
     /* Size */ int assetNumber() const ;
};

%addmethods MultiPath {
    int __len__() {
        return int(self->assetNumber());
    }
    Path __getitem__(int i) {
        int size_ = int(self->assetNumber());
        if (i>=0 && i<size_) {
            return (*self)[i];
        } else if (i<0 && -i<=size_) {
            return (*self)[size_+i];
        } else {
            throw IndexError("Path index out of range");
        }
        QL_DUMMY_RETURN(0.0)
    }
}


class SampleMultiPath {
  public:
    ~SampleMultiPath();
    MultiPath value;
    double weight;
  private:
    SampleMultiPath();
};

class GaussianMultiPathGenerator {
  public:
    GaussianMultiPathGenerator(const Array& drifts,
							   const Matrix& covariance,
							   const DoubleVector& timeDelays,
							   long seed=0);
	~GaussianMultiPathGenerator();
	SampleMultiPath next() const;
};


#endif
