#!/usr/bin/python2.2

import sys
sys.path.append(".")

import libplot

MAXORDER = 12

def draw_c_curve( pl, dx, dy, order ):
	if order >= MAXORDER:
		pl.fcontrel( dx, dy )
	else:
		draw_c_curve( pl, 0.5 * (dx - dy), 0.5 * (dx + dy), order + 1 )
		draw_c_curve( pl, 0.5 * (dx + dy), 0.5 * (dy - dx), order + 1 )

if __name__ == '__main__':

	pl = libplot.Plotter()	# defaults to X window

	pl.openpl()

	pl.fspace( 0., 0., 1000., 1000. )
	pl.flinewidth( 0.25 )
	pl.pencolorname( "red" )
	pl.erase()
	pl.fmove( 600., 300. )

	draw_c_curve( pl, 0., 400., 0 )

	pl.closepl()
