// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "cone.h"
#include "axial.h"
#include "cylmodel.h"
#include GL_INCLUDE

namespace visual {

void 
cone::glRender( rView& view) 
{
	if (degenerate) return;
	
	/*static double brect[] = { 0,  1.0,  1.0,
	                            0, -1.0, -1.0};
	view.ext_brect(mwt, brect);*/
	view.ext_circle(mwt*vector(0,0,0), wlt[0], scale.y);
	view.ext_point(mwt*vector(2,0,0));
	
	tmatrix mct(mwt, view.wct);
	
	/* calculate some values that will be used to scale the light
	 vector.  What is really going on here is that the cone's
	 normals are being rotated as the slope (radius/length) of
	 the cone changes, but it is more efficient to do the 
	 multiplication once per light than once per vertex. */
	float scmag = std::sqrt(scale.x*scale.x + scale.y*scale.y);
	float nc = scale.y / scmag;
	float ns = scale.x / scmag;
	
	lighting lt(view.lights, wlt);
	  
	double left = lt.ambient;
	for(int l=0;l<lt.n_lights;l++) {
		if (lt.L[l].x < 0) left -= lt.L[l].x;
		lt.L[l].x *= nc;
		lt.L[l].y *= ns;
		lt.L[l].z *= ns;
	}
	
	// Level-of-detail heuristic.
	//   xxx Figure out how this should actually work!
	vector o = mct*vector(0,0,0) / mct.w(vector(0,0,0));
	vector oy = mct*vector(0,1,0) / mct.w(vector(0,1,0));
	vector oz = mct*vector(0,0,1) / mct.w(vector(0,0,1));
	float size = std::sqrt((o-oy).mag2() + (o-oz).mag2());
	int n = int(size*140);
	if (n<5) n=5;
	else if (n>20) n=20;
	cyl_model& model = cyl_model::get(n);
	
	// Project the tip of the cone.
	vertex tip;
	mct.project(vector(2,0,0), tip);
	
	// Lighting and projection loop.
	vertex *pr = model.proj;
	float *col = model.color;
	float *mv = model.verts;
	for(int v=0;v<model.nverts;v+=2) {
		double illum = lt.illuminate(1.0, mv[1], mv[2]);
	
		// We color two vertices at once, at
		//   opposite ends of the cone.
		col[0] = col[4] = color.r*illum;
		col[1] = col[5] = color.g*illum;
		col[2] = col[6] = color.b*illum;
		col[3] = col[7] = 1.0;
		col += 8;
	
		// Project two vertices.  The tip is always in the same
		//   place, no need to recalculate it.
		mct.project(mv, *pr++); 
		*pr++ = tip;
		mv+=6;
	}
	
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glVertexPointer(4, GL_DOUBLE, sizeof(vertex), &model.proj[0].x);
	glColorPointer(4, GL_FLOAT, 4*sizeof(float), model.color);
	glShadeModel(GL_SMOOTH);
	
	glDrawArrays(GL_TRIANGLE_STRIP, 0, model.nverts);
	  
	glDisableClientState(GL_COLOR_ARRAY);
	glShadeModel(GL_FLAT);
	
	glVertexPointer(4, GL_DOUBLE, 2*sizeof(vertex), &model.proj[0].x);
	glColor3d(color.r*left, color.g*left, color.b*left);
	glDrawArrays(GL_POLYGON, 0, model.nverts/2);
}

} // !namespace visual
