#ifndef VISUAL_KBOBJECT_H
#define VISUAL_KBOBJECT_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "cvisual.h"
#include <string>
#include <queue>

namespace visual {

/* The kbObject class acts as a synchronization bridge between python and the 
 * rendering loop.
 */
class kbObject
{
 private:
	mutex mtx;
	std::queue<std::string> keys;
 public:
  
	kbObject() {};
	std::string pop_next_key();
	void push_new_key( std::string key);
	int get_available_keys();
};

} // !namespace visual

#endif
