# Compile the mpipython executable containing
# the Scientific MPI extension module

# Name of the MPI compilation script.
# This should be correct for most MPI implementations.
mpicompiler = 'mpicc'


# Normally nothing needs to be changed below
import os, string, sys

lib = os.path.join(os.path.join(sys.exec_prefix, 'lib'),
                   'python'+sys.version[:3])

if os.path.exists('version_info'):
    info = open('version_info').readlines()
    platform = info[0][:-1]
    version = info[1][:-1]
    if sys.platform != platform or sys.version != version:
        os.system('make distclean')
        for file in ['Makefile.pre.in', 'Makefile.pre', 'Makefile']:
            if os.path.exists(file):
                os.unlink(file)

open('version_info', 'w').write(sys.platform+'\n' + sys.version+'\n')

if not os.path.exists('Makefile.pre.in'):
    source = os.path.join(os.path.join(lib, 'config'), 'Makefile.pre.in')
    if os.path.exists(source):
        os.system('cp ' + source + ' .')
    else:
        print "Copy Misc/Makefile.pre.in from the Python distribution"
        print "to this directory and try again."

if not os.path.exists('Makefile'):
    os.system("make -f Makefile.pre.in boot")

os.system("sed -e 's+\\$(LIBPL)/python\\.o+mpipython\\.o+g'" +
          " < Makefile > Makefile.mpi")
os.system("sed -e 's+PY_CFLAGS+CFLAGS+g'" +
          " < Makefile.mpi > Makefile")
#os.system("echo 'mpipython.o:\tmpipython.c' >> Makefile.mpi")
#os.system("echo '\t\t$(CC) $(CFLAGS) -c mpipython.c' >> Makefile.mpi")
#os.system("mv Makefile.mpi Makefile")

os.system("make CC=" + mpicompiler + " static")
os.system("mv python mpipython")
