#!/www/python/bin/python

# Test script for external manipulation of an OptionParser's option
# list: querying, removing, overriding, replacing options.

__revision__ = "$Id: test_manipulate.py,v 1.2 2001/12/10 19:33:26 gward Exp $"

import sys
from cStringIO import StringIO
from optik import OptionParser, Option, SUPPRESS_USAGE

# Test the OptionParser.remove_option() method: select an option
# through one of its option strings, and remove it completely
# from the OptionParser.

parser = OptionParser(usage=SUPPRESS_USAGE)
parser.add_option("-v", "--verbose", "-n", "--noisy",
                  action="store_true", dest="verbose")
parser.add_option("-q", "--quiet", "--silent",
                  action="store_false", dest="verbose")


opt1 = parser.get_option("-v")
assert isinstance(opt1, Option)
assert opt1._short_opts == ["-v", "-n"]
assert opt1._long_opts == ["--verbose", "--noisy"]
assert opt1.action == "store_true"
assert opt1.dest == "verbose"
print "ok: 1"

opt2 = parser.get_option("--verbose")
opt3 = parser.get_option("-n")
opt4 = parser.get_option("--noisy")
assert opt1 is opt2 is opt3 is opt4
print "ok: 2"

assert parser.has_option("-v")
assert parser.has_option("--verbose")
print "ok: 3"

assert parser.has_option("-q")
assert parser.has_option("--silent")
print "ok: 4"

sys.stdout = StringIO()
try:
    parser.parse_args(["--help"])
except SystemExit, err:
    stdout = sys.stdout.getvalue()
    sys.stdout = sys.__stdout__
    assert err[0] == 0
    assert stdout == """\
options:
  -h, --help            show this help message and exit
  -v, -n, --verbose, --noisy
  -q, --quiet, --silent
""", stdout
    print "ok: 5"
else:
    sys.stdout = sys.__stdout__
    print "not ok"


# Now do the removal, and make sure it has the desired effect.
parser.remove_option("-n")
assert parser.get_option("-v") is None
assert parser.get_option("--verbose") is None
assert parser.get_option("-n") is None
assert parser.get_option("--noisy") is None
print "ok: 6"

assert not parser.has_option("-v")
assert not parser.has_option("--verbose")
assert not parser.has_option("-n")
assert not parser.has_option("--noisy")

assert parser.has_option("-q")
assert parser.has_option("--silent")
print "ok: 7"

sys.stdout = StringIO()
try:
    parser.parse_args(["--help"])
except SystemExit, err:
    stdout = sys.stdout.getvalue()
    sys.stdout = sys.__stdout__
    assert err[0] == 0
    assert stdout == """\
options:
  -h, --help            show this help message and exit
  -q, --quiet, --silent
""", stdout
    print "ok: 8"
else:
    sys.stdout = sys.__stdout__
    print "not ok"
