#!/www/python/bin/python

import os, copy
from optik import OptionParser, Option, OptionValueError, SUPPRESS_USAGE

__revision__ = "$Id: test_extend.py,v 1.2 2001/11/14 15:32:16 gward Exp $"


# Test overriding 1: adding types

def check_file (option, opt, value):
    if not os.path.exists(value):
        raise OptionValueError("%s: file does not exist" % value)
    elif not os.path.isfile(value):
        raise OptionValueError("%s: not a regular file" % value)
    return value

class MyOption (Option):
    TYPES = Option.TYPES + ("file",)
    TYPE_CHECKER = copy.copy(Option.TYPE_CHECKER)
    TYPE_CHECKER["file"] = check_file

parser = OptionParser(usage=SUPPRESS_USAGE, option_class=MyOption)
parser.add_option("-a", None, type="string", dest="a")
parser.add_option("-f", "--file", type="file", dest="file")
try:
    (values, args) = parser.parse_args(["--file", "foo", "-afoo"])
except SystemExit, err:
    assert err.args[0].endswith("foo: file does not exist")
    print "ok: 1"
else:
    print "not ok"

os.mkdir("foo")
try:
    (values, args) = parser.parse_args(["--file", "foo", "-afoo"])
except SystemExit, err:
    assert err.args[0].endswith("foo: not a regular file")
    print "ok: 2"
else:
    print "not ok"

os.rmdir("foo")
open("foo", "w").close()
(values, args) = parser.parse_args(["--file", "foo", "-afoo"])
assert values.file == "foo"
assert values.a == "foo"
assert args == []
print "ok: 3"
os.unlink("foo")


# Test overriding 2: adding actions

class MyOption (Option):

    ACTIONS = Option.ACTIONS + ("extend",)
    STORE_ACTIONS = Option.STORE_ACTIONS + ("extend",)
    TYPED_ACTIONS = Option.TYPED_ACTIONS + ("extend",)

    def take_action (self, action, dest, opt, value, values, parser):
        if action == "extend":
            lvalue = value.split(",")
            values.ensure_value(dest, []).extend(lvalue)
        else:
            Option.take_action(self, action, dest, opt, parser, value, values)

parser = OptionParser(option_list=[
    MyOption("-a", "--apple", 
             action="extend", type="string", dest="apple")])

(values, args) = parser.parse_args(["-afoo,bar", "--apple=blah"])
assert values.apple == ["foo", "bar", "blah"]
assert args == []
print "ok: 4"

(values, args) = parser.parse_args(["-a", "foo", "-abar", "--apple=x,y"])
assert values.apple == ["foo", "bar", "x", "y"]
assert args == []
print "ok: 5"
