#!/usr/bin/env python
#
# $Id: setup.py,v 1.10 2001/11/12 21:48:11 doughellmann Exp $
#
# Time-stamp: <01/11/12 16:37:27 dhellmann>
#
# Copyright 2001 Doug Hellmann.
#
#
#                         All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose and without fee is hereby
# granted, provided that the above copyright notice appear in all
# copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of Doug
# Hellmann not be used in advertising or publicity pertaining to
# distribution of the software without specific, written prior
# permission.
#
# DOUG HELLMANN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
# NO EVENT SHALL DOUG HELLMANN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
# OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
"""Distutils setup file for HappyDoc

"""

__rcs_info__ = {
    #
    #  Creation Information
    #
    'module_name'  : '$RCSfile: setup.py,v $',
    'rcs_id'       : '$Id: setup.py,v 1.10 2001/11/12 21:48:11 doughellmann Exp $',
    'creator'      : 'Doug Hellmann <doug@hellfly.net>',
    'project'      : 'HappyDoc',
    'created'      : 'Sat, 03-Feb-2001 12:51:26 EST',

    #
    #  Current Information
    #
    'author'       : '$Author: doughellmann $',
    'version'      : '$Revision: 1.10 $',
    'date'         : '$Date: 2001/11/12 21:48:11 $',
}
try:
    __version__ = __rcs_info__['version'].split(' ')[1]
except:
    __version__ = '0.0'

#
# Import system modules
#
from distutils.core import setup
import sys

#
# Import Local modules
#
from happydoclib.cvsversion import cvsProductVersion

#
# Module
#

BSD_LICENSE="""

                    Copyright 2001 Doug Hellmann.

                         All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that copyright notice and this permission
notice appear in supporting documentation, and that the name of Doug
Hellmann not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

DOUG HELLMANN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
NO EVENT SHALL DOUG HELLMANN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
"""

LONG_DESCRIPTION = """
  HappyDoc is a tool for extracting documentation from Python source
  code.  It differs from other such applications by the fact that it
  uses the parse tree for a module to derive the information used in
  its output, rather that importing the module directly.  This allows
  the user to generate documentation for modules which need special
  context to be imported.
"""


if sys.platform == 'win32':
    platform_specific_scripts = ['happydocwin.py']
else:
    platform_specific_scripts = ['happydoc']

setup (
    name = 'HappyDoc',
    version = cvsProductVersion(),

    description = 'HappyDoc Automatic Documentation System',
    long_description = LONG_DESCRIPTION,

    author = 'Doug Hellmann',
    author_email = 'doug@hellfly.net',

    url = 'http://happydoc.sourceforge.net',
    licence = BSD_LICENSE,

    platforms = ('Any',),
    keywords = ('documentation', 'extraction', 'source', 'docstring', '__doc__'),

    packages = [ 'happydoclib',
                 'happydoclib.docset',
                 'happydoclib.docstring',
                 'happydoclib.docstring.StructuredText',
                 'happydoclib.formatter',
                 'happydoclib.formatter.OpenOffice',
                 'happydoclib.parseinfo',
                 ],
    
    package_dir = { '': '.' },
    
    scripts = platform_specific_scripts,
    )

