# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CacheIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity used for the cache
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"

class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DomainJoinedType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """True if the HPC Cache is joined to the Active Directory domain.
    """

    YES = "Yes"
    NO = "No"
    ERROR = "Error"

class FirmwareStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """True if there is a firmware update ready to install on this Cache. The firmware will
    automatically be installed after firmwareUpdateDeadline if not triggered earlier via the
    upgrade operation.
    """

    AVAILABLE = "available"
    UNAVAILABLE = "unavailable"

class HealthStateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of Cache health states.
    """

    UNKNOWN = "Unknown"
    HEALTHY = "Healthy"
    DEGRADED = "Degraded"
    DOWN = "Down"
    TRANSITIONING = "Transitioning"
    STOPPING = "Stopping"
    STOPPED = "Stopped"
    UPGRADING = "Upgrading"
    FLUSHING = "Flushing"
    WAITING_FOR_KEY = "WaitingForKey"
    START_FAILED = "StartFailed"
    UPGRADE_FAILED = "UpgradeFailed"

class MetricAggregationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    NOT_SPECIFIED = "NotSpecified"
    NONE = "None"
    AVERAGE = "Average"
    MINIMUM = "Minimum"
    MAXIMUM = "Maximum"
    TOTAL = "Total"
    COUNT = "Count"

class NfsAccessRuleAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Access allowed by this rule.
    """

    NO = "no"
    RO = "ro"
    RW = "rw"

class NfsAccessRuleScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scope for this rule. The scope and filter determine which clients match the rule.
    """

    DEFAULT = "default"
    NETWORK = "network"
    HOST = "host"

class OperationalStateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage target operational state.
    """

    READY = "Ready"
    BUSY = "Busy"
    SUSPENDED = "Suspended"
    FLUSHING = "Flushing"

class PrimingJobState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the priming operation.
    """

    QUEUED = "Queued"
    RUNNING = "Running"
    PAUSED = "Paused"
    COMPLETE = "Complete"

class ProvisioningStateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ARM provisioning state, see
    https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    CREATING = "Creating"
    DELETING = "Deleting"
    UPDATING = "Updating"

class ReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for the restriction. As of now this can be "QuotaId" or
    "NotAvailableForSubscription". "QuotaId" is set when the SKU has requiredQuotas parameter as
    the subscription does not belong to that quota. "NotAvailableForSubscription" is related to
    capacity at the datacenter.
    """

    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"

class StorageTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Storage Target.
    """

    NFS3 = "nfs3"
    CLFS = "clfs"
    UNKNOWN = "unknown"
    BLOB_NFS = "blobNfs"

class UsernameDownloadedType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether or not the HPC Cache has performed the username download successfully.
    """

    YES = "Yes"
    NO = "No"
    ERROR = "Error"

class UsernameSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This setting determines how the cache gets username and group names for clients.
    """

    AD = "AD"
    LDAP = "LDAP"
    FILE = "File"
    NONE = "None"
