# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._logic_management_client_enums import *


class AgreementContent(msrest.serialization.Model):
    """The integration account agreement content.

    :ivar a_s2: The AS2 agreement content.
    :vartype a_s2: ~azure.mgmt.logic.models.AS2AgreementContent
    :ivar x12: The X12 agreement content.
    :vartype x12: ~azure.mgmt.logic.models.X12AgreementContent
    :ivar edifact: The EDIFACT agreement content.
    :vartype edifact: ~azure.mgmt.logic.models.EdifactAgreementContent
    """

    _attribute_map = {
        'a_s2': {'key': 'aS2', 'type': 'AS2AgreementContent'},
        'x12': {'key': 'x12', 'type': 'X12AgreementContent'},
        'edifact': {'key': 'edifact', 'type': 'EdifactAgreementContent'},
    }

    def __init__(
        self,
        *,
        a_s2: Optional["AS2AgreementContent"] = None,
        x12: Optional["X12AgreementContent"] = None,
        edifact: Optional["EdifactAgreementContent"] = None,
        **kwargs
    ):
        """
        :keyword a_s2: The AS2 agreement content.
        :paramtype a_s2: ~azure.mgmt.logic.models.AS2AgreementContent
        :keyword x12: The X12 agreement content.
        :paramtype x12: ~azure.mgmt.logic.models.X12AgreementContent
        :keyword edifact: The EDIFACT agreement content.
        :paramtype edifact: ~azure.mgmt.logic.models.EdifactAgreementContent
        """
        super(AgreementContent, self).__init__(**kwargs)
        self.a_s2 = a_s2
        self.x12 = x12
        self.edifact = edifact


class ApiDeploymentParameterMetadata(msrest.serialization.Model):
    """The API deployment parameter metadata.

    :ivar type: The type.
    :vartype type: str
    :ivar is_required: Indicates whether its required.
    :vartype is_required: bool
    :ivar display_name: The display name.
    :vartype display_name: str
    :ivar description: The description.
    :vartype description: str
    :ivar visibility: The visibility. Possible values include: "NotSpecified", "Default",
     "Internal".
    :vartype visibility: str or ~azure.mgmt.logic.models.ApiDeploymentParameterVisibility
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_required': {'key': 'isRequired', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        is_required: Optional[bool] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        visibility: Optional[Union[str, "ApiDeploymentParameterVisibility"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type.
        :paramtype type: str
        :keyword is_required: Indicates whether its required.
        :paramtype is_required: bool
        :keyword display_name: The display name.
        :paramtype display_name: str
        :keyword description: The description.
        :paramtype description: str
        :keyword visibility: The visibility. Possible values include: "NotSpecified", "Default",
         "Internal".
        :paramtype visibility: str or ~azure.mgmt.logic.models.ApiDeploymentParameterVisibility
        """
        super(ApiDeploymentParameterMetadata, self).__init__(**kwargs)
        self.type = type
        self.is_required = is_required
        self.display_name = display_name
        self.description = description
        self.visibility = visibility


class ApiDeploymentParameterMetadataSet(msrest.serialization.Model):
    """The API deployment parameters metadata.

    :ivar package_content_link: The package content link parameter.
    :vartype package_content_link: ~azure.mgmt.logic.models.ApiDeploymentParameterMetadata
    :ivar redis_cache_connection_string: The package content link parameter.
    :vartype redis_cache_connection_string: ~azure.mgmt.logic.models.ApiDeploymentParameterMetadata
    """

    _attribute_map = {
        'package_content_link': {'key': 'packageContentLink', 'type': 'ApiDeploymentParameterMetadata'},
        'redis_cache_connection_string': {'key': 'redisCacheConnectionString', 'type': 'ApiDeploymentParameterMetadata'},
    }

    def __init__(
        self,
        *,
        package_content_link: Optional["ApiDeploymentParameterMetadata"] = None,
        redis_cache_connection_string: Optional["ApiDeploymentParameterMetadata"] = None,
        **kwargs
    ):
        """
        :keyword package_content_link: The package content link parameter.
        :paramtype package_content_link: ~azure.mgmt.logic.models.ApiDeploymentParameterMetadata
        :keyword redis_cache_connection_string: The package content link parameter.
        :paramtype redis_cache_connection_string:
         ~azure.mgmt.logic.models.ApiDeploymentParameterMetadata
        """
        super(ApiDeploymentParameterMetadataSet, self).__init__(**kwargs)
        self.package_content_link = package_content_link
        self.redis_cache_connection_string = redis_cache_connection_string


class Resource(msrest.serialization.Model):
    """The base resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApiOperation(Resource):
    """The api operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The api operations properties.
    :vartype properties: ~azure.mgmt.logic.models.ApiOperationPropertiesDefinition
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ApiOperationPropertiesDefinition'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["ApiOperationPropertiesDefinition"] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The api operations properties.
        :paramtype properties: ~azure.mgmt.logic.models.ApiOperationPropertiesDefinition
        """
        super(ApiOperation, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class ApiOperationAnnotation(msrest.serialization.Model):
    """The Api Operation Annotation.

    :ivar status: The status annotation. Possible values include: "NotSpecified", "Preview",
     "Production".
    :vartype status: str or ~azure.mgmt.logic.models.StatusAnnotation
    :ivar family: The family.
    :vartype family: str
    :ivar revision: The revision.
    :vartype revision: int
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "StatusAnnotation"]] = None,
        family: Optional[str] = None,
        revision: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword status: The status annotation. Possible values include: "NotSpecified", "Preview",
         "Production".
        :paramtype status: str or ~azure.mgmt.logic.models.StatusAnnotation
        :keyword family: The family.
        :paramtype family: str
        :keyword revision: The revision.
        :paramtype revision: int
        """
        super(ApiOperationAnnotation, self).__init__(**kwargs)
        self.status = status
        self.family = family
        self.revision = revision


class ApiOperationListResult(msrest.serialization.Model):
    """The list of managed API operations.

    :ivar value: The api operation definitions for an API.
    :vartype value: list[~azure.mgmt.logic.models.ApiOperation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApiOperation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The api operation definitions for an API.
        :paramtype value: list[~azure.mgmt.logic.models.ApiOperation]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(ApiOperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApiOperationPropertiesDefinition(msrest.serialization.Model):
    """The api operations properties.

    :ivar summary: The summary of the api operation.
    :vartype summary: str
    :ivar description: The description of the api operation.
    :vartype description: str
    :ivar visibility: The visibility of the api operation.
    :vartype visibility: str
    :ivar trigger: The trigger type of api operation.
    :vartype trigger: str
    :ivar trigger_hint: The trigger hint for the api operation.
    :vartype trigger_hint: str
    :ivar pageable: Indicates whether the api operation is pageable.
    :vartype pageable: bool
    :ivar annotation: The annotation of api operation.
    :vartype annotation: ~azure.mgmt.logic.models.ApiOperationAnnotation
    :ivar api: The api reference.
    :vartype api: ~azure.mgmt.logic.models.ApiReference
    :ivar inputs_definition: The operation inputs definition schema.
    :vartype inputs_definition: ~azure.mgmt.logic.models.SwaggerSchema
    :ivar responses_definition: The operation responses definition schemas.
    :vartype responses_definition: dict[str, ~azure.mgmt.logic.models.SwaggerSchema]
    :ivar is_webhook: Indicates whether the API operation is webhook or not.
    :vartype is_webhook: bool
    :ivar is_notification: Indicates whether the API operation is notification or not.
    :vartype is_notification: bool
    """

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': 'str'},
        'trigger': {'key': 'trigger', 'type': 'str'},
        'trigger_hint': {'key': 'triggerHint', 'type': 'str'},
        'pageable': {'key': 'pageable', 'type': 'bool'},
        'annotation': {'key': 'annotation', 'type': 'ApiOperationAnnotation'},
        'api': {'key': 'api', 'type': 'ApiReference'},
        'inputs_definition': {'key': 'inputsDefinition', 'type': 'SwaggerSchema'},
        'responses_definition': {'key': 'responsesDefinition', 'type': '{SwaggerSchema}'},
        'is_webhook': {'key': 'isWebhook', 'type': 'bool'},
        'is_notification': {'key': 'isNotification', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        summary: Optional[str] = None,
        description: Optional[str] = None,
        visibility: Optional[str] = None,
        trigger: Optional[str] = None,
        trigger_hint: Optional[str] = None,
        pageable: Optional[bool] = None,
        annotation: Optional["ApiOperationAnnotation"] = None,
        api: Optional["ApiReference"] = None,
        inputs_definition: Optional["SwaggerSchema"] = None,
        responses_definition: Optional[Dict[str, "SwaggerSchema"]] = None,
        is_webhook: Optional[bool] = None,
        is_notification: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword summary: The summary of the api operation.
        :paramtype summary: str
        :keyword description: The description of the api operation.
        :paramtype description: str
        :keyword visibility: The visibility of the api operation.
        :paramtype visibility: str
        :keyword trigger: The trigger type of api operation.
        :paramtype trigger: str
        :keyword trigger_hint: The trigger hint for the api operation.
        :paramtype trigger_hint: str
        :keyword pageable: Indicates whether the api operation is pageable.
        :paramtype pageable: bool
        :keyword annotation: The annotation of api operation.
        :paramtype annotation: ~azure.mgmt.logic.models.ApiOperationAnnotation
        :keyword api: The api reference.
        :paramtype api: ~azure.mgmt.logic.models.ApiReference
        :keyword inputs_definition: The operation inputs definition schema.
        :paramtype inputs_definition: ~azure.mgmt.logic.models.SwaggerSchema
        :keyword responses_definition: The operation responses definition schemas.
        :paramtype responses_definition: dict[str, ~azure.mgmt.logic.models.SwaggerSchema]
        :keyword is_webhook: Indicates whether the API operation is webhook or not.
        :paramtype is_webhook: bool
        :keyword is_notification: Indicates whether the API operation is notification or not.
        :paramtype is_notification: bool
        """
        super(ApiOperationPropertiesDefinition, self).__init__(**kwargs)
        self.summary = summary
        self.description = description
        self.visibility = visibility
        self.trigger = trigger
        self.trigger_hint = trigger_hint
        self.pageable = pageable
        self.annotation = annotation
        self.api = api
        self.inputs_definition = inputs_definition
        self.responses_definition = responses_definition
        self.is_webhook = is_webhook
        self.is_notification = is_notification


class ResourceReference(msrest.serialization.Model):
    """The resource reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The resource id.
        :paramtype id: str
        """
        super(ResourceReference, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class ApiReference(ResourceReference):
    """The Api reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar display_name: The display name of the api.
    :vartype display_name: str
    :ivar description: The description of the api.
    :vartype description: str
    :ivar icon_uri: The icon uri of the api.
    :vartype icon_uri: str
    :ivar swagger: The swagger of the api.
    :vartype swagger: any
    :ivar brand_color: The brand color of the api.
    :vartype brand_color: str
    :ivar category: The tier. Possible values include: "NotSpecified", "Enterprise", "Standard",
     "Premium".
    :vartype category: str or ~azure.mgmt.logic.models.ApiTier
    :ivar integration_service_environment: The integration service environment reference.
    :vartype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'icon_uri': {'key': 'iconUri', 'type': 'str'},
        'swagger': {'key': 'swagger', 'type': 'object'},
        'brand_color': {'key': 'brandColor', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'integration_service_environment': {'key': 'integrationServiceEnvironment', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        icon_uri: Optional[str] = None,
        swagger: Optional[Any] = None,
        brand_color: Optional[str] = None,
        category: Optional[Union[str, "ApiTier"]] = None,
        integration_service_environment: Optional["ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword id: The resource id.
        :paramtype id: str
        :keyword display_name: The display name of the api.
        :paramtype display_name: str
        :keyword description: The description of the api.
        :paramtype description: str
        :keyword icon_uri: The icon uri of the api.
        :paramtype icon_uri: str
        :keyword swagger: The swagger of the api.
        :paramtype swagger: any
        :keyword brand_color: The brand color of the api.
        :paramtype brand_color: str
        :keyword category: The tier. Possible values include: "NotSpecified", "Enterprise", "Standard",
         "Premium".
        :paramtype category: str or ~azure.mgmt.logic.models.ApiTier
        :keyword integration_service_environment: The integration service environment reference.
        :paramtype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
        """
        super(ApiReference, self).__init__(id=id, **kwargs)
        self.display_name = display_name
        self.description = description
        self.icon_uri = icon_uri
        self.swagger = swagger
        self.brand_color = brand_color
        self.category = category
        self.integration_service_environment = integration_service_environment


class ApiResourceBackendService(msrest.serialization.Model):
    """The API backend service.

    :ivar service_url: The service URL.
    :vartype service_url: str
    """

    _attribute_map = {
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword service_url: The service URL.
        :paramtype service_url: str
        """
        super(ApiResourceBackendService, self).__init__(**kwargs)
        self.service_url = service_url


class ApiResourceDefinitions(msrest.serialization.Model):
    """The Api resource definition.

    :ivar original_swagger_url: The original swagger url.
    :vartype original_swagger_url: str
    :ivar modified_swagger_url: The modified swagger url.
    :vartype modified_swagger_url: str
    """

    _attribute_map = {
        'original_swagger_url': {'key': 'originalSwaggerUrl', 'type': 'str'},
        'modified_swagger_url': {'key': 'modifiedSwaggerUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        original_swagger_url: Optional[str] = None,
        modified_swagger_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword original_swagger_url: The original swagger url.
        :paramtype original_swagger_url: str
        :keyword modified_swagger_url: The modified swagger url.
        :paramtype modified_swagger_url: str
        """
        super(ApiResourceDefinitions, self).__init__(**kwargs)
        self.original_swagger_url = original_swagger_url
        self.modified_swagger_url = modified_swagger_url


class ApiResourceGeneralInformation(msrest.serialization.Model):
    """The API general information.

    :ivar icon_url: The icon url.
    :vartype icon_url: str
    :ivar display_name: The display name.
    :vartype display_name: str
    :ivar description: The description.
    :vartype description: str
    :ivar terms_of_use_url: The terms of use url.
    :vartype terms_of_use_url: str
    :ivar release_tag: The release tag.
    :vartype release_tag: str
    :ivar tier: The tier. Possible values include: "NotSpecified", "Enterprise", "Standard",
     "Premium".
    :vartype tier: str or ~azure.mgmt.logic.models.ApiTier
    """

    _attribute_map = {
        'icon_url': {'key': 'iconUrl', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'terms_of_use_url': {'key': 'termsOfUseUrl', 'type': 'str'},
        'release_tag': {'key': 'releaseTag', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        icon_url: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        terms_of_use_url: Optional[str] = None,
        release_tag: Optional[str] = None,
        tier: Optional[Union[str, "ApiTier"]] = None,
        **kwargs
    ):
        """
        :keyword icon_url: The icon url.
        :paramtype icon_url: str
        :keyword display_name: The display name.
        :paramtype display_name: str
        :keyword description: The description.
        :paramtype description: str
        :keyword terms_of_use_url: The terms of use url.
        :paramtype terms_of_use_url: str
        :keyword release_tag: The release tag.
        :paramtype release_tag: str
        :keyword tier: The tier. Possible values include: "NotSpecified", "Enterprise", "Standard",
         "Premium".
        :paramtype tier: str or ~azure.mgmt.logic.models.ApiTier
        """
        super(ApiResourceGeneralInformation, self).__init__(**kwargs)
        self.icon_url = icon_url
        self.display_name = display_name
        self.description = description
        self.terms_of_use_url = terms_of_use_url
        self.release_tag = release_tag
        self.tier = tier


class ApiResourceMetadata(msrest.serialization.Model):
    """The api resource metadata.

    :ivar source: The source.
    :vartype source: str
    :ivar brand_color: The brand color.
    :vartype brand_color: str
    :ivar hide_key: The hide key.
    :vartype hide_key: str
    :ivar tags: A set of tags. The tags.
    :vartype tags: dict[str, str]
    :ivar api_type: The api type. Possible values include: "NotSpecified", "Rest", "Soap".
    :vartype api_type: str or ~azure.mgmt.logic.models.ApiType
    :ivar wsdl_service: The WSDL service.
    :vartype wsdl_service: ~azure.mgmt.logic.models.WsdlService
    :ivar wsdl_import_method: The WSDL import method. Possible values include: "NotSpecified",
     "SoapToRest", "SoapPassThrough".
    :vartype wsdl_import_method: str or ~azure.mgmt.logic.models.WsdlImportMethod
    :ivar connection_type: The connection type.
    :vartype connection_type: str
    :ivar provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar deployment_parameters: The connector deployment parameters metadata.
    :vartype deployment_parameters: ~azure.mgmt.logic.models.ApiDeploymentParameterMetadataSet
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'brand_color': {'key': 'brandColor', 'type': 'str'},
        'hide_key': {'key': 'hideKey', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'api_type': {'key': 'ApiType', 'type': 'str'},
        'wsdl_service': {'key': 'wsdlService', 'type': 'WsdlService'},
        'wsdl_import_method': {'key': 'wsdlImportMethod', 'type': 'str'},
        'connection_type': {'key': 'connectionType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_parameters': {'key': 'deploymentParameters', 'type': 'ApiDeploymentParameterMetadataSet'},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        brand_color: Optional[str] = None,
        hide_key: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        api_type: Optional[Union[str, "ApiType"]] = None,
        wsdl_service: Optional["WsdlService"] = None,
        wsdl_import_method: Optional[Union[str, "WsdlImportMethod"]] = None,
        connection_type: Optional[str] = None,
        provisioning_state: Optional[Union[str, "WorkflowProvisioningState"]] = None,
        deployment_parameters: Optional["ApiDeploymentParameterMetadataSet"] = None,
        **kwargs
    ):
        """
        :keyword source: The source.
        :paramtype source: str
        :keyword brand_color: The brand color.
        :paramtype brand_color: str
        :keyword hide_key: The hide key.
        :paramtype hide_key: str
        :keyword tags: A set of tags. The tags.
        :paramtype tags: dict[str, str]
        :keyword api_type: The api type. Possible values include: "NotSpecified", "Rest", "Soap".
        :paramtype api_type: str or ~azure.mgmt.logic.models.ApiType
        :keyword wsdl_service: The WSDL service.
        :paramtype wsdl_service: ~azure.mgmt.logic.models.WsdlService
        :keyword wsdl_import_method: The WSDL import method. Possible values include: "NotSpecified",
         "SoapToRest", "SoapPassThrough".
        :paramtype wsdl_import_method: str or ~azure.mgmt.logic.models.WsdlImportMethod
        :keyword connection_type: The connection type.
        :paramtype connection_type: str
        :keyword provisioning_state: The provisioning state. Possible values include: "NotSpecified",
         "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
         "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
         "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
        :paramtype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
        :keyword deployment_parameters: The connector deployment parameters metadata.
        :paramtype deployment_parameters: ~azure.mgmt.logic.models.ApiDeploymentParameterMetadataSet
        """
        super(ApiResourceMetadata, self).__init__(**kwargs)
        self.source = source
        self.brand_color = brand_color
        self.hide_key = hide_key
        self.tags = tags
        self.api_type = api_type
        self.wsdl_service = wsdl_service
        self.wsdl_import_method = wsdl_import_method
        self.connection_type = connection_type
        self.provisioning_state = provisioning_state
        self.deployment_parameters = deployment_parameters


class ApiResourcePolicies(msrest.serialization.Model):
    """The API resource policies.

    :ivar content: The API level only policies XML as embedded content.
    :vartype content: str
    :ivar content_link: The content link to the policies.
    :vartype content_link: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        content_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword content: The API level only policies XML as embedded content.
        :paramtype content: str
        :keyword content_link: The content link to the policies.
        :paramtype content_link: str
        """
        super(ApiResourcePolicies, self).__init__(**kwargs)
        self.content = content
        self.content_link = content_link


class ApiResourceProperties(msrest.serialization.Model):
    """The API resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name.
    :vartype name: str
    :ivar connection_parameters: The connection parameters.
    :vartype connection_parameters: dict[str, any]
    :ivar metadata: The metadata.
    :vartype metadata: ~azure.mgmt.logic.models.ApiResourceMetadata
    :ivar runtime_urls: The runtime urls.
    :vartype runtime_urls: list[str]
    :ivar general_information: The api general information.
    :vartype general_information: ~azure.mgmt.logic.models.ApiResourceGeneralInformation
    :ivar capabilities: The capabilities.
    :vartype capabilities: list[str]
    :ivar backend_service: The backend service.
    :vartype backend_service: ~azure.mgmt.logic.models.ApiResourceBackendService
    :ivar policies: The policies for the API.
    :vartype policies: ~azure.mgmt.logic.models.ApiResourcePolicies
    :ivar api_definition_url: The API definition.
    :vartype api_definition_url: str
    :ivar api_definitions: The api definitions.
    :vartype api_definitions: ~azure.mgmt.logic.models.ApiResourceDefinitions
    :ivar integration_service_environment: The integration service environment reference.
    :vartype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    :ivar provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar category: The category. Possible values include: "NotSpecified", "Enterprise",
     "Standard", "Premium".
    :vartype category: str or ~azure.mgmt.logic.models.ApiTier
    """

    _validation = {
        'name': {'readonly': True},
        'connection_parameters': {'readonly': True},
        'metadata': {'readonly': True},
        'runtime_urls': {'readonly': True},
        'general_information': {'readonly': True},
        'capabilities': {'readonly': True},
        'backend_service': {'readonly': True},
        'policies': {'readonly': True},
        'api_definition_url': {'readonly': True},
        'api_definitions': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'category': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_parameters': {'key': 'connectionParameters', 'type': '{object}'},
        'metadata': {'key': 'metadata', 'type': 'ApiResourceMetadata'},
        'runtime_urls': {'key': 'runtimeUrls', 'type': '[str]'},
        'general_information': {'key': 'generalInformation', 'type': 'ApiResourceGeneralInformation'},
        'capabilities': {'key': 'capabilities', 'type': '[str]'},
        'backend_service': {'key': 'backendService', 'type': 'ApiResourceBackendService'},
        'policies': {'key': 'policies', 'type': 'ApiResourcePolicies'},
        'api_definition_url': {'key': 'apiDefinitionUrl', 'type': 'str'},
        'api_definitions': {'key': 'apiDefinitions', 'type': 'ApiResourceDefinitions'},
        'integration_service_environment': {'key': 'integrationServiceEnvironment', 'type': 'ResourceReference'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        integration_service_environment: Optional["ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword integration_service_environment: The integration service environment reference.
        :paramtype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
        """
        super(ApiResourceProperties, self).__init__(**kwargs)
        self.name = None
        self.connection_parameters = None
        self.metadata = None
        self.runtime_urls = None
        self.general_information = None
        self.capabilities = None
        self.backend_service = None
        self.policies = None
        self.api_definition_url = None
        self.api_definitions = None
        self.integration_service_environment = integration_service_environment
        self.provisioning_state = None
        self.category = None


class ArtifactProperties(msrest.serialization.Model):
    """The artifact properties definition.

    :ivar created_time: The artifact creation time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The artifact changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar metadata: Anything.
    :vartype metadata: any
    """

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        created_time: Optional[datetime.datetime] = None,
        changed_time: Optional[datetime.datetime] = None,
        metadata: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword created_time: The artifact creation time.
        :paramtype created_time: ~datetime.datetime
        :keyword changed_time: The artifact changed time.
        :paramtype changed_time: ~datetime.datetime
        :keyword metadata: Anything.
        :paramtype metadata: any
        """
        super(ArtifactProperties, self).__init__(**kwargs)
        self.created_time = created_time
        self.changed_time = changed_time
        self.metadata = metadata


class ArtifactContentPropertiesDefinition(ArtifactProperties):
    """The artifact content properties definition.

    :ivar created_time: The artifact creation time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The artifact changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar metadata: Anything.
    :vartype metadata: any
    :ivar content: Anything.
    :vartype content: any
    :ivar content_type: The content type.
    :vartype content_type: str
    :ivar content_link: The content link.
    :vartype content_link: ~azure.mgmt.logic.models.ContentLink
    """

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'content': {'key': 'content', 'type': 'object'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        created_time: Optional[datetime.datetime] = None,
        changed_time: Optional[datetime.datetime] = None,
        metadata: Optional[Any] = None,
        content: Optional[Any] = None,
        content_type: Optional[str] = None,
        content_link: Optional["ContentLink"] = None,
        **kwargs
    ):
        """
        :keyword created_time: The artifact creation time.
        :paramtype created_time: ~datetime.datetime
        :keyword changed_time: The artifact changed time.
        :paramtype changed_time: ~datetime.datetime
        :keyword metadata: Anything.
        :paramtype metadata: any
        :keyword content: Anything.
        :paramtype content: any
        :keyword content_type: The content type.
        :paramtype content_type: str
        :keyword content_link: The content link.
        :paramtype content_link: ~azure.mgmt.logic.models.ContentLink
        """
        super(ArtifactContentPropertiesDefinition, self).__init__(created_time=created_time, changed_time=changed_time, metadata=metadata, **kwargs)
        self.content = content
        self.content_type = content_type
        self.content_link = content_link


class AS2AcknowledgementConnectionSettings(msrest.serialization.Model):
    """The AS2 agreement acknowledgement connection settings.

    All required parameters must be populated in order to send to Azure.

    :ivar ignore_certificate_name_mismatch: Required. Indicates whether to ignore mismatch in
     certificate name.
    :vartype ignore_certificate_name_mismatch: bool
    :ivar support_http_status_code_continue: Required. Indicates whether to support HTTP status
     code 'CONTINUE'.
    :vartype support_http_status_code_continue: bool
    :ivar keep_http_connection_alive: Required. Indicates whether to keep the connection alive.
    :vartype keep_http_connection_alive: bool
    :ivar unfold_http_headers: Required. Indicates whether to unfold the HTTP headers.
    :vartype unfold_http_headers: bool
    """

    _validation = {
        'ignore_certificate_name_mismatch': {'required': True},
        'support_http_status_code_continue': {'required': True},
        'keep_http_connection_alive': {'required': True},
        'unfold_http_headers': {'required': True},
    }

    _attribute_map = {
        'ignore_certificate_name_mismatch': {'key': 'ignoreCertificateNameMismatch', 'type': 'bool'},
        'support_http_status_code_continue': {'key': 'supportHttpStatusCodeContinue', 'type': 'bool'},
        'keep_http_connection_alive': {'key': 'keepHttpConnectionAlive', 'type': 'bool'},
        'unfold_http_headers': {'key': 'unfoldHttpHeaders', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        ignore_certificate_name_mismatch: bool,
        support_http_status_code_continue: bool,
        keep_http_connection_alive: bool,
        unfold_http_headers: bool,
        **kwargs
    ):
        """
        :keyword ignore_certificate_name_mismatch: Required. Indicates whether to ignore mismatch in
         certificate name.
        :paramtype ignore_certificate_name_mismatch: bool
        :keyword support_http_status_code_continue: Required. Indicates whether to support HTTP status
         code 'CONTINUE'.
        :paramtype support_http_status_code_continue: bool
        :keyword keep_http_connection_alive: Required. Indicates whether to keep the connection alive.
        :paramtype keep_http_connection_alive: bool
        :keyword unfold_http_headers: Required. Indicates whether to unfold the HTTP headers.
        :paramtype unfold_http_headers: bool
        """
        super(AS2AcknowledgementConnectionSettings, self).__init__(**kwargs)
        self.ignore_certificate_name_mismatch = ignore_certificate_name_mismatch
        self.support_http_status_code_continue = support_http_status_code_continue
        self.keep_http_connection_alive = keep_http_connection_alive
        self.unfold_http_headers = unfold_http_headers


class AS2AgreementContent(msrest.serialization.Model):
    """The integration account AS2 agreement content.

    All required parameters must be populated in order to send to Azure.

    :ivar receive_agreement: Required. The AS2 one-way receive agreement.
    :vartype receive_agreement: ~azure.mgmt.logic.models.AS2OneWayAgreement
    :ivar send_agreement: Required. The AS2 one-way send agreement.
    :vartype send_agreement: ~azure.mgmt.logic.models.AS2OneWayAgreement
    """

    _validation = {
        'receive_agreement': {'required': True},
        'send_agreement': {'required': True},
    }

    _attribute_map = {
        'receive_agreement': {'key': 'receiveAgreement', 'type': 'AS2OneWayAgreement'},
        'send_agreement': {'key': 'sendAgreement', 'type': 'AS2OneWayAgreement'},
    }

    def __init__(
        self,
        *,
        receive_agreement: "AS2OneWayAgreement",
        send_agreement: "AS2OneWayAgreement",
        **kwargs
    ):
        """
        :keyword receive_agreement: Required. The AS2 one-way receive agreement.
        :paramtype receive_agreement: ~azure.mgmt.logic.models.AS2OneWayAgreement
        :keyword send_agreement: Required. The AS2 one-way send agreement.
        :paramtype send_agreement: ~azure.mgmt.logic.models.AS2OneWayAgreement
        """
        super(AS2AgreementContent, self).__init__(**kwargs)
        self.receive_agreement = receive_agreement
        self.send_agreement = send_agreement


class AS2EnvelopeSettings(msrest.serialization.Model):
    """The AS2 agreement envelope settings.

    All required parameters must be populated in order to send to Azure.

    :ivar message_content_type: Required. The message content type.
    :vartype message_content_type: str
    :ivar transmit_file_name_in_mime_header: Required. The value indicating whether to transmit
     file name in mime header.
    :vartype transmit_file_name_in_mime_header: bool
    :ivar file_name_template: Required. The template for file name.
    :vartype file_name_template: str
    :ivar suspend_message_on_file_name_generation_error: Required. The value indicating whether to
     suspend message on file name generation error.
    :vartype suspend_message_on_file_name_generation_error: bool
    :ivar autogenerate_file_name: Required. The value indicating whether to auto generate file
     name.
    :vartype autogenerate_file_name: bool
    """

    _validation = {
        'message_content_type': {'required': True},
        'transmit_file_name_in_mime_header': {'required': True},
        'file_name_template': {'required': True},
        'suspend_message_on_file_name_generation_error': {'required': True},
        'autogenerate_file_name': {'required': True},
    }

    _attribute_map = {
        'message_content_type': {'key': 'messageContentType', 'type': 'str'},
        'transmit_file_name_in_mime_header': {'key': 'transmitFileNameInMimeHeader', 'type': 'bool'},
        'file_name_template': {'key': 'fileNameTemplate', 'type': 'str'},
        'suspend_message_on_file_name_generation_error': {'key': 'suspendMessageOnFileNameGenerationError', 'type': 'bool'},
        'autogenerate_file_name': {'key': 'autogenerateFileName', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        message_content_type: str,
        transmit_file_name_in_mime_header: bool,
        file_name_template: str,
        suspend_message_on_file_name_generation_error: bool,
        autogenerate_file_name: bool,
        **kwargs
    ):
        """
        :keyword message_content_type: Required. The message content type.
        :paramtype message_content_type: str
        :keyword transmit_file_name_in_mime_header: Required. The value indicating whether to transmit
         file name in mime header.
        :paramtype transmit_file_name_in_mime_header: bool
        :keyword file_name_template: Required. The template for file name.
        :paramtype file_name_template: str
        :keyword suspend_message_on_file_name_generation_error: Required. The value indicating whether
         to suspend message on file name generation error.
        :paramtype suspend_message_on_file_name_generation_error: bool
        :keyword autogenerate_file_name: Required. The value indicating whether to auto generate file
         name.
        :paramtype autogenerate_file_name: bool
        """
        super(AS2EnvelopeSettings, self).__init__(**kwargs)
        self.message_content_type = message_content_type
        self.transmit_file_name_in_mime_header = transmit_file_name_in_mime_header
        self.file_name_template = file_name_template
        self.suspend_message_on_file_name_generation_error = suspend_message_on_file_name_generation_error
        self.autogenerate_file_name = autogenerate_file_name


class AS2ErrorSettings(msrest.serialization.Model):
    """The AS2 agreement error settings.

    All required parameters must be populated in order to send to Azure.

    :ivar suspend_duplicate_message: Required. The value indicating whether to suspend duplicate
     message.
    :vartype suspend_duplicate_message: bool
    :ivar resend_if_mdn_not_received: Required. The value indicating whether to resend message If
     MDN is not received.
    :vartype resend_if_mdn_not_received: bool
    """

    _validation = {
        'suspend_duplicate_message': {'required': True},
        'resend_if_mdn_not_received': {'required': True},
    }

    _attribute_map = {
        'suspend_duplicate_message': {'key': 'suspendDuplicateMessage', 'type': 'bool'},
        'resend_if_mdn_not_received': {'key': 'resendIfMDNNotReceived', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        suspend_duplicate_message: bool,
        resend_if_mdn_not_received: bool,
        **kwargs
    ):
        """
        :keyword suspend_duplicate_message: Required. The value indicating whether to suspend duplicate
         message.
        :paramtype suspend_duplicate_message: bool
        :keyword resend_if_mdn_not_received: Required. The value indicating whether to resend message
         If MDN is not received.
        :paramtype resend_if_mdn_not_received: bool
        """
        super(AS2ErrorSettings, self).__init__(**kwargs)
        self.suspend_duplicate_message = suspend_duplicate_message
        self.resend_if_mdn_not_received = resend_if_mdn_not_received


class AS2MdnSettings(msrest.serialization.Model):
    """The AS2 agreement mdn settings.

    All required parameters must be populated in order to send to Azure.

    :ivar need_mdn: Required. The value indicating whether to send or request a MDN.
    :vartype need_mdn: bool
    :ivar sign_mdn: Required. The value indicating whether the MDN needs to be signed or not.
    :vartype sign_mdn: bool
    :ivar send_mdn_asynchronously: Required. The value indicating whether to send the asynchronous
     MDN.
    :vartype send_mdn_asynchronously: bool
    :ivar receipt_delivery_url: The receipt delivery URL.
    :vartype receipt_delivery_url: str
    :ivar disposition_notification_to: The disposition notification to header value.
    :vartype disposition_notification_to: str
    :ivar sign_outbound_mdn_if_optional: Required. The value indicating whether to sign the
     outbound MDN if optional.
    :vartype sign_outbound_mdn_if_optional: bool
    :ivar mdn_text: The MDN text.
    :vartype mdn_text: str
    :ivar send_inbound_mdn_to_message_box: Required. The value indicating whether to send inbound
     MDN to message box.
    :vartype send_inbound_mdn_to_message_box: bool
    :ivar mic_hashing_algorithm: Required. The signing or hashing algorithm. Possible values
     include: "NotSpecified", "None", "MD5", "SHA1", "SHA2256", "SHA2384", "SHA2512".
    :vartype mic_hashing_algorithm: str or ~azure.mgmt.logic.models.HashingAlgorithm
    """

    _validation = {
        'need_mdn': {'required': True},
        'sign_mdn': {'required': True},
        'send_mdn_asynchronously': {'required': True},
        'sign_outbound_mdn_if_optional': {'required': True},
        'send_inbound_mdn_to_message_box': {'required': True},
        'mic_hashing_algorithm': {'required': True},
    }

    _attribute_map = {
        'need_mdn': {'key': 'needMDN', 'type': 'bool'},
        'sign_mdn': {'key': 'signMDN', 'type': 'bool'},
        'send_mdn_asynchronously': {'key': 'sendMDNAsynchronously', 'type': 'bool'},
        'receipt_delivery_url': {'key': 'receiptDeliveryUrl', 'type': 'str'},
        'disposition_notification_to': {'key': 'dispositionNotificationTo', 'type': 'str'},
        'sign_outbound_mdn_if_optional': {'key': 'signOutboundMDNIfOptional', 'type': 'bool'},
        'mdn_text': {'key': 'mdnText', 'type': 'str'},
        'send_inbound_mdn_to_message_box': {'key': 'sendInboundMDNToMessageBox', 'type': 'bool'},
        'mic_hashing_algorithm': {'key': 'micHashingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        need_mdn: bool,
        sign_mdn: bool,
        send_mdn_asynchronously: bool,
        sign_outbound_mdn_if_optional: bool,
        send_inbound_mdn_to_message_box: bool,
        mic_hashing_algorithm: Union[str, "HashingAlgorithm"],
        receipt_delivery_url: Optional[str] = None,
        disposition_notification_to: Optional[str] = None,
        mdn_text: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword need_mdn: Required. The value indicating whether to send or request a MDN.
        :paramtype need_mdn: bool
        :keyword sign_mdn: Required. The value indicating whether the MDN needs to be signed or not.
        :paramtype sign_mdn: bool
        :keyword send_mdn_asynchronously: Required. The value indicating whether to send the
         asynchronous MDN.
        :paramtype send_mdn_asynchronously: bool
        :keyword receipt_delivery_url: The receipt delivery URL.
        :paramtype receipt_delivery_url: str
        :keyword disposition_notification_to: The disposition notification to header value.
        :paramtype disposition_notification_to: str
        :keyword sign_outbound_mdn_if_optional: Required. The value indicating whether to sign the
         outbound MDN if optional.
        :paramtype sign_outbound_mdn_if_optional: bool
        :keyword mdn_text: The MDN text.
        :paramtype mdn_text: str
        :keyword send_inbound_mdn_to_message_box: Required. The value indicating whether to send
         inbound MDN to message box.
        :paramtype send_inbound_mdn_to_message_box: bool
        :keyword mic_hashing_algorithm: Required. The signing or hashing algorithm. Possible values
         include: "NotSpecified", "None", "MD5", "SHA1", "SHA2256", "SHA2384", "SHA2512".
        :paramtype mic_hashing_algorithm: str or ~azure.mgmt.logic.models.HashingAlgorithm
        """
        super(AS2MdnSettings, self).__init__(**kwargs)
        self.need_mdn = need_mdn
        self.sign_mdn = sign_mdn
        self.send_mdn_asynchronously = send_mdn_asynchronously
        self.receipt_delivery_url = receipt_delivery_url
        self.disposition_notification_to = disposition_notification_to
        self.sign_outbound_mdn_if_optional = sign_outbound_mdn_if_optional
        self.mdn_text = mdn_text
        self.send_inbound_mdn_to_message_box = send_inbound_mdn_to_message_box
        self.mic_hashing_algorithm = mic_hashing_algorithm


class AS2MessageConnectionSettings(msrest.serialization.Model):
    """The AS2 agreement message connection settings.

    All required parameters must be populated in order to send to Azure.

    :ivar ignore_certificate_name_mismatch: Required. The value indicating whether to ignore
     mismatch in certificate name.
    :vartype ignore_certificate_name_mismatch: bool
    :ivar support_http_status_code_continue: Required. The value indicating whether to support HTTP
     status code 'CONTINUE'.
    :vartype support_http_status_code_continue: bool
    :ivar keep_http_connection_alive: Required. The value indicating whether to keep the connection
     alive.
    :vartype keep_http_connection_alive: bool
    :ivar unfold_http_headers: Required. The value indicating whether to unfold the HTTP headers.
    :vartype unfold_http_headers: bool
    """

    _validation = {
        'ignore_certificate_name_mismatch': {'required': True},
        'support_http_status_code_continue': {'required': True},
        'keep_http_connection_alive': {'required': True},
        'unfold_http_headers': {'required': True},
    }

    _attribute_map = {
        'ignore_certificate_name_mismatch': {'key': 'ignoreCertificateNameMismatch', 'type': 'bool'},
        'support_http_status_code_continue': {'key': 'supportHttpStatusCodeContinue', 'type': 'bool'},
        'keep_http_connection_alive': {'key': 'keepHttpConnectionAlive', 'type': 'bool'},
        'unfold_http_headers': {'key': 'unfoldHttpHeaders', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        ignore_certificate_name_mismatch: bool,
        support_http_status_code_continue: bool,
        keep_http_connection_alive: bool,
        unfold_http_headers: bool,
        **kwargs
    ):
        """
        :keyword ignore_certificate_name_mismatch: Required. The value indicating whether to ignore
         mismatch in certificate name.
        :paramtype ignore_certificate_name_mismatch: bool
        :keyword support_http_status_code_continue: Required. The value indicating whether to support
         HTTP status code 'CONTINUE'.
        :paramtype support_http_status_code_continue: bool
        :keyword keep_http_connection_alive: Required. The value indicating whether to keep the
         connection alive.
        :paramtype keep_http_connection_alive: bool
        :keyword unfold_http_headers: Required. The value indicating whether to unfold the HTTP
         headers.
        :paramtype unfold_http_headers: bool
        """
        super(AS2MessageConnectionSettings, self).__init__(**kwargs)
        self.ignore_certificate_name_mismatch = ignore_certificate_name_mismatch
        self.support_http_status_code_continue = support_http_status_code_continue
        self.keep_http_connection_alive = keep_http_connection_alive
        self.unfold_http_headers = unfold_http_headers


class AS2OneWayAgreement(msrest.serialization.Model):
    """The integration account AS2 one-way agreement.

    All required parameters must be populated in order to send to Azure.

    :ivar sender_business_identity: Required. The sender business identity.
    :vartype sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :ivar receiver_business_identity: Required. The receiver business identity.
    :vartype receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :ivar protocol_settings: Required. The AS2 protocol settings.
    :vartype protocol_settings: ~azure.mgmt.logic.models.AS2ProtocolSettings
    """

    _validation = {
        'sender_business_identity': {'required': True},
        'receiver_business_identity': {'required': True},
        'protocol_settings': {'required': True},
    }

    _attribute_map = {
        'sender_business_identity': {'key': 'senderBusinessIdentity', 'type': 'BusinessIdentity'},
        'receiver_business_identity': {'key': 'receiverBusinessIdentity', 'type': 'BusinessIdentity'},
        'protocol_settings': {'key': 'protocolSettings', 'type': 'AS2ProtocolSettings'},
    }

    def __init__(
        self,
        *,
        sender_business_identity: "BusinessIdentity",
        receiver_business_identity: "BusinessIdentity",
        protocol_settings: "AS2ProtocolSettings",
        **kwargs
    ):
        """
        :keyword sender_business_identity: Required. The sender business identity.
        :paramtype sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
        :keyword receiver_business_identity: Required. The receiver business identity.
        :paramtype receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
        :keyword protocol_settings: Required. The AS2 protocol settings.
        :paramtype protocol_settings: ~azure.mgmt.logic.models.AS2ProtocolSettings
        """
        super(AS2OneWayAgreement, self).__init__(**kwargs)
        self.sender_business_identity = sender_business_identity
        self.receiver_business_identity = receiver_business_identity
        self.protocol_settings = protocol_settings


class AS2ProtocolSettings(msrest.serialization.Model):
    """The AS2 agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :ivar message_connection_settings: Required. The message connection settings.
    :vartype message_connection_settings: ~azure.mgmt.logic.models.AS2MessageConnectionSettings
    :ivar acknowledgement_connection_settings: Required. The acknowledgement connection settings.
    :vartype acknowledgement_connection_settings:
     ~azure.mgmt.logic.models.AS2AcknowledgementConnectionSettings
    :ivar mdn_settings: Required. The MDN settings.
    :vartype mdn_settings: ~azure.mgmt.logic.models.AS2MdnSettings
    :ivar security_settings: Required. The security settings.
    :vartype security_settings: ~azure.mgmt.logic.models.AS2SecuritySettings
    :ivar validation_settings: Required. The validation settings.
    :vartype validation_settings: ~azure.mgmt.logic.models.AS2ValidationSettings
    :ivar envelope_settings: Required. The envelope settings.
    :vartype envelope_settings: ~azure.mgmt.logic.models.AS2EnvelopeSettings
    :ivar error_settings: Required. The error settings.
    :vartype error_settings: ~azure.mgmt.logic.models.AS2ErrorSettings
    """

    _validation = {
        'message_connection_settings': {'required': True},
        'acknowledgement_connection_settings': {'required': True},
        'mdn_settings': {'required': True},
        'security_settings': {'required': True},
        'validation_settings': {'required': True},
        'envelope_settings': {'required': True},
        'error_settings': {'required': True},
    }

    _attribute_map = {
        'message_connection_settings': {'key': 'messageConnectionSettings', 'type': 'AS2MessageConnectionSettings'},
        'acknowledgement_connection_settings': {'key': 'acknowledgementConnectionSettings', 'type': 'AS2AcknowledgementConnectionSettings'},
        'mdn_settings': {'key': 'mdnSettings', 'type': 'AS2MdnSettings'},
        'security_settings': {'key': 'securitySettings', 'type': 'AS2SecuritySettings'},
        'validation_settings': {'key': 'validationSettings', 'type': 'AS2ValidationSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'AS2EnvelopeSettings'},
        'error_settings': {'key': 'errorSettings', 'type': 'AS2ErrorSettings'},
    }

    def __init__(
        self,
        *,
        message_connection_settings: "AS2MessageConnectionSettings",
        acknowledgement_connection_settings: "AS2AcknowledgementConnectionSettings",
        mdn_settings: "AS2MdnSettings",
        security_settings: "AS2SecuritySettings",
        validation_settings: "AS2ValidationSettings",
        envelope_settings: "AS2EnvelopeSettings",
        error_settings: "AS2ErrorSettings",
        **kwargs
    ):
        """
        :keyword message_connection_settings: Required. The message connection settings.
        :paramtype message_connection_settings: ~azure.mgmt.logic.models.AS2MessageConnectionSettings
        :keyword acknowledgement_connection_settings: Required. The acknowledgement connection
         settings.
        :paramtype acknowledgement_connection_settings:
         ~azure.mgmt.logic.models.AS2AcknowledgementConnectionSettings
        :keyword mdn_settings: Required. The MDN settings.
        :paramtype mdn_settings: ~azure.mgmt.logic.models.AS2MdnSettings
        :keyword security_settings: Required. The security settings.
        :paramtype security_settings: ~azure.mgmt.logic.models.AS2SecuritySettings
        :keyword validation_settings: Required. The validation settings.
        :paramtype validation_settings: ~azure.mgmt.logic.models.AS2ValidationSettings
        :keyword envelope_settings: Required. The envelope settings.
        :paramtype envelope_settings: ~azure.mgmt.logic.models.AS2EnvelopeSettings
        :keyword error_settings: Required. The error settings.
        :paramtype error_settings: ~azure.mgmt.logic.models.AS2ErrorSettings
        """
        super(AS2ProtocolSettings, self).__init__(**kwargs)
        self.message_connection_settings = message_connection_settings
        self.acknowledgement_connection_settings = acknowledgement_connection_settings
        self.mdn_settings = mdn_settings
        self.security_settings = security_settings
        self.validation_settings = validation_settings
        self.envelope_settings = envelope_settings
        self.error_settings = error_settings


class AS2SecuritySettings(msrest.serialization.Model):
    """The AS2 agreement security settings.

    All required parameters must be populated in order to send to Azure.

    :ivar override_group_signing_certificate: Required. The value indicating whether to send or
     request a MDN.
    :vartype override_group_signing_certificate: bool
    :ivar signing_certificate_name: The name of the signing certificate.
    :vartype signing_certificate_name: str
    :ivar encryption_certificate_name: The name of the encryption certificate.
    :vartype encryption_certificate_name: str
    :ivar enable_nrr_for_inbound_encoded_messages: Required. The value indicating whether to enable
     NRR for inbound encoded messages.
    :vartype enable_nrr_for_inbound_encoded_messages: bool
    :ivar enable_nrr_for_inbound_decoded_messages: Required. The value indicating whether to enable
     NRR for inbound decoded messages.
    :vartype enable_nrr_for_inbound_decoded_messages: bool
    :ivar enable_nrr_for_outbound_mdn: Required. The value indicating whether to enable NRR for
     outbound MDN.
    :vartype enable_nrr_for_outbound_mdn: bool
    :ivar enable_nrr_for_outbound_encoded_messages: Required. The value indicating whether to
     enable NRR for outbound encoded messages.
    :vartype enable_nrr_for_outbound_encoded_messages: bool
    :ivar enable_nrr_for_outbound_decoded_messages: Required. The value indicating whether to
     enable NRR for outbound decoded messages.
    :vartype enable_nrr_for_outbound_decoded_messages: bool
    :ivar enable_nrr_for_inbound_mdn: Required. The value indicating whether to enable NRR for
     inbound MDN.
    :vartype enable_nrr_for_inbound_mdn: bool
    :ivar sha2_algorithm_format: The Sha2 algorithm format. Valid values are Sha2, ShaHashSize,
     ShaHyphenHashSize, Sha2UnderscoreHashSize.
    :vartype sha2_algorithm_format: str
    """

    _validation = {
        'override_group_signing_certificate': {'required': True},
        'enable_nrr_for_inbound_encoded_messages': {'required': True},
        'enable_nrr_for_inbound_decoded_messages': {'required': True},
        'enable_nrr_for_outbound_mdn': {'required': True},
        'enable_nrr_for_outbound_encoded_messages': {'required': True},
        'enable_nrr_for_outbound_decoded_messages': {'required': True},
        'enable_nrr_for_inbound_mdn': {'required': True},
    }

    _attribute_map = {
        'override_group_signing_certificate': {'key': 'overrideGroupSigningCertificate', 'type': 'bool'},
        'signing_certificate_name': {'key': 'signingCertificateName', 'type': 'str'},
        'encryption_certificate_name': {'key': 'encryptionCertificateName', 'type': 'str'},
        'enable_nrr_for_inbound_encoded_messages': {'key': 'enableNRRForInboundEncodedMessages', 'type': 'bool'},
        'enable_nrr_for_inbound_decoded_messages': {'key': 'enableNRRForInboundDecodedMessages', 'type': 'bool'},
        'enable_nrr_for_outbound_mdn': {'key': 'enableNRRForOutboundMDN', 'type': 'bool'},
        'enable_nrr_for_outbound_encoded_messages': {'key': 'enableNRRForOutboundEncodedMessages', 'type': 'bool'},
        'enable_nrr_for_outbound_decoded_messages': {'key': 'enableNRRForOutboundDecodedMessages', 'type': 'bool'},
        'enable_nrr_for_inbound_mdn': {'key': 'enableNRRForInboundMDN', 'type': 'bool'},
        'sha2_algorithm_format': {'key': 'sha2AlgorithmFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        override_group_signing_certificate: bool,
        enable_nrr_for_inbound_encoded_messages: bool,
        enable_nrr_for_inbound_decoded_messages: bool,
        enable_nrr_for_outbound_mdn: bool,
        enable_nrr_for_outbound_encoded_messages: bool,
        enable_nrr_for_outbound_decoded_messages: bool,
        enable_nrr_for_inbound_mdn: bool,
        signing_certificate_name: Optional[str] = None,
        encryption_certificate_name: Optional[str] = None,
        sha2_algorithm_format: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword override_group_signing_certificate: Required. The value indicating whether to send or
         request a MDN.
        :paramtype override_group_signing_certificate: bool
        :keyword signing_certificate_name: The name of the signing certificate.
        :paramtype signing_certificate_name: str
        :keyword encryption_certificate_name: The name of the encryption certificate.
        :paramtype encryption_certificate_name: str
        :keyword enable_nrr_for_inbound_encoded_messages: Required. The value indicating whether to
         enable NRR for inbound encoded messages.
        :paramtype enable_nrr_for_inbound_encoded_messages: bool
        :keyword enable_nrr_for_inbound_decoded_messages: Required. The value indicating whether to
         enable NRR for inbound decoded messages.
        :paramtype enable_nrr_for_inbound_decoded_messages: bool
        :keyword enable_nrr_for_outbound_mdn: Required. The value indicating whether to enable NRR for
         outbound MDN.
        :paramtype enable_nrr_for_outbound_mdn: bool
        :keyword enable_nrr_for_outbound_encoded_messages: Required. The value indicating whether to
         enable NRR for outbound encoded messages.
        :paramtype enable_nrr_for_outbound_encoded_messages: bool
        :keyword enable_nrr_for_outbound_decoded_messages: Required. The value indicating whether to
         enable NRR for outbound decoded messages.
        :paramtype enable_nrr_for_outbound_decoded_messages: bool
        :keyword enable_nrr_for_inbound_mdn: Required. The value indicating whether to enable NRR for
         inbound MDN.
        :paramtype enable_nrr_for_inbound_mdn: bool
        :keyword sha2_algorithm_format: The Sha2 algorithm format. Valid values are Sha2, ShaHashSize,
         ShaHyphenHashSize, Sha2UnderscoreHashSize.
        :paramtype sha2_algorithm_format: str
        """
        super(AS2SecuritySettings, self).__init__(**kwargs)
        self.override_group_signing_certificate = override_group_signing_certificate
        self.signing_certificate_name = signing_certificate_name
        self.encryption_certificate_name = encryption_certificate_name
        self.enable_nrr_for_inbound_encoded_messages = enable_nrr_for_inbound_encoded_messages
        self.enable_nrr_for_inbound_decoded_messages = enable_nrr_for_inbound_decoded_messages
        self.enable_nrr_for_outbound_mdn = enable_nrr_for_outbound_mdn
        self.enable_nrr_for_outbound_encoded_messages = enable_nrr_for_outbound_encoded_messages
        self.enable_nrr_for_outbound_decoded_messages = enable_nrr_for_outbound_decoded_messages
        self.enable_nrr_for_inbound_mdn = enable_nrr_for_inbound_mdn
        self.sha2_algorithm_format = sha2_algorithm_format


class AS2ValidationSettings(msrest.serialization.Model):
    """The AS2 agreement validation settings.

    All required parameters must be populated in order to send to Azure.

    :ivar override_message_properties: Required. The value indicating whether to override incoming
     message properties with those in agreement.
    :vartype override_message_properties: bool
    :ivar encrypt_message: Required. The value indicating whether the message has to be encrypted.
    :vartype encrypt_message: bool
    :ivar sign_message: Required. The value indicating whether the message has to be signed.
    :vartype sign_message: bool
    :ivar compress_message: Required. The value indicating whether the message has to be
     compressed.
    :vartype compress_message: bool
    :ivar check_duplicate_message: Required. The value indicating whether to check for duplicate
     message.
    :vartype check_duplicate_message: bool
    :ivar interchange_duplicates_validity_days: Required. The number of days to look back for
     duplicate interchange.
    :vartype interchange_duplicates_validity_days: int
    :ivar check_certificate_revocation_list_on_send: Required. The value indicating whether to
     check for certificate revocation list on send.
    :vartype check_certificate_revocation_list_on_send: bool
    :ivar check_certificate_revocation_list_on_receive: Required. The value indicating whether to
     check for certificate revocation list on receive.
    :vartype check_certificate_revocation_list_on_receive: bool
    :ivar encryption_algorithm: Required. The encryption algorithm. Possible values include:
     "NotSpecified", "None", "DES3", "RC2", "AES128", "AES192", "AES256".
    :vartype encryption_algorithm: str or ~azure.mgmt.logic.models.EncryptionAlgorithm
    :ivar signing_algorithm: The signing algorithm. Possible values include: "NotSpecified",
     "Default", "SHA1", "SHA2256", "SHA2384", "SHA2512".
    :vartype signing_algorithm: str or ~azure.mgmt.logic.models.SigningAlgorithm
    """

    _validation = {
        'override_message_properties': {'required': True},
        'encrypt_message': {'required': True},
        'sign_message': {'required': True},
        'compress_message': {'required': True},
        'check_duplicate_message': {'required': True},
        'interchange_duplicates_validity_days': {'required': True},
        'check_certificate_revocation_list_on_send': {'required': True},
        'check_certificate_revocation_list_on_receive': {'required': True},
        'encryption_algorithm': {'required': True},
    }

    _attribute_map = {
        'override_message_properties': {'key': 'overrideMessageProperties', 'type': 'bool'},
        'encrypt_message': {'key': 'encryptMessage', 'type': 'bool'},
        'sign_message': {'key': 'signMessage', 'type': 'bool'},
        'compress_message': {'key': 'compressMessage', 'type': 'bool'},
        'check_duplicate_message': {'key': 'checkDuplicateMessage', 'type': 'bool'},
        'interchange_duplicates_validity_days': {'key': 'interchangeDuplicatesValidityDays', 'type': 'int'},
        'check_certificate_revocation_list_on_send': {'key': 'checkCertificateRevocationListOnSend', 'type': 'bool'},
        'check_certificate_revocation_list_on_receive': {'key': 'checkCertificateRevocationListOnReceive', 'type': 'bool'},
        'encryption_algorithm': {'key': 'encryptionAlgorithm', 'type': 'str'},
        'signing_algorithm': {'key': 'signingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        override_message_properties: bool,
        encrypt_message: bool,
        sign_message: bool,
        compress_message: bool,
        check_duplicate_message: bool,
        interchange_duplicates_validity_days: int,
        check_certificate_revocation_list_on_send: bool,
        check_certificate_revocation_list_on_receive: bool,
        encryption_algorithm: Union[str, "EncryptionAlgorithm"],
        signing_algorithm: Optional[Union[str, "SigningAlgorithm"]] = None,
        **kwargs
    ):
        """
        :keyword override_message_properties: Required. The value indicating whether to override
         incoming message properties with those in agreement.
        :paramtype override_message_properties: bool
        :keyword encrypt_message: Required. The value indicating whether the message has to be
         encrypted.
        :paramtype encrypt_message: bool
        :keyword sign_message: Required. The value indicating whether the message has to be signed.
        :paramtype sign_message: bool
        :keyword compress_message: Required. The value indicating whether the message has to be
         compressed.
        :paramtype compress_message: bool
        :keyword check_duplicate_message: Required. The value indicating whether to check for duplicate
         message.
        :paramtype check_duplicate_message: bool
        :keyword interchange_duplicates_validity_days: Required. The number of days to look back for
         duplicate interchange.
        :paramtype interchange_duplicates_validity_days: int
        :keyword check_certificate_revocation_list_on_send: Required. The value indicating whether to
         check for certificate revocation list on send.
        :paramtype check_certificate_revocation_list_on_send: bool
        :keyword check_certificate_revocation_list_on_receive: Required. The value indicating whether
         to check for certificate revocation list on receive.
        :paramtype check_certificate_revocation_list_on_receive: bool
        :keyword encryption_algorithm: Required. The encryption algorithm. Possible values include:
         "NotSpecified", "None", "DES3", "RC2", "AES128", "AES192", "AES256".
        :paramtype encryption_algorithm: str or ~azure.mgmt.logic.models.EncryptionAlgorithm
        :keyword signing_algorithm: The signing algorithm. Possible values include: "NotSpecified",
         "Default", "SHA1", "SHA2256", "SHA2384", "SHA2512".
        :paramtype signing_algorithm: str or ~azure.mgmt.logic.models.SigningAlgorithm
        """
        super(AS2ValidationSettings, self).__init__(**kwargs)
        self.override_message_properties = override_message_properties
        self.encrypt_message = encrypt_message
        self.sign_message = sign_message
        self.compress_message = compress_message
        self.check_duplicate_message = check_duplicate_message
        self.interchange_duplicates_validity_days = interchange_duplicates_validity_days
        self.check_certificate_revocation_list_on_send = check_certificate_revocation_list_on_send
        self.check_certificate_revocation_list_on_receive = check_certificate_revocation_list_on_receive
        self.encryption_algorithm = encryption_algorithm
        self.signing_algorithm = signing_algorithm


class AssemblyCollection(msrest.serialization.Model):
    """A collection of assembly definitions.

    :ivar value:
    :vartype value: list[~azure.mgmt.logic.models.AssemblyDefinition]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AssemblyDefinition]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AssemblyDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.logic.models.AssemblyDefinition]
        """
        super(AssemblyCollection, self).__init__(**kwargs)
        self.value = value


class AssemblyDefinition(Resource):
    """The assembly definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Required. The assembly properties.
    :vartype properties: ~azure.mgmt.logic.models.AssemblyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'AssemblyProperties'},
    }

    def __init__(
        self,
        *,
        properties: "AssemblyProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Required. The assembly properties.
        :paramtype properties: ~azure.mgmt.logic.models.AssemblyProperties
        """
        super(AssemblyDefinition, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class AssemblyProperties(ArtifactContentPropertiesDefinition):
    """The assembly properties definition.

    All required parameters must be populated in order to send to Azure.

    :ivar created_time: The artifact creation time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The artifact changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar metadata: Anything.
    :vartype metadata: any
    :ivar content: Anything.
    :vartype content: any
    :ivar content_type: The content type.
    :vartype content_type: str
    :ivar content_link: The content link.
    :vartype content_link: ~azure.mgmt.logic.models.ContentLink
    :ivar assembly_name: Required. The assembly name.
    :vartype assembly_name: str
    :ivar assembly_version: The assembly version.
    :vartype assembly_version: str
    :ivar assembly_culture: The assembly culture.
    :vartype assembly_culture: str
    :ivar assembly_public_key_token: The assembly public key token.
    :vartype assembly_public_key_token: str
    """

    _validation = {
        'assembly_name': {'required': True},
    }

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'content': {'key': 'content', 'type': 'object'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'ContentLink'},
        'assembly_name': {'key': 'assemblyName', 'type': 'str'},
        'assembly_version': {'key': 'assemblyVersion', 'type': 'str'},
        'assembly_culture': {'key': 'assemblyCulture', 'type': 'str'},
        'assembly_public_key_token': {'key': 'assemblyPublicKeyToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        assembly_name: str,
        created_time: Optional[datetime.datetime] = None,
        changed_time: Optional[datetime.datetime] = None,
        metadata: Optional[Any] = None,
        content: Optional[Any] = None,
        content_type: Optional[str] = None,
        content_link: Optional["ContentLink"] = None,
        assembly_version: Optional[str] = None,
        assembly_culture: Optional[str] = None,
        assembly_public_key_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword created_time: The artifact creation time.
        :paramtype created_time: ~datetime.datetime
        :keyword changed_time: The artifact changed time.
        :paramtype changed_time: ~datetime.datetime
        :keyword metadata: Anything.
        :paramtype metadata: any
        :keyword content: Anything.
        :paramtype content: any
        :keyword content_type: The content type.
        :paramtype content_type: str
        :keyword content_link: The content link.
        :paramtype content_link: ~azure.mgmt.logic.models.ContentLink
        :keyword assembly_name: Required. The assembly name.
        :paramtype assembly_name: str
        :keyword assembly_version: The assembly version.
        :paramtype assembly_version: str
        :keyword assembly_culture: The assembly culture.
        :paramtype assembly_culture: str
        :keyword assembly_public_key_token: The assembly public key token.
        :paramtype assembly_public_key_token: str
        """
        super(AssemblyProperties, self).__init__(created_time=created_time, changed_time=changed_time, metadata=metadata, content=content, content_type=content_type, content_link=content_link, **kwargs)
        self.assembly_name = assembly_name
        self.assembly_version = assembly_version
        self.assembly_culture = assembly_culture
        self.assembly_public_key_token = assembly_public_key_token


class ErrorInfo(msrest.serialization.Model):
    """The error info.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. The error code.
    :vartype code: str
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        **kwargs
    ):
        """
        :keyword code: Required. The error code.
        :paramtype code: str
        """
        super(ErrorInfo, self).__init__(**kwargs)
        self.code = code


class AzureResourceErrorInfo(ErrorInfo):
    """The azure resource error info.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. The error code.
    :vartype code: str
    :ivar message: Required. The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.logic.models.AzureResourceErrorInfo]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[AzureResourceErrorInfo]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["AzureResourceErrorInfo"]] = None,
        **kwargs
    ):
        """
        :keyword code: Required. The error code.
        :paramtype code: str
        :keyword message: Required. The error message.
        :paramtype message: str
        :keyword details: The error details.
        :paramtype details: list[~azure.mgmt.logic.models.AzureResourceErrorInfo]
        """
        super(AzureResourceErrorInfo, self).__init__(code=code, **kwargs)
        self.message = message
        self.details = details


class B2BPartnerContent(msrest.serialization.Model):
    """The B2B partner content.

    :ivar business_identities: The list of partner business identities.
    :vartype business_identities: list[~azure.mgmt.logic.models.BusinessIdentity]
    """

    _attribute_map = {
        'business_identities': {'key': 'businessIdentities', 'type': '[BusinessIdentity]'},
    }

    def __init__(
        self,
        *,
        business_identities: Optional[List["BusinessIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword business_identities: The list of partner business identities.
        :paramtype business_identities: list[~azure.mgmt.logic.models.BusinessIdentity]
        """
        super(B2BPartnerContent, self).__init__(**kwargs)
        self.business_identities = business_identities


class BatchConfiguration(Resource):
    """The batch configuration resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Required. The batch configuration properties.
    :vartype properties: ~azure.mgmt.logic.models.BatchConfigurationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'BatchConfigurationProperties'},
    }

    def __init__(
        self,
        *,
        properties: "BatchConfigurationProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Required. The batch configuration properties.
        :paramtype properties: ~azure.mgmt.logic.models.BatchConfigurationProperties
        """
        super(BatchConfiguration, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class BatchConfigurationCollection(msrest.serialization.Model):
    """A collection of batch configurations.

    :ivar value:
    :vartype value: list[~azure.mgmt.logic.models.BatchConfiguration]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BatchConfiguration]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BatchConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.logic.models.BatchConfiguration]
        """
        super(BatchConfigurationCollection, self).__init__(**kwargs)
        self.value = value


class BatchConfigurationProperties(ArtifactProperties):
    """The batch configuration properties definition.

    All required parameters must be populated in order to send to Azure.

    :ivar created_time: The artifact creation time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The artifact changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar metadata: Anything.
    :vartype metadata: any
    :ivar batch_group_name: Required. The name of the batch group.
    :vartype batch_group_name: str
    :ivar release_criteria: Required. The batch release criteria.
    :vartype release_criteria: ~azure.mgmt.logic.models.BatchReleaseCriteria
    """

    _validation = {
        'batch_group_name': {'required': True},
        'release_criteria': {'required': True},
    }

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'batch_group_name': {'key': 'batchGroupName', 'type': 'str'},
        'release_criteria': {'key': 'releaseCriteria', 'type': 'BatchReleaseCriteria'},
    }

    def __init__(
        self,
        *,
        batch_group_name: str,
        release_criteria: "BatchReleaseCriteria",
        created_time: Optional[datetime.datetime] = None,
        changed_time: Optional[datetime.datetime] = None,
        metadata: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword created_time: The artifact creation time.
        :paramtype created_time: ~datetime.datetime
        :keyword changed_time: The artifact changed time.
        :paramtype changed_time: ~datetime.datetime
        :keyword metadata: Anything.
        :paramtype metadata: any
        :keyword batch_group_name: Required. The name of the batch group.
        :paramtype batch_group_name: str
        :keyword release_criteria: Required. The batch release criteria.
        :paramtype release_criteria: ~azure.mgmt.logic.models.BatchReleaseCriteria
        """
        super(BatchConfigurationProperties, self).__init__(created_time=created_time, changed_time=changed_time, metadata=metadata, **kwargs)
        self.batch_group_name = batch_group_name
        self.release_criteria = release_criteria


class BatchReleaseCriteria(msrest.serialization.Model):
    """The batch release criteria.

    :ivar message_count: The message count.
    :vartype message_count: int
    :ivar batch_size: The batch size in bytes.
    :vartype batch_size: int
    :ivar recurrence: The recurrence.
    :vartype recurrence: ~azure.mgmt.logic.models.WorkflowTriggerRecurrence
    """

    _attribute_map = {
        'message_count': {'key': 'messageCount', 'type': 'int'},
        'batch_size': {'key': 'batchSize', 'type': 'int'},
        'recurrence': {'key': 'recurrence', 'type': 'WorkflowTriggerRecurrence'},
    }

    def __init__(
        self,
        *,
        message_count: Optional[int] = None,
        batch_size: Optional[int] = None,
        recurrence: Optional["WorkflowTriggerRecurrence"] = None,
        **kwargs
    ):
        """
        :keyword message_count: The message count.
        :paramtype message_count: int
        :keyword batch_size: The batch size in bytes.
        :paramtype batch_size: int
        :keyword recurrence: The recurrence.
        :paramtype recurrence: ~azure.mgmt.logic.models.WorkflowTriggerRecurrence
        """
        super(BatchReleaseCriteria, self).__init__(**kwargs)
        self.message_count = message_count
        self.batch_size = batch_size
        self.recurrence = recurrence


class BusinessIdentity(msrest.serialization.Model):
    """The integration account partner's business identity.

    All required parameters must be populated in order to send to Azure.

    :ivar qualifier: Required. The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32.
    :vartype qualifier: str
    :ivar value: Required. The user defined business identity value.
    :vartype value: str
    """

    _validation = {
        'qualifier': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'qualifier': {'key': 'qualifier', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        qualifier: str,
        value: str,
        **kwargs
    ):
        """
        :keyword qualifier: Required. The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31,
         32.
        :paramtype qualifier: str
        :keyword value: Required. The user defined business identity value.
        :paramtype value: str
        """
        super(BusinessIdentity, self).__init__(**kwargs)
        self.qualifier = qualifier
        self.value = value


class CallbackUrl(msrest.serialization.Model):
    """The callback url.

    :ivar value: The URL value.
    :vartype value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The URL value.
        :paramtype value: str
        """
        super(CallbackUrl, self).__init__(**kwargs)
        self.value = value


class ContentHash(msrest.serialization.Model):
    """The content hash.

    :ivar algorithm: The algorithm of the content hash.
    :vartype algorithm: str
    :ivar value: The value of the content hash.
    :vartype value: str
    """

    _attribute_map = {
        'algorithm': {'key': 'algorithm', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        algorithm: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword algorithm: The algorithm of the content hash.
        :paramtype algorithm: str
        :keyword value: The value of the content hash.
        :paramtype value: str
        """
        super(ContentHash, self).__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class ContentLink(msrest.serialization.Model):
    """The content link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar uri: The content link URI.
    :vartype uri: str
    :ivar content_version: The content version.
    :vartype content_version: str
    :ivar content_size: The content size.
    :vartype content_size: long
    :ivar content_hash: The content hash.
    :vartype content_hash: ~azure.mgmt.logic.models.ContentHash
    :ivar metadata: The metadata.
    :vartype metadata: any
    """

    _validation = {
        'content_version': {'readonly': True},
        'content_size': {'readonly': True},
        'content_hash': {'readonly': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
        'content_size': {'key': 'contentSize', 'type': 'long'},
        'content_hash': {'key': 'contentHash', 'type': 'ContentHash'},
        'metadata': {'key': 'metadata', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword uri: The content link URI.
        :paramtype uri: str
        """
        super(ContentLink, self).__init__(**kwargs)
        self.uri = uri
        self.content_version = None
        self.content_size = None
        self.content_hash = None
        self.metadata = None


class Correlation(msrest.serialization.Model):
    """The correlation property.

    :ivar client_tracking_id: The client tracking id.
    :vartype client_tracking_id: str
    """

    _attribute_map = {
        'client_tracking_id': {'key': 'clientTrackingId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_tracking_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_tracking_id: The client tracking id.
        :paramtype client_tracking_id: str
        """
        super(Correlation, self).__init__(**kwargs)
        self.client_tracking_id = client_tracking_id


class EdifactAcknowledgementSettings(msrest.serialization.Model):
    """The Edifact agreement acknowledgement settings.

    All required parameters must be populated in order to send to Azure.

    :ivar need_technical_acknowledgement: Required. The value indicating whether technical
     acknowledgement is needed.
    :vartype need_technical_acknowledgement: bool
    :ivar batch_technical_acknowledgements: Required. The value indicating whether to batch the
     technical acknowledgements.
    :vartype batch_technical_acknowledgements: bool
    :ivar need_functional_acknowledgement: Required. The value indicating whether functional
     acknowledgement is needed.
    :vartype need_functional_acknowledgement: bool
    :ivar batch_functional_acknowledgements: Required. The value indicating whether to batch
     functional acknowledgements.
    :vartype batch_functional_acknowledgements: bool
    :ivar need_loop_for_valid_messages: Required. The value indicating whether a loop is needed for
     valid messages.
    :vartype need_loop_for_valid_messages: bool
    :ivar send_synchronous_acknowledgement: Required. The value indicating whether to send
     synchronous acknowledgement.
    :vartype send_synchronous_acknowledgement: bool
    :ivar acknowledgement_control_number_prefix: The acknowledgement control number prefix.
    :vartype acknowledgement_control_number_prefix: str
    :ivar acknowledgement_control_number_suffix: The acknowledgement control number suffix.
    :vartype acknowledgement_control_number_suffix: str
    :ivar acknowledgement_control_number_lower_bound: Required. The acknowledgement control number
     lower bound.
    :vartype acknowledgement_control_number_lower_bound: int
    :ivar acknowledgement_control_number_upper_bound: Required. The acknowledgement control number
     upper bound.
    :vartype acknowledgement_control_number_upper_bound: int
    :ivar rollover_acknowledgement_control_number: Required. The value indicating whether to
     rollover acknowledgement control number.
    :vartype rollover_acknowledgement_control_number: bool
    """

    _validation = {
        'need_technical_acknowledgement': {'required': True},
        'batch_technical_acknowledgements': {'required': True},
        'need_functional_acknowledgement': {'required': True},
        'batch_functional_acknowledgements': {'required': True},
        'need_loop_for_valid_messages': {'required': True},
        'send_synchronous_acknowledgement': {'required': True},
        'acknowledgement_control_number_lower_bound': {'required': True},
        'acknowledgement_control_number_upper_bound': {'required': True},
        'rollover_acknowledgement_control_number': {'required': True},
    }

    _attribute_map = {
        'need_technical_acknowledgement': {'key': 'needTechnicalAcknowledgement', 'type': 'bool'},
        'batch_technical_acknowledgements': {'key': 'batchTechnicalAcknowledgements', 'type': 'bool'},
        'need_functional_acknowledgement': {'key': 'needFunctionalAcknowledgement', 'type': 'bool'},
        'batch_functional_acknowledgements': {'key': 'batchFunctionalAcknowledgements', 'type': 'bool'},
        'need_loop_for_valid_messages': {'key': 'needLoopForValidMessages', 'type': 'bool'},
        'send_synchronous_acknowledgement': {'key': 'sendSynchronousAcknowledgement', 'type': 'bool'},
        'acknowledgement_control_number_prefix': {'key': 'acknowledgementControlNumberPrefix', 'type': 'str'},
        'acknowledgement_control_number_suffix': {'key': 'acknowledgementControlNumberSuffix', 'type': 'str'},
        'acknowledgement_control_number_lower_bound': {'key': 'acknowledgementControlNumberLowerBound', 'type': 'int'},
        'acknowledgement_control_number_upper_bound': {'key': 'acknowledgementControlNumberUpperBound', 'type': 'int'},
        'rollover_acknowledgement_control_number': {'key': 'rolloverAcknowledgementControlNumber', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        need_technical_acknowledgement: bool,
        batch_technical_acknowledgements: bool,
        need_functional_acknowledgement: bool,
        batch_functional_acknowledgements: bool,
        need_loop_for_valid_messages: bool,
        send_synchronous_acknowledgement: bool,
        acknowledgement_control_number_lower_bound: int,
        acknowledgement_control_number_upper_bound: int,
        rollover_acknowledgement_control_number: bool,
        acknowledgement_control_number_prefix: Optional[str] = None,
        acknowledgement_control_number_suffix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword need_technical_acknowledgement: Required. The value indicating whether technical
         acknowledgement is needed.
        :paramtype need_technical_acknowledgement: bool
        :keyword batch_technical_acknowledgements: Required. The value indicating whether to batch the
         technical acknowledgements.
        :paramtype batch_technical_acknowledgements: bool
        :keyword need_functional_acknowledgement: Required. The value indicating whether functional
         acknowledgement is needed.
        :paramtype need_functional_acknowledgement: bool
        :keyword batch_functional_acknowledgements: Required. The value indicating whether to batch
         functional acknowledgements.
        :paramtype batch_functional_acknowledgements: bool
        :keyword need_loop_for_valid_messages: Required. The value indicating whether a loop is needed
         for valid messages.
        :paramtype need_loop_for_valid_messages: bool
        :keyword send_synchronous_acknowledgement: Required. The value indicating whether to send
         synchronous acknowledgement.
        :paramtype send_synchronous_acknowledgement: bool
        :keyword acknowledgement_control_number_prefix: The acknowledgement control number prefix.
        :paramtype acknowledgement_control_number_prefix: str
        :keyword acknowledgement_control_number_suffix: The acknowledgement control number suffix.
        :paramtype acknowledgement_control_number_suffix: str
        :keyword acknowledgement_control_number_lower_bound: Required. The acknowledgement control
         number lower bound.
        :paramtype acknowledgement_control_number_lower_bound: int
        :keyword acknowledgement_control_number_upper_bound: Required. The acknowledgement control
         number upper bound.
        :paramtype acknowledgement_control_number_upper_bound: int
        :keyword rollover_acknowledgement_control_number: Required. The value indicating whether to
         rollover acknowledgement control number.
        :paramtype rollover_acknowledgement_control_number: bool
        """
        super(EdifactAcknowledgementSettings, self).__init__(**kwargs)
        self.need_technical_acknowledgement = need_technical_acknowledgement
        self.batch_technical_acknowledgements = batch_technical_acknowledgements
        self.need_functional_acknowledgement = need_functional_acknowledgement
        self.batch_functional_acknowledgements = batch_functional_acknowledgements
        self.need_loop_for_valid_messages = need_loop_for_valid_messages
        self.send_synchronous_acknowledgement = send_synchronous_acknowledgement
        self.acknowledgement_control_number_prefix = acknowledgement_control_number_prefix
        self.acknowledgement_control_number_suffix = acknowledgement_control_number_suffix
        self.acknowledgement_control_number_lower_bound = acknowledgement_control_number_lower_bound
        self.acknowledgement_control_number_upper_bound = acknowledgement_control_number_upper_bound
        self.rollover_acknowledgement_control_number = rollover_acknowledgement_control_number


class EdifactAgreementContent(msrest.serialization.Model):
    """The Edifact agreement content.

    All required parameters must be populated in order to send to Azure.

    :ivar receive_agreement: Required. The EDIFACT one-way receive agreement.
    :vartype receive_agreement: ~azure.mgmt.logic.models.EdifactOneWayAgreement
    :ivar send_agreement: Required. The EDIFACT one-way send agreement.
    :vartype send_agreement: ~azure.mgmt.logic.models.EdifactOneWayAgreement
    """

    _validation = {
        'receive_agreement': {'required': True},
        'send_agreement': {'required': True},
    }

    _attribute_map = {
        'receive_agreement': {'key': 'receiveAgreement', 'type': 'EdifactOneWayAgreement'},
        'send_agreement': {'key': 'sendAgreement', 'type': 'EdifactOneWayAgreement'},
    }

    def __init__(
        self,
        *,
        receive_agreement: "EdifactOneWayAgreement",
        send_agreement: "EdifactOneWayAgreement",
        **kwargs
    ):
        """
        :keyword receive_agreement: Required. The EDIFACT one-way receive agreement.
        :paramtype receive_agreement: ~azure.mgmt.logic.models.EdifactOneWayAgreement
        :keyword send_agreement: Required. The EDIFACT one-way send agreement.
        :paramtype send_agreement: ~azure.mgmt.logic.models.EdifactOneWayAgreement
        """
        super(EdifactAgreementContent, self).__init__(**kwargs)
        self.receive_agreement = receive_agreement
        self.send_agreement = send_agreement


class EdifactDelimiterOverride(msrest.serialization.Model):
    """The Edifact delimiter override settings.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: The message id.
    :vartype message_id: str
    :ivar message_version: The message version.
    :vartype message_version: str
    :ivar message_release: The message release.
    :vartype message_release: str
    :ivar data_element_separator: Required. The data element separator.
    :vartype data_element_separator: int
    :ivar component_separator: Required. The component separator.
    :vartype component_separator: int
    :ivar segment_terminator: Required. The segment terminator.
    :vartype segment_terminator: int
    :ivar repetition_separator: Required. The repetition separator.
    :vartype repetition_separator: int
    :ivar segment_terminator_suffix: Required. The segment terminator suffix. Possible values
     include: "NotSpecified", "None", "CR", "LF", "CRLF".
    :vartype segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    :ivar decimal_point_indicator: Required. The decimal point indicator. Possible values include:
     "NotSpecified", "Comma", "Decimal".
    :vartype decimal_point_indicator: str or ~azure.mgmt.logic.models.EdifactDecimalIndicator
    :ivar release_indicator: Required. The release indicator.
    :vartype release_indicator: int
    :ivar message_association_assigned_code: The message association assigned code.
    :vartype message_association_assigned_code: str
    :ivar target_namespace: The target namespace on which this delimiter settings has to be
     applied.
    :vartype target_namespace: str
    """

    _validation = {
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'segment_terminator': {'required': True},
        'repetition_separator': {'required': True},
        'segment_terminator_suffix': {'required': True},
        'decimal_point_indicator': {'required': True},
        'release_indicator': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'message_version': {'key': 'messageVersion', 'type': 'str'},
        'message_release': {'key': 'messageRelease', 'type': 'str'},
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'repetition_separator': {'key': 'repetitionSeparator', 'type': 'int'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'str'},
        'decimal_point_indicator': {'key': 'decimalPointIndicator', 'type': 'str'},
        'release_indicator': {'key': 'releaseIndicator', 'type': 'int'},
        'message_association_assigned_code': {'key': 'messageAssociationAssignedCode', 'type': 'str'},
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_element_separator: int,
        component_separator: int,
        segment_terminator: int,
        repetition_separator: int,
        segment_terminator_suffix: Union[str, "SegmentTerminatorSuffix"],
        decimal_point_indicator: Union[str, "EdifactDecimalIndicator"],
        release_indicator: int,
        message_id: Optional[str] = None,
        message_version: Optional[str] = None,
        message_release: Optional[str] = None,
        message_association_assigned_code: Optional[str] = None,
        target_namespace: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message_id: The message id.
        :paramtype message_id: str
        :keyword message_version: The message version.
        :paramtype message_version: str
        :keyword message_release: The message release.
        :paramtype message_release: str
        :keyword data_element_separator: Required. The data element separator.
        :paramtype data_element_separator: int
        :keyword component_separator: Required. The component separator.
        :paramtype component_separator: int
        :keyword segment_terminator: Required. The segment terminator.
        :paramtype segment_terminator: int
        :keyword repetition_separator: Required. The repetition separator.
        :paramtype repetition_separator: int
        :keyword segment_terminator_suffix: Required. The segment terminator suffix. Possible values
         include: "NotSpecified", "None", "CR", "LF", "CRLF".
        :paramtype segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
        :keyword decimal_point_indicator: Required. The decimal point indicator. Possible values
         include: "NotSpecified", "Comma", "Decimal".
        :paramtype decimal_point_indicator: str or ~azure.mgmt.logic.models.EdifactDecimalIndicator
        :keyword release_indicator: Required. The release indicator.
        :paramtype release_indicator: int
        :keyword message_association_assigned_code: The message association assigned code.
        :paramtype message_association_assigned_code: str
        :keyword target_namespace: The target namespace on which this delimiter settings has to be
         applied.
        :paramtype target_namespace: str
        """
        super(EdifactDelimiterOverride, self).__init__(**kwargs)
        self.message_id = message_id
        self.message_version = message_version
        self.message_release = message_release
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.segment_terminator = segment_terminator
        self.repetition_separator = repetition_separator
        self.segment_terminator_suffix = segment_terminator_suffix
        self.decimal_point_indicator = decimal_point_indicator
        self.release_indicator = release_indicator
        self.message_association_assigned_code = message_association_assigned_code
        self.target_namespace = target_namespace


class EdifactEnvelopeOverride(msrest.serialization.Model):
    """The Edifact envelope override settings.

    :ivar message_id: The message id on which this envelope settings has to be applied.
    :vartype message_id: str
    :ivar message_version: The message version on which this envelope settings has to be applied.
    :vartype message_version: str
    :ivar message_release: The message release version on which this envelope settings has to be
     applied.
    :vartype message_release: str
    :ivar message_association_assigned_code: The message association assigned code.
    :vartype message_association_assigned_code: str
    :ivar target_namespace: The target namespace on which this envelope settings has to be applied.
    :vartype target_namespace: str
    :ivar functional_group_id: The functional group id.
    :vartype functional_group_id: str
    :ivar sender_application_qualifier: The sender application qualifier.
    :vartype sender_application_qualifier: str
    :ivar sender_application_id: The sender application id.
    :vartype sender_application_id: str
    :ivar receiver_application_qualifier: The receiver application qualifier.
    :vartype receiver_application_qualifier: str
    :ivar receiver_application_id: The receiver application id.
    :vartype receiver_application_id: str
    :ivar controlling_agency_code: The controlling agency code.
    :vartype controlling_agency_code: str
    :ivar group_header_message_version: The group header message version.
    :vartype group_header_message_version: str
    :ivar group_header_message_release: The group header message release.
    :vartype group_header_message_release: str
    :ivar association_assigned_code: The association assigned code.
    :vartype association_assigned_code: str
    :ivar application_password: The application password.
    :vartype application_password: str
    """

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'message_version': {'key': 'messageVersion', 'type': 'str'},
        'message_release': {'key': 'messageRelease', 'type': 'str'},
        'message_association_assigned_code': {'key': 'messageAssociationAssignedCode', 'type': 'str'},
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
        'functional_group_id': {'key': 'functionalGroupId', 'type': 'str'},
        'sender_application_qualifier': {'key': 'senderApplicationQualifier', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'receiver_application_qualifier': {'key': 'receiverApplicationQualifier', 'type': 'str'},
        'receiver_application_id': {'key': 'receiverApplicationId', 'type': 'str'},
        'controlling_agency_code': {'key': 'controllingAgencyCode', 'type': 'str'},
        'group_header_message_version': {'key': 'groupHeaderMessageVersion', 'type': 'str'},
        'group_header_message_release': {'key': 'groupHeaderMessageRelease', 'type': 'str'},
        'association_assigned_code': {'key': 'associationAssignedCode', 'type': 'str'},
        'application_password': {'key': 'applicationPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: Optional[str] = None,
        message_version: Optional[str] = None,
        message_release: Optional[str] = None,
        message_association_assigned_code: Optional[str] = None,
        target_namespace: Optional[str] = None,
        functional_group_id: Optional[str] = None,
        sender_application_qualifier: Optional[str] = None,
        sender_application_id: Optional[str] = None,
        receiver_application_qualifier: Optional[str] = None,
        receiver_application_id: Optional[str] = None,
        controlling_agency_code: Optional[str] = None,
        group_header_message_version: Optional[str] = None,
        group_header_message_release: Optional[str] = None,
        association_assigned_code: Optional[str] = None,
        application_password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message_id: The message id on which this envelope settings has to be applied.
        :paramtype message_id: str
        :keyword message_version: The message version on which this envelope settings has to be
         applied.
        :paramtype message_version: str
        :keyword message_release: The message release version on which this envelope settings has to be
         applied.
        :paramtype message_release: str
        :keyword message_association_assigned_code: The message association assigned code.
        :paramtype message_association_assigned_code: str
        :keyword target_namespace: The target namespace on which this envelope settings has to be
         applied.
        :paramtype target_namespace: str
        :keyword functional_group_id: The functional group id.
        :paramtype functional_group_id: str
        :keyword sender_application_qualifier: The sender application qualifier.
        :paramtype sender_application_qualifier: str
        :keyword sender_application_id: The sender application id.
        :paramtype sender_application_id: str
        :keyword receiver_application_qualifier: The receiver application qualifier.
        :paramtype receiver_application_qualifier: str
        :keyword receiver_application_id: The receiver application id.
        :paramtype receiver_application_id: str
        :keyword controlling_agency_code: The controlling agency code.
        :paramtype controlling_agency_code: str
        :keyword group_header_message_version: The group header message version.
        :paramtype group_header_message_version: str
        :keyword group_header_message_release: The group header message release.
        :paramtype group_header_message_release: str
        :keyword association_assigned_code: The association assigned code.
        :paramtype association_assigned_code: str
        :keyword application_password: The application password.
        :paramtype application_password: str
        """
        super(EdifactEnvelopeOverride, self).__init__(**kwargs)
        self.message_id = message_id
        self.message_version = message_version
        self.message_release = message_release
        self.message_association_assigned_code = message_association_assigned_code
        self.target_namespace = target_namespace
        self.functional_group_id = functional_group_id
        self.sender_application_qualifier = sender_application_qualifier
        self.sender_application_id = sender_application_id
        self.receiver_application_qualifier = receiver_application_qualifier
        self.receiver_application_id = receiver_application_id
        self.controlling_agency_code = controlling_agency_code
        self.group_header_message_version = group_header_message_version
        self.group_header_message_release = group_header_message_release
        self.association_assigned_code = association_assigned_code
        self.application_password = application_password


class EdifactEnvelopeSettings(msrest.serialization.Model):
    """The Edifact agreement envelope settings.

    All required parameters must be populated in order to send to Azure.

    :ivar group_association_assigned_code: The group association assigned code.
    :vartype group_association_assigned_code: str
    :ivar communication_agreement_id: The communication agreement id.
    :vartype communication_agreement_id: str
    :ivar apply_delimiter_string_advice: Required. The value indicating whether to apply delimiter
     string advice.
    :vartype apply_delimiter_string_advice: bool
    :ivar create_grouping_segments: Required. The value indicating whether to create grouping
     segments.
    :vartype create_grouping_segments: bool
    :ivar enable_default_group_headers: Required. The value indicating whether to enable default
     group headers.
    :vartype enable_default_group_headers: bool
    :ivar recipient_reference_password_value: The recipient reference password value.
    :vartype recipient_reference_password_value: str
    :ivar recipient_reference_password_qualifier: The recipient reference password qualifier.
    :vartype recipient_reference_password_qualifier: str
    :ivar application_reference_id: The application reference id.
    :vartype application_reference_id: str
    :ivar processing_priority_code: The processing priority code.
    :vartype processing_priority_code: str
    :ivar interchange_control_number_lower_bound: Required. The interchange control number lower
     bound.
    :vartype interchange_control_number_lower_bound: long
    :ivar interchange_control_number_upper_bound: Required. The interchange control number upper
     bound.
    :vartype interchange_control_number_upper_bound: long
    :ivar rollover_interchange_control_number: Required. The value indicating whether to rollover
     interchange control number.
    :vartype rollover_interchange_control_number: bool
    :ivar interchange_control_number_prefix: The interchange control number prefix.
    :vartype interchange_control_number_prefix: str
    :ivar interchange_control_number_suffix: The interchange control number suffix.
    :vartype interchange_control_number_suffix: str
    :ivar sender_reverse_routing_address: The sender reverse routing address.
    :vartype sender_reverse_routing_address: str
    :ivar receiver_reverse_routing_address: The receiver reverse routing address.
    :vartype receiver_reverse_routing_address: str
    :ivar functional_group_id: The functional group id.
    :vartype functional_group_id: str
    :ivar group_controlling_agency_code: The group controlling agency code.
    :vartype group_controlling_agency_code: str
    :ivar group_message_version: The group message version.
    :vartype group_message_version: str
    :ivar group_message_release: The group message release.
    :vartype group_message_release: str
    :ivar group_control_number_lower_bound: Required. The group control number lower bound.
    :vartype group_control_number_lower_bound: long
    :ivar group_control_number_upper_bound: Required. The group control number upper bound.
    :vartype group_control_number_upper_bound: long
    :ivar rollover_group_control_number: Required. The value indicating whether to rollover group
     control number.
    :vartype rollover_group_control_number: bool
    :ivar group_control_number_prefix: The group control number prefix.
    :vartype group_control_number_prefix: str
    :ivar group_control_number_suffix: The group control number suffix.
    :vartype group_control_number_suffix: str
    :ivar group_application_receiver_qualifier: The group application receiver qualifier.
    :vartype group_application_receiver_qualifier: str
    :ivar group_application_receiver_id: The group application receiver id.
    :vartype group_application_receiver_id: str
    :ivar group_application_sender_qualifier: The group application sender qualifier.
    :vartype group_application_sender_qualifier: str
    :ivar group_application_sender_id: The group application sender id.
    :vartype group_application_sender_id: str
    :ivar group_application_password: The group application password.
    :vartype group_application_password: str
    :ivar overwrite_existing_transaction_set_control_number: Required. The value indicating whether
     to overwrite existing transaction set control number.
    :vartype overwrite_existing_transaction_set_control_number: bool
    :ivar transaction_set_control_number_prefix: The transaction set control number prefix.
    :vartype transaction_set_control_number_prefix: str
    :ivar transaction_set_control_number_suffix: The transaction set control number suffix.
    :vartype transaction_set_control_number_suffix: str
    :ivar transaction_set_control_number_lower_bound: Required. The transaction set control number
     lower bound.
    :vartype transaction_set_control_number_lower_bound: long
    :ivar transaction_set_control_number_upper_bound: Required. The transaction set control number
     upper bound.
    :vartype transaction_set_control_number_upper_bound: long
    :ivar rollover_transaction_set_control_number: Required. The value indicating whether to
     rollover transaction set control number.
    :vartype rollover_transaction_set_control_number: bool
    :ivar is_test_interchange: Required. The value indicating whether the message is a test
     interchange.
    :vartype is_test_interchange: bool
    :ivar sender_internal_identification: The sender internal identification.
    :vartype sender_internal_identification: str
    :ivar sender_internal_sub_identification: The sender internal sub identification.
    :vartype sender_internal_sub_identification: str
    :ivar receiver_internal_identification: The receiver internal identification.
    :vartype receiver_internal_identification: str
    :ivar receiver_internal_sub_identification: The receiver internal sub identification.
    :vartype receiver_internal_sub_identification: str
    """

    _validation = {
        'apply_delimiter_string_advice': {'required': True},
        'create_grouping_segments': {'required': True},
        'enable_default_group_headers': {'required': True},
        'interchange_control_number_lower_bound': {'required': True},
        'interchange_control_number_upper_bound': {'required': True},
        'rollover_interchange_control_number': {'required': True},
        'group_control_number_lower_bound': {'required': True},
        'group_control_number_upper_bound': {'required': True},
        'rollover_group_control_number': {'required': True},
        'overwrite_existing_transaction_set_control_number': {'required': True},
        'transaction_set_control_number_lower_bound': {'required': True},
        'transaction_set_control_number_upper_bound': {'required': True},
        'rollover_transaction_set_control_number': {'required': True},
        'is_test_interchange': {'required': True},
    }

    _attribute_map = {
        'group_association_assigned_code': {'key': 'groupAssociationAssignedCode', 'type': 'str'},
        'communication_agreement_id': {'key': 'communicationAgreementId', 'type': 'str'},
        'apply_delimiter_string_advice': {'key': 'applyDelimiterStringAdvice', 'type': 'bool'},
        'create_grouping_segments': {'key': 'createGroupingSegments', 'type': 'bool'},
        'enable_default_group_headers': {'key': 'enableDefaultGroupHeaders', 'type': 'bool'},
        'recipient_reference_password_value': {'key': 'recipientReferencePasswordValue', 'type': 'str'},
        'recipient_reference_password_qualifier': {'key': 'recipientReferencePasswordQualifier', 'type': 'str'},
        'application_reference_id': {'key': 'applicationReferenceId', 'type': 'str'},
        'processing_priority_code': {'key': 'processingPriorityCode', 'type': 'str'},
        'interchange_control_number_lower_bound': {'key': 'interchangeControlNumberLowerBound', 'type': 'long'},
        'interchange_control_number_upper_bound': {'key': 'interchangeControlNumberUpperBound', 'type': 'long'},
        'rollover_interchange_control_number': {'key': 'rolloverInterchangeControlNumber', 'type': 'bool'},
        'interchange_control_number_prefix': {'key': 'interchangeControlNumberPrefix', 'type': 'str'},
        'interchange_control_number_suffix': {'key': 'interchangeControlNumberSuffix', 'type': 'str'},
        'sender_reverse_routing_address': {'key': 'senderReverseRoutingAddress', 'type': 'str'},
        'receiver_reverse_routing_address': {'key': 'receiverReverseRoutingAddress', 'type': 'str'},
        'functional_group_id': {'key': 'functionalGroupId', 'type': 'str'},
        'group_controlling_agency_code': {'key': 'groupControllingAgencyCode', 'type': 'str'},
        'group_message_version': {'key': 'groupMessageVersion', 'type': 'str'},
        'group_message_release': {'key': 'groupMessageRelease', 'type': 'str'},
        'group_control_number_lower_bound': {'key': 'groupControlNumberLowerBound', 'type': 'long'},
        'group_control_number_upper_bound': {'key': 'groupControlNumberUpperBound', 'type': 'long'},
        'rollover_group_control_number': {'key': 'rolloverGroupControlNumber', 'type': 'bool'},
        'group_control_number_prefix': {'key': 'groupControlNumberPrefix', 'type': 'str'},
        'group_control_number_suffix': {'key': 'groupControlNumberSuffix', 'type': 'str'},
        'group_application_receiver_qualifier': {'key': 'groupApplicationReceiverQualifier', 'type': 'str'},
        'group_application_receiver_id': {'key': 'groupApplicationReceiverId', 'type': 'str'},
        'group_application_sender_qualifier': {'key': 'groupApplicationSenderQualifier', 'type': 'str'},
        'group_application_sender_id': {'key': 'groupApplicationSenderId', 'type': 'str'},
        'group_application_password': {'key': 'groupApplicationPassword', 'type': 'str'},
        'overwrite_existing_transaction_set_control_number': {'key': 'overwriteExistingTransactionSetControlNumber', 'type': 'bool'},
        'transaction_set_control_number_prefix': {'key': 'transactionSetControlNumberPrefix', 'type': 'str'},
        'transaction_set_control_number_suffix': {'key': 'transactionSetControlNumberSuffix', 'type': 'str'},
        'transaction_set_control_number_lower_bound': {'key': 'transactionSetControlNumberLowerBound', 'type': 'long'},
        'transaction_set_control_number_upper_bound': {'key': 'transactionSetControlNumberUpperBound', 'type': 'long'},
        'rollover_transaction_set_control_number': {'key': 'rolloverTransactionSetControlNumber', 'type': 'bool'},
        'is_test_interchange': {'key': 'isTestInterchange', 'type': 'bool'},
        'sender_internal_identification': {'key': 'senderInternalIdentification', 'type': 'str'},
        'sender_internal_sub_identification': {'key': 'senderInternalSubIdentification', 'type': 'str'},
        'receiver_internal_identification': {'key': 'receiverInternalIdentification', 'type': 'str'},
        'receiver_internal_sub_identification': {'key': 'receiverInternalSubIdentification', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        apply_delimiter_string_advice: bool,
        create_grouping_segments: bool,
        enable_default_group_headers: bool,
        interchange_control_number_lower_bound: int,
        interchange_control_number_upper_bound: int,
        rollover_interchange_control_number: bool,
        group_control_number_lower_bound: int,
        group_control_number_upper_bound: int,
        rollover_group_control_number: bool,
        overwrite_existing_transaction_set_control_number: bool,
        transaction_set_control_number_lower_bound: int,
        transaction_set_control_number_upper_bound: int,
        rollover_transaction_set_control_number: bool,
        is_test_interchange: bool,
        group_association_assigned_code: Optional[str] = None,
        communication_agreement_id: Optional[str] = None,
        recipient_reference_password_value: Optional[str] = None,
        recipient_reference_password_qualifier: Optional[str] = None,
        application_reference_id: Optional[str] = None,
        processing_priority_code: Optional[str] = None,
        interchange_control_number_prefix: Optional[str] = None,
        interchange_control_number_suffix: Optional[str] = None,
        sender_reverse_routing_address: Optional[str] = None,
        receiver_reverse_routing_address: Optional[str] = None,
        functional_group_id: Optional[str] = None,
        group_controlling_agency_code: Optional[str] = None,
        group_message_version: Optional[str] = None,
        group_message_release: Optional[str] = None,
        group_control_number_prefix: Optional[str] = None,
        group_control_number_suffix: Optional[str] = None,
        group_application_receiver_qualifier: Optional[str] = None,
        group_application_receiver_id: Optional[str] = None,
        group_application_sender_qualifier: Optional[str] = None,
        group_application_sender_id: Optional[str] = None,
        group_application_password: Optional[str] = None,
        transaction_set_control_number_prefix: Optional[str] = None,
        transaction_set_control_number_suffix: Optional[str] = None,
        sender_internal_identification: Optional[str] = None,
        sender_internal_sub_identification: Optional[str] = None,
        receiver_internal_identification: Optional[str] = None,
        receiver_internal_sub_identification: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword group_association_assigned_code: The group association assigned code.
        :paramtype group_association_assigned_code: str
        :keyword communication_agreement_id: The communication agreement id.
        :paramtype communication_agreement_id: str
        :keyword apply_delimiter_string_advice: Required. The value indicating whether to apply
         delimiter string advice.
        :paramtype apply_delimiter_string_advice: bool
        :keyword create_grouping_segments: Required. The value indicating whether to create grouping
         segments.
        :paramtype create_grouping_segments: bool
        :keyword enable_default_group_headers: Required. The value indicating whether to enable default
         group headers.
        :paramtype enable_default_group_headers: bool
        :keyword recipient_reference_password_value: The recipient reference password value.
        :paramtype recipient_reference_password_value: str
        :keyword recipient_reference_password_qualifier: The recipient reference password qualifier.
        :paramtype recipient_reference_password_qualifier: str
        :keyword application_reference_id: The application reference id.
        :paramtype application_reference_id: str
        :keyword processing_priority_code: The processing priority code.
        :paramtype processing_priority_code: str
        :keyword interchange_control_number_lower_bound: Required. The interchange control number lower
         bound.
        :paramtype interchange_control_number_lower_bound: long
        :keyword interchange_control_number_upper_bound: Required. The interchange control number upper
         bound.
        :paramtype interchange_control_number_upper_bound: long
        :keyword rollover_interchange_control_number: Required. The value indicating whether to
         rollover interchange control number.
        :paramtype rollover_interchange_control_number: bool
        :keyword interchange_control_number_prefix: The interchange control number prefix.
        :paramtype interchange_control_number_prefix: str
        :keyword interchange_control_number_suffix: The interchange control number suffix.
        :paramtype interchange_control_number_suffix: str
        :keyword sender_reverse_routing_address: The sender reverse routing address.
        :paramtype sender_reverse_routing_address: str
        :keyword receiver_reverse_routing_address: The receiver reverse routing address.
        :paramtype receiver_reverse_routing_address: str
        :keyword functional_group_id: The functional group id.
        :paramtype functional_group_id: str
        :keyword group_controlling_agency_code: The group controlling agency code.
        :paramtype group_controlling_agency_code: str
        :keyword group_message_version: The group message version.
        :paramtype group_message_version: str
        :keyword group_message_release: The group message release.
        :paramtype group_message_release: str
        :keyword group_control_number_lower_bound: Required. The group control number lower bound.
        :paramtype group_control_number_lower_bound: long
        :keyword group_control_number_upper_bound: Required. The group control number upper bound.
        :paramtype group_control_number_upper_bound: long
        :keyword rollover_group_control_number: Required. The value indicating whether to rollover
         group control number.
        :paramtype rollover_group_control_number: bool
        :keyword group_control_number_prefix: The group control number prefix.
        :paramtype group_control_number_prefix: str
        :keyword group_control_number_suffix: The group control number suffix.
        :paramtype group_control_number_suffix: str
        :keyword group_application_receiver_qualifier: The group application receiver qualifier.
        :paramtype group_application_receiver_qualifier: str
        :keyword group_application_receiver_id: The group application receiver id.
        :paramtype group_application_receiver_id: str
        :keyword group_application_sender_qualifier: The group application sender qualifier.
        :paramtype group_application_sender_qualifier: str
        :keyword group_application_sender_id: The group application sender id.
        :paramtype group_application_sender_id: str
        :keyword group_application_password: The group application password.
        :paramtype group_application_password: str
        :keyword overwrite_existing_transaction_set_control_number: Required. The value indicating
         whether to overwrite existing transaction set control number.
        :paramtype overwrite_existing_transaction_set_control_number: bool
        :keyword transaction_set_control_number_prefix: The transaction set control number prefix.
        :paramtype transaction_set_control_number_prefix: str
        :keyword transaction_set_control_number_suffix: The transaction set control number suffix.
        :paramtype transaction_set_control_number_suffix: str
        :keyword transaction_set_control_number_lower_bound: Required. The transaction set control
         number lower bound.
        :paramtype transaction_set_control_number_lower_bound: long
        :keyword transaction_set_control_number_upper_bound: Required. The transaction set control
         number upper bound.
        :paramtype transaction_set_control_number_upper_bound: long
        :keyword rollover_transaction_set_control_number: Required. The value indicating whether to
         rollover transaction set control number.
        :paramtype rollover_transaction_set_control_number: bool
        :keyword is_test_interchange: Required. The value indicating whether the message is a test
         interchange.
        :paramtype is_test_interchange: bool
        :keyword sender_internal_identification: The sender internal identification.
        :paramtype sender_internal_identification: str
        :keyword sender_internal_sub_identification: The sender internal sub identification.
        :paramtype sender_internal_sub_identification: str
        :keyword receiver_internal_identification: The receiver internal identification.
        :paramtype receiver_internal_identification: str
        :keyword receiver_internal_sub_identification: The receiver internal sub identification.
        :paramtype receiver_internal_sub_identification: str
        """
        super(EdifactEnvelopeSettings, self).__init__(**kwargs)
        self.group_association_assigned_code = group_association_assigned_code
        self.communication_agreement_id = communication_agreement_id
        self.apply_delimiter_string_advice = apply_delimiter_string_advice
        self.create_grouping_segments = create_grouping_segments
        self.enable_default_group_headers = enable_default_group_headers
        self.recipient_reference_password_value = recipient_reference_password_value
        self.recipient_reference_password_qualifier = recipient_reference_password_qualifier
        self.application_reference_id = application_reference_id
        self.processing_priority_code = processing_priority_code
        self.interchange_control_number_lower_bound = interchange_control_number_lower_bound
        self.interchange_control_number_upper_bound = interchange_control_number_upper_bound
        self.rollover_interchange_control_number = rollover_interchange_control_number
        self.interchange_control_number_prefix = interchange_control_number_prefix
        self.interchange_control_number_suffix = interchange_control_number_suffix
        self.sender_reverse_routing_address = sender_reverse_routing_address
        self.receiver_reverse_routing_address = receiver_reverse_routing_address
        self.functional_group_id = functional_group_id
        self.group_controlling_agency_code = group_controlling_agency_code
        self.group_message_version = group_message_version
        self.group_message_release = group_message_release
        self.group_control_number_lower_bound = group_control_number_lower_bound
        self.group_control_number_upper_bound = group_control_number_upper_bound
        self.rollover_group_control_number = rollover_group_control_number
        self.group_control_number_prefix = group_control_number_prefix
        self.group_control_number_suffix = group_control_number_suffix
        self.group_application_receiver_qualifier = group_application_receiver_qualifier
        self.group_application_receiver_id = group_application_receiver_id
        self.group_application_sender_qualifier = group_application_sender_qualifier
        self.group_application_sender_id = group_application_sender_id
        self.group_application_password = group_application_password
        self.overwrite_existing_transaction_set_control_number = overwrite_existing_transaction_set_control_number
        self.transaction_set_control_number_prefix = transaction_set_control_number_prefix
        self.transaction_set_control_number_suffix = transaction_set_control_number_suffix
        self.transaction_set_control_number_lower_bound = transaction_set_control_number_lower_bound
        self.transaction_set_control_number_upper_bound = transaction_set_control_number_upper_bound
        self.rollover_transaction_set_control_number = rollover_transaction_set_control_number
        self.is_test_interchange = is_test_interchange
        self.sender_internal_identification = sender_internal_identification
        self.sender_internal_sub_identification = sender_internal_sub_identification
        self.receiver_internal_identification = receiver_internal_identification
        self.receiver_internal_sub_identification = receiver_internal_sub_identification


class EdifactFramingSettings(msrest.serialization.Model):
    """The Edifact agreement framing settings.

    All required parameters must be populated in order to send to Azure.

    :ivar service_code_list_directory_version: The service code list directory version.
    :vartype service_code_list_directory_version: str
    :ivar character_encoding: The character encoding.
    :vartype character_encoding: str
    :ivar protocol_version: Required. The protocol version.
    :vartype protocol_version: int
    :ivar data_element_separator: Required. The data element separator.
    :vartype data_element_separator: int
    :ivar component_separator: Required. The component separator.
    :vartype component_separator: int
    :ivar segment_terminator: Required. The segment terminator.
    :vartype segment_terminator: int
    :ivar release_indicator: Required. The release indicator.
    :vartype release_indicator: int
    :ivar repetition_separator: Required. The repetition separator.
    :vartype repetition_separator: int
    :ivar character_set: Required. The EDIFACT frame setting characterSet. Possible values include:
     "NotSpecified", "UNOB", "UNOA", "UNOC", "UNOD", "UNOE", "UNOF", "UNOG", "UNOH", "UNOI", "UNOJ",
     "UNOK", "UNOX", "UNOY", "KECA".
    :vartype character_set: str or ~azure.mgmt.logic.models.EdifactCharacterSet
    :ivar decimal_point_indicator: Required. The EDIFACT frame setting decimal indicator. Possible
     values include: "NotSpecified", "Comma", "Decimal".
    :vartype decimal_point_indicator: str or ~azure.mgmt.logic.models.EdifactDecimalIndicator
    :ivar segment_terminator_suffix: Required. The EDIFACT frame setting segment terminator suffix.
     Possible values include: "NotSpecified", "None", "CR", "LF", "CRLF".
    :vartype segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    """

    _validation = {
        'protocol_version': {'required': True},
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'segment_terminator': {'required': True},
        'release_indicator': {'required': True},
        'repetition_separator': {'required': True},
        'character_set': {'required': True},
        'decimal_point_indicator': {'required': True},
        'segment_terminator_suffix': {'required': True},
    }

    _attribute_map = {
        'service_code_list_directory_version': {'key': 'serviceCodeListDirectoryVersion', 'type': 'str'},
        'character_encoding': {'key': 'characterEncoding', 'type': 'str'},
        'protocol_version': {'key': 'protocolVersion', 'type': 'int'},
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'release_indicator': {'key': 'releaseIndicator', 'type': 'int'},
        'repetition_separator': {'key': 'repetitionSeparator', 'type': 'int'},
        'character_set': {'key': 'characterSet', 'type': 'str'},
        'decimal_point_indicator': {'key': 'decimalPointIndicator', 'type': 'str'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protocol_version: int,
        data_element_separator: int,
        component_separator: int,
        segment_terminator: int,
        release_indicator: int,
        repetition_separator: int,
        character_set: Union[str, "EdifactCharacterSet"],
        decimal_point_indicator: Union[str, "EdifactDecimalIndicator"],
        segment_terminator_suffix: Union[str, "SegmentTerminatorSuffix"],
        service_code_list_directory_version: Optional[str] = None,
        character_encoding: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword service_code_list_directory_version: The service code list directory version.
        :paramtype service_code_list_directory_version: str
        :keyword character_encoding: The character encoding.
        :paramtype character_encoding: str
        :keyword protocol_version: Required. The protocol version.
        :paramtype protocol_version: int
        :keyword data_element_separator: Required. The data element separator.
        :paramtype data_element_separator: int
        :keyword component_separator: Required. The component separator.
        :paramtype component_separator: int
        :keyword segment_terminator: Required. The segment terminator.
        :paramtype segment_terminator: int
        :keyword release_indicator: Required. The release indicator.
        :paramtype release_indicator: int
        :keyword repetition_separator: Required. The repetition separator.
        :paramtype repetition_separator: int
        :keyword character_set: Required. The EDIFACT frame setting characterSet. Possible values
         include: "NotSpecified", "UNOB", "UNOA", "UNOC", "UNOD", "UNOE", "UNOF", "UNOG", "UNOH",
         "UNOI", "UNOJ", "UNOK", "UNOX", "UNOY", "KECA".
        :paramtype character_set: str or ~azure.mgmt.logic.models.EdifactCharacterSet
        :keyword decimal_point_indicator: Required. The EDIFACT frame setting decimal indicator.
         Possible values include: "NotSpecified", "Comma", "Decimal".
        :paramtype decimal_point_indicator: str or ~azure.mgmt.logic.models.EdifactDecimalIndicator
        :keyword segment_terminator_suffix: Required. The EDIFACT frame setting segment terminator
         suffix. Possible values include: "NotSpecified", "None", "CR", "LF", "CRLF".
        :paramtype segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
        """
        super(EdifactFramingSettings, self).__init__(**kwargs)
        self.service_code_list_directory_version = service_code_list_directory_version
        self.character_encoding = character_encoding
        self.protocol_version = protocol_version
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.segment_terminator = segment_terminator
        self.release_indicator = release_indicator
        self.repetition_separator = repetition_separator
        self.character_set = character_set
        self.decimal_point_indicator = decimal_point_indicator
        self.segment_terminator_suffix = segment_terminator_suffix


class EdifactMessageFilter(msrest.serialization.Model):
    """The Edifact message filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :ivar message_filter_type: Required. The message filter type. Possible values include:
     "NotSpecified", "Include", "Exclude".
    :vartype message_filter_type: str or ~azure.mgmt.logic.models.MessageFilterType
    """

    _validation = {
        'message_filter_type': {'required': True},
    }

    _attribute_map = {
        'message_filter_type': {'key': 'messageFilterType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_filter_type: Union[str, "MessageFilterType"],
        **kwargs
    ):
        """
        :keyword message_filter_type: Required. The message filter type. Possible values include:
         "NotSpecified", "Include", "Exclude".
        :paramtype message_filter_type: str or ~azure.mgmt.logic.models.MessageFilterType
        """
        super(EdifactMessageFilter, self).__init__(**kwargs)
        self.message_filter_type = message_filter_type


class EdifactMessageIdentifier(msrest.serialization.Model):
    """The Edifact message identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The message id on which this envelope settings has to be applied.
    :vartype message_id: str
    """

    _validation = {
        'message_id': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        **kwargs
    ):
        """
        :keyword message_id: Required. The message id on which this envelope settings has to be
         applied.
        :paramtype message_id: str
        """
        super(EdifactMessageIdentifier, self).__init__(**kwargs)
        self.message_id = message_id


class EdifactOneWayAgreement(msrest.serialization.Model):
    """The Edifact one way agreement.

    All required parameters must be populated in order to send to Azure.

    :ivar sender_business_identity: Required. The sender business identity.
    :vartype sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :ivar receiver_business_identity: Required. The receiver business identity.
    :vartype receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :ivar protocol_settings: Required. The EDIFACT protocol settings.
    :vartype protocol_settings: ~azure.mgmt.logic.models.EdifactProtocolSettings
    """

    _validation = {
        'sender_business_identity': {'required': True},
        'receiver_business_identity': {'required': True},
        'protocol_settings': {'required': True},
    }

    _attribute_map = {
        'sender_business_identity': {'key': 'senderBusinessIdentity', 'type': 'BusinessIdentity'},
        'receiver_business_identity': {'key': 'receiverBusinessIdentity', 'type': 'BusinessIdentity'},
        'protocol_settings': {'key': 'protocolSettings', 'type': 'EdifactProtocolSettings'},
    }

    def __init__(
        self,
        *,
        sender_business_identity: "BusinessIdentity",
        receiver_business_identity: "BusinessIdentity",
        protocol_settings: "EdifactProtocolSettings",
        **kwargs
    ):
        """
        :keyword sender_business_identity: Required. The sender business identity.
        :paramtype sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
        :keyword receiver_business_identity: Required. The receiver business identity.
        :paramtype receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
        :keyword protocol_settings: Required. The EDIFACT protocol settings.
        :paramtype protocol_settings: ~azure.mgmt.logic.models.EdifactProtocolSettings
        """
        super(EdifactOneWayAgreement, self).__init__(**kwargs)
        self.sender_business_identity = sender_business_identity
        self.receiver_business_identity = receiver_business_identity
        self.protocol_settings = protocol_settings


class EdifactProcessingSettings(msrest.serialization.Model):
    """The Edifact agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :ivar mask_security_info: Required. The value indicating whether to mask security information.
    :vartype mask_security_info: bool
    :ivar preserve_interchange: Required. The value indicating whether to preserve interchange.
    :vartype preserve_interchange: bool
    :ivar suspend_interchange_on_error: Required. The value indicating whether to suspend
     interchange on error.
    :vartype suspend_interchange_on_error: bool
    :ivar create_empty_xml_tags_for_trailing_separators: Required. The value indicating whether to
     create empty xml tags for trailing separators.
    :vartype create_empty_xml_tags_for_trailing_separators: bool
    :ivar use_dot_as_decimal_separator: Required. The value indicating whether to use dot as
     decimal separator.
    :vartype use_dot_as_decimal_separator: bool
    """

    _validation = {
        'mask_security_info': {'required': True},
        'preserve_interchange': {'required': True},
        'suspend_interchange_on_error': {'required': True},
        'create_empty_xml_tags_for_trailing_separators': {'required': True},
        'use_dot_as_decimal_separator': {'required': True},
    }

    _attribute_map = {
        'mask_security_info': {'key': 'maskSecurityInfo', 'type': 'bool'},
        'preserve_interchange': {'key': 'preserveInterchange', 'type': 'bool'},
        'suspend_interchange_on_error': {'key': 'suspendInterchangeOnError', 'type': 'bool'},
        'create_empty_xml_tags_for_trailing_separators': {'key': 'createEmptyXmlTagsForTrailingSeparators', 'type': 'bool'},
        'use_dot_as_decimal_separator': {'key': 'useDotAsDecimalSeparator', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        mask_security_info: bool,
        preserve_interchange: bool,
        suspend_interchange_on_error: bool,
        create_empty_xml_tags_for_trailing_separators: bool,
        use_dot_as_decimal_separator: bool,
        **kwargs
    ):
        """
        :keyword mask_security_info: Required. The value indicating whether to mask security
         information.
        :paramtype mask_security_info: bool
        :keyword preserve_interchange: Required. The value indicating whether to preserve interchange.
        :paramtype preserve_interchange: bool
        :keyword suspend_interchange_on_error: Required. The value indicating whether to suspend
         interchange on error.
        :paramtype suspend_interchange_on_error: bool
        :keyword create_empty_xml_tags_for_trailing_separators: Required. The value indicating whether
         to create empty xml tags for trailing separators.
        :paramtype create_empty_xml_tags_for_trailing_separators: bool
        :keyword use_dot_as_decimal_separator: Required. The value indicating whether to use dot as
         decimal separator.
        :paramtype use_dot_as_decimal_separator: bool
        """
        super(EdifactProcessingSettings, self).__init__(**kwargs)
        self.mask_security_info = mask_security_info
        self.preserve_interchange = preserve_interchange
        self.suspend_interchange_on_error = suspend_interchange_on_error
        self.create_empty_xml_tags_for_trailing_separators = create_empty_xml_tags_for_trailing_separators
        self.use_dot_as_decimal_separator = use_dot_as_decimal_separator


class EdifactProtocolSettings(msrest.serialization.Model):
    """The Edifact agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_settings: Required. The EDIFACT validation settings.
    :vartype validation_settings: ~azure.mgmt.logic.models.EdifactValidationSettings
    :ivar framing_settings: Required. The EDIFACT framing settings.
    :vartype framing_settings: ~azure.mgmt.logic.models.EdifactFramingSettings
    :ivar envelope_settings: Required. The EDIFACT envelope settings.
    :vartype envelope_settings: ~azure.mgmt.logic.models.EdifactEnvelopeSettings
    :ivar acknowledgement_settings: Required. The EDIFACT acknowledgement settings.
    :vartype acknowledgement_settings: ~azure.mgmt.logic.models.EdifactAcknowledgementSettings
    :ivar message_filter: Required. The EDIFACT message filter.
    :vartype message_filter: ~azure.mgmt.logic.models.EdifactMessageFilter
    :ivar processing_settings: Required. The EDIFACT processing Settings.
    :vartype processing_settings: ~azure.mgmt.logic.models.EdifactProcessingSettings
    :ivar envelope_overrides: The EDIFACT envelope override settings.
    :vartype envelope_overrides: list[~azure.mgmt.logic.models.EdifactEnvelopeOverride]
    :ivar message_filter_list: The EDIFACT message filter list.
    :vartype message_filter_list: list[~azure.mgmt.logic.models.EdifactMessageIdentifier]
    :ivar schema_references: Required. The EDIFACT schema references.
    :vartype schema_references: list[~azure.mgmt.logic.models.EdifactSchemaReference]
    :ivar validation_overrides: The EDIFACT validation override settings.
    :vartype validation_overrides: list[~azure.mgmt.logic.models.EdifactValidationOverride]
    :ivar edifact_delimiter_overrides: The EDIFACT delimiter override settings.
    :vartype edifact_delimiter_overrides: list[~azure.mgmt.logic.models.EdifactDelimiterOverride]
    """

    _validation = {
        'validation_settings': {'required': True},
        'framing_settings': {'required': True},
        'envelope_settings': {'required': True},
        'acknowledgement_settings': {'required': True},
        'message_filter': {'required': True},
        'processing_settings': {'required': True},
        'schema_references': {'required': True},
    }

    _attribute_map = {
        'validation_settings': {'key': 'validationSettings', 'type': 'EdifactValidationSettings'},
        'framing_settings': {'key': 'framingSettings', 'type': 'EdifactFramingSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'EdifactEnvelopeSettings'},
        'acknowledgement_settings': {'key': 'acknowledgementSettings', 'type': 'EdifactAcknowledgementSettings'},
        'message_filter': {'key': 'messageFilter', 'type': 'EdifactMessageFilter'},
        'processing_settings': {'key': 'processingSettings', 'type': 'EdifactProcessingSettings'},
        'envelope_overrides': {'key': 'envelopeOverrides', 'type': '[EdifactEnvelopeOverride]'},
        'message_filter_list': {'key': 'messageFilterList', 'type': '[EdifactMessageIdentifier]'},
        'schema_references': {'key': 'schemaReferences', 'type': '[EdifactSchemaReference]'},
        'validation_overrides': {'key': 'validationOverrides', 'type': '[EdifactValidationOverride]'},
        'edifact_delimiter_overrides': {'key': 'edifactDelimiterOverrides', 'type': '[EdifactDelimiterOverride]'},
    }

    def __init__(
        self,
        *,
        validation_settings: "EdifactValidationSettings",
        framing_settings: "EdifactFramingSettings",
        envelope_settings: "EdifactEnvelopeSettings",
        acknowledgement_settings: "EdifactAcknowledgementSettings",
        message_filter: "EdifactMessageFilter",
        processing_settings: "EdifactProcessingSettings",
        schema_references: List["EdifactSchemaReference"],
        envelope_overrides: Optional[List["EdifactEnvelopeOverride"]] = None,
        message_filter_list: Optional[List["EdifactMessageIdentifier"]] = None,
        validation_overrides: Optional[List["EdifactValidationOverride"]] = None,
        edifact_delimiter_overrides: Optional[List["EdifactDelimiterOverride"]] = None,
        **kwargs
    ):
        """
        :keyword validation_settings: Required. The EDIFACT validation settings.
        :paramtype validation_settings: ~azure.mgmt.logic.models.EdifactValidationSettings
        :keyword framing_settings: Required. The EDIFACT framing settings.
        :paramtype framing_settings: ~azure.mgmt.logic.models.EdifactFramingSettings
        :keyword envelope_settings: Required. The EDIFACT envelope settings.
        :paramtype envelope_settings: ~azure.mgmt.logic.models.EdifactEnvelopeSettings
        :keyword acknowledgement_settings: Required. The EDIFACT acknowledgement settings.
        :paramtype acknowledgement_settings: ~azure.mgmt.logic.models.EdifactAcknowledgementSettings
        :keyword message_filter: Required. The EDIFACT message filter.
        :paramtype message_filter: ~azure.mgmt.logic.models.EdifactMessageFilter
        :keyword processing_settings: Required. The EDIFACT processing Settings.
        :paramtype processing_settings: ~azure.mgmt.logic.models.EdifactProcessingSettings
        :keyword envelope_overrides: The EDIFACT envelope override settings.
        :paramtype envelope_overrides: list[~azure.mgmt.logic.models.EdifactEnvelopeOverride]
        :keyword message_filter_list: The EDIFACT message filter list.
        :paramtype message_filter_list: list[~azure.mgmt.logic.models.EdifactMessageIdentifier]
        :keyword schema_references: Required. The EDIFACT schema references.
        :paramtype schema_references: list[~azure.mgmt.logic.models.EdifactSchemaReference]
        :keyword validation_overrides: The EDIFACT validation override settings.
        :paramtype validation_overrides: list[~azure.mgmt.logic.models.EdifactValidationOverride]
        :keyword edifact_delimiter_overrides: The EDIFACT delimiter override settings.
        :paramtype edifact_delimiter_overrides: list[~azure.mgmt.logic.models.EdifactDelimiterOverride]
        """
        super(EdifactProtocolSettings, self).__init__(**kwargs)
        self.validation_settings = validation_settings
        self.framing_settings = framing_settings
        self.envelope_settings = envelope_settings
        self.acknowledgement_settings = acknowledgement_settings
        self.message_filter = message_filter
        self.processing_settings = processing_settings
        self.envelope_overrides = envelope_overrides
        self.message_filter_list = message_filter_list
        self.schema_references = schema_references
        self.validation_overrides = validation_overrides
        self.edifact_delimiter_overrides = edifact_delimiter_overrides


class EdifactSchemaReference(msrest.serialization.Model):
    """The Edifact schema reference.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The message id.
    :vartype message_id: str
    :ivar message_version: Required. The message version.
    :vartype message_version: str
    :ivar message_release: Required. The message release version.
    :vartype message_release: str
    :ivar sender_application_id: The sender application id.
    :vartype sender_application_id: str
    :ivar sender_application_qualifier: The sender application qualifier.
    :vartype sender_application_qualifier: str
    :ivar association_assigned_code: The association assigned code.
    :vartype association_assigned_code: str
    :ivar schema_name: Required. The schema name.
    :vartype schema_name: str
    """

    _validation = {
        'message_id': {'required': True},
        'message_version': {'required': True},
        'message_release': {'required': True},
        'schema_name': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'message_version': {'key': 'messageVersion', 'type': 'str'},
        'message_release': {'key': 'messageRelease', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'sender_application_qualifier': {'key': 'senderApplicationQualifier', 'type': 'str'},
        'association_assigned_code': {'key': 'associationAssignedCode', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        message_version: str,
        message_release: str,
        schema_name: str,
        sender_application_id: Optional[str] = None,
        sender_application_qualifier: Optional[str] = None,
        association_assigned_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message_id: Required. The message id.
        :paramtype message_id: str
        :keyword message_version: Required. The message version.
        :paramtype message_version: str
        :keyword message_release: Required. The message release version.
        :paramtype message_release: str
        :keyword sender_application_id: The sender application id.
        :paramtype sender_application_id: str
        :keyword sender_application_qualifier: The sender application qualifier.
        :paramtype sender_application_qualifier: str
        :keyword association_assigned_code: The association assigned code.
        :paramtype association_assigned_code: str
        :keyword schema_name: Required. The schema name.
        :paramtype schema_name: str
        """
        super(EdifactSchemaReference, self).__init__(**kwargs)
        self.message_id = message_id
        self.message_version = message_version
        self.message_release = message_release
        self.sender_application_id = sender_application_id
        self.sender_application_qualifier = sender_application_qualifier
        self.association_assigned_code = association_assigned_code
        self.schema_name = schema_name


class EdifactValidationOverride(msrest.serialization.Model):
    """The Edifact validation override settings.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The message id on which the validation settings has to be applied.
    :vartype message_id: str
    :ivar enforce_character_set: Required. The value indicating whether to validate character Set.
    :vartype enforce_character_set: bool
    :ivar validate_edi_types: Required. The value indicating whether to validate EDI types.
    :vartype validate_edi_types: bool
    :ivar validate_xsd_types: Required. The value indicating whether to validate XSD types.
    :vartype validate_xsd_types: bool
    :ivar allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     allow leading and trailing spaces and zeroes.
    :vartype allow_leading_and_trailing_spaces_and_zeroes: bool
    :ivar trailing_separator_policy: Required. The trailing separator policy. Possible values
     include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
    :vartype trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    :ivar trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     trim leading and trailing spaces and zeroes.
    :vartype trim_leading_and_trailing_spaces_and_zeroes: bool
    """

    _validation = {
        'message_id': {'required': True},
        'enforce_character_set': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'enforce_character_set': {'key': 'enforceCharacterSet', 'type': 'bool'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        enforce_character_set: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: Union[str, "TrailingSeparatorPolicy"],
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        **kwargs
    ):
        """
        :keyword message_id: Required. The message id on which the validation settings has to be
         applied.
        :paramtype message_id: str
        :keyword enforce_character_set: Required. The value indicating whether to validate character
         Set.
        :paramtype enforce_character_set: bool
        :keyword validate_edi_types: Required. The value indicating whether to validate EDI types.
        :paramtype validate_edi_types: bool
        :keyword validate_xsd_types: Required. The value indicating whether to validate XSD types.
        :paramtype validate_xsd_types: bool
        :keyword allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether
         to allow leading and trailing spaces and zeroes.
        :paramtype allow_leading_and_trailing_spaces_and_zeroes: bool
        :keyword trailing_separator_policy: Required. The trailing separator policy. Possible values
         include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
        :paramtype trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
        :keyword trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
         trim leading and trailing spaces and zeroes.
        :paramtype trim_leading_and_trailing_spaces_and_zeroes: bool
        """
        super(EdifactValidationOverride, self).__init__(**kwargs)
        self.message_id = message_id
        self.enforce_character_set = enforce_character_set
        self.validate_edi_types = validate_edi_types
        self.validate_xsd_types = validate_xsd_types
        self.allow_leading_and_trailing_spaces_and_zeroes = allow_leading_and_trailing_spaces_and_zeroes
        self.trailing_separator_policy = trailing_separator_policy
        self.trim_leading_and_trailing_spaces_and_zeroes = trim_leading_and_trailing_spaces_and_zeroes


class EdifactValidationSettings(msrest.serialization.Model):
    """The Edifact agreement validation settings.

    All required parameters must be populated in order to send to Azure.

    :ivar validate_character_set: Required. The value indicating whether to validate character set
     in the message.
    :vartype validate_character_set: bool
    :ivar check_duplicate_interchange_control_number: Required. The value indicating whether to
     check for duplicate interchange control number.
    :vartype check_duplicate_interchange_control_number: bool
    :ivar interchange_control_number_validity_days: Required. The validity period of interchange
     control number.
    :vartype interchange_control_number_validity_days: int
    :ivar check_duplicate_group_control_number: Required. The value indicating whether to check for
     duplicate group control number.
    :vartype check_duplicate_group_control_number: bool
    :ivar check_duplicate_transaction_set_control_number: Required. The value indicating whether to
     check for duplicate transaction set control number.
    :vartype check_duplicate_transaction_set_control_number: bool
    :ivar validate_edi_types: Required. The value indicating whether to Whether to validate EDI
     types.
    :vartype validate_edi_types: bool
    :ivar validate_xsd_types: Required. The value indicating whether to Whether to validate XSD
     types.
    :vartype validate_xsd_types: bool
    :ivar allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     allow leading and trailing spaces and zeroes.
    :vartype allow_leading_and_trailing_spaces_and_zeroes: bool
    :ivar trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     trim leading and trailing spaces and zeroes.
    :vartype trim_leading_and_trailing_spaces_and_zeroes: bool
    :ivar trailing_separator_policy: Required. The trailing separator policy. Possible values
     include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
    :vartype trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    """

    _validation = {
        'validate_character_set': {'required': True},
        'check_duplicate_interchange_control_number': {'required': True},
        'interchange_control_number_validity_days': {'required': True},
        'check_duplicate_group_control_number': {'required': True},
        'check_duplicate_transaction_set_control_number': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
    }

    _attribute_map = {
        'validate_character_set': {'key': 'validateCharacterSet', 'type': 'bool'},
        'check_duplicate_interchange_control_number': {'key': 'checkDuplicateInterchangeControlNumber', 'type': 'bool'},
        'interchange_control_number_validity_days': {'key': 'interchangeControlNumberValidityDays', 'type': 'int'},
        'check_duplicate_group_control_number': {'key': 'checkDuplicateGroupControlNumber', 'type': 'bool'},
        'check_duplicate_transaction_set_control_number': {'key': 'checkDuplicateTransactionSetControlNumber', 'type': 'bool'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validate_character_set: bool,
        check_duplicate_interchange_control_number: bool,
        interchange_control_number_validity_days: int,
        check_duplicate_group_control_number: bool,
        check_duplicate_transaction_set_control_number: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: Union[str, "TrailingSeparatorPolicy"],
        **kwargs
    ):
        """
        :keyword validate_character_set: Required. The value indicating whether to validate character
         set in the message.
        :paramtype validate_character_set: bool
        :keyword check_duplicate_interchange_control_number: Required. The value indicating whether to
         check for duplicate interchange control number.
        :paramtype check_duplicate_interchange_control_number: bool
        :keyword interchange_control_number_validity_days: Required. The validity period of interchange
         control number.
        :paramtype interchange_control_number_validity_days: int
        :keyword check_duplicate_group_control_number: Required. The value indicating whether to check
         for duplicate group control number.
        :paramtype check_duplicate_group_control_number: bool
        :keyword check_duplicate_transaction_set_control_number: Required. The value indicating whether
         to check for duplicate transaction set control number.
        :paramtype check_duplicate_transaction_set_control_number: bool
        :keyword validate_edi_types: Required. The value indicating whether to Whether to validate EDI
         types.
        :paramtype validate_edi_types: bool
        :keyword validate_xsd_types: Required. The value indicating whether to Whether to validate XSD
         types.
        :paramtype validate_xsd_types: bool
        :keyword allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether
         to allow leading and trailing spaces and zeroes.
        :paramtype allow_leading_and_trailing_spaces_and_zeroes: bool
        :keyword trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
         trim leading and trailing spaces and zeroes.
        :paramtype trim_leading_and_trailing_spaces_and_zeroes: bool
        :keyword trailing_separator_policy: Required. The trailing separator policy. Possible values
         include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
        :paramtype trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
        """
        super(EdifactValidationSettings, self).__init__(**kwargs)
        self.validate_character_set = validate_character_set
        self.check_duplicate_interchange_control_number = check_duplicate_interchange_control_number
        self.interchange_control_number_validity_days = interchange_control_number_validity_days
        self.check_duplicate_group_control_number = check_duplicate_group_control_number
        self.check_duplicate_transaction_set_control_number = check_duplicate_transaction_set_control_number
        self.validate_edi_types = validate_edi_types
        self.validate_xsd_types = validate_xsd_types
        self.allow_leading_and_trailing_spaces_and_zeroes = allow_leading_and_trailing_spaces_and_zeroes
        self.trim_leading_and_trailing_spaces_and_zeroes = trim_leading_and_trailing_spaces_and_zeroes
        self.trailing_separator_policy = trailing_separator_policy


class ErrorProperties(msrest.serialization.Model):
    """Error properties indicate why the Logic service was not able to process the incoming request. The reason is provided in the error message.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorProperties, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates Logic service is not able to process the incoming request. The error property contains the error details.

    :ivar error: The error properties.
    :vartype error: ~azure.mgmt.logic.models.ErrorProperties
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorProperties'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorProperties"] = None,
        **kwargs
    ):
        """
        :keyword error: The error properties.
        :paramtype error: ~azure.mgmt.logic.models.ErrorProperties
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class Expression(msrest.serialization.Model):
    """The expression.

    :ivar text: The text.
    :vartype text: str
    :ivar value: Anything.
    :vartype value: any
    :ivar subexpressions: The sub expressions.
    :vartype subexpressions: list[~azure.mgmt.logic.models.Expression]
    :ivar error: The azure resource error info.
    :vartype error: ~azure.mgmt.logic.models.AzureResourceErrorInfo
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'subexpressions': {'key': 'subexpressions', 'type': '[Expression]'},
        'error': {'key': 'error', 'type': 'AzureResourceErrorInfo'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        value: Optional[Any] = None,
        subexpressions: Optional[List["Expression"]] = None,
        error: Optional["AzureResourceErrorInfo"] = None,
        **kwargs
    ):
        """
        :keyword text: The text.
        :paramtype text: str
        :keyword value: Anything.
        :paramtype value: any
        :keyword subexpressions: The sub expressions.
        :paramtype subexpressions: list[~azure.mgmt.logic.models.Expression]
        :keyword error: The azure resource error info.
        :paramtype error: ~azure.mgmt.logic.models.AzureResourceErrorInfo
        """
        super(Expression, self).__init__(**kwargs)
        self.text = text
        self.value = value
        self.subexpressions = subexpressions
        self.error = error


class ExpressionRoot(Expression):
    """The expression root.

    :ivar text: The text.
    :vartype text: str
    :ivar value: Anything.
    :vartype value: any
    :ivar subexpressions: The sub expressions.
    :vartype subexpressions: list[~azure.mgmt.logic.models.Expression]
    :ivar error: The azure resource error info.
    :vartype error: ~azure.mgmt.logic.models.AzureResourceErrorInfo
    :ivar path: The path.
    :vartype path: str
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'subexpressions': {'key': 'subexpressions', 'type': '[Expression]'},
        'error': {'key': 'error', 'type': 'AzureResourceErrorInfo'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        value: Optional[Any] = None,
        subexpressions: Optional[List["Expression"]] = None,
        error: Optional["AzureResourceErrorInfo"] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword text: The text.
        :paramtype text: str
        :keyword value: Anything.
        :paramtype value: any
        :keyword subexpressions: The sub expressions.
        :paramtype subexpressions: list[~azure.mgmt.logic.models.Expression]
        :keyword error: The azure resource error info.
        :paramtype error: ~azure.mgmt.logic.models.AzureResourceErrorInfo
        :keyword path: The path.
        :paramtype path: str
        """
        super(ExpressionRoot, self).__init__(text=text, value=value, subexpressions=subexpressions, error=error, **kwargs)
        self.path = path


class ExpressionTraces(msrest.serialization.Model):
    """The expression traces.

    :ivar inputs:
    :vartype inputs: list[~azure.mgmt.logic.models.ExpressionRoot]
    """

    _attribute_map = {
        'inputs': {'key': 'inputs', 'type': '[ExpressionRoot]'},
    }

    def __init__(
        self,
        *,
        inputs: Optional[List["ExpressionRoot"]] = None,
        **kwargs
    ):
        """
        :keyword inputs:
        :paramtype inputs: list[~azure.mgmt.logic.models.ExpressionRoot]
        """
        super(ExpressionTraces, self).__init__(**kwargs)
        self.inputs = inputs


class ExtendedErrorInfo(msrest.serialization.Model):
    """The extended error info.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. The error code. Possible values include: "NotSpecified",
     "IntegrationServiceEnvironmentNotFound", "InternalServerError", "InvalidOperationId".
    :vartype code: str or ~azure.mgmt.logic.models.ErrorResponseCode
    :ivar message: Required. The error message.
    :vartype message: str
    :ivar details: The error message details.
    :vartype details: list[~azure.mgmt.logic.models.ExtendedErrorInfo]
    :ivar inner_error: The inner error.
    :vartype inner_error: any
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ExtendedErrorInfo]'},
        'inner_error': {'key': 'innerError', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "ErrorResponseCode"],
        message: str,
        details: Optional[List["ExtendedErrorInfo"]] = None,
        inner_error: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword code: Required. The error code. Possible values include: "NotSpecified",
         "IntegrationServiceEnvironmentNotFound", "InternalServerError", "InvalidOperationId".
        :paramtype code: str or ~azure.mgmt.logic.models.ErrorResponseCode
        :keyword message: Required. The error message.
        :paramtype message: str
        :keyword details: The error message details.
        :paramtype details: list[~azure.mgmt.logic.models.ExtendedErrorInfo]
        :keyword inner_error: The inner error.
        :paramtype inner_error: any
        """
        super(ExtendedErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.inner_error = inner_error


class FlowAccessControlConfiguration(msrest.serialization.Model):
    """The access control configuration.

    :ivar triggers: The access control configuration for invoking workflow triggers.
    :vartype triggers: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
    :ivar contents: The access control configuration for accessing workflow run contents.
    :vartype contents: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
    :ivar actions: The access control configuration for workflow actions.
    :vartype actions: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
    :ivar workflow_management: The access control configuration for workflow management.
    :vartype workflow_management: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'FlowAccessControlConfigurationPolicy'},
        'contents': {'key': 'contents', 'type': 'FlowAccessControlConfigurationPolicy'},
        'actions': {'key': 'actions', 'type': 'FlowAccessControlConfigurationPolicy'},
        'workflow_management': {'key': 'workflowManagement', 'type': 'FlowAccessControlConfigurationPolicy'},
    }

    def __init__(
        self,
        *,
        triggers: Optional["FlowAccessControlConfigurationPolicy"] = None,
        contents: Optional["FlowAccessControlConfigurationPolicy"] = None,
        actions: Optional["FlowAccessControlConfigurationPolicy"] = None,
        workflow_management: Optional["FlowAccessControlConfigurationPolicy"] = None,
        **kwargs
    ):
        """
        :keyword triggers: The access control configuration for invoking workflow triggers.
        :paramtype triggers: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
        :keyword contents: The access control configuration for accessing workflow run contents.
        :paramtype contents: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
        :keyword actions: The access control configuration for workflow actions.
        :paramtype actions: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
        :keyword workflow_management: The access control configuration for workflow management.
        :paramtype workflow_management: ~azure.mgmt.logic.models.FlowAccessControlConfigurationPolicy
        """
        super(FlowAccessControlConfiguration, self).__init__(**kwargs)
        self.triggers = triggers
        self.contents = contents
        self.actions = actions
        self.workflow_management = workflow_management


class FlowAccessControlConfigurationPolicy(msrest.serialization.Model):
    """The access control configuration policy.

    :ivar allowed_caller_ip_addresses: The allowed caller IP address ranges.
    :vartype allowed_caller_ip_addresses: list[~azure.mgmt.logic.models.IpAddressRange]
    :ivar open_authentication_policies: The authentication policies for workflow.
    :vartype open_authentication_policies:
     ~azure.mgmt.logic.models.OpenAuthenticationAccessPolicies
    """

    _attribute_map = {
        'allowed_caller_ip_addresses': {'key': 'allowedCallerIpAddresses', 'type': '[IpAddressRange]'},
        'open_authentication_policies': {'key': 'openAuthenticationPolicies', 'type': 'OpenAuthenticationAccessPolicies'},
    }

    def __init__(
        self,
        *,
        allowed_caller_ip_addresses: Optional[List["IpAddressRange"]] = None,
        open_authentication_policies: Optional["OpenAuthenticationAccessPolicies"] = None,
        **kwargs
    ):
        """
        :keyword allowed_caller_ip_addresses: The allowed caller IP address ranges.
        :paramtype allowed_caller_ip_addresses: list[~azure.mgmt.logic.models.IpAddressRange]
        :keyword open_authentication_policies: The authentication policies for workflow.
        :paramtype open_authentication_policies:
         ~azure.mgmt.logic.models.OpenAuthenticationAccessPolicies
        """
        super(FlowAccessControlConfigurationPolicy, self).__init__(**kwargs)
        self.allowed_caller_ip_addresses = allowed_caller_ip_addresses
        self.open_authentication_policies = open_authentication_policies


class FlowEndpoints(msrest.serialization.Model):
    """The flow endpoints configuration.

    :ivar outgoing_ip_addresses: The outgoing ip address.
    :vartype outgoing_ip_addresses: list[~azure.mgmt.logic.models.IpAddress]
    :ivar access_endpoint_ip_addresses: The access endpoint ip address.
    :vartype access_endpoint_ip_addresses: list[~azure.mgmt.logic.models.IpAddress]
    """

    _attribute_map = {
        'outgoing_ip_addresses': {'key': 'outgoingIpAddresses', 'type': '[IpAddress]'},
        'access_endpoint_ip_addresses': {'key': 'accessEndpointIpAddresses', 'type': '[IpAddress]'},
    }

    def __init__(
        self,
        *,
        outgoing_ip_addresses: Optional[List["IpAddress"]] = None,
        access_endpoint_ip_addresses: Optional[List["IpAddress"]] = None,
        **kwargs
    ):
        """
        :keyword outgoing_ip_addresses: The outgoing ip address.
        :paramtype outgoing_ip_addresses: list[~azure.mgmt.logic.models.IpAddress]
        :keyword access_endpoint_ip_addresses: The access endpoint ip address.
        :paramtype access_endpoint_ip_addresses: list[~azure.mgmt.logic.models.IpAddress]
        """
        super(FlowEndpoints, self).__init__(**kwargs)
        self.outgoing_ip_addresses = outgoing_ip_addresses
        self.access_endpoint_ip_addresses = access_endpoint_ip_addresses


class FlowEndpointsConfiguration(msrest.serialization.Model):
    """The endpoints configuration.

    :ivar workflow: The workflow endpoints.
    :vartype workflow: ~azure.mgmt.logic.models.FlowEndpoints
    :ivar connector: The connector endpoints.
    :vartype connector: ~azure.mgmt.logic.models.FlowEndpoints
    """

    _attribute_map = {
        'workflow': {'key': 'workflow', 'type': 'FlowEndpoints'},
        'connector': {'key': 'connector', 'type': 'FlowEndpoints'},
    }

    def __init__(
        self,
        *,
        workflow: Optional["FlowEndpoints"] = None,
        connector: Optional["FlowEndpoints"] = None,
        **kwargs
    ):
        """
        :keyword workflow: The workflow endpoints.
        :paramtype workflow: ~azure.mgmt.logic.models.FlowEndpoints
        :keyword connector: The connector endpoints.
        :paramtype connector: ~azure.mgmt.logic.models.FlowEndpoints
        """
        super(FlowEndpointsConfiguration, self).__init__(**kwargs)
        self.workflow = workflow
        self.connector = connector


class GenerateUpgradedDefinitionParameters(msrest.serialization.Model):
    """The parameters to generate upgraded definition.

    :ivar target_schema_version: The target schema version.
    :vartype target_schema_version: str
    """

    _attribute_map = {
        'target_schema_version': {'key': 'targetSchemaVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_schema_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_schema_version: The target schema version.
        :paramtype target_schema_version: str
        """
        super(GenerateUpgradedDefinitionParameters, self).__init__(**kwargs)
        self.target_schema_version = target_schema_version


class GetCallbackUrlParameters(msrest.serialization.Model):
    """The callback url parameters.

    :ivar not_after: The expiry time.
    :vartype not_after: ~datetime.datetime
    :ivar key_type: The key type. Possible values include: "NotSpecified", "Primary", "Secondary".
    :vartype key_type: str or ~azure.mgmt.logic.models.KeyType
    """

    _attribute_map = {
        'not_after': {'key': 'notAfter', 'type': 'iso-8601'},
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        not_after: Optional[datetime.datetime] = None,
        key_type: Optional[Union[str, "KeyType"]] = None,
        **kwargs
    ):
        """
        :keyword not_after: The expiry time.
        :paramtype not_after: ~datetime.datetime
        :keyword key_type: The key type. Possible values include: "NotSpecified", "Primary",
         "Secondary".
        :paramtype key_type: str or ~azure.mgmt.logic.models.KeyType
        """
        super(GetCallbackUrlParameters, self).__init__(**kwargs)
        self.not_after = not_after
        self.key_type = key_type


class IntegrationAccount(Resource):
    """The integration account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.logic.models.IntegrationAccountSku
    :ivar integration_service_environment: The integration service environment.
    :vartype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    :ivar state: The workflow state. Possible values include: "NotSpecified", "Completed",
     "Enabled", "Disabled", "Deleted", "Suspended".
    :vartype state: str or ~azure.mgmt.logic.models.WorkflowState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'IntegrationAccountSku'},
        'integration_service_environment': {'key': 'properties.integrationServiceEnvironment', 'type': 'ResourceReference'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["IntegrationAccountSku"] = None,
        integration_service_environment: Optional["ResourceReference"] = None,
        state: Optional[Union[str, "WorkflowState"]] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku.
        :paramtype sku: ~azure.mgmt.logic.models.IntegrationAccountSku
        :keyword integration_service_environment: The integration service environment.
        :paramtype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
        :keyword state: The workflow state. Possible values include: "NotSpecified", "Completed",
         "Enabled", "Disabled", "Deleted", "Suspended".
        :paramtype state: str or ~azure.mgmt.logic.models.WorkflowState
        """
        super(IntegrationAccount, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.integration_service_environment = integration_service_environment
        self.state = state


class IntegrationAccountAgreement(Resource):
    """The integration account agreement.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar metadata: The metadata.
    :vartype metadata: any
    :ivar agreement_type: Required. The agreement type. Possible values include: "NotSpecified",
     "AS2", "X12", "Edifact".
    :vartype agreement_type: str or ~azure.mgmt.logic.models.AgreementType
    :ivar host_partner: Required. The integration account partner that is set as host partner for
     this agreement.
    :vartype host_partner: str
    :ivar guest_partner: Required. The integration account partner that is set as guest partner for
     this agreement.
    :vartype guest_partner: str
    :ivar host_identity: Required. The business identity of the host partner.
    :vartype host_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :ivar guest_identity: Required. The business identity of the guest partner.
    :vartype guest_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :ivar content: Required. The agreement content.
    :vartype content: ~azure.mgmt.logic.models.AgreementContent
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'agreement_type': {'required': True},
        'host_partner': {'required': True},
        'guest_partner': {'required': True},
        'host_identity': {'required': True},
        'guest_identity': {'required': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'agreement_type': {'key': 'properties.agreementType', 'type': 'str'},
        'host_partner': {'key': 'properties.hostPartner', 'type': 'str'},
        'guest_partner': {'key': 'properties.guestPartner', 'type': 'str'},
        'host_identity': {'key': 'properties.hostIdentity', 'type': 'BusinessIdentity'},
        'guest_identity': {'key': 'properties.guestIdentity', 'type': 'BusinessIdentity'},
        'content': {'key': 'properties.content', 'type': 'AgreementContent'},
    }

    def __init__(
        self,
        *,
        agreement_type: Union[str, "AgreementType"],
        host_partner: str,
        guest_partner: str,
        host_identity: "BusinessIdentity",
        guest_identity: "BusinessIdentity",
        content: "AgreementContent",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        metadata: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword metadata: The metadata.
        :paramtype metadata: any
        :keyword agreement_type: Required. The agreement type. Possible values include: "NotSpecified",
         "AS2", "X12", "Edifact".
        :paramtype agreement_type: str or ~azure.mgmt.logic.models.AgreementType
        :keyword host_partner: Required. The integration account partner that is set as host partner
         for this agreement.
        :paramtype host_partner: str
        :keyword guest_partner: Required. The integration account partner that is set as guest partner
         for this agreement.
        :paramtype guest_partner: str
        :keyword host_identity: Required. The business identity of the host partner.
        :paramtype host_identity: ~azure.mgmt.logic.models.BusinessIdentity
        :keyword guest_identity: Required. The business identity of the guest partner.
        :paramtype guest_identity: ~azure.mgmt.logic.models.BusinessIdentity
        :keyword content: Required. The agreement content.
        :paramtype content: ~azure.mgmt.logic.models.AgreementContent
        """
        super(IntegrationAccountAgreement, self).__init__(location=location, tags=tags, **kwargs)
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.agreement_type = agreement_type
        self.host_partner = host_partner
        self.guest_partner = guest_partner
        self.host_identity = host_identity
        self.guest_identity = guest_identity
        self.content = content


class IntegrationAccountAgreementFilter(msrest.serialization.Model):
    """The integration account agreement filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :ivar agreement_type: Required. The agreement type of integration account agreement. Possible
     values include: "NotSpecified", "AS2", "X12", "Edifact".
    :vartype agreement_type: str or ~azure.mgmt.logic.models.AgreementType
    """

    _validation = {
        'agreement_type': {'required': True},
    }

    _attribute_map = {
        'agreement_type': {'key': 'agreementType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        agreement_type: Union[str, "AgreementType"],
        **kwargs
    ):
        """
        :keyword agreement_type: Required. The agreement type of integration account agreement.
         Possible values include: "NotSpecified", "AS2", "X12", "Edifact".
        :paramtype agreement_type: str or ~azure.mgmt.logic.models.AgreementType
        """
        super(IntegrationAccountAgreementFilter, self).__init__(**kwargs)
        self.agreement_type = agreement_type


class IntegrationAccountAgreementListResult(msrest.serialization.Model):
    """The list of integration account agreements.

    :ivar value: The list of integration account agreements.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationAccountAgreement]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountAgreement]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountAgreement"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of integration account agreements.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationAccountAgreement]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationAccountAgreementListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountCertificate(Resource):
    """The integration account certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar metadata: The metadata.
    :vartype metadata: any
    :ivar key: The key details in the key vault.
    :vartype key: ~azure.mgmt.logic.models.KeyVaultKeyReference
    :ivar public_certificate: The public certificate.
    :vartype public_certificate: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'key': {'key': 'properties.key', 'type': 'KeyVaultKeyReference'},
        'public_certificate': {'key': 'properties.publicCertificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        metadata: Optional[Any] = None,
        key: Optional["KeyVaultKeyReference"] = None,
        public_certificate: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword metadata: The metadata.
        :paramtype metadata: any
        :keyword key: The key details in the key vault.
        :paramtype key: ~azure.mgmt.logic.models.KeyVaultKeyReference
        :keyword public_certificate: The public certificate.
        :paramtype public_certificate: str
        """
        super(IntegrationAccountCertificate, self).__init__(location=location, tags=tags, **kwargs)
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.key = key
        self.public_certificate = public_certificate


class IntegrationAccountCertificateListResult(msrest.serialization.Model):
    """The list of integration account certificates.

    :ivar value: The list of integration account certificates.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationAccountCertificate]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountCertificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountCertificate"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of integration account certificates.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationAccountCertificate]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationAccountCertificateListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountListResult(msrest.serialization.Model):
    """The list of integration accounts.

    :ivar value: The list of integration accounts.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationAccount]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccount"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of integration accounts.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationAccount]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationAccountListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountMap(Resource):
    """The integration account map.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar map_type: Required. The map type. Possible values include: "NotSpecified", "Xslt",
     "Xslt20", "Xslt30", "Liquid".
    :vartype map_type: str or ~azure.mgmt.logic.models.MapType
    :ivar parameters_schema: The parameters schema of integration account map.
    :vartype parameters_schema:
     ~azure.mgmt.logic.models.IntegrationAccountMapPropertiesParametersSchema
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar content: The content.
    :vartype content: str
    :ivar content_type: The content type.
    :vartype content_type: str
    :ivar content_link: The content link.
    :vartype content_link: ~azure.mgmt.logic.models.ContentLink
    :ivar metadata: The metadata.
    :vartype metadata: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'map_type': {'required': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'content_link': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'map_type': {'key': 'properties.mapType', 'type': 'str'},
        'parameters_schema': {'key': 'properties.parametersSchema', 'type': 'IntegrationAccountMapPropertiesParametersSchema'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'content': {'key': 'properties.content', 'type': 'str'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        map_type: Union[str, "MapType"],
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        parameters_schema: Optional["IntegrationAccountMapPropertiesParametersSchema"] = None,
        content: Optional[str] = None,
        content_type: Optional[str] = None,
        metadata: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword map_type: Required. The map type. Possible values include: "NotSpecified", "Xslt",
         "Xslt20", "Xslt30", "Liquid".
        :paramtype map_type: str or ~azure.mgmt.logic.models.MapType
        :keyword parameters_schema: The parameters schema of integration account map.
        :paramtype parameters_schema:
         ~azure.mgmt.logic.models.IntegrationAccountMapPropertiesParametersSchema
        :keyword content: The content.
        :paramtype content: str
        :keyword content_type: The content type.
        :paramtype content_type: str
        :keyword metadata: The metadata.
        :paramtype metadata: any
        """
        super(IntegrationAccountMap, self).__init__(location=location, tags=tags, **kwargs)
        self.map_type = map_type
        self.parameters_schema = parameters_schema
        self.created_time = None
        self.changed_time = None
        self.content = content
        self.content_type = content_type
        self.content_link = None
        self.metadata = metadata


class IntegrationAccountMapFilter(msrest.serialization.Model):
    """The integration account map filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :ivar map_type: Required. The map type of integration account map. Possible values include:
     "NotSpecified", "Xslt", "Xslt20", "Xslt30", "Liquid".
    :vartype map_type: str or ~azure.mgmt.logic.models.MapType
    """

    _validation = {
        'map_type': {'required': True},
    }

    _attribute_map = {
        'map_type': {'key': 'mapType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        map_type: Union[str, "MapType"],
        **kwargs
    ):
        """
        :keyword map_type: Required. The map type of integration account map. Possible values include:
         "NotSpecified", "Xslt", "Xslt20", "Xslt30", "Liquid".
        :paramtype map_type: str or ~azure.mgmt.logic.models.MapType
        """
        super(IntegrationAccountMapFilter, self).__init__(**kwargs)
        self.map_type = map_type


class IntegrationAccountMapListResult(msrest.serialization.Model):
    """The list of integration account maps.

    :ivar value: The list of integration account maps.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationAccountMap]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountMap]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountMap"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of integration account maps.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationAccountMap]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationAccountMapListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountMapPropertiesParametersSchema(msrest.serialization.Model):
    """The parameters schema of integration account map.

    :ivar ref: The reference name.
    :vartype ref: str
    """

    _attribute_map = {
        'ref': {'key': 'ref', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ref: The reference name.
        :paramtype ref: str
        """
        super(IntegrationAccountMapPropertiesParametersSchema, self).__init__(**kwargs)
        self.ref = ref


class IntegrationAccountPartner(Resource):
    """The integration account partner.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar partner_type: Required. The partner type. Possible values include: "NotSpecified", "B2B".
    :vartype partner_type: str or ~azure.mgmt.logic.models.PartnerType
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar metadata: The metadata.
    :vartype metadata: any
    :ivar content: Required. The partner content.
    :vartype content: ~azure.mgmt.logic.models.PartnerContent
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'partner_type': {'required': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'partner_type': {'key': 'properties.partnerType', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'content': {'key': 'properties.content', 'type': 'PartnerContent'},
    }

    def __init__(
        self,
        *,
        partner_type: Union[str, "PartnerType"],
        content: "PartnerContent",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        metadata: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword partner_type: Required. The partner type. Possible values include: "NotSpecified",
         "B2B".
        :paramtype partner_type: str or ~azure.mgmt.logic.models.PartnerType
        :keyword metadata: The metadata.
        :paramtype metadata: any
        :keyword content: Required. The partner content.
        :paramtype content: ~azure.mgmt.logic.models.PartnerContent
        """
        super(IntegrationAccountPartner, self).__init__(location=location, tags=tags, **kwargs)
        self.partner_type = partner_type
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.content = content


class IntegrationAccountPartnerFilter(msrest.serialization.Model):
    """The integration account partner filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :ivar partner_type: Required. The partner type of integration account partner. Possible values
     include: "NotSpecified", "B2B".
    :vartype partner_type: str or ~azure.mgmt.logic.models.PartnerType
    """

    _validation = {
        'partner_type': {'required': True},
    }

    _attribute_map = {
        'partner_type': {'key': 'partnerType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        partner_type: Union[str, "PartnerType"],
        **kwargs
    ):
        """
        :keyword partner_type: Required. The partner type of integration account partner. Possible
         values include: "NotSpecified", "B2B".
        :paramtype partner_type: str or ~azure.mgmt.logic.models.PartnerType
        """
        super(IntegrationAccountPartnerFilter, self).__init__(**kwargs)
        self.partner_type = partner_type


class IntegrationAccountPartnerListResult(msrest.serialization.Model):
    """The list of integration account partners.

    :ivar value: The list of integration account partners.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationAccountPartner]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountPartner]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountPartner"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of integration account partners.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationAccountPartner]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationAccountPartnerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountSchema(Resource):
    """The integration account schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar schema_type: Required. The schema type. Possible values include: "NotSpecified", "Xml".
    :vartype schema_type: str or ~azure.mgmt.logic.models.SchemaType
    :ivar target_namespace: The target namespace of the schema.
    :vartype target_namespace: str
    :ivar document_name: The document name.
    :vartype document_name: str
    :ivar file_name: The file name.
    :vartype file_name: str
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar metadata: The metadata.
    :vartype metadata: any
    :ivar content: The content.
    :vartype content: str
    :ivar content_type: The content type.
    :vartype content_type: str
    :ivar content_link: The content link.
    :vartype content_link: ~azure.mgmt.logic.models.ContentLink
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'schema_type': {'required': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'content_link': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'schema_type': {'key': 'properties.schemaType', 'type': 'str'},
        'target_namespace': {'key': 'properties.targetNamespace', 'type': 'str'},
        'document_name': {'key': 'properties.documentName', 'type': 'str'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'content': {'key': 'properties.content', 'type': 'str'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'content_link': {'key': 'properties.contentLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        schema_type: Union[str, "SchemaType"],
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        target_namespace: Optional[str] = None,
        document_name: Optional[str] = None,
        file_name: Optional[str] = None,
        metadata: Optional[Any] = None,
        content: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword schema_type: Required. The schema type. Possible values include: "NotSpecified",
         "Xml".
        :paramtype schema_type: str or ~azure.mgmt.logic.models.SchemaType
        :keyword target_namespace: The target namespace of the schema.
        :paramtype target_namespace: str
        :keyword document_name: The document name.
        :paramtype document_name: str
        :keyword file_name: The file name.
        :paramtype file_name: str
        :keyword metadata: The metadata.
        :paramtype metadata: any
        :keyword content: The content.
        :paramtype content: str
        :keyword content_type: The content type.
        :paramtype content_type: str
        """
        super(IntegrationAccountSchema, self).__init__(location=location, tags=tags, **kwargs)
        self.schema_type = schema_type
        self.target_namespace = target_namespace
        self.document_name = document_name
        self.file_name = file_name
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.content = content
        self.content_type = content_type
        self.content_link = None


class IntegrationAccountSchemaFilter(msrest.serialization.Model):
    """The integration account schema filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :ivar schema_type: Required. The schema type of integration account schema. Possible values
     include: "NotSpecified", "Xml".
    :vartype schema_type: str or ~azure.mgmt.logic.models.SchemaType
    """

    _validation = {
        'schema_type': {'required': True},
    }

    _attribute_map = {
        'schema_type': {'key': 'schemaType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        schema_type: Union[str, "SchemaType"],
        **kwargs
    ):
        """
        :keyword schema_type: Required. The schema type of integration account schema. Possible values
         include: "NotSpecified", "Xml".
        :paramtype schema_type: str or ~azure.mgmt.logic.models.SchemaType
        """
        super(IntegrationAccountSchemaFilter, self).__init__(**kwargs)
        self.schema_type = schema_type


class IntegrationAccountSchemaListResult(msrest.serialization.Model):
    """The list of integration account schemas.

    :ivar value: The list of integration account schemas.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationAccountSchema]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountSchema]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountSchema"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of integration account schemas.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationAccountSchema]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationAccountSchemaListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountSession(Resource):
    """The integration account session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar created_time: The created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar content: The session content.
    :vartype content: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'content': {'key': 'properties.content', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        content: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword content: The session content.
        :paramtype content: any
        """
        super(IntegrationAccountSession, self).__init__(location=location, tags=tags, **kwargs)
        self.created_time = None
        self.changed_time = None
        self.content = content


class IntegrationAccountSessionFilter(msrest.serialization.Model):
    """The integration account session filter.

    All required parameters must be populated in order to send to Azure.

    :ivar changed_time: Required. The changed time of integration account sessions.
    :vartype changed_time: ~datetime.datetime
    """

    _validation = {
        'changed_time': {'required': True},
    }

    _attribute_map = {
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        changed_time: datetime.datetime,
        **kwargs
    ):
        """
        :keyword changed_time: Required. The changed time of integration account sessions.
        :paramtype changed_time: ~datetime.datetime
        """
        super(IntegrationAccountSessionFilter, self).__init__(**kwargs)
        self.changed_time = changed_time


class IntegrationAccountSessionListResult(msrest.serialization.Model):
    """The list of integration account sessions.

    :ivar value: The list of integration account sessions.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationAccountSession]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationAccountSession]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationAccountSession"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of integration account sessions.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationAccountSession]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationAccountSessionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationAccountSku(msrest.serialization.Model):
    """The integration account sku.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The sku name. Possible values include: "NotSpecified", "Free", "Basic",
     "Standard".
    :vartype name: str or ~azure.mgmt.logic.models.IntegrationAccountSkuName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "IntegrationAccountSkuName"],
        **kwargs
    ):
        """
        :keyword name: Required. The sku name. Possible values include: "NotSpecified", "Free",
         "Basic", "Standard".
        :paramtype name: str or ~azure.mgmt.logic.models.IntegrationAccountSkuName
        """
        super(IntegrationAccountSku, self).__init__(**kwargs)
        self.name = name


class IntegrationServiceEnvironmenEncryptionConfiguration(msrest.serialization.Model):
    """The encryption configuration for the integration service environment.

    :ivar encryption_key_reference: The encryption key reference.
    :vartype encryption_key_reference:
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmenEncryptionKeyReference
    """

    _attribute_map = {
        'encryption_key_reference': {'key': 'encryptionKeyReference', 'type': 'IntegrationServiceEnvironmenEncryptionKeyReference'},
    }

    def __init__(
        self,
        *,
        encryption_key_reference: Optional["IntegrationServiceEnvironmenEncryptionKeyReference"] = None,
        **kwargs
    ):
        """
        :keyword encryption_key_reference: The encryption key reference.
        :paramtype encryption_key_reference:
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmenEncryptionKeyReference
        """
        super(IntegrationServiceEnvironmenEncryptionConfiguration, self).__init__(**kwargs)
        self.encryption_key_reference = encryption_key_reference


class IntegrationServiceEnvironmenEncryptionKeyReference(msrest.serialization.Model):
    """The encryption key details for the integration service environment.

    :ivar key_vault: The key vault reference.
    :vartype key_vault: ~azure.mgmt.logic.models.ResourceReference
    :ivar key_name: Gets the key name in the Key Vault.
    :vartype key_name: str
    :ivar key_version: Gets the version of the key specified in the keyName property.
    :vartype key_version: str
    """

    _attribute_map = {
        'key_vault': {'key': 'keyVault', 'type': 'ResourceReference'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault: Optional["ResourceReference"] = None,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_vault: The key vault reference.
        :paramtype key_vault: ~azure.mgmt.logic.models.ResourceReference
        :keyword key_name: Gets the key name in the Key Vault.
        :paramtype key_name: str
        :keyword key_version: Gets the version of the key specified in the keyName property.
        :paramtype key_version: str
        """
        super(IntegrationServiceEnvironmenEncryptionKeyReference, self).__init__(**kwargs)
        self.key_vault = key_vault
        self.key_name = key_name
        self.key_version = key_version


class IntegrationServiceEnvironment(Resource):
    """The integration service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The integration service environment properties.
    :vartype properties: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentProperties
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSku
    :ivar identity: Managed service identity properties.
    :vartype identity: ~azure.mgmt.logic.models.ManagedServiceIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'IntegrationServiceEnvironmentProperties'},
        'sku': {'key': 'sku', 'type': 'IntegrationServiceEnvironmentSku'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["IntegrationServiceEnvironmentProperties"] = None,
        sku: Optional["IntegrationServiceEnvironmentSku"] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The integration service environment properties.
        :paramtype properties: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentProperties
        :keyword sku: The sku.
        :paramtype sku: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSku
        :keyword identity: Managed service identity properties.
        :paramtype identity: ~azure.mgmt.logic.models.ManagedServiceIdentity
        """
        super(IntegrationServiceEnvironment, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties
        self.sku = sku
        self.identity = identity


class IntegrationServiceEnvironmentAccessEndpoint(msrest.serialization.Model):
    """The integration service environment access endpoint.

    :ivar type: The access endpoint type. Possible values include: "NotSpecified", "External",
     "Internal".
    :vartype type: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentAccessEndpointType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IntegrationServiceEnvironmentAccessEndpointType"]] = None,
        **kwargs
    ):
        """
        :keyword type: The access endpoint type. Possible values include: "NotSpecified", "External",
         "Internal".
        :paramtype type: str or
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentAccessEndpointType
        """
        super(IntegrationServiceEnvironmentAccessEndpoint, self).__init__(**kwargs)
        self.type = type


class IntegrationServiceEnvironmentListResult(msrest.serialization.Model):
    """The list of integration service environments.

    :ivar value:
    :vartype value: list[~azure.mgmt.logic.models.IntegrationServiceEnvironment]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationServiceEnvironment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationServiceEnvironment"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationServiceEnvironment]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationServiceEnvironmentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationServiceEnvironmentManagedApi(Resource):
    """The integration service environment managed api.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar name_properties_name: The name.
    :vartype name_properties_name: str
    :ivar connection_parameters: The connection parameters.
    :vartype connection_parameters: dict[str, any]
    :ivar metadata: The metadata.
    :vartype metadata: ~azure.mgmt.logic.models.ApiResourceMetadata
    :ivar runtime_urls: The runtime urls.
    :vartype runtime_urls: list[str]
    :ivar general_information: The api general information.
    :vartype general_information: ~azure.mgmt.logic.models.ApiResourceGeneralInformation
    :ivar capabilities: The capabilities.
    :vartype capabilities: list[str]
    :ivar backend_service: The backend service.
    :vartype backend_service: ~azure.mgmt.logic.models.ApiResourceBackendService
    :ivar policies: The policies for the API.
    :vartype policies: ~azure.mgmt.logic.models.ApiResourcePolicies
    :ivar api_definition_url: The API definition.
    :vartype api_definition_url: str
    :ivar api_definitions: The api definitions.
    :vartype api_definitions: ~azure.mgmt.logic.models.ApiResourceDefinitions
    :ivar integration_service_environment: The integration service environment reference.
    :vartype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    :ivar provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar category: The category. Possible values include: "NotSpecified", "Enterprise",
     "Standard", "Premium".
    :vartype category: str or ~azure.mgmt.logic.models.ApiTier
    :ivar deployment_parameters: The integration service environment managed api deployment
     parameters.
    :vartype deployment_parameters:
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentManagedApiDeploymentParameters
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'connection_parameters': {'readonly': True},
        'metadata': {'readonly': True},
        'runtime_urls': {'readonly': True},
        'general_information': {'readonly': True},
        'capabilities': {'readonly': True},
        'backend_service': {'readonly': True},
        'policies': {'readonly': True},
        'api_definition_url': {'readonly': True},
        'api_definitions': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'category': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'connection_parameters': {'key': 'properties.connectionParameters', 'type': '{object}'},
        'metadata': {'key': 'properties.metadata', 'type': 'ApiResourceMetadata'},
        'runtime_urls': {'key': 'properties.runtimeUrls', 'type': '[str]'},
        'general_information': {'key': 'properties.generalInformation', 'type': 'ApiResourceGeneralInformation'},
        'capabilities': {'key': 'properties.capabilities', 'type': '[str]'},
        'backend_service': {'key': 'properties.backendService', 'type': 'ApiResourceBackendService'},
        'policies': {'key': 'properties.policies', 'type': 'ApiResourcePolicies'},
        'api_definition_url': {'key': 'properties.apiDefinitionUrl', 'type': 'str'},
        'api_definitions': {'key': 'properties.apiDefinitions', 'type': 'ApiResourceDefinitions'},
        'integration_service_environment': {'key': 'properties.integrationServiceEnvironment', 'type': 'ResourceReference'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'deployment_parameters': {'key': 'properties.deploymentParameters', 'type': 'IntegrationServiceEnvironmentManagedApiDeploymentParameters'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        integration_service_environment: Optional["ResourceReference"] = None,
        deployment_parameters: Optional["IntegrationServiceEnvironmentManagedApiDeploymentParameters"] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword integration_service_environment: The integration service environment reference.
        :paramtype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
        :keyword deployment_parameters: The integration service environment managed api deployment
         parameters.
        :paramtype deployment_parameters:
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentManagedApiDeploymentParameters
        """
        super(IntegrationServiceEnvironmentManagedApi, self).__init__(location=location, tags=tags, **kwargs)
        self.name_properties_name = None
        self.connection_parameters = None
        self.metadata = None
        self.runtime_urls = None
        self.general_information = None
        self.capabilities = None
        self.backend_service = None
        self.policies = None
        self.api_definition_url = None
        self.api_definitions = None
        self.integration_service_environment = integration_service_environment
        self.provisioning_state = None
        self.category = None
        self.deployment_parameters = deployment_parameters


class IntegrationServiceEnvironmentManagedApiDeploymentParameters(msrest.serialization.Model):
    """The integration service environment managed api deployment parameters.

    :ivar content_link_definition: The integration service environment managed api content link for
     deployment.
    :vartype content_link_definition: ~azure.mgmt.logic.models.ContentLink
    """

    _attribute_map = {
        'content_link_definition': {'key': 'contentLinkDefinition', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        content_link_definition: Optional["ContentLink"] = None,
        **kwargs
    ):
        """
        :keyword content_link_definition: The integration service environment managed api content link
         for deployment.
        :paramtype content_link_definition: ~azure.mgmt.logic.models.ContentLink
        """
        super(IntegrationServiceEnvironmentManagedApiDeploymentParameters, self).__init__(**kwargs)
        self.content_link_definition = content_link_definition


class IntegrationServiceEnvironmentManagedApiListResult(msrest.serialization.Model):
    """The list of integration service environment managed APIs.

    :ivar value: The integration service environment managed APIs.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentManagedApi]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationServiceEnvironmentManagedApi]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationServiceEnvironmentManagedApi"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The integration service environment managed APIs.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentManagedApi]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationServiceEnvironmentManagedApiListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationServiceEnvironmentManagedApiProperties(ApiResourceProperties):
    """The integration service environment managed api properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name.
    :vartype name: str
    :ivar connection_parameters: The connection parameters.
    :vartype connection_parameters: dict[str, any]
    :ivar metadata: The metadata.
    :vartype metadata: ~azure.mgmt.logic.models.ApiResourceMetadata
    :ivar runtime_urls: The runtime urls.
    :vartype runtime_urls: list[str]
    :ivar general_information: The api general information.
    :vartype general_information: ~azure.mgmt.logic.models.ApiResourceGeneralInformation
    :ivar capabilities: The capabilities.
    :vartype capabilities: list[str]
    :ivar backend_service: The backend service.
    :vartype backend_service: ~azure.mgmt.logic.models.ApiResourceBackendService
    :ivar policies: The policies for the API.
    :vartype policies: ~azure.mgmt.logic.models.ApiResourcePolicies
    :ivar api_definition_url: The API definition.
    :vartype api_definition_url: str
    :ivar api_definitions: The api definitions.
    :vartype api_definitions: ~azure.mgmt.logic.models.ApiResourceDefinitions
    :ivar integration_service_environment: The integration service environment reference.
    :vartype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    :ivar provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar category: The category. Possible values include: "NotSpecified", "Enterprise",
     "Standard", "Premium".
    :vartype category: str or ~azure.mgmt.logic.models.ApiTier
    :ivar deployment_parameters: The integration service environment managed api deployment
     parameters.
    :vartype deployment_parameters:
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentManagedApiDeploymentParameters
    """

    _validation = {
        'name': {'readonly': True},
        'connection_parameters': {'readonly': True},
        'metadata': {'readonly': True},
        'runtime_urls': {'readonly': True},
        'general_information': {'readonly': True},
        'capabilities': {'readonly': True},
        'backend_service': {'readonly': True},
        'policies': {'readonly': True},
        'api_definition_url': {'readonly': True},
        'api_definitions': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'category': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_parameters': {'key': 'connectionParameters', 'type': '{object}'},
        'metadata': {'key': 'metadata', 'type': 'ApiResourceMetadata'},
        'runtime_urls': {'key': 'runtimeUrls', 'type': '[str]'},
        'general_information': {'key': 'generalInformation', 'type': 'ApiResourceGeneralInformation'},
        'capabilities': {'key': 'capabilities', 'type': '[str]'},
        'backend_service': {'key': 'backendService', 'type': 'ApiResourceBackendService'},
        'policies': {'key': 'policies', 'type': 'ApiResourcePolicies'},
        'api_definition_url': {'key': 'apiDefinitionUrl', 'type': 'str'},
        'api_definitions': {'key': 'apiDefinitions', 'type': 'ApiResourceDefinitions'},
        'integration_service_environment': {'key': 'integrationServiceEnvironment', 'type': 'ResourceReference'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'deployment_parameters': {'key': 'deploymentParameters', 'type': 'IntegrationServiceEnvironmentManagedApiDeploymentParameters'},
    }

    def __init__(
        self,
        *,
        integration_service_environment: Optional["ResourceReference"] = None,
        deployment_parameters: Optional["IntegrationServiceEnvironmentManagedApiDeploymentParameters"] = None,
        **kwargs
    ):
        """
        :keyword integration_service_environment: The integration service environment reference.
        :paramtype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
        :keyword deployment_parameters: The integration service environment managed api deployment
         parameters.
        :paramtype deployment_parameters:
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentManagedApiDeploymentParameters
        """
        super(IntegrationServiceEnvironmentManagedApiProperties, self).__init__(integration_service_environment=integration_service_environment, **kwargs)
        self.deployment_parameters = deployment_parameters


class IntegrationServiceEnvironmentNetworkDependency(msrest.serialization.Model):
    """The azure async operation resource.

    :ivar category: The network dependency category type. Possible values include: "NotSpecified",
     "AzureStorage", "AzureManagement", "AzureActiveDirectory", "SSLCertificateVerification",
     "DiagnosticLogsAndMetrics", "IntegrationServiceEnvironmentConnectors", "RedisCache",
     "AccessEndpoints", "RecoveryService", "SQL", "RegionalService".
    :vartype category: str or
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyCategoryType
    :ivar display_name: The display name.
    :vartype display_name: str
    :ivar endpoints: The endpoints.
    :vartype endpoints: list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndpoint]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[IntegrationServiceEnvironmentNetworkEndpoint]'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "IntegrationServiceEnvironmentNetworkDependencyCategoryType"]] = None,
        display_name: Optional[str] = None,
        endpoints: Optional[List["IntegrationServiceEnvironmentNetworkEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword category: The network dependency category type. Possible values include:
         "NotSpecified", "AzureStorage", "AzureManagement", "AzureActiveDirectory",
         "SSLCertificateVerification", "DiagnosticLogsAndMetrics",
         "IntegrationServiceEnvironmentConnectors", "RedisCache", "AccessEndpoints", "RecoveryService",
         "SQL", "RegionalService".
        :paramtype category: str or
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyCategoryType
        :keyword display_name: The display name.
        :paramtype display_name: str
        :keyword endpoints: The endpoints.
        :paramtype endpoints:
         list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndpoint]
        """
        super(IntegrationServiceEnvironmentNetworkDependency, self).__init__(**kwargs)
        self.category = category
        self.display_name = display_name
        self.endpoints = endpoints


class IntegrationServiceEnvironmentNetworkDependencyHealth(msrest.serialization.Model):
    """The integration service environment subnet network health.

    :ivar error: The error if any occurred during the operation.
    :vartype error: ~azure.mgmt.logic.models.ExtendedErrorInfo
    :ivar state: The network dependency health state. Possible values include: "NotSpecified",
     "Healthy", "Unhealthy", "Unknown".
    :vartype state: str or
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyHealthState
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ExtendedErrorInfo'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        error: Optional["ExtendedErrorInfo"] = None,
        state: Optional[Union[str, "IntegrationServiceEnvironmentNetworkDependencyHealthState"]] = None,
        **kwargs
    ):
        """
        :keyword error: The error if any occurred during the operation.
        :paramtype error: ~azure.mgmt.logic.models.ExtendedErrorInfo
        :keyword state: The network dependency health state. Possible values include: "NotSpecified",
         "Healthy", "Unhealthy", "Unknown".
        :paramtype state: str or
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyHealthState
        """
        super(IntegrationServiceEnvironmentNetworkDependencyHealth, self).__init__(**kwargs)
        self.error = error
        self.state = state


class IntegrationServiceEnvironmentNetworkEndpoint(msrest.serialization.Model):
    """The network endpoint.

    :ivar accessibility: The accessibility state. Possible values include: "NotSpecified",
     "Unknown", "Available", "NotAvailable".
    :vartype accessibility: str or
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndPointAccessibilityState
    :ivar domain_name: The domain name.
    :vartype domain_name: str
    :ivar ports: The ports.
    :vartype ports: list[str]
    """

    _attribute_map = {
        'accessibility': {'key': 'accessibility', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        accessibility: Optional[Union[str, "IntegrationServiceEnvironmentNetworkEndPointAccessibilityState"]] = None,
        domain_name: Optional[str] = None,
        ports: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword accessibility: The accessibility state. Possible values include: "NotSpecified",
         "Unknown", "Available", "NotAvailable".
        :paramtype accessibility: str or
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndPointAccessibilityState
        :keyword domain_name: The domain name.
        :paramtype domain_name: str
        :keyword ports: The ports.
        :paramtype ports: list[str]
        """
        super(IntegrationServiceEnvironmentNetworkEndpoint, self).__init__(**kwargs)
        self.accessibility = accessibility
        self.domain_name = domain_name
        self.ports = ports


class IntegrationServiceEnvironmentProperties(msrest.serialization.Model):
    """The integration service environment properties.

    :ivar provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar state: The integration service environment state. Possible values include:
     "NotSpecified", "Completed", "Enabled", "Disabled", "Deleted", "Suspended".
    :vartype state: str or ~azure.mgmt.logic.models.WorkflowState
    :ivar integration_service_environment_id: Gets the tracking id.
    :vartype integration_service_environment_id: str
    :ivar endpoints_configuration: The endpoints configuration.
    :vartype endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
    :ivar network_configuration: The network configuration.
    :vartype network_configuration: ~azure.mgmt.logic.models.NetworkConfiguration
    :ivar encryption_configuration: The encryption configuration.
    :vartype encryption_configuration:
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmenEncryptionConfiguration
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'integration_service_environment_id': {'key': 'integrationServiceEnvironmentId', 'type': 'str'},
        'endpoints_configuration': {'key': 'endpointsConfiguration', 'type': 'FlowEndpointsConfiguration'},
        'network_configuration': {'key': 'networkConfiguration', 'type': 'NetworkConfiguration'},
        'encryption_configuration': {'key': 'encryptionConfiguration', 'type': 'IntegrationServiceEnvironmenEncryptionConfiguration'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "WorkflowProvisioningState"]] = None,
        state: Optional[Union[str, "WorkflowState"]] = None,
        integration_service_environment_id: Optional[str] = None,
        endpoints_configuration: Optional["FlowEndpointsConfiguration"] = None,
        network_configuration: Optional["NetworkConfiguration"] = None,
        encryption_configuration: Optional["IntegrationServiceEnvironmenEncryptionConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: The provisioning state. Possible values include: "NotSpecified",
         "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
         "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
         "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
        :paramtype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
        :keyword state: The integration service environment state. Possible values include:
         "NotSpecified", "Completed", "Enabled", "Disabled", "Deleted", "Suspended".
        :paramtype state: str or ~azure.mgmt.logic.models.WorkflowState
        :keyword integration_service_environment_id: Gets the tracking id.
        :paramtype integration_service_environment_id: str
        :keyword endpoints_configuration: The endpoints configuration.
        :paramtype endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
        :keyword network_configuration: The network configuration.
        :paramtype network_configuration: ~azure.mgmt.logic.models.NetworkConfiguration
        :keyword encryption_configuration: The encryption configuration.
        :paramtype encryption_configuration:
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmenEncryptionConfiguration
        """
        super(IntegrationServiceEnvironmentProperties, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.state = state
        self.integration_service_environment_id = integration_service_environment_id
        self.endpoints_configuration = endpoints_configuration
        self.network_configuration = network_configuration
        self.encryption_configuration = encryption_configuration


class IntegrationServiceEnvironmentSku(msrest.serialization.Model):
    """The integration service environment sku.

    :ivar name: The sku name. Possible values include: "NotSpecified", "Premium", "Developer".
    :vartype name: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuName
    :ivar capacity: The sku capacity.
    :vartype capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "IntegrationServiceEnvironmentSkuName"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The sku name. Possible values include: "NotSpecified", "Premium", "Developer".
        :paramtype name: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuName
        :keyword capacity: The sku capacity.
        :paramtype capacity: int
        """
        super(IntegrationServiceEnvironmentSku, self).__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class IntegrationServiceEnvironmentSkuCapacity(msrest.serialization.Model):
    """The integration service environment sku capacity.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The sku scale type. Possible values include: "Manual", "Automatic", "None".
    :vartype scale_type: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuScaleType
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[Union[str, "IntegrationServiceEnvironmentSkuScaleType"]] = None,
        **kwargs
    ):
        """
        :keyword minimum: The minimum capacity.
        :paramtype minimum: int
        :keyword maximum: The maximum capacity.
        :paramtype maximum: int
        :keyword default: The default capacity.
        :paramtype default: int
        :keyword scale_type: The sku scale type. Possible values include: "Manual", "Automatic",
         "None".
        :paramtype scale_type: str or
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuScaleType
        """
        super(IntegrationServiceEnvironmentSkuCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class IntegrationServiceEnvironmentSkuDefinition(msrest.serialization.Model):
    """The integration service environment sku definition.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuDefinitionSku
    :ivar capacity: The sku capacity.
    :vartype capacity: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'IntegrationServiceEnvironmentSkuDefinitionSku'},
        'capacity': {'key': 'capacity', 'type': 'IntegrationServiceEnvironmentSkuCapacity'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        sku: Optional["IntegrationServiceEnvironmentSkuDefinitionSku"] = None,
        capacity: Optional["IntegrationServiceEnvironmentSkuCapacity"] = None,
        **kwargs
    ):
        """
        :keyword resource_type: The resource type.
        :paramtype resource_type: str
        :keyword sku: The sku.
        :paramtype sku: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuDefinitionSku
        :keyword capacity: The sku capacity.
        :paramtype capacity: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuCapacity
        """
        super(IntegrationServiceEnvironmentSkuDefinition, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku
        self.capacity = capacity


class IntegrationServiceEnvironmentSkuDefinitionSku(msrest.serialization.Model):
    """The sku.

    :ivar name: The sku name. Possible values include: "NotSpecified", "Premium", "Developer".
    :vartype name: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuName
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "IntegrationServiceEnvironmentSkuName"]] = None,
        tier: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The sku name. Possible values include: "NotSpecified", "Premium", "Developer".
        :paramtype name: str or ~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuName
        :keyword tier: The sku tier.
        :paramtype tier: str
        """
        super(IntegrationServiceEnvironmentSkuDefinitionSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class IntegrationServiceEnvironmentSkuList(msrest.serialization.Model):
    """The list of integration service environment skus.

    :ivar value: The list of integration service environment skus.
    :vartype value: list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuDefinition]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationServiceEnvironmentSkuDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IntegrationServiceEnvironmentSkuDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of integration service environment skus.
        :paramtype value: list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentSkuDefinition]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(IntegrationServiceEnvironmentSkuList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationServiceEnvironmentSubnetNetworkHealth(msrest.serialization.Model):
    """The integration service environment subnet network health.

    All required parameters must be populated in order to send to Azure.

    :ivar outbound_network_dependencies: The outbound network dependencies.
    :vartype outbound_network_dependencies:
     list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependency]
    :ivar outbound_network_health: The integration service environment network health.
    :vartype outbound_network_health:
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyHealth
    :ivar network_dependency_health_state: Required. The integration service environment network
     health state. Possible values include: "NotSpecified", "Unknown", "Available", "NotAvailable".
    :vartype network_dependency_health_state: str or
     ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndPointAccessibilityState
    """

    _validation = {
        'network_dependency_health_state': {'required': True},
    }

    _attribute_map = {
        'outbound_network_dependencies': {'key': 'outboundNetworkDependencies', 'type': '[IntegrationServiceEnvironmentNetworkDependency]'},
        'outbound_network_health': {'key': 'outboundNetworkHealth', 'type': 'IntegrationServiceEnvironmentNetworkDependencyHealth'},
        'network_dependency_health_state': {'key': 'networkDependencyHealthState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        network_dependency_health_state: Union[str, "IntegrationServiceEnvironmentNetworkEndPointAccessibilityState"],
        outbound_network_dependencies: Optional[List["IntegrationServiceEnvironmentNetworkDependency"]] = None,
        outbound_network_health: Optional["IntegrationServiceEnvironmentNetworkDependencyHealth"] = None,
        **kwargs
    ):
        """
        :keyword outbound_network_dependencies: The outbound network dependencies.
        :paramtype outbound_network_dependencies:
         list[~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependency]
        :keyword outbound_network_health: The integration service environment network health.
        :paramtype outbound_network_health:
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkDependencyHealth
        :keyword network_dependency_health_state: Required. The integration service environment network
         health state. Possible values include: "NotSpecified", "Unknown", "Available", "NotAvailable".
        :paramtype network_dependency_health_state: str or
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentNetworkEndPointAccessibilityState
        """
        super(IntegrationServiceEnvironmentSubnetNetworkHealth, self).__init__(**kwargs)
        self.outbound_network_dependencies = outbound_network_dependencies
        self.outbound_network_health = outbound_network_health
        self.network_dependency_health_state = network_dependency_health_state


class IpAddress(msrest.serialization.Model):
    """The ip address.

    :ivar address: The address.
    :vartype address: str
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword address: The address.
        :paramtype address: str
        """
        super(IpAddress, self).__init__(**kwargs)
        self.address = address


class IpAddressRange(msrest.serialization.Model):
    """The ip address range.

    :ivar address_range: The IP address range.
    :vartype address_range: str
    """

    _attribute_map = {
        'address_range': {'key': 'addressRange', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address_range: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword address_range: The IP address range.
        :paramtype address_range: str
        """
        super(IpAddressRange, self).__init__(**kwargs)
        self.address_range = address_range


class JsonSchema(msrest.serialization.Model):
    """The JSON schema.

    :ivar title: The JSON title.
    :vartype title: str
    :ivar content: The JSON content.
    :vartype content: str
    """

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        content: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword title: The JSON title.
        :paramtype title: str
        :keyword content: The JSON content.
        :paramtype content: str
        """
        super(JsonSchema, self).__init__(**kwargs)
        self.title = title
        self.content = content


class KeyVaultKey(msrest.serialization.Model):
    """The key vault key.

    :ivar kid: The key id.
    :vartype kid: str
    :ivar attributes: The key attributes.
    :vartype attributes: ~azure.mgmt.logic.models.KeyVaultKeyAttributes
    """

    _attribute_map = {
        'kid': {'key': 'kid', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'KeyVaultKeyAttributes'},
    }

    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        attributes: Optional["KeyVaultKeyAttributes"] = None,
        **kwargs
    ):
        """
        :keyword kid: The key id.
        :paramtype kid: str
        :keyword attributes: The key attributes.
        :paramtype attributes: ~azure.mgmt.logic.models.KeyVaultKeyAttributes
        """
        super(KeyVaultKey, self).__init__(**kwargs)
        self.kid = kid
        self.attributes = attributes


class KeyVaultKeyAttributes(msrest.serialization.Model):
    """The key attributes.

    :ivar enabled: Whether the key is enabled or not.
    :vartype enabled: bool
    :ivar created: When the key was created.
    :vartype created: long
    :ivar updated: When the key was updated.
    :vartype updated: long
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'long'},
        'updated': {'key': 'updated', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        created: Optional[int] = None,
        updated: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword enabled: Whether the key is enabled or not.
        :paramtype enabled: bool
        :keyword created: When the key was created.
        :paramtype created: long
        :keyword updated: When the key was updated.
        :paramtype updated: long
        """
        super(KeyVaultKeyAttributes, self).__init__(**kwargs)
        self.enabled = enabled
        self.created = created
        self.updated = updated


class KeyVaultKeyCollection(msrest.serialization.Model):
    """Collection of key vault keys.

    :ivar value: The key vault keys.
    :vartype value: list[~azure.mgmt.logic.models.KeyVaultKey]
    :ivar skip_token: The skip token.
    :vartype skip_token: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[KeyVaultKey]'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["KeyVaultKey"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The key vault keys.
        :paramtype value: list[~azure.mgmt.logic.models.KeyVaultKey]
        :keyword skip_token: The skip token.
        :paramtype skip_token: str
        """
        super(KeyVaultKeyCollection, self).__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class KeyVaultKeyReference(msrest.serialization.Model):
    """The reference to the key vault key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault: Required. The key vault reference.
    :vartype key_vault: ~azure.mgmt.logic.models.KeyVaultKeyReferenceKeyVault
    :ivar key_name: Required. The private key name in key vault.
    :vartype key_name: str
    :ivar key_version: The private key version in key vault.
    :vartype key_version: str
    """

    _validation = {
        'key_vault': {'required': True},
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultKeyReferenceKeyVault'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault: "KeyVaultKeyReferenceKeyVault",
        key_name: str,
        key_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_vault: Required. The key vault reference.
        :paramtype key_vault: ~azure.mgmt.logic.models.KeyVaultKeyReferenceKeyVault
        :keyword key_name: Required. The private key name in key vault.
        :paramtype key_name: str
        :keyword key_version: The private key version in key vault.
        :paramtype key_version: str
        """
        super(KeyVaultKeyReference, self).__init__(**kwargs)
        self.key_vault = key_vault
        self.key_name = key_name
        self.key_version = key_version


class KeyVaultKeyReferenceKeyVault(msrest.serialization.Model):
    """The key vault reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The resource id.
        :paramtype id: str
        """
        super(KeyVaultKeyReferenceKeyVault, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class KeyVaultReference(ResourceReference):
    """The key vault reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The resource id.
        :paramtype id: str
        """
        super(KeyVaultReference, self).__init__(id=id, **kwargs)


class ListKeyVaultKeysDefinition(msrest.serialization.Model):
    """The list key vault keys definition.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault: Required. The key vault reference.
    :vartype key_vault: ~azure.mgmt.logic.models.KeyVaultReference
    :ivar skip_token: The skip token.
    :vartype skip_token: str
    """

    _validation = {
        'key_vault': {'required': True},
    }

    _attribute_map = {
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultReference'},
        'skip_token': {'key': 'skipToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault: "KeyVaultReference",
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_vault: Required. The key vault reference.
        :paramtype key_vault: ~azure.mgmt.logic.models.KeyVaultReference
        :keyword skip_token: The skip token.
        :paramtype skip_token: str
        """
        super(ListKeyVaultKeysDefinition, self).__init__(**kwargs)
        self.key_vault = key_vault
        self.skip_token = skip_token


class ManagedApi(Resource):
    """The managed api definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The api resource properties.
    :vartype properties: ~azure.mgmt.logic.models.ApiResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ApiResourceProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["ApiResourceProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The api resource properties.
        :paramtype properties: ~azure.mgmt.logic.models.ApiResourceProperties
        """
        super(ManagedApi, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class ManagedApiListResult(msrest.serialization.Model):
    """The list of managed APIs.

    :ivar value: The managed APIs.
    :vartype value: list[~azure.mgmt.logic.models.ManagedApi]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedApi]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedApi"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The managed APIs.
        :paramtype value: list[~azure.mgmt.logic.models.ManagedApi]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(ManagedApiListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Type of managed service identity. The type 'SystemAssigned' includes an
     implicitly created identity. The type 'None' will remove any identities from the resource.
     Possible values include: "SystemAssigned", "UserAssigned", "None".
    :vartype type: str or ~azure.mgmt.logic.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    :ivar user_assigned_identities: The list of user assigned identities associated with the
     resource. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.logic.models.UserAssignedIdentity]
    """

    _validation = {
        'type': {'required': True},
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. Type of managed service identity. The type 'SystemAssigned' includes
         an implicitly created identity. The type 'None' will remove any identities from the resource.
         Possible values include: "SystemAssigned", "UserAssigned", "None".
        :paramtype type: str or ~azure.mgmt.logic.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The list of user assigned identities associated with the
         resource. The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.logic.models.UserAssignedIdentity]
        """
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None
        self.user_assigned_identities = user_assigned_identities


class NetworkConfiguration(msrest.serialization.Model):
    """The network configuration.

    :ivar virtual_network_address_space: Gets the virtual network address space.
    :vartype virtual_network_address_space: str
    :ivar access_endpoint: The access endpoint.
    :vartype access_endpoint: ~azure.mgmt.logic.models.IntegrationServiceEnvironmentAccessEndpoint
    :ivar subnets: The subnets.
    :vartype subnets: list[~azure.mgmt.logic.models.ResourceReference]
    """

    _attribute_map = {
        'virtual_network_address_space': {'key': 'virtualNetworkAddressSpace', 'type': 'str'},
        'access_endpoint': {'key': 'accessEndpoint', 'type': 'IntegrationServiceEnvironmentAccessEndpoint'},
        'subnets': {'key': 'subnets', 'type': '[ResourceReference]'},
    }

    def __init__(
        self,
        *,
        virtual_network_address_space: Optional[str] = None,
        access_endpoint: Optional["IntegrationServiceEnvironmentAccessEndpoint"] = None,
        subnets: Optional[List["ResourceReference"]] = None,
        **kwargs
    ):
        """
        :keyword virtual_network_address_space: Gets the virtual network address space.
        :paramtype virtual_network_address_space: str
        :keyword access_endpoint: The access endpoint.
        :paramtype access_endpoint:
         ~azure.mgmt.logic.models.IntegrationServiceEnvironmentAccessEndpoint
        :keyword subnets: The subnets.
        :paramtype subnets: list[~azure.mgmt.logic.models.ResourceReference]
        """
        super(NetworkConfiguration, self).__init__(**kwargs)
        self.virtual_network_address_space = virtual_network_address_space
        self.access_endpoint = access_endpoint
        self.subnets = subnets


class OpenAuthenticationAccessPolicies(msrest.serialization.Model):
    """AuthenticationPolicy of type Open.

    :ivar policies: Open authentication policies.
    :vartype policies: dict[str, ~azure.mgmt.logic.models.OpenAuthenticationAccessPolicy]
    """

    _attribute_map = {
        'policies': {'key': 'policies', 'type': '{OpenAuthenticationAccessPolicy}'},
    }

    def __init__(
        self,
        *,
        policies: Optional[Dict[str, "OpenAuthenticationAccessPolicy"]] = None,
        **kwargs
    ):
        """
        :keyword policies: Open authentication policies.
        :paramtype policies: dict[str, ~azure.mgmt.logic.models.OpenAuthenticationAccessPolicy]
        """
        super(OpenAuthenticationAccessPolicies, self).__init__(**kwargs)
        self.policies = policies


class OpenAuthenticationAccessPolicy(msrest.serialization.Model):
    """Open authentication access policy defined by user.

    :ivar type: Type of provider for OAuth. Possible values include: "AAD".
    :vartype type: str or ~azure.mgmt.logic.models.OpenAuthenticationProviderType
    :ivar claims: The access policy claims.
    :vartype claims: list[~azure.mgmt.logic.models.OpenAuthenticationPolicyClaim]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'claims': {'key': 'claims', 'type': '[OpenAuthenticationPolicyClaim]'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "OpenAuthenticationProviderType"]] = None,
        claims: Optional[List["OpenAuthenticationPolicyClaim"]] = None,
        **kwargs
    ):
        """
        :keyword type: Type of provider for OAuth. Possible values include: "AAD".
        :paramtype type: str or ~azure.mgmt.logic.models.OpenAuthenticationProviderType
        :keyword claims: The access policy claims.
        :paramtype claims: list[~azure.mgmt.logic.models.OpenAuthenticationPolicyClaim]
        """
        super(OpenAuthenticationAccessPolicy, self).__init__(**kwargs)
        self.type = type
        self.claims = claims


class OpenAuthenticationPolicyClaim(msrest.serialization.Model):
    """Open authentication policy claim.

    :ivar name: The name of the claim.
    :vartype name: str
    :ivar value: The value of the claim.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the claim.
        :paramtype name: str
        :keyword value: The value of the claim.
        :paramtype value: str
        """
        super(OpenAuthenticationPolicyClaim, self).__init__(**kwargs)
        self.name = name
        self.value = value


class Operation(msrest.serialization.Model):
    """Logic REST API operation.

    :ivar origin: Operation: origin.
    :vartype origin: str
    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.logic.models.OperationDisplay
    :ivar properties: The properties.
    :vartype properties: any
    """

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        origin: Optional[str] = None,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword origin: Operation: origin.
        :paramtype origin: str
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.logic.models.OperationDisplay
        :keyword properties: The properties.
        :paramtype properties: any
        """
        super(Operation, self).__init__(**kwargs)
        self.origin = origin
        self.name = name
        self.display = display
        self.properties = properties


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Logic.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Operation: description.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.Logic.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Operation: description.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Logic operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Logic operations supported by the Logic resource provider.
    :vartype value: list[~azure.mgmt.logic.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of Logic operations supported by the Logic resource provider.
        :paramtype value: list[~azure.mgmt.logic.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResultProperties(msrest.serialization.Model):
    """The run operation result properties.

    :ivar start_time: The start time of the workflow scope repetition.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the workflow scope repetition.
    :vartype end_time: ~datetime.datetime
    :ivar correlation: The correlation properties.
    :vartype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :ivar status: The status of the workflow scope repetition. Possible values include:
     "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
     "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: The workflow scope repetition code.
    :vartype code: str
    :ivar error: Anything.
    :vartype error: any
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'correlation': {'key': 'correlation', 'type': 'RunActionCorrelation'},
        'status': {'key': 'status', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["RunActionCorrelation"] = None,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start time of the workflow scope repetition.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the workflow scope repetition.
        :paramtype end_time: ~datetime.datetime
        :keyword correlation: The correlation properties.
        :paramtype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
        :keyword status: The status of the workflow scope repetition. Possible values include:
         "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
         "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
        :paramtype status: str or ~azure.mgmt.logic.models.WorkflowStatus
        :keyword code: The workflow scope repetition code.
        :paramtype code: str
        :keyword error: Anything.
        :paramtype error: any
        """
        super(OperationResultProperties, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.correlation = correlation
        self.status = status
        self.code = code
        self.error = error


class OperationResult(OperationResultProperties):
    """The operation result definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: The start time of the workflow scope repetition.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the workflow scope repetition.
    :vartype end_time: ~datetime.datetime
    :ivar correlation: The correlation properties.
    :vartype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :ivar status: The status of the workflow scope repetition. Possible values include:
     "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
     "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: The workflow scope repetition code.
    :vartype code: str
    :ivar error: Anything.
    :vartype error: any
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: any
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: any
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: any
    :ivar retry_history: Gets the retry histories.
    :vartype retry_history: list[~azure.mgmt.logic.models.RetryHistory]
    :ivar iteration_count:
    :vartype iteration_count: int
    """

    _validation = {
        'tracking_id': {'readonly': True},
        'inputs': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs': {'readonly': True},
        'outputs_link': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'correlation': {'key': 'correlation', 'type': 'RunActionCorrelation'},
        'status': {'key': 'status', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': 'object'},
        'inputs_link': {'key': 'inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'outputs_link': {'key': 'outputsLink', 'type': 'ContentLink'},
        'tracked_properties': {'key': 'trackedProperties', 'type': 'object'},
        'retry_history': {'key': 'retryHistory', 'type': '[RetryHistory]'},
        'iteration_count': {'key': 'iterationCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["RunActionCorrelation"] = None,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[Any] = None,
        retry_history: Optional[List["RetryHistory"]] = None,
        iteration_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start time of the workflow scope repetition.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the workflow scope repetition.
        :paramtype end_time: ~datetime.datetime
        :keyword correlation: The correlation properties.
        :paramtype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
        :keyword status: The status of the workflow scope repetition. Possible values include:
         "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
         "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
        :paramtype status: str or ~azure.mgmt.logic.models.WorkflowStatus
        :keyword code: The workflow scope repetition code.
        :paramtype code: str
        :keyword error: Anything.
        :paramtype error: any
        :keyword retry_history: Gets the retry histories.
        :paramtype retry_history: list[~azure.mgmt.logic.models.RetryHistory]
        :keyword iteration_count:
        :paramtype iteration_count: int
        """
        super(OperationResult, self).__init__(start_time=start_time, end_time=end_time, correlation=correlation, status=status, code=code, error=error, **kwargs)
        self.tracking_id = None
        self.inputs = None
        self.inputs_link = None
        self.outputs = None
        self.outputs_link = None
        self.tracked_properties = None
        self.retry_history = retry_history
        self.iteration_count = iteration_count


class PartnerContent(msrest.serialization.Model):
    """The integration account partner content.

    :ivar b2_b: The B2B partner content.
    :vartype b2_b: ~azure.mgmt.logic.models.B2BPartnerContent
    """

    _attribute_map = {
        'b2_b': {'key': 'b2b', 'type': 'B2BPartnerContent'},
    }

    def __init__(
        self,
        *,
        b2_b: Optional["B2BPartnerContent"] = None,
        **kwargs
    ):
        """
        :keyword b2_b: The B2B partner content.
        :paramtype b2_b: ~azure.mgmt.logic.models.B2BPartnerContent
        """
        super(PartnerContent, self).__init__(**kwargs)
        self.b2_b = b2_b


class RecurrenceSchedule(msrest.serialization.Model):
    """The recurrence schedule.

    :ivar minutes: The minutes.
    :vartype minutes: list[int]
    :ivar hours: The hours.
    :vartype hours: list[int]
    :ivar week_days: The days of the week.
    :vartype week_days: list[str or ~azure.mgmt.logic.models.DaysOfWeek]
    :ivar month_days: The month days.
    :vartype month_days: list[int]
    :ivar monthly_occurrences: The monthly occurrences.
    :vartype monthly_occurrences: list[~azure.mgmt.logic.models.RecurrenceScheduleOccurrence]
    """

    _attribute_map = {
        'minutes': {'key': 'minutes', 'type': '[int]'},
        'hours': {'key': 'hours', 'type': '[int]'},
        'week_days': {'key': 'weekDays', 'type': '[str]'},
        'month_days': {'key': 'monthDays', 'type': '[int]'},
        'monthly_occurrences': {'key': 'monthlyOccurrences', 'type': '[RecurrenceScheduleOccurrence]'},
    }

    def __init__(
        self,
        *,
        minutes: Optional[List[int]] = None,
        hours: Optional[List[int]] = None,
        week_days: Optional[List[Union[str, "DaysOfWeek"]]] = None,
        month_days: Optional[List[int]] = None,
        monthly_occurrences: Optional[List["RecurrenceScheduleOccurrence"]] = None,
        **kwargs
    ):
        """
        :keyword minutes: The minutes.
        :paramtype minutes: list[int]
        :keyword hours: The hours.
        :paramtype hours: list[int]
        :keyword week_days: The days of the week.
        :paramtype week_days: list[str or ~azure.mgmt.logic.models.DaysOfWeek]
        :keyword month_days: The month days.
        :paramtype month_days: list[int]
        :keyword monthly_occurrences: The monthly occurrences.
        :paramtype monthly_occurrences: list[~azure.mgmt.logic.models.RecurrenceScheduleOccurrence]
        """
        super(RecurrenceSchedule, self).__init__(**kwargs)
        self.minutes = minutes
        self.hours = hours
        self.week_days = week_days
        self.month_days = month_days
        self.monthly_occurrences = monthly_occurrences


class RecurrenceScheduleOccurrence(msrest.serialization.Model):
    """The recurrence schedule occurrence.

    :ivar day: The day of the week. Possible values include: "Sunday", "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", "Saturday".
    :vartype day: str or ~azure.mgmt.logic.models.DayOfWeek
    :ivar occurrence: The occurrence.
    :vartype occurrence: int
    """

    _attribute_map = {
        'day': {'key': 'day', 'type': 'str'},
        'occurrence': {'key': 'occurrence', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        day: Optional[Union[str, "DayOfWeek"]] = None,
        occurrence: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword day: The day of the week. Possible values include: "Sunday", "Monday", "Tuesday",
         "Wednesday", "Thursday", "Friday", "Saturday".
        :paramtype day: str or ~azure.mgmt.logic.models.DayOfWeek
        :keyword occurrence: The occurrence.
        :paramtype occurrence: int
        """
        super(RecurrenceScheduleOccurrence, self).__init__(**kwargs)
        self.day = day
        self.occurrence = occurrence


class RegenerateActionParameter(msrest.serialization.Model):
    """The access key regenerate action content.

    :ivar key_type: The key type. Possible values include: "NotSpecified", "Primary", "Secondary".
    :vartype key_type: str or ~azure.mgmt.logic.models.KeyType
    """

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_type: Optional[Union[str, "KeyType"]] = None,
        **kwargs
    ):
        """
        :keyword key_type: The key type. Possible values include: "NotSpecified", "Primary",
         "Secondary".
        :paramtype key_type: str or ~azure.mgmt.logic.models.KeyType
        """
        super(RegenerateActionParameter, self).__init__(**kwargs)
        self.key_type = key_type


class RepetitionIndex(msrest.serialization.Model):
    """The workflow run action repetition index.

    All required parameters must be populated in order to send to Azure.

    :ivar scope_name: The scope.
    :vartype scope_name: str
    :ivar item_index: Required. The index.
    :vartype item_index: int
    """

    _validation = {
        'item_index': {'required': True},
    }

    _attribute_map = {
        'scope_name': {'key': 'scopeName', 'type': 'str'},
        'item_index': {'key': 'itemIndex', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        item_index: int,
        scope_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword scope_name: The scope.
        :paramtype scope_name: str
        :keyword item_index: Required. The index.
        :paramtype item_index: int
        """
        super(RepetitionIndex, self).__init__(**kwargs)
        self.scope_name = scope_name
        self.item_index = item_index


class Request(msrest.serialization.Model):
    """A request.

    :ivar headers: A list of all the headers attached to the request.
    :vartype headers: any
    :ivar uri: The destination for the request.
    :vartype uri: str
    :ivar method: The HTTP method used for the request.
    :vartype method: str
    """

    _attribute_map = {
        'headers': {'key': 'headers', 'type': 'object'},
        'uri': {'key': 'uri', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        headers: Optional[Any] = None,
        uri: Optional[str] = None,
        method: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword headers: A list of all the headers attached to the request.
        :paramtype headers: any
        :keyword uri: The destination for the request.
        :paramtype uri: str
        :keyword method: The HTTP method used for the request.
        :paramtype method: str
        """
        super(Request, self).__init__(**kwargs)
        self.headers = headers
        self.uri = uri
        self.method = method


class RequestHistory(Resource):
    """The request history.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The request history properties.
    :vartype properties: ~azure.mgmt.logic.models.RequestHistoryProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'RequestHistoryProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["RequestHistoryProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The request history properties.
        :paramtype properties: ~azure.mgmt.logic.models.RequestHistoryProperties
        """
        super(RequestHistory, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class RequestHistoryListResult(msrest.serialization.Model):
    """The list of workflow request histories.

    :ivar value: A list of workflow request histories.
    :vartype value: list[~azure.mgmt.logic.models.RequestHistory]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RequestHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RequestHistory"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of workflow request histories.
        :paramtype value: list[~azure.mgmt.logic.models.RequestHistory]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(RequestHistoryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RequestHistoryProperties(msrest.serialization.Model):
    """The request history.

    :ivar start_time: The time the request started.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time the request ended.
    :vartype end_time: ~datetime.datetime
    :ivar request: The request.
    :vartype request: ~azure.mgmt.logic.models.Request
    :ivar response: The response.
    :vartype response: ~azure.mgmt.logic.models.Response
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'request': {'key': 'request', 'type': 'Request'},
        'response': {'key': 'response', 'type': 'Response'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        request: Optional["Request"] = None,
        response: Optional["Response"] = None,
        **kwargs
    ):
        """
        :keyword start_time: The time the request started.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The time the request ended.
        :paramtype end_time: ~datetime.datetime
        :keyword request: The request.
        :paramtype request: ~azure.mgmt.logic.models.Request
        :keyword response: The response.
        :paramtype response: ~azure.mgmt.logic.models.Response
        """
        super(RequestHistoryProperties, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.request = request
        self.response = response


class Response(msrest.serialization.Model):
    """A response.

    :ivar headers: A list of all the headers attached to the response.
    :vartype headers: any
    :ivar status_code: The status code of the response.
    :vartype status_code: int
    :ivar body_link: Details on the location of the body content.
    :vartype body_link: ~azure.mgmt.logic.models.ContentLink
    """

    _attribute_map = {
        'headers': {'key': 'headers', 'type': 'object'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'body_link': {'key': 'bodyLink', 'type': 'ContentLink'},
    }

    def __init__(
        self,
        *,
        headers: Optional[Any] = None,
        status_code: Optional[int] = None,
        body_link: Optional["ContentLink"] = None,
        **kwargs
    ):
        """
        :keyword headers: A list of all the headers attached to the response.
        :paramtype headers: any
        :keyword status_code: The status code of the response.
        :paramtype status_code: int
        :keyword body_link: Details on the location of the body content.
        :paramtype body_link: ~azure.mgmt.logic.models.ContentLink
        """
        super(Response, self).__init__(**kwargs)
        self.headers = headers
        self.status_code = status_code
        self.body_link = body_link


class RetryHistory(msrest.serialization.Model):
    """The retry history.

    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar code: Gets the status code.
    :vartype code: str
    :ivar client_request_id: Gets the client request Id.
    :vartype client_request_id: str
    :ivar service_request_id: Gets the service request Id.
    :vartype service_request_id: str
    :ivar error: Gets the error response.
    :vartype error: ~azure.mgmt.logic.models.ErrorResponse
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'code': {'key': 'code', 'type': 'str'},
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'service_request_id': {'key': 'serviceRequestId', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        code: Optional[str] = None,
        client_request_id: Optional[str] = None,
        service_request_id: Optional[str] = None,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        """
        :keyword start_time: Gets the start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Gets the end time.
        :paramtype end_time: ~datetime.datetime
        :keyword code: Gets the status code.
        :paramtype code: str
        :keyword client_request_id: Gets the client request Id.
        :paramtype client_request_id: str
        :keyword service_request_id: Gets the service request Id.
        :paramtype service_request_id: str
        :keyword error: Gets the error response.
        :paramtype error: ~azure.mgmt.logic.models.ErrorResponse
        """
        super(RetryHistory, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.code = code
        self.client_request_id = client_request_id
        self.service_request_id = service_request_id
        self.error = error


class RunCorrelation(msrest.serialization.Model):
    """The correlation properties.

    :ivar client_tracking_id: The client tracking identifier.
    :vartype client_tracking_id: str
    :ivar client_keywords: The client keywords.
    :vartype client_keywords: list[str]
    """

    _attribute_map = {
        'client_tracking_id': {'key': 'clientTrackingId', 'type': 'str'},
        'client_keywords': {'key': 'clientKeywords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        client_tracking_id: Optional[str] = None,
        client_keywords: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword client_tracking_id: The client tracking identifier.
        :paramtype client_tracking_id: str
        :keyword client_keywords: The client keywords.
        :paramtype client_keywords: list[str]
        """
        super(RunCorrelation, self).__init__(**kwargs)
        self.client_tracking_id = client_tracking_id
        self.client_keywords = client_keywords


class RunActionCorrelation(RunCorrelation):
    """The workflow run action correlation properties.

    :ivar client_tracking_id: The client tracking identifier.
    :vartype client_tracking_id: str
    :ivar client_keywords: The client keywords.
    :vartype client_keywords: list[str]
    :ivar action_tracking_id: The action tracking identifier.
    :vartype action_tracking_id: str
    """

    _attribute_map = {
        'client_tracking_id': {'key': 'clientTrackingId', 'type': 'str'},
        'client_keywords': {'key': 'clientKeywords', 'type': '[str]'},
        'action_tracking_id': {'key': 'actionTrackingId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_tracking_id: Optional[str] = None,
        client_keywords: Optional[List[str]] = None,
        action_tracking_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_tracking_id: The client tracking identifier.
        :paramtype client_tracking_id: str
        :keyword client_keywords: The client keywords.
        :paramtype client_keywords: list[str]
        :keyword action_tracking_id: The action tracking identifier.
        :paramtype action_tracking_id: str
        """
        super(RunActionCorrelation, self).__init__(client_tracking_id=client_tracking_id, client_keywords=client_keywords, **kwargs)
        self.action_tracking_id = action_tracking_id


class SetTriggerStateActionDefinition(msrest.serialization.Model):
    """The set trigger state action definition.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Required. The source.
    :vartype source: ~azure.mgmt.logic.models.WorkflowTriggerReference
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'WorkflowTriggerReference'},
    }

    def __init__(
        self,
        *,
        source: "WorkflowTriggerReference",
        **kwargs
    ):
        """
        :keyword source: Required. The source.
        :paramtype source: ~azure.mgmt.logic.models.WorkflowTriggerReference
        """
        super(SetTriggerStateActionDefinition, self).__init__(**kwargs)
        self.source = source


class Sku(msrest.serialization.Model):
    """The sku type.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name. Possible values include: "NotSpecified", "Free", "Shared",
     "Basic", "Standard", "Premium".
    :vartype name: str or ~azure.mgmt.logic.models.SkuName
    :ivar plan: The reference to plan.
    :vartype plan: ~azure.mgmt.logic.models.ResourceReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'plan': {'key': 'plan', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        plan: Optional["ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name. Possible values include: "NotSpecified", "Free", "Shared",
         "Basic", "Standard", "Premium".
        :paramtype name: str or ~azure.mgmt.logic.models.SkuName
        :keyword plan: The reference to plan.
        :paramtype plan: ~azure.mgmt.logic.models.ResourceReference
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.plan = plan


class SubResource(msrest.serialization.Model):
    """The sub resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SubResource, self).__init__(**kwargs)
        self.id = None


class SwaggerCustomDynamicList(msrest.serialization.Model):
    """The swagger custom dynamic list.

    :ivar operation_id: The operation id to fetch dynamic schema.
    :vartype operation_id: str
    :ivar built_in_operation: The built in operation.
    :vartype built_in_operation: str
    :ivar items_path: The path to a response property (relative to the response object, not the
     response body) which contains an array of dynamic value items.
    :vartype items_path: str
    :ivar item_value_path: The path to a property which defines the value which should be used.
    :vartype item_value_path: str
    :ivar item_title_path: The path to an item property which defines the display name of the item.
    :vartype item_title_path: str
    :ivar parameters: The parameters.
    :vartype parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties]
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'built_in_operation': {'key': 'builtInOperation', 'type': 'str'},
        'items_path': {'key': 'itemsPath', 'type': 'str'},
        'item_value_path': {'key': 'itemValuePath', 'type': 'str'},
        'item_title_path': {'key': 'itemTitlePath', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{SwaggerCustomDynamicProperties}'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        built_in_operation: Optional[str] = None,
        items_path: Optional[str] = None,
        item_value_path: Optional[str] = None,
        item_title_path: Optional[str] = None,
        parameters: Optional[Dict[str, "SwaggerCustomDynamicProperties"]] = None,
        **kwargs
    ):
        """
        :keyword operation_id: The operation id to fetch dynamic schema.
        :paramtype operation_id: str
        :keyword built_in_operation: The built in operation.
        :paramtype built_in_operation: str
        :keyword items_path: The path to a response property (relative to the response object, not the
         response body) which contains an array of dynamic value items.
        :paramtype items_path: str
        :keyword item_value_path: The path to a property which defines the value which should be used.
        :paramtype item_value_path: str
        :keyword item_title_path: The path to an item property which defines the display name of the
         item.
        :paramtype item_title_path: str
        :keyword parameters: The parameters.
        :paramtype parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties]
        """
        super(SwaggerCustomDynamicList, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.built_in_operation = built_in_operation
        self.items_path = items_path
        self.item_value_path = item_value_path
        self.item_title_path = item_title_path
        self.parameters = parameters


class SwaggerCustomDynamicProperties(msrest.serialization.Model):
    """The swagger custom dynamic properties.

    :ivar operation_id: The operation id to fetch dynamic schema.
    :vartype operation_id: str
    :ivar value_path: Json pointer to the dynamic schema on the response body.
    :vartype value_path: str
    :ivar parameters: The operation parameters.
    :vartype parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties]
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'value_path': {'key': 'valuePath', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{SwaggerCustomDynamicProperties}'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        value_path: Optional[str] = None,
        parameters: Optional[Dict[str, "SwaggerCustomDynamicProperties"]] = None,
        **kwargs
    ):
        """
        :keyword operation_id: The operation id to fetch dynamic schema.
        :paramtype operation_id: str
        :keyword value_path: Json pointer to the dynamic schema on the response body.
        :paramtype value_path: str
        :keyword parameters: The operation parameters.
        :paramtype parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties]
        """
        super(SwaggerCustomDynamicProperties, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.value_path = value_path
        self.parameters = parameters


class SwaggerCustomDynamicSchema(msrest.serialization.Model):
    """The swagger custom dynamic schema.

    :ivar operation_id: The operation id to fetch dynamic schema.
    :vartype operation_id: str
    :ivar value_path: Json pointer to the dynamic schema on the response body.
    :vartype value_path: str
    :ivar parameters: The operation parameters.
    :vartype parameters: dict[str, any]
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'value_path': {'key': 'valuePath', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        value_path: Optional[str] = None,
        parameters: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword operation_id: The operation id to fetch dynamic schema.
        :paramtype operation_id: str
        :keyword value_path: Json pointer to the dynamic schema on the response body.
        :paramtype value_path: str
        :keyword parameters: The operation parameters.
        :paramtype parameters: dict[str, any]
        """
        super(SwaggerCustomDynamicSchema, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.value_path = value_path
        self.parameters = parameters


class SwaggerCustomDynamicTree(msrest.serialization.Model):
    """The swagger custom dynamic tree.

    :ivar settings: The tree settings.
    :vartype settings: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeSettings
    :ivar open: The tree on-open configuration.
    :vartype open: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeCommand
    :ivar browse: The tree on-browse configuration.
    :vartype browse: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeCommand
    """

    _attribute_map = {
        'settings': {'key': 'settings', 'type': 'SwaggerCustomDynamicTreeSettings'},
        'open': {'key': 'open', 'type': 'SwaggerCustomDynamicTreeCommand'},
        'browse': {'key': 'browse', 'type': 'SwaggerCustomDynamicTreeCommand'},
    }

    def __init__(
        self,
        *,
        settings: Optional["SwaggerCustomDynamicTreeSettings"] = None,
        open: Optional["SwaggerCustomDynamicTreeCommand"] = None,
        browse: Optional["SwaggerCustomDynamicTreeCommand"] = None,
        **kwargs
    ):
        """
        :keyword settings: The tree settings.
        :paramtype settings: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeSettings
        :keyword open: The tree on-open configuration.
        :paramtype open: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeCommand
        :keyword browse: The tree on-browse configuration.
        :paramtype browse: ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeCommand
        """
        super(SwaggerCustomDynamicTree, self).__init__(**kwargs)
        self.settings = settings
        self.open = open
        self.browse = browse


class SwaggerCustomDynamicTreeCommand(msrest.serialization.Model):
    """The swagger tree command.

    :ivar operation_id: The path to an item property which defines the display name of the item.
    :vartype operation_id: str
    :ivar items_path: The path to an item property which defines the display name of the item.
    :vartype items_path: str
    :ivar item_value_path: The path to an item property which defines the display name of the item.
    :vartype item_value_path: str
    :ivar item_title_path: The path to an item property which defines the display name of the item.
    :vartype item_title_path: str
    :ivar item_full_title_path: The path to an item property which defines the display name of the
     item.
    :vartype item_full_title_path: str
    :ivar item_is_parent: The path to an item property which defines the display name of the item.
    :vartype item_is_parent: str
    :ivar selectable_filter: The path to an item property which defines the display name of the
     item.
    :vartype selectable_filter: str
    :ivar parameters: Dictionary of :code:`<SwaggerCustomDynamicTreeParameter>`.
    :vartype parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeParameter]
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'items_path': {'key': 'itemsPath', 'type': 'str'},
        'item_value_path': {'key': 'itemValuePath', 'type': 'str'},
        'item_title_path': {'key': 'itemTitlePath', 'type': 'str'},
        'item_full_title_path': {'key': 'itemFullTitlePath', 'type': 'str'},
        'item_is_parent': {'key': 'itemIsParent', 'type': 'str'},
        'selectable_filter': {'key': 'selectableFilter', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{SwaggerCustomDynamicTreeParameter}'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        items_path: Optional[str] = None,
        item_value_path: Optional[str] = None,
        item_title_path: Optional[str] = None,
        item_full_title_path: Optional[str] = None,
        item_is_parent: Optional[str] = None,
        selectable_filter: Optional[str] = None,
        parameters: Optional[Dict[str, "SwaggerCustomDynamicTreeParameter"]] = None,
        **kwargs
    ):
        """
        :keyword operation_id: The path to an item property which defines the display name of the item.
        :paramtype operation_id: str
        :keyword items_path: The path to an item property which defines the display name of the item.
        :paramtype items_path: str
        :keyword item_value_path: The path to an item property which defines the display name of the
         item.
        :paramtype item_value_path: str
        :keyword item_title_path: The path to an item property which defines the display name of the
         item.
        :paramtype item_title_path: str
        :keyword item_full_title_path: The path to an item property which defines the display name of
         the item.
        :paramtype item_full_title_path: str
        :keyword item_is_parent: The path to an item property which defines the display name of the
         item.
        :paramtype item_is_parent: str
        :keyword selectable_filter: The path to an item property which defines the display name of the
         item.
        :paramtype selectable_filter: str
        :keyword parameters: Dictionary of :code:`<SwaggerCustomDynamicTreeParameter>`.
        :paramtype parameters: dict[str, ~azure.mgmt.logic.models.SwaggerCustomDynamicTreeParameter]
        """
        super(SwaggerCustomDynamicTreeCommand, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.items_path = items_path
        self.item_value_path = item_value_path
        self.item_title_path = item_title_path
        self.item_full_title_path = item_full_title_path
        self.item_is_parent = item_is_parent
        self.selectable_filter = selectable_filter
        self.parameters = parameters


class SwaggerCustomDynamicTreeParameter(msrest.serialization.Model):
    """The swagger custom dynamic tree parameter.

    :ivar selected_item_value_path: Gets or sets a path to a property in the currently selected
     item to pass as a value to a parameter for the given operation.
    :vartype selected_item_value_path: str
    :ivar value: The parameter value.
    :vartype value: any
    :ivar parameter_reference: The parameter reference.
    :vartype parameter_reference: str
    :ivar required: Indicates whether the parameter is required.
    :vartype required: bool
    """

    _attribute_map = {
        'selected_item_value_path': {'key': 'selectedItemValuePath', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'parameter_reference': {'key': 'parameterReference', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        selected_item_value_path: Optional[str] = None,
        value: Optional[Any] = None,
        parameter_reference: Optional[str] = None,
        required: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword selected_item_value_path: Gets or sets a path to a property in the currently selected
         item to pass as a value to a parameter for the given operation.
        :paramtype selected_item_value_path: str
        :keyword value: The parameter value.
        :paramtype value: any
        :keyword parameter_reference: The parameter reference.
        :paramtype parameter_reference: str
        :keyword required: Indicates whether the parameter is required.
        :paramtype required: bool
        """
        super(SwaggerCustomDynamicTreeParameter, self).__init__(**kwargs)
        self.selected_item_value_path = selected_item_value_path
        self.value = value
        self.parameter_reference = parameter_reference
        self.required = required


class SwaggerCustomDynamicTreeSettings(msrest.serialization.Model):
    """The swagger custom dynamic tree settings.

    :ivar can_select_parent_nodes: Indicates whether parent nodes can be selected.
    :vartype can_select_parent_nodes: bool
    :ivar can_select_leaf_nodes: Indicates whether leaf nodes can be selected.
    :vartype can_select_leaf_nodes: bool
    """

    _attribute_map = {
        'can_select_parent_nodes': {'key': 'CanSelectParentNodes', 'type': 'bool'},
        'can_select_leaf_nodes': {'key': 'CanSelectLeafNodes', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        can_select_parent_nodes: Optional[bool] = None,
        can_select_leaf_nodes: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword can_select_parent_nodes: Indicates whether parent nodes can be selected.
        :paramtype can_select_parent_nodes: bool
        :keyword can_select_leaf_nodes: Indicates whether leaf nodes can be selected.
        :paramtype can_select_leaf_nodes: bool
        """
        super(SwaggerCustomDynamicTreeSettings, self).__init__(**kwargs)
        self.can_select_parent_nodes = can_select_parent_nodes
        self.can_select_leaf_nodes = can_select_leaf_nodes


class SwaggerExternalDocumentation(msrest.serialization.Model):
    """The swagger external documentation.

    :ivar description: The document description.
    :vartype description: str
    :ivar uri: The documentation Uri.
    :vartype uri: str
    :ivar extensions: The vendor extensions.
    :vartype extensions: dict[str, any]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'extensions': {'key': 'extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        uri: Optional[str] = None,
        extensions: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword description: The document description.
        :paramtype description: str
        :keyword uri: The documentation Uri.
        :paramtype uri: str
        :keyword extensions: The vendor extensions.
        :paramtype extensions: dict[str, any]
        """
        super(SwaggerExternalDocumentation, self).__init__(**kwargs)
        self.description = description
        self.uri = uri
        self.extensions = extensions


class SwaggerSchema(msrest.serialization.Model):
    """The swagger schema.

    :ivar ref: The reference.
    :vartype ref: str
    :ivar type: The type. Possible values include: "String", "Number", "Integer", "Boolean",
     "Array", "File", "Object", "Null".
    :vartype type: str or ~azure.mgmt.logic.models.SwaggerSchemaType
    :ivar title: The title.
    :vartype title: str
    :ivar items: The items schema.
    :vartype items: ~azure.mgmt.logic.models.SwaggerSchema
    :ivar properties: The object properties.
    :vartype properties: dict[str, ~azure.mgmt.logic.models.SwaggerSchema]
    :ivar additional_properties: The additional properties.
    :vartype additional_properties: any
    :ivar required: The object required properties.
    :vartype required: list[str]
    :ivar max_properties: The maximum number of allowed properties.
    :vartype max_properties: int
    :ivar min_properties: The minimum number of allowed properties.
    :vartype min_properties: int
    :ivar all_of: The schemas which must pass validation when this schema is used.
    :vartype all_of: list[~azure.mgmt.logic.models.SwaggerSchema]
    :ivar discriminator: The discriminator.
    :vartype discriminator: str
    :ivar read_only: Indicates whether this property must be present in the a request.
    :vartype read_only: bool
    :ivar xml: The xml representation format for a property.
    :vartype xml: ~azure.mgmt.logic.models.SwaggerXml
    :ivar external_docs: The external documentation.
    :vartype external_docs: ~azure.mgmt.logic.models.SwaggerExternalDocumentation
    :ivar example: The example value.
    :vartype example: any
    :ivar notification_url_extension: Indicates the notification url extension. If this is set, the
     property's value should be a callback url for a webhook.
    :vartype notification_url_extension: bool
    :ivar dynamic_schema_old: The dynamic schema configuration.
    :vartype dynamic_schema_old: ~azure.mgmt.logic.models.SwaggerCustomDynamicSchema
    :ivar dynamic_schema_new: The dynamic schema configuration.
    :vartype dynamic_schema_new: ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties
    :ivar dynamic_list_new: The dynamic list.
    :vartype dynamic_list_new: ~azure.mgmt.logic.models.SwaggerCustomDynamicList
    :ivar dynamic_tree: The dynamic values tree configuration.
    :vartype dynamic_tree: ~azure.mgmt.logic.models.SwaggerCustomDynamicTree
    """

    _attribute_map = {
        'ref': {'key': 'ref', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'items': {'key': 'items', 'type': 'SwaggerSchema'},
        'properties': {'key': 'properties', 'type': '{SwaggerSchema}'},
        'additional_properties': {'key': 'additionalProperties', 'type': 'object'},
        'required': {'key': 'required', 'type': '[str]'},
        'max_properties': {'key': 'maxProperties', 'type': 'int'},
        'min_properties': {'key': 'minProperties', 'type': 'int'},
        'all_of': {'key': 'allOf', 'type': '[SwaggerSchema]'},
        'discriminator': {'key': 'discriminator', 'type': 'str'},
        'read_only': {'key': 'readOnly', 'type': 'bool'},
        'xml': {'key': 'xml', 'type': 'SwaggerXml'},
        'external_docs': {'key': 'externalDocs', 'type': 'SwaggerExternalDocumentation'},
        'example': {'key': 'example', 'type': 'object'},
        'notification_url_extension': {'key': 'notificationUrlExtension', 'type': 'bool'},
        'dynamic_schema_old': {'key': 'dynamicSchemaOld', 'type': 'SwaggerCustomDynamicSchema'},
        'dynamic_schema_new': {'key': 'dynamicSchemaNew', 'type': 'SwaggerCustomDynamicProperties'},
        'dynamic_list_new': {'key': 'dynamicListNew', 'type': 'SwaggerCustomDynamicList'},
        'dynamic_tree': {'key': 'dynamicTree', 'type': 'SwaggerCustomDynamicTree'},
    }

    def __init__(
        self,
        *,
        ref: Optional[str] = None,
        type: Optional[Union[str, "SwaggerSchemaType"]] = None,
        title: Optional[str] = None,
        items: Optional["SwaggerSchema"] = None,
        properties: Optional[Dict[str, "SwaggerSchema"]] = None,
        additional_properties: Optional[Any] = None,
        required: Optional[List[str]] = None,
        max_properties: Optional[int] = None,
        min_properties: Optional[int] = None,
        all_of: Optional[List["SwaggerSchema"]] = None,
        discriminator: Optional[str] = None,
        read_only: Optional[bool] = None,
        xml: Optional["SwaggerXml"] = None,
        external_docs: Optional["SwaggerExternalDocumentation"] = None,
        example: Optional[Any] = None,
        notification_url_extension: Optional[bool] = None,
        dynamic_schema_old: Optional["SwaggerCustomDynamicSchema"] = None,
        dynamic_schema_new: Optional["SwaggerCustomDynamicProperties"] = None,
        dynamic_list_new: Optional["SwaggerCustomDynamicList"] = None,
        dynamic_tree: Optional["SwaggerCustomDynamicTree"] = None,
        **kwargs
    ):
        """
        :keyword ref: The reference.
        :paramtype ref: str
        :keyword type: The type. Possible values include: "String", "Number", "Integer", "Boolean",
         "Array", "File", "Object", "Null".
        :paramtype type: str or ~azure.mgmt.logic.models.SwaggerSchemaType
        :keyword title: The title.
        :paramtype title: str
        :keyword items: The items schema.
        :paramtype items: ~azure.mgmt.logic.models.SwaggerSchema
        :keyword properties: The object properties.
        :paramtype properties: dict[str, ~azure.mgmt.logic.models.SwaggerSchema]
        :keyword additional_properties: The additional properties.
        :paramtype additional_properties: any
        :keyword required: The object required properties.
        :paramtype required: list[str]
        :keyword max_properties: The maximum number of allowed properties.
        :paramtype max_properties: int
        :keyword min_properties: The minimum number of allowed properties.
        :paramtype min_properties: int
        :keyword all_of: The schemas which must pass validation when this schema is used.
        :paramtype all_of: list[~azure.mgmt.logic.models.SwaggerSchema]
        :keyword discriminator: The discriminator.
        :paramtype discriminator: str
        :keyword read_only: Indicates whether this property must be present in the a request.
        :paramtype read_only: bool
        :keyword xml: The xml representation format for a property.
        :paramtype xml: ~azure.mgmt.logic.models.SwaggerXml
        :keyword external_docs: The external documentation.
        :paramtype external_docs: ~azure.mgmt.logic.models.SwaggerExternalDocumentation
        :keyword example: The example value.
        :paramtype example: any
        :keyword notification_url_extension: Indicates the notification url extension. If this is set,
         the property's value should be a callback url for a webhook.
        :paramtype notification_url_extension: bool
        :keyword dynamic_schema_old: The dynamic schema configuration.
        :paramtype dynamic_schema_old: ~azure.mgmt.logic.models.SwaggerCustomDynamicSchema
        :keyword dynamic_schema_new: The dynamic schema configuration.
        :paramtype dynamic_schema_new: ~azure.mgmt.logic.models.SwaggerCustomDynamicProperties
        :keyword dynamic_list_new: The dynamic list.
        :paramtype dynamic_list_new: ~azure.mgmt.logic.models.SwaggerCustomDynamicList
        :keyword dynamic_tree: The dynamic values tree configuration.
        :paramtype dynamic_tree: ~azure.mgmt.logic.models.SwaggerCustomDynamicTree
        """
        super(SwaggerSchema, self).__init__(**kwargs)
        self.ref = ref
        self.type = type
        self.title = title
        self.items = items
        self.properties = properties
        self.additional_properties = additional_properties
        self.required = required
        self.max_properties = max_properties
        self.min_properties = min_properties
        self.all_of = all_of
        self.discriminator = discriminator
        self.read_only = read_only
        self.xml = xml
        self.external_docs = external_docs
        self.example = example
        self.notification_url_extension = notification_url_extension
        self.dynamic_schema_old = dynamic_schema_old
        self.dynamic_schema_new = dynamic_schema_new
        self.dynamic_list_new = dynamic_list_new
        self.dynamic_tree = dynamic_tree


class SwaggerXml(msrest.serialization.Model):
    """The Swagger XML.

    :ivar name: The xml element or attribute name.
    :vartype name: str
    :ivar namespace: The xml namespace.
    :vartype namespace: str
    :ivar prefix: The name prefix.
    :vartype prefix: str
    :ivar attribute: Indicates whether the property should be an attribute instead of an element.
    :vartype attribute: bool
    :ivar wrapped: Indicates whether the array elements are wrapped in a container element.
    :vartype wrapped: bool
    :ivar extensions: The vendor extensions.
    :vartype extensions: dict[str, any]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
        'attribute': {'key': 'attribute', 'type': 'bool'},
        'wrapped': {'key': 'wrapped', 'type': 'bool'},
        'extensions': {'key': 'extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        namespace: Optional[str] = None,
        prefix: Optional[str] = None,
        attribute: Optional[bool] = None,
        wrapped: Optional[bool] = None,
        extensions: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword name: The xml element or attribute name.
        :paramtype name: str
        :keyword namespace: The xml namespace.
        :paramtype namespace: str
        :keyword prefix: The name prefix.
        :paramtype prefix: str
        :keyword attribute: Indicates whether the property should be an attribute instead of an
         element.
        :paramtype attribute: bool
        :keyword wrapped: Indicates whether the array elements are wrapped in a container element.
        :paramtype wrapped: bool
        :keyword extensions: The vendor extensions.
        :paramtype extensions: dict[str, any]
        """
        super(SwaggerXml, self).__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.prefix = prefix
        self.attribute = attribute
        self.wrapped = wrapped
        self.extensions = extensions


class TrackingEvent(msrest.serialization.Model):
    """The tracking event.

    All required parameters must be populated in order to send to Azure.

    :ivar event_level: Required. The event level. Possible values include: "LogAlways", "Critical",
     "Error", "Warning", "Informational", "Verbose".
    :vartype event_level: str or ~azure.mgmt.logic.models.EventLevel
    :ivar event_time: Required. The event time.
    :vartype event_time: ~datetime.datetime
    :ivar record_type: Required. The record type. Possible values include: "NotSpecified",
     "Custom", "AS2Message", "AS2MDN", "X12Interchange", "X12FunctionalGroup", "X12TransactionSet",
     "X12InterchangeAcknowledgment", "X12FunctionalGroupAcknowledgment",
     "X12TransactionSetAcknowledgment", "EdifactInterchange", "EdifactFunctionalGroup",
     "EdifactTransactionSet", "EdifactInterchangeAcknowledgment",
     "EdifactFunctionalGroupAcknowledgment", "EdifactTransactionSetAcknowledgment".
    :vartype record_type: str or ~azure.mgmt.logic.models.TrackingRecordType
    :ivar record: The record.
    :vartype record: any
    :ivar error: The error.
    :vartype error: ~azure.mgmt.logic.models.TrackingEventErrorInfo
    """

    _validation = {
        'event_level': {'required': True},
        'event_time': {'required': True},
        'record_type': {'required': True},
    }

    _attribute_map = {
        'event_level': {'key': 'eventLevel', 'type': 'str'},
        'event_time': {'key': 'eventTime', 'type': 'iso-8601'},
        'record_type': {'key': 'recordType', 'type': 'str'},
        'record': {'key': 'record', 'type': 'object'},
        'error': {'key': 'error', 'type': 'TrackingEventErrorInfo'},
    }

    def __init__(
        self,
        *,
        event_level: Union[str, "EventLevel"],
        event_time: datetime.datetime,
        record_type: Union[str, "TrackingRecordType"],
        record: Optional[Any] = None,
        error: Optional["TrackingEventErrorInfo"] = None,
        **kwargs
    ):
        """
        :keyword event_level: Required. The event level. Possible values include: "LogAlways",
         "Critical", "Error", "Warning", "Informational", "Verbose".
        :paramtype event_level: str or ~azure.mgmt.logic.models.EventLevel
        :keyword event_time: Required. The event time.
        :paramtype event_time: ~datetime.datetime
        :keyword record_type: Required. The record type. Possible values include: "NotSpecified",
         "Custom", "AS2Message", "AS2MDN", "X12Interchange", "X12FunctionalGroup", "X12TransactionSet",
         "X12InterchangeAcknowledgment", "X12FunctionalGroupAcknowledgment",
         "X12TransactionSetAcknowledgment", "EdifactInterchange", "EdifactFunctionalGroup",
         "EdifactTransactionSet", "EdifactInterchangeAcknowledgment",
         "EdifactFunctionalGroupAcknowledgment", "EdifactTransactionSetAcknowledgment".
        :paramtype record_type: str or ~azure.mgmt.logic.models.TrackingRecordType
        :keyword record: The record.
        :paramtype record: any
        :keyword error: The error.
        :paramtype error: ~azure.mgmt.logic.models.TrackingEventErrorInfo
        """
        super(TrackingEvent, self).__init__(**kwargs)
        self.event_level = event_level
        self.event_time = event_time
        self.record_type = record_type
        self.record = record
        self.error = error


class TrackingEventErrorInfo(msrest.serialization.Model):
    """The tracking event error info.

    :ivar message: The message.
    :vartype message: str
    :ivar code: The code.
    :vartype code: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message: The message.
        :paramtype message: str
        :keyword code: The code.
        :paramtype code: str
        """
        super(TrackingEventErrorInfo, self).__init__(**kwargs)
        self.message = message
        self.code = code


class TrackingEventsDefinition(msrest.serialization.Model):
    """The tracking events definition.

    All required parameters must be populated in order to send to Azure.

    :ivar source_type: Required. The source type.
    :vartype source_type: str
    :ivar track_events_options: The track events options. Possible values include: "None",
     "DisableSourceInfoEnrich".
    :vartype track_events_options: str or ~azure.mgmt.logic.models.TrackEventsOperationOptions
    :ivar events: Required. The events.
    :vartype events: list[~azure.mgmt.logic.models.TrackingEvent]
    """

    _validation = {
        'source_type': {'required': True},
        'events': {'required': True},
    }

    _attribute_map = {
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'track_events_options': {'key': 'trackEventsOptions', 'type': 'str'},
        'events': {'key': 'events', 'type': '[TrackingEvent]'},
    }

    def __init__(
        self,
        *,
        source_type: str,
        events: List["TrackingEvent"],
        track_events_options: Optional[Union[str, "TrackEventsOperationOptions"]] = None,
        **kwargs
    ):
        """
        :keyword source_type: Required. The source type.
        :paramtype source_type: str
        :keyword track_events_options: The track events options. Possible values include: "None",
         "DisableSourceInfoEnrich".
        :paramtype track_events_options: str or ~azure.mgmt.logic.models.TrackEventsOperationOptions
        :keyword events: Required. The events.
        :paramtype events: list[~azure.mgmt.logic.models.TrackingEvent]
        """
        super(TrackingEventsDefinition, self).__init__(**kwargs)
        self.source_type = source_type
        self.track_events_options = track_events_options
        self.events = events


class UserAssignedIdentity(msrest.serialization.Model):
    """User Assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Workflow(Resource):
    """The workflow type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity properties.
    :vartype identity: ~azure.mgmt.logic.models.ManagedServiceIdentity
    :ivar provisioning_state: Gets the provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar created_time: Gets the created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: Gets the changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar state: The state. Possible values include: "NotSpecified", "Completed", "Enabled",
     "Disabled", "Deleted", "Suspended".
    :vartype state: str or ~azure.mgmt.logic.models.WorkflowState
    :ivar version: Gets the version.
    :vartype version: str
    :ivar access_endpoint: Gets the access endpoint.
    :vartype access_endpoint: str
    :ivar endpoints_configuration: The endpoints configuration.
    :vartype endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
    :ivar access_control: The access control configuration.
    :vartype access_control: ~azure.mgmt.logic.models.FlowAccessControlConfiguration
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.logic.models.Sku
    :ivar integration_account: The integration account.
    :vartype integration_account: ~azure.mgmt.logic.models.ResourceReference
    :ivar integration_service_environment: The integration service environment.
    :vartype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
    :ivar definition: The definition.
    :vartype definition: any
    :ivar parameters: The parameters.
    :vartype parameters: dict[str, ~azure.mgmt.logic.models.WorkflowParameter]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'version': {'readonly': True},
        'access_endpoint': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'access_endpoint': {'key': 'properties.accessEndpoint', 'type': 'str'},
        'endpoints_configuration': {'key': 'properties.endpointsConfiguration', 'type': 'FlowEndpointsConfiguration'},
        'access_control': {'key': 'properties.accessControl', 'type': 'FlowAccessControlConfiguration'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'integration_account': {'key': 'properties.integrationAccount', 'type': 'ResourceReference'},
        'integration_service_environment': {'key': 'properties.integrationServiceEnvironment', 'type': 'ResourceReference'},
        'definition': {'key': 'properties.definition', 'type': 'object'},
        'parameters': {'key': 'properties.parameters', 'type': '{WorkflowParameter}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        state: Optional[Union[str, "WorkflowState"]] = None,
        endpoints_configuration: Optional["FlowEndpointsConfiguration"] = None,
        access_control: Optional["FlowAccessControlConfiguration"] = None,
        integration_account: Optional["ResourceReference"] = None,
        integration_service_environment: Optional["ResourceReference"] = None,
        definition: Optional[Any] = None,
        parameters: Optional[Dict[str, "WorkflowParameter"]] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity properties.
        :paramtype identity: ~azure.mgmt.logic.models.ManagedServiceIdentity
        :keyword state: The state. Possible values include: "NotSpecified", "Completed", "Enabled",
         "Disabled", "Deleted", "Suspended".
        :paramtype state: str or ~azure.mgmt.logic.models.WorkflowState
        :keyword endpoints_configuration: The endpoints configuration.
        :paramtype endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
        :keyword access_control: The access control configuration.
        :paramtype access_control: ~azure.mgmt.logic.models.FlowAccessControlConfiguration
        :keyword integration_account: The integration account.
        :paramtype integration_account: ~azure.mgmt.logic.models.ResourceReference
        :keyword integration_service_environment: The integration service environment.
        :paramtype integration_service_environment: ~azure.mgmt.logic.models.ResourceReference
        :keyword definition: The definition.
        :paramtype definition: any
        :keyword parameters: The parameters.
        :paramtype parameters: dict[str, ~azure.mgmt.logic.models.WorkflowParameter]
        """
        super(Workflow, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.created_time = None
        self.changed_time = None
        self.state = state
        self.version = None
        self.access_endpoint = None
        self.endpoints_configuration = endpoints_configuration
        self.access_control = access_control
        self.sku = None
        self.integration_account = integration_account
        self.integration_service_environment = integration_service_environment
        self.definition = definition
        self.parameters = parameters


class WorkflowFilter(msrest.serialization.Model):
    """The workflow filter.

    :ivar state: The state of workflows. Possible values include: "NotSpecified", "Completed",
     "Enabled", "Disabled", "Deleted", "Suspended".
    :vartype state: str or ~azure.mgmt.logic.models.WorkflowState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "WorkflowState"]] = None,
        **kwargs
    ):
        """
        :keyword state: The state of workflows. Possible values include: "NotSpecified", "Completed",
         "Enabled", "Disabled", "Deleted", "Suspended".
        :paramtype state: str or ~azure.mgmt.logic.models.WorkflowState
        """
        super(WorkflowFilter, self).__init__(**kwargs)
        self.state = state


class WorkflowListResult(msrest.serialization.Model):
    """The list of workflows.

    :ivar value: The list of workflows.
    :vartype value: list[~azure.mgmt.logic.models.Workflow]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workflow]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Workflow"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of workflows.
        :paramtype value: list[~azure.mgmt.logic.models.Workflow]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(WorkflowListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowParameter(msrest.serialization.Model):
    """The workflow parameters.

    :ivar type: The type. Possible values include: "NotSpecified", "String", "SecureString", "Int",
     "Float", "Bool", "Array", "Object", "SecureObject".
    :vartype type: str or ~azure.mgmt.logic.models.ParameterType
    :ivar value: The value.
    :vartype value: any
    :ivar metadata: The metadata.
    :vartype metadata: any
    :ivar description: The description.
    :vartype description: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ParameterType"]] = None,
        value: Optional[Any] = None,
        metadata: Optional[Any] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: The type. Possible values include: "NotSpecified", "String", "SecureString",
         "Int", "Float", "Bool", "Array", "Object", "SecureObject".
        :paramtype type: str or ~azure.mgmt.logic.models.ParameterType
        :keyword value: The value.
        :paramtype value: any
        :keyword metadata: The metadata.
        :paramtype metadata: any
        :keyword description: The description.
        :paramtype description: str
        """
        super(WorkflowParameter, self).__init__(**kwargs)
        self.type = type
        self.value = value
        self.metadata = metadata
        self.description = description


class WorkflowOutputParameter(WorkflowParameter):
    """The workflow output parameter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type. Possible values include: "NotSpecified", "String", "SecureString", "Int",
     "Float", "Bool", "Array", "Object", "SecureObject".
    :vartype type: str or ~azure.mgmt.logic.models.ParameterType
    :ivar value: The value.
    :vartype value: any
    :ivar metadata: The metadata.
    :vartype metadata: any
    :ivar description: The description.
    :vartype description: str
    :ivar error: Gets the error.
    :vartype error: any
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'description': {'key': 'description', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ParameterType"]] = None,
        value: Optional[Any] = None,
        metadata: Optional[Any] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: The type. Possible values include: "NotSpecified", "String", "SecureString",
         "Int", "Float", "Bool", "Array", "Object", "SecureObject".
        :paramtype type: str or ~azure.mgmt.logic.models.ParameterType
        :keyword value: The value.
        :paramtype value: any
        :keyword metadata: The metadata.
        :paramtype metadata: any
        :keyword description: The description.
        :paramtype description: str
        """
        super(WorkflowOutputParameter, self).__init__(type=type, value=value, metadata=metadata, description=description, **kwargs)
        self.error = None


class WorkflowReference(ResourceReference):
    """The workflow reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The resource id.
        :paramtype id: str
        """
        super(WorkflowReference, self).__init__(id=id, **kwargs)


class WorkflowRun(SubResource):
    """The workflow run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the workflow run name.
    :vartype name: str
    :ivar type: Gets the workflow run type.
    :vartype type: str
    :ivar wait_end_time: Gets the wait end time.
    :vartype wait_end_time: ~datetime.datetime
    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: Gets the code.
    :vartype code: str
    :ivar error: Gets the error.
    :vartype error: any
    :ivar correlation_id: Gets the correlation id.
    :vartype correlation_id: str
    :ivar correlation: The run correlation.
    :vartype correlation: ~azure.mgmt.logic.models.Correlation
    :ivar workflow: Gets the reference to workflow version.
    :vartype workflow: ~azure.mgmt.logic.models.ResourceReference
    :ivar trigger: Gets the fired trigger.
    :vartype trigger: ~azure.mgmt.logic.models.WorkflowRunTrigger
    :ivar outputs: Gets the outputs.
    :vartype outputs: dict[str, ~azure.mgmt.logic.models.WorkflowOutputParameter]
    :ivar response: Gets the response of the flow run.
    :vartype response: ~azure.mgmt.logic.models.WorkflowRunTrigger
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'wait_end_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'status': {'readonly': True},
        'code': {'readonly': True},
        'error': {'readonly': True},
        'correlation_id': {'readonly': True},
        'workflow': {'readonly': True},
        'trigger': {'readonly': True},
        'outputs': {'readonly': True},
        'response': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'wait_end_time': {'key': 'properties.waitEndTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'correlation': {'key': 'properties.correlation', 'type': 'Correlation'},
        'workflow': {'key': 'properties.workflow', 'type': 'ResourceReference'},
        'trigger': {'key': 'properties.trigger', 'type': 'WorkflowRunTrigger'},
        'outputs': {'key': 'properties.outputs', 'type': '{WorkflowOutputParameter}'},
        'response': {'key': 'properties.response', 'type': 'WorkflowRunTrigger'},
    }

    def __init__(
        self,
        *,
        correlation: Optional["Correlation"] = None,
        **kwargs
    ):
        """
        :keyword correlation: The run correlation.
        :paramtype correlation: ~azure.mgmt.logic.models.Correlation
        """
        super(WorkflowRun, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.wait_end_time = None
        self.start_time = None
        self.end_time = None
        self.status = None
        self.code = None
        self.error = None
        self.correlation_id = None
        self.correlation = correlation
        self.workflow = None
        self.trigger = None
        self.outputs = None
        self.response = None


class WorkflowRunAction(SubResource):
    """The workflow run action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the workflow run action name.
    :vartype name: str
    :ivar type: Gets the workflow run action type.
    :vartype type: str
    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: Gets the code.
    :vartype code: str
    :ivar error: Gets the error.
    :vartype error: any
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar correlation: The correlation properties.
    :vartype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: any
    :ivar retry_history: Gets the retry histories.
    :vartype retry_history: list[~azure.mgmt.logic.models.RetryHistory]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'status': {'readonly': True},
        'code': {'readonly': True},
        'error': {'readonly': True},
        'tracking_id': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs_link': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'tracking_id': {'key': 'properties.trackingId', 'type': 'str'},
        'correlation': {'key': 'properties.correlation', 'type': 'RunActionCorrelation'},
        'inputs_link': {'key': 'properties.inputsLink', 'type': 'ContentLink'},
        'outputs_link': {'key': 'properties.outputsLink', 'type': 'ContentLink'},
        'tracked_properties': {'key': 'properties.trackedProperties', 'type': 'object'},
        'retry_history': {'key': 'properties.retryHistory', 'type': '[RetryHistory]'},
    }

    def __init__(
        self,
        *,
        correlation: Optional["RunActionCorrelation"] = None,
        retry_history: Optional[List["RetryHistory"]] = None,
        **kwargs
    ):
        """
        :keyword correlation: The correlation properties.
        :paramtype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
        :keyword retry_history: Gets the retry histories.
        :paramtype retry_history: list[~azure.mgmt.logic.models.RetryHistory]
        """
        super(WorkflowRunAction, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.start_time = None
        self.end_time = None
        self.status = None
        self.code = None
        self.error = None
        self.tracking_id = None
        self.correlation = correlation
        self.inputs_link = None
        self.outputs_link = None
        self.tracked_properties = None
        self.retry_history = retry_history


class WorkflowRunActionFilter(msrest.serialization.Model):
    """The workflow run action filter.

    :ivar status: The status of workflow run action. Possible values include: "NotSpecified",
     "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
     "Faulted", "TimedOut", "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        **kwargs
    ):
        """
        :keyword status: The status of workflow run action. Possible values include: "NotSpecified",
         "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
         "Faulted", "TimedOut", "Aborted", "Ignored".
        :paramtype status: str or ~azure.mgmt.logic.models.WorkflowStatus
        """
        super(WorkflowRunActionFilter, self).__init__(**kwargs)
        self.status = status


class WorkflowRunActionListResult(msrest.serialization.Model):
    """The list of workflow run actions.

    :ivar value: A list of workflow run actions.
    :vartype value: list[~azure.mgmt.logic.models.WorkflowRunAction]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowRunAction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowRunAction"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of workflow run actions.
        :paramtype value: list[~azure.mgmt.logic.models.WorkflowRunAction]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(WorkflowRunActionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowRunActionRepetitionDefinition(Resource):
    """The workflow run action repetition definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar start_time: The start time of the workflow scope repetition.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the workflow scope repetition.
    :vartype end_time: ~datetime.datetime
    :ivar correlation: The correlation properties.
    :vartype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :ivar status: The status of the workflow scope repetition. Possible values include:
     "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
     "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: The workflow scope repetition code.
    :vartype code: str
    :ivar error: Anything.
    :vartype error: any
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: any
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: any
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: any
    :ivar retry_history: Gets the retry histories.
    :vartype retry_history: list[~azure.mgmt.logic.models.RetryHistory]
    :ivar iteration_count:
    :vartype iteration_count: int
    :ivar repetition_indexes: The repetition indexes.
    :vartype repetition_indexes: list[~azure.mgmt.logic.models.RepetitionIndex]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tracking_id': {'readonly': True},
        'inputs': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs': {'readonly': True},
        'outputs_link': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'correlation': {'key': 'properties.correlation', 'type': 'RunActionCorrelation'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'tracking_id': {'key': 'properties.trackingId', 'type': 'str'},
        'inputs': {'key': 'properties.inputs', 'type': 'object'},
        'inputs_link': {'key': 'properties.inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'properties.outputs', 'type': 'object'},
        'outputs_link': {'key': 'properties.outputsLink', 'type': 'ContentLink'},
        'tracked_properties': {'key': 'properties.trackedProperties', 'type': 'object'},
        'retry_history': {'key': 'properties.retryHistory', 'type': '[RetryHistory]'},
        'iteration_count': {'key': 'properties.iterationCount', 'type': 'int'},
        'repetition_indexes': {'key': 'properties.repetitionIndexes', 'type': '[RepetitionIndex]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["RunActionCorrelation"] = None,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[Any] = None,
        retry_history: Optional[List["RetryHistory"]] = None,
        iteration_count: Optional[int] = None,
        repetition_indexes: Optional[List["RepetitionIndex"]] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword start_time: The start time of the workflow scope repetition.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the workflow scope repetition.
        :paramtype end_time: ~datetime.datetime
        :keyword correlation: The correlation properties.
        :paramtype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
        :keyword status: The status of the workflow scope repetition. Possible values include:
         "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
         "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
        :paramtype status: str or ~azure.mgmt.logic.models.WorkflowStatus
        :keyword code: The workflow scope repetition code.
        :paramtype code: str
        :keyword error: Anything.
        :paramtype error: any
        :keyword retry_history: Gets the retry histories.
        :paramtype retry_history: list[~azure.mgmt.logic.models.RetryHistory]
        :keyword iteration_count:
        :paramtype iteration_count: int
        :keyword repetition_indexes: The repetition indexes.
        :paramtype repetition_indexes: list[~azure.mgmt.logic.models.RepetitionIndex]
        """
        super(WorkflowRunActionRepetitionDefinition, self).__init__(location=location, tags=tags, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.correlation = correlation
        self.status = status
        self.code = code
        self.error = error
        self.tracking_id = None
        self.inputs = None
        self.inputs_link = None
        self.outputs = None
        self.outputs_link = None
        self.tracked_properties = None
        self.retry_history = retry_history
        self.iteration_count = iteration_count
        self.repetition_indexes = repetition_indexes


class WorkflowRunActionRepetitionDefinitionCollection(msrest.serialization.Model):
    """A collection of workflow run action repetitions.

    :ivar next_link: The link used to get the next page of recommendations.
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.mgmt.logic.models.WorkflowRunActionRepetitionDefinition]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[WorkflowRunActionRepetitionDefinition]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["WorkflowRunActionRepetitionDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of recommendations.
        :paramtype next_link: str
        :keyword value:
        :paramtype value: list[~azure.mgmt.logic.models.WorkflowRunActionRepetitionDefinition]
        """
        super(WorkflowRunActionRepetitionDefinitionCollection, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class WorkflowRunActionRepetitionProperties(OperationResult):
    """The workflow run action repetition properties definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: The start time of the workflow scope repetition.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the workflow scope repetition.
    :vartype end_time: ~datetime.datetime
    :ivar correlation: The correlation properties.
    :vartype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
    :ivar status: The status of the workflow scope repetition. Possible values include:
     "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
     "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: The workflow scope repetition code.
    :vartype code: str
    :ivar error: Anything.
    :vartype error: any
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: any
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: any
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: any
    :ivar retry_history: Gets the retry histories.
    :vartype retry_history: list[~azure.mgmt.logic.models.RetryHistory]
    :ivar iteration_count:
    :vartype iteration_count: int
    :ivar repetition_indexes: The repetition indexes.
    :vartype repetition_indexes: list[~azure.mgmt.logic.models.RepetitionIndex]
    """

    _validation = {
        'tracking_id': {'readonly': True},
        'inputs': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs': {'readonly': True},
        'outputs_link': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'correlation': {'key': 'correlation', 'type': 'RunActionCorrelation'},
        'status': {'key': 'status', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': 'object'},
        'inputs_link': {'key': 'inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'outputs_link': {'key': 'outputsLink', 'type': 'ContentLink'},
        'tracked_properties': {'key': 'trackedProperties', 'type': 'object'},
        'retry_history': {'key': 'retryHistory', 'type': '[RetryHistory]'},
        'iteration_count': {'key': 'iterationCount', 'type': 'int'},
        'repetition_indexes': {'key': 'repetitionIndexes', 'type': '[RepetitionIndex]'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["RunActionCorrelation"] = None,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[Any] = None,
        retry_history: Optional[List["RetryHistory"]] = None,
        iteration_count: Optional[int] = None,
        repetition_indexes: Optional[List["RepetitionIndex"]] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start time of the workflow scope repetition.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the workflow scope repetition.
        :paramtype end_time: ~datetime.datetime
        :keyword correlation: The correlation properties.
        :paramtype correlation: ~azure.mgmt.logic.models.RunActionCorrelation
        :keyword status: The status of the workflow scope repetition. Possible values include:
         "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
         "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
        :paramtype status: str or ~azure.mgmt.logic.models.WorkflowStatus
        :keyword code: The workflow scope repetition code.
        :paramtype code: str
        :keyword error: Anything.
        :paramtype error: any
        :keyword retry_history: Gets the retry histories.
        :paramtype retry_history: list[~azure.mgmt.logic.models.RetryHistory]
        :keyword iteration_count:
        :paramtype iteration_count: int
        :keyword repetition_indexes: The repetition indexes.
        :paramtype repetition_indexes: list[~azure.mgmt.logic.models.RepetitionIndex]
        """
        super(WorkflowRunActionRepetitionProperties, self).__init__(start_time=start_time, end_time=end_time, correlation=correlation, status=status, code=code, error=error, retry_history=retry_history, iteration_count=iteration_count, **kwargs)
        self.repetition_indexes = repetition_indexes


class WorkflowRunFilter(msrest.serialization.Model):
    """The workflow run filter.

    :ivar status: The status of workflow run. Possible values include: "NotSpecified", "Paused",
     "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted",
     "TimedOut", "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        **kwargs
    ):
        """
        :keyword status: The status of workflow run. Possible values include: "NotSpecified", "Paused",
         "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted",
         "TimedOut", "Aborted", "Ignored".
        :paramtype status: str or ~azure.mgmt.logic.models.WorkflowStatus
        """
        super(WorkflowRunFilter, self).__init__(**kwargs)
        self.status = status


class WorkflowRunListResult(msrest.serialization.Model):
    """The list of workflow runs.

    :ivar value: A list of workflow runs.
    :vartype value: list[~azure.mgmt.logic.models.WorkflowRun]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowRun]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowRun"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of workflow runs.
        :paramtype value: list[~azure.mgmt.logic.models.WorkflowRun]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(WorkflowRunListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowRunTrigger(msrest.serialization.Model):
    """The workflow run trigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets the name.
    :vartype name: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: any
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: any
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar scheduled_time: Gets the scheduled time.
    :vartype scheduled_time: ~datetime.datetime
    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar correlation: The run correlation.
    :vartype correlation: ~azure.mgmt.logic.models.Correlation
    :ivar code: Gets the code.
    :vartype code: str
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar error: Gets the error.
    :vartype error: any
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: any
    """

    _validation = {
        'name': {'readonly': True},
        'inputs': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs': {'readonly': True},
        'outputs_link': {'readonly': True},
        'scheduled_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'tracking_id': {'readonly': True},
        'code': {'readonly': True},
        'status': {'readonly': True},
        'error': {'readonly': True},
        'tracked_properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': 'object'},
        'inputs_link': {'key': 'inputsLink', 'type': 'ContentLink'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'outputs_link': {'key': 'outputsLink', 'type': 'ContentLink'},
        'scheduled_time': {'key': 'scheduledTime', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'correlation': {'key': 'correlation', 'type': 'Correlation'},
        'code': {'key': 'code', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
        'tracked_properties': {'key': 'trackedProperties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        correlation: Optional["Correlation"] = None,
        **kwargs
    ):
        """
        :keyword correlation: The run correlation.
        :paramtype correlation: ~azure.mgmt.logic.models.Correlation
        """
        super(WorkflowRunTrigger, self).__init__(**kwargs)
        self.name = None
        self.inputs = None
        self.inputs_link = None
        self.outputs = None
        self.outputs_link = None
        self.scheduled_time = None
        self.start_time = None
        self.end_time = None
        self.tracking_id = None
        self.correlation = correlation
        self.code = None
        self.status = None
        self.error = None
        self.tracked_properties = None


class WorkflowTrigger(SubResource):
    """The workflow trigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the workflow trigger name.
    :vartype name: str
    :ivar type: Gets the workflow trigger type.
    :vartype type: str
    :ivar provisioning_state: Gets the provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowTriggerProvisioningState
    :ivar created_time: Gets the created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: Gets the changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar state: Gets the state. Possible values include: "NotSpecified", "Completed", "Enabled",
     "Disabled", "Deleted", "Suspended".
    :vartype state: str or ~azure.mgmt.logic.models.WorkflowState
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar last_execution_time: Gets the last execution time.
    :vartype last_execution_time: ~datetime.datetime
    :ivar next_execution_time: Gets the next execution time.
    :vartype next_execution_time: ~datetime.datetime
    :ivar recurrence: Gets the workflow trigger recurrence.
    :vartype recurrence: ~azure.mgmt.logic.models.WorkflowTriggerRecurrence
    :ivar workflow: Gets the reference to workflow.
    :vartype workflow: ~azure.mgmt.logic.models.ResourceReference
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'state': {'readonly': True},
        'status': {'readonly': True},
        'last_execution_time': {'readonly': True},
        'next_execution_time': {'readonly': True},
        'recurrence': {'readonly': True},
        'workflow': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'last_execution_time': {'key': 'properties.lastExecutionTime', 'type': 'iso-8601'},
        'next_execution_time': {'key': 'properties.nextExecutionTime', 'type': 'iso-8601'},
        'recurrence': {'key': 'properties.recurrence', 'type': 'WorkflowTriggerRecurrence'},
        'workflow': {'key': 'properties.workflow', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(WorkflowTrigger, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.created_time = None
        self.changed_time = None
        self.state = None
        self.status = None
        self.last_execution_time = None
        self.next_execution_time = None
        self.recurrence = None
        self.workflow = None


class WorkflowTriggerCallbackUrl(msrest.serialization.Model):
    """The workflow trigger callback URL.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the workflow trigger callback URL.
    :vartype value: str
    :ivar method: Gets the workflow trigger callback URL HTTP method.
    :vartype method: str
    :ivar base_path: Gets the workflow trigger callback URL base path.
    :vartype base_path: str
    :ivar relative_path: Gets the workflow trigger callback URL relative path.
    :vartype relative_path: str
    :ivar relative_path_parameters: Gets the workflow trigger callback URL relative path
     parameters.
    :vartype relative_path_parameters: list[str]
    :ivar queries: Gets the workflow trigger callback URL query parameters.
    :vartype queries: ~azure.mgmt.logic.models.WorkflowTriggerListCallbackUrlQueries
    """

    _validation = {
        'value': {'readonly': True},
        'method': {'readonly': True},
        'base_path': {'readonly': True},
        'relative_path': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'base_path': {'key': 'basePath', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'relative_path_parameters': {'key': 'relativePathParameters', 'type': '[str]'},
        'queries': {'key': 'queries', 'type': 'WorkflowTriggerListCallbackUrlQueries'},
    }

    def __init__(
        self,
        *,
        relative_path_parameters: Optional[List[str]] = None,
        queries: Optional["WorkflowTriggerListCallbackUrlQueries"] = None,
        **kwargs
    ):
        """
        :keyword relative_path_parameters: Gets the workflow trigger callback URL relative path
         parameters.
        :paramtype relative_path_parameters: list[str]
        :keyword queries: Gets the workflow trigger callback URL query parameters.
        :paramtype queries: ~azure.mgmt.logic.models.WorkflowTriggerListCallbackUrlQueries
        """
        super(WorkflowTriggerCallbackUrl, self).__init__(**kwargs)
        self.value = None
        self.method = None
        self.base_path = None
        self.relative_path = None
        self.relative_path_parameters = relative_path_parameters
        self.queries = queries


class WorkflowTriggerFilter(msrest.serialization.Model):
    """The workflow trigger filter.

    :ivar state: The state of workflow trigger. Possible values include: "NotSpecified",
     "Completed", "Enabled", "Disabled", "Deleted", "Suspended".
    :vartype state: str or ~azure.mgmt.logic.models.WorkflowState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "WorkflowState"]] = None,
        **kwargs
    ):
        """
        :keyword state: The state of workflow trigger. Possible values include: "NotSpecified",
         "Completed", "Enabled", "Disabled", "Deleted", "Suspended".
        :paramtype state: str or ~azure.mgmt.logic.models.WorkflowState
        """
        super(WorkflowTriggerFilter, self).__init__(**kwargs)
        self.state = state


class WorkflowTriggerHistory(SubResource):
    """The workflow trigger history.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the workflow trigger history name.
    :vartype name: str
    :ivar type: Gets the workflow trigger history type.
    :vartype type: str
    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar scheduled_time: The scheduled time.
    :vartype scheduled_time: ~datetime.datetime
    :ivar status: Gets the status. Possible values include: "NotSpecified", "Paused", "Running",
     "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed", "Faulted", "TimedOut",
     "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    :ivar code: Gets the code.
    :vartype code: str
    :ivar error: Gets the error.
    :vartype error: any
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar correlation: The run correlation.
    :vartype correlation: ~azure.mgmt.logic.models.Correlation
    :ivar inputs_link: Gets the link to input parameters.
    :vartype inputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar outputs_link: Gets the link to output parameters.
    :vartype outputs_link: ~azure.mgmt.logic.models.ContentLink
    :ivar fired: The value indicating whether trigger was fired.
    :vartype fired: bool
    :ivar run: Gets the reference to workflow run.
    :vartype run: ~azure.mgmt.logic.models.ResourceReference
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'scheduled_time': {'readonly': True},
        'status': {'readonly': True},
        'code': {'readonly': True},
        'error': {'readonly': True},
        'tracking_id': {'readonly': True},
        'inputs_link': {'readonly': True},
        'outputs_link': {'readonly': True},
        'fired': {'readonly': True},
        'run': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'scheduled_time': {'key': 'properties.scheduledTime', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'code': {'key': 'properties.code', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'object'},
        'tracking_id': {'key': 'properties.trackingId', 'type': 'str'},
        'correlation': {'key': 'properties.correlation', 'type': 'Correlation'},
        'inputs_link': {'key': 'properties.inputsLink', 'type': 'ContentLink'},
        'outputs_link': {'key': 'properties.outputsLink', 'type': 'ContentLink'},
        'fired': {'key': 'properties.fired', 'type': 'bool'},
        'run': {'key': 'properties.run', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        correlation: Optional["Correlation"] = None,
        **kwargs
    ):
        """
        :keyword correlation: The run correlation.
        :paramtype correlation: ~azure.mgmt.logic.models.Correlation
        """
        super(WorkflowTriggerHistory, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.start_time = None
        self.end_time = None
        self.scheduled_time = None
        self.status = None
        self.code = None
        self.error = None
        self.tracking_id = None
        self.correlation = correlation
        self.inputs_link = None
        self.outputs_link = None
        self.fired = None
        self.run = None


class WorkflowTriggerHistoryFilter(msrest.serialization.Model):
    """The workflow trigger history filter.

    :ivar status: The status of workflow trigger history. Possible values include: "NotSpecified",
     "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
     "Faulted", "TimedOut", "Aborted", "Ignored".
    :vartype status: str or ~azure.mgmt.logic.models.WorkflowStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "WorkflowStatus"]] = None,
        **kwargs
    ):
        """
        :keyword status: The status of workflow trigger history. Possible values include:
         "NotSpecified", "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended",
         "Cancelled", "Failed", "Faulted", "TimedOut", "Aborted", "Ignored".
        :paramtype status: str or ~azure.mgmt.logic.models.WorkflowStatus
        """
        super(WorkflowTriggerHistoryFilter, self).__init__(**kwargs)
        self.status = status


class WorkflowTriggerHistoryListResult(msrest.serialization.Model):
    """The list of workflow trigger histories.

    :ivar value: A list of workflow trigger histories.
    :vartype value: list[~azure.mgmt.logic.models.WorkflowTriggerHistory]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowTriggerHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowTriggerHistory"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of workflow trigger histories.
        :paramtype value: list[~azure.mgmt.logic.models.WorkflowTriggerHistory]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(WorkflowTriggerHistoryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowTriggerListCallbackUrlQueries(msrest.serialization.Model):
    """Gets the workflow trigger callback URL query parameters.

    :ivar api_version: The api version.
    :vartype api_version: str
    :ivar sp: The SAS permissions.
    :vartype sp: str
    :ivar sv: The SAS version.
    :vartype sv: str
    :ivar sig: The SAS signature.
    :vartype sig: str
    :ivar se: The SAS timestamp.
    :vartype se: str
    """

    _attribute_map = {
        'api_version': {'key': 'api-version', 'type': 'str'},
        'sp': {'key': 'sp', 'type': 'str'},
        'sv': {'key': 'sv', 'type': 'str'},
        'sig': {'key': 'sig', 'type': 'str'},
        'se': {'key': 'se', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        api_version: Optional[str] = None,
        sp: Optional[str] = None,
        sv: Optional[str] = None,
        sig: Optional[str] = None,
        se: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword api_version: The api version.
        :paramtype api_version: str
        :keyword sp: The SAS permissions.
        :paramtype sp: str
        :keyword sv: The SAS version.
        :paramtype sv: str
        :keyword sig: The SAS signature.
        :paramtype sig: str
        :keyword se: The SAS timestamp.
        :paramtype se: str
        """
        super(WorkflowTriggerListCallbackUrlQueries, self).__init__(**kwargs)
        self.api_version = api_version
        self.sp = sp
        self.sv = sv
        self.sig = sig
        self.se = se


class WorkflowTriggerListResult(msrest.serialization.Model):
    """The list of workflow triggers.

    :ivar value: A list of workflow triggers.
    :vartype value: list[~azure.mgmt.logic.models.WorkflowTrigger]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowTrigger]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowTrigger"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of workflow triggers.
        :paramtype value: list[~azure.mgmt.logic.models.WorkflowTrigger]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(WorkflowTriggerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkflowTriggerRecurrence(msrest.serialization.Model):
    """The workflow trigger recurrence.

    :ivar frequency: The frequency. Possible values include: "NotSpecified", "Second", "Minute",
     "Hour", "Day", "Week", "Month", "Year".
    :vartype frequency: str or ~azure.mgmt.logic.models.RecurrenceFrequency
    :ivar interval: The interval.
    :vartype interval: int
    :ivar start_time: The start time.
    :vartype start_time: str
    :ivar end_time: The end time.
    :vartype end_time: str
    :ivar time_zone: The time zone.
    :vartype time_zone: str
    :ivar schedule: The recurrence schedule.
    :vartype schedule: ~azure.mgmt.logic.models.RecurrenceSchedule
    """

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'RecurrenceSchedule'},
    }

    def __init__(
        self,
        *,
        frequency: Optional[Union[str, "RecurrenceFrequency"]] = None,
        interval: Optional[int] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        time_zone: Optional[str] = None,
        schedule: Optional["RecurrenceSchedule"] = None,
        **kwargs
    ):
        """
        :keyword frequency: The frequency. Possible values include: "NotSpecified", "Second", "Minute",
         "Hour", "Day", "Week", "Month", "Year".
        :paramtype frequency: str or ~azure.mgmt.logic.models.RecurrenceFrequency
        :keyword interval: The interval.
        :paramtype interval: int
        :keyword start_time: The start time.
        :paramtype start_time: str
        :keyword end_time: The end time.
        :paramtype end_time: str
        :keyword time_zone: The time zone.
        :paramtype time_zone: str
        :keyword schedule: The recurrence schedule.
        :paramtype schedule: ~azure.mgmt.logic.models.RecurrenceSchedule
        """
        super(WorkflowTriggerRecurrence, self).__init__(**kwargs)
        self.frequency = frequency
        self.interval = interval
        self.start_time = start_time
        self.end_time = end_time
        self.time_zone = time_zone
        self.schedule = schedule


class WorkflowTriggerReference(ResourceReference):
    """The workflow trigger reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar flow_name: The workflow name.
    :vartype flow_name: str
    :ivar trigger_name: The workflow trigger name.
    :vartype trigger_name: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'flow_name': {'key': 'flowName', 'type': 'str'},
        'trigger_name': {'key': 'triggerName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        flow_name: Optional[str] = None,
        trigger_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The resource id.
        :paramtype id: str
        :keyword flow_name: The workflow name.
        :paramtype flow_name: str
        :keyword trigger_name: The workflow trigger name.
        :paramtype trigger_name: str
        """
        super(WorkflowTriggerReference, self).__init__(id=id, **kwargs)
        self.flow_name = flow_name
        self.trigger_name = trigger_name


class WorkflowVersion(Resource):
    """The workflow version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state. Possible values include: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", "Moving", "Updating", "Registering", "Registered", "Unregistering",
     "Unregistered", "Completed", "Renewing", "Pending", "Waiting", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.logic.models.WorkflowProvisioningState
    :ivar created_time: Gets the created time.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: Gets the changed time.
    :vartype changed_time: ~datetime.datetime
    :ivar state: The state. Possible values include: "NotSpecified", "Completed", "Enabled",
     "Disabled", "Deleted", "Suspended".
    :vartype state: str or ~azure.mgmt.logic.models.WorkflowState
    :ivar version: Gets the version.
    :vartype version: str
    :ivar access_endpoint: Gets the access endpoint.
    :vartype access_endpoint: str
    :ivar endpoints_configuration: The endpoints configuration.
    :vartype endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
    :ivar access_control: The access control configuration.
    :vartype access_control: ~azure.mgmt.logic.models.FlowAccessControlConfiguration
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.logic.models.Sku
    :ivar integration_account: The integration account.
    :vartype integration_account: ~azure.mgmt.logic.models.ResourceReference
    :ivar definition: The definition.
    :vartype definition: any
    :ivar parameters: The parameters.
    :vartype parameters: dict[str, ~azure.mgmt.logic.models.WorkflowParameter]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'version': {'readonly': True},
        'access_endpoint': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'access_endpoint': {'key': 'properties.accessEndpoint', 'type': 'str'},
        'endpoints_configuration': {'key': 'properties.endpointsConfiguration', 'type': 'FlowEndpointsConfiguration'},
        'access_control': {'key': 'properties.accessControl', 'type': 'FlowAccessControlConfiguration'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'integration_account': {'key': 'properties.integrationAccount', 'type': 'ResourceReference'},
        'definition': {'key': 'properties.definition', 'type': 'object'},
        'parameters': {'key': 'properties.parameters', 'type': '{WorkflowParameter}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        state: Optional[Union[str, "WorkflowState"]] = None,
        endpoints_configuration: Optional["FlowEndpointsConfiguration"] = None,
        access_control: Optional["FlowAccessControlConfiguration"] = None,
        integration_account: Optional["ResourceReference"] = None,
        definition: Optional[Any] = None,
        parameters: Optional[Dict[str, "WorkflowParameter"]] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword state: The state. Possible values include: "NotSpecified", "Completed", "Enabled",
         "Disabled", "Deleted", "Suspended".
        :paramtype state: str or ~azure.mgmt.logic.models.WorkflowState
        :keyword endpoints_configuration: The endpoints configuration.
        :paramtype endpoints_configuration: ~azure.mgmt.logic.models.FlowEndpointsConfiguration
        :keyword access_control: The access control configuration.
        :paramtype access_control: ~azure.mgmt.logic.models.FlowAccessControlConfiguration
        :keyword integration_account: The integration account.
        :paramtype integration_account: ~azure.mgmt.logic.models.ResourceReference
        :keyword definition: The definition.
        :paramtype definition: any
        :keyword parameters: The parameters.
        :paramtype parameters: dict[str, ~azure.mgmt.logic.models.WorkflowParameter]
        """
        super(WorkflowVersion, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.created_time = None
        self.changed_time = None
        self.state = state
        self.version = None
        self.access_endpoint = None
        self.endpoints_configuration = endpoints_configuration
        self.access_control = access_control
        self.sku = None
        self.integration_account = integration_account
        self.definition = definition
        self.parameters = parameters


class WorkflowVersionListResult(msrest.serialization.Model):
    """The list of workflow versions.

    :ivar value: A list of workflow versions.
    :vartype value: list[~azure.mgmt.logic.models.WorkflowVersion]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkflowVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkflowVersion"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of workflow versions.
        :paramtype value: list[~azure.mgmt.logic.models.WorkflowVersion]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(WorkflowVersionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WsdlService(msrest.serialization.Model):
    """The WSDL service.

    :ivar qualified_name: The qualified name.
    :vartype qualified_name: str
    :ivar endpoint_qualified_names: The list of endpoints' qualified names.
    :vartype endpoint_qualified_names: list[str]
    """

    _attribute_map = {
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
        'endpoint_qualified_names': {'key': 'EndpointQualifiedNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        qualified_name: Optional[str] = None,
        endpoint_qualified_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword qualified_name: The qualified name.
        :paramtype qualified_name: str
        :keyword endpoint_qualified_names: The list of endpoints' qualified names.
        :paramtype endpoint_qualified_names: list[str]
        """
        super(WsdlService, self).__init__(**kwargs)
        self.qualified_name = qualified_name
        self.endpoint_qualified_names = endpoint_qualified_names


class X12AcknowledgementSettings(msrest.serialization.Model):
    """The X12 agreement acknowledgement settings.

    All required parameters must be populated in order to send to Azure.

    :ivar need_technical_acknowledgement: Required. The value indicating whether technical
     acknowledgement is needed.
    :vartype need_technical_acknowledgement: bool
    :ivar batch_technical_acknowledgements: Required. The value indicating whether to batch the
     technical acknowledgements.
    :vartype batch_technical_acknowledgements: bool
    :ivar need_functional_acknowledgement: Required. The value indicating whether functional
     acknowledgement is needed.
    :vartype need_functional_acknowledgement: bool
    :ivar functional_acknowledgement_version: The functional acknowledgement version.
    :vartype functional_acknowledgement_version: str
    :ivar batch_functional_acknowledgements: Required. The value indicating whether to batch
     functional acknowledgements.
    :vartype batch_functional_acknowledgements: bool
    :ivar need_implementation_acknowledgement: Required. The value indicating whether
     implementation acknowledgement is needed.
    :vartype need_implementation_acknowledgement: bool
    :ivar implementation_acknowledgement_version: The implementation acknowledgement version.
    :vartype implementation_acknowledgement_version: str
    :ivar batch_implementation_acknowledgements: Required. The value indicating whether to batch
     implementation acknowledgements.
    :vartype batch_implementation_acknowledgements: bool
    :ivar need_loop_for_valid_messages: Required. The value indicating whether a loop is needed for
     valid messages.
    :vartype need_loop_for_valid_messages: bool
    :ivar send_synchronous_acknowledgement: Required. The value indicating whether to send
     synchronous acknowledgement.
    :vartype send_synchronous_acknowledgement: bool
    :ivar acknowledgement_control_number_prefix: The acknowledgement control number prefix.
    :vartype acknowledgement_control_number_prefix: str
    :ivar acknowledgement_control_number_suffix: The acknowledgement control number suffix.
    :vartype acknowledgement_control_number_suffix: str
    :ivar acknowledgement_control_number_lower_bound: Required. The acknowledgement control number
     lower bound.
    :vartype acknowledgement_control_number_lower_bound: int
    :ivar acknowledgement_control_number_upper_bound: Required. The acknowledgement control number
     upper bound.
    :vartype acknowledgement_control_number_upper_bound: int
    :ivar rollover_acknowledgement_control_number: Required. The value indicating whether to
     rollover acknowledgement control number.
    :vartype rollover_acknowledgement_control_number: bool
    """

    _validation = {
        'need_technical_acknowledgement': {'required': True},
        'batch_technical_acknowledgements': {'required': True},
        'need_functional_acknowledgement': {'required': True},
        'batch_functional_acknowledgements': {'required': True},
        'need_implementation_acknowledgement': {'required': True},
        'batch_implementation_acknowledgements': {'required': True},
        'need_loop_for_valid_messages': {'required': True},
        'send_synchronous_acknowledgement': {'required': True},
        'acknowledgement_control_number_lower_bound': {'required': True},
        'acknowledgement_control_number_upper_bound': {'required': True},
        'rollover_acknowledgement_control_number': {'required': True},
    }

    _attribute_map = {
        'need_technical_acknowledgement': {'key': 'needTechnicalAcknowledgement', 'type': 'bool'},
        'batch_technical_acknowledgements': {'key': 'batchTechnicalAcknowledgements', 'type': 'bool'},
        'need_functional_acknowledgement': {'key': 'needFunctionalAcknowledgement', 'type': 'bool'},
        'functional_acknowledgement_version': {'key': 'functionalAcknowledgementVersion', 'type': 'str'},
        'batch_functional_acknowledgements': {'key': 'batchFunctionalAcknowledgements', 'type': 'bool'},
        'need_implementation_acknowledgement': {'key': 'needImplementationAcknowledgement', 'type': 'bool'},
        'implementation_acknowledgement_version': {'key': 'implementationAcknowledgementVersion', 'type': 'str'},
        'batch_implementation_acknowledgements': {'key': 'batchImplementationAcknowledgements', 'type': 'bool'},
        'need_loop_for_valid_messages': {'key': 'needLoopForValidMessages', 'type': 'bool'},
        'send_synchronous_acknowledgement': {'key': 'sendSynchronousAcknowledgement', 'type': 'bool'},
        'acknowledgement_control_number_prefix': {'key': 'acknowledgementControlNumberPrefix', 'type': 'str'},
        'acknowledgement_control_number_suffix': {'key': 'acknowledgementControlNumberSuffix', 'type': 'str'},
        'acknowledgement_control_number_lower_bound': {'key': 'acknowledgementControlNumberLowerBound', 'type': 'int'},
        'acknowledgement_control_number_upper_bound': {'key': 'acknowledgementControlNumberUpperBound', 'type': 'int'},
        'rollover_acknowledgement_control_number': {'key': 'rolloverAcknowledgementControlNumber', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        need_technical_acknowledgement: bool,
        batch_technical_acknowledgements: bool,
        need_functional_acknowledgement: bool,
        batch_functional_acknowledgements: bool,
        need_implementation_acknowledgement: bool,
        batch_implementation_acknowledgements: bool,
        need_loop_for_valid_messages: bool,
        send_synchronous_acknowledgement: bool,
        acknowledgement_control_number_lower_bound: int,
        acknowledgement_control_number_upper_bound: int,
        rollover_acknowledgement_control_number: bool,
        functional_acknowledgement_version: Optional[str] = None,
        implementation_acknowledgement_version: Optional[str] = None,
        acknowledgement_control_number_prefix: Optional[str] = None,
        acknowledgement_control_number_suffix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword need_technical_acknowledgement: Required. The value indicating whether technical
         acknowledgement is needed.
        :paramtype need_technical_acknowledgement: bool
        :keyword batch_technical_acknowledgements: Required. The value indicating whether to batch the
         technical acknowledgements.
        :paramtype batch_technical_acknowledgements: bool
        :keyword need_functional_acknowledgement: Required. The value indicating whether functional
         acknowledgement is needed.
        :paramtype need_functional_acknowledgement: bool
        :keyword functional_acknowledgement_version: The functional acknowledgement version.
        :paramtype functional_acknowledgement_version: str
        :keyword batch_functional_acknowledgements: Required. The value indicating whether to batch
         functional acknowledgements.
        :paramtype batch_functional_acknowledgements: bool
        :keyword need_implementation_acknowledgement: Required. The value indicating whether
         implementation acknowledgement is needed.
        :paramtype need_implementation_acknowledgement: bool
        :keyword implementation_acknowledgement_version: The implementation acknowledgement version.
        :paramtype implementation_acknowledgement_version: str
        :keyword batch_implementation_acknowledgements: Required. The value indicating whether to batch
         implementation acknowledgements.
        :paramtype batch_implementation_acknowledgements: bool
        :keyword need_loop_for_valid_messages: Required. The value indicating whether a loop is needed
         for valid messages.
        :paramtype need_loop_for_valid_messages: bool
        :keyword send_synchronous_acknowledgement: Required. The value indicating whether to send
         synchronous acknowledgement.
        :paramtype send_synchronous_acknowledgement: bool
        :keyword acknowledgement_control_number_prefix: The acknowledgement control number prefix.
        :paramtype acknowledgement_control_number_prefix: str
        :keyword acknowledgement_control_number_suffix: The acknowledgement control number suffix.
        :paramtype acknowledgement_control_number_suffix: str
        :keyword acknowledgement_control_number_lower_bound: Required. The acknowledgement control
         number lower bound.
        :paramtype acknowledgement_control_number_lower_bound: int
        :keyword acknowledgement_control_number_upper_bound: Required. The acknowledgement control
         number upper bound.
        :paramtype acknowledgement_control_number_upper_bound: int
        :keyword rollover_acknowledgement_control_number: Required. The value indicating whether to
         rollover acknowledgement control number.
        :paramtype rollover_acknowledgement_control_number: bool
        """
        super(X12AcknowledgementSettings, self).__init__(**kwargs)
        self.need_technical_acknowledgement = need_technical_acknowledgement
        self.batch_technical_acknowledgements = batch_technical_acknowledgements
        self.need_functional_acknowledgement = need_functional_acknowledgement
        self.functional_acknowledgement_version = functional_acknowledgement_version
        self.batch_functional_acknowledgements = batch_functional_acknowledgements
        self.need_implementation_acknowledgement = need_implementation_acknowledgement
        self.implementation_acknowledgement_version = implementation_acknowledgement_version
        self.batch_implementation_acknowledgements = batch_implementation_acknowledgements
        self.need_loop_for_valid_messages = need_loop_for_valid_messages
        self.send_synchronous_acknowledgement = send_synchronous_acknowledgement
        self.acknowledgement_control_number_prefix = acknowledgement_control_number_prefix
        self.acknowledgement_control_number_suffix = acknowledgement_control_number_suffix
        self.acknowledgement_control_number_lower_bound = acknowledgement_control_number_lower_bound
        self.acknowledgement_control_number_upper_bound = acknowledgement_control_number_upper_bound
        self.rollover_acknowledgement_control_number = rollover_acknowledgement_control_number


class X12AgreementContent(msrest.serialization.Model):
    """The X12 agreement content.

    All required parameters must be populated in order to send to Azure.

    :ivar receive_agreement: Required. The X12 one-way receive agreement.
    :vartype receive_agreement: ~azure.mgmt.logic.models.X12OneWayAgreement
    :ivar send_agreement: Required. The X12 one-way send agreement.
    :vartype send_agreement: ~azure.mgmt.logic.models.X12OneWayAgreement
    """

    _validation = {
        'receive_agreement': {'required': True},
        'send_agreement': {'required': True},
    }

    _attribute_map = {
        'receive_agreement': {'key': 'receiveAgreement', 'type': 'X12OneWayAgreement'},
        'send_agreement': {'key': 'sendAgreement', 'type': 'X12OneWayAgreement'},
    }

    def __init__(
        self,
        *,
        receive_agreement: "X12OneWayAgreement",
        send_agreement: "X12OneWayAgreement",
        **kwargs
    ):
        """
        :keyword receive_agreement: Required. The X12 one-way receive agreement.
        :paramtype receive_agreement: ~azure.mgmt.logic.models.X12OneWayAgreement
        :keyword send_agreement: Required. The X12 one-way send agreement.
        :paramtype send_agreement: ~azure.mgmt.logic.models.X12OneWayAgreement
        """
        super(X12AgreementContent, self).__init__(**kwargs)
        self.receive_agreement = receive_agreement
        self.send_agreement = send_agreement


class X12DelimiterOverrides(msrest.serialization.Model):
    """The X12 delimiter override settings.

    All required parameters must be populated in order to send to Azure.

    :ivar protocol_version: The protocol version.
    :vartype protocol_version: str
    :ivar message_id: The message id.
    :vartype message_id: str
    :ivar data_element_separator: Required. The data element separator.
    :vartype data_element_separator: int
    :ivar component_separator: Required. The component separator.
    :vartype component_separator: int
    :ivar segment_terminator: Required. The segment terminator.
    :vartype segment_terminator: int
    :ivar segment_terminator_suffix: Required. The segment terminator suffix. Possible values
     include: "NotSpecified", "None", "CR", "LF", "CRLF".
    :vartype segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    :ivar replace_character: Required. The replacement character.
    :vartype replace_character: int
    :ivar replace_separators_in_payload: Required. The value indicating whether to replace
     separators in payload.
    :vartype replace_separators_in_payload: bool
    :ivar target_namespace: The target namespace on which this delimiter settings has to be
     applied.
    :vartype target_namespace: str
    """

    _validation = {
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'segment_terminator': {'required': True},
        'segment_terminator_suffix': {'required': True},
        'replace_character': {'required': True},
        'replace_separators_in_payload': {'required': True},
    }

    _attribute_map = {
        'protocol_version': {'key': 'protocolVersion', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'str'},
        'replace_character': {'key': 'replaceCharacter', 'type': 'int'},
        'replace_separators_in_payload': {'key': 'replaceSeparatorsInPayload', 'type': 'bool'},
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_element_separator: int,
        component_separator: int,
        segment_terminator: int,
        segment_terminator_suffix: Union[str, "SegmentTerminatorSuffix"],
        replace_character: int,
        replace_separators_in_payload: bool,
        protocol_version: Optional[str] = None,
        message_id: Optional[str] = None,
        target_namespace: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword protocol_version: The protocol version.
        :paramtype protocol_version: str
        :keyword message_id: The message id.
        :paramtype message_id: str
        :keyword data_element_separator: Required. The data element separator.
        :paramtype data_element_separator: int
        :keyword component_separator: Required. The component separator.
        :paramtype component_separator: int
        :keyword segment_terminator: Required. The segment terminator.
        :paramtype segment_terminator: int
        :keyword segment_terminator_suffix: Required. The segment terminator suffix. Possible values
         include: "NotSpecified", "None", "CR", "LF", "CRLF".
        :paramtype segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
        :keyword replace_character: Required. The replacement character.
        :paramtype replace_character: int
        :keyword replace_separators_in_payload: Required. The value indicating whether to replace
         separators in payload.
        :paramtype replace_separators_in_payload: bool
        :keyword target_namespace: The target namespace on which this delimiter settings has to be
         applied.
        :paramtype target_namespace: str
        """
        super(X12DelimiterOverrides, self).__init__(**kwargs)
        self.protocol_version = protocol_version
        self.message_id = message_id
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.segment_terminator = segment_terminator
        self.segment_terminator_suffix = segment_terminator_suffix
        self.replace_character = replace_character
        self.replace_separators_in_payload = replace_separators_in_payload
        self.target_namespace = target_namespace


class X12EnvelopeOverride(msrest.serialization.Model):
    """The X12 envelope override settings.

    All required parameters must be populated in order to send to Azure.

    :ivar target_namespace: Required. The target namespace on which this envelope settings has to
     be applied.
    :vartype target_namespace: str
    :ivar protocol_version: Required. The protocol version on which this envelope settings has to
     be applied.
    :vartype protocol_version: str
    :ivar message_id: Required. The message id on which this envelope settings has to be applied.
    :vartype message_id: str
    :ivar responsible_agency_code: Required. The responsible agency code.
    :vartype responsible_agency_code: str
    :ivar header_version: Required. The header version.
    :vartype header_version: str
    :ivar sender_application_id: Required. The sender application id.
    :vartype sender_application_id: str
    :ivar receiver_application_id: Required. The receiver application id.
    :vartype receiver_application_id: str
    :ivar functional_identifier_code: The functional identifier code.
    :vartype functional_identifier_code: str
    :ivar date_format: Required. The date format. Possible values include: "NotSpecified",
     "CCYYMMDD", "YYMMDD".
    :vartype date_format: str or ~azure.mgmt.logic.models.X12DateFormat
    :ivar time_format: Required. The time format. Possible values include: "NotSpecified", "HHMM",
     "HHMMSS", "HHMMSSdd", "HHMMSSd".
    :vartype time_format: str or ~azure.mgmt.logic.models.X12TimeFormat
    """

    _validation = {
        'target_namespace': {'required': True},
        'protocol_version': {'required': True},
        'message_id': {'required': True},
        'responsible_agency_code': {'required': True},
        'header_version': {'required': True},
        'sender_application_id': {'required': True},
        'receiver_application_id': {'required': True},
        'date_format': {'required': True},
        'time_format': {'required': True},
    }

    _attribute_map = {
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
        'protocol_version': {'key': 'protocolVersion', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'responsible_agency_code': {'key': 'responsibleAgencyCode', 'type': 'str'},
        'header_version': {'key': 'headerVersion', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'receiver_application_id': {'key': 'receiverApplicationId', 'type': 'str'},
        'functional_identifier_code': {'key': 'functionalIdentifierCode', 'type': 'str'},
        'date_format': {'key': 'dateFormat', 'type': 'str'},
        'time_format': {'key': 'timeFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_namespace: str,
        protocol_version: str,
        message_id: str,
        responsible_agency_code: str,
        header_version: str,
        sender_application_id: str,
        receiver_application_id: str,
        date_format: Union[str, "X12DateFormat"],
        time_format: Union[str, "X12TimeFormat"],
        functional_identifier_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_namespace: Required. The target namespace on which this envelope settings has
         to be applied.
        :paramtype target_namespace: str
        :keyword protocol_version: Required. The protocol version on which this envelope settings has
         to be applied.
        :paramtype protocol_version: str
        :keyword message_id: Required. The message id on which this envelope settings has to be
         applied.
        :paramtype message_id: str
        :keyword responsible_agency_code: Required. The responsible agency code.
        :paramtype responsible_agency_code: str
        :keyword header_version: Required. The header version.
        :paramtype header_version: str
        :keyword sender_application_id: Required. The sender application id.
        :paramtype sender_application_id: str
        :keyword receiver_application_id: Required. The receiver application id.
        :paramtype receiver_application_id: str
        :keyword functional_identifier_code: The functional identifier code.
        :paramtype functional_identifier_code: str
        :keyword date_format: Required. The date format. Possible values include: "NotSpecified",
         "CCYYMMDD", "YYMMDD".
        :paramtype date_format: str or ~azure.mgmt.logic.models.X12DateFormat
        :keyword time_format: Required. The time format. Possible values include: "NotSpecified",
         "HHMM", "HHMMSS", "HHMMSSdd", "HHMMSSd".
        :paramtype time_format: str or ~azure.mgmt.logic.models.X12TimeFormat
        """
        super(X12EnvelopeOverride, self).__init__(**kwargs)
        self.target_namespace = target_namespace
        self.protocol_version = protocol_version
        self.message_id = message_id
        self.responsible_agency_code = responsible_agency_code
        self.header_version = header_version
        self.sender_application_id = sender_application_id
        self.receiver_application_id = receiver_application_id
        self.functional_identifier_code = functional_identifier_code
        self.date_format = date_format
        self.time_format = time_format


class X12EnvelopeSettings(msrest.serialization.Model):
    """The X12 agreement envelope settings.

    All required parameters must be populated in order to send to Azure.

    :ivar control_standards_id: Required. The controls standards id.
    :vartype control_standards_id: int
    :ivar use_control_standards_id_as_repetition_character: Required. The value indicating whether
     to use control standards id as repetition character.
    :vartype use_control_standards_id_as_repetition_character: bool
    :ivar sender_application_id: Required. The sender application id.
    :vartype sender_application_id: str
    :ivar receiver_application_id: Required. The receiver application id.
    :vartype receiver_application_id: str
    :ivar control_version_number: Required. The control version number.
    :vartype control_version_number: str
    :ivar interchange_control_number_lower_bound: Required. The interchange  control number lower
     bound.
    :vartype interchange_control_number_lower_bound: int
    :ivar interchange_control_number_upper_bound: Required. The interchange  control number upper
     bound.
    :vartype interchange_control_number_upper_bound: int
    :ivar rollover_interchange_control_number: Required. The value indicating whether to rollover
     interchange control number.
    :vartype rollover_interchange_control_number: bool
    :ivar enable_default_group_headers: Required. The value indicating whether to enable default
     group headers.
    :vartype enable_default_group_headers: bool
    :ivar functional_group_id: The functional group id.
    :vartype functional_group_id: str
    :ivar group_control_number_lower_bound: Required. The group control number lower bound.
    :vartype group_control_number_lower_bound: int
    :ivar group_control_number_upper_bound: Required. The group control number upper bound.
    :vartype group_control_number_upper_bound: int
    :ivar rollover_group_control_number: Required. The value indicating whether to rollover group
     control number.
    :vartype rollover_group_control_number: bool
    :ivar group_header_agency_code: Required. The group header agency code.
    :vartype group_header_agency_code: str
    :ivar group_header_version: Required. The group header version.
    :vartype group_header_version: str
    :ivar transaction_set_control_number_lower_bound: Required. The transaction set control number
     lower bound.
    :vartype transaction_set_control_number_lower_bound: int
    :ivar transaction_set_control_number_upper_bound: Required. The transaction set control number
     upper bound.
    :vartype transaction_set_control_number_upper_bound: int
    :ivar rollover_transaction_set_control_number: Required. The value indicating whether to
     rollover transaction set control number.
    :vartype rollover_transaction_set_control_number: bool
    :ivar transaction_set_control_number_prefix: The transaction set control number prefix.
    :vartype transaction_set_control_number_prefix: str
    :ivar transaction_set_control_number_suffix: The transaction set control number suffix.
    :vartype transaction_set_control_number_suffix: str
    :ivar overwrite_existing_transaction_set_control_number: Required. The value indicating whether
     to overwrite existing transaction set control number.
    :vartype overwrite_existing_transaction_set_control_number: bool
    :ivar group_header_date_format: Required. The group header date format. Possible values
     include: "NotSpecified", "CCYYMMDD", "YYMMDD".
    :vartype group_header_date_format: str or ~azure.mgmt.logic.models.X12DateFormat
    :ivar group_header_time_format: Required. The group header time format. Possible values
     include: "NotSpecified", "HHMM", "HHMMSS", "HHMMSSdd", "HHMMSSd".
    :vartype group_header_time_format: str or ~azure.mgmt.logic.models.X12TimeFormat
    :ivar usage_indicator: Required. The usage indicator. Possible values include: "NotSpecified",
     "Test", "Information", "Production".
    :vartype usage_indicator: str or ~azure.mgmt.logic.models.UsageIndicator
    """

    _validation = {
        'control_standards_id': {'required': True},
        'use_control_standards_id_as_repetition_character': {'required': True},
        'sender_application_id': {'required': True},
        'receiver_application_id': {'required': True},
        'control_version_number': {'required': True},
        'interchange_control_number_lower_bound': {'required': True},
        'interchange_control_number_upper_bound': {'required': True},
        'rollover_interchange_control_number': {'required': True},
        'enable_default_group_headers': {'required': True},
        'group_control_number_lower_bound': {'required': True},
        'group_control_number_upper_bound': {'required': True},
        'rollover_group_control_number': {'required': True},
        'group_header_agency_code': {'required': True},
        'group_header_version': {'required': True},
        'transaction_set_control_number_lower_bound': {'required': True},
        'transaction_set_control_number_upper_bound': {'required': True},
        'rollover_transaction_set_control_number': {'required': True},
        'overwrite_existing_transaction_set_control_number': {'required': True},
        'group_header_date_format': {'required': True},
        'group_header_time_format': {'required': True},
        'usage_indicator': {'required': True},
    }

    _attribute_map = {
        'control_standards_id': {'key': 'controlStandardsId', 'type': 'int'},
        'use_control_standards_id_as_repetition_character': {'key': 'useControlStandardsIdAsRepetitionCharacter', 'type': 'bool'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'receiver_application_id': {'key': 'receiverApplicationId', 'type': 'str'},
        'control_version_number': {'key': 'controlVersionNumber', 'type': 'str'},
        'interchange_control_number_lower_bound': {'key': 'interchangeControlNumberLowerBound', 'type': 'int'},
        'interchange_control_number_upper_bound': {'key': 'interchangeControlNumberUpperBound', 'type': 'int'},
        'rollover_interchange_control_number': {'key': 'rolloverInterchangeControlNumber', 'type': 'bool'},
        'enable_default_group_headers': {'key': 'enableDefaultGroupHeaders', 'type': 'bool'},
        'functional_group_id': {'key': 'functionalGroupId', 'type': 'str'},
        'group_control_number_lower_bound': {'key': 'groupControlNumberLowerBound', 'type': 'int'},
        'group_control_number_upper_bound': {'key': 'groupControlNumberUpperBound', 'type': 'int'},
        'rollover_group_control_number': {'key': 'rolloverGroupControlNumber', 'type': 'bool'},
        'group_header_agency_code': {'key': 'groupHeaderAgencyCode', 'type': 'str'},
        'group_header_version': {'key': 'groupHeaderVersion', 'type': 'str'},
        'transaction_set_control_number_lower_bound': {'key': 'transactionSetControlNumberLowerBound', 'type': 'int'},
        'transaction_set_control_number_upper_bound': {'key': 'transactionSetControlNumberUpperBound', 'type': 'int'},
        'rollover_transaction_set_control_number': {'key': 'rolloverTransactionSetControlNumber', 'type': 'bool'},
        'transaction_set_control_number_prefix': {'key': 'transactionSetControlNumberPrefix', 'type': 'str'},
        'transaction_set_control_number_suffix': {'key': 'transactionSetControlNumberSuffix', 'type': 'str'},
        'overwrite_existing_transaction_set_control_number': {'key': 'overwriteExistingTransactionSetControlNumber', 'type': 'bool'},
        'group_header_date_format': {'key': 'groupHeaderDateFormat', 'type': 'str'},
        'group_header_time_format': {'key': 'groupHeaderTimeFormat', 'type': 'str'},
        'usage_indicator': {'key': 'usageIndicator', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        control_standards_id: int,
        use_control_standards_id_as_repetition_character: bool,
        sender_application_id: str,
        receiver_application_id: str,
        control_version_number: str,
        interchange_control_number_lower_bound: int,
        interchange_control_number_upper_bound: int,
        rollover_interchange_control_number: bool,
        enable_default_group_headers: bool,
        group_control_number_lower_bound: int,
        group_control_number_upper_bound: int,
        rollover_group_control_number: bool,
        group_header_agency_code: str,
        group_header_version: str,
        transaction_set_control_number_lower_bound: int,
        transaction_set_control_number_upper_bound: int,
        rollover_transaction_set_control_number: bool,
        overwrite_existing_transaction_set_control_number: bool,
        group_header_date_format: Union[str, "X12DateFormat"],
        group_header_time_format: Union[str, "X12TimeFormat"],
        usage_indicator: Union[str, "UsageIndicator"],
        functional_group_id: Optional[str] = None,
        transaction_set_control_number_prefix: Optional[str] = None,
        transaction_set_control_number_suffix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword control_standards_id: Required. The controls standards id.
        :paramtype control_standards_id: int
        :keyword use_control_standards_id_as_repetition_character: Required. The value indicating
         whether to use control standards id as repetition character.
        :paramtype use_control_standards_id_as_repetition_character: bool
        :keyword sender_application_id: Required. The sender application id.
        :paramtype sender_application_id: str
        :keyword receiver_application_id: Required. The receiver application id.
        :paramtype receiver_application_id: str
        :keyword control_version_number: Required. The control version number.
        :paramtype control_version_number: str
        :keyword interchange_control_number_lower_bound: Required. The interchange  control number
         lower bound.
        :paramtype interchange_control_number_lower_bound: int
        :keyword interchange_control_number_upper_bound: Required. The interchange  control number
         upper bound.
        :paramtype interchange_control_number_upper_bound: int
        :keyword rollover_interchange_control_number: Required. The value indicating whether to
         rollover interchange control number.
        :paramtype rollover_interchange_control_number: bool
        :keyword enable_default_group_headers: Required. The value indicating whether to enable default
         group headers.
        :paramtype enable_default_group_headers: bool
        :keyword functional_group_id: The functional group id.
        :paramtype functional_group_id: str
        :keyword group_control_number_lower_bound: Required. The group control number lower bound.
        :paramtype group_control_number_lower_bound: int
        :keyword group_control_number_upper_bound: Required. The group control number upper bound.
        :paramtype group_control_number_upper_bound: int
        :keyword rollover_group_control_number: Required. The value indicating whether to rollover
         group control number.
        :paramtype rollover_group_control_number: bool
        :keyword group_header_agency_code: Required. The group header agency code.
        :paramtype group_header_agency_code: str
        :keyword group_header_version: Required. The group header version.
        :paramtype group_header_version: str
        :keyword transaction_set_control_number_lower_bound: Required. The transaction set control
         number lower bound.
        :paramtype transaction_set_control_number_lower_bound: int
        :keyword transaction_set_control_number_upper_bound: Required. The transaction set control
         number upper bound.
        :paramtype transaction_set_control_number_upper_bound: int
        :keyword rollover_transaction_set_control_number: Required. The value indicating whether to
         rollover transaction set control number.
        :paramtype rollover_transaction_set_control_number: bool
        :keyword transaction_set_control_number_prefix: The transaction set control number prefix.
        :paramtype transaction_set_control_number_prefix: str
        :keyword transaction_set_control_number_suffix: The transaction set control number suffix.
        :paramtype transaction_set_control_number_suffix: str
        :keyword overwrite_existing_transaction_set_control_number: Required. The value indicating
         whether to overwrite existing transaction set control number.
        :paramtype overwrite_existing_transaction_set_control_number: bool
        :keyword group_header_date_format: Required. The group header date format. Possible values
         include: "NotSpecified", "CCYYMMDD", "YYMMDD".
        :paramtype group_header_date_format: str or ~azure.mgmt.logic.models.X12DateFormat
        :keyword group_header_time_format: Required. The group header time format. Possible values
         include: "NotSpecified", "HHMM", "HHMMSS", "HHMMSSdd", "HHMMSSd".
        :paramtype group_header_time_format: str or ~azure.mgmt.logic.models.X12TimeFormat
        :keyword usage_indicator: Required. The usage indicator. Possible values include:
         "NotSpecified", "Test", "Information", "Production".
        :paramtype usage_indicator: str or ~azure.mgmt.logic.models.UsageIndicator
        """
        super(X12EnvelopeSettings, self).__init__(**kwargs)
        self.control_standards_id = control_standards_id
        self.use_control_standards_id_as_repetition_character = use_control_standards_id_as_repetition_character
        self.sender_application_id = sender_application_id
        self.receiver_application_id = receiver_application_id
        self.control_version_number = control_version_number
        self.interchange_control_number_lower_bound = interchange_control_number_lower_bound
        self.interchange_control_number_upper_bound = interchange_control_number_upper_bound
        self.rollover_interchange_control_number = rollover_interchange_control_number
        self.enable_default_group_headers = enable_default_group_headers
        self.functional_group_id = functional_group_id
        self.group_control_number_lower_bound = group_control_number_lower_bound
        self.group_control_number_upper_bound = group_control_number_upper_bound
        self.rollover_group_control_number = rollover_group_control_number
        self.group_header_agency_code = group_header_agency_code
        self.group_header_version = group_header_version
        self.transaction_set_control_number_lower_bound = transaction_set_control_number_lower_bound
        self.transaction_set_control_number_upper_bound = transaction_set_control_number_upper_bound
        self.rollover_transaction_set_control_number = rollover_transaction_set_control_number
        self.transaction_set_control_number_prefix = transaction_set_control_number_prefix
        self.transaction_set_control_number_suffix = transaction_set_control_number_suffix
        self.overwrite_existing_transaction_set_control_number = overwrite_existing_transaction_set_control_number
        self.group_header_date_format = group_header_date_format
        self.group_header_time_format = group_header_time_format
        self.usage_indicator = usage_indicator


class X12FramingSettings(msrest.serialization.Model):
    """The X12 agreement framing settings.

    All required parameters must be populated in order to send to Azure.

    :ivar data_element_separator: Required. The data element separator.
    :vartype data_element_separator: int
    :ivar component_separator: Required. The component separator.
    :vartype component_separator: int
    :ivar replace_separators_in_payload: Required. The value indicating whether to replace
     separators in payload.
    :vartype replace_separators_in_payload: bool
    :ivar replace_character: Required. The replacement character.
    :vartype replace_character: int
    :ivar segment_terminator: Required. The segment terminator.
    :vartype segment_terminator: int
    :ivar character_set: Required. The X12 character set. Possible values include: "NotSpecified",
     "Basic", "Extended", "UTF8".
    :vartype character_set: str or ~azure.mgmt.logic.models.X12CharacterSet
    :ivar segment_terminator_suffix: Required. The segment terminator suffix. Possible values
     include: "NotSpecified", "None", "CR", "LF", "CRLF".
    :vartype segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
    """

    _validation = {
        'data_element_separator': {'required': True},
        'component_separator': {'required': True},
        'replace_separators_in_payload': {'required': True},
        'replace_character': {'required': True},
        'segment_terminator': {'required': True},
        'character_set': {'required': True},
        'segment_terminator_suffix': {'required': True},
    }

    _attribute_map = {
        'data_element_separator': {'key': 'dataElementSeparator', 'type': 'int'},
        'component_separator': {'key': 'componentSeparator', 'type': 'int'},
        'replace_separators_in_payload': {'key': 'replaceSeparatorsInPayload', 'type': 'bool'},
        'replace_character': {'key': 'replaceCharacter', 'type': 'int'},
        'segment_terminator': {'key': 'segmentTerminator', 'type': 'int'},
        'character_set': {'key': 'characterSet', 'type': 'str'},
        'segment_terminator_suffix': {'key': 'segmentTerminatorSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_element_separator: int,
        component_separator: int,
        replace_separators_in_payload: bool,
        replace_character: int,
        segment_terminator: int,
        character_set: Union[str, "X12CharacterSet"],
        segment_terminator_suffix: Union[str, "SegmentTerminatorSuffix"],
        **kwargs
    ):
        """
        :keyword data_element_separator: Required. The data element separator.
        :paramtype data_element_separator: int
        :keyword component_separator: Required. The component separator.
        :paramtype component_separator: int
        :keyword replace_separators_in_payload: Required. The value indicating whether to replace
         separators in payload.
        :paramtype replace_separators_in_payload: bool
        :keyword replace_character: Required. The replacement character.
        :paramtype replace_character: int
        :keyword segment_terminator: Required. The segment terminator.
        :paramtype segment_terminator: int
        :keyword character_set: Required. The X12 character set. Possible values include:
         "NotSpecified", "Basic", "Extended", "UTF8".
        :paramtype character_set: str or ~azure.mgmt.logic.models.X12CharacterSet
        :keyword segment_terminator_suffix: Required. The segment terminator suffix. Possible values
         include: "NotSpecified", "None", "CR", "LF", "CRLF".
        :paramtype segment_terminator_suffix: str or ~azure.mgmt.logic.models.SegmentTerminatorSuffix
        """
        super(X12FramingSettings, self).__init__(**kwargs)
        self.data_element_separator = data_element_separator
        self.component_separator = component_separator
        self.replace_separators_in_payload = replace_separators_in_payload
        self.replace_character = replace_character
        self.segment_terminator = segment_terminator
        self.character_set = character_set
        self.segment_terminator_suffix = segment_terminator_suffix


class X12MessageFilter(msrest.serialization.Model):
    """The X12 message filter for odata query.

    All required parameters must be populated in order to send to Azure.

    :ivar message_filter_type: Required. The message filter type. Possible values include:
     "NotSpecified", "Include", "Exclude".
    :vartype message_filter_type: str or ~azure.mgmt.logic.models.MessageFilterType
    """

    _validation = {
        'message_filter_type': {'required': True},
    }

    _attribute_map = {
        'message_filter_type': {'key': 'messageFilterType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_filter_type: Union[str, "MessageFilterType"],
        **kwargs
    ):
        """
        :keyword message_filter_type: Required. The message filter type. Possible values include:
         "NotSpecified", "Include", "Exclude".
        :paramtype message_filter_type: str or ~azure.mgmt.logic.models.MessageFilterType
        """
        super(X12MessageFilter, self).__init__(**kwargs)
        self.message_filter_type = message_filter_type


class X12MessageIdentifier(msrest.serialization.Model):
    """The X12 message identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The message id.
    :vartype message_id: str
    """

    _validation = {
        'message_id': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        **kwargs
    ):
        """
        :keyword message_id: Required. The message id.
        :paramtype message_id: str
        """
        super(X12MessageIdentifier, self).__init__(**kwargs)
        self.message_id = message_id


class X12OneWayAgreement(msrest.serialization.Model):
    """The X12 one-way agreement.

    All required parameters must be populated in order to send to Azure.

    :ivar sender_business_identity: Required. The sender business identity.
    :vartype sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :ivar receiver_business_identity: Required. The receiver business identity.
    :vartype receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
    :ivar protocol_settings: Required. The X12 protocol settings.
    :vartype protocol_settings: ~azure.mgmt.logic.models.X12ProtocolSettings
    """

    _validation = {
        'sender_business_identity': {'required': True},
        'receiver_business_identity': {'required': True},
        'protocol_settings': {'required': True},
    }

    _attribute_map = {
        'sender_business_identity': {'key': 'senderBusinessIdentity', 'type': 'BusinessIdentity'},
        'receiver_business_identity': {'key': 'receiverBusinessIdentity', 'type': 'BusinessIdentity'},
        'protocol_settings': {'key': 'protocolSettings', 'type': 'X12ProtocolSettings'},
    }

    def __init__(
        self,
        *,
        sender_business_identity: "BusinessIdentity",
        receiver_business_identity: "BusinessIdentity",
        protocol_settings: "X12ProtocolSettings",
        **kwargs
    ):
        """
        :keyword sender_business_identity: Required. The sender business identity.
        :paramtype sender_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
        :keyword receiver_business_identity: Required. The receiver business identity.
        :paramtype receiver_business_identity: ~azure.mgmt.logic.models.BusinessIdentity
        :keyword protocol_settings: Required. The X12 protocol settings.
        :paramtype protocol_settings: ~azure.mgmt.logic.models.X12ProtocolSettings
        """
        super(X12OneWayAgreement, self).__init__(**kwargs)
        self.sender_business_identity = sender_business_identity
        self.receiver_business_identity = receiver_business_identity
        self.protocol_settings = protocol_settings


class X12ProcessingSettings(msrest.serialization.Model):
    """The X12 processing settings.

    All required parameters must be populated in order to send to Azure.

    :ivar mask_security_info: Required. The value indicating whether to mask security information.
    :vartype mask_security_info: bool
    :ivar convert_implied_decimal: Required. The value indicating whether to convert numerical type
     to implied decimal.
    :vartype convert_implied_decimal: bool
    :ivar preserve_interchange: Required. The value indicating whether to preserve interchange.
    :vartype preserve_interchange: bool
    :ivar suspend_interchange_on_error: Required. The value indicating whether to suspend
     interchange on error.
    :vartype suspend_interchange_on_error: bool
    :ivar create_empty_xml_tags_for_trailing_separators: Required. The value indicating whether to
     create empty xml tags for trailing separators.
    :vartype create_empty_xml_tags_for_trailing_separators: bool
    :ivar use_dot_as_decimal_separator: Required. The value indicating whether to use dot as
     decimal separator.
    :vartype use_dot_as_decimal_separator: bool
    """

    _validation = {
        'mask_security_info': {'required': True},
        'convert_implied_decimal': {'required': True},
        'preserve_interchange': {'required': True},
        'suspend_interchange_on_error': {'required': True},
        'create_empty_xml_tags_for_trailing_separators': {'required': True},
        'use_dot_as_decimal_separator': {'required': True},
    }

    _attribute_map = {
        'mask_security_info': {'key': 'maskSecurityInfo', 'type': 'bool'},
        'convert_implied_decimal': {'key': 'convertImpliedDecimal', 'type': 'bool'},
        'preserve_interchange': {'key': 'preserveInterchange', 'type': 'bool'},
        'suspend_interchange_on_error': {'key': 'suspendInterchangeOnError', 'type': 'bool'},
        'create_empty_xml_tags_for_trailing_separators': {'key': 'createEmptyXmlTagsForTrailingSeparators', 'type': 'bool'},
        'use_dot_as_decimal_separator': {'key': 'useDotAsDecimalSeparator', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        mask_security_info: bool,
        convert_implied_decimal: bool,
        preserve_interchange: bool,
        suspend_interchange_on_error: bool,
        create_empty_xml_tags_for_trailing_separators: bool,
        use_dot_as_decimal_separator: bool,
        **kwargs
    ):
        """
        :keyword mask_security_info: Required. The value indicating whether to mask security
         information.
        :paramtype mask_security_info: bool
        :keyword convert_implied_decimal: Required. The value indicating whether to convert numerical
         type to implied decimal.
        :paramtype convert_implied_decimal: bool
        :keyword preserve_interchange: Required. The value indicating whether to preserve interchange.
        :paramtype preserve_interchange: bool
        :keyword suspend_interchange_on_error: Required. The value indicating whether to suspend
         interchange on error.
        :paramtype suspend_interchange_on_error: bool
        :keyword create_empty_xml_tags_for_trailing_separators: Required. The value indicating whether
         to create empty xml tags for trailing separators.
        :paramtype create_empty_xml_tags_for_trailing_separators: bool
        :keyword use_dot_as_decimal_separator: Required. The value indicating whether to use dot as
         decimal separator.
        :paramtype use_dot_as_decimal_separator: bool
        """
        super(X12ProcessingSettings, self).__init__(**kwargs)
        self.mask_security_info = mask_security_info
        self.convert_implied_decimal = convert_implied_decimal
        self.preserve_interchange = preserve_interchange
        self.suspend_interchange_on_error = suspend_interchange_on_error
        self.create_empty_xml_tags_for_trailing_separators = create_empty_xml_tags_for_trailing_separators
        self.use_dot_as_decimal_separator = use_dot_as_decimal_separator


class X12ProtocolSettings(msrest.serialization.Model):
    """The X12 agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_settings: Required. The X12 validation settings.
    :vartype validation_settings: ~azure.mgmt.logic.models.X12ValidationSettings
    :ivar framing_settings: Required. The X12 framing settings.
    :vartype framing_settings: ~azure.mgmt.logic.models.X12FramingSettings
    :ivar envelope_settings: Required. The X12 envelope settings.
    :vartype envelope_settings: ~azure.mgmt.logic.models.X12EnvelopeSettings
    :ivar acknowledgement_settings: Required. The X12 acknowledgment settings.
    :vartype acknowledgement_settings: ~azure.mgmt.logic.models.X12AcknowledgementSettings
    :ivar message_filter: Required. The X12 message filter.
    :vartype message_filter: ~azure.mgmt.logic.models.X12MessageFilter
    :ivar security_settings: Required. The X12 security settings.
    :vartype security_settings: ~azure.mgmt.logic.models.X12SecuritySettings
    :ivar processing_settings: Required. The X12 processing settings.
    :vartype processing_settings: ~azure.mgmt.logic.models.X12ProcessingSettings
    :ivar envelope_overrides: The X12 envelope override settings.
    :vartype envelope_overrides: list[~azure.mgmt.logic.models.X12EnvelopeOverride]
    :ivar validation_overrides: The X12 validation override settings.
    :vartype validation_overrides: list[~azure.mgmt.logic.models.X12ValidationOverride]
    :ivar message_filter_list: The X12 message filter list.
    :vartype message_filter_list: list[~azure.mgmt.logic.models.X12MessageIdentifier]
    :ivar schema_references: Required. The X12 schema references.
    :vartype schema_references: list[~azure.mgmt.logic.models.X12SchemaReference]
    :ivar x12_delimiter_overrides: The X12 delimiter override settings.
    :vartype x12_delimiter_overrides: list[~azure.mgmt.logic.models.X12DelimiterOverrides]
    """

    _validation = {
        'validation_settings': {'required': True},
        'framing_settings': {'required': True},
        'envelope_settings': {'required': True},
        'acknowledgement_settings': {'required': True},
        'message_filter': {'required': True},
        'security_settings': {'required': True},
        'processing_settings': {'required': True},
        'schema_references': {'required': True},
    }

    _attribute_map = {
        'validation_settings': {'key': 'validationSettings', 'type': 'X12ValidationSettings'},
        'framing_settings': {'key': 'framingSettings', 'type': 'X12FramingSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'X12EnvelopeSettings'},
        'acknowledgement_settings': {'key': 'acknowledgementSettings', 'type': 'X12AcknowledgementSettings'},
        'message_filter': {'key': 'messageFilter', 'type': 'X12MessageFilter'},
        'security_settings': {'key': 'securitySettings', 'type': 'X12SecuritySettings'},
        'processing_settings': {'key': 'processingSettings', 'type': 'X12ProcessingSettings'},
        'envelope_overrides': {'key': 'envelopeOverrides', 'type': '[X12EnvelopeOverride]'},
        'validation_overrides': {'key': 'validationOverrides', 'type': '[X12ValidationOverride]'},
        'message_filter_list': {'key': 'messageFilterList', 'type': '[X12MessageIdentifier]'},
        'schema_references': {'key': 'schemaReferences', 'type': '[X12SchemaReference]'},
        'x12_delimiter_overrides': {'key': 'x12DelimiterOverrides', 'type': '[X12DelimiterOverrides]'},
    }

    def __init__(
        self,
        *,
        validation_settings: "X12ValidationSettings",
        framing_settings: "X12FramingSettings",
        envelope_settings: "X12EnvelopeSettings",
        acknowledgement_settings: "X12AcknowledgementSettings",
        message_filter: "X12MessageFilter",
        security_settings: "X12SecuritySettings",
        processing_settings: "X12ProcessingSettings",
        schema_references: List["X12SchemaReference"],
        envelope_overrides: Optional[List["X12EnvelopeOverride"]] = None,
        validation_overrides: Optional[List["X12ValidationOverride"]] = None,
        message_filter_list: Optional[List["X12MessageIdentifier"]] = None,
        x12_delimiter_overrides: Optional[List["X12DelimiterOverrides"]] = None,
        **kwargs
    ):
        """
        :keyword validation_settings: Required. The X12 validation settings.
        :paramtype validation_settings: ~azure.mgmt.logic.models.X12ValidationSettings
        :keyword framing_settings: Required. The X12 framing settings.
        :paramtype framing_settings: ~azure.mgmt.logic.models.X12FramingSettings
        :keyword envelope_settings: Required. The X12 envelope settings.
        :paramtype envelope_settings: ~azure.mgmt.logic.models.X12EnvelopeSettings
        :keyword acknowledgement_settings: Required. The X12 acknowledgment settings.
        :paramtype acknowledgement_settings: ~azure.mgmt.logic.models.X12AcknowledgementSettings
        :keyword message_filter: Required. The X12 message filter.
        :paramtype message_filter: ~azure.mgmt.logic.models.X12MessageFilter
        :keyword security_settings: Required. The X12 security settings.
        :paramtype security_settings: ~azure.mgmt.logic.models.X12SecuritySettings
        :keyword processing_settings: Required. The X12 processing settings.
        :paramtype processing_settings: ~azure.mgmt.logic.models.X12ProcessingSettings
        :keyword envelope_overrides: The X12 envelope override settings.
        :paramtype envelope_overrides: list[~azure.mgmt.logic.models.X12EnvelopeOverride]
        :keyword validation_overrides: The X12 validation override settings.
        :paramtype validation_overrides: list[~azure.mgmt.logic.models.X12ValidationOverride]
        :keyword message_filter_list: The X12 message filter list.
        :paramtype message_filter_list: list[~azure.mgmt.logic.models.X12MessageIdentifier]
        :keyword schema_references: Required. The X12 schema references.
        :paramtype schema_references: list[~azure.mgmt.logic.models.X12SchemaReference]
        :keyword x12_delimiter_overrides: The X12 delimiter override settings.
        :paramtype x12_delimiter_overrides: list[~azure.mgmt.logic.models.X12DelimiterOverrides]
        """
        super(X12ProtocolSettings, self).__init__(**kwargs)
        self.validation_settings = validation_settings
        self.framing_settings = framing_settings
        self.envelope_settings = envelope_settings
        self.acknowledgement_settings = acknowledgement_settings
        self.message_filter = message_filter
        self.security_settings = security_settings
        self.processing_settings = processing_settings
        self.envelope_overrides = envelope_overrides
        self.validation_overrides = validation_overrides
        self.message_filter_list = message_filter_list
        self.schema_references = schema_references
        self.x12_delimiter_overrides = x12_delimiter_overrides


class X12SchemaReference(msrest.serialization.Model):
    """The X12 schema reference.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The message id.
    :vartype message_id: str
    :ivar sender_application_id: The sender application id.
    :vartype sender_application_id: str
    :ivar schema_version: Required. The schema version.
    :vartype schema_version: str
    :ivar schema_name: Required. The schema name.
    :vartype schema_name: str
    """

    _validation = {
        'message_id': {'required': True},
        'schema_version': {'required': True},
        'schema_name': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'schema_version': {'key': 'schemaVersion', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        schema_version: str,
        schema_name: str,
        sender_application_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message_id: Required. The message id.
        :paramtype message_id: str
        :keyword sender_application_id: The sender application id.
        :paramtype sender_application_id: str
        :keyword schema_version: Required. The schema version.
        :paramtype schema_version: str
        :keyword schema_name: Required. The schema name.
        :paramtype schema_name: str
        """
        super(X12SchemaReference, self).__init__(**kwargs)
        self.message_id = message_id
        self.sender_application_id = sender_application_id
        self.schema_version = schema_version
        self.schema_name = schema_name


class X12SecuritySettings(msrest.serialization.Model):
    """The X12 agreement security settings.

    All required parameters must be populated in order to send to Azure.

    :ivar authorization_qualifier: Required. The authorization qualifier.
    :vartype authorization_qualifier: str
    :ivar authorization_value: The authorization value.
    :vartype authorization_value: str
    :ivar security_qualifier: Required. The security qualifier.
    :vartype security_qualifier: str
    :ivar password_value: The password value.
    :vartype password_value: str
    """

    _validation = {
        'authorization_qualifier': {'required': True},
        'security_qualifier': {'required': True},
    }

    _attribute_map = {
        'authorization_qualifier': {'key': 'authorizationQualifier', 'type': 'str'},
        'authorization_value': {'key': 'authorizationValue', 'type': 'str'},
        'security_qualifier': {'key': 'securityQualifier', 'type': 'str'},
        'password_value': {'key': 'passwordValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authorization_qualifier: str,
        security_qualifier: str,
        authorization_value: Optional[str] = None,
        password_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authorization_qualifier: Required. The authorization qualifier.
        :paramtype authorization_qualifier: str
        :keyword authorization_value: The authorization value.
        :paramtype authorization_value: str
        :keyword security_qualifier: Required. The security qualifier.
        :paramtype security_qualifier: str
        :keyword password_value: The password value.
        :paramtype password_value: str
        """
        super(X12SecuritySettings, self).__init__(**kwargs)
        self.authorization_qualifier = authorization_qualifier
        self.authorization_value = authorization_value
        self.security_qualifier = security_qualifier
        self.password_value = password_value


class X12ValidationOverride(msrest.serialization.Model):
    """The X12 validation override settings.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The message id on which the validation settings has to be applied.
    :vartype message_id: str
    :ivar validate_edi_types: Required. The value indicating whether to validate EDI types.
    :vartype validate_edi_types: bool
    :ivar validate_xsd_types: Required. The value indicating whether to validate XSD types.
    :vartype validate_xsd_types: bool
    :ivar allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     allow leading and trailing spaces and zeroes.
    :vartype allow_leading_and_trailing_spaces_and_zeroes: bool
    :ivar validate_character_set: Required. The value indicating whether to validate character Set.
    :vartype validate_character_set: bool
    :ivar trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     trim leading and trailing spaces and zeroes.
    :vartype trim_leading_and_trailing_spaces_and_zeroes: bool
    :ivar trailing_separator_policy: Required. The trailing separator policy. Possible values
     include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
    :vartype trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    """

    _validation = {
        'message_id': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'validate_character_set': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'validate_character_set': {'key': 'validateCharacterSet', 'type': 'bool'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_id: str,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        validate_character_set: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: Union[str, "TrailingSeparatorPolicy"],
        **kwargs
    ):
        """
        :keyword message_id: Required. The message id on which the validation settings has to be
         applied.
        :paramtype message_id: str
        :keyword validate_edi_types: Required. The value indicating whether to validate EDI types.
        :paramtype validate_edi_types: bool
        :keyword validate_xsd_types: Required. The value indicating whether to validate XSD types.
        :paramtype validate_xsd_types: bool
        :keyword allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether
         to allow leading and trailing spaces and zeroes.
        :paramtype allow_leading_and_trailing_spaces_and_zeroes: bool
        :keyword validate_character_set: Required. The value indicating whether to validate character
         Set.
        :paramtype validate_character_set: bool
        :keyword trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
         trim leading and trailing spaces and zeroes.
        :paramtype trim_leading_and_trailing_spaces_and_zeroes: bool
        :keyword trailing_separator_policy: Required. The trailing separator policy. Possible values
         include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
        :paramtype trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
        """
        super(X12ValidationOverride, self).__init__(**kwargs)
        self.message_id = message_id
        self.validate_edi_types = validate_edi_types
        self.validate_xsd_types = validate_xsd_types
        self.allow_leading_and_trailing_spaces_and_zeroes = allow_leading_and_trailing_spaces_and_zeroes
        self.validate_character_set = validate_character_set
        self.trim_leading_and_trailing_spaces_and_zeroes = trim_leading_and_trailing_spaces_and_zeroes
        self.trailing_separator_policy = trailing_separator_policy


class X12ValidationSettings(msrest.serialization.Model):
    """The X12 agreement validation settings.

    All required parameters must be populated in order to send to Azure.

    :ivar validate_character_set: Required. The value indicating whether to validate character set
     in the message.
    :vartype validate_character_set: bool
    :ivar check_duplicate_interchange_control_number: Required. The value indicating whether to
     check for duplicate interchange control number.
    :vartype check_duplicate_interchange_control_number: bool
    :ivar interchange_control_number_validity_days: Required. The validity period of interchange
     control number.
    :vartype interchange_control_number_validity_days: int
    :ivar check_duplicate_group_control_number: Required. The value indicating whether to check for
     duplicate group control number.
    :vartype check_duplicate_group_control_number: bool
    :ivar check_duplicate_transaction_set_control_number: Required. The value indicating whether to
     check for duplicate transaction set control number.
    :vartype check_duplicate_transaction_set_control_number: bool
    :ivar validate_edi_types: Required. The value indicating whether to Whether to validate EDI
     types.
    :vartype validate_edi_types: bool
    :ivar validate_xsd_types: Required. The value indicating whether to Whether to validate XSD
     types.
    :vartype validate_xsd_types: bool
    :ivar allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     allow leading and trailing spaces and zeroes.
    :vartype allow_leading_and_trailing_spaces_and_zeroes: bool
    :ivar trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
     trim leading and trailing spaces and zeroes.
    :vartype trim_leading_and_trailing_spaces_and_zeroes: bool
    :ivar trailing_separator_policy: Required. The trailing separator policy. Possible values
     include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
    :vartype trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
    """

    _validation = {
        'validate_character_set': {'required': True},
        'check_duplicate_interchange_control_number': {'required': True},
        'interchange_control_number_validity_days': {'required': True},
        'check_duplicate_group_control_number': {'required': True},
        'check_duplicate_transaction_set_control_number': {'required': True},
        'validate_edi_types': {'required': True},
        'validate_xsd_types': {'required': True},
        'allow_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trim_leading_and_trailing_spaces_and_zeroes': {'required': True},
        'trailing_separator_policy': {'required': True},
    }

    _attribute_map = {
        'validate_character_set': {'key': 'validateCharacterSet', 'type': 'bool'},
        'check_duplicate_interchange_control_number': {'key': 'checkDuplicateInterchangeControlNumber', 'type': 'bool'},
        'interchange_control_number_validity_days': {'key': 'interchangeControlNumberValidityDays', 'type': 'int'},
        'check_duplicate_group_control_number': {'key': 'checkDuplicateGroupControlNumber', 'type': 'bool'},
        'check_duplicate_transaction_set_control_number': {'key': 'checkDuplicateTransactionSetControlNumber', 'type': 'bool'},
        'validate_edi_types': {'key': 'validateEDITypes', 'type': 'bool'},
        'validate_xsd_types': {'key': 'validateXSDTypes', 'type': 'bool'},
        'allow_leading_and_trailing_spaces_and_zeroes': {'key': 'allowLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trim_leading_and_trailing_spaces_and_zeroes': {'key': 'trimLeadingAndTrailingSpacesAndZeroes', 'type': 'bool'},
        'trailing_separator_policy': {'key': 'trailingSeparatorPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validate_character_set: bool,
        check_duplicate_interchange_control_number: bool,
        interchange_control_number_validity_days: int,
        check_duplicate_group_control_number: bool,
        check_duplicate_transaction_set_control_number: bool,
        validate_edi_types: bool,
        validate_xsd_types: bool,
        allow_leading_and_trailing_spaces_and_zeroes: bool,
        trim_leading_and_trailing_spaces_and_zeroes: bool,
        trailing_separator_policy: Union[str, "TrailingSeparatorPolicy"],
        **kwargs
    ):
        """
        :keyword validate_character_set: Required. The value indicating whether to validate character
         set in the message.
        :paramtype validate_character_set: bool
        :keyword check_duplicate_interchange_control_number: Required. The value indicating whether to
         check for duplicate interchange control number.
        :paramtype check_duplicate_interchange_control_number: bool
        :keyword interchange_control_number_validity_days: Required. The validity period of interchange
         control number.
        :paramtype interchange_control_number_validity_days: int
        :keyword check_duplicate_group_control_number: Required. The value indicating whether to check
         for duplicate group control number.
        :paramtype check_duplicate_group_control_number: bool
        :keyword check_duplicate_transaction_set_control_number: Required. The value indicating whether
         to check for duplicate transaction set control number.
        :paramtype check_duplicate_transaction_set_control_number: bool
        :keyword validate_edi_types: Required. The value indicating whether to Whether to validate EDI
         types.
        :paramtype validate_edi_types: bool
        :keyword validate_xsd_types: Required. The value indicating whether to Whether to validate XSD
         types.
        :paramtype validate_xsd_types: bool
        :keyword allow_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether
         to allow leading and trailing spaces and zeroes.
        :paramtype allow_leading_and_trailing_spaces_and_zeroes: bool
        :keyword trim_leading_and_trailing_spaces_and_zeroes: Required. The value indicating whether to
         trim leading and trailing spaces and zeroes.
        :paramtype trim_leading_and_trailing_spaces_and_zeroes: bool
        :keyword trailing_separator_policy: Required. The trailing separator policy. Possible values
         include: "NotSpecified", "NotAllowed", "Optional", "Mandatory".
        :paramtype trailing_separator_policy: str or ~azure.mgmt.logic.models.TrailingSeparatorPolicy
        """
        super(X12ValidationSettings, self).__init__(**kwargs)
        self.validate_character_set = validate_character_set
        self.check_duplicate_interchange_control_number = check_duplicate_interchange_control_number
        self.interchange_control_number_validity_days = interchange_control_number_validity_days
        self.check_duplicate_group_control_number = check_duplicate_group_control_number
        self.check_duplicate_transaction_set_control_number = check_duplicate_transaction_set_control_number
        self.validate_edi_types = validate_edi_types
        self.validate_xsd_types = validate_xsd_types
        self.allow_leading_and_trailing_spaces_and_zeroes = allow_leading_and_trailing_spaces_and_zeroes
        self.trim_leading_and_trailing_spaces_and_zeroes = trim_leading_and_trailing_spaces_and_zeroes
        self.trailing_separator_policy = trailing_separator_policy
