# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._containers_operations import (
    build_attach_request,
    build_execute_command_request,
    build_list_logs_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ContainersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.containerinstance.aio.ContainerInstanceManagementClient`'s
        :attr:`containers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_logs(
        self,
        resource_group_name: str,
        container_group_name: str,
        container_name: str,
        tail: Optional[int] = None,
        timestamps: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.Logs:
        """Get the logs for a specified container instance.

        Get the logs for a specified container instance in a specified resource group and container
        group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param container_group_name: The name of the container group. Required.
        :type container_group_name: str
        :param container_name: The name of the container instance. Required.
        :type container_name: str
        :param tail: The number of lines to show from the tail of the container instance log. If not
         provided, all available logs are shown up to 4mb. Default value is None.
        :type tail: int
        :param timestamps: If true, adds a timestamp at the beginning of every line of log output. If
         not provided, defaults to false. Default value is None.
        :type timestamps: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Logs or the result of cls(response)
        :rtype: ~azure.mgmt.containerinstance.models.Logs
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Logs]

        request = build_list_logs_request(
            resource_group_name=resource_group_name,
            container_group_name=container_group_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            tail=tail,
            timestamps=timestamps,
            api_version=api_version,
            template_url=self.list_logs.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Logs", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_logs.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/logs"}  # type: ignore

    @overload
    async def execute_command(
        self,
        resource_group_name: str,
        container_group_name: str,
        container_name: str,
        container_exec_request: _models.ContainerExecRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ContainerExecResponse:
        """Executes a command in a specific container instance.

        Executes a command for a specific container instance in a specified resource group and
        container group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param container_group_name: The name of the container group. Required.
        :type container_group_name: str
        :param container_name: The name of the container instance. Required.
        :type container_name: str
        :param container_exec_request: The request for the exec command. Required.
        :type container_exec_request: ~azure.mgmt.containerinstance.models.ContainerExecRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerExecResponse or the result of cls(response)
        :rtype: ~azure.mgmt.containerinstance.models.ContainerExecResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def execute_command(
        self,
        resource_group_name: str,
        container_group_name: str,
        container_name: str,
        container_exec_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ContainerExecResponse:
        """Executes a command in a specific container instance.

        Executes a command for a specific container instance in a specified resource group and
        container group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param container_group_name: The name of the container group. Required.
        :type container_group_name: str
        :param container_name: The name of the container instance. Required.
        :type container_name: str
        :param container_exec_request: The request for the exec command. Required.
        :type container_exec_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerExecResponse or the result of cls(response)
        :rtype: ~azure.mgmt.containerinstance.models.ContainerExecResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def execute_command(
        self,
        resource_group_name: str,
        container_group_name: str,
        container_name: str,
        container_exec_request: Union[_models.ContainerExecRequest, IO],
        **kwargs: Any
    ) -> _models.ContainerExecResponse:
        """Executes a command in a specific container instance.

        Executes a command for a specific container instance in a specified resource group and
        container group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param container_group_name: The name of the container group. Required.
        :type container_group_name: str
        :param container_name: The name of the container instance. Required.
        :type container_name: str
        :param container_exec_request: The request for the exec command. Is either a model type or a IO
         type. Required.
        :type container_exec_request: ~azure.mgmt.containerinstance.models.ContainerExecRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerExecResponse or the result of cls(response)
        :rtype: ~azure.mgmt.containerinstance.models.ContainerExecResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ContainerExecResponse]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(container_exec_request, (IO, bytes)):
            _content = container_exec_request
        else:
            _json = self._serialize.body(container_exec_request, "ContainerExecRequest")

        request = build_execute_command_request(
            resource_group_name=resource_group_name,
            container_group_name=container_group_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.execute_command.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ContainerExecResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_command.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/exec"}  # type: ignore

    @distributed_trace_async
    async def attach(
        self, resource_group_name: str, container_group_name: str, container_name: str, **kwargs: Any
    ) -> _models.ContainerAttachResponse:
        """Attach to the output of a specific container instance.

        Attach to the output stream of a specific container instance in a specified resource group and
        container group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param container_group_name: The name of the container group. Required.
        :type container_group_name: str
        :param container_name: The name of the container instance. Required.
        :type container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerAttachResponse or the result of cls(response)
        :rtype: ~azure.mgmt.containerinstance.models.ContainerAttachResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ContainerAttachResponse]

        request = build_attach_request(
            resource_group_name=resource_group_name,
            container_group_name=container_group_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.attach.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ContainerAttachResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    attach.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/attach"}  # type: ignore
