# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CommunicationError(_serialization.Model):
    """The Communication Services error.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: The error message. Required.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: Further details about specific errors that led to this error.
    :vartype details: list[~azure.communication.phonenumbers.models.CommunicationError]
    :ivar inner_error: The inner error if any.
    :vartype inner_error: ~azure.communication.phonenumbers.models.CommunicationError
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CommunicationError]"},
        "inner_error": {"key": "innererror", "type": "CommunicationError"},
    }

    def __init__(self, *, code: str, message: str, **kwargs):
        """
        :keyword code: The error code. Required.
        :paramtype code: str
        :keyword message: The error message. Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = None
        self.details = None
        self.inner_error = None


class CommunicationErrorResponse(_serialization.Model):
    """The Communication Services error.

    All required parameters must be populated in order to send to Azure.

    :ivar error: The Communication Services error. Required.
    :vartype error: ~azure.communication.phonenumbers.models.CommunicationError
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "CommunicationError"},
    }

    def __init__(self, *, error: "_models.CommunicationError", **kwargs):
        """
        :keyword error: The Communication Services error. Required.
        :paramtype error: ~azure.communication.phonenumbers.models.CommunicationError
        """
        super().__init__(**kwargs)
        self.error = error


class PhoneNumberCapabilities(_serialization.Model):
    """Capabilities of a phone number.

    All required parameters must be populated in order to send to Azure.

    :ivar calling: Capability value for calling. Required. Known values are: "none", "inbound",
     "outbound", and "inbound+outbound".
    :vartype calling: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
    :ivar sms: Capability value for SMS. Required. Known values are: "none", "inbound", "outbound",
     and "inbound+outbound".
    :vartype sms: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
    """

    _validation = {
        "calling": {"required": True},
        "sms": {"required": True},
    }

    _attribute_map = {
        "calling": {"key": "calling", "type": "str"},
        "sms": {"key": "sms", "type": "str"},
    }

    def __init__(
        self,
        *,
        calling: Union[str, "_models.PhoneNumberCapabilityType"],
        sms: Union[str, "_models.PhoneNumberCapabilityType"],
        **kwargs
    ):
        """
        :keyword calling: Capability value for calling. Required. Known values are: "none", "inbound",
         "outbound", and "inbound+outbound".
        :paramtype calling: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
        :keyword sms: Capability value for SMS. Required. Known values are: "none", "inbound",
         "outbound", and "inbound+outbound".
        :paramtype sms: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
        """
        super().__init__(**kwargs)
        self.calling = calling
        self.sms = sms


class PhoneNumberCapabilitiesRequest(_serialization.Model):
    """Capabilities of a phone number.

    :ivar calling: Capability value for calling. Known values are: "none", "inbound", "outbound",
     and "inbound+outbound".
    :vartype calling: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
    :ivar sms: Capability value for SMS. Known values are: "none", "inbound", "outbound", and
     "inbound+outbound".
    :vartype sms: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
    """

    _attribute_map = {
        "calling": {"key": "calling", "type": "str"},
        "sms": {"key": "sms", "type": "str"},
    }

    def __init__(
        self,
        *,
        calling: Optional[Union[str, "_models.PhoneNumberCapabilityType"]] = None,
        sms: Optional[Union[str, "_models.PhoneNumberCapabilityType"]] = None,
        **kwargs
    ):
        """
        :keyword calling: Capability value for calling. Known values are: "none", "inbound",
         "outbound", and "inbound+outbound".
        :paramtype calling: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
        :keyword sms: Capability value for SMS. Known values are: "none", "inbound", "outbound", and
         "inbound+outbound".
        :paramtype sms: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
        """
        super().__init__(**kwargs)
        self.calling = calling
        self.sms = sms


class PhoneNumberCost(_serialization.Model):
    """The incurred cost for a single phone number.

    All required parameters must be populated in order to send to Azure.

    :ivar amount: The cost amount. Required.
    :vartype amount: float
    :ivar currency_code: The ISO 4217 currency code for the cost amount, e.g. USD. Required.
    :vartype currency_code: str
    :ivar billing_frequency: The frequency with which the cost gets billed. Required. "monthly"
    :vartype billing_frequency: str or ~azure.communication.phonenumbers.models.BillingFrequency
    """

    _validation = {
        "amount": {"required": True},
        "currency_code": {"required": True},
        "billing_frequency": {"required": True},
    }

    _attribute_map = {
        "amount": {"key": "amount", "type": "float"},
        "currency_code": {"key": "currencyCode", "type": "str"},
        "billing_frequency": {"key": "billingFrequency", "type": "str"},
    }

    def __init__(
        self, *, amount: float, currency_code: str, billing_frequency: Union[str, "_models.BillingFrequency"], **kwargs
    ):
        """
        :keyword amount: The cost amount. Required.
        :paramtype amount: float
        :keyword currency_code: The ISO 4217 currency code for the cost amount, e.g. USD. Required.
        :paramtype currency_code: str
        :keyword billing_frequency: The frequency with which the cost gets billed. Required. "monthly"
        :paramtype billing_frequency: str or ~azure.communication.phonenumbers.models.BillingFrequency
        """
        super().__init__(**kwargs)
        self.amount = amount
        self.currency_code = currency_code
        self.billing_frequency = billing_frequency


class PhoneNumberOperation(_serialization.Model):
    """Long running operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Status of operation. Required. Known values are: "notStarted", "running",
     "succeeded", and "failed".
    :vartype status: str or ~azure.communication.phonenumbers.models.PhoneNumberOperationStatus
    :ivar resource_location: URL for retrieving the result of the operation, if any.
    :vartype resource_location: str
    :ivar created_date_time: The date that the operation was created. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar error: The Communication Services error.
    :vartype error: ~azure.communication.phonenumbers.models.CommunicationError
    :ivar id: Id of operation. Required.
    :vartype id: str
    :ivar operation_type: The type of operation, e.g. Search. Required. Known values are:
     "purchase", "releasePhoneNumber", "search", and "updatePhoneNumberCapabilities".
    :vartype operation_type: str or
     ~azure.communication.phonenumbers.models.PhoneNumberOperationType
    :ivar last_action_date_time: The most recent date that the operation was changed.
    :vartype last_action_date_time: ~datetime.datetime
    """

    _validation = {
        "status": {"required": True},
        "created_date_time": {"required": True},
        "id": {"required": True},
        "operation_type": {"required": True},
        "last_action_date_time": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "CommunicationError"},
        "id": {"key": "id", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "last_action_date_time": {"key": "lastActionDateTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.PhoneNumberOperationStatus"],
        created_date_time: datetime.datetime,
        id: str,  # pylint: disable=redefined-builtin
        operation_type: Union[str, "_models.PhoneNumberOperationType"],
        resource_location: Optional[str] = None,
        error: Optional["_models.CommunicationError"] = None,
        **kwargs
    ):
        """
        :keyword status: Status of operation. Required. Known values are: "notStarted", "running",
         "succeeded", and "failed".
        :paramtype status: str or ~azure.communication.phonenumbers.models.PhoneNumberOperationStatus
        :keyword resource_location: URL for retrieving the result of the operation, if any.
        :paramtype resource_location: str
        :keyword created_date_time: The date that the operation was created. Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword error: The Communication Services error.
        :paramtype error: ~azure.communication.phonenumbers.models.CommunicationError
        :keyword id: Id of operation. Required.
        :paramtype id: str
        :keyword operation_type: The type of operation, e.g. Search. Required. Known values are:
         "purchase", "releasePhoneNumber", "search", and "updatePhoneNumberCapabilities".
        :paramtype operation_type: str or
         ~azure.communication.phonenumbers.models.PhoneNumberOperationType
        """
        super().__init__(**kwargs)
        self.status = status
        self.resource_location = resource_location
        self.created_date_time = created_date_time
        self.error = error
        self.id = id
        self.operation_type = operation_type
        self.last_action_date_time = None


class PhoneNumberPurchaseRequest(_serialization.Model):
    """The phone number search purchase request.

    :ivar search_id: The search id.
    :vartype search_id: str
    """

    _attribute_map = {
        "search_id": {"key": "searchId", "type": "str"},
    }

    def __init__(self, *, search_id: Optional[str] = None, **kwargs):
        """
        :keyword search_id: The search id.
        :paramtype search_id: str
        """
        super().__init__(**kwargs)
        self.search_id = search_id


class PhoneNumberSearchRequest(_serialization.Model):
    """Represents a phone number search request to find phone numbers. Found phone numbers are temporarily held for a following purchase.

    All required parameters must be populated in order to send to Azure.

    :ivar phone_number_type: The type of phone numbers to search for, e.g. geographic, or tollFree.
     Required. Known values are: "geographic" and "tollFree".
    :vartype phone_number_type: str or ~azure.communication.phonenumbers.models.PhoneNumberType
    :ivar assignment_type: The assignment type of the phone numbers to search for. A phone number
     can be assigned to a person, or to an application. Required. Known values are: "person" and
     "application".
    :vartype assignment_type: str or
     ~azure.communication.phonenumbers.models.PhoneNumberAssignmentType
    :ivar capabilities: Capabilities of a phone number. Required.
    :vartype capabilities: ~azure.communication.phonenumbers.models.PhoneNumberCapabilities
    :ivar area_code: The area code of the desired phone number, e.g. 425.
    :vartype area_code: str
    :ivar quantity: The quantity of desired phone numbers. The default value is 1.
    :vartype quantity: int
    """

    _validation = {
        "phone_number_type": {"required": True},
        "assignment_type": {"required": True},
        "capabilities": {"required": True},
        "quantity": {"maximum": 2147483647, "minimum": 1},
    }

    _attribute_map = {
        "phone_number_type": {"key": "phoneNumberType", "type": "str"},
        "assignment_type": {"key": "assignmentType", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "PhoneNumberCapabilities"},
        "area_code": {"key": "areaCode", "type": "str"},
        "quantity": {"key": "quantity", "type": "int"},
    }

    def __init__(
        self,
        *,
        phone_number_type: Union[str, "_models.PhoneNumberType"],
        assignment_type: Union[str, "_models.PhoneNumberAssignmentType"],
        capabilities: "_models.PhoneNumberCapabilities",
        area_code: Optional[str] = None,
        quantity: int = 1,
        **kwargs
    ):
        """
        :keyword phone_number_type: The type of phone numbers to search for, e.g. geographic, or
         tollFree. Required. Known values are: "geographic" and "tollFree".
        :paramtype phone_number_type: str or ~azure.communication.phonenumbers.models.PhoneNumberType
        :keyword assignment_type: The assignment type of the phone numbers to search for. A phone
         number can be assigned to a person, or to an application. Required. Known values are: "person"
         and "application".
        :paramtype assignment_type: str or
         ~azure.communication.phonenumbers.models.PhoneNumberAssignmentType
        :keyword capabilities: Capabilities of a phone number. Required.
        :paramtype capabilities: ~azure.communication.phonenumbers.models.PhoneNumberCapabilities
        :keyword area_code: The area code of the desired phone number, e.g. 425.
        :paramtype area_code: str
        :keyword quantity: The quantity of desired phone numbers. The default value is 1.
        :paramtype quantity: int
        """
        super().__init__(**kwargs)
        self.phone_number_type = phone_number_type
        self.assignment_type = assignment_type
        self.capabilities = capabilities
        self.area_code = area_code
        self.quantity = quantity


class PhoneNumberSearchResult(_serialization.Model):
    """The result of a phone number search operation.

    All required parameters must be populated in order to send to Azure.

    :ivar search_id: The search id. Required.
    :vartype search_id: str
    :ivar phone_numbers: The phone numbers that are available. Can be fewer than the desired search
     quantity. Required.
    :vartype phone_numbers: list[str]
    :ivar phone_number_type: The phone number's type, e.g. geographic, or tollFree. Required. Known
     values are: "geographic" and "tollFree".
    :vartype phone_number_type: str or ~azure.communication.phonenumbers.models.PhoneNumberType
    :ivar assignment_type: Phone number's assignment type. Required. Known values are: "person" and
     "application".
    :vartype assignment_type: str or
     ~azure.communication.phonenumbers.models.PhoneNumberAssignmentType
    :ivar capabilities: Capabilities of a phone number. Required.
    :vartype capabilities: ~azure.communication.phonenumbers.models.PhoneNumberCapabilities
    :ivar cost: The incurred cost for a single phone number. Required.
    :vartype cost: ~azure.communication.phonenumbers.models.PhoneNumberCost
    :ivar search_expires_by: The date that this search result expires and phone numbers are no
     longer on hold. A search result expires in less than 15min, e.g. 2020-11-19T16:31:49.048Z.
     Required.
    :vartype search_expires_by: ~datetime.datetime
    """

    _validation = {
        "search_id": {"required": True},
        "phone_numbers": {"required": True},
        "phone_number_type": {"required": True},
        "assignment_type": {"required": True},
        "capabilities": {"required": True},
        "cost": {"required": True},
        "search_expires_by": {"required": True},
    }

    _attribute_map = {
        "search_id": {"key": "searchId", "type": "str"},
        "phone_numbers": {"key": "phoneNumbers", "type": "[str]"},
        "phone_number_type": {"key": "phoneNumberType", "type": "str"},
        "assignment_type": {"key": "assignmentType", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "PhoneNumberCapabilities"},
        "cost": {"key": "cost", "type": "PhoneNumberCost"},
        "search_expires_by": {"key": "searchExpiresBy", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        search_id: str,
        phone_numbers: List[str],
        phone_number_type: Union[str, "_models.PhoneNumberType"],
        assignment_type: Union[str, "_models.PhoneNumberAssignmentType"],
        capabilities: "_models.PhoneNumberCapabilities",
        cost: "_models.PhoneNumberCost",
        search_expires_by: datetime.datetime,
        **kwargs
    ):
        """
        :keyword search_id: The search id. Required.
        :paramtype search_id: str
        :keyword phone_numbers: The phone numbers that are available. Can be fewer than the desired
         search quantity. Required.
        :paramtype phone_numbers: list[str]
        :keyword phone_number_type: The phone number's type, e.g. geographic, or tollFree. Required.
         Known values are: "geographic" and "tollFree".
        :paramtype phone_number_type: str or ~azure.communication.phonenumbers.models.PhoneNumberType
        :keyword assignment_type: Phone number's assignment type. Required. Known values are: "person"
         and "application".
        :paramtype assignment_type: str or
         ~azure.communication.phonenumbers.models.PhoneNumberAssignmentType
        :keyword capabilities: Capabilities of a phone number. Required.
        :paramtype capabilities: ~azure.communication.phonenumbers.models.PhoneNumberCapabilities
        :keyword cost: The incurred cost for a single phone number. Required.
        :paramtype cost: ~azure.communication.phonenumbers.models.PhoneNumberCost
        :keyword search_expires_by: The date that this search result expires and phone numbers are no
         longer on hold. A search result expires in less than 15min, e.g. 2020-11-19T16:31:49.048Z.
         Required.
        :paramtype search_expires_by: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.search_id = search_id
        self.phone_numbers = phone_numbers
        self.phone_number_type = phone_number_type
        self.assignment_type = assignment_type
        self.capabilities = capabilities
        self.cost = cost
        self.search_expires_by = search_expires_by


class PurchasedPhoneNumber(_serialization.Model):
    """Represents a purchased phone number.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The id of the phone number, e.g. 11234567890. Required.
    :vartype id: str
    :ivar phone_number: String of the E.164 format of the phone number, e.g. +11234567890.
     Required.
    :vartype phone_number: str
    :ivar country_code: The ISO 3166-2 code of the phone number's country, e.g. US. Required.
    :vartype country_code: str
    :ivar phone_number_type: The phone number's type, e.g. Geographic, TollFree. Required. Known
     values are: "geographic" and "tollFree".
    :vartype phone_number_type: str or ~azure.communication.phonenumbers.models.PhoneNumberType
    :ivar capabilities: Capabilities of a phone number. Required.
    :vartype capabilities: ~azure.communication.phonenumbers.models.PhoneNumberCapabilities
    :ivar assignment_type: The assignment type of the phone number. A phone number can be assigned
     to a person, or to an application. Required. Known values are: "person" and "application".
    :vartype assignment_type: str or
     ~azure.communication.phonenumbers.models.PhoneNumberAssignmentType
    :ivar purchase_date: The date and time that the phone number was purchased. Required.
    :vartype purchase_date: ~datetime.datetime
    :ivar cost: The incurred cost for a single phone number. Required.
    :vartype cost: ~azure.communication.phonenumbers.models.PhoneNumberCost
    """

    _validation = {
        "id": {"required": True},
        "phone_number": {"required": True},
        "country_code": {"required": True},
        "phone_number_type": {"required": True},
        "capabilities": {"required": True},
        "assignment_type": {"required": True},
        "purchase_date": {"required": True},
        "cost": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "phone_number_type": {"key": "phoneNumberType", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "PhoneNumberCapabilities"},
        "assignment_type": {"key": "assignmentType", "type": "str"},
        "purchase_date": {"key": "purchaseDate", "type": "iso-8601"},
        "cost": {"key": "cost", "type": "PhoneNumberCost"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        phone_number: str,
        country_code: str,
        phone_number_type: Union[str, "_models.PhoneNumberType"],
        capabilities: "_models.PhoneNumberCapabilities",
        assignment_type: Union[str, "_models.PhoneNumberAssignmentType"],
        purchase_date: datetime.datetime,
        cost: "_models.PhoneNumberCost",
        **kwargs
    ):
        """
        :keyword id: The id of the phone number, e.g. 11234567890. Required.
        :paramtype id: str
        :keyword phone_number: String of the E.164 format of the phone number, e.g. +11234567890.
         Required.
        :paramtype phone_number: str
        :keyword country_code: The ISO 3166-2 code of the phone number's country, e.g. US. Required.
        :paramtype country_code: str
        :keyword phone_number_type: The phone number's type, e.g. Geographic, TollFree. Required. Known
         values are: "geographic" and "tollFree".
        :paramtype phone_number_type: str or ~azure.communication.phonenumbers.models.PhoneNumberType
        :keyword capabilities: Capabilities of a phone number. Required.
        :paramtype capabilities: ~azure.communication.phonenumbers.models.PhoneNumberCapabilities
        :keyword assignment_type: The assignment type of the phone number. A phone number can be
         assigned to a person, or to an application. Required. Known values are: "person" and
         "application".
        :paramtype assignment_type: str or
         ~azure.communication.phonenumbers.models.PhoneNumberAssignmentType
        :keyword purchase_date: The date and time that the phone number was purchased. Required.
        :paramtype purchase_date: ~datetime.datetime
        :keyword cost: The incurred cost for a single phone number. Required.
        :paramtype cost: ~azure.communication.phonenumbers.models.PhoneNumberCost
        """
        super().__init__(**kwargs)
        self.id = id
        self.phone_number = phone_number
        self.country_code = country_code
        self.phone_number_type = phone_number_type
        self.capabilities = capabilities
        self.assignment_type = assignment_type
        self.purchase_date = purchase_date
        self.cost = cost


class PurchasedPhoneNumbers(_serialization.Model):
    """The list of purchased phone numbers.

    All required parameters must be populated in order to send to Azure.

    :ivar phone_numbers: Represents a list of phone numbers. Required.
    :vartype phone_numbers: list[~azure.communication.phonenumbers.models.PurchasedPhoneNumber]
    :ivar next_link: Represents the URL link to the next page of phone number results.
    :vartype next_link: str
    """

    _validation = {
        "phone_numbers": {"required": True},
    }

    _attribute_map = {
        "phone_numbers": {"key": "phoneNumbers", "type": "[PurchasedPhoneNumber]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, phone_numbers: List["_models.PurchasedPhoneNumber"], next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword phone_numbers: Represents a list of phone numbers. Required.
        :paramtype phone_numbers: list[~azure.communication.phonenumbers.models.PurchasedPhoneNumber]
        :keyword next_link: Represents the URL link to the next page of phone number results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.phone_numbers = phone_numbers
        self.next_link = next_link
