# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, TYPE_CHECKING, Union

import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CommunicationError(msrest.serialization.Model):
    """The Communication Services error.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: The error message. Required.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: Further details about specific errors that led to this error.
    :vartype details: list[~azure.communication.email.models.CommunicationError]
    :ivar inner_error: The inner error if any.
    :vartype inner_error: ~azure.communication.email.models.CommunicationError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'inner_error': {'readonly': True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CommunicationError]"},
        "inner_error": {"key": "innererror", "type": "CommunicationError"},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        **kwargs
    ):
        """
        :keyword code: The error code. Required.
        :paramtype code: str
        :keyword message: The error message. Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = None
        self.details = None
        self.inner_error = None


class CommunicationErrorResponse(msrest.serialization.Model):
    """The Communication Services error.

    All required parameters must be populated in order to send to Azure.

    :ivar error: The Communication Services error. Required.
    :vartype error: ~azure.communication.email.models.CommunicationError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "CommunicationError"},
    }

    def __init__(
        self,
        *,
        error: "_models.CommunicationError",
        **kwargs
    ):
        """
        :keyword error: The Communication Services error. Required.
        :paramtype error: ~azure.communication.email.models.CommunicationError
        """
        super().__init__(**kwargs)
        self.error = error


class EmailAddress(msrest.serialization.Model):
    """An object representing the email address and its display name.

    All required parameters must be populated in order to send to Azure.

    :ivar email: Email address. Required.
    :vartype email: str
    :ivar display_name: Email display name.
    :vartype display_name: str
    """

    _validation = {
        'email': {'required': True},
    }

    _attribute_map = {
        "email": {"key": "email", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        email: str,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword email: Email address. Required.
        :paramtype email: str
        :keyword display_name: Email display name.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.email = email
        self.display_name = display_name


class EmailAttachment(msrest.serialization.Model):
    """Attachment to the email.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the attachment. Required.
    :vartype name: str
    :ivar attachment_type: The type of attachment file. Required. Known values are: "avi", "bmp",
     "doc", "docm", "docx", "gif", "jpeg", "mp3", "one", "pdf", "png", "ppsm", "ppsx", "ppt",
     "pptm", "pptx", "pub", "rpmsg", "rtf", "tif", "txt", "vsd", "wav", "wma", "xls", "xlsb",
     "xlsm", and "xlsx".
    :vartype attachment_type: str or ~azure.communication.email.models.EmailAttachmentType
    :ivar content_bytes_base64: Base64 encoded contents of the attachment. Required.
    :vartype content_bytes_base64: str
    """

    _validation = {
        'name': {'required': True},
        'attachment_type': {'required': True},
        'content_bytes_base64': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "attachment_type": {"key": "attachmentType", "type": "str"},
        "content_bytes_base64": {"key": "contentBytesBase64", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        attachment_type: Union[str, "_models.EmailAttachmentType"],
        content_bytes_base64: str,
        **kwargs
    ):
        """
        :keyword name: Name of the attachment. Required.
        :paramtype name: str
        :keyword attachment_type: The type of attachment file. Required. Known values are: "avi",
         "bmp", "doc", "docm", "docx", "gif", "jpeg", "mp3", "one", "pdf", "png", "ppsm", "ppsx", "ppt",
         "pptm", "pptx", "pub", "rpmsg", "rtf", "tif", "txt", "vsd", "wav", "wma", "xls", "xlsb",
         "xlsm", and "xlsx".
        :paramtype attachment_type: str or ~azure.communication.email.models.EmailAttachmentType
        :keyword content_bytes_base64: Base64 encoded contents of the attachment. Required.
        :paramtype content_bytes_base64: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.attachment_type = attachment_type
        self.content_bytes_base64 = content_bytes_base64


class EmailContent(msrest.serialization.Model):
    """Content of the email.

    All required parameters must be populated in order to send to Azure.

    :ivar subject: Subject of the email message. Required.
    :vartype subject: str
    :ivar plain_text: Plain text version of the email message.
    :vartype plain_text: str
    :ivar html: Html version of the email message.
    :vartype html: str
    """

    _validation = {
        'subject': {'required': True},
    }

    _attribute_map = {
        "subject": {"key": "subject", "type": "str"},
        "plain_text": {"key": "plainText", "type": "str"},
        "html": {"key": "html", "type": "str"},
    }

    def __init__(
        self,
        *,
        subject: str,
        plain_text: Optional[str] = None,
        html: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subject: Subject of the email message. Required.
        :paramtype subject: str
        :keyword plain_text: Plain text version of the email message.
        :paramtype plain_text: str
        :keyword html: Html version of the email message.
        :paramtype html: str
        """
        super().__init__(**kwargs)
        self.subject = subject
        self.plain_text = plain_text
        self.html = html


class EmailCustomHeader(msrest.serialization.Model):
    """Custom header for email.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Header name. Required.
    :vartype name: str
    :ivar value: Header value. Required.
    :vartype value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        """
        :keyword name: Header name. Required.
        :paramtype name: str
        :keyword value: Header value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class EmailMessage(msrest.serialization.Model):
    """Message payload for sending an email.

    All required parameters must be populated in order to send to Azure.

    :ivar custom_headers: Custom email headers to be passed.
    :vartype custom_headers: list[~azure.communication.email.models.EmailCustomHeader]
    :ivar sender: Sender email address from a verified domain. Required.
    :vartype sender: str
    :ivar content: Email content to be sent. Required.
    :vartype content: ~azure.communication.email.models.EmailContent
    :ivar importance: The importance type for the email. Known values are: "high", "normal", and
     "low".
    :vartype importance: str or ~azure.communication.email.models.EmailImportance
    :ivar recipients: Recipients for the email. Required.
    :vartype recipients: ~azure.communication.email.models.EmailRecipients
    :ivar attachments: list of attachments.
    :vartype attachments: list[~azure.communication.email.models.EmailAttachment]
    :ivar reply_to: Email addresses where recipients' replies will be sent to.
    :vartype reply_to: list[~azure.communication.email.models.EmailAddress]
    :ivar disable_user_engagement_tracking: Indicates whether user engagement tracking should be
     disabled for this request if the resource-level user engagement tracking setting was already
     enabled in the control plane.
    :vartype disable_user_engagement_tracking: bool
    """

    _validation = {
        'sender': {'required': True},
        'content': {'required': True},
        'recipients': {'required': True},
    }

    _attribute_map = {
        "custom_headers": {"key": "headers", "type": "[EmailCustomHeader]"},
        "sender": {"key": "sender", "type": "str"},
        "content": {"key": "content", "type": "EmailContent"},
        "importance": {"key": "importance", "type": "str"},
        "recipients": {"key": "recipients", "type": "EmailRecipients"},
        "attachments": {"key": "attachments", "type": "[EmailAttachment]"},
        "reply_to": {"key": "replyTo", "type": "[EmailAddress]"},
        "disable_user_engagement_tracking": {"key": "disableUserEngagementTracking", "type": "bool"},
    }

    def __init__(
        self,
        *,
        sender: str,
        content: "_models.EmailContent",
        recipients: "_models.EmailRecipients",
        custom_headers: Optional[List["_models.EmailCustomHeader"]] = None,
        importance: Union[str, "_models.EmailImportance"] = "normal",
        attachments: Optional[List["_models.EmailAttachment"]] = None,
        reply_to: Optional[List["_models.EmailAddress"]] = None,
        disable_user_engagement_tracking: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword custom_headers: Custom email headers to be passed.
        :paramtype custom_headers: list[~azure.communication.email.models.EmailCustomHeader]
        :keyword sender: Sender email address from a verified domain. Required.
        :paramtype sender: str
        :keyword content: Email content to be sent. Required.
        :paramtype content: ~azure.communication.email.models.EmailContent
        :keyword importance: The importance type for the email. Known values are: "high", "normal", and
         "low".
        :paramtype importance: str or ~azure.communication.email.models.EmailImportance
        :keyword recipients: Recipients for the email. Required.
        :paramtype recipients: ~azure.communication.email.models.EmailRecipients
        :keyword attachments: list of attachments.
        :paramtype attachments: list[~azure.communication.email.models.EmailAttachment]
        :keyword reply_to: Email addresses where recipients' replies will be sent to.
        :paramtype reply_to: list[~azure.communication.email.models.EmailAddress]
        :keyword disable_user_engagement_tracking: Indicates whether user engagement tracking should be
         disabled for this request if the resource-level user engagement tracking setting was already
         enabled in the control plane.
        :paramtype disable_user_engagement_tracking: bool
        """
        super().__init__(**kwargs)
        self.custom_headers = custom_headers
        self.sender = sender
        self.content = content
        self.importance = importance
        self.recipients = recipients
        self.attachments = attachments
        self.reply_to = reply_to
        self.disable_user_engagement_tracking = disable_user_engagement_tracking


class EmailRecipients(msrest.serialization.Model):
    """Recipients of the email.

    All required parameters must be populated in order to send to Azure.

    :ivar to: Email To recipients. Required.
    :vartype to: list[~azure.communication.email.models.EmailAddress]
    :ivar cc: Email CC recipients.
    :vartype cc: list[~azure.communication.email.models.EmailAddress]
    :ivar bcc: Email BCC recipients.
    :vartype bcc: list[~azure.communication.email.models.EmailAddress]
    """

    _validation = {
        'to': {'required': True},
    }

    _attribute_map = {
        "to": {"key": "to", "type": "[EmailAddress]"},
        "cc": {"key": "CC", "type": "[EmailAddress]"},
        "bcc": {"key": "bCC", "type": "[EmailAddress]"},
    }

    def __init__(
        self,
        *,
        to: List["_models.EmailAddress"],
        cc: Optional[List["_models.EmailAddress"]] = None,
        bcc: Optional[List["_models.EmailAddress"]] = None,
        **kwargs
    ):
        """
        :keyword to: Email To recipients. Required.
        :paramtype to: list[~azure.communication.email.models.EmailAddress]
        :keyword cc: Email CC recipients.
        :paramtype cc: list[~azure.communication.email.models.EmailAddress]
        :keyword bcc: Email BCC recipients.
        :paramtype bcc: list[~azure.communication.email.models.EmailAddress]
        """
        super().__init__(**kwargs)
        self.to = to
        self.cc = cc
        self.bcc = bcc


class SendStatusResult(msrest.serialization.Model):
    """Status of an email message that was sent previously.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: System generated id of an email message sent. Required.
    :vartype message_id: str
    :ivar status: The type indicating the status of a request. Required. Known values are:
     "queued", "outForDelivery", and "dropped".
    :vartype status: str or ~azure.communication.email.models.SendStatus
    """

    _validation = {
        'message_id': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "message_id": {"key": "messageId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        message_id: str,
        status: Union[str, "_models.SendStatus"],
        **kwargs
    ):
        """
        :keyword message_id: System generated id of an email message sent. Required.
        :paramtype message_id: str
        :keyword status: The type indicating the status of a request. Required. Known values are:
         "queued", "outForDelivery", and "dropped".
        :paramtype status: str or ~azure.communication.email.models.SendStatus
        """
        super().__init__(**kwargs)
        self.message_id = message_id
        self.status = status
