# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ArmAsyncOperation(_serialization.Model):
    """Arm async operation class.
    Ref: https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/async-operations.

        :ivar status: Status of the async operation.
        :vartype status: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[str] = None, **kwargs):
        """
        :keyword status: Status of the async operation.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.status = status


class CheckNameAvailabilityRequest(_serialization.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs):
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(_serialization.Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.agrifood.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name_available: Indicates if the resource name is available.
        :paramtype name_available: bool
        :keyword reason: The reason why the given name is not available. Known values are: "Invalid"
         and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.agrifood.models.CheckNameAvailabilityReason
        :keyword message: Detailed reason why the given name is available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class DetailedInformation(_serialization.Model):
    """Model to capture detailed information for farmBeatsExtensions.

    :ivar api_name: ApiName available for the farmBeatsExtension.
    :vartype api_name: str
    :ivar custom_parameters: List of customParameters.
    :vartype custom_parameters: list[str]
    :ivar platform_parameters: List of platformParameters.
    :vartype platform_parameters: list[str]
    :ivar units_supported: Unit systems info for the data provider.
    :vartype units_supported: ~azure.mgmt.agrifood.models.UnitSystemsInfo
    :ivar api_input_parameters: List of apiInputParameters.
    :vartype api_input_parameters: list[str]
    """

    _attribute_map = {
        "api_name": {"key": "apiName", "type": "str"},
        "custom_parameters": {"key": "customParameters", "type": "[str]"},
        "platform_parameters": {"key": "platformParameters", "type": "[str]"},
        "units_supported": {"key": "unitsSupported", "type": "UnitSystemsInfo"},
        "api_input_parameters": {"key": "apiInputParameters", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        api_name: Optional[str] = None,
        custom_parameters: Optional[List[str]] = None,
        platform_parameters: Optional[List[str]] = None,
        units_supported: Optional["_models.UnitSystemsInfo"] = None,
        api_input_parameters: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword api_name: ApiName available for the farmBeatsExtension.
        :paramtype api_name: str
        :keyword custom_parameters: List of customParameters.
        :paramtype custom_parameters: list[str]
        :keyword platform_parameters: List of platformParameters.
        :paramtype platform_parameters: list[str]
        :keyword units_supported: Unit systems info for the data provider.
        :paramtype units_supported: ~azure.mgmt.agrifood.models.UnitSystemsInfo
        :keyword api_input_parameters: List of apiInputParameters.
        :paramtype api_input_parameters: list[str]
        """
        super().__init__(**kwargs)
        self.api_name = api_name
        self.custom_parameters = custom_parameters
        self.platform_parameters = platform_parameters
        self.units_supported = units_supported
        self.api_input_parameters = api_input_parameters


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.agrifood.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.agrifood.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.agrifood.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.agrifood.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class Extension(ProxyResource):
    """Extension resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :ivar extension_id: Extension Id.
    :vartype extension_id: str
    :ivar extension_category: Extension category. e.g. weather/sensor/satellite.
    :vartype extension_category: str
    :ivar installed_extension_version: Installed extension version.
    :vartype installed_extension_version: str
    :ivar extension_auth_link: Extension auth link.
    :vartype extension_auth_link: str
    :ivar extension_api_docs_link: Extension api docs link.
    :vartype extension_api_docs_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "e_tag": {"readonly": True},
        "extension_id": {"readonly": True, "pattern": r"^[a-zA-Z]{3,50}[.][a-zA-Z]{3,100}$"},
        "extension_category": {"readonly": True},
        "installed_extension_version": {"readonly": True, "pattern": r"^([1-9]|10).\d$"},
        "extension_auth_link": {"readonly": True},
        "extension_api_docs_link": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "e_tag": {"key": "eTag", "type": "str"},
        "extension_id": {"key": "properties.extensionId", "type": "str"},
        "extension_category": {"key": "properties.extensionCategory", "type": "str"},
        "installed_extension_version": {"key": "properties.installedExtensionVersion", "type": "str"},
        "extension_auth_link": {"key": "properties.extensionAuthLink", "type": "str"},
        "extension_api_docs_link": {"key": "properties.extensionApiDocsLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.e_tag = None
        self.extension_id = None
        self.extension_category = None
        self.installed_extension_version = None
        self.extension_auth_link = None
        self.extension_api_docs_link = None


class ExtensionListResponse(_serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of requested objects.
    :vartype value: list[~azure.mgmt.agrifood.models.Extension]
    :ivar next_link: Continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Extension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Extension"]] = None, **kwargs):
        """
        :keyword value: List of requested objects.
        :paramtype value: list[~azure.mgmt.agrifood.models.Extension]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class FarmBeats(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """FarmBeats ARM Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.agrifood.models.Identity
    :ivar instance_uri: Uri of the FarmBeats instance.
    :vartype instance_uri: str
    :ivar provisioning_state: FarmBeats instance provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.agrifood.models.ProvisioningState
    :ivar sensor_integration: Sensor integration request model.
    :vartype sensor_integration: ~azure.mgmt.agrifood.models.SensorIntegration
    :ivar public_network_access: Property to allow or block public traffic for an Azure FarmBeats
     resource. Known values are: "Enabled" and "Hybrid".
    :vartype public_network_access: str or ~azure.mgmt.agrifood.models.PublicNetworkAccess
    :ivar private_endpoint_connections: The Private Endpoint Connection resource.
    :vartype private_endpoint_connections: ~azure.mgmt.agrifood.models.PrivateEndpointConnection
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "instance_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "instance_uri": {"key": "properties.instanceUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sensor_integration": {"key": "properties.sensorIntegration", "type": "SensorIntegration"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "PrivateEndpointConnection",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        sensor_integration: Optional["_models.SensorIntegration"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.agrifood.models.Identity
        :keyword sensor_integration: Sensor integration request model.
        :paramtype sensor_integration: ~azure.mgmt.agrifood.models.SensorIntegration
        :keyword public_network_access: Property to allow or block public traffic for an Azure
         FarmBeats resource. Known values are: "Enabled" and "Hybrid".
        :paramtype public_network_access: str or ~azure.mgmt.agrifood.models.PublicNetworkAccess
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.instance_uri = None
        self.provisioning_state = None
        self.sensor_integration = sensor_integration
        self.public_network_access = public_network_access
        self.private_endpoint_connections = None


class FarmBeatsExtension(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """FarmBeats extension resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar target_resource_type: Target ResourceType of the farmBeatsExtension.
    :vartype target_resource_type: str
    :ivar farm_beats_extension_id: FarmBeatsExtension ID.
    :vartype farm_beats_extension_id: str
    :ivar farm_beats_extension_name: FarmBeatsExtension name.
    :vartype farm_beats_extension_name: str
    :ivar farm_beats_extension_version: FarmBeatsExtension version.
    :vartype farm_beats_extension_version: str
    :ivar publisher_id: Publisher ID.
    :vartype publisher_id: str
    :ivar description: Textual description.
    :vartype description: str
    :ivar extension_category: Category of the extension. e.g. weather/sensor/satellite.
    :vartype extension_category: str
    :ivar extension_auth_link: FarmBeatsExtension auth link.
    :vartype extension_auth_link: str
    :ivar extension_api_docs_link: FarmBeatsExtension api docs link.
    :vartype extension_api_docs_link: str
    :ivar detailed_information: Detailed information which shows summary of requested data.
     Used in descriptive get extension metadata call.
     Information for weather category per api included are apisSupported,
     customParameters, PlatformParameters and Units supported.
    :vartype detailed_information: list[~azure.mgmt.agrifood.models.DetailedInformation]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "target_resource_type": {"readonly": True},
        "farm_beats_extension_id": {
            "readonly": True,
            "max_length": 100,
            "min_length": 2,
            "pattern": r"^[a-zA-Z]{3,50}[.][a-zA-Z]{3,100}$",
        },
        "farm_beats_extension_name": {"readonly": True, "max_length": 100, "min_length": 2},
        "farm_beats_extension_version": {
            "readonly": True,
            "max_length": 100,
            "min_length": 2,
            "pattern": r"^([1-9]|10).\d$",
        },
        "publisher_id": {"readonly": True, "max_length": 100, "min_length": 2},
        "description": {"readonly": True, "max_length": 500, "min_length": 2},
        "extension_category": {"readonly": True, "max_length": 100, "min_length": 2},
        "extension_auth_link": {"readonly": True},
        "extension_api_docs_link": {"readonly": True},
        "detailed_information": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "target_resource_type": {"key": "properties.targetResourceType", "type": "str"},
        "farm_beats_extension_id": {"key": "properties.farmBeatsExtensionId", "type": "str"},
        "farm_beats_extension_name": {"key": "properties.farmBeatsExtensionName", "type": "str"},
        "farm_beats_extension_version": {"key": "properties.farmBeatsExtensionVersion", "type": "str"},
        "publisher_id": {"key": "properties.publisherId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "extension_category": {"key": "properties.extensionCategory", "type": "str"},
        "extension_auth_link": {"key": "properties.extensionAuthLink", "type": "str"},
        "extension_api_docs_link": {"key": "properties.extensionApiDocsLink", "type": "str"},
        "detailed_information": {"key": "properties.detailedInformation", "type": "[DetailedInformation]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.target_resource_type = None
        self.farm_beats_extension_id = None
        self.farm_beats_extension_name = None
        self.farm_beats_extension_version = None
        self.publisher_id = None
        self.description = None
        self.extension_category = None
        self.extension_auth_link = None
        self.extension_api_docs_link = None
        self.detailed_information = None


class FarmBeatsExtensionListResponse(_serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of requested objects.
    :vartype value: list[~azure.mgmt.agrifood.models.FarmBeatsExtension]
    :ivar next_link: Continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FarmBeatsExtension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.FarmBeatsExtension"]] = None, **kwargs):
        """
        :keyword value: List of requested objects.
        :paramtype value: list[~azure.mgmt.agrifood.models.FarmBeatsExtension]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class FarmBeatsListResponse(_serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of requested objects.
    :vartype value: list[~azure.mgmt.agrifood.models.FarmBeats]
    :ivar next_link: Continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FarmBeats]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.FarmBeats"]] = None, **kwargs):
        """
        :keyword value: List of requested objects.
        :paramtype value: list[~azure.mgmt.agrifood.models.FarmBeats]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class FarmBeatsUpdateProperties(_serialization.Model):
    """FarmBeats ARM Resource properties.

    :ivar sensor_integration: Sensor integration request model.
    :vartype sensor_integration: ~azure.mgmt.agrifood.models.SensorIntegration
    :ivar public_network_access: Property to allow or block public traffic for an Azure FarmBeats
     resource. Known values are: "Enabled" and "Hybrid".
    :vartype public_network_access: str or ~azure.mgmt.agrifood.models.PublicNetworkAccess
    """

    _attribute_map = {
        "sensor_integration": {"key": "sensorIntegration", "type": "SensorIntegration"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        sensor_integration: Optional["_models.SensorIntegration"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs
    ):
        """
        :keyword sensor_integration: Sensor integration request model.
        :paramtype sensor_integration: ~azure.mgmt.agrifood.models.SensorIntegration
        :keyword public_network_access: Property to allow or block public traffic for an Azure
         FarmBeats resource. Known values are: "Enabled" and "Hybrid".
        :paramtype public_network_access: str or ~azure.mgmt.agrifood.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.sensor_integration = sensor_integration
        self.public_network_access = public_network_access


class FarmBeatsUpdateRequestModel(_serialization.Model):
    """FarmBeats update request.

    :ivar location: Geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.agrifood.models.Identity
    :ivar properties: FarmBeats ARM Resource properties.
    :vartype properties: ~azure.mgmt.agrifood.models.FarmBeatsUpdateProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "properties": {"key": "properties", "type": "FarmBeatsUpdateProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        properties: Optional["_models.FarmBeatsUpdateProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.agrifood.models.Identity
        :keyword properties: FarmBeats ARM Resource properties.
        :paramtype properties: ~azure.mgmt.agrifood.models.FarmBeatsUpdateProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.identity = identity
        self.properties = properties
        self.tags = tags


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, **kwargs):
        """
        :keyword type: The identity type. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.agrifood.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.agrifood.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.agrifood.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.agrifood.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.agrifood.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.agrifood.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.agrifood.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.agrifood.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.agrifood.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.agrifood.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.agrifood.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.agrifood.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs):
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.agrifood.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs):
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.agrifood.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.agrifood.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or ~azure.mgmt.agrifood.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class SensorIntegration(_serialization.Model):
    """Sensor integration request model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Sensor integration enable state. Allowed values are True, None.
    :vartype enabled: str
    :ivar provisioning_state: Sensor integration instance provisioning state. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.agrifood.models.ProvisioningState
    :ivar provisioning_info: Common error response for all Azure Resource Manager APIs to return
     error details for failed operations. (This also follows the OData error response format.).
    :vartype provisioning_info: ~azure.mgmt.agrifood.models.ErrorResponse
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "provisioning_info": {"key": "provisioningInfo", "type": "ErrorResponse"},
    }

    def __init__(
        self, *, enabled: Optional[str] = None, provisioning_info: Optional["_models.ErrorResponse"] = None, **kwargs
    ):
        """
        :keyword enabled: Sensor integration enable state. Allowed values are True, None.
        :paramtype enabled: str
        :keyword provisioning_info: Common error response for all Azure Resource Manager APIs to return
         error details for failed operations. (This also follows the OData error response format.).
        :paramtype provisioning_info: ~azure.mgmt.agrifood.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.provisioning_state = None
        self.provisioning_info = provisioning_info


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.agrifood.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.agrifood.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.agrifood.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.agrifood.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UnitSystemsInfo(_serialization.Model):
    """Unit systems info for the data provider.

    All required parameters must be populated in order to send to Azure.

    :ivar key: UnitSystem key sent as part of ProviderInput. Required.
    :vartype key: str
    :ivar values: List of unit systems supported by this data provider. Required.
    :vartype values: list[str]
    """

    _validation = {
        "key": {"required": True, "max_length": 100, "min_length": 2},
        "values": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, key: str, values: List[str], **kwargs):
        """
        :keyword key: UnitSystem key sent as part of ProviderInput. Required.
        :paramtype key: str
        :keyword values: List of unit systems supported by this data provider. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.key = key
        self.values = values
