# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PartnerRegionInfo(Model):
    """Partner region information for the failover group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Geo location of the partner managed instances.
    :type location: str
    :ivar replication_role: Replication role of the partner managed instances.
     Possible values include: 'Primary', 'Secondary'
    :vartype replication_role: str or
     ~azure.mgmt.sql.models.InstanceFailoverGroupReplicationRole
    """

    _validation = {
        'replication_role': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'replication_role': {'key': 'replicationRole', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, **kwargs) -> None:
        super(PartnerRegionInfo, self).__init__(**kwargs)
        self.location = location
        self.replication_role = None
