# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Table(Model):
    """Query output in tabular format.

    All required parameters must be populated in order to send to Azure.

    :param columns: Required. Query result column descriptors.
    :type columns: list[~azure.mgmt.resourcegraph.models.Column]
    :param rows: Required. Query result rows.
    :type rows: list[list[object]]
    """

    _validation = {
        'columns': {'required': True},
        'rows': {'required': True},
    }

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[Column]'},
        'rows': {'key': 'rows', 'type': '[[object]]'},
    }

    def __init__(self, **kwargs):
        super(Table, self).__init__(**kwargs)
        self.columns = kwargs.get('columns', None)
        self.rows = kwargs.get('rows', None)
