# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class X12SchemaReference(Model):
    """The X12 schema reference.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The message id.
    :type message_id: str
    :param sender_application_id: The sender application id.
    :type sender_application_id: str
    :param schema_version: Required. The schema version.
    :type schema_version: str
    :param schema_name: Required. The schema name.
    :type schema_name: str
    """

    _validation = {
        'message_id': {'required': True},
        'schema_version': {'required': True},
        'schema_name': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'messageId', 'type': 'str'},
        'sender_application_id': {'key': 'senderApplicationId', 'type': 'str'},
        'schema_version': {'key': 'schemaVersion', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(X12SchemaReference, self).__init__(**kwargs)
        self.message_id = kwargs.get('message_id', None)
        self.sender_application_id = kwargs.get('sender_application_id', None)
        self.schema_version = kwargs.get('schema_version', None)
        self.schema_name = kwargs.get('schema_name', None)
