# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .execution_activity import ExecutionActivity


class AzureMLUpdateResourceActivity(ExecutionActivity):
    """Azure ML Update Resource management activity.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param name: Activity name.
    :type name: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param type: Constant filled by server.
    :type type: str
    :param linked_service_name: Linked service reference.
    :type linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param trained_model_name: Name of the Trained Model module in the Web
     Service experiment to be updated. Type: string (or Expression with
     resultType string).
    :type trained_model_name: object
    :param trained_model_linked_service_name: Name of Azure Storage linked
     service holding the .ilearner file that will be uploaded by the update
     operation.
    :type trained_model_linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param trained_model_file_path: The relative file path in
     trainedModelLinkedService to represent the .ilearner file that will be
     uploaded by the update operation.  Type: string (or Expression with
     resultType string).
    :type trained_model_file_path: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'trained_model_name': {'required': True},
        'trained_model_linked_service_name': {'required': True},
        'trained_model_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'trained_model_name': {'key': 'typeProperties.trainedModelName', 'type': 'object'},
        'trained_model_linked_service_name': {'key': 'typeProperties.trainedModelLinkedServiceName', 'type': 'LinkedServiceReference'},
        'trained_model_file_path': {'key': 'typeProperties.trainedModelFilePath', 'type': 'object'},
    }

    def __init__(self, name, trained_model_name, trained_model_linked_service_name, trained_model_file_path, additional_properties=None, description=None, depends_on=None, linked_service_name=None, policy=None):
        super(AzureMLUpdateResourceActivity, self).__init__(additional_properties=additional_properties, name=name, description=description, depends_on=depends_on, linked_service_name=linked_service_name, policy=policy)
        self.trained_model_name = trained_model_name
        self.trained_model_linked_service_name = trained_model_linked_service_name
        self.trained_model_file_path = trained_model_file_path
        self.type = 'AzureMLUpdateResource'
