# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .integration_account_resource import IntegrationAccountResource


class IntegrationAccountSchema(IntegrationAccountResource):
    """IntegrationAccountSchema.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: The resource id.
    :type id: str
    :param name: The resource name.
    :type name: str
    :param type: The resource type.
    :type type: str
    :param location: The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict
    :param schema_type: The schema type. Possible values include:
     'NotSpecified', 'Xml'
    :type schema_type: str or :class:`SchemaType
     <azure.mgmt.logic.models.SchemaType>`
    :param target_namespace: The target namespace.
    :type target_namespace: str
    :ivar created_time: The created time.
    :vartype created_time: datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: datetime
    :param content: The content.
    :type content: object
    :param content_type: The content type.
    :type content_type: str
    :ivar content_link: The content link.
    :vartype content_link: :class:`IntegrationAccountContentLink
     <azure.mgmt.logic.models.IntegrationAccountContentLink>`
    :param metadata: The metadata.
    :type metadata: object
    """ 

    _validation = {
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'content_link': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'schema_type': {'key': 'properties.schemaType', 'type': 'SchemaType'},
        'target_namespace': {'key': 'properties.targetNamespace', 'type': 'str'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'content': {'key': 'properties.content', 'type': 'object'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'content_link': {'key': 'properties.contentLink', 'type': 'IntegrationAccountContentLink'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
    }

    def __init__(self, id=None, name=None, type=None, location=None, tags=None, schema_type=None, target_namespace=None, content=None, content_type=None, metadata=None):
        super(IntegrationAccountSchema, self).__init__(id=id, name=name, type=type, location=location, tags=tags)
        self.schema_type = schema_type
        self.target_namespace = target_namespace
        self.created_time = None
        self.changed_time = None
        self.content = content
        self.content_type = content_type
        self.content_link = None
        self.metadata = metadata
