# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The Resource Id.
    :vartype id: str
    :ivar name: The Resource name.
    :vartype name: str
    :ivar type: The Resource type.
    :vartype type: str
    :param location: The Resource location.
    :type location: str
    :param tags: The Resource tags.
    :type tags: dict
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': '^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, location=None, tags=None):
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
