# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventHubProperties(Model):
    """The properties of the provisioned event hub used by the Iot Hub.

    :param retention_time_in_days: The retention time in days. Range of
     values [For F1: 1-1, S1: 1-7, S2: 1-7, S3: 1-7].
    :type retention_time_in_days: long
    :param partition_count: The partition count. Range of values [For F1:
     2-2, S1: 2-128, S2: 2-128, S3: 2-128].
    :type partition_count: int
    :param partition_ids: The partition ids.
    :type partition_ids: list of str
    :param path: The eventhub path.
    :type path: str
    :param endpoint: The endpoint.
    :type endpoint: str
    :param internal_authorization_policies: The internal authorization rules.
    :type internal_authorization_policies: list of
     :class:`SharedAccessAuthorizationRule
     <azure.mgmt.iothub.models.SharedAccessAuthorizationRule>`
    :param authorization_policies: The authorization rules.
    :type authorization_policies: list of
     :class:`SharedAccessAuthorizationRule
     <azure.mgmt.iothub.models.SharedAccessAuthorizationRule>`
    """ 

    _attribute_map = {
        'retention_time_in_days': {'key': 'retentionTimeInDays', 'type': 'long'},
        'partition_count': {'key': 'partitionCount', 'type': 'int'},
        'partition_ids': {'key': 'partitionIds', 'type': '[str]'},
        'path': {'key': 'path', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'internal_authorization_policies': {'key': 'internalAuthorizationPolicies', 'type': '[SharedAccessAuthorizationRule]'},
        'authorization_policies': {'key': 'authorizationPolicies', 'type': '[SharedAccessAuthorizationRule]'},
    }

    def __init__(self, retention_time_in_days=None, partition_count=None, partition_ids=None, path=None, endpoint=None, internal_authorization_policies=None, authorization_policies=None):
        self.retention_time_in_days = retention_time_in_days
        self.partition_count = partition_count
        self.partition_ids = partition_ids
        self.path = path
        self.endpoint = endpoint
        self.internal_authorization_policies = internal_authorization_policies
        self.authorization_policies = authorization_policies
