# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Zone(Resource):
    """Describes a DNS zone.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param etag: Gets or sets the ETag of the zone that is being updated, as
     received from a Get operation.
    :type etag: str
    :param max_number_of_record_sets: Gets or sets the maximum number of
     record sets that can be created in this zone.
    :type max_number_of_record_sets: long
    :param number_of_record_sets: Gets or sets the current number of record
     sets in this zone.
    :type number_of_record_sets: long
    :ivar name_servers: Gets the name servers populated for this zone. This
     is a read-only property and any attempt to set this value will be
     ignored.
    :vartype name_servers: list of str
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'name_servers': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'max_number_of_record_sets': {'key': 'properties.maxNumberOfRecordSets', 'type': 'long'},
        'number_of_record_sets': {'key': 'properties.numberOfRecordSets', 'type': 'long'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
    }

    def __init__(self, location, tags=None, etag=None, max_number_of_record_sets=None, number_of_record_sets=None):
        super(Zone, self).__init__(location=location, tags=tags)
        self.etag = etag
        self.max_number_of_record_sets = max_number_of_record_sets
        self.number_of_record_sets = number_of_record_sets
        self.name_servers = None
