# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RecordSet(Model):
    """Describes a DNS RecordSet (a set of DNS records with the same name and
    type).

    :param id: Gets or sets the ID of the resource.
    :type id: str
    :param name: Gets or sets the name of the resource.
    :type name: str
    :param type: Gets or sets the type of the resource.
    :type type: str
    :param etag: Gets or sets the ETag of the RecordSet.
    :type etag: str
    :param metadata: Gets or sets the metadata attached to the resource.
    :type metadata: dict
    :param ttl: Gets or sets the TTL of the records in the RecordSet.
    :type ttl: long
    :param arecords: Gets or sets the list of A records in the RecordSet.
    :type arecords: list of :class:`ARecord <azure.mgmt.dns.models.ARecord>`
    :param aaaa_records: Gets or sets the list of AAAA records in the
     RecordSet.
    :type aaaa_records: list of :class:`AaaaRecord
     <azure.mgmt.dns.models.AaaaRecord>`
    :param mx_records: Gets or sets the list of MX records in the RecordSet.
    :type mx_records: list of :class:`MxRecord
     <azure.mgmt.dns.models.MxRecord>`
    :param ns_records: Gets or sets the list of NS records in the RecordSet.
    :type ns_records: list of :class:`NsRecord
     <azure.mgmt.dns.models.NsRecord>`
    :param ptr_records: Gets or sets the list of PTR records in the RecordSet.
    :type ptr_records: list of :class:`PtrRecord
     <azure.mgmt.dns.models.PtrRecord>`
    :param srv_records: Gets or sets the list of SRV records in the RecordSet.
    :type srv_records: list of :class:`SrvRecord
     <azure.mgmt.dns.models.SrvRecord>`
    :param txt_records: Gets or sets the list of TXT records in the RecordSet.
    :type txt_records: list of :class:`TxtRecord
     <azure.mgmt.dns.models.TxtRecord>`
    :param cname_record: Gets or sets the CNAME record in the RecordSet.
    :type cname_record: :class:`CnameRecord
     <azure.mgmt.dns.models.CnameRecord>`
    :param soa_record: Gets or sets the SOA record in the RecordSet.
    :type soa_record: :class:`SoaRecord <azure.mgmt.dns.models.SoaRecord>`
    """ 

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'ttl': {'key': 'properties.TTL', 'type': 'long'},
        'arecords': {'key': 'properties.ARecords', 'type': '[ARecord]'},
        'aaaa_records': {'key': 'properties.AAAARecords', 'type': '[AaaaRecord]'},
        'mx_records': {'key': 'properties.MXRecords', 'type': '[MxRecord]'},
        'ns_records': {'key': 'properties.NSRecords', 'type': '[NsRecord]'},
        'ptr_records': {'key': 'properties.PTRRecords', 'type': '[PtrRecord]'},
        'srv_records': {'key': 'properties.SRVRecords', 'type': '[SrvRecord]'},
        'txt_records': {'key': 'properties.TXTRecords', 'type': '[TxtRecord]'},
        'cname_record': {'key': 'properties.CNAMERecord', 'type': 'CnameRecord'},
        'soa_record': {'key': 'properties.SOARecord', 'type': 'SoaRecord'},
    }

    def __init__(self, id=None, name=None, type=None, etag=None, metadata=None, ttl=None, arecords=None, aaaa_records=None, mx_records=None, ns_records=None, ptr_records=None, srv_records=None, txt_records=None, cname_record=None, soa_record=None):
        self.id = id
        self.name = name
        self.type = type
        self.etag = etag
        self.metadata = metadata
        self.ttl = ttl
        self.arecords = arecords
        self.aaaa_records = aaaa_records
        self.mx_records = mx_records
        self.ns_records = ns_records
        self.ptr_records = ptr_records
        self.srv_records = srv_records
        self.txt_records = txt_records
        self.cname_record = cname_record
        self.soa_record = soa_record
