# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VirtualMachineConfiguration(Model):
    """The configuration for compute nodes in a pool based on the Azure Virtual
    Machines infrastructure.

    :param image_reference: A reference to the Azure Virtual Machines
     Marketplace image to use.
    :type image_reference: :class:`ImageReference
     <azure.batch.models.ImageReference>`
    :param node_agent_sku_id: The SKU of Batch Node Agent to be provisioned
     on the compute node. The Batch node agent is a program that runs on each
     node in the pool, and provides the command-and-control interface between
     the node and the Batch service. There are different implementations of
     the node agent, known as SKUs, for different operating systems.
    :type node_agent_sku_id: str
    :param windows_configuration: Windows operating system settings on the
     virtual machine. This property must not be specified if the
     imageReference property specifies a Linux OS image.
    :type windows_configuration: :class:`WindowsConfiguration
     <azure.batch.models.WindowsConfiguration>`
    """ 

    _validation = {
        'image_reference': {'required': True},
        'node_agent_sku_id': {'required': True},
    }

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'node_agent_sku_id': {'key': 'nodeAgentSKUId', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
    }

    def __init__(self, image_reference, node_agent_sku_id, windows_configuration=None):
        self.image_reference = image_reference
        self.node_agent_sku_id = node_agent_sku_id
        self.windows_configuration = windows_configuration
