import sha
from Ft.Server.Server import FtServerServerException, Error

from Ft.Server.Common import AclConstants, Schema

import test_helper

from Ft.Rdf import Statement

from Ft.Server import FTSERVER_NAMESPACE

def GetU1Repo(tester):
    return test_helper.GetRepo(tester,'test1','test1')
def GetU2Repo(tester):
    return test_helper.GetRepo(tester,'test2','test2')

def GetOwnerRepo(tester):
    return test_helper.GetRepo(tester,'o','o')



def test_read(tester):


    tester.startGroup("Read Access")

    tester.startTest("Create a test container")
    repo = GetOwnerRepo(tester)
    cont = repo.createContainer('/test/cont')
    cont.setAcl(AclConstants.READ_ACCESS,'test1',AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()


    tester.startTest("SU read access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    repo.txRollback()
    tester.testDone()

    tester.startTest("test1 read access")
    repo = GetU1Repo(tester)
    cont = repo.fetchResource('/test/cont')
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 read access")
    repo = GetU2Repo(tester)
    tester.testException(repo.fetchResource,('/test/cont',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner read access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.addAcl(AclConstants.READ_ACCESS,
                AclConstants.OWNER,
                AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    cont = repo.fetchResource('/test/cont')
    repo.txRollback()
    tester.testDone()


    tester.startTest("Deny Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.setAcl(AclConstants.READ_ACCESS,'test1',AclConstants.DENIED)
    cont.addAcl(AclConstants.READ_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    cont.addAcl(AclConstants.READ_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 read access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource,('/test/cont',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 read access")
    repo = GetU2Repo(tester)
    cont = repo.fetchResource('/test/cont')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner read access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource,('/test/cont',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()


    tester.startTest("Group Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.setAcl(AclConstants.READ_ACCESS,'test_group',AclConstants.ALLOWED)
    cont.addAcl(AclConstants.READ_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 read access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource,('/test/cont',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 read access")
    repo = GetU2Repo(tester)
    cont = repo.fetchResource('/test/cont')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner read access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource,('/test/cont',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.groupDone()

def test_read_metadata(tester):

    tester.startTest("Read Metadata Access")
    tester.warning("Not Tested")
    tester.testDone()


def test_write(tester):

    tester.startGroup("Write Access")


    tester.startTest("Set Permissions")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.setAcl(AclConstants.WRITE_ACCESS,'test1',AclConstants.ALLOWED)
    cont.setAcl(AclConstants.READ_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()


    tester.startTest("SU write access")
    repo = test_helper.GetRepo(tester)
    f = repo.createRawFile('/test/cont/f1','text/plain','foo')
    repo.txRollback()
    tester.testDone()

    tester.startTest("test1 write access")
    repo = GetU1Repo(tester)
    f = repo.createRawFile('/test/cont/f1','text/plain','foo')
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 write access")
    repo = GetU2Repo(tester)
    tester.testException(repo.createRawFile,('/test/cont/rf1','text/plain','boo'),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner write access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.addAcl(AclConstants.WRITE_ACCESS,
                AclConstants.OWNER,
                AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    f = repo.createRawFile('/test/cont/f1','text/plain','foo')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Deny Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.setAcl(AclConstants.WRITE_ACCESS,'test1',AclConstants.DENIED)
    cont.addAcl(AclConstants.WRITE_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    cont.addAcl(AclConstants.WRITE_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 write access")
    repo = GetU1Repo(tester)
    tester.testException(repo.createRawFile,('/test/cont/rf1','text/plain','boo'),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 write access")
    repo = GetU2Repo(tester)
    f = repo.createRawFile('/test/cont/f1','text/plain','foo')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner write access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.createRawFile,('/test/cont/rf1','text/plain','boo'),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()


    tester.startTest("Group Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.setAcl(AclConstants.WRITE_ACCESS,'test_group',AclConstants.ALLOWED)
    cont.addAcl(AclConstants.WRITE_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 write access")
    repo = GetU1Repo(tester)
    tester.testException(repo.createRawFile,('/test/cont/rf1','text/plain','boo'),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 write access")
    repo = GetU2Repo(tester)
    f = repo.createRawFile('/test/cont/f1','text/plain','foo')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner write access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.createRawFile,('/test/cont/rf1','text/plain','boo'),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()



    tester.groupDone()


def test_execute(tester):

    tester.startGroup("Execute Access")


    tester.startTest("Set Permissions")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    subcont = cont.createContainer('sub')
    subcont.setAcl(AclConstants.READ_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    cont.setAcl(AclConstants.READ_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    cont.setAcl(AclConstants.EXECUTE_ACCESS,'test1',AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()


    tester.startTest("SU execute access")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont/sub')
    repo.txRollback()
    tester.testDone()

    tester.startTest("test1 execute access")
    repo = GetU1Repo(tester)
    repo.fetchResource('/test/cont/sub')
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 execute access")
    repo = GetU2Repo(tester)
    tester.testException(repo.fetchResource,('/test/cont/sub',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner execute access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.addAcl(AclConstants.EXECUTE_ACCESS,
                AclConstants.OWNER,
                AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    repo.fetchResource('/test/cont/sub')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Deny Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.setAcl(AclConstants.EXECUTE_ACCESS,'test1',AclConstants.DENIED)
    cont.addAcl(AclConstants.EXECUTE_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    cont.addAcl(AclConstants.EXECUTE_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 execute access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource,('/test/cont/sub',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 execute access")
    repo = GetU2Repo(tester)
    repo.fetchResource('/test/cont/sub')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner execute access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource,('/test/cont/sub',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()


    tester.startTest("Group Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.setAcl(AclConstants.EXECUTE_ACCESS,'test_group',AclConstants.ALLOWED)
    cont.addAcl(AclConstants.EXECUTE_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 execute access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource,('/test/cont/sub',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 execute access")
    repo = GetU2Repo(tester)
    repo.fetchResource('/test/cont/sub')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner execute access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource,('/test/cont/sub',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.groupDone()



def test_delete(tester):

    tester.startGroup("Delete Access")


    tester.startTest("Set Permissions")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont').setAcl(AclConstants.WRITE_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.fetchResource('/test/cont').setAcl(AclConstants.READ_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.fetchResource('/test/cont').setAcl(AclConstants.EXECUTE_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.txCommit()
    repo = GetOwnerRepo(tester)
    cont = repo.fetchResource('/test/cont')
    for ctr in range(11):
        subcont = cont.createContainer('delete%d' % ctr)
        subcont.setAcl(AclConstants.DELETE_ACCESS,'test1',AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()


    tester.startTest("SU delete access")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont/delete1')
    repo.txRollback()
    tester.testDone()

    tester.startTest("test1 delete access")
    repo = GetU1Repo(tester)
    repo.fetchResource('/test/cont/delete2')
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 delete access")
    repo = GetU2Repo(tester)
    tester.testException(repo.deleteResource,('/test/cont/delete3',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner delete access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    cont.fetchResource('delete4').addAcl(AclConstants.DELETE_ACCESS,
                                         AclConstants.OWNER,
                                         AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    repo.deleteResource('/test/cont/delete4')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Deny Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    for ctr in [5,6,7]:
        sub = cont.fetchResource('delete%d'%ctr)
        sub.setAcl(AclConstants.DELETE_ACCESS,'test1',AclConstants.DENIED)
        sub.addAcl(AclConstants.DELETE_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
        sub.addAcl(AclConstants.DELETE_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 delete access")
    repo = GetU1Repo(tester)
    tester.testException(repo.deleteResource,('/test/cont/delete5',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 delete access")
    repo = GetU2Repo(tester)
    repo.deleteResource('/test/cont/delete6')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner delete access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.deleteResource,('/test/cont/delete7',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Group Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    for ctr in [8,9,10]:
        sub = cont.fetchResource('delete%d'%ctr)
        sub.setAcl(AclConstants.DELETE_ACCESS,'test_group',AclConstants.ALLOWED)
        sub.addAcl(AclConstants.DELETE_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 delete access")
    repo = GetU1Repo(tester)
    tester.testException(repo.deleteResource,('/test/cont/delete8',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 delete access")
    repo = GetU2Repo(tester)
    repo.deleteResource('/test/cont/delete9')
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner delete access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.deleteResource,('/test/cont/delete10',),FtServerServerException,{'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()


    tester.groupDone()


def test_change_owner(tester):

    tester.startGroup("Change Owner Access")


    tester.startTest("Set Permissions")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont').setAcl(AclConstants.WRITE_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.fetchResource('/test/cont').setAcl(AclConstants.READ_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.fetchResource('/test/cont').setAcl(AclConstants.EXECUTE_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    cont = repo.fetchResource('/test/cont')
    subcont = cont.createContainer('owner-test')
    subcont.setAcl(AclConstants.CHANGE_OWNER_ACCESS,'test1',AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()


    tester.startTest("SU change owner access")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont/owner-test').setOwner(repo.getCurrentUser())
    repo.txRollback()
    tester.testDone()

    tester.startTest("test1 change owner access")
    repo = GetU1Repo(tester)
    repo.fetchResource('/test/cont/owner-test').setOwner(repo.getCurrentUser())
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 change owner access")
    repo = GetU2Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/owner-test').setOwner,
                         (repo.getCurrentUser(),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner change owner access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/owner-test')
    cont.addAcl(AclConstants.CHANGE_OWNER_ACCESS,
                AclConstants.OWNER,
                AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    repo.fetchResource('/test/cont/owner-test').setOwner(repo.getCurrentUser())
    repo.txRollback()
    tester.testDone()


    tester.startTest("Deny Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/owner-test')
    cont.setAcl(AclConstants.CHANGE_OWNER_ACCESS,'test1',AclConstants.DENIED)
    cont.addAcl(AclConstants.CHANGE_OWNER_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    cont.addAcl(AclConstants.CHANGE_OWNER_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 change owner access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/owner-test').setOwner,
                         (repo.getCurrentUser(),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 change owner access")
    repo = GetU2Repo(tester)
    repo.fetchResource('/test/cont/owner-test').setOwner(repo.getCurrentUser())
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner change owner access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource('/test/cont/owner-test').setOwner,
                         (repo.getCurrentUser(),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})

    repo.txRollback()
    tester.testDone()

    tester.startTest("Group Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/owner-test')
    cont.setAcl(AclConstants.CHANGE_OWNER_ACCESS,'test_group',AclConstants.ALLOWED)
    cont.addAcl(AclConstants.CHANGE_OWNER_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 change owner access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/owner-test').setOwner,
                         (repo.getCurrentUser(),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 change owner access")
    repo = GetU2Repo(tester)
    repo.fetchResource('/test/cont/owner-test').setOwner(repo.getCurrentUser())
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner owner access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource('/test/cont/owner-test').setOwner,
                         (repo.getCurrentUser(),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})

    repo.txRollback()
    tester.testDone()


    tester.groupDone()



def test_change_permissions(tester):

    tester.startGroup("Change Permissions Access")


    tester.startTest("Set Permissions")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont').setAcl(AclConstants.WRITE_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.fetchResource('/test/cont').setAcl(AclConstants.READ_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.fetchResource('/test/cont').setAcl(AclConstants.EXECUTE_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    cont = repo.fetchResource('/test/cont')
    subcont = cont.createContainer('perm-test')
    subcont.setAcl(AclConstants.CHANGE_PERMISSIONS_ACCESS,'test1',AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()


    tester.startTest("SU change permissions access")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont/perm-test').setAcl('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txRollback()
    tester.testDone()

    tester.startTest("test1 change owner access")
    repo = GetU1Repo(tester)
    repo.fetchResource('/test/cont/perm-test').setAcl('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 change owner access")
    repo = GetU2Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/perm-test').setAcl,
                         ('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner change permissions access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/perm-test')
    cont.addAcl(AclConstants.CHANGE_PERMISSIONS_ACCESS,
                AclConstants.OWNER,
                AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    repo.fetchResource('/test/cont/perm-test').setAcl('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txRollback()
    tester.testDone()


    tester.startTest("Deny Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/perm-test')
    cont.setAcl(AclConstants.CHANGE_PERMISSIONS_ACCESS,'test1',AclConstants.DENIED)
    cont.addAcl(AclConstants.CHANGE_PERMISSIONS_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    cont.addAcl(AclConstants.CHANGE_PERMISSIONS_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 change permissions access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/perm-test').setAcl,
                         ('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})

    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 change permissions access")
    repo = GetU2Repo(tester)
    repo.fetchResource('/test/cont/perm-test').setAcl('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner change permissions access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource('/test/cont/perm-test').setAcl,
                         ('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Group Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/perm-test')
    cont.setAcl(AclConstants.CHANGE_PERMISSIONS_ACCESS,'test_group',AclConstants.ALLOWED)
    cont.addAcl(AclConstants.CHANGE_PERMISSIONS_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 change permissions access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/perm-test').setAcl,
                         ('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 change permissions access")
    repo = GetU2Repo(tester)
    repo.fetchResource('/test/cont/perm-test').setAcl('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner delete access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource('/test/cont/perm-test').setAcl,
                         ('foo',AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})

    repo.txRollback()
    tester.testDone()


    tester.groupDone()



def test_rdf(tester):

    tester.startGroup("User Model Access")


    tester.startTest("Set Permissions")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont').setAcl(AclConstants.WRITE_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.fetchResource('/test/cont').setAcl(AclConstants.READ_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.fetchResource('/test/cont').setAcl(AclConstants.EXECUTE_ACCESS,
                                            AclConstants.WORLD_GROUP_NAME,
                                            AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    cont = repo.fetchResource('/test/cont')
    subcont = cont.createContainer('rdf-test')
    subcont.setAcl(AclConstants.WRITE_USER_MODEL_ACCESS,'test1',AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()


    tester.startTest("SU user model access")
    repo = test_helper.GetRepo(tester)
    repo.fetchResource('/test/cont/rdf-test').getModel().add(Statement.Statement('a','b','c'))
    repo.txRollback()
    tester.testDone()

    tester.startTest("test1 user model access")
    repo = GetU1Repo(tester)
    repo.fetchResource('/test/cont/rdf-test').getModel().add(Statement.Statement('a','b','c'))
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 user model access")
    repo = GetU2Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/rdf-test').getModel().add,
                         (Statement.Statement('a','b','c'),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner user model access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/rdf-test')
    cont.addAcl(AclConstants.WRITE_USER_MODEL_ACCESS,
                AclConstants.OWNER,
                AclConstants.ALLOWED)
    repo.txCommit()

    repo = GetOwnerRepo(tester)
    repo.fetchResource('/test/cont/rdf-test').getModel().add(Statement.Statement('a','b','c'))
    repo.txRollback()
    tester.testDone()

    tester.startTest("Deny Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/rdf-test')
    cont.setAcl(AclConstants.WRITE_USER_MODEL_ACCESS,'test1',AclConstants.DENIED)
    cont.addAcl(AclConstants.WRITE_USER_MODEL_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    cont.addAcl(AclConstants.WRITE_USER_MODEL_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 user model access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/rdf-test').getModel().add,
                         (Statement.Statement('a','b','c'),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 user model access")
    repo = GetU2Repo(tester)
    repo.fetchResource('/test/cont/rdf-test').getModel().add(Statement.Statement('a','b','c'))
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner user model access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource('/test/cont/rdf-test').getModel().add,
                         (Statement.Statement('a','b','c'),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("Group Access")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont/rdf-test')
    cont.setAcl(AclConstants.WRITE_USER_MODEL_ACCESS,'test_group',AclConstants.ALLOWED)
    cont.addAcl(AclConstants.WRITE_USER_MODEL_ACCESS,AclConstants.OWNER,AclConstants.DENIED)
    repo.txCommit()
    tester.testDone()

    tester.startTest("test1 user model access")
    repo = GetU1Repo(tester)
    tester.testException(repo.fetchResource('/test/cont/rdf-test').getModel().add,
                         (Statement.Statement('a','b','c'),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()

    tester.startTest("test2 user model access")
    repo = GetU2Repo(tester)
    repo.fetchResource('/test/cont/rdf-test').getModel().add(Statement.Statement('a','b','c'))
    repo.txRollback()
    tester.testDone()

    tester.startTest("Owner user model access")
    repo = GetOwnerRepo(tester)
    tester.testException(repo.fetchResource('/test/cont/rdf-test').getModel().add,
                         (Statement.Statement('a','b','c'),),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})

    repo.txRollback()
    tester.testDone()


    tester.groupDone()



def test_create_group(tester):

    tester.startTest("Create Group")
    repo = test_helper.GetAnonRepo(tester)
    test = repo.fetchResource('test')
    tester.testException(test.createGroup,
                         ('test-groupII',),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()


def test_create_user(tester):

    tester.startTest("Create User")
    repo = test_helper.GetAnonRepo(tester)
    test = repo.fetchResource('test')
    tester.testException(test.createUser,
                         ('test-userI','test-userI'),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()
    tester.testDone()


def test_create_server(tester):

    src="""<ftss:Server xmlns:ftss="%s" xmlns:dc="%s" name='foo'>
  <dc:Description>This is a test server</dc:Description>
  <ftss:Port>8080</ftss:Port>
  <ftss:Handler>Ft.Server.Server.FtRpc.FtRpcHandler</ftss:Handler>
  <ftss:Status running='1'/>
</ftss:Server>
""" % (FTSERVER_NAMESPACE,Schema.DC)


    tester.startTest("Create Server")
    repo = GetU1Repo(tester)
    test = repo.fetchResource('test')
    tester.testException(test.createDocument,
                         ('server1',src),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()

    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('test')
    test.createDocument('server1',src)
    repo.txRollback()
    tester.testDone()



def test_verify(tester):

    tester.startTest("Verify ACL")


    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    subcont = cont.createContainer('verify-test')
    subcont.setAcl('foo','test1',AclConstants.ALLOWED)
    repo.txCommit()


    repo = test_helper.GetRepo(tester)
    res = repo.fetchResource('/test/cont/verify-test')
    res.verifyAcl('foo')
    repo.txRollback()

    repo = GetU1Repo(tester)
    res = repo.fetchResource('/test/cont/verify-test')
    res.verifyAcl('foo')
    repo.txRollback()

    repo = GetU2Repo(tester)
    res = repo.fetchResource('/test/cont/verify-test')
    tester.testException(res.verifyAcl,
                         ('foo',),
                         FtServerServerException,
                         {'code':Error.PERMISSION_DENIED})
    repo.txRollback()

    tester.testDone()


def test_inherit(tester):

    tester.startTest("Re-inherit ACL")


    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    subcont = cont.createContainer('inherit-test')
    subcont.setAcl(AclConstants.READ_ACCESS,'test1',AclConstants.ALLOWED)

    acl = subcont.getAcl(AclConstants.READ_ACCESS)
    tester.compare(1,acl.has_key('test1'))
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource('/test/cont')
    subcont = cont.fetchResource('inherit-test')
    subcont.inheritAcl(AclConstants.READ_ACCESS)
    acl = subcont.getAcl(AclConstants.READ_ACCESS)
    tester.compare(1,acl.has_key(AclConstants.WORLD_GROUP_NAME))
    repo.txRollback()
    tester.testDone()






def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()

    test = repo.createContainer("/test",1)
    test.setAcl(AclConstants.WRITE_ACCESS,AclConstants.WORLD_GROUP_NAME,AclConstants.ALLOWED)

    u1 = test.createUser('test1',sha.new('test1').hexdigest())

    u2 = test.createUser('test2',sha.new('test2').hexdigest())

    ow = test.createUser('o',sha.new('o').hexdigest())

    g = test.createGroup('test_group')
    g.addMember(u2)

    repo.txCommit()
    tester.testDone()


def Test(tester):

    cleanup(tester)


    test_read(tester)
    test_read_metadata(tester)
    test_write(tester)
    test_execute(tester)
    test_delete(tester)
    test_change_owner(tester)
    test_change_permissions(tester)
    test_rdf(tester)
    test_create_group(tester)
    test_create_user(tester)
    test_create_server(tester)
    test_verify(tester)
    test_inherit(tester)
    

