__revision__ = '$Id: __init__.py,v 1.14 2005/10/19 04:02:00 cogbuji Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)

    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = ['Helpers', 'test_bind', 'test_removeall', 'RdfHelper']
    RemoveTests(files, ignored_files)

    ordered_files = ['test_model', 'test_serializer', 'test_schemahandler']
    SortTests(files, ordered_files)

    ignored_dirs = ['use_case', 'Query']
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = ['Drivers', 'Inference', 'Core', 'Borrowed']
    SortTests(dirs, ordered_dirs)

    return (dirs, files)

CoverageModule = 'Ft.Rdf'

# -- run modes -------------------------------------------------------

from Ft.Lib.TestSuite import TestMode

class _MemoryMode(TestMode.TestMode):
    def __init__(self):
        TestMode.TestMode.__init__(self, 'Memory', 1)


    def _init(self, tester):
        return 1

    def _pre(self, tester):
        """
        By having a __call__, this becomes a transparent wrapper
        around the real function.
        """
        from Ft.Rdf.Drivers import Memory
        # The tester will remove entries in test_data after each test
        tester.test_data['driver'] = Memory
        return

    def _post(self, tester):
        tester.test_data['driver'] = None


class _DbmMode(TestMode.TestMode):

    def __init__(self):
        TestMode.TestMode.__init__(self, 'Dbm', 0)

    def _init(self, tester):
        from Ft.Rdf.Drivers import Dbm
        try:
            Dbm.InitializeModule()
        except Exception, error:
            tester.warning("Unable to use mode 'Dbm': %s" % ( str(error)))
            return 0
        return 1

    def _pre(self, tester):
        from Ft.Rdf.Drivers import Dbm
        tester.test_data['driver'] = Dbm
        return

    def _post(self, tester):
        tester.test_data['driver'] = None

class _PostgresMode(TestMode.TestMode):
    def __init__(self):
        TestMode.TestMode.__init__(self, 'Postgres', 0)

    def _init(self, tester):
        from Ft.Rdf.Drivers import Postgres
        try:
            Postgres.InitializeModule()
        except Exception, error:
            tester.warning("Unable to use mode 'Postgres': %s" % (str(error)))
            return 0
        return 1

    def _pre(self, tester):
        from Ft.Rdf.Drivers import Postgres
        tester.test_data['driver'] = Postgres
        return

    def _post(self, tester):
        tester.test_data['driver'] = None

class _MetaKitMode(TestMode.TestMode):
    def __init__(self):
        TestMode.TestMode.__init__(self, 'MetaKit', 0)

    def _init(self, tester):
        from Ft.Rdf.Drivers import MetaKit
        try:
            MetaKit.InitializeModule()
        except Exception, error:
            tester.warning("Unable to use mode 'MetaKit': %s" % (str(error)))
            return 0
        return 1

    def _pre(self, tester):
        from Ft.Rdf.Drivers import MetaKit
        tester.test_data['driver'] = MetaKit
        return

    def _post(self, tester):
        tester.test_data['driver'] = None


class _MySQLMode(TestMode.TestMode):
    def __init__(self):
        TestMode.TestMode.__init__(self, 'MySQL', 0)

    def _init(self, tester):
        from Ft.Rdf.Drivers import MySQL
        try:
            MySQL.InitializeModule()
        except Exception, error:
            tester.warning("Unable to use mode 'MySql': %s" % (str(error)))
            return 0
        return 1

    def _pre(self, tester):
        from Ft.Rdf.Drivers import MySQL
        tester.test_data['driver'] = MySQL
        return

    def _post(self, tester):
        tester.test_data['driver'] = None

class _BerkeleyDBMode(TestMode.TestMode):
    def __init__(self):
        TestMode.TestMode.__init__(self, 'BerkeleyDB', 0)

    def _init(self, tester):
        from Ft.Rdf.Drivers import BerkeleyDB
        try:
            BerkeleyDB.InitializeModule()
        except Exception, error:
            tester.warning("Unable to use mode 'BerkeleyDB': %s" % (str(error)))
            return 0
        return 1

    def _pre(self, tester):
        from Ft.Rdf.Drivers import BerkeleyDB
        tester.test_data['driver'] = BerkeleyDB
        return

    def _post(self, tester):
        tester.test_data['driver'] = None


class _RdflibMode(TestMode.TestMode):
    def __init__(self):
        TestMode.TestMode.__init__(self, 'Rdflib', 0)

    def _init(self, tester):
        from Ft.Rdf.Drivers import Rdflib
        try:
            Rdflib.InitializeModule()
        except Exception, error:
            tester.warning("Unable to use mode 'Rdflib': %s" % (str(error)))
            return 0
        return 1

    def _pre(self, tester):
        from Ft.Rdf.Drivers import Rdflib
        tester.test_data['driver'] = Rdflib
        return

    def _post(self, tester):
        tester.test_data['driver'] = None


MODES = [_MemoryMode(), _DbmMode(), _PostgresMode(), _MetaKitMode(), _MySQLMode(), _BerkeleyDBMode(),_RdflibMode()]
