import os

from Ft.Rdf.Parsers.Ril import RilParserImp
from Ft.Rdf.Inference import Assert, Action, Assert, Common, Command, Query, Rule

g_tests = [('test_action.ril',[Assert.SingleAssert,
                               Action.StatementSubject,
                               Action.StatementPredicate,
                               Action.StatementObject,
                               Assert.DualAssert,
                               Assert.DualAssert,
                               Assert.DualAssert,
                               Assert.DualAssert,
                               Assert.DualAssert,
                               Assert.DualAssert,
                               Assert.DualAssert,
                               Action.PathsAction,
                               Action.ReversePathsAction,
                               Action.IndexAction,
                               Action.ReverseAction,
                               Action.SliceAction,
                               Action.UniqueAction,
                               Action.IntersectionAction,
                               Action.UnionAction,
                               Action.CountAction,
                               Action.SumAction,
                               Action.AverageAction,
                               Action.SortAction,
                               Action.VariableSetAction,
                               Common.VariableReferenceArgument,
                               Action.ExternalParamAction,
                               Common.VariableReferenceArgument,
                               Action.ExternalParamAction,
                               Common.VariableReferenceArgument],
            ),
           ('test_assert.ril',[Assert.SingleAssert,
                               Assert.DualAssert]
            ),
           ('test_command.ril',[Command.MessageCommand,
                                Command.FireCommand,
                                Command.StopCommand]
            ),
           ('test_query.ril',[Assert.SingleAssert,
                              Assert.DualAssert,
                              Query.SingleQuery,
                              Query.SingleQuery,
                              Query.DualQuery,
                              Query.DualQuery,
                              Query.DualQuery,
                              Query.DualQuery,
                              Query.DualQuery]
            ),
           ('test_rule.ril',[Assert.SingleAssert,
                             Assert.SingleAssert,
                             Assert.SingleAssert,
                             Assert.SingleAssert,
                             Rule.Rule]
            ),
           ]



def TestFile(tester,fileName,expected):

    p = RilParserImp.RilParserImp()

    res = p.parse(open(fileName,'r').read())

    tester.compare(len(expected),len(res))

    for ctr in range(len(expected)):
        tester.compare(expected[ctr],res[ctr].__class__)
    

import test_parser
BASE_DIR = os.path.abspath(os.path.split(test_parser.__file__)[0])

def Test(tester):

    tester.startGroup('RIL Parser')

    for file,expected in g_tests:
        realFile = os.path.join(BASE_DIR,file)
        tester.startTest(file)
        TestFile(tester,realFile,expected)
        tester.testDone()
                 

    tester.groupDone()


if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)

