

#Test select * from students as s where s.name = "Mike"


#initDB
odl_string = '''
module Test {

class Student (extent students)
{
	attribute string name;
	attribute unsigned short student_id;
        attribute short age;
        attribute double weight;
	readonly attribute string ssn;
};

};

'''
#'

from Ft.Ods import Database
from Ft.Ods.Parsers.Odl import Processor

def init(dbName='test'):
    processor = Processor.Processor(dbName)
    processor.runString(odl_string)

    from Test import Student

    db = Database.Database()
    db.open('test')

    tx = db.new()
    tx.begin()

    s = Student.new()
    s.name = 'Mike'
    s.age = 25
    s.weight = 240
    s1 = Student.new()
    s1.name = 'Uche'
    s1.age = 29
    s1.weight = 190
    tx.commit()
    db.close()




queries = ['select * from students',
           'select * from students as s',
           'select * from students as s where s.name = "Mike"',
           'select * from students as s where s.name = "Mike" and s.age = 25',
           'select * from students as s where s.name = "Mike Olson" and s.age = 25'
           ]



def test():


    from Ft.Ods import Database
    db = Database.Database()
    db.open('test')

    tx = db.new()
    tx.begin()

    print db

    for q in queries:
        print "*"*10
        print q
        rt = db._4ods_query(q)
        print rt
        if len(rt):
            print rt[0]
            print rt[0].name
        print "*"*10

if __name__ == '__main__':


    import sys
    if len(sys.argv) > 1:
        import os
        os.system('4odb_destroy test')
        os.system('4odb_create test')
        init()

    test()
