import sys, os
p = os.path.join("..","..")
sys.path.append(p)
import profile_util

def do_fetch():
    repo = profile_util.GetRepo()
    repo.fetchResource('/profile/doc')
    repo.txRollback()


NUM_CHILDREN = 2500
XML_SRC = """<docelem><one>Foo</one>%s<two>Bar</two></docelem>""" % ("<child/>"*NUM_CHILDREN)

def do_profile():

    #Init
    repo = profile_util.GetRepo()
    if repo.hasResource('/profile'):
        repo.deleteResource('/profile')
    repo.createContainer('/profile',1)
    repo.createDocument('/profile/doc',XML_SRC)
    repo.txCommit()

    profile_util.run("do_fetch()",globals(),locals())




if __name__ == '__main__':
    profile_util.InitRepo()
    do_profile()
