<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fcore="http://xmlns.4suite.org/4ss/score" xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" xmlns:fhttp="http://xmlns.4suite.org/4ss/http" xmlns:exslt="http://exslt.org/common" xmlns:exslt-set="http://exslt.org/sets" xmlns:exslt-math="http://exslt.org/math" xmlns:exslt-functions="http://exslt.org/functions" xmlns:exslt-date-time="http://exslt.org/dates-and-times" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="&dc;" xmlns:fres="&fres;" xmlns:rdf="&rdf;" xmlns:f="&f;" extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
  <xsl:template name="command-manager">
    <xsl:variable name="basename" select="substring-after(substring-after($resourcePath,fcore:get-parent($resourcePath)),'/')"/>
    <!--
    <f:assign name="parentCommand" body-as-ns="yes">
      <frdf:complete p="&fschema;#command.subcommand" o=".*{$resourcePath}" o-flags="REGEX"/>
    </f:assign>-->
    <xsl:variable name="parentCommand" select="frdf:complete(frdf:any(),'&fschema;#command.subcommand',$basename)/Subject"/>
    <input type="hidden" name="action" value="changeCommand"/>
    <input type="hidden" name="aliasPath" value="{$resourcePath}"/>
    <table class="normal" cellpadding="0" cellspacing="5">
      <tr>
        <td colspan="3">
          <span class="blackTitle">Command Details</span>
        </td>
      </tr>
      <tr>
        <th class="grayBar">localName</th>
        <td colspan="2">
          <input name="localName" type="text" value="{/fres:Command/@name}" readonly="1"/>
        </td>
      </tr>
      <tr>
        <th class="grayBar">Verbose Description</th>
        <td colspan="2">
          <textarea cols="80" rows="3" name="description" readonly="1">
            <xsl:value-of select="/fres:Command/fres:VerboseDescription"/>
          </textarea>
        </td>
      </tr>
      <tr>
        <td/>
      </tr>
      <xsl:apply-templates select="/fres:Command/fres:Options"/>
      <xsl:if test="$parentCommand">
        <tr>
          <th align="left">Parent Command</th>
          <td colspan="2" align="left">
            <a href="{$parentCommand}">
              <xsl:value-of select="$parentCommand"/>
            </a>
          </td>
        </tr>
      </xsl:if>
      <xsl:apply-templates select="/fres:Command/fres:SubCommands"/>
      <tr>
        <td colspan="3" align="middle">
          <textarea COLS="120" ROWS="20" name="textAreaSrc">
            <xsl:value-of select="fcore:get-content($resourcePath)"/>
          </textarea>
        </td>
      </tr>
      <tr>
        <td colspan="3" align="middle">
          <input type="submit" value="Change {$resourcePath}"/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="fres:Options">
    <xsl:if test="fres:Option | fres:ExclusiveOption/fres:Option">
      <tr>
        <td colspan="3">
          <span class="blackTitle">Options</span>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <th aligh="left">short form</th>
      <th aligh="left">long form</th>
      <th aligh="left">description</th>
    </tr>
    <xsl:for-each select="fres:Option | fres:ExclusiveOption/fres:Option">
      <tr>
        <td>
          <xsl:if test="@short-name">-<xsl:value-of select="@short-name"/>
          </xsl:if>
        </td>
        <td>--<xsl:value-of select="@long-name"/>
        </td>
        <td>
          <xsl:value-of select="dc:Description"/>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="fres:SubCommands">
    <xsl:if test="fres:CommandReference">
      <tr>
        <td colspan="3">
          <span class="blackTitle">Sub Commands</span>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td colspan="3">
        <ul>
          <xsl:for-each select="fres:CommandReference">
            <li>
              <a href="{concat('/ftss/commands/',@xlink:href)}">
                <xsl:value-of select="@xlink:href"/>
              </a>
            </li>
          </xsl:for-each>
        </ul>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
