import RawFileClient
from Ft.Server.FtRpc import Commands

class XmlDocumentClient(RawFileClient.RawFileClient):
    """
    A specialized raw file resource, that is an XML document
    """

    def getDocumentDefinition(self):
        """
        Get the document definition associated with this document
        """
        path = Commands.RemoteMethodCommand('getDocumentDefinition',
                                            self._path,
                                            ()
                                            ).send(self._connection).results

        if path is not None:
            return self.fetchResource(path)
        return path

    def expandXLink(self):
        """
        Return the content of this resource with all XLinks expanded
        """
        return Commands.RemoteMethodCommand('expandXLink',
                                            self._path,
                                            ()
                                            ).send(self._connection).results
        
    def setDocumentDefinition(self,newDocDef):
        """
        Reset our document definition and regenerate our self
        """
        if newDocDef:
            newDocDef = (None,newDocDef.getAbsolutePath())
        Commands.RemoteMethodCommand('setDocumentDefinition',
                                      self._path,
                                      (newDocDef,)
                                     ).send(self._connection).results

