#!/usr/bin/env python
############################################################################
#  
#  Copyright (c)2000 Fourthought, Inc.
#  http://ftsuite.com/4ODS
#
############################################################################
#
# File Name: 		4odb clear.py
#
# Author:		Mike Olson
#
# Creation Date:	2000-06-10
#
# Documentation:	http://docs.ftsuite.com/4ODS/Tools/4odb_clear.py.html
#

#A Tool for clearing all data from an existing database.

import sys

__doc__ = 'Remove all existing data from a 4ODS database'


def Run(options,args):
    from Ft.Ods.StorageManager import Adapters

    dbName = args['dbName']
    mang = Adapters.GetManager(options.get('adapter')) 
    adapter = Adapters.GetAdapter(options.get('adapter')) 
    mang.clear(dbName)

def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('clear',
                          'Clear a 4ODS database',
                          ' test',                          
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('dbName',
                                                                  'The name of the database.',
                                                                  str),
                                       ],
                                                               
                          )
    return cmd
