########################################################################
#
# File Name: 	        OracleManagement.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Drivers/OracleManagement.py.html
#
"""
The Oracle Database Management functions
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import DCOracle

import string,os, sys

from Ft.Ods.StorageManager.Adapters import Sql
from Ft.Ods.StorageManager.Adapters import Util
from Ft.Ods.StorageManager.Adapters import Constants


class DbManager(Sql.DbManager):

    def connect(self,connectString):
        dbName,hostName,port,userName,passwd = Util.SplitDbConnectString(connectString)
        if dbName: oracleConnect = "%s/%s@%s" % (userName,passwd,dbName)
        else: oracleConnect = "%s/%s" % (userName,passwd)
        db = DCOracle.Connect(oracleConnect)
        return [db,db.cursor(),connectString]


    def create(self,connString,initRepo = 1):
        pass
        


    def exists(self,connString):
        # validate connection string
        try:
            db = self.connect(connString) # test connection
        except:
            (etype, value, tb) =sys.exc_info()
            if etype in (DCOracle.error, 'OracleError'): return 0
            else: raise etype, value, tb

        # check for ODS system tables
        tables =map(lambda x: string.lower(x[0]),
                    filter(lambda x: x[1] =='TABLE', db[0].objects()))
        db[0].close()
        for table_name in Sql.Manager.g_sortedTableNames:
            if table_name not in tables: return 0
        collection_map = self.collectionTableMapping
        for table_name,table_type in collection_map.values():
            if table_name not in tables: return 0
        # all ODS tables found.
        return 1

    def destroy(self,connString):
        dbTuple = self.connect(connString)
        db,cursor,st = dbTuple

        table_names = []
        try:
            cursor.execute("SELECT repoid from ftods_class")
            rt = cursor.fetchall()
            table_names = table_names + map(lambda x: "interface__%s" % x[0],rt)
        except DCOracle.ociUtil.error, e:
            sys.stderr.write("Unable to get generated tables!\n")

        try:
            cursor.execute("SELECT repoid from ftods_interface")
            rt = cursor.fetchall()
            table_names = table_names + map(lambda x: "interface__%s" % x[0],rt)
        except DCOracle.ociUtil.error, e:
            sys.stderr.write("Unable to get generated tables!\n")

        for table_name in table_names:
            try:
                db.execute('DROP TABLE %s' % table_name)
            except DCOracle.ociUtil.error, e:
                sys.stderr.write("Unable to drop table %s!\n" % table_name)
        

        for seq in self.sequences.keys():
            try:
                db.execute('DROP SEQUENCE %s' % seq)
            except DCOracle.ociUtil.error, e:
                sys.stderr.write("Unable to drop sequence %s\n" % seq)
        

        for table_name in Sql.Manager.g_sortedTableNames:
            try:
                db.execute('DROP TABLE %s' % table_name)
            except DCOracle.ociUtil.error, e:
                sys.stderr.write("Unable to drop table %s!\n" % table_name)

        doneTables = []
        for table_name,table_type in self.collectionTableMapping.values():
            if table_name in doneTables:
                continue
            doneTables.append(table_name)
            try:
                db.execute('DROP TABLE %s' % table_name)
            except DCOracle.ociUtil.error, e:
                sys.stderr.write("Unable to drop table %s!\n" % table_name)


    def close(self,conn):
        pass
        

    def _createSequence(self,db,name):
        if name == 'ftods_repoid':
            start = " START WITH 2"
        else:
            start = ""
        db[0].execute('CREATE SEQUENCE %s' % name  + start)

    def _resetSequence(self,db,name):
        raise "Finish"
        db.query("SELECT SETVAL('%s',1)" % name)
        


    def _createTable(self,db,table_name,initData,inherits):
        st = "CREATE TABLE %s (" % table_name
        st = st + self._tableInitString(table_name,initData,inherits) + ')'
        db[0].execute(st)

    def _dropTable(self,db,tableName):
        db[0].execute("DROP TABLE %s" % tableName)

    def _createIndex(self,db,index_name,columns,table_name):
        iString = 'CREATE INDEX %s  on %s (' % (index_name,table_name)
        for c in columns:
            if c == '_cid':
                newC = 'cid'
            elif c == 'index':
                newC = 'rindex'
            else:
                newC = c
            iString = iString + newC
            if c != columns[-1]:
                iString = iString + ','
        iString = iString + ')'
        db[0].execute(iString)


    def _getAllGeneratedTables(self,db):
        table_names = []

        db[1].execute('SELECT repoid,inherits,extender from ftods_class')
        rt = db[1].fetchall()

        allInterfaces = {}
        for rid,inherits,extender in rt:
            rid = int(rid)
            allInterfaces[rid] = []
            if inherits:
                db[1].execute('SELECT rvalue from ftods_long_collection where cid=%s'%inherits)
                res = db[1].fetchall()
                for r in res:
                    allInterfaces[rid].append(int(r[0]))
            if extender and int(extender):
                allInterfaces[rid].append(int(extender))


        db[1].execute('SELECT repoid,inherits from ftods_interface')
        rt = db[1].fetchall()

        for rid,inherits in rt:
            rid = int(rid)
            allInterfaces[rid] = []
            if inherits:
                db[1].execute('SELECT rvalue from ftods_long_collection where cid=%s'%inherits)
                res = db[1].fetchall()
                for r in res:
                    allInterfaces[rid].append(int(r[0]))

        tables = []
        for rid,derived in allInterfaces.items():
            curIndex = len(tables)
            for d in derived:
                if d in tables:
                    curIndex = tables.index(d)
            tables.insert(curIndex,rid)

        return map(lambda x:'interface__%s'%x,tables)


    def _deleteTable(self,db,tableName):
        db[0].execute("DELETE from %s" % tableName)

    def _getAllExtentNames(self,db):
        db[1].execute('SELECT name,extentid from ftods_extents')
        return db[1].fetchall()

    def _deleteExtent(self,db,id):
        db[0].execute("DELETE from ftods_extentmapping where extentid = '%s'"%id)
        db[0].execute("DELETE from ftods_extents where extentid = '%s'"%id)

    def _dropAllBindings(self,db):
        db[0].execute("DELETE from ftods_binding")


    def _deleteAllBlobs(self,db):
        db[1].execute("SELECT fileName from ftods_blobs")
        rt = db[1].fetchall()
        for fileName in rt:
            os.unlink(fileName[0])
        db[0].execute("DELETE from ftods_blobs")
        



    def _4ods_interfaceTableInitString(self,data):
        tableName,defs,bClasses = data
        st = ""
        for b in bClasses:
            st = st + self._4ods_interfaceTableInitString(b)

        for (rid,type_,other) in defs:
            if rid != 'oid':
                rid = 'def__%i' % rid
            st = st + rid + ' ' + type_ + ' ' + other
            st = st + ','


        return st


    #Repository Object Helpers
    def _createInterfaceStorage(self,db,data):
        tableName,defs,bClasses = data
        qstr = 'CREATE TABLE %s ( ' % tableName
        qstr = qstr + self._4ods_interfaceTableInitString(data)
        qstr = qstr [:-1] + ')'
        try:
            db[0].execute(qstr)
        except:
            print qstr
            raise

    odmgToSqlTypes = {
        # in Postgres adapter, IDs are 64-bit integers representable by 20 digits
        # short is int4 (32 bits, at most 10 digits)
        Constants.Types.BOOLEAN: 'NUMBER(1,0)',
        #Constants.Types.BOOLEAN_BAG: 'NUMBER(20,0)',
        #Constants.Types.BOOLEAN_SET: 'NUMBER(20,0)',
        #Constants.Types.BOOLEAN_LIST: 'NUMBER(20,0)',
        Constants.Types.SIGNED_SHORT: 'NUMBER(15,0)',
        #Constants.Types.SIGNED_SHORT_BAG: 'NUMBER(20,0)',
        #Constants.Types.SIGNED_SHORT_LIST: 'NUMBER(20,0)',
        #Constants.Types.SIGNED_SHORT_SET: 'NUMBER(20,0)',
        Constants.Types.STRING: 'VARCHAR(2048)',
        #Constants.Types.STRING_BAG: 'NUMBER(20,0)',
        #Constants.Types.STRING_SET: 'NUMBER(20,0)',
        #Constants.Types.STRING_LIST: 'NUMBER(20,0)',
        Constants.Types.UNSIGNED_SHORT: 'NUMBER(10,0)',
        #Constants.Types.UNSIGNED_SHORT_BAG: 'NUMBER(20,0)',
        #Constants.Types.UNSIGNED_SHORT_SET: 'NUMBER(20,0)',
        #Constants.Types.UNSIGNED_SHORT_LIST: 'NUMBER(20,0)',
        Constants.Types.SIGNED_LONG: 'NUMBER(20,0)',
        #Constants.Types.SIGNED_LONG_BAG: 'NUMBER(20,0)',
        #Constants.Types.SIGNED_LONG_SET: 'NUMBER(20,0)',
        #Constants.Types.SIGNED_LONG_LIST: 'NUMBER(20,0)',
        Constants.Types.UNSIGNED_LONG: 'NUMBER(20,0)',
        #Constants.Types.UNSIGNED_LONG_BAG: 'NUMBER(20,0)',
        #Constants.Types.UNSIGNED_LONG_SET: 'NUMBER(20,0)',
        #Constants.Types.UNSIGNED_LONG_LIST: 'NUMBER(20,0)',
        # XXX long longs (128 bits) can not be stored in Oracle NUMBER column
        #     because number precision is limited with 38 digits (up to 126 bit ints).
        Constants.Types.SIGNED_LONG_LONG: 'VARCHAR(40)',
        #Constants.Types.SIGNED_LONG_LONG_BAG: 'NUMBER(20,0)',
        #Constants.Types.SIGNED_LONG_LONG_SET: 'NUMBER(20,0)',
        #Constants.Types.SIGNED_LONG_LONG_LIST: 'NUMBER(20,0)',
        # Postgres adapter uses float4 (up to 6 digits) for float
        # XXX Constants.Types.FLOAT: 'NUMBER(12,6)',
        Constants.Types.FLOAT: 'NUMBER(15,7)',
        #Constants.Types.FLOAT_BAG: 'NUMBER(20,0)',
        #Constants.Types.FLOAT_SET: 'NUMBER(20,0)',
        #Constants.Types.FLOAT_LIST: 'NUMBER(20,0)',
        # Postgres adapter uses float8 (up to 18 digits) for double
        # XXX Constants.Types.DOUBLE: 'NUMBER(36,18)',
        Constants.Types.DOUBLE: 'NUMBER(30,15)',
        #Constants.Types.DOUBLE_BAG: 'NUMBER(20,0)',
        #Constants.Types.DOUBLE_SET: 'NUMBER(20,0)',
        #Constants.Types.DOUBLE_LIST: 'NUMBER(20,0)',
        Constants.Types.ROBJECT: 'NUMBER(20,0)',
        Constants.Types.POBJECT: 'NUMBER(20,0)',
        #Constants.Types.OBJECT_BAG: 'NUMBER(20,0)',
        #Constants.Types.OBJECT_SET: 'NUMBER(20,0)',
        #Constants.Types.OBJECT_LIST: 'NUMBER(20,0)',
        Constants.Types.ENUMERATION: 'NUMBER(15,0)',
        Constants.Types.STRUCTURE: 'NUMBER(20,0)',
        Constants.Types.UNION:'NUMBER(20,0)',
        Constants.Types.BLOB:'NUMBER(20,0)',

        Constants.Types.CHAR : 'VARCHAR(1)',   # postgres CHAR
        Constants.Types.OCTET : 'NUMBER(2,0)', # postgres INT2

        Constants.Types.DATE : 'VARCHAR(2048)', # postgres TEXT
        Constants.Types.TIME : 'VARCHAR(2048)', # postgres TEXT
        Constants.Types.INTERVAL : 'VARCHAR(2048)', # postgres TEXT
        Constants.Types.TIMESTAMP: 'VARCHAR(2048)', # postgres TEXT

        Constants.Types.SET_COLLECTION : 'NUMBER(20,0)',
        Constants.Types.LIST_COLLECTION : 'NUMBER(20,0)',
        Constants.Types.BAG_COLLECTION : 'NUMBER(20,0)',
        Constants.Types.DICTIONARY_COLLECTION : 'NUMBER(20,0)',
        }


    systemTypesToSql = {Sql.DbManager.SystemTypes.NAME:"VARCHAR(128)",
                        Sql.DbManager.SystemTypes.OBJECT:odmgToSqlTypes[Constants.Types.ROBJECT],
                        Sql.DbManager.SystemTypes.ENUMERATION:odmgToSqlTypes[Constants.Types.ENUMERATION],
                        Sql.DbManager.SystemTypes.STRING:odmgToSqlTypes[Constants.Types.STRING],
                        Sql.DbManager.SystemTypes.BOOLEAN:odmgToSqlTypes[Constants.Types.BOOLEAN],
                        Sql.DbManager.SystemTypes.SHORT:odmgToSqlTypes[Constants.Types.UNSIGNED_SHORT],
                        Sql.DbManager.SystemTypes.STRING:odmgToSqlTypes[Constants.Types.STRING],
                        Sql.DbManager.SystemTypes.DOUBLE:odmgToSqlTypes[Constants.Types.DOUBLE],
                        Sql.DbManager.SystemTypes.TIMESTAMP:odmgToSqlTypes[Constants.Types.DOUBLE],
                        Sql.DbManager.SystemTypes.ANY:odmgToSqlTypes[Constants.Types.STRING],
                        }



    tables = Sql.DbManager.tables.copy()

    tables['ftods_actualclass']={Sql.DbManager.TableData.TABLE_INIT:[('oid',Sql.DbManager.SystemTypes.OBJECT,'PRIMARY KEY'),
                                                                     ('pythonclassid',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                     ('lastUpdate',Sql.DbManager.SystemTypes.TIMESTAMP,''),
                                                                     ],
                                 Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.OBJECT_ACCESS,
                                 Sql.DbManager.TableData.TABLE_INHERITS:[]
                                 }
    tables['ftods_collectionclass']={Sql.DbManager.TableData.TABLE_INIT:[('cid',Sql.DbManager.SystemTypes.OBJECT,'PRIMARY KEY'),
                                                                         ('pythonclassid',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                         ('subtype',Sql.DbManager.SystemTypes.ENUMERATION,''),
                                                                         ('lastUpdate',Sql.DbManager.SystemTypes.TIMESTAMP,''),
                                                                         ],
                                     Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.OBJECT_ACCESS,
                                     Sql.DbManager.TableData.TABLE_INHERITS:[]
                                     }
    tables['ftods_object']={Sql.DbManager.TableData.TABLE_INIT:[('oid',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                ],
                            Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.OBJECT_ACCESS,
                            Sql.DbManager.TableData.TABLE_INHERITS:[]
                        }
    tables['ftods_collection']={Sql.DbManager.TableData.TABLE_INIT:[('cid',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                    ],
                                Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.SYSTEM_ACCESS,
                                Sql.DbManager.TableData.TABLE_INHERITS:[]
                                }

    tables['ftods_literal']={Sql.DbManager.TableData.TABLE_INIT:[('lid',Sql.DbManager.SystemTypes.OBJECT,'PRIMARY KEY'),
                                                                 ],
                             Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.OBJECT_ACCESS,
                             Sql.DbManager.TableData.TABLE_INHERITS:[]
                             }
    tables['ftods_repositoryobject']={Sql.DbManager.TableData.TABLE_INIT:[('repoid',Sql.DbManager.SystemTypes.OBJECT,'PRIMARY KEY'),
                                                                          ('meta_kind',Sql.DbManager.SystemTypes.ENUMERATION,''),
                                                                          ],
                                      Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.METADATA_ACCESS,
                                      Sql.DbManager.TableData.TABLE_INHERITS:[]
                                      }
    tables['ftods_metaobject']={Sql.DbManager.TableData.TABLE_INIT:[('rname',Sql.DbManager.SystemTypes.STRING,''),
                                                                    ('rcomment',Sql.DbManager.SystemTypes.STRING,''),
                                                                    ('definedIn',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                    ],
                                Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.METADATA_ACCESS,
                                Sql.DbManager.TableData.TABLE_INHERITS:["ftods_repositoryobject"]
                                }

    tables['ftods_specifier'] = {Sql.DbManager.TableData.TABLE_INIT:[('rname',Sql.DbManager.SystemTypes.STRING,''),
                                                                     ('rtype',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                     ],
                                 Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.METADATA_ACCESS,
                                 Sql.DbManager.TableData.TABLE_INHERITS:["ftods_repositoryobject"]
                                 }


    tables['ftods_constant']={Sql.DbManager.TableData.TABLE_INIT:[('the_value',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                  ('rtype',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                  ('referenced_by',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                  ('enumeration',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                  ],
                              Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.METADATA_ACCESS,
                              Sql.DbManager.TableData.TABLE_INHERITS:["ftods_metaobject"]
                          }

    tables['ftods_property']={Sql.DbManager.TableData.TABLE_INIT:[('rtype',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                  ],
                              Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.METADATA_ACCESS,
                              Sql.DbManager.TableData.TABLE_INHERITS:["ftods_metaobject"]
                         }

    tables['ftods_const_operand']={Sql.DbManager.TableData.TABLE_INIT:[('references',Sql.DbManager.SystemTypes.OBJECT,''),
                                                                       ],
                                   Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.METADATA_ACCESS,
                                   Sql.DbManager.TableData.TABLE_INHERITS:["ftods_operand"]
                                   }


    tables['ftods_blobs'] = {Sql.DbManager.TableData.TABLE_INIT:[('bid',Sql.DbManager.SystemTypes.OBJECT,'PRIMARY KEY'),
                                                                 ('filename',Sql.DbManager.SystemTypes.STRING,''),
                                                                 ],
                              Sql.DbManager.TableData.TABLE_ACCESS:Sql.DbManager.AccessTypes.OBJECT_ACCESS,
                              Sql.DbManager.TableData.TABLE_INHERITS:[]
                              }
    Sql.SManager.g_sortedTableNames.append('ftods_blobs')


    collectionTableData = [('rindex',Sql.DbManager.SystemTypes.SHORT,''),
                           ['rvalue',"PLACE HOLDER",''],
                           ]

    sequences = Sql.DbManager.sequences.copy()
    sequences['ftods_blobId'] = Sql.DbManager.AccessTypes.SYSTEM_ACCESS
